# Copyright (c) 2016, Patrick Uiterwijk <patrick@puiterwijk.org>,
#           (c) 2019, Lars Wilhelmsen <lars@sral.org>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# * Redistributions of source code must retain the above copyright notice, this
#   list of conditions and the following disclaimer.
#
# * Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import httplib2

from flask_oidc_keycloak import _json_loads


# OpenID Connect Discovery 1.0
def discover_OP_information(OP_uri, httpFactory=None):
    """
    Discovers information about the provided OpenID Provider.

    :param OP_uri: The base URI of the Provider information is requested for.
    :type OP_uri: str
    :returns: The contents of the Provider metadata document.
    :rtype: dict

    .. versionadded:: 1.0
    """
    http = None
    if httpFactory is not None and callable(httpFactory):
        http = httpFactory()
    else:
        http = httplib2.Http()

    _, content = http.request(
        '%s/.well-known/openid-configuration' % OP_uri)
    return _json_loads(content)
