# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['gvsbuild', 'gvsbuild.projects', 'gvsbuild.utils']

package_data = \
{'': ['*'],
 'gvsbuild': ['patches/*',
              'patches/adwaita-icon-theme/Adwaita/64x64/ui/*',
              'patches/adwaita-icon-theme/Adwaita/96x96/ui/*',
              'patches/check-libs/*',
              'patches/clutter/build/win32/vs12/*',
              'patches/clutter/build/win32/vs14/*',
              'patches/clutter/build/win32/vs15/*',
              'patches/cogl/*',
              'patches/cogl/GL/*',
              'patches/cogl/build/win32/vs12/*',
              'patches/cogl/build/win32/vs14/*',
              'patches/cogl/build/win32/vs15/*',
              'patches/cyrus-sasl/*',
              'patches/cyrus-sasl/include/*',
              'patches/cyrus-sasl/pc-files/*',
              'patches/enchant/src/*',
              'patches/ffmpeg/*',
              'patches/ffmpeg/build/*',
              'patches/freetype/*',
              'patches/gettext/*',
              'patches/gettext/msvc/gettext-runtime/gnulib-lib/*',
              'patches/gettext/msvc/gettext-runtime/gnulib-lib/sys/*',
              'patches/gettext/msvc/gettext-runtime/intl/*',
              'patches/gettext/msvc/gettext-runtime/libasprintf/*',
              'patches/gettext/msvc/gettext-tools/gnulib-lib/*',
              'patches/gettext/msvc/gettext-tools/gnulib-lib/libxml/*',
              'patches/gettext/msvc/gettext-tools/gnulib-lib/sys/*',
              'patches/gettext/msvc/gettext-tools/gnulib-tests/*',
              'patches/gettext/msvc/gettext-tools/gnulib-tests/arpa/*',
              'patches/gettext/msvc/gettext-tools/gnulib-tests/netinet/*',
              'patches/gettext/msvc/gettext-tools/gnulib-tests/sys/*',
              'patches/gettext/msvc/gettext-tools/libgettextpo/*',
              'patches/gettext/msvc/gettext-tools/libgettextpo/sys/*',
              'patches/gettext/msvc/gettext-tools/libgrep/*',
              'patches/gettext/msvc/gettext-tools/src/*',
              'patches/gettext/msvc/gettext-tools/src/textstyle/*',
              'patches/gettext/msvc/libtextstyle/lib/*',
              'patches/gettext/msvc/libtextstyle/lib/glib/*',
              'patches/gettext/msvc/libtextstyle/lib/libxml/*',
              'patches/gettext/msvc/libtextstyle/lib/sys/*',
              'patches/gettext/msvc/libtextstyle/lib/textstyle/*',
              'patches/gettext/msvc/vs12/Win32/gettext-runtime/*',
              'patches/gettext/msvc/vs12/Win32/gettext-runtime/gnulib-lib/*',
              'patches/gettext/msvc/vs12/Win32/gettext-tools/*',
              'patches/gettext/msvc/vs12/Win32/gettext-tools/gnulib-lib/*',
              'patches/gettext/msvc/vs12/Win32/gettext-tools/libgettextpo/*',
              'patches/gettext/msvc/vs12/Win32/libtextstyle/*',
              'patches/gettext/msvc/vs12/Win32/libtextstyle/lib/*',
              'patches/gettext/msvc/vs12/x64/gettext-runtime/*',
              'patches/gettext/msvc/vs12/x64/gettext-runtime/gnulib-lib/*',
              'patches/gettext/msvc/vs12/x64/gettext-tools/*',
              'patches/gettext/msvc/vs12/x64/gettext-tools/gnulib-lib/*',
              'patches/gettext/msvc/vs12/x64/gettext-tools/libgettextpo/*',
              'patches/gettext/msvc/vs12/x64/libtextstyle/*',
              'patches/gettext/msvc/vs12/x64/libtextstyle/lib/*',
              'patches/gettext/msvc/vs14/Win32/gettext-runtime/*',
              'patches/gettext/msvc/vs14/Win32/gettext-runtime/gnulib-lib/*',
              'patches/gettext/msvc/vs14/Win32/gettext-tools/*',
              'patches/gettext/msvc/vs14/Win32/gettext-tools/gnulib-lib/*',
              'patches/gettext/msvc/vs14/Win32/gettext-tools/libgettextpo/*',
              'patches/gettext/msvc/vs14/Win32/libtextstyle/*',
              'patches/gettext/msvc/vs14/Win32/libtextstyle/lib/*',
              'patches/gettext/msvc/vs14/arm64/gettext-runtime/*',
              'patches/gettext/msvc/vs14/arm64/gettext-runtime/gnulib-lib/*',
              'patches/gettext/msvc/vs14/arm64/gettext-tools/*',
              'patches/gettext/msvc/vs14/arm64/gettext-tools/gnulib-lib/*',
              'patches/gettext/msvc/vs14/arm64/gettext-tools/libgettextpo/*',
              'patches/gettext/msvc/vs14/arm64/libtextstyle/*',
              'patches/gettext/msvc/vs14/arm64/libtextstyle/lib/*',
              'patches/gettext/msvc/vs14/x64/gettext-runtime/*',
              'patches/gettext/msvc/vs14/x64/gettext-runtime/gnulib-lib/*',
              'patches/gettext/msvc/vs14/x64/gettext-tools/*',
              'patches/gettext/msvc/vs14/x64/gettext-tools/gnulib-lib/*',
              'patches/gettext/msvc/vs14/x64/gettext-tools/libgettextpo/*',
              'patches/gettext/msvc/vs14/x64/libtextstyle/*',
              'patches/gettext/msvc/vs14/x64/libtextstyle/lib/*',
              'patches/gettext/nmake/*',
              'patches/glib-py-wrapper/*',
              'patches/glib/*',
              'patches/gobject-introspection/*',
              'patches/gsettings-desktop-schemas/*',
              'patches/gst-plugins-bad/*',
              'patches/gtk2/*',
              'patches/gtk2/build/win32/*',
              'patches/gtk2/build/win32/vs12/*',
              'patches/gtk2/build/win32/vs14/*',
              'patches/gtk2/build/win32/vs15/*',
              'patches/gtk3/*',
              'patches/gtk3/gdk/win32/*',
              'patches/hello-world/*',
              'patches/icu/pc-files-debug/*',
              'patches/icu/pc-files/*',
              'patches/leveldb/build/win32/vs12/*',
              'patches/leveldb/build/win32/vs12/leveldb_test/*',
              'patches/leveldb/build/win32/vs14/*',
              'patches/leveldb/build/win32/vs14/leveldb_test/*',
              'patches/leveldb/build/win32/vs15/*',
              'patches/leveldb/build/win32/vs15/leveldb_test/*',
              'patches/leveldb/port/*',
              'patches/leveldb/port/win/*',
              'patches/leveldb/util/*',
              'patches/libcroco/*',
              'patches/libcroco/win32/vs10/*',
              'patches/libcroco/win32/vs12/*',
              'patches/libcroco/win32/vs14/*',
              'patches/libcroco/win32/vs15/*',
              'patches/libmicrohttpd/*',
              'patches/libpng/*',
              'patches/libpng/pc-files/*',
              'patches/libpsl/*',
              'patches/librsvg-legacy/*',
              'patches/librsvg-legacy/build/win32/vs12/*',
              'patches/librsvg-legacy/build/win32/vs14/*',
              'patches/librsvg-legacy/build/win32/vs15/*',
              'patches/libsoup3/*',
              'patches/libssh/*',
              'patches/libssh/build/vs12/*',
              'patches/libssh/build/vs14/*',
              'patches/libssh/build/vs15/*',
              'patches/libtiff-4/*',
              'patches/libvpx/*',
              'patches/libxml2/*',
              'patches/libxml2/include/libxml/*',
              'patches/libxml2/pc-files/*',
              'patches/libyuv/*',
              'patches/libyuv/pc-files/*',
              'patches/luajit/*',
              'patches/luajit/pc-files/*',
              'patches/lz4/pc-files/*',
              'patches/lz4/visual/VS2013/*',
              'patches/lz4/visual/VS2013/datagen/*',
              'patches/lz4/visual/VS2013/frametest/*',
              'patches/lz4/visual/VS2013/fullbench-dll/*',
              'patches/lz4/visual/VS2013/fullbench/*',
              'patches/lz4/visual/VS2013/fuzzer/*',
              'patches/lz4/visual/VS2013/liblz4-dll/*',
              'patches/lz4/visual/VS2013/liblz4/*',
              'patches/lz4/visual/VS2013/lz4/*',
              'patches/lz4/visual/VS2015/*',
              'patches/lz4/visual/VS2015/datagen/*',
              'patches/lz4/visual/VS2015/frametest/*',
              'patches/lz4/visual/VS2015/fullbench-dll/*',
              'patches/lz4/visual/VS2015/fullbench/*',
              'patches/lz4/visual/VS2015/fuzzer/*',
              'patches/lz4/visual/VS2015/liblz4-dll/*',
              'patches/lz4/visual/VS2015/liblz4/*',
              'patches/lz4/visual/VS2015/lz4/*',
              'patches/lz4/visual/VS2017/*',
              'patches/lz4/visual/VS2017/datagen/*',
              'patches/lz4/visual/VS2017/frametest/*',
              'patches/lz4/visual/VS2017/fullbench-dll/*',
              'patches/lz4/visual/VS2017/fullbench/*',
              'patches/lz4/visual/VS2017/fuzzer/*',
              'patches/lz4/visual/VS2017/liblz4-dll/*',
              'patches/lz4/visual/VS2017/liblz4/*',
              'patches/lz4/visual/VS2017/lz4/*',
              'patches/lz4/visual/VS2022/*',
              'patches/lz4/visual/VS2022/datagen/*',
              'patches/lz4/visual/VS2022/frametest/*',
              'patches/lz4/visual/VS2022/fullbench-dll/*',
              'patches/lz4/visual/VS2022/fullbench/*',
              'patches/lz4/visual/VS2022/fuzzer/*',
              'patches/lz4/visual/VS2022/liblz4-dll/*',
              'patches/lz4/visual/VS2022/liblz4/*',
              'patches/lz4/visual/VS2022/lz4/*',
              'patches/nghttp2/*',
              'patches/openssl/*',
              'patches/openssl/pc-files/*',
              'patches/pcre2/*',
              'patches/pkgconf/*',
              'patches/protobuf-c/*',
              'patches/protobuf-c/pc-files/*',
              'patches/pygobject/*',
              'patches/win-iconv/*',
              'patches/x264/build/*',
              'patches/zlib/pc-files/*']}

install_requires = \
['build>=0.9,<0.11', 'typer[all]>=0.6.1,<0.8.0']

extras_require = \
{'outdated': ['lastversion>=2.4.2,<3.0.0', 'packaging>=21.3,<24.0']}

entry_points = \
{'console_scripts': ['gvsbuild = gvsbuild.main:run']}

setup_kwargs = {
    'name': 'gvsbuild',
    'version': '2023.3.0',
    'description': 'GTK stack for Windows',
    'long_description': '# gvsbuild\n\n![CI](https://github.com/wingtk/gvsbuild/workflows/CI/badge.svg)\n\nThis python script helps you build a full [GTK](https://www.gtk.org/) library\nstack for Windows using Visual Studio. Currently, GTK 3 and GTK 4 are supported.\n\nThe script supports multiple versions of Visual Studio - at the moment we are\nfocusing on VS 2022, but we include projects for other versions, and we gladly\naccept patches.\n\nThe script focuses on GTK and the surrounding ecosystem (e.g. GStreamer).\nHowever, we are open to adding more libraries as long as the contributor takes\non the responsibility for keeping it up to date. The supported projects are\nmodules in the\n[projects](https://github.com/wingtk/gvsbuild/blob/master/gvsbuild/projects)\ndirectory.\n\nThe script requires a working installation of [Visual Studio for Windows\nDesktop](http://www.visualstudio.com), [Python 3](https://www.python.org) and\n[msys2](https://msys2.github.io). The script will download any additional tools\nrequired to build the libraries and will use them from a local directory,\nwithout any installation. As of today these tools include cmake, meson, ninja,\nnuget and perl.\n\nThe script fetches source tarballs for the projects from their original\nlocations, however in some cases it might be necessary to host a patched tarball\non GitHub. To ensure integrity of the downloaded files, the script checks the\nSHA256 hash of each download. Downloads are done using TLS, using SSL\ncertificates provided by the system, but in case of error the download is tried\nagain ignoring certificate errors.\n\n## Development Environment\n\n### Choco\nWe recommend using [Chocolately](https://chocolatey.org/) as a package manager\nin Windows.\n\nTo install it, open PowerShell as an administrator, then execute:\n\n```PowerShell\nSet-ExecutionPolicy Bypass -Scope Process -Force; iex ((New-Object System.Net.WebClient).DownloadString(\'https://community.chocolatey.org/install.ps1\'))\n```\nTo run local scripts in follow-on steps, also execute\n`Set-ExecutionPolicy RemoteSigned`. This allows for local PowerShell scripts\nto run without signing, but still requires signing for remote scripts.\n\n### Git\nTo setup a development environment in Windows install\n[Git](https://gitforwindows.org) by executing as an administrator:\n\n```PowerShell\nchoco install git\n```\n\n### MSYS2\nBoth of the development environments in the next steps need MSYS2 installed.\n\nInstall [MSYS2](http://www.msys2.org/):\n\nKeep PowerShell open as administrator and execute:\n```PowerShell\nchoco install msys2\n```\n\n### Building GTK\n\nFirst we will install the gvsbuild dependencies:\n1. Visual C++ build tools workload for Visual Studio 2022 Build Tools\n2. Python\n\n#### Install Visual Studio 2022\nWith your admin PowerShell terminal:\n\n```PowerShell\nchoco install visualstudio2022-workload-vctools\n```\n\nNote: Visual Studio versions 2013 (not for all projects), 2015, 2017, 2019, and 2022 are currently supported.\n\n#### Install the Latest Python\n\nDownload and install the latest version of Python:\n\n1. Install from Chocolately with `choco install python` with admin PowerShell\n1. Restart your PowerShell terminal as a normal user and check that `python --version` is correct.\n\nNote: If you are going to install Python using an alternative means, like the\nofficial Windows installers, we suggest to install Python in C:\\Python3x, for\nexample C:\\Python310. Other Python distributions like [Miniconda\n3](https://repo.continuum.io/miniconda/Miniconda3-latest-Windows-x86_64.exe)\nshould also work.\n\n#### Install gvsbuild\nThe recommended way to install gvsbuild is with pipx. Open a new regular user\nPowerShell terminal and execute:\n\n```PowerShell\npython -m pip install --user pipx\npython -m pipx ensurepath\npipx install gvsbuild\n```\n\nAlternatively, you can also use git to clone the repository and install it.\nOpen a new regular user PowerShell terminal and execute:\n\n```PowerShell\nmkdir C:\\gtk-build\\github\ncd C:\\gtk-build\\github\ngit clone https://github.com/wingtk/gvsbuild.git\ncd C:\\gtk-build\\github\\gvsbuild\npython -m venv .venv\n.\\.venv\\Scripts\\activate.ps1\npip install .\n```\n\n#### Build GTK\n\nIn the same PowerShell terminal, execute:\n\n```PowerShell\ngvsbuild build gtk3\n```\n\nAlternatively, if you want to build GTK 4, execute:\n```PowerShell\ngvsbuild build gtk4\n```\n\nGrab a coffee, the build will take a few minutes to complete.\n\n#### Add GTK to Your Environmental Variables\n\n```PowerShell\n$env:Path = "C:\\gtk-build\\gtk\\x64\\release\\bin;" + $env:Path\n$env:LIB = "C:\\gtk-build\\gtk\\x64\\release\\lib;" + $env:LIB\n$env:INCLUDE = "C:\\gtk-build\\gtk\\x64\\release\\include;C:\\gtk-build\\gtk\\x64\\release\\include\\cairo;C:\\gtk-build\\gtk\\x64\\release\\include\\glib-2.0;C:\\gtk-build\\gtk\\x64\\release\\include\\gobject-introspection-1.0;C:\\gtk-build\\gtk\\x64\\release\\lib\\glib-2.0\\include;" + $env:INCLUDE\n```\n\n#### Use PyGObject\n\nAdd the `--enable-gi` and `--py-wheel` options like:\n\n```PowerShell\ngvsbuild build --enable-gi --py-wheel gtk4 pygobject\n```\n\nOnce that finishes, then you need to use the gvsbuild generated wheels with your\n[Python virtualenv](https://docs.python.org/3/tutorial/venv.html) in order to\nwork around this [PyGObject\nbug](https://gitlab.gnome.org/GNOME/pygobject/-/issues/545):\n\n```PowerShell\npip install --force-reinstall (Resolve-Path C:\\gtk-build\\build\\x64\\release\\pygobject\\dist\\PyGObject*.whl)\npip install --force-reinstall (Resolve-Path C:\\gtk-build\\build\\x64\\release\\pycairo\\dist\\pycairo*.whl)\n```\n\n#### Other Options\n\n For more information about the possible commands run:\n\n ```\n gvsbuild --help\n ```\n\n To get detailed help on the build command run:\n\n ```\n gvsbuild build --help\n ```\n\n It is possible to set some parameters from a file, e.g. vs2015-release.pro, putting\n the @ character before the file name. The file contains the option, one per\n line, separated by a carriage return:\n\n ```\n --vs-ver\n 14\n --win-sdk\n 8.1\n --configuration\n release\n ```\n\n Even if the format is not the easier to write or read in this way we eliminate\n the problem of escaping spaces is file names and directories. Then you can use\n it:\n\n ```\n gvsbuild build @vs2015-release.pro gtk3-full\n ```\n\n## Troubleshooting\n\nIf the download of a tarball fails a partial file will not pass the hash check,\ndelete the file and try again.\n\n## OpenSSL\n\nIn addition to the setup instructions above, to build OpenSSL you also need the\nVisual C++ 2013 Redistributable Package installed. To install it, open PowerShell\nas administrator and execute:\n\n```PowerShell\nchoco install vcredist2013\n```\n\nSimilar to other packages, you can build OpenSSL by executing:\n```\ngvsbuild build openssl\n```\n\n## Dependency Graph\n\nTo see and analyze the dependency between the various projects, in text or in a\nGraphviz format, use the script deps.py:\n\n ```\ngvsbuild deps --graph --gv-file test.gv\n ```\n\nWithout option a simple dependency of all the projects is printed, as usual with\n--help a summary of the options/commands is printed.\n\n## License\n\nThis build script is licensed under the GPL2.0 license, see the COPYING file for\nthe full text.\n\nThe binaries produced by the build script are licensed under the license terms\nof the project that is built (ie glib is LGPL so you can use glib.dll built\nwith this script under the terms of LGPL).\n\nPatches included in the repository are licensed under the license terms of the\nproject they apply to.\n\n## Credits\n\nThis tool originated from a gtk-win32 PowerShell script created by the\n[HexChat](https://hexchat.github.io/) developers for building it for Windows.\nAlthough this project is now archived, you can explore the original project if you\nare interested in the history at https://github.com/hexchat/gtk-win32.\n\nCompiling the GTK stack on MSVC would not be possible without the incredible\nwork by [Fan Chun-wei](https://github.com/fanc999). If you are interested in more\ndetails of how this works, please see [Compiling the GTK+ (and Clutter) stack using\nVisual C++ 2008 and\nlater](https://wiki.gnome.org/Projects/GTK/Win32/MSVCCompilationOfGTKStack).\n',
    'author': 'Ignacio Casal Quinteiro',
    'author_email': 'qignacio@amazon.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
