"use strict";
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2020-08-28T09:56:40.433Z","fingerprint":"4GrwA5ZsFWWcooV7VhsSmLA7tSol98+7sGJ3NMZJCB8="}
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnPipeline = exports.CfnDatastore = exports.CfnDataset = exports.CfnChannel = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/cfn-parse");
/**
 * Determine whether the given properties match those of a `CfnChannelProps`
 *
 * @param properties - the TypeScript properties of a `CfnChannelProps`
 *
 * @returns the result of the validation.
 */
function CfnChannelPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('channelName', cdk.validateString)(properties.channelName));
    errors.collect(cdk.propertyValidator('channelStorage', CfnChannel_ChannelStoragePropertyValidator)(properties.channelStorage));
    errors.collect(cdk.propertyValidator('retentionPeriod', CfnChannel_RetentionPeriodPropertyValidator)(properties.retentionPeriod));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnChannelProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Channel` resource
 *
 * @param properties - the TypeScript properties of a `CfnChannelProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Channel` resource.
 */
// @ts-ignore TS6133
function cfnChannelPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannelPropsValidator(properties).assertSuccess();
    return {
        ChannelName: cdk.stringToCloudFormation(properties.channelName),
        ChannelStorage: cfnChannelChannelStoragePropertyToCloudFormation(properties.channelStorage),
        RetentionPeriod: cfnChannelRetentionPeriodPropertyToCloudFormation(properties.retentionPeriod),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnChannelPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        channelName: properties.ChannelName != null ? cfn_parse.FromCloudFormation.getString(properties.ChannelName) : undefined,
        channelStorage: properties.ChannelStorage != null ? CfnChannelChannelStoragePropertyFromCloudFormation(properties.ChannelStorage) : undefined,
        retentionPeriod: properties.RetentionPeriod != null ? CfnChannelRetentionPeriodPropertyFromCloudFormation(properties.RetentionPeriod) : undefined,
        tags: properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined,
    };
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Channel`
 *
 * @cloudformationResource AWS::IoTAnalytics::Channel
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-channel.html
 */
class CfnChannel extends cdk.CfnResource {
    /**
     * Create a new `AWS::IoTAnalytics::Channel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnChannel.CFN_RESOURCE_TYPE_NAME, properties: props });
        this.channelName = props.channelName;
        this.channelStorage = props.channelStorage;
        this.retentionPeriod = props.retentionPeriod;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::IoTAnalytics::Channel", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const props = CfnChannelPropsFromCloudFormation(resourceProperties);
        const ret = new CfnChannel(scope, id, props);
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnChannel.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            channelName: this.channelName,
            channelStorage: this.channelStorage,
            retentionPeriod: this.retentionPeriod,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnChannelPropsToCloudFormation(props);
    }
}
exports.CfnChannel = CfnChannel;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnChannel.CFN_RESOURCE_TYPE_NAME = "AWS::IoTAnalytics::Channel";
/**
 * Determine whether the given properties match those of a `ChannelStorageProperty`
 *
 * @param properties - the TypeScript properties of a `ChannelStorageProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_ChannelStoragePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('customerManagedS3', CfnChannel_CustomerManagedS3PropertyValidator)(properties.customerManagedS3));
    errors.collect(cdk.propertyValidator('serviceManagedS3', CfnChannel_ServiceManagedS3PropertyValidator)(properties.serviceManagedS3));
    return errors.wrap('supplied properties not correct for "ChannelStorageProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Channel.ChannelStorage` resource
 *
 * @param properties - the TypeScript properties of a `ChannelStorageProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Channel.ChannelStorage` resource.
 */
// @ts-ignore TS6133
function cfnChannelChannelStoragePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_ChannelStoragePropertyValidator(properties).assertSuccess();
    return {
        CustomerManagedS3: cfnChannelCustomerManagedS3PropertyToCloudFormation(properties.customerManagedS3),
        ServiceManagedS3: cfnChannelServiceManagedS3PropertyToCloudFormation(properties.serviceManagedS3),
    };
}
// @ts-ignore TS6133
function CfnChannelChannelStoragePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        customerManagedS3: properties.CustomerManagedS3 != null ? CfnChannelCustomerManagedS3PropertyFromCloudFormation(properties.CustomerManagedS3) : undefined,
        serviceManagedS3: properties.ServiceManagedS3 != null ? CfnChannelServiceManagedS3PropertyFromCloudFormation(properties.ServiceManagedS3) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `CustomerManagedS3Property`
 *
 * @param properties - the TypeScript properties of a `CustomerManagedS3Property`
 *
 * @returns the result of the validation.
 */
function CfnChannel_CustomerManagedS3PropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('bucket', cdk.requiredValidator)(properties.bucket));
    errors.collect(cdk.propertyValidator('bucket', cdk.validateString)(properties.bucket));
    errors.collect(cdk.propertyValidator('keyPrefix', cdk.validateString)(properties.keyPrefix));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "CustomerManagedS3Property"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Channel.CustomerManagedS3` resource
 *
 * @param properties - the TypeScript properties of a `CustomerManagedS3Property`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Channel.CustomerManagedS3` resource.
 */
// @ts-ignore TS6133
function cfnChannelCustomerManagedS3PropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_CustomerManagedS3PropertyValidator(properties).assertSuccess();
    return {
        Bucket: cdk.stringToCloudFormation(properties.bucket),
        KeyPrefix: cdk.stringToCloudFormation(properties.keyPrefix),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnChannelCustomerManagedS3PropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        bucket: cfn_parse.FromCloudFormation.getString(properties.Bucket),
        keyPrefix: properties.KeyPrefix != null ? cfn_parse.FromCloudFormation.getString(properties.KeyPrefix) : undefined,
        roleArn: cfn_parse.FromCloudFormation.getString(properties.RoleArn),
    };
}
/**
 * Determine whether the given properties match those of a `RetentionPeriodProperty`
 *
 * @param properties - the TypeScript properties of a `RetentionPeriodProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_RetentionPeriodPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('numberOfDays', cdk.validateNumber)(properties.numberOfDays));
    errors.collect(cdk.propertyValidator('unlimited', cdk.validateBoolean)(properties.unlimited));
    return errors.wrap('supplied properties not correct for "RetentionPeriodProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Channel.RetentionPeriod` resource
 *
 * @param properties - the TypeScript properties of a `RetentionPeriodProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Channel.RetentionPeriod` resource.
 */
// @ts-ignore TS6133
function cfnChannelRetentionPeriodPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_RetentionPeriodPropertyValidator(properties).assertSuccess();
    return {
        NumberOfDays: cdk.numberToCloudFormation(properties.numberOfDays),
        Unlimited: cdk.booleanToCloudFormation(properties.unlimited),
    };
}
// @ts-ignore TS6133
function CfnChannelRetentionPeriodPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        numberOfDays: properties.NumberOfDays != null ? cfn_parse.FromCloudFormation.getNumber(properties.NumberOfDays) : undefined,
        unlimited: properties.Unlimited != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Unlimited) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `ServiceManagedS3Property`
 *
 * @param properties - the TypeScript properties of a `ServiceManagedS3Property`
 *
 * @returns the result of the validation.
 */
function CfnChannel_ServiceManagedS3PropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    return errors.wrap('supplied properties not correct for "ServiceManagedS3Property"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Channel.ServiceManagedS3` resource
 *
 * @param properties - the TypeScript properties of a `ServiceManagedS3Property`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Channel.ServiceManagedS3` resource.
 */
// @ts-ignore TS6133
function cfnChannelServiceManagedS3PropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_ServiceManagedS3PropertyValidator(properties).assertSuccess();
    return {};
}
// @ts-ignore TS6133
function CfnChannelServiceManagedS3PropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {};
}
/**
 * Determine whether the given properties match those of a `CfnDatasetProps`
 *
 * @param properties - the TypeScript properties of a `CfnDatasetProps`
 *
 * @returns the result of the validation.
 */
function CfnDatasetPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('actions', cdk.requiredValidator)(properties.actions));
    errors.collect(cdk.propertyValidator('actions', cdk.listValidator(CfnDataset_ActionPropertyValidator))(properties.actions));
    errors.collect(cdk.propertyValidator('contentDeliveryRules', cdk.listValidator(CfnDataset_DatasetContentDeliveryRulePropertyValidator))(properties.contentDeliveryRules));
    errors.collect(cdk.propertyValidator('datasetName', cdk.validateString)(properties.datasetName));
    errors.collect(cdk.propertyValidator('retentionPeriod', CfnDataset_RetentionPeriodPropertyValidator)(properties.retentionPeriod));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('triggers', cdk.listValidator(CfnDataset_TriggerPropertyValidator))(properties.triggers));
    errors.collect(cdk.propertyValidator('versioningConfiguration', CfnDataset_VersioningConfigurationPropertyValidator)(properties.versioningConfiguration));
    return errors.wrap('supplied properties not correct for "CfnDatasetProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset` resource
 *
 * @param properties - the TypeScript properties of a `CfnDatasetProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset` resource.
 */
// @ts-ignore TS6133
function cfnDatasetPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDatasetPropsValidator(properties).assertSuccess();
    return {
        Actions: cdk.listMapper(cfnDatasetActionPropertyToCloudFormation)(properties.actions),
        ContentDeliveryRules: cdk.listMapper(cfnDatasetDatasetContentDeliveryRulePropertyToCloudFormation)(properties.contentDeliveryRules),
        DatasetName: cdk.stringToCloudFormation(properties.datasetName),
        RetentionPeriod: cfnDatasetRetentionPeriodPropertyToCloudFormation(properties.retentionPeriod),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        Triggers: cdk.listMapper(cfnDatasetTriggerPropertyToCloudFormation)(properties.triggers),
        VersioningConfiguration: cfnDatasetVersioningConfigurationPropertyToCloudFormation(properties.versioningConfiguration),
    };
}
// @ts-ignore TS6133
function CfnDatasetPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        actions: cfn_parse.FromCloudFormation.getArray(CfnDatasetActionPropertyFromCloudFormation)(properties.Actions),
        contentDeliveryRules: properties.ContentDeliveryRules != null ? cfn_parse.FromCloudFormation.getArray(CfnDatasetDatasetContentDeliveryRulePropertyFromCloudFormation)(properties.ContentDeliveryRules) : undefined,
        datasetName: properties.DatasetName != null ? cfn_parse.FromCloudFormation.getString(properties.DatasetName) : undefined,
        retentionPeriod: properties.RetentionPeriod != null ? CfnDatasetRetentionPeriodPropertyFromCloudFormation(properties.RetentionPeriod) : undefined,
        tags: properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined,
        triggers: properties.Triggers != null ? cfn_parse.FromCloudFormation.getArray(CfnDatasetTriggerPropertyFromCloudFormation)(properties.Triggers) : undefined,
        versioningConfiguration: properties.VersioningConfiguration != null ? CfnDatasetVersioningConfigurationPropertyFromCloudFormation(properties.VersioningConfiguration) : undefined,
    };
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`
 *
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
class CfnDataset extends cdk.CfnResource {
    /**
     * Create a new `AWS::IoTAnalytics::Dataset`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDataset.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'actions', this);
        this.actions = props.actions;
        this.contentDeliveryRules = props.contentDeliveryRules;
        this.datasetName = props.datasetName;
        this.retentionPeriod = props.retentionPeriod;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::IoTAnalytics::Dataset", props.tags, { tagPropertyName: 'tags' });
        this.triggers = props.triggers;
        this.versioningConfiguration = props.versioningConfiguration;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const props = CfnDatasetPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDataset(scope, id, props);
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDataset.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            actions: this.actions,
            contentDeliveryRules: this.contentDeliveryRules,
            datasetName: this.datasetName,
            retentionPeriod: this.retentionPeriod,
            tags: this.tags.renderTags(),
            triggers: this.triggers,
            versioningConfiguration: this.versioningConfiguration,
        };
    }
    renderProperties(props) {
        return cfnDatasetPropsToCloudFormation(props);
    }
}
exports.CfnDataset = CfnDataset;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDataset.CFN_RESOURCE_TYPE_NAME = "AWS::IoTAnalytics::Dataset";
/**
 * Determine whether the given properties match those of a `ActionProperty`
 *
 * @param properties - the TypeScript properties of a `ActionProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataset_ActionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('actionName', cdk.requiredValidator)(properties.actionName));
    errors.collect(cdk.propertyValidator('actionName', cdk.validateString)(properties.actionName));
    errors.collect(cdk.propertyValidator('containerAction', CfnDataset_ContainerActionPropertyValidator)(properties.containerAction));
    errors.collect(cdk.propertyValidator('queryAction', CfnDataset_QueryActionPropertyValidator)(properties.queryAction));
    return errors.wrap('supplied properties not correct for "ActionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.Action` resource
 *
 * @param properties - the TypeScript properties of a `ActionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.Action` resource.
 */
// @ts-ignore TS6133
function cfnDatasetActionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataset_ActionPropertyValidator(properties).assertSuccess();
    return {
        ActionName: cdk.stringToCloudFormation(properties.actionName),
        ContainerAction: cfnDatasetContainerActionPropertyToCloudFormation(properties.containerAction),
        QueryAction: cfnDatasetQueryActionPropertyToCloudFormation(properties.queryAction),
    };
}
// @ts-ignore TS6133
function CfnDatasetActionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        actionName: cfn_parse.FromCloudFormation.getString(properties.ActionName),
        containerAction: properties.ContainerAction != null ? CfnDatasetContainerActionPropertyFromCloudFormation(properties.ContainerAction) : undefined,
        queryAction: properties.QueryAction != null ? CfnDatasetQueryActionPropertyFromCloudFormation(properties.QueryAction) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `ContainerActionProperty`
 *
 * @param properties - the TypeScript properties of a `ContainerActionProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataset_ContainerActionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('executionRoleArn', cdk.requiredValidator)(properties.executionRoleArn));
    errors.collect(cdk.propertyValidator('executionRoleArn', cdk.validateString)(properties.executionRoleArn));
    errors.collect(cdk.propertyValidator('image', cdk.requiredValidator)(properties.image));
    errors.collect(cdk.propertyValidator('image', cdk.validateString)(properties.image));
    errors.collect(cdk.propertyValidator('resourceConfiguration', cdk.requiredValidator)(properties.resourceConfiguration));
    errors.collect(cdk.propertyValidator('resourceConfiguration', CfnDataset_ResourceConfigurationPropertyValidator)(properties.resourceConfiguration));
    errors.collect(cdk.propertyValidator('variables', cdk.listValidator(CfnDataset_VariablePropertyValidator))(properties.variables));
    return errors.wrap('supplied properties not correct for "ContainerActionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.ContainerAction` resource
 *
 * @param properties - the TypeScript properties of a `ContainerActionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.ContainerAction` resource.
 */
// @ts-ignore TS6133
function cfnDatasetContainerActionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataset_ContainerActionPropertyValidator(properties).assertSuccess();
    return {
        ExecutionRoleArn: cdk.stringToCloudFormation(properties.executionRoleArn),
        Image: cdk.stringToCloudFormation(properties.image),
        ResourceConfiguration: cfnDatasetResourceConfigurationPropertyToCloudFormation(properties.resourceConfiguration),
        Variables: cdk.listMapper(cfnDatasetVariablePropertyToCloudFormation)(properties.variables),
    };
}
// @ts-ignore TS6133
function CfnDatasetContainerActionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        executionRoleArn: cfn_parse.FromCloudFormation.getString(properties.ExecutionRoleArn),
        image: cfn_parse.FromCloudFormation.getString(properties.Image),
        resourceConfiguration: CfnDatasetResourceConfigurationPropertyFromCloudFormation(properties.ResourceConfiguration),
        variables: properties.Variables != null ? cfn_parse.FromCloudFormation.getArray(CfnDatasetVariablePropertyFromCloudFormation)(properties.Variables) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `DatasetContentDeliveryRuleProperty`
 *
 * @param properties - the TypeScript properties of a `DatasetContentDeliveryRuleProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataset_DatasetContentDeliveryRulePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('destination', cdk.requiredValidator)(properties.destination));
    errors.collect(cdk.propertyValidator('destination', CfnDataset_DatasetContentDeliveryRuleDestinationPropertyValidator)(properties.destination));
    errors.collect(cdk.propertyValidator('entryName', cdk.validateString)(properties.entryName));
    return errors.wrap('supplied properties not correct for "DatasetContentDeliveryRuleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.DatasetContentDeliveryRule` resource
 *
 * @param properties - the TypeScript properties of a `DatasetContentDeliveryRuleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.DatasetContentDeliveryRule` resource.
 */
// @ts-ignore TS6133
function cfnDatasetDatasetContentDeliveryRulePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataset_DatasetContentDeliveryRulePropertyValidator(properties).assertSuccess();
    return {
        Destination: cfnDatasetDatasetContentDeliveryRuleDestinationPropertyToCloudFormation(properties.destination),
        EntryName: cdk.stringToCloudFormation(properties.entryName),
    };
}
// @ts-ignore TS6133
function CfnDatasetDatasetContentDeliveryRulePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        destination: CfnDatasetDatasetContentDeliveryRuleDestinationPropertyFromCloudFormation(properties.Destination),
        entryName: properties.EntryName != null ? cfn_parse.FromCloudFormation.getString(properties.EntryName) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `DatasetContentDeliveryRuleDestinationProperty`
 *
 * @param properties - the TypeScript properties of a `DatasetContentDeliveryRuleDestinationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataset_DatasetContentDeliveryRuleDestinationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('iotEventsDestinationConfiguration', CfnDataset_IotEventsDestinationConfigurationPropertyValidator)(properties.iotEventsDestinationConfiguration));
    errors.collect(cdk.propertyValidator('s3DestinationConfiguration', CfnDataset_S3DestinationConfigurationPropertyValidator)(properties.s3DestinationConfiguration));
    return errors.wrap('supplied properties not correct for "DatasetContentDeliveryRuleDestinationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.DatasetContentDeliveryRuleDestination` resource
 *
 * @param properties - the TypeScript properties of a `DatasetContentDeliveryRuleDestinationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.DatasetContentDeliveryRuleDestination` resource.
 */
// @ts-ignore TS6133
function cfnDatasetDatasetContentDeliveryRuleDestinationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataset_DatasetContentDeliveryRuleDestinationPropertyValidator(properties).assertSuccess();
    return {
        IotEventsDestinationConfiguration: cfnDatasetIotEventsDestinationConfigurationPropertyToCloudFormation(properties.iotEventsDestinationConfiguration),
        S3DestinationConfiguration: cfnDatasetS3DestinationConfigurationPropertyToCloudFormation(properties.s3DestinationConfiguration),
    };
}
// @ts-ignore TS6133
function CfnDatasetDatasetContentDeliveryRuleDestinationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        iotEventsDestinationConfiguration: properties.IotEventsDestinationConfiguration != null ? CfnDatasetIotEventsDestinationConfigurationPropertyFromCloudFormation(properties.IotEventsDestinationConfiguration) : undefined,
        s3DestinationConfiguration: properties.S3DestinationConfiguration != null ? CfnDatasetS3DestinationConfigurationPropertyFromCloudFormation(properties.S3DestinationConfiguration) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `DatasetContentVersionValueProperty`
 *
 * @param properties - the TypeScript properties of a `DatasetContentVersionValueProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataset_DatasetContentVersionValuePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('datasetName', cdk.validateString)(properties.datasetName));
    return errors.wrap('supplied properties not correct for "DatasetContentVersionValueProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.DatasetContentVersionValue` resource
 *
 * @param properties - the TypeScript properties of a `DatasetContentVersionValueProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.DatasetContentVersionValue` resource.
 */
// @ts-ignore TS6133
function cfnDatasetDatasetContentVersionValuePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataset_DatasetContentVersionValuePropertyValidator(properties).assertSuccess();
    return {
        DatasetName: cdk.stringToCloudFormation(properties.datasetName),
    };
}
// @ts-ignore TS6133
function CfnDatasetDatasetContentVersionValuePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        datasetName: properties.DatasetName != null ? cfn_parse.FromCloudFormation.getString(properties.DatasetName) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `DeltaTimeProperty`
 *
 * @param properties - the TypeScript properties of a `DeltaTimeProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataset_DeltaTimePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('offsetSeconds', cdk.requiredValidator)(properties.offsetSeconds));
    errors.collect(cdk.propertyValidator('offsetSeconds', cdk.validateNumber)(properties.offsetSeconds));
    errors.collect(cdk.propertyValidator('timeExpression', cdk.requiredValidator)(properties.timeExpression));
    errors.collect(cdk.propertyValidator('timeExpression', cdk.validateString)(properties.timeExpression));
    return errors.wrap('supplied properties not correct for "DeltaTimeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.DeltaTime` resource
 *
 * @param properties - the TypeScript properties of a `DeltaTimeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.DeltaTime` resource.
 */
// @ts-ignore TS6133
function cfnDatasetDeltaTimePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataset_DeltaTimePropertyValidator(properties).assertSuccess();
    return {
        OffsetSeconds: cdk.numberToCloudFormation(properties.offsetSeconds),
        TimeExpression: cdk.stringToCloudFormation(properties.timeExpression),
    };
}
// @ts-ignore TS6133
function CfnDatasetDeltaTimePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        offsetSeconds: cfn_parse.FromCloudFormation.getNumber(properties.OffsetSeconds),
        timeExpression: cfn_parse.FromCloudFormation.getString(properties.TimeExpression),
    };
}
/**
 * Determine whether the given properties match those of a `FilterProperty`
 *
 * @param properties - the TypeScript properties of a `FilterProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataset_FilterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('deltaTime', CfnDataset_DeltaTimePropertyValidator)(properties.deltaTime));
    return errors.wrap('supplied properties not correct for "FilterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.Filter` resource
 *
 * @param properties - the TypeScript properties of a `FilterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.Filter` resource.
 */
// @ts-ignore TS6133
function cfnDatasetFilterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataset_FilterPropertyValidator(properties).assertSuccess();
    return {
        DeltaTime: cfnDatasetDeltaTimePropertyToCloudFormation(properties.deltaTime),
    };
}
// @ts-ignore TS6133
function CfnDatasetFilterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        deltaTime: properties.DeltaTime != null ? CfnDatasetDeltaTimePropertyFromCloudFormation(properties.DeltaTime) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `GlueConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `GlueConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataset_GlueConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('databaseName', cdk.requiredValidator)(properties.databaseName));
    errors.collect(cdk.propertyValidator('databaseName', cdk.validateString)(properties.databaseName));
    errors.collect(cdk.propertyValidator('tableName', cdk.requiredValidator)(properties.tableName));
    errors.collect(cdk.propertyValidator('tableName', cdk.validateString)(properties.tableName));
    return errors.wrap('supplied properties not correct for "GlueConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.GlueConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `GlueConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.GlueConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDatasetGlueConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataset_GlueConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DatabaseName: cdk.stringToCloudFormation(properties.databaseName),
        TableName: cdk.stringToCloudFormation(properties.tableName),
    };
}
// @ts-ignore TS6133
function CfnDatasetGlueConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        databaseName: cfn_parse.FromCloudFormation.getString(properties.DatabaseName),
        tableName: cfn_parse.FromCloudFormation.getString(properties.TableName),
    };
}
/**
 * Determine whether the given properties match those of a `IotEventsDestinationConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `IotEventsDestinationConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataset_IotEventsDestinationConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('inputName', cdk.requiredValidator)(properties.inputName));
    errors.collect(cdk.propertyValidator('inputName', cdk.validateString)(properties.inputName));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "IotEventsDestinationConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.IotEventsDestinationConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `IotEventsDestinationConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.IotEventsDestinationConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDatasetIotEventsDestinationConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataset_IotEventsDestinationConfigurationPropertyValidator(properties).assertSuccess();
    return {
        InputName: cdk.stringToCloudFormation(properties.inputName),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnDatasetIotEventsDestinationConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        inputName: cfn_parse.FromCloudFormation.getString(properties.InputName),
        roleArn: cfn_parse.FromCloudFormation.getString(properties.RoleArn),
    };
}
/**
 * Determine whether the given properties match those of a `OutputFileUriValueProperty`
 *
 * @param properties - the TypeScript properties of a `OutputFileUriValueProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataset_OutputFileUriValuePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('fileName', cdk.validateString)(properties.fileName));
    return errors.wrap('supplied properties not correct for "OutputFileUriValueProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.OutputFileUriValue` resource
 *
 * @param properties - the TypeScript properties of a `OutputFileUriValueProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.OutputFileUriValue` resource.
 */
// @ts-ignore TS6133
function cfnDatasetOutputFileUriValuePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataset_OutputFileUriValuePropertyValidator(properties).assertSuccess();
    return {
        FileName: cdk.stringToCloudFormation(properties.fileName),
    };
}
// @ts-ignore TS6133
function CfnDatasetOutputFileUriValuePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        fileName: properties.FileName != null ? cfn_parse.FromCloudFormation.getString(properties.FileName) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `QueryActionProperty`
 *
 * @param properties - the TypeScript properties of a `QueryActionProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataset_QueryActionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('filters', cdk.listValidator(CfnDataset_FilterPropertyValidator))(properties.filters));
    errors.collect(cdk.propertyValidator('sqlQuery', cdk.requiredValidator)(properties.sqlQuery));
    errors.collect(cdk.propertyValidator('sqlQuery', cdk.validateString)(properties.sqlQuery));
    return errors.wrap('supplied properties not correct for "QueryActionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.QueryAction` resource
 *
 * @param properties - the TypeScript properties of a `QueryActionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.QueryAction` resource.
 */
// @ts-ignore TS6133
function cfnDatasetQueryActionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataset_QueryActionPropertyValidator(properties).assertSuccess();
    return {
        Filters: cdk.listMapper(cfnDatasetFilterPropertyToCloudFormation)(properties.filters),
        SqlQuery: cdk.stringToCloudFormation(properties.sqlQuery),
    };
}
// @ts-ignore TS6133
function CfnDatasetQueryActionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        filters: properties.Filters != null ? cfn_parse.FromCloudFormation.getArray(CfnDatasetFilterPropertyFromCloudFormation)(properties.Filters) : undefined,
        sqlQuery: cfn_parse.FromCloudFormation.getString(properties.SqlQuery),
    };
}
/**
 * Determine whether the given properties match those of a `ResourceConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ResourceConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataset_ResourceConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('computeType', cdk.requiredValidator)(properties.computeType));
    errors.collect(cdk.propertyValidator('computeType', cdk.validateString)(properties.computeType));
    errors.collect(cdk.propertyValidator('volumeSizeInGb', cdk.requiredValidator)(properties.volumeSizeInGb));
    errors.collect(cdk.propertyValidator('volumeSizeInGb', cdk.validateNumber)(properties.volumeSizeInGb));
    return errors.wrap('supplied properties not correct for "ResourceConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.ResourceConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ResourceConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.ResourceConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDatasetResourceConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataset_ResourceConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ComputeType: cdk.stringToCloudFormation(properties.computeType),
        VolumeSizeInGB: cdk.numberToCloudFormation(properties.volumeSizeInGb),
    };
}
// @ts-ignore TS6133
function CfnDatasetResourceConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        computeType: cfn_parse.FromCloudFormation.getString(properties.ComputeType),
        volumeSizeInGb: cfn_parse.FromCloudFormation.getNumber(properties.VolumeSizeInGB),
    };
}
/**
 * Determine whether the given properties match those of a `RetentionPeriodProperty`
 *
 * @param properties - the TypeScript properties of a `RetentionPeriodProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataset_RetentionPeriodPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('numberOfDays', cdk.requiredValidator)(properties.numberOfDays));
    errors.collect(cdk.propertyValidator('numberOfDays', cdk.validateNumber)(properties.numberOfDays));
    errors.collect(cdk.propertyValidator('unlimited', cdk.requiredValidator)(properties.unlimited));
    errors.collect(cdk.propertyValidator('unlimited', cdk.validateBoolean)(properties.unlimited));
    return errors.wrap('supplied properties not correct for "RetentionPeriodProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.RetentionPeriod` resource
 *
 * @param properties - the TypeScript properties of a `RetentionPeriodProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.RetentionPeriod` resource.
 */
// @ts-ignore TS6133
function cfnDatasetRetentionPeriodPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataset_RetentionPeriodPropertyValidator(properties).assertSuccess();
    return {
        NumberOfDays: cdk.numberToCloudFormation(properties.numberOfDays),
        Unlimited: cdk.booleanToCloudFormation(properties.unlimited),
    };
}
// @ts-ignore TS6133
function CfnDatasetRetentionPeriodPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        numberOfDays: cfn_parse.FromCloudFormation.getNumber(properties.NumberOfDays),
        unlimited: cfn_parse.FromCloudFormation.getBoolean(properties.Unlimited),
    };
}
/**
 * Determine whether the given properties match those of a `S3DestinationConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `S3DestinationConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataset_S3DestinationConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('bucket', cdk.requiredValidator)(properties.bucket));
    errors.collect(cdk.propertyValidator('bucket', cdk.validateString)(properties.bucket));
    errors.collect(cdk.propertyValidator('glueConfiguration', CfnDataset_GlueConfigurationPropertyValidator)(properties.glueConfiguration));
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "S3DestinationConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.S3DestinationConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `S3DestinationConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.S3DestinationConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDatasetS3DestinationConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataset_S3DestinationConfigurationPropertyValidator(properties).assertSuccess();
    return {
        Bucket: cdk.stringToCloudFormation(properties.bucket),
        GlueConfiguration: cfnDatasetGlueConfigurationPropertyToCloudFormation(properties.glueConfiguration),
        Key: cdk.stringToCloudFormation(properties.key),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnDatasetS3DestinationConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        bucket: cfn_parse.FromCloudFormation.getString(properties.Bucket),
        glueConfiguration: properties.GlueConfiguration != null ? CfnDatasetGlueConfigurationPropertyFromCloudFormation(properties.GlueConfiguration) : undefined,
        key: cfn_parse.FromCloudFormation.getString(properties.Key),
        roleArn: cfn_parse.FromCloudFormation.getString(properties.RoleArn),
    };
}
/**
 * Determine whether the given properties match those of a `ScheduleProperty`
 *
 * @param properties - the TypeScript properties of a `ScheduleProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataset_SchedulePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('scheduleExpression', cdk.requiredValidator)(properties.scheduleExpression));
    errors.collect(cdk.propertyValidator('scheduleExpression', cdk.validateString)(properties.scheduleExpression));
    return errors.wrap('supplied properties not correct for "ScheduleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.Schedule` resource
 *
 * @param properties - the TypeScript properties of a `ScheduleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.Schedule` resource.
 */
// @ts-ignore TS6133
function cfnDatasetSchedulePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataset_SchedulePropertyValidator(properties).assertSuccess();
    return {
        ScheduleExpression: cdk.stringToCloudFormation(properties.scheduleExpression),
    };
}
// @ts-ignore TS6133
function CfnDatasetSchedulePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        scheduleExpression: cfn_parse.FromCloudFormation.getString(properties.ScheduleExpression),
    };
}
/**
 * Determine whether the given properties match those of a `TriggerProperty`
 *
 * @param properties - the TypeScript properties of a `TriggerProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataset_TriggerPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('schedule', CfnDataset_SchedulePropertyValidator)(properties.schedule));
    errors.collect(cdk.propertyValidator('triggeringDataset', CfnDataset_TriggeringDatasetPropertyValidator)(properties.triggeringDataset));
    return errors.wrap('supplied properties not correct for "TriggerProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.Trigger` resource
 *
 * @param properties - the TypeScript properties of a `TriggerProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.Trigger` resource.
 */
// @ts-ignore TS6133
function cfnDatasetTriggerPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataset_TriggerPropertyValidator(properties).assertSuccess();
    return {
        Schedule: cfnDatasetSchedulePropertyToCloudFormation(properties.schedule),
        TriggeringDataset: cfnDatasetTriggeringDatasetPropertyToCloudFormation(properties.triggeringDataset),
    };
}
// @ts-ignore TS6133
function CfnDatasetTriggerPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        schedule: properties.Schedule != null ? CfnDatasetSchedulePropertyFromCloudFormation(properties.Schedule) : undefined,
        triggeringDataset: properties.TriggeringDataset != null ? CfnDatasetTriggeringDatasetPropertyFromCloudFormation(properties.TriggeringDataset) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `TriggeringDatasetProperty`
 *
 * @param properties - the TypeScript properties of a `TriggeringDatasetProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataset_TriggeringDatasetPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('datasetName', cdk.requiredValidator)(properties.datasetName));
    errors.collect(cdk.propertyValidator('datasetName', cdk.validateString)(properties.datasetName));
    return errors.wrap('supplied properties not correct for "TriggeringDatasetProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.TriggeringDataset` resource
 *
 * @param properties - the TypeScript properties of a `TriggeringDatasetProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.TriggeringDataset` resource.
 */
// @ts-ignore TS6133
function cfnDatasetTriggeringDatasetPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataset_TriggeringDatasetPropertyValidator(properties).assertSuccess();
    return {
        DatasetName: cdk.stringToCloudFormation(properties.datasetName),
    };
}
// @ts-ignore TS6133
function CfnDatasetTriggeringDatasetPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        datasetName: cfn_parse.FromCloudFormation.getString(properties.DatasetName),
    };
}
/**
 * Determine whether the given properties match those of a `VariableProperty`
 *
 * @param properties - the TypeScript properties of a `VariableProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataset_VariablePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('datasetContentVersionValue', CfnDataset_DatasetContentVersionValuePropertyValidator)(properties.datasetContentVersionValue));
    errors.collect(cdk.propertyValidator('doubleValue', cdk.validateNumber)(properties.doubleValue));
    errors.collect(cdk.propertyValidator('outputFileUriValue', CfnDataset_OutputFileUriValuePropertyValidator)(properties.outputFileUriValue));
    errors.collect(cdk.propertyValidator('stringValue', cdk.validateString)(properties.stringValue));
    errors.collect(cdk.propertyValidator('variableName', cdk.requiredValidator)(properties.variableName));
    errors.collect(cdk.propertyValidator('variableName', cdk.validateString)(properties.variableName));
    return errors.wrap('supplied properties not correct for "VariableProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.Variable` resource
 *
 * @param properties - the TypeScript properties of a `VariableProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.Variable` resource.
 */
// @ts-ignore TS6133
function cfnDatasetVariablePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataset_VariablePropertyValidator(properties).assertSuccess();
    return {
        DatasetContentVersionValue: cfnDatasetDatasetContentVersionValuePropertyToCloudFormation(properties.datasetContentVersionValue),
        DoubleValue: cdk.numberToCloudFormation(properties.doubleValue),
        OutputFileUriValue: cfnDatasetOutputFileUriValuePropertyToCloudFormation(properties.outputFileUriValue),
        StringValue: cdk.stringToCloudFormation(properties.stringValue),
        VariableName: cdk.stringToCloudFormation(properties.variableName),
    };
}
// @ts-ignore TS6133
function CfnDatasetVariablePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        datasetContentVersionValue: properties.DatasetContentVersionValue != null ? CfnDatasetDatasetContentVersionValuePropertyFromCloudFormation(properties.DatasetContentVersionValue) : undefined,
        doubleValue: properties.DoubleValue != null ? cfn_parse.FromCloudFormation.getNumber(properties.DoubleValue) : undefined,
        outputFileUriValue: properties.OutputFileUriValue != null ? CfnDatasetOutputFileUriValuePropertyFromCloudFormation(properties.OutputFileUriValue) : undefined,
        stringValue: properties.StringValue != null ? cfn_parse.FromCloudFormation.getString(properties.StringValue) : undefined,
        variableName: cfn_parse.FromCloudFormation.getString(properties.VariableName),
    };
}
/**
 * Determine whether the given properties match those of a `VersioningConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `VersioningConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataset_VersioningConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('maxVersions', cdk.validateNumber)(properties.maxVersions));
    errors.collect(cdk.propertyValidator('unlimited', cdk.validateBoolean)(properties.unlimited));
    return errors.wrap('supplied properties not correct for "VersioningConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.VersioningConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `VersioningConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Dataset.VersioningConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDatasetVersioningConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataset_VersioningConfigurationPropertyValidator(properties).assertSuccess();
    return {
        MaxVersions: cdk.numberToCloudFormation(properties.maxVersions),
        Unlimited: cdk.booleanToCloudFormation(properties.unlimited),
    };
}
// @ts-ignore TS6133
function CfnDatasetVersioningConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        maxVersions: properties.MaxVersions != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxVersions) : undefined,
        unlimited: properties.Unlimited != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Unlimited) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `CfnDatastoreProps`
 *
 * @param properties - the TypeScript properties of a `CfnDatastoreProps`
 *
 * @returns the result of the validation.
 */
function CfnDatastorePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('datastoreName', cdk.validateString)(properties.datastoreName));
    errors.collect(cdk.propertyValidator('datastoreStorage', CfnDatastore_DatastoreStoragePropertyValidator)(properties.datastoreStorage));
    errors.collect(cdk.propertyValidator('retentionPeriod', CfnDatastore_RetentionPeriodPropertyValidator)(properties.retentionPeriod));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDatastoreProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Datastore` resource
 *
 * @param properties - the TypeScript properties of a `CfnDatastoreProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Datastore` resource.
 */
// @ts-ignore TS6133
function cfnDatastorePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDatastorePropsValidator(properties).assertSuccess();
    return {
        DatastoreName: cdk.stringToCloudFormation(properties.datastoreName),
        DatastoreStorage: cfnDatastoreDatastoreStoragePropertyToCloudFormation(properties.datastoreStorage),
        RetentionPeriod: cfnDatastoreRetentionPeriodPropertyToCloudFormation(properties.retentionPeriod),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDatastorePropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        datastoreName: properties.DatastoreName != null ? cfn_parse.FromCloudFormation.getString(properties.DatastoreName) : undefined,
        datastoreStorage: properties.DatastoreStorage != null ? CfnDatastoreDatastoreStoragePropertyFromCloudFormation(properties.DatastoreStorage) : undefined,
        retentionPeriod: properties.RetentionPeriod != null ? CfnDatastoreRetentionPeriodPropertyFromCloudFormation(properties.RetentionPeriod) : undefined,
        tags: properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined,
    };
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Datastore`
 *
 * @cloudformationResource AWS::IoTAnalytics::Datastore
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html
 */
class CfnDatastore extends cdk.CfnResource {
    /**
     * Create a new `AWS::IoTAnalytics::Datastore`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnDatastore.CFN_RESOURCE_TYPE_NAME, properties: props });
        this.datastoreName = props.datastoreName;
        this.datastoreStorage = props.datastoreStorage;
        this.retentionPeriod = props.retentionPeriod;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::IoTAnalytics::Datastore", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const props = CfnDatastorePropsFromCloudFormation(resourceProperties);
        const ret = new CfnDatastore(scope, id, props);
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDatastore.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            datastoreName: this.datastoreName,
            datastoreStorage: this.datastoreStorage,
            retentionPeriod: this.retentionPeriod,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDatastorePropsToCloudFormation(props);
    }
}
exports.CfnDatastore = CfnDatastore;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDatastore.CFN_RESOURCE_TYPE_NAME = "AWS::IoTAnalytics::Datastore";
/**
 * Determine whether the given properties match those of a `CustomerManagedS3Property`
 *
 * @param properties - the TypeScript properties of a `CustomerManagedS3Property`
 *
 * @returns the result of the validation.
 */
function CfnDatastore_CustomerManagedS3PropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('bucket', cdk.requiredValidator)(properties.bucket));
    errors.collect(cdk.propertyValidator('bucket', cdk.validateString)(properties.bucket));
    errors.collect(cdk.propertyValidator('keyPrefix', cdk.validateString)(properties.keyPrefix));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "CustomerManagedS3Property"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Datastore.CustomerManagedS3` resource
 *
 * @param properties - the TypeScript properties of a `CustomerManagedS3Property`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Datastore.CustomerManagedS3` resource.
 */
// @ts-ignore TS6133
function cfnDatastoreCustomerManagedS3PropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDatastore_CustomerManagedS3PropertyValidator(properties).assertSuccess();
    return {
        Bucket: cdk.stringToCloudFormation(properties.bucket),
        KeyPrefix: cdk.stringToCloudFormation(properties.keyPrefix),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnDatastoreCustomerManagedS3PropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        bucket: cfn_parse.FromCloudFormation.getString(properties.Bucket),
        keyPrefix: properties.KeyPrefix != null ? cfn_parse.FromCloudFormation.getString(properties.KeyPrefix) : undefined,
        roleArn: cfn_parse.FromCloudFormation.getString(properties.RoleArn),
    };
}
/**
 * Determine whether the given properties match those of a `DatastoreStorageProperty`
 *
 * @param properties - the TypeScript properties of a `DatastoreStorageProperty`
 *
 * @returns the result of the validation.
 */
function CfnDatastore_DatastoreStoragePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('customerManagedS3', CfnDatastore_CustomerManagedS3PropertyValidator)(properties.customerManagedS3));
    errors.collect(cdk.propertyValidator('serviceManagedS3', CfnDatastore_ServiceManagedS3PropertyValidator)(properties.serviceManagedS3));
    return errors.wrap('supplied properties not correct for "DatastoreStorageProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Datastore.DatastoreStorage` resource
 *
 * @param properties - the TypeScript properties of a `DatastoreStorageProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Datastore.DatastoreStorage` resource.
 */
// @ts-ignore TS6133
function cfnDatastoreDatastoreStoragePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDatastore_DatastoreStoragePropertyValidator(properties).assertSuccess();
    return {
        CustomerManagedS3: cfnDatastoreCustomerManagedS3PropertyToCloudFormation(properties.customerManagedS3),
        ServiceManagedS3: cfnDatastoreServiceManagedS3PropertyToCloudFormation(properties.serviceManagedS3),
    };
}
// @ts-ignore TS6133
function CfnDatastoreDatastoreStoragePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        customerManagedS3: properties.CustomerManagedS3 != null ? CfnDatastoreCustomerManagedS3PropertyFromCloudFormation(properties.CustomerManagedS3) : undefined,
        serviceManagedS3: properties.ServiceManagedS3 != null ? CfnDatastoreServiceManagedS3PropertyFromCloudFormation(properties.ServiceManagedS3) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `RetentionPeriodProperty`
 *
 * @param properties - the TypeScript properties of a `RetentionPeriodProperty`
 *
 * @returns the result of the validation.
 */
function CfnDatastore_RetentionPeriodPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('numberOfDays', cdk.validateNumber)(properties.numberOfDays));
    errors.collect(cdk.propertyValidator('unlimited', cdk.validateBoolean)(properties.unlimited));
    return errors.wrap('supplied properties not correct for "RetentionPeriodProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Datastore.RetentionPeriod` resource
 *
 * @param properties - the TypeScript properties of a `RetentionPeriodProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Datastore.RetentionPeriod` resource.
 */
// @ts-ignore TS6133
function cfnDatastoreRetentionPeriodPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDatastore_RetentionPeriodPropertyValidator(properties).assertSuccess();
    return {
        NumberOfDays: cdk.numberToCloudFormation(properties.numberOfDays),
        Unlimited: cdk.booleanToCloudFormation(properties.unlimited),
    };
}
// @ts-ignore TS6133
function CfnDatastoreRetentionPeriodPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        numberOfDays: properties.NumberOfDays != null ? cfn_parse.FromCloudFormation.getNumber(properties.NumberOfDays) : undefined,
        unlimited: properties.Unlimited != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Unlimited) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `ServiceManagedS3Property`
 *
 * @param properties - the TypeScript properties of a `ServiceManagedS3Property`
 *
 * @returns the result of the validation.
 */
function CfnDatastore_ServiceManagedS3PropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    return errors.wrap('supplied properties not correct for "ServiceManagedS3Property"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Datastore.ServiceManagedS3` resource
 *
 * @param properties - the TypeScript properties of a `ServiceManagedS3Property`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Datastore.ServiceManagedS3` resource.
 */
// @ts-ignore TS6133
function cfnDatastoreServiceManagedS3PropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDatastore_ServiceManagedS3PropertyValidator(properties).assertSuccess();
    return {};
}
// @ts-ignore TS6133
function CfnDatastoreServiceManagedS3PropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {};
}
/**
 * Determine whether the given properties match those of a `CfnPipelineProps`
 *
 * @param properties - the TypeScript properties of a `CfnPipelineProps`
 *
 * @returns the result of the validation.
 */
function CfnPipelinePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('pipelineActivities', cdk.requiredValidator)(properties.pipelineActivities));
    errors.collect(cdk.propertyValidator('pipelineActivities', cdk.listValidator(CfnPipeline_ActivityPropertyValidator))(properties.pipelineActivities));
    errors.collect(cdk.propertyValidator('pipelineName', cdk.validateString)(properties.pipelineName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnPipelineProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline` resource
 *
 * @param properties - the TypeScript properties of a `CfnPipelineProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline` resource.
 */
// @ts-ignore TS6133
function cfnPipelinePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPipelinePropsValidator(properties).assertSuccess();
    return {
        PipelineActivities: cdk.listMapper(cfnPipelineActivityPropertyToCloudFormation)(properties.pipelineActivities),
        PipelineName: cdk.stringToCloudFormation(properties.pipelineName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnPipelinePropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        pipelineActivities: cfn_parse.FromCloudFormation.getArray(CfnPipelineActivityPropertyFromCloudFormation)(properties.PipelineActivities),
        pipelineName: properties.PipelineName != null ? cfn_parse.FromCloudFormation.getString(properties.PipelineName) : undefined,
        tags: properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined,
    };
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Pipeline`
 *
 * @cloudformationResource AWS::IoTAnalytics::Pipeline
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-pipeline.html
 */
class CfnPipeline extends cdk.CfnResource {
    /**
     * Create a new `AWS::IoTAnalytics::Pipeline`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnPipeline.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'pipelineActivities', this);
        this.pipelineActivities = props.pipelineActivities;
        this.pipelineName = props.pipelineName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::IoTAnalytics::Pipeline", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const props = CfnPipelinePropsFromCloudFormation(resourceProperties);
        const ret = new CfnPipeline(scope, id, props);
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnPipeline.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            pipelineActivities: this.pipelineActivities,
            pipelineName: this.pipelineName,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnPipelinePropsToCloudFormation(props);
    }
}
exports.CfnPipeline = CfnPipeline;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnPipeline.CFN_RESOURCE_TYPE_NAME = "AWS::IoTAnalytics::Pipeline";
/**
 * Determine whether the given properties match those of a `ActivityProperty`
 *
 * @param properties - the TypeScript properties of a `ActivityProperty`
 *
 * @returns the result of the validation.
 */
function CfnPipeline_ActivityPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('addAttributes', CfnPipeline_AddAttributesPropertyValidator)(properties.addAttributes));
    errors.collect(cdk.propertyValidator('channel', CfnPipeline_ChannelPropertyValidator)(properties.channel));
    errors.collect(cdk.propertyValidator('datastore', CfnPipeline_DatastorePropertyValidator)(properties.datastore));
    errors.collect(cdk.propertyValidator('deviceRegistryEnrich', CfnPipeline_DeviceRegistryEnrichPropertyValidator)(properties.deviceRegistryEnrich));
    errors.collect(cdk.propertyValidator('deviceShadowEnrich', CfnPipeline_DeviceShadowEnrichPropertyValidator)(properties.deviceShadowEnrich));
    errors.collect(cdk.propertyValidator('filter', CfnPipeline_FilterPropertyValidator)(properties.filter));
    errors.collect(cdk.propertyValidator('lambda', CfnPipeline_LambdaPropertyValidator)(properties.lambda));
    errors.collect(cdk.propertyValidator('math', CfnPipeline_MathPropertyValidator)(properties.math));
    errors.collect(cdk.propertyValidator('removeAttributes', CfnPipeline_RemoveAttributesPropertyValidator)(properties.removeAttributes));
    errors.collect(cdk.propertyValidator('selectAttributes', CfnPipeline_SelectAttributesPropertyValidator)(properties.selectAttributes));
    return errors.wrap('supplied properties not correct for "ActivityProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.Activity` resource
 *
 * @param properties - the TypeScript properties of a `ActivityProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.Activity` resource.
 */
// @ts-ignore TS6133
function cfnPipelineActivityPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPipeline_ActivityPropertyValidator(properties).assertSuccess();
    return {
        AddAttributes: cfnPipelineAddAttributesPropertyToCloudFormation(properties.addAttributes),
        Channel: cfnPipelineChannelPropertyToCloudFormation(properties.channel),
        Datastore: cfnPipelineDatastorePropertyToCloudFormation(properties.datastore),
        DeviceRegistryEnrich: cfnPipelineDeviceRegistryEnrichPropertyToCloudFormation(properties.deviceRegistryEnrich),
        DeviceShadowEnrich: cfnPipelineDeviceShadowEnrichPropertyToCloudFormation(properties.deviceShadowEnrich),
        Filter: cfnPipelineFilterPropertyToCloudFormation(properties.filter),
        Lambda: cfnPipelineLambdaPropertyToCloudFormation(properties.lambda),
        Math: cfnPipelineMathPropertyToCloudFormation(properties.math),
        RemoveAttributes: cfnPipelineRemoveAttributesPropertyToCloudFormation(properties.removeAttributes),
        SelectAttributes: cfnPipelineSelectAttributesPropertyToCloudFormation(properties.selectAttributes),
    };
}
// @ts-ignore TS6133
function CfnPipelineActivityPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        addAttributes: properties.AddAttributes != null ? CfnPipelineAddAttributesPropertyFromCloudFormation(properties.AddAttributes) : undefined,
        channel: properties.Channel != null ? CfnPipelineChannelPropertyFromCloudFormation(properties.Channel) : undefined,
        datastore: properties.Datastore != null ? CfnPipelineDatastorePropertyFromCloudFormation(properties.Datastore) : undefined,
        deviceRegistryEnrich: properties.DeviceRegistryEnrich != null ? CfnPipelineDeviceRegistryEnrichPropertyFromCloudFormation(properties.DeviceRegistryEnrich) : undefined,
        deviceShadowEnrich: properties.DeviceShadowEnrich != null ? CfnPipelineDeviceShadowEnrichPropertyFromCloudFormation(properties.DeviceShadowEnrich) : undefined,
        filter: properties.Filter != null ? CfnPipelineFilterPropertyFromCloudFormation(properties.Filter) : undefined,
        lambda: properties.Lambda != null ? CfnPipelineLambdaPropertyFromCloudFormation(properties.Lambda) : undefined,
        math: properties.Math != null ? CfnPipelineMathPropertyFromCloudFormation(properties.Math) : undefined,
        removeAttributes: properties.RemoveAttributes != null ? CfnPipelineRemoveAttributesPropertyFromCloudFormation(properties.RemoveAttributes) : undefined,
        selectAttributes: properties.SelectAttributes != null ? CfnPipelineSelectAttributesPropertyFromCloudFormation(properties.SelectAttributes) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `AddAttributesProperty`
 *
 * @param properties - the TypeScript properties of a `AddAttributesProperty`
 *
 * @returns the result of the validation.
 */
function CfnPipeline_AddAttributesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('attributes', cdk.validateObject)(properties.attributes));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('next', cdk.validateString)(properties.next));
    return errors.wrap('supplied properties not correct for "AddAttributesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.AddAttributes` resource
 *
 * @param properties - the TypeScript properties of a `AddAttributesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.AddAttributes` resource.
 */
// @ts-ignore TS6133
function cfnPipelineAddAttributesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPipeline_AddAttributesPropertyValidator(properties).assertSuccess();
    return {
        Attributes: cdk.objectToCloudFormation(properties.attributes),
        Name: cdk.stringToCloudFormation(properties.name),
        Next: cdk.stringToCloudFormation(properties.next),
    };
}
// @ts-ignore TS6133
function CfnPipelineAddAttributesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        attributes: properties.Attributes != null ? cfn_parse.FromCloudFormation.getAny(properties.Attributes) : undefined,
        name: properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined,
        next: properties.Next != null ? cfn_parse.FromCloudFormation.getString(properties.Next) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `ChannelProperty`
 *
 * @param properties - the TypeScript properties of a `ChannelProperty`
 *
 * @returns the result of the validation.
 */
function CfnPipeline_ChannelPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('channelName', cdk.validateString)(properties.channelName));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('next', cdk.validateString)(properties.next));
    return errors.wrap('supplied properties not correct for "ChannelProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.Channel` resource
 *
 * @param properties - the TypeScript properties of a `ChannelProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.Channel` resource.
 */
// @ts-ignore TS6133
function cfnPipelineChannelPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPipeline_ChannelPropertyValidator(properties).assertSuccess();
    return {
        ChannelName: cdk.stringToCloudFormation(properties.channelName),
        Name: cdk.stringToCloudFormation(properties.name),
        Next: cdk.stringToCloudFormation(properties.next),
    };
}
// @ts-ignore TS6133
function CfnPipelineChannelPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        channelName: properties.ChannelName != null ? cfn_parse.FromCloudFormation.getString(properties.ChannelName) : undefined,
        name: properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined,
        next: properties.Next != null ? cfn_parse.FromCloudFormation.getString(properties.Next) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `DatastoreProperty`
 *
 * @param properties - the TypeScript properties of a `DatastoreProperty`
 *
 * @returns the result of the validation.
 */
function CfnPipeline_DatastorePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('datastoreName', cdk.validateString)(properties.datastoreName));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "DatastoreProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.Datastore` resource
 *
 * @param properties - the TypeScript properties of a `DatastoreProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.Datastore` resource.
 */
// @ts-ignore TS6133
function cfnPipelineDatastorePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPipeline_DatastorePropertyValidator(properties).assertSuccess();
    return {
        DatastoreName: cdk.stringToCloudFormation(properties.datastoreName),
        Name: cdk.stringToCloudFormation(properties.name),
    };
}
// @ts-ignore TS6133
function CfnPipelineDatastorePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        datastoreName: properties.DatastoreName != null ? cfn_parse.FromCloudFormation.getString(properties.DatastoreName) : undefined,
        name: properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `DeviceRegistryEnrichProperty`
 *
 * @param properties - the TypeScript properties of a `DeviceRegistryEnrichProperty`
 *
 * @returns the result of the validation.
 */
function CfnPipeline_DeviceRegistryEnrichPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('attribute', cdk.validateString)(properties.attribute));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('next', cdk.validateString)(properties.next));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('thingName', cdk.validateString)(properties.thingName));
    return errors.wrap('supplied properties not correct for "DeviceRegistryEnrichProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.DeviceRegistryEnrich` resource
 *
 * @param properties - the TypeScript properties of a `DeviceRegistryEnrichProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.DeviceRegistryEnrich` resource.
 */
// @ts-ignore TS6133
function cfnPipelineDeviceRegistryEnrichPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPipeline_DeviceRegistryEnrichPropertyValidator(properties).assertSuccess();
    return {
        Attribute: cdk.stringToCloudFormation(properties.attribute),
        Name: cdk.stringToCloudFormation(properties.name),
        Next: cdk.stringToCloudFormation(properties.next),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        ThingName: cdk.stringToCloudFormation(properties.thingName),
    };
}
// @ts-ignore TS6133
function CfnPipelineDeviceRegistryEnrichPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        attribute: properties.Attribute != null ? cfn_parse.FromCloudFormation.getString(properties.Attribute) : undefined,
        name: properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined,
        next: properties.Next != null ? cfn_parse.FromCloudFormation.getString(properties.Next) : undefined,
        roleArn: properties.RoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.RoleArn) : undefined,
        thingName: properties.ThingName != null ? cfn_parse.FromCloudFormation.getString(properties.ThingName) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `DeviceShadowEnrichProperty`
 *
 * @param properties - the TypeScript properties of a `DeviceShadowEnrichProperty`
 *
 * @returns the result of the validation.
 */
function CfnPipeline_DeviceShadowEnrichPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('attribute', cdk.validateString)(properties.attribute));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('next', cdk.validateString)(properties.next));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('thingName', cdk.validateString)(properties.thingName));
    return errors.wrap('supplied properties not correct for "DeviceShadowEnrichProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.DeviceShadowEnrich` resource
 *
 * @param properties - the TypeScript properties of a `DeviceShadowEnrichProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.DeviceShadowEnrich` resource.
 */
// @ts-ignore TS6133
function cfnPipelineDeviceShadowEnrichPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPipeline_DeviceShadowEnrichPropertyValidator(properties).assertSuccess();
    return {
        Attribute: cdk.stringToCloudFormation(properties.attribute),
        Name: cdk.stringToCloudFormation(properties.name),
        Next: cdk.stringToCloudFormation(properties.next),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        ThingName: cdk.stringToCloudFormation(properties.thingName),
    };
}
// @ts-ignore TS6133
function CfnPipelineDeviceShadowEnrichPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        attribute: properties.Attribute != null ? cfn_parse.FromCloudFormation.getString(properties.Attribute) : undefined,
        name: properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined,
        next: properties.Next != null ? cfn_parse.FromCloudFormation.getString(properties.Next) : undefined,
        roleArn: properties.RoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.RoleArn) : undefined,
        thingName: properties.ThingName != null ? cfn_parse.FromCloudFormation.getString(properties.ThingName) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `FilterProperty`
 *
 * @param properties - the TypeScript properties of a `FilterProperty`
 *
 * @returns the result of the validation.
 */
function CfnPipeline_FilterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('filter', cdk.validateString)(properties.filter));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('next', cdk.validateString)(properties.next));
    return errors.wrap('supplied properties not correct for "FilterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.Filter` resource
 *
 * @param properties - the TypeScript properties of a `FilterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.Filter` resource.
 */
// @ts-ignore TS6133
function cfnPipelineFilterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPipeline_FilterPropertyValidator(properties).assertSuccess();
    return {
        Filter: cdk.stringToCloudFormation(properties.filter),
        Name: cdk.stringToCloudFormation(properties.name),
        Next: cdk.stringToCloudFormation(properties.next),
    };
}
// @ts-ignore TS6133
function CfnPipelineFilterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        filter: properties.Filter != null ? cfn_parse.FromCloudFormation.getString(properties.Filter) : undefined,
        name: properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined,
        next: properties.Next != null ? cfn_parse.FromCloudFormation.getString(properties.Next) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `LambdaProperty`
 *
 * @param properties - the TypeScript properties of a `LambdaProperty`
 *
 * @returns the result of the validation.
 */
function CfnPipeline_LambdaPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('batchSize', cdk.validateNumber)(properties.batchSize));
    errors.collect(cdk.propertyValidator('lambdaName', cdk.validateString)(properties.lambdaName));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('next', cdk.validateString)(properties.next));
    return errors.wrap('supplied properties not correct for "LambdaProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.Lambda` resource
 *
 * @param properties - the TypeScript properties of a `LambdaProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.Lambda` resource.
 */
// @ts-ignore TS6133
function cfnPipelineLambdaPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPipeline_LambdaPropertyValidator(properties).assertSuccess();
    return {
        BatchSize: cdk.numberToCloudFormation(properties.batchSize),
        LambdaName: cdk.stringToCloudFormation(properties.lambdaName),
        Name: cdk.stringToCloudFormation(properties.name),
        Next: cdk.stringToCloudFormation(properties.next),
    };
}
// @ts-ignore TS6133
function CfnPipelineLambdaPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        batchSize: properties.BatchSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.BatchSize) : undefined,
        lambdaName: properties.LambdaName != null ? cfn_parse.FromCloudFormation.getString(properties.LambdaName) : undefined,
        name: properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined,
        next: properties.Next != null ? cfn_parse.FromCloudFormation.getString(properties.Next) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `MathProperty`
 *
 * @param properties - the TypeScript properties of a `MathProperty`
 *
 * @returns the result of the validation.
 */
function CfnPipeline_MathPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('attribute', cdk.validateString)(properties.attribute));
    errors.collect(cdk.propertyValidator('math', cdk.validateString)(properties.math));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('next', cdk.validateString)(properties.next));
    return errors.wrap('supplied properties not correct for "MathProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.Math` resource
 *
 * @param properties - the TypeScript properties of a `MathProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.Math` resource.
 */
// @ts-ignore TS6133
function cfnPipelineMathPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPipeline_MathPropertyValidator(properties).assertSuccess();
    return {
        Attribute: cdk.stringToCloudFormation(properties.attribute),
        Math: cdk.stringToCloudFormation(properties.math),
        Name: cdk.stringToCloudFormation(properties.name),
        Next: cdk.stringToCloudFormation(properties.next),
    };
}
// @ts-ignore TS6133
function CfnPipelineMathPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        attribute: properties.Attribute != null ? cfn_parse.FromCloudFormation.getString(properties.Attribute) : undefined,
        math: properties.Math != null ? cfn_parse.FromCloudFormation.getString(properties.Math) : undefined,
        name: properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined,
        next: properties.Next != null ? cfn_parse.FromCloudFormation.getString(properties.Next) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `RemoveAttributesProperty`
 *
 * @param properties - the TypeScript properties of a `RemoveAttributesProperty`
 *
 * @returns the result of the validation.
 */
function CfnPipeline_RemoveAttributesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('attributes', cdk.listValidator(cdk.validateString))(properties.attributes));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('next', cdk.validateString)(properties.next));
    return errors.wrap('supplied properties not correct for "RemoveAttributesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.RemoveAttributes` resource
 *
 * @param properties - the TypeScript properties of a `RemoveAttributesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.RemoveAttributes` resource.
 */
// @ts-ignore TS6133
function cfnPipelineRemoveAttributesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPipeline_RemoveAttributesPropertyValidator(properties).assertSuccess();
    return {
        Attributes: cdk.listMapper(cdk.stringToCloudFormation)(properties.attributes),
        Name: cdk.stringToCloudFormation(properties.name),
        Next: cdk.stringToCloudFormation(properties.next),
    };
}
// @ts-ignore TS6133
function CfnPipelineRemoveAttributesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        attributes: properties.Attributes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Attributes) : undefined,
        name: properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined,
        next: properties.Next != null ? cfn_parse.FromCloudFormation.getString(properties.Next) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `SelectAttributesProperty`
 *
 * @param properties - the TypeScript properties of a `SelectAttributesProperty`
 *
 * @returns the result of the validation.
 */
function CfnPipeline_SelectAttributesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('attributes', cdk.listValidator(cdk.validateString))(properties.attributes));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('next', cdk.validateString)(properties.next));
    return errors.wrap('supplied properties not correct for "SelectAttributesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.SelectAttributes` resource
 *
 * @param properties - the TypeScript properties of a `SelectAttributesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::IoTAnalytics::Pipeline.SelectAttributes` resource.
 */
// @ts-ignore TS6133
function cfnPipelineSelectAttributesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPipeline_SelectAttributesPropertyValidator(properties).assertSuccess();
    return {
        Attributes: cdk.listMapper(cdk.stringToCloudFormation)(properties.attributes),
        Name: cdk.stringToCloudFormation(properties.name),
        Next: cdk.stringToCloudFormation(properties.next),
    };
}
// @ts-ignore TS6133
function CfnPipelineSelectAttributesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        attributes: properties.Attributes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Attributes) : undefined,
        name: properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined,
        next: properties.Next != null ? cfn_parse.FromCloudFormation.getString(properties.Next) : undefined,
    };
}
//# sourceMappingURL=data:application/json;base64,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