# GEOG0111 Scientific Computing

[Course Documentation](https://ucl-eo.github.io/geog0111/)

 [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/UCL-EO/geog0111/master)
 [![Travis-CI](https://travis-ci.com/UCL-EO/geog0111.svg?branch=master)](https://travis-ci.com/github/UCL-EO/geog0111)
 


## Course information

### Course Convenor 

[Prof P. Lewis](http://www.geog.ucl.ac.uk/~plewis)

### Teaching Staff 2020-2021

|   |  | 
|---|---|
|[Prof P. Lewis](http://www.geog.ucl.ac.uk/~plewis)|[Dr Qingling Wu](http://www.geog.ucl.ac.uk/about-the-department/people/research-staff/qingling-wu/)| 

### Contributing Staff

|   |   |   |
|---|---|---|
|[Dr Qingling Wu](http://www.geog.ucl.ac.uk/about-the-department/people/research-staff/qingling-wu/)| [Dr. Jose Gomez-Dans](http://www.geog.ucl.ac.uk/about-the-department/people/research-staff/jose-gomez-dans/)|[Feng Yin](https://www.geog.ucl.ac.uk/people/research-students/feng-yin)|


### Purpose of this course

This course, GEOG0111 Scientific Computing, is a term 1 MSc module worth 15 credits (25% of the term 1 credits) that aims to:

* impart an understanding of scientific computing
* give students a grounding in the basic principles of algorithm development and program construction
* to introduce principles of computer-based image analysis and model development

It is open to students from a number of MSc courses run by the Department of Geography UCL, but the material should be of wider value to others wishing to make use of scientific computing. 

The module will cover:

* Computing in Python
* Computing for image analysis
* Computing for environmental modelling
* Data visualisation for scientific applications

### Learning Outcomes

At the end of the module, students should:

* have an understanding of the Python programmibng language and experience of its use
* have an understanding of algorithm development and be able to use widely used scientific computing software to manipulate datasets and accomplish analytical tasks
* have an understanding of the technical issues specific to image-based analysis, model implementation and scientific visualisation


### Running on UCL JupyterHub

Follow the instructions on [UCL installation and running](notebooks/Install.md)

## Timetable

[class timetable for 2020/21](notebooks/TIMETABLE.md)

The course takes place over 10 weeks in term 1, usually in the Geography Department Unix Computing Lab (PB110) in the [Northwest wing](http://www.ucl.ac.uk/estates/roombooking/building-location/?id=003), UCL. 

Due to covid restrictions, it is being run online in the 2020-21 session.

Classes take place from the second week of term to the final week of term, other than Reading week. See UCL [term dates](http://www.ucl.ac.uk/staff/term-dates) for further information.

The timetable is available on the UCL Academic Calendar. Live class sessions will take place in groups on Monday and Thursdays.




### Assessment

Assessment is through two pieces of coursework, submitted in both paper form and electronically via Moodle. 

See the [Moodle page](https://moodle.ucl.ac.uk/course/view.php?id=21495) for more details.

### Useful links

[Course Moodle page](https://moodle.ucl.ac.uk/course/view.php?id=21495)  

### Notes, code etc
[geog0111 code pypi for v1.1.0](https://test.pypi.org/project/geog0111/1.1.0)

### Using the course notes

We will generally use `jupyter` notebooks for running interactive Python programs. If you are taking this course at UCL, 
follow the instructions on [UCL installation and running](notebooks/Install.md). If you are running from outside UCL [see these notes](notebooks/OutsideInstall-Local.md).
