# coding: utf-8

"""
    VIER Cognitive Voice Assist API

    With the CVG Assist API you can use live transcriptions of customers to provide in-call agent assistance.  CVG Assist API requires some integration with contact center software to link ACD phone number, dialogID und agentID. The call has to be bridged to the contact center head number of e.g. a hotline plus an extension. The contact center then has to invoke `/assist/accept` with the phone number.  Integration with VIER Engage is available. Ask us if you are interested in integrating other contact center software.  CVG Assist API is part of the VIER Cognitive Voice Gateway.  For more details, see [our documentation](/docs/Essential-Use-Cases.html#agent-assistance).  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@vier.ai
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from cvg_sdk import schemas  # noqa: F401


class TranscriptionStartParameters(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """


    class MetaOapg:
        required = {
            "resellerToken",
            "speaker",
            "dialogId",
        }
        
        class properties:
            resellerToken = schemas.StrSchema
            dialogId = schemas.StrSchema
        
            @staticmethod
            def speaker() -> typing.Type['Speaker']:
                return Speaker
            __annotations__ = {
                "resellerToken": resellerToken,
                "dialogId": dialogId,
                "speaker": speaker,
            }
    
    resellerToken: MetaOapg.properties.resellerToken
    speaker: 'Speaker'
    dialogId: MetaOapg.properties.dialogId
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["resellerToken"]) -> MetaOapg.properties.resellerToken: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["dialogId"]) -> MetaOapg.properties.dialogId: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["speaker"]) -> 'Speaker': ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["resellerToken", "dialogId", "speaker", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["resellerToken"]) -> MetaOapg.properties.resellerToken: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["dialogId"]) -> MetaOapg.properties.dialogId: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["speaker"]) -> 'Speaker': ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["resellerToken", "dialogId", "speaker", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        resellerToken: typing.Union[MetaOapg.properties.resellerToken, str, ],
        speaker: 'Speaker',
        dialogId: typing.Union[MetaOapg.properties.dialogId, str, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'TranscriptionStartParameters':
        return super().__new__(
            cls,
            *args,
            resellerToken=resellerToken,
            speaker=speaker,
            dialogId=dialogId,
            _configuration=_configuration,
            **kwargs,
        )

from cvg_sdk.model.speaker import Speaker
