# coding: utf-8

"""
    VIER Cognitive Voice Recording API

    With the Recording API, client applications can manage recordings that have previously been created using the Call or Assist APIs.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@vier.ai
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from cvg_sdk import schemas  # noqa: F401


class TranscriptEntry(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    A transcript entry describes what either participant (here `speaker`) has said with minimal to no interpretation
by the platform.
    """


    class MetaOapg:
        required = {
            "speaker",
            "type",
            "timestamp",
        }
        
        @staticmethod
        def discriminator():
            return {
                'type': {
                    'Audio': Audio,
                    'Dtmf': Dtmf,
                    'Text': Text,
                    'Voice': Voice,
                }
            }
        
        class properties:
            
            
            class type(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "Voice": "VOICE",
                        "Dtmf": "DTMF",
                        "Text": "TEXT",
                        "Audio": "AUDIO",
                    }
                
                @schemas.classproperty
                def VOICE(cls):
                    return cls("Voice")
                
                @schemas.classproperty
                def DTMF(cls):
                    return cls("Dtmf")
                
                @schemas.classproperty
                def TEXT(cls):
                    return cls("Text")
                
                @schemas.classproperty
                def AUDIO(cls):
                    return cls("Audio")
            timestamp = schemas.Int64Schema
        
            @staticmethod
            def speaker() -> typing.Type['Speaker']:
                return Speaker
            __annotations__ = {
                "type": type,
                "timestamp": timestamp,
                "speaker": speaker,
            }
    
    speaker: 'Speaker'
    type: MetaOapg.properties.type
    timestamp: MetaOapg.properties.timestamp
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["type"]) -> MetaOapg.properties.type: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["timestamp"]) -> MetaOapg.properties.timestamp: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["speaker"]) -> 'Speaker': ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["type", "timestamp", "speaker", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["type"]) -> MetaOapg.properties.type: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["timestamp"]) -> MetaOapg.properties.timestamp: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["speaker"]) -> 'Speaker': ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["type", "timestamp", "speaker", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        speaker: 'Speaker',
        type: typing.Union[MetaOapg.properties.type, str, ],
        timestamp: typing.Union[MetaOapg.properties.timestamp, decimal.Decimal, int, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'TranscriptEntry':
        return super().__new__(
            cls,
            *args,
            speaker=speaker,
            type=type,
            timestamp=timestamp,
            _configuration=_configuration,
            **kwargs,
        )

from cvg_sdk.model.audio import Audio
from cvg_sdk.model.dtmf import Dtmf
from cvg_sdk.model.speaker import Speaker
from cvg_sdk.model.text import Text
from cvg_sdk.model.voice import Voice
