# coding: utf-8

"""
    VIER Cognitive Voice Recording API

    With the Recording API, client applications can manage recordings that have previously been created using the Call or Assist APIs.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@vier.ai
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from cvg_sdk import schemas  # noqa: F401


class RecordingObjectsResponse(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    This object contains URLs to the various artifacts that can be retrieved for a given recording.

All URLs in this object are **not stable** and **not permanent**. Download the files in a timely fashion. If
you need to download the files multiple times, always request this object first for the appropriate download
URLs.
    """


    class MetaOapg:
        required = {
            "duration",
            "lossy",
            "phase",
            "transcript",
            "lossless",
            "recordingId",
        }
        
        class properties:
        
            @staticmethod
            def phase() -> typing.Type['DialogPhase']:
                return DialogPhase
        
            @staticmethod
            def recordingId() -> typing.Type['RecordingId']:
                return RecordingId
            lossless = schemas.StrSchema
            lossy = schemas.StrSchema
            transcript = schemas.StrSchema
            __annotations__ = {
                "phase": phase,
                "recordingId": recordingId,
                "lossless": lossless,
                "lossy": lossy,
                "transcript": transcript,
            }
    
    duration: schemas.AnyTypeSchema
    lossy: MetaOapg.properties.lossy
    phase: 'DialogPhase'
    transcript: MetaOapg.properties.transcript
    lossless: MetaOapg.properties.lossless
    recordingId: 'RecordingId'
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["phase"]) -> 'DialogPhase': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["recordingId"]) -> 'RecordingId': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["lossless"]) -> MetaOapg.properties.lossless: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["lossy"]) -> MetaOapg.properties.lossy: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["transcript"]) -> MetaOapg.properties.transcript: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["phase", "recordingId", "lossless", "lossy", "transcript", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["phase"]) -> 'DialogPhase': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["recordingId"]) -> 'RecordingId': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["lossless"]) -> MetaOapg.properties.lossless: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["lossy"]) -> MetaOapg.properties.lossy: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["transcript"]) -> MetaOapg.properties.transcript: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["phase", "recordingId", "lossless", "lossy", "transcript", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        duration: typing.Union[MetaOapg.properties.duration, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ],
        lossy: typing.Union[MetaOapg.properties.lossy, str, ],
        phase: 'DialogPhase',
        transcript: typing.Union[MetaOapg.properties.transcript, str, ],
        lossless: typing.Union[MetaOapg.properties.lossless, str, ],
        recordingId: 'RecordingId',
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'RecordingObjectsResponse':
        return super().__new__(
            cls,
            *args,
            duration=duration,
            lossy=lossy,
            phase=phase,
            transcript=transcript,
            lossless=lossless,
            recordingId=recordingId,
            _configuration=_configuration,
            **kwargs,
        )

from cvg_sdk.model.dialog_phase import DialogPhase
from cvg_sdk.model.recording_id import RecordingId
