# Generated by Django 3.2.15 on 2022-10-27 15:08

import uuid

import django.core.validators
import django.db.models.deletion
from django.db import migrations, models

import privates.fields
import privates.storages

import digid_eherkenning.models.digid


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("simple_certmanager", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="EherkenningConfiguration",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "idp_metadata_file",
                    privates.fields.PrivateMediaFileField(
                        help_text="The metadata file of the identity provider.",
                        storage=privates.storages.PrivateMediaFileSystemStorage(),
                        upload_to="",
                        verbose_name="identity provider metadata",
                    ),
                ),
                (
                    "idp_service_entity_id",
                    models.CharField(
                        help_text="Example value: 'https://was-preprod1.digid.nl/saml/idp/metadata'. Note that this must match the 'entityID' attribute on the 'md:EntityDescriptor' node found in the Identity Provider's metadata.",
                        max_length=255,
                        verbose_name="identity provider service entity ID",
                    ),
                ),
                (
                    "want_assertions_signed",
                    models.BooleanField(
                        default=True,
                        help_text="If True, the XML assertions need to be signed, otherwise the whole response needs to be signed.",
                        max_length=100,
                        verbose_name="want assertions signed",
                    ),
                ),
                (
                    "want_assertions_encrypted",
                    models.BooleanField(
                        default=False,
                        help_text="If True the XML assertions need to be encrypted.",
                        max_length=100,
                        verbose_name="want assertions encrypted",
                    ),
                ),
                (
                    "key_passphrase",
                    models.CharField(
                        blank=True,
                        help_text="Passphrase for the private key used by the SOAP client.",
                        max_length=100,
                        verbose_name="key passphrase",
                    ),
                ),
                (
                    "signature_algorithm",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("http://www.w3.org/2000/09/xmldsig#dsa-sha1", "DSA_SHA1"),
                            ("http://www.w3.org/2000/09/xmldsig#rsa-sha1", "RSA_SHA1"),
                            (
                                "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256",
                                "RSA_SHA256",
                            ),
                            (
                                "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384",
                                "RSA_SHA384",
                            ),
                            (
                                "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512",
                                "RSA_SHA512",
                            ),
                        ],
                        default="http://www.w3.org/2000/09/xmldsig#rsa-sha1",
                        help_text="Signature algorithm. Note that DSA_SHA1 and RSA_SHA1 are deprecated, but RSA_SHA1 is still the default value in the SAMLv2 standard. Warning: there are known issues with single-logout functionality if using anything other than SHA1 due to some hardcoded algorithm.",
                        max_length=100,
                        verbose_name="signature algorithm",
                    ),
                ),
                (
                    "digest_algorithm",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("http://www.w3.org/2000/09/xmldsig#sha1", "SHA1"),
                            ("http://www.w3.org/2001/04/xmlenc#sha256", "SHA256"),
                            ("http://www.w3.org/2001/04/xmldsig-more#sha384", "SHA384"),
                            ("http://www.w3.org/2001/04/xmlenc#sha512", "SHA512"),
                        ],
                        default="http://www.w3.org/2000/09/xmldsig#sha1",
                        help_text="Digest algorithm. Note that SHA1 is deprecated, but still the default value in the SAMLv2 standard. Warning: there are known issues with single-logout functionality if using anything other than SHA1 due to some hardcoded algorithm.",
                        max_length=100,
                        verbose_name="digest algorithm",
                    ),
                ),
                (
                    "entity_id",
                    models.CharField(
                        help_text="Service provider entity ID.",
                        max_length=100,
                        verbose_name="entity ID",
                    ),
                ),
                (
                    "base_url",
                    models.URLField(
                        help_text="Base URL of the application.",
                        max_length=100,
                        verbose_name="base URL",
                    ),
                ),
                (
                    "service_name",
                    models.CharField(
                        help_text="Name of the service you are providing.",
                        max_length=100,
                        verbose_name="service name",
                    ),
                ),
                (
                    "service_description",
                    models.CharField(
                        help_text="A description of the service you are providing.",
                        max_length=100,
                        verbose_name="service description",
                    ),
                ),
                (
                    "technical_contact_person_telephone",
                    models.CharField(
                        blank=True,
                        help_text="Telephone number of the technical person responsible for this DigiD/eHerkenning/eIDAS setup. For it to show up in the metata, you should also specify the email address.",
                        max_length=100,
                        verbose_name="technical contact: phone number",
                    ),
                ),
                (
                    "technical_contact_person_email",
                    models.CharField(
                        blank=True,
                        help_text="Email address of the technical person responsible for this DigiD/eHerkenning/eIDAS setup. For it to show up in the metadata, you should also specify the phone number.",
                        max_length=100,
                        verbose_name="technical contact: email",
                    ),
                ),
                (
                    "organization_url",
                    models.URLField(
                        blank=True,
                        help_text="URL of the organization providing the service for which DigiD/eHerkenning/eIDAS login is configured. For it to show up in the metadata, you should also specify the organization name.",
                        max_length=255,
                        verbose_name="organization URL",
                    ),
                ),
                (
                    "organization_name",
                    models.CharField(
                        blank=True,
                        help_text="URL of the organization providing the service for which DigiD/eHerkenning/eIDAS login is configured. For it to show up in the metadata, you should also specify the organization URL.",
                        max_length=100,
                        verbose_name="organization name",
                    ),
                ),
                (
                    "loa",
                    models.CharField(
                        blank=True,
                        choices=[
                            (
                                "urn:etoegang:core:assurance-class:loa1",
                                "Non existent (1)",
                            ),
                            ("urn:etoegang:core:assurance-class:loa2", "Low (2)"),
                            ("urn:etoegang:core:assurance-class:loa2plus", "Low (2+)"),
                            (
                                "urn:etoegang:core:assurance-class:loa3",
                                "Substantial (3)",
                            ),
                            ("urn:etoegang:core:assurance-class:loa4", "High (4)"),
                        ],
                        default="urn:etoegang:core:assurance-class:loa3",
                        help_text="Level of Assurance (LoA) to use for all the services.",
                        max_length=100,
                        verbose_name="LoA",
                    ),
                ),
                (
                    "eh_attribute_consuming_service_index",
                    models.CharField(
                        blank=True,
                        default="9052",
                        help_text="Attribute consuming service index for the eHerkenning service",
                        max_length=100,
                        verbose_name="eHerkenning attribute consuming service index",
                    ),
                ),
                (
                    "eh_requested_attributes",
                    models.JSONField(
                        default=list,
                        help_text="A list of additional requested attributes. A single requested attribute can be a string (the name of the attribute) or an object with keys 'name' and 'required', where 'name' is a string and 'required' a boolean'.",
                        verbose_name="requested attributes",
                    ),
                ),
                (
                    "eh_service_uuid",
                    models.UUIDField(
                        default=uuid.uuid4,
                        help_text="UUID of the eHerkenning service. Once entered into catalogues, changing the value is a manual process.",
                        verbose_name="eHerkenning service UUID",
                    ),
                ),
                (
                    "eh_service_instance_uuid",
                    models.UUIDField(
                        default=uuid.uuid4,
                        help_text="UUID of the eHerkenning service instance. Once entered into catalogues, changing the value is a manual process.",
                        verbose_name="eHerkenning service UUID",
                    ),
                ),
                (
                    "eidas_attribute_consuming_service_index",
                    models.CharField(
                        blank=True,
                        default="9053",
                        help_text="Attribute consuming service index for the eIDAS service",
                        max_length=100,
                        verbose_name="eIDAS attribute consuming service index",
                    ),
                ),
                (
                    "eidas_requested_attributes",
                    models.JSONField(
                        default=list,
                        help_text="A list of additional requested attributes. A single requested attribute can be a string (the name of the attribute) or an object with keys 'name' and 'required', where 'name' is a string and 'required' a boolean'.",
                        verbose_name="requested attributes",
                    ),
                ),
                (
                    "eidas_service_uuid",
                    models.UUIDField(
                        default=uuid.uuid4,
                        help_text="UUID of the eIDAS service. Once entered into catalogues, changing the value is a manual process.",
                        verbose_name="eIDAS service UUID",
                    ),
                ),
                (
                    "eidas_service_instance_uuid",
                    models.UUIDField(
                        default=uuid.uuid4,
                        help_text="UUID of the eHerkenning service instance. Once entered into catalogues, changing the value is a manual process.",
                        verbose_name="eIDAS service UUID",
                    ),
                ),
                (
                    "oin",
                    models.CharField(
                        help_text="The OIN of the company providing the service.",
                        max_length=100,
                        validators=[
                            django.core.validators.RegexValidator(
                                message="A valid OIN consists of 20 digits.",
                                regex="[0-9]{20}",
                            )
                        ],
                        verbose_name="OIN",
                    ),
                ),
                (
                    "no_eidas",
                    models.BooleanField(
                        blank=True,
                        default=False,
                        help_text="If True, then the service catalogue will contain only the eHerkenning service.",
                        verbose_name="no eIDAS",
                    ),
                ),
                (
                    "privacy_policy",
                    models.URLField(
                        help_text="The URL where the privacy policy from the organization providing the service can be found.",
                        max_length=255,
                        verbose_name="privacy policy",
                    ),
                ),
                (
                    "makelaar_id",
                    models.CharField(
                        help_text="OIN of the broker used to set up eHerkenning/eIDAS.",
                        max_length=100,
                        validators=[
                            django.core.validators.RegexValidator(
                                message="A valid OIN consists of 20 digits.",
                                regex="[0-9]{20}",
                            )
                        ],
                        verbose_name="broker ID",
                    ),
                ),
                (
                    "artifact_resolve_content_type",
                    models.CharField(
                        choices=[
                            ("application/soap+xml", "application/soap+xml"),
                            ("text/xml", "text/xml"),
                        ],
                        default="application/soap+xml",
                        help_text="'application/soap+xml' is considered legacy and modern brokers typically expect 'text/xml'.",
                        max_length=100,
                        verbose_name="resolve artifact binding content type",
                    ),
                ),
                (
                    "service_language",
                    models.CharField(
                        default="nl",
                        help_text="Metadata for eHerkenning/eidas will contain this language key",
                        max_length=2,
                        verbose_name="service language",
                    ),
                ),
                (
                    "certificate",
                    models.ForeignKey(
                        help_text="The private key and public certificate pair to use during the authentication flow.",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="simple_certmanager.certificate",
                        verbose_name="key pair",
                    ),
                ),
            ],
            options={
                "verbose_name": "Eherkenning/eIDAS metadata configuration",
            },
        ),
        migrations.CreateModel(
            name="DigidConfiguration",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "idp_metadata_file",
                    privates.fields.PrivateMediaFileField(
                        help_text="The metadata file of the identity provider.",
                        storage=privates.storages.PrivateMediaFileSystemStorage(),
                        upload_to="",
                        verbose_name="identity provider metadata",
                    ),
                ),
                (
                    "idp_service_entity_id",
                    models.CharField(
                        help_text="Example value: 'https://was-preprod1.digid.nl/saml/idp/metadata'. Note that this must match the 'entityID' attribute on the 'md:EntityDescriptor' node found in the Identity Provider's metadata.",
                        max_length=255,
                        verbose_name="identity provider service entity ID",
                    ),
                ),
                (
                    "want_assertions_signed",
                    models.BooleanField(
                        default=True,
                        help_text="If True, the XML assertions need to be signed, otherwise the whole response needs to be signed.",
                        max_length=100,
                        verbose_name="want assertions signed",
                    ),
                ),
                (
                    "want_assertions_encrypted",
                    models.BooleanField(
                        default=False,
                        help_text="If True the XML assertions need to be encrypted.",
                        max_length=100,
                        verbose_name="want assertions encrypted",
                    ),
                ),
                (
                    "key_passphrase",
                    models.CharField(
                        blank=True,
                        help_text="Passphrase for the private key used by the SOAP client.",
                        max_length=100,
                        verbose_name="key passphrase",
                    ),
                ),
                (
                    "signature_algorithm",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("http://www.w3.org/2000/09/xmldsig#dsa-sha1", "DSA_SHA1"),
                            ("http://www.w3.org/2000/09/xmldsig#rsa-sha1", "RSA_SHA1"),
                            (
                                "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256",
                                "RSA_SHA256",
                            ),
                            (
                                "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384",
                                "RSA_SHA384",
                            ),
                            (
                                "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512",
                                "RSA_SHA512",
                            ),
                        ],
                        default="http://www.w3.org/2000/09/xmldsig#rsa-sha1",
                        help_text="Signature algorithm. Note that DSA_SHA1 and RSA_SHA1 are deprecated, but RSA_SHA1 is still the default value in the SAMLv2 standard. Warning: there are known issues with single-logout functionality if using anything other than SHA1 due to some hardcoded algorithm.",
                        max_length=100,
                        verbose_name="signature algorithm",
                    ),
                ),
                (
                    "digest_algorithm",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("http://www.w3.org/2000/09/xmldsig#sha1", "SHA1"),
                            ("http://www.w3.org/2001/04/xmlenc#sha256", "SHA256"),
                            ("http://www.w3.org/2001/04/xmldsig-more#sha384", "SHA384"),
                            ("http://www.w3.org/2001/04/xmlenc#sha512", "SHA512"),
                        ],
                        default="http://www.w3.org/2000/09/xmldsig#sha1",
                        help_text="Digest algorithm. Note that SHA1 is deprecated, but still the default value in the SAMLv2 standard. Warning: there are known issues with single-logout functionality if using anything other than SHA1 due to some hardcoded algorithm.",
                        max_length=100,
                        verbose_name="digest algorithm",
                    ),
                ),
                (
                    "entity_id",
                    models.CharField(
                        help_text="Service provider entity ID.",
                        max_length=100,
                        verbose_name="entity ID",
                    ),
                ),
                (
                    "base_url",
                    models.URLField(
                        help_text="Base URL of the application.",
                        max_length=100,
                        verbose_name="base URL",
                    ),
                ),
                (
                    "service_name",
                    models.CharField(
                        help_text="Name of the service you are providing.",
                        max_length=100,
                        verbose_name="service name",
                    ),
                ),
                (
                    "service_description",
                    models.CharField(
                        help_text="A description of the service you are providing.",
                        max_length=100,
                        verbose_name="service description",
                    ),
                ),
                (
                    "technical_contact_person_telephone",
                    models.CharField(
                        blank=True,
                        help_text="Telephone number of the technical person responsible for this DigiD/eHerkenning/eIDAS setup. For it to show up in the metata, you should also specify the email address.",
                        max_length=100,
                        verbose_name="technical contact: phone number",
                    ),
                ),
                (
                    "technical_contact_person_email",
                    models.CharField(
                        blank=True,
                        help_text="Email address of the technical person responsible for this DigiD/eHerkenning/eIDAS setup. For it to show up in the metadata, you should also specify the phone number.",
                        max_length=100,
                        verbose_name="technical contact: email",
                    ),
                ),
                (
                    "organization_url",
                    models.URLField(
                        blank=True,
                        help_text="URL of the organization providing the service for which DigiD/eHerkenning/eIDAS login is configured. For it to show up in the metadata, you should also specify the organization name.",
                        max_length=255,
                        verbose_name="organization URL",
                    ),
                ),
                (
                    "organization_name",
                    models.CharField(
                        blank=True,
                        help_text="URL of the organization providing the service for which DigiD/eHerkenning/eIDAS login is configured. For it to show up in the metadata, you should also specify the organization URL.",
                        max_length=100,
                        verbose_name="organization name",
                    ),
                ),
                (
                    "attribute_consuming_service_index",
                    models.CharField(
                        blank=True,
                        default="1",
                        help_text="Attribute consuming service index",
                        max_length=100,
                        verbose_name="Attribute consuming service index",
                    ),
                ),
                (
                    "requested_attributes",
                    models.JSONField(
                        default=digid_eherkenning.models.digid.default_digid_requested_attributes,
                        help_text="A list of strings (or objects) with the requested attributes, e.g. '[\"bsn\"]'",
                        verbose_name="requested attributes",
                    ),
                ),
                (
                    "slo",
                    models.BooleanField(
                        default=True,
                        help_text="If enabled, Single Logout is supported",
                        verbose_name="Single logout",
                    ),
                ),
                (
                    "certificate",
                    models.ForeignKey(
                        help_text="The private key and public certificate pair to use during the authentication flow.",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="simple_certmanager.certificate",
                        verbose_name="key pair",
                    ),
                ),
            ],
            options={
                "verbose_name": "Digid metadata configuration",
            },
        ),
    ]
