"""Test constants."""

ADDRESS_TO_COORDS_RESPONSE_MAINZ = [
    {
        "bounds": None,
        "businessName": None,
        "city": "Mainz",
        "countryName": "Germany",
        "location": {"lat": 50.007301330566406, "lon": 8.267149925231934},
        "name": "Kaiserstraße, Mainz, Rheinland-Pfalz",
        "number": None,
        "provider": "waze",
        "segmentId": -1,
        "state": "Rheinland-Pfalz",
        "stateName": "No State",
        "street": "Kaiserstraße",
        "streetId": 21416972,
    },
    {
        "bounds": None,
        "businessName": "Kaiserstraße",
        "city": "Hockenheim",
        "countryName": "Germany",
        "location": {"lat": 49.32006072998047, "lon": 8.544225692749023},
        "name": "Kaiserstraße",
        "number": None,
        "provider": "waze",
        "segmentId": -1,
        "state": "Baden-Württemberg",
        "stateName": "No State",
        "street": None,
        "streetId": 0,
    },
    {
        "bounds": None,
        "businessName": "Kaiserstraße",
        "city": "Sinzig",
        "countryName": "Germany",
        "location": {"lat": 50.54433822631836, "lon": 7.248213768005371},
        "name": "Kaiserstraße",
        "number": None,
        "provider": "waze",
        "segmentId": -1,
        "state": "Rheinland-Pfalz",
        "stateName": "No State",
        "street": None,
        "streetId": 0,
    },
    {
        "bounds": None,
        "businessName": None,
        "city": "Mainz",
        "countryName": "Germany",
        "location": {"lat": 50.001861572265625, "lon": 8.261739730834961},
        "name": "B40 - Kaiserstraße, Mainz, Rheinland-Pfalz",
        "number": None,
        "provider": "waze",
        "segmentId": -1,
        "state": "Rheinland-Pfalz",
        "stateName": "No State",
        "street": "B40 - Kaiserstraße",
        "streetId": 18566237,
    },
    {
        "bounds": None,
        "businessName": "Reifen Mainz",
        "city": "Hartmannsdorf bei Chemnitz",
        "countryName": "Germany",
        "location": {"lat": 50.89254379272461, "lon": 12.787724494934082},
        "name": "Reifen Mainz",
        "number": None,
        "provider": "waze",
        "segmentId": -1,
        "state": "Sachsen",
        "stateName": "No State",
        "street": None,
        "streetId": 0,
    },
    {
        "bounds": None,
        "businessName": "Kreissparkasse Kaiserstraße",
        "city": "Reutlingen",
        "countryName": "Germany",
        "location": {"lat": 48.490360260009766, "lon": 9.221074104309082},
        "name": "Kreissparkasse Kaiserstraße",
        "number": None,
        "provider": "waze",
        "segmentId": -1,
        "state": "Baden-Württemberg",
        "stateName": "No State",
        "street": None,
        "streetId": 0,
    },
    {
        "bounds": None,
        "businessName": "[P] Kaiserstraße",
        "city": "Hockenheim",
        "countryName": "Germany",
        "location": {"lat": 49.32023620605469, "lon": 8.543981552124023},
        "name": "[P] Kaiserstraße",
        "number": None,
        "provider": "waze",
        "segmentId": -1,
        "state": "Baden-Württemberg",
        "stateName": "No State",
        "street": None,
        "streetId": 0,
    },
    {
        "bounds": None,
        "businessName": "Parkhaus Kaiserstraße (KIT)",
        "city": "Karlsruhe",
        "countryName": "Germany",
        "location": {"lat": 49.00894546508789, "lon": 8.409723281860352},
        "name": "Parkhaus Kaiserstraße (KIT)",
        "number": None,
        "provider": "waze",
        "segmentId": -1,
        "state": "Baden-Württemberg",
        "stateName": "No State",
        "street": None,
        "streetId": 0,
    },
    {
        "bounds": None,
        "businessName": None,
        "city": "Neuschönau",
        "countryName": "Germany",
        "location": {"lat": 48.88447189331055, "lon": 13.478440284729004},
        "name": "Kaiserstraße, Neuschönau, Bayern",
        "number": None,
        "provider": "waze",
        "segmentId": -1,
        "state": "Bayern",
        "stateName": "No State",
        "street": "Kaiserstraße",
        "streetId": 35357765,
    },
    {
        "bounds": None,
        "businessName": None,
        "city": "Hofkirchen",
        "countryName": "Germany",
        "location": {"lat": 48.67823028564453, "lon": 13.116209983825684},
        "name": "Kaiserstraße, Hofkirchen, Bayern",
        "number": None,
        "provider": "waze",
        "segmentId": -1,
        "state": "Bayern",
        "stateName": "No State",
        "street": "Kaiserstraße",
        "streetId": 29590662,
    },
]
ADDRESS_TO_COORDS_RESPONSE_WIESBADEN = [
    {
        "bounds": None,
        "businessName": None,
        "city": "Wiesbaden",
        "countryName": "Germany",
        "location": {"lat": 50.07912063598633, "lon": 8.240204811096191},
        "name": "Luisenstraße 30, Wiesbaden, Hessen",
        "number": "30",
        "provider": "waze",
        "segmentId": 252684065,
        "state": "Hessen",
        "stateName": "No State",
        "street": "Luisenstraße",
        "streetId": 7561951,
    },
    {
        "bounds": None,
        "businessName": "Luisenstraße",
        "city": "Osterode am Harz",
        "countryName": "Germany",
        "location": {"lat": 51.726436614990234, "lon": 10.251501083374023},
        "name": "Luisenstraße",
        "number": None,
        "provider": "waze",
        "segmentId": -1,
        "state": "Niedersachsen",
        "stateName": "No State",
        "street": None,
        "streetId": 0,
    },
    {
        "bounds": None,
        "businessName": "Luisenstraße",
        "city": "Neuwied",
        "countryName": "Germany",
        "location": {"lat": 50.43082809448242, "lon": 7.459702968597412},
        "name": "Luisenstraße",
        "number": None,
        "provider": "waze",
        "segmentId": -1,
        "state": "Rheinland-Pfalz",
        "stateName": "No State",
        "street": None,
        "streetId": 0,
    },
    {
        "bounds": None,
        "businessName": "Luisenstraße",
        "city": "Neuwied",
        "countryName": "Germany",
        "location": {"lat": 50.431365966796875, "lon": 7.459079742431641},
        "name": "Luisenstraße",
        "number": None,
        "provider": "waze",
        "segmentId": -1,
        "state": "Rheinland-Pfalz",
        "stateName": "No State",
        "street": None,
        "streetId": 0,
    },
    {
        "bounds": None,
        "businessName": None,
        "city": "Wiesbaden",
        "countryName": "Germany",
        "location": {"lat": 50.002811431884766, "lon": 8.302370071411133},
        "name": "B43 - Luisenstraße, Wiesbaden, Hessen",
        "number": None,
        "provider": "waze",
        "segmentId": -1,
        "state": "Hessen",
        "stateName": "No State",
        "street": "B43 - Luisenstraße",
        "streetId": 29162817,
    },
    {
        "bounds": None,
        "businessName": "Coswig, Luisenstraße",
        "city": "Coswig (Anhalt)",
        "countryName": "Germany",
        "location": {"lat": 51.886539459228516, "lon": 12.458844184875488},
        "name": "Coswig, Luisenstraße",
        "number": None,
        "provider": "waze",
        "segmentId": -1,
        "state": "Sachsen-Anhalt",
        "stateName": "No State",
        "street": None,
        "streetId": 0,
    },
    {
        "bounds": None,
        "businessName": "Parkhaus Luisenstraße",
        "city": "Berlin",
        "countryName": "Germany",
        "location": {"lat": 52.52417755126953, "lon": 13.379514694213867},
        "name": "Parkhaus Luisenstraße",
        "number": None,
        "provider": "waze",
        "segmentId": -1,
        "state": "Berlin",
        "stateName": "No State",
        "street": None,
        "streetId": 0,
    },
    {
        "bounds": None,
        "businessName": "Luisenstraße 19",
        "city": "Hockenheim",
        "countryName": "Germany",
        "location": {"lat": 49.31757354736328, "lon": 8.551689147949219},
        "name": "Luisenstraße 19",
        "number": None,
        "provider": "waze",
        "segmentId": -1,
        "state": "Baden-Württemberg",
        "stateName": "No State",
        "street": None,
        "streetId": 0,
    },
    {
        "bounds": None,
        "businessName": "Parkhaus Luisenstraße",
        "city": "Karlsruhe",
        "countryName": "Germany",
        "location": {"lat": 49.00056457519531, "lon": 8.404129981994629},
        "name": "Parkhaus Luisenstraße",
        "number": None,
        "provider": "waze",
        "segmentId": -1,
        "state": "Baden-Württemberg",
        "stateName": "No State",
        "street": None,
        "streetId": 0,
    },
    {
        "bounds": None,
        "businessName": None,
        "city": "Garching an der Alz",
        "countryName": "Germany",
        "location": {"lat": 48.13867950439453, "lon": 12.601479530334473},
        "name": "Luisenstraße, Garching an der Alz, Bayern",
        "number": None,
        "provider": "waze",
        "segmentId": -1,
        "state": "Bayern",
        "stateName": "No State",
        "street": "Luisenstraße",
        "streetId": 29515549,
    },
]

GET_ROUTE_RESPONSE_ADDRESSES = {
    "response": {
        "results": [
            {
                "path": {
                    "segmentId": 72856282,
                    "nodeId": 79353550,
                    "x": 8.267026968560463,
                    "y": 50.00718314352199,
                    "direction": True,
                },
                "street": 0,
                "distance": 0,
                "length": 122,
                "crossTime": 22,
                "crossTimeWithoutRealTime": 22,
                "knownDirection": True,
                "penalty": 7,
                "roadType": 1,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "TURN_LEFT", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 246047066,
                    "nodeId": 79353551,
                    "x": 8.268418364486765,
                    "y": 50.006461713952184,
                    "direction": False,
                },
                "street": 1,
                "distance": 22,
                "length": 204,
                "crossTime": 67,
                "crossTimeWithoutRealTime": 67,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 1,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "TURN_RIGHT", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 246047440,
                    "nodeId": 209641300,
                    "x": 8.270667599646012,
                    "y": 50.007563160951484,
                    "direction": False,
                },
                "street": 3,
                "altStreets": [2],
                "distance": 89,
                "length": 141,
                "crossTime": 26,
                "crossTimeWithoutRealTime": 26,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [{"angle": 90, "selected": False}],
                        },
                    ],
                    "enable_voice_for_instruction": False,
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "NONE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 0, "to_lane_index": 1},
                        "angle": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 392387017,
                    "nodeId": 79353565,
                    "x": 8.271494187674573,
                    "y": 50.006420341318844,
                    "direction": False,
                },
                "street": 3,
                "altStreets": [2],
                "distance": 115,
                "length": 36,
                "crossTime": 5,
                "crossTimeWithoutRealTime": 5,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 162231268,
                    "nodeId": 162914110,
                    "x": 8.271637685856833,
                    "y": 50.00611392414356,
                    "direction": False,
                },
                "street": 3,
                "altStreets": [2],
                "distance": 120,
                "length": 191,
                "crossTime": 22,
                "crossTimeWithoutRealTime": 22,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 360439058,
                    "nodeId": 79354884,
                    "x": 8.273044504485089,
                    "y": 50.00466110951561,
                    "direction": False,
                },
                "street": 5,
                "altStreets": [4],
                "distance": 142,
                "length": 137,
                "crossTime": 16,
                "crossTimeWithoutRealTime": 16,
                "knownDirection": True,
                "penalty": 5,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": -90, "selected": True}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": False}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [
                                {"angle": 0, "selected": False},
                                {"angle": 90, "selected": False},
                            ],
                        },
                    ]
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "TURN_LEFT",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 0, "to_lane_index": 0},
                        "angle": -45,
                        "angle_override": -90,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 399190430,
                    "nodeId": 284052144,
                    "x": 8.273971790530663,
                    "y": 50.00359047306348,
                    "direction": False,
                },
                "street": 5,
                "altStreets": [4],
                "distance": 158,
                "length": 65,
                "crossTime": 10,
                "crossTimeWithoutRealTime": 10,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 399190429,
                    "nodeId": 309295012,
                    "x": 8.27458476301202,
                    "y": 50.003390345561506,
                    "direction": False,
                },
                "street": 5,
                "altStreets": [4],
                "distance": 168,
                "length": 37,
                "crossTime": 4,
                "crossTimeWithoutRealTime": 4,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 392386961,
                    "nodeId": 79358204,
                    "x": 8.274416454396324,
                    "y": 50.003697642077995,
                    "direction": False,
                },
                "street": 5,
                "altStreets": [4],
                "distance": 172,
                "length": 179,
                "crossTime": 17,
                "crossTimeWithoutRealTime": 17,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 270261228,
                    "nodeId": 225111472,
                    "x": 8.27325020772032,
                    "y": 50.0050858175989,
                    "direction": False,
                },
                "street": 7,
                "altStreets": [6],
                "distance": 189,
                "length": 36,
                "crossTime": 4,
                "crossTimeWithoutRealTime": 4,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 239674002,
                    "nodeId": 79353332,
                    "x": 8.273584842682723,
                    "y": 50.00532475365378,
                    "direction": False,
                },
                "street": 7,
                "altStreets": [6],
                "distance": 193,
                "length": 208,
                "crossTime": 17,
                "crossTimeWithoutRealTime": 17,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 369081994,
                    "nodeId": 205584787,
                    "x": 8.276032753295809,
                    "y": 50.006327055101046,
                    "direction": False,
                },
                "street": 9,
                "altStreets": [8],
                "distance": 210,
                "length": 309,
                "crossTime": 32,
                "crossTimeWithoutRealTime": 32,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": False}],
                        },
                    ]
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "KEEP_LEFT",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 0, "to_lane_index": 0},
                        "angle": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 403833198,
                    "nodeId": 225111842,
                    "x": 8.27967572957318,
                    "y": 50.00781791594246,
                    "direction": True,
                },
                "street": 10,
                "distance": 242,
                "length": 77,
                "crossTime": 8,
                "crossTimeWithoutRealTime": 8,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "entrySegment": {"segment_id": 369081994, "segment_direction": False},
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403833199,
                    "nodeId": 312426534,
                    "x": 8.280588422753961,
                    "y": 50.00817553744451,
                    "direction": True,
                },
                "street": 10,
                "distance": 250,
                "length": 41,
                "crossTime": 5,
                "crossTimeWithoutRealTime": 4,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "entrySegment": {"segment_id": 369081994, "segment_direction": False},
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 239540450,
                    "nodeId": 205500150,
                    "x": 8.281030654908028,
                    "y": 50.008406125706664,
                    "direction": True,
                },
                "street": 11,
                "distance": 255,
                "length": 38,
                "crossTime": 6,
                "crossTimeWithoutRealTime": 5,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 239540443,
                    "nodeId": 205500121,
                    "x": 8.281298742764584,
                    "y": 50.00867084273389,
                    "direction": True,
                },
                "street": 11,
                "distance": 261,
                "length": 17,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 2,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": -45, "selected": False}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [
                                {"angle": 45, "selected": True},
                                {"angle": -45, "selected": False},
                            ],
                        },
                    ]
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "entrySegment": {"segment_id": 239540450, "segment_direction": True},
                "instruction": {
                    "opcode": "KEEP_RIGHT",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 1, "to_lane_index": 1},
                        "angle": 45,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 416527190,
                    "nodeId": 205500130,
                    "x": 8.281234434580242,
                    "y": 50.00881377267493,
                    "direction": True,
                },
                "street": 13,
                "altStreets": [12],
                "distance": 263,
                "length": 72,
                "crossTime": 7,
                "crossTimeWithoutRealTime": 7,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 257351336,
                    "nodeId": 79357623,
                    "x": 8.28098937901436,
                    "y": 50.00943918092699,
                    "direction": False,
                },
                "street": 13,
                "altStreets": [12],
                "distance": 270,
                "length": 148,
                "crossTime": 13,
                "crossTimeWithoutRealTime": 13,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 188953304,
                    "nodeId": 79356765,
                    "x": 8.280682992090153,
                    "y": 50.01073476651955,
                    "direction": True,
                },
                "street": 13,
                "altStreets": [12],
                "distance": 283,
                "length": 62,
                "crossTime": 8,
                "crossTimeWithoutRealTime": 8,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "ROUNDABOUT_ENTER", "arg": 2},
            },
            {
                "path": {
                    "segmentId": 405910183,
                    "nodeId": 313820661,
                    "x": 8.2813478562369,
                    "y": 50.01108070814998,
                    "direction": True,
                },
                "street": 11,
                "distance": 291,
                "length": 8,
                "crossTime": 1,
                "crossTimeWithoutRealTime": 1,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
            },
            {
                "path": {
                    "segmentId": 405910184,
                    "nodeId": 313820662,
                    "x": 8.2814609537597,
                    "y": 50.011079077743,
                    "direction": True,
                },
                "street": 11,
                "distance": 292,
                "length": 23,
                "crossTime": 3,
                "crossTimeWithoutRealTime": 3,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
            },
            {
                "path": {
                    "segmentId": 405910185,
                    "nodeId": 313820663,
                    "x": 8.2816835034332,
                    "y": 50.011211538476026,
                    "direction": True,
                },
                "street": 11,
                "distance": 295,
                "length": 9,
                "crossTime": 1,
                "crossTimeWithoutRealTime": 1,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "ROUNDABOUT_EXIT", "arg": 2},
            },
            {
                "path": {
                    "segmentId": 72861035,
                    "nodeId": 313820656,
                    "x": 8.2817056796749,
                    "y": 50.01129154713299,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 296,
                "length": 42,
                "crossTime": 5,
                "crossTimeWithoutRealTime": 5,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72858815,
                    "nodeId": 79355011,
                    "x": 8.281870412588123,
                    "y": 50.01164604939817,
                    "direction": False,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 301,
                "length": 28,
                "crossTime": 3,
                "crossTimeWithoutRealTime": 3,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72858814,
                    "nodeId": 79355010,
                    "x": 8.281943391027694,
                    "y": 50.0118944330428,
                    "direction": False,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 304,
                "length": 79,
                "crossTime": 7,
                "crossTimeWithoutRealTime": 7,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72857212,
                    "nodeId": 79355008,
                    "x": 8.28224111622832,
                    "y": 50.01257872283312,
                    "direction": False,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 311,
                "length": 97,
                "crossTime": 8,
                "crossTimeWithoutRealTime": 8,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 398640564,
                    "nodeId": 79355007,
                    "x": 8.282603214445347,
                    "y": 50.01341424986179,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 319,
                "length": 187,
                "crossTime": 15,
                "crossTimeWithoutRealTime": 15,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 398640565,
                    "nodeId": 308918826,
                    "x": 8.283469567957145,
                    "y": 50.01499649744738,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 334,
                "length": 64,
                "crossTime": 5,
                "crossTimeWithoutRealTime": 5,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72858822,
                    "nodeId": 79356588,
                    "x": 8.283965217828909,
                    "y": 50.01547503651856,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 339,
                "length": 23,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 2,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 398513278,
                    "nodeId": 79356589,
                    "x": 8.28415699577346,
                    "y": 50.01563532507227,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 341,
                "length": 19,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 2,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 398513280,
                    "nodeId": 308831979,
                    "x": 8.284319026554906,
                    "y": 50.01577041640963,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 343,
                "length": 113,
                "crossTime": 10,
                "crossTimeWithoutRealTime": 10,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72862730,
                    "nodeId": 79358197,
                    "x": 8.285279500246174,
                    "y": 50.01657119272344,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 353,
                "length": 56,
                "crossTime": 5,
                "crossTimeWithoutRealTime": 5,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 359201998,
                    "nodeId": 79355060,
                    "x": 8.285704630375077,
                    "y": 50.01699172400254,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 358,
                "length": 87,
                "crossTime": 7,
                "crossTimeWithoutRealTime": 7,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 359202001,
                    "nodeId": 283273243,
                    "x": 8.286282646417748,
                    "y": 50.01767938812136,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 365,
                "length": 31,
                "crossTime": 3,
                "crossTimeWithoutRealTime": 3,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 359202002,
                    "nodeId": 283273245,
                    "x": 8.286489544612841,
                    "y": 50.017924908846936,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 368,
                "length": 72,
                "crossTime": 6,
                "crossTimeWithoutRealTime": 6,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 369982948,
                    "nodeId": 79353652,
                    "x": 8.286934939940569,
                    "y": 50.01850240828643,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 374,
                "length": 39,
                "crossTime": 4,
                "crossTimeWithoutRealTime": 4,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 369982949,
                    "nodeId": 290265373,
                    "x": 8.28721674105569,
                    "y": 50.018805262484385,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 378,
                "length": 15,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 2,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 359202193,
                    "nodeId": 283273358,
                    "x": 8.287313925309153,
                    "y": 50.01892364901965,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 380,
                "length": 34,
                "crossTime": 4,
                "crossTimeWithoutRealTime": 4,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 359202190,
                    "nodeId": 283273356,
                    "x": 8.28752922463611,
                    "y": 50.019200053936416,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 384,
                "length": 8,
                "crossTime": 1,
                "crossTimeWithoutRealTime": 1,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 359202111,
                    "nodeId": 283273312,
                    "x": 8.28757583140188,
                    "y": 50.01926117012916,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 385,
                "length": 48,
                "crossTime": 13,
                "crossTimeWithoutRealTime": 13,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": -90, "selected": False}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [
                                {"angle": 0, "selected": True},
                                {"angle": 90, "selected": False},
                            ],
                        },
                    ],
                    "enable_voice_for_instruction": False,
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "NONE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 1, "to_lane_index": 2},
                        "angle": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 420571611,
                    "nodeId": 174344265,
                    "x": 8.287890559637065,
                    "y": 50.01964560749178,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 398,
                "length": 8,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 2,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "entrySegment": {"segment_id": 359202111, "segment_direction": True},
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 420571706,
                    "nodeId": 323291959,
                    "x": 8.287942185469513,
                    "y": 50.01970657605405,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 400,
                "length": 376,
                "crossTime": 28,
                "crossTimeWithoutRealTime": 28,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 420571708,
                    "nodeId": 323292020,
                    "x": 8.289386510174873,
                    "y": 50.02294373296669,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 428,
                "length": 20,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 1,
                "knownDirection": True,
                "penalty": 6,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 420572000,
                    "nodeId": 323291962,
                    "x": 8.289451539417117,
                    "y": 50.023119952514335,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 430,
                "length": 331,
                "crossTime": 25,
                "crossTimeWithoutRealTime": 25,
                "knownDirection": True,
                "penalty": 8,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 420572105,
                    "nodeId": 323292224,
                    "x": 8.291147001107324,
                    "y": 50.02588207737042,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 455,
                "length": 432,
                "crossTime": 28,
                "crossTimeWithoutRealTime": 28,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 420572106,
                    "nodeId": 323292298,
                    "x": 8.293392365649517,
                    "y": 50.029480847228186,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 483,
                "length": 28,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 2,
                "knownDirection": True,
                "penalty": 6,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403456941,
                    "nodeId": 323292225,
                    "x": 8.293529878657477,
                    "y": 50.029718589523696,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 485,
                "length": 43,
                "crossTime": 3,
                "crossTimeWithoutRealTime": 3,
                "knownDirection": True,
                "penalty": 6,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 45, "selected": False}],
                        },
                    ]
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "CONTINUE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 0, "to_lane_index": 0},
                        "angle": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 403456984,
                    "nodeId": 312171749,
                    "x": 8.293760503833154,
                    "y": 50.03007362370881,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 488,
                "length": 108,
                "crossTime": 6,
                "crossTimeWithoutRealTime": 6,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403456985,
                    "nodeId": 312171771,
                    "x": 8.29435285802704,
                    "y": 50.030968909449435,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 494,
                "length": 46,
                "crossTime": 3,
                "crossTimeWithoutRealTime": 3,
                "knownDirection": True,
                "penalty": 6,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 45, "selected": False}],
                        },
                    ],
                    "enable_voice_for_instruction": False,
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "NONE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 0, "to_lane_index": 0},
                        "angle": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 403457477,
                    "nodeId": 312171938,
                    "x": 8.294596792107003,
                    "y": 50.031353997435836,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 497,
                "length": 215,
                "crossTime": 11,
                "crossTimeWithoutRealTime": 11,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403457478,
                    "nodeId": 312172067,
                    "x": 8.295513831213526,
                    "y": 50.033195695906976,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 508,
                "length": 110,
                "crossTime": 6,
                "crossTimeWithoutRealTime": 6,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403646272,
                    "nodeId": 214044048,
                    "x": 8.295886740089179,
                    "y": 50.034156514171585,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 514,
                "length": 449,
                "crossTime": 19,
                "crossTimeWithoutRealTime": 19,
                "knownDirection": True,
                "penalty": 4,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72857660,
                    "nodeId": 79355475,
                    "x": 8.297822550832048,
                    "y": 50.03799377196168,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 533,
                "length": 163,
                "crossTime": 6,
                "crossTimeWithoutRealTime": 6,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 270260191,
                    "nodeId": 152542831,
                    "x": 8.298357205225384,
                    "y": 50.039416455948285,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 539,
                "length": 221,
                "crossTime": 9,
                "crossTimeWithoutRealTime": 9,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 391255020,
                    "nodeId": 79353453,
                    "x": 8.298718482256245,
                    "y": 50.04139157351876,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 548,
                "length": 356,
                "crossTime": 14,
                "crossTimeWithoutRealTime": 14,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72856088,
                    "nodeId": 232259579,
                    "x": 8.29805632622561,
                    "y": 50.04454535961542,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 562,
                "length": 150,
                "crossTime": 7,
                "crossTimeWithoutRealTime": 6,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 270259997,
                    "nodeId": 232259577,
                    "x": 8.297155103996614,
                    "y": 50.04576659144225,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 569,
                "length": 158,
                "crossTime": 7,
                "crossTimeWithoutRealTime": 7,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [{"angle": 45, "selected": False}],
                        },
                    ],
                    "enable_voice_for_instruction": False,
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "NONE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 0, "to_lane_index": 1},
                        "angle": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 403644391,
                    "nodeId": 79353397,
                    "x": 8.29600135584082,
                    "y": 50.04697724849803,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 576,
                "length": 301,
                "crossTime": 12,
                "crossTimeWithoutRealTime": 12,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72856105,
                    "nodeId": 79353303,
                    "x": 8.293654102615042,
                    "y": 50.04922412977821,
                    "direction": True,
                },
                "street": 16,
                "distance": 588,
                "length": 70,
                "crossTime": 3,
                "crossTimeWithoutRealTime": 3,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [{"angle": 45, "selected": False}],
                        },
                    ],
                    "enable_voice_for_instruction": False,
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "NONE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 0, "to_lane_index": 1},
                        "angle": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 270468796,
                    "nodeId": 79353310,
                    "x": 8.29308286073319,
                    "y": 50.04973165478949,
                    "direction": True,
                },
                "street": 16,
                "distance": 591,
                "length": 108,
                "crossTime": 4,
                "crossTimeWithoutRealTime": 4,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403644528,
                    "nodeId": 79353306,
                    "x": 8.292173843576604,
                    "y": 50.050504605307545,
                    "direction": True,
                },
                "street": 16,
                "distance": 595,
                "length": 324,
                "crossTime": 12,
                "crossTimeWithoutRealTime": 12,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403644909,
                    "nodeId": 216801994,
                    "x": 8.289468359393958,
                    "y": 50.05283882466332,
                    "direction": True,
                },
                "street": 16,
                "distance": 607,
                "length": 208,
                "crossTime": 8,
                "crossTimeWithoutRealTime": 8,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403645057,
                    "nodeId": 312297451,
                    "x": 8.28805483524311,
                    "y": 50.05446799359876,
                    "direction": True,
                },
                "street": 16,
                "distance": 615,
                "length": 871,
                "crossTime": 35,
                "crossTimeWithoutRealTime": 35,
                "knownDirection": True,
                "penalty": 4,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403645103,
                    "nodeId": 312297570,
                    "x": 8.282227183044732,
                    "y": 50.06121432712545,
                    "direction": True,
                },
                "street": 18,
                "altStreets": [17],
                "distance": 650,
                "length": 358,
                "crossTime": 14,
                "crossTimeWithoutRealTime": 14,
                "knownDirection": True,
                "penalty": 4,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [{"angle": 45, "selected": False}],
                        },
                    ],
                    "enable_voice_for_instruction": False,
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "NONE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 0, "to_lane_index": 1},
                        "angle": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 403645289,
                    "nodeId": 312297615,
                    "x": 8.277999361532887,
                    "y": 50.06292565734028,
                    "direction": True,
                },
                "street": 18,
                "altStreets": [17],
                "distance": 664,
                "length": 277,
                "crossTime": 12,
                "crossTimeWithoutRealTime": 12,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403645290,
                    "nodeId": 312297732,
                    "x": 8.27463742134867,
                    "y": 50.06415295898346,
                    "direction": True,
                },
                "street": 18,
                "altStreets": [17],
                "distance": 676,
                "length": 32,
                "crossTime": 1,
                "crossTimeWithoutRealTime": 1,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403645382,
                    "nodeId": 312297731,
                    "x": 8.27425321254867,
                    "y": 50.064296020265736,
                    "direction": True,
                },
                "street": 19,
                "altStreets": [17],
                "distance": 677,
                "length": 412,
                "crossTime": 20,
                "crossTimeWithoutRealTime": 20,
                "knownDirection": True,
                "penalty": 4,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403645384,
                    "nodeId": 312297772,
                    "x": 8.269241769018308,
                    "y": 50.06610874780491,
                    "direction": True,
                },
                "street": 19,
                "altStreets": [17],
                "distance": 697,
                "length": 41,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 2,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [{"angle": 45, "selected": False}],
                        },
                    ],
                    "enable_voice_for_instruction": False,
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "NONE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 0, "to_lane_index": 1},
                        "angle": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 403645575,
                    "nodeId": 312297803,
                    "x": 8.26874406645578,
                    "y": 50.06628877186283,
                    "direction": True,
                },
                "street": 19,
                "altStreets": [17],
                "distance": 699,
                "length": 565,
                "crossTime": 35,
                "crossTimeWithoutRealTime": 35,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403645505,
                    "nodeId": 312297926,
                    "x": 8.262006484131975,
                    "y": 50.06891731088396,
                    "direction": True,
                },
                "street": 19,
                "altStreets": [17],
                "distance": 734,
                "length": 94,
                "crossTime": 8,
                "crossTimeWithoutRealTime": 7,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": 0, "selected": False}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [
                                {"angle": 0, "selected": False},
                                {"angle": 0, "selected": True},
                            ],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [{"angle": 45, "selected": False}],
                        },
                    ],
                    "enable_voice_for_instruction": False,
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "NONE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 0, "to_lane_index": 1},
                        "angle": 0,
                        "enable_display": True,
                        "enable_voice": False,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 403646403,
                    "nodeId": 312297993,
                    "x": 8.261065777583108,
                    "y": 50.069508069042826,
                    "direction": True,
                },
                "street": 19,
                "altStreets": [17],
                "distance": 742,
                "length": 321,
                "crossTime": 26,
                "crossTimeWithoutRealTime": 26,
                "knownDirection": True,
                "penalty": 4,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": -45, "selected": False}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": -45, "selected": False}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                    ]
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "CONTINUE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 2, "to_lane_index": 2},
                        "angle": 45,
                        "angle_override": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 319869982,
                    "nodeId": 79354101,
                    "x": 8.258151635527357,
                    "y": 50.07169588488001,
                    "direction": True,
                },
                "street": 21,
                "altStreets": [20],
                "distance": 768,
                "length": 24,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 2,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 392456901,
                    "nodeId": 258526097,
                    "x": 8.2579690105894,
                    "y": 50.07187605329073,
                    "direction": True,
                },
                "street": 22,
                "altStreets": [20],
                "distance": 770,
                "length": 38,
                "crossTime": 3,
                "crossTimeWithoutRealTime": 3,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 392456904,
                    "nodeId": 304758949,
                    "x": 8.257601588468507,
                    "y": 50.072117516562244,
                    "direction": True,
                },
                "street": 22,
                "altStreets": [20],
                "distance": 773,
                "length": 104,
                "crossTime": 7,
                "crossTimeWithoutRealTime": 7,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 392456905,
                    "nodeId": 304758951,
                    "x": 8.256560593230622,
                    "y": 50.07276745207503,
                    "direction": True,
                },
                "street": 22,
                "altStreets": [20],
                "distance": 780,
                "length": 132,
                "crossTime": 10,
                "crossTimeWithoutRealTime": 10,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72857995,
                    "nodeId": 79353501,
                    "x": 8.255321646661743,
                    "y": 50.07364275376407,
                    "direction": False,
                },
                "street": 22,
                "altStreets": [20],
                "distance": 790,
                "length": 123,
                "crossTime": 16,
                "crossTimeWithoutRealTime": 16,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [
                                {"angle": -90, "selected": False},
                                {"angle": -180, "selected": False},
                            ],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [{"angle": 90, "selected": False}],
                        },
                    ],
                    "enable_voice_for_instruction": False,
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "NONE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 1, "to_lane_index": 1},
                        "angle": 0,
                        "enable_display": True,
                        "enable_voice": False,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 72857994,
                    "nodeId": 79355835,
                    "x": 8.254181440178295,
                    "y": 50.07447100898019,
                    "direction": False,
                },
                "street": 22,
                "altStreets": [20],
                "distance": 806,
                "length": 109,
                "crossTime": 10,
                "crossTimeWithoutRealTime": 10,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72858013,
                    "nodeId": 79355850,
                    "x": 8.253178896805343,
                    "y": 50.075209322489115,
                    "direction": False,
                },
                "street": 22,
                "altStreets": [20],
                "distance": 816,
                "length": 159,
                "crossTime": 14,
                "crossTimeWithoutRealTime": 14,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 238123028,
                    "nodeId": 79355857,
                    "x": 8.251714843135225,
                    "y": 50.07628794135344,
                    "direction": False,
                },
                "street": 22,
                "altStreets": [20],
                "distance": 830,
                "length": 20,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 2,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 238123027,
                    "nodeId": 204585735,
                    "x": 8.251541672219897,
                    "y": 50.076426172858824,
                    "direction": False,
                },
                "street": 22,
                "altStreets": [20],
                "distance": 832,
                "length": 142,
                "crossTime": 13,
                "crossTimeWithoutRealTime": 13,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72862880,
                    "nodeId": 79358062,
                    "x": 8.250227969999997,
                    "y": 50.07738830905831,
                    "direction": False,
                },
                "street": 22,
                "altStreets": [20],
                "distance": 845,
                "length": 46,
                "crossTime": 4,
                "crossTimeWithoutRealTime": 4,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 241124839,
                    "nodeId": 79358269,
                    "x": 8.249803092149582,
                    "y": 50.07769683498676,
                    "direction": False,
                },
                "street": 22,
                "altStreets": [20],
                "distance": 849,
                "length": 75,
                "crossTime": 8,
                "crossTimeWithoutRealTime": 8,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 241124838,
                    "nodeId": 206526997,
                    "x": 8.249134843004203,
                    "y": 50.07821624167377,
                    "direction": False,
                },
                "street": 22,
                "altStreets": [20],
                "distance": 857,
                "length": 13,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 2,
                "knownDirection": True,
                "penalty": 6,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "TURN_LEFT", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72863165,
                    "nodeId": 79358414,
                    "x": 8.24901572883606,
                    "y": 50.078303885124676,
                    "direction": True,
                },
                "street": 24,
                "altStreets": [23],
                "distance": 859,
                "length": 63,
                "crossTime": 9,
                "crossTimeWithoutRealTime": 9,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72864129,
                    "nodeId": 79358575,
                    "x": 8.24814074994057,
                    "y": 50.078263101664994,
                    "direction": True,
                },
                "street": 24,
                "altStreets": [23],
                "distance": 868,
                "length": 21,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 2,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 289953136,
                    "nodeId": 79359498,
                    "x": 8.247843672467797,
                    "y": 50.078272143791274,
                    "direction": True,
                },
                "street": 24,
                "altStreets": [23],
                "distance": 870,
                "length": 100,
                "crossTime": 10,
                "crossTimeWithoutRealTime": 10,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 408947081,
                    "nodeId": 239296301,
                    "x": 8.24644856601507,
                    "y": 50.0782336621307,
                    "direction": True,
                },
                "street": 24,
                "altStreets": [23],
                "distance": 880,
                "length": 84,
                "crossTime": 33,
                "crossTimeWithoutRealTime": 33,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 408947082,
                    "nodeId": 315848979,
                    "x": 8.245279289684236,
                    "y": 50.07815929784913,
                    "direction": True,
                },
                "street": 11,
                "distance": 913,
                "length": 11,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 2,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 409751224,
                    "nodeId": 79359497,
                    "x": 8.245128395879131,
                    "y": 50.07814502445939,
                    "direction": True,
                },
                "street": 24,
                "altStreets": [23],
                "distance": 915,
                "length": 90,
                "crossTime": 13,
                "crossTimeWithoutRealTime": 11,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 409751225,
                    "nodeId": 316335318,
                    "x": 8.243880042685669,
                    "y": 50.07807934305053,
                    "direction": True,
                },
                "street": 24,
                "altStreets": [23],
                "distance": 928,
                "length": 109,
                "crossTime": 35,
                "crossTimeWithoutRealTime": 35,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": -90, "selected": False}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 3,
                            "angle_object": [
                                {"angle": 90, "selected": False},
                                {"angle": 0, "selected": True},
                            ],
                        },
                    ],
                    "enable_voice_for_instruction": False,
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "NONE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 1, "to_lane_index": 3},
                        "angle": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 258967045,
                    "nodeId": 79360061,
                    "x": 8.24236944,
                    "y": 50.0779953,
                    "direction": True,
                },
                "street": 24,
                "altStreets": [23],
                "distance": 963,
                "length": 69,
                "crossTime": 8,
                "crossTimeWithoutRealTime": 8,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 310137478,
                    "nodeId": 217863803,
                    "x": 8.24141160513036,
                    "y": 50.07794137500822,
                    "direction": True,
                },
                "street": 24,
                "altStreets": [23],
                "distance": 971,
                "length": 10,
                "crossTime": 1,
                "crossTimeWithoutRealTime": 1,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 310137479,
                    "nodeId": 252227655,
                    "x": 8.241277972353426,
                    "y": 50.07793385163309,
                    "direction": True,
                },
                "street": 24,
                "altStreets": [23],
                "distance": 972,
                "length": 77,
                "crossTime": 13,
                "crossTimeWithoutRealTime": 13,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 296420648,
                    "nodeId": 243411265,
                    "x": 8.240210861336173,
                    "y": 50.07788020660904,
                    "direction": True,
                },
                "street": 24,
                "altStreets": [23],
                "distance": 985,
                "length": 9,
                "crossTime": 1,
                "crossTimeWithoutRealTime": 1,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72864751,
                    "nodeId": 92813486,
                    "x": 8.240081530382582,
                    "y": 50.07787628925589,
                    "direction": False,
                },
                "street": 24,
                "altStreets": [23],
                "distance": 986,
                "length": 28,
                "crossTime": 3,
                "crossTimeWithoutRealTime": 3,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72864325,
                    "nodeId": 79359289,
                    "x": 8.239685606729893,
                    "y": 50.07785445485039,
                    "direction": False,
                },
                "street": 24,
                "altStreets": [23],
                "distance": 989,
                "length": 103,
                "crossTime": 16,
                "crossTimeWithoutRealTime": 16,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72867508,
                    "nodeId": 79359709,
                    "x": 8.238250290118858,
                    "y": 50.0777773810518,
                    "direction": False,
                },
                "street": 24,
                "altStreets": [23],
                "distance": 1005,
                "length": 74,
                "crossTime": 11,
                "crossTimeWithoutRealTime": 11,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": -90, "selected": False}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": False}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [{"angle": 0, "selected": False}],
                        },
                        {
                            "lane_index": 3,
                            "angle_object": [{"angle": 90, "selected": False}],
                        },
                        {
                            "lane_index": 4,
                            "angle_object": [
                                {"angle": 90, "selected": False},
                                {"angle": 90, "selected": True},
                            ],
                        },
                    ]
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "TURN_RIGHT",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 3, "to_lane_index": 4},
                        "angle": 45,
                        "angle_override": 90,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 388536728,
                    "nodeId": 79361694,
                    "x": 8.237228705551548,
                    "y": 50.07771043947438,
                    "direction": False,
                },
                "street": 26,
                "altStreets": [25],
                "distance": 1016,
                "length": 88,
                "crossTime": 20,
                "crossTimeWithoutRealTime": 20,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 2,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": 0, "selected": False}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": False}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [{"angle": 45, "selected": True}],
                        },
                    ]
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "KEEP_RIGHT",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 2, "to_lane_index": 2},
                        "angle": 45,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 388536726,
                    "nodeId": 302254532,
                    "x": 8.236684292492537,
                    "y": 50.07827361403733,
                    "direction": True,
                },
                "street": 11,
                "distance": 1036,
                "length": 75,
                "crossTime": 12,
                "crossTimeWithoutRealTime": 12,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 1,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "TURN_RIGHT", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 388536832,
                    "nodeId": 302254591,
                    "x": 8.236717197938464,
                    "y": 50.078941219926016,
                    "direction": True,
                },
                "street": 27,
                "distance": 1048,
                "length": 52,
                "crossTime": 8,
                "crossTimeWithoutRealTime": 6,
                "knownDirection": True,
                "penalty": 3638,
                "roadType": 1,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 252684065,
                    "nodeId": 178071243,
                    "x": 8.237438475187458,
                    "y": 50.078971128845915,
                    "direction": True,
                },
                "street": 27,
                "distance": 1056,
                "length": 198,
                "crossTime": 35,
                "crossTimeWithoutRealTime": 35,
                "knownDirection": True,
                "penalty": 3611,
                "roadType": 1,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "APPROACHING_DESTINATION", "arg": 0},
            },
        ],
        "streetNames": [
            "Ernst-Ludwig-Straße",
            "Diether-von-Isenburg-Straße",
            "Peter-Altmeier-Allee",
            "B40 - Peter-Altmeier-Allee",
            "Rheinstraße",
            "B40 - Rheinstraße",
            "Theodor-Heuss-Brücke",
            "B40 - Theodor-Heuss-Brücke",
            "Theodor-Heuss-Brücke",
            "B40 - Theodor-Heuss-Brücke",
            "B40",
            None,
            "Ludwigsrampe",
            "B455 - Ludwigsrampe",
            "Boelckestraße",
            "B455 - Boelckestraße",
            "B455",
            "Berliner Straße",
            "B455 - Berliner Straße",
            "B54 - Berliner Straße",
            "Frankfurter Straße",
            "> Stadtmitte",
            "L3037 - Frankfurter Straße",
            "Rheinstraße",
            "L3037 - Rheinstraße",
            "Schwalbacher Straße",
            "K651 - Schwalbacher Straße",
            "Luisenstraße",
        ],
        "fromFraction": 0.04088647496562475,
        "toFraction": 0.9701975545356646,
        "sameFromSegment": True,
        "sameToSegment": True,
        "tollMeters": 0,
        "preferedRouteId": -1,
        "isInvalid": False,
        "isBlocked": False,
        "serverUniqueId": "m5956273620021076028",
        "displayRoute": True,
        "astarVisited": 116911,
        "astarResult": "UNKNOWN",
        "isRestricted": False,
        "avoidStatus": "MAYBE",
        "passesThroughDangerArea": False,
        "distanceFromSource": 16,
        "distanceFromTarget": 0,
        "minPassengers": 0,
        "hovIndex": -1,
        "preRefinedRouteIndex": -1,
        "blockedRouteUid": -1,
        "alternativeRouteUuid": "2db129a9-06c2-4a8d-adf5-b167fc9d8495",
        "serverTilesVersion": 1691214914000,
        "rankBeforeReordering": 0,
        "serverType": "LIVEMAP",
        "routeType": ["Best"],
        "routeAttr": ["RestrictedZone"],
        "astarCost": 4879,
        "totalRouteTime": 1091,
        "totalRouteTimeWithoutRealtime": 1082,
        "carbonEmissionsGrams": 0,
        "creationMechanismSet": ["ASTAR", "AERIAL_TIME_HEURISTIC"],
        "laneTypes": [],
        "areas": ["Umweltzone"],
        "requiredPermits": [],
        "etaHistograms": [],
        "tollPrice": 0.0,
        "isInvalidForPrivateVehicle": False,
        "costInfo": {
            "unbiasedAstarCost": 0,
            "tollAsSeconds": 0,
            "keepForReordering": False,
        },
        "destinationInformation": {
            "segment_id": 252684065,
            "street_id": 7561951,
            "city_id": 27809,
            "country_id": 81,
            "street_name": "Luisenstraße",
            "city_name": "Wiesbaden",
        },
        "routeName": "B455 - Boelckestraße Wiesbaden",
        "totalRouteTimeWithoutMl": 1091,
        "open": False,
    },
    "coords": [
        {"x": 8.267085132265365, "y": 50.00715815209651, "z": "NaN"},
        {"x": 8.267619736752678, "y": 50.00692844650572, "z": "NaN"},
        {"x": 8.268418364486765, "y": 50.006461713952184, "z": "NaN"},
        {"x": 8.268418364486765, "y": 50.006461713952184, "z": "NaN"},
        {"x": 8.268526993951816, "y": 50.00647765964532, "z": "NaN"},
        {"x": 8.26905337747097, "y": 50.00678493642532, "z": "NaN"},
        {"x": 8.269656225245912, "y": 50.00712860410831, "z": "NaN"},
        {"x": 8.270667599646012, "y": 50.007563160951484, "z": "NaN"},
        {"x": 8.270667599646012, "y": 50.007563160951484, "z": "NaN"},
        {"x": 8.271037978316048, "y": 50.00715250234093, "z": "NaN"},
        {"x": 8.271365441641864, "y": 50.00671382766804, "z": "NaN"},
        {"x": 8.271431155762743, "y": 50.00660824174283, "z": "NaN"},
        {"x": 8.271494187674573, "y": 50.006420341318844, "z": "NaN"},
        {"x": 8.271494187674573, "y": 50.006420341318844, "z": "NaN"},
        {"x": 8.271637685856833, "y": 50.00611392414356, "z": "NaN"},
        {"x": 8.271637685856833, "y": 50.00611392414356, "z": "NaN"},
        {"x": 8.27170798235573, "y": 50.00600453636846, "z": "NaN"},
        {"x": 8.271787666586183, "y": 50.00591368004332, "z": "NaN"},
        {"x": 8.273044504485089, "y": 50.00466110951561, "z": "NaN"},
        {"x": 8.273044504485089, "y": 50.00466110951561, "z": "NaN"},
        {"x": 8.273474809463597, "y": 50.00421243931527, "z": "NaN"},
        {"x": 8.273716018706539, "y": 50.00393185031846, "z": "NaN"},
        {"x": 8.273971790530663, "y": 50.00359047306348, "z": "NaN"},
        {"x": 8.273971790530663, "y": 50.00359047306348, "z": "NaN"},
        {"x": 8.274058150504036, "y": 50.003546367736924, "z": "NaN"},
        {"x": 8.274210941546816, "y": 50.003356526900085, "z": "NaN"},
        {"x": 8.274288378915841, "y": 50.00331492185268, "z": "NaN"},
        {"x": 8.274394326171992, "y": 50.003298544117264, "z": "NaN"},
        {"x": 8.274480156860436, "y": 50.00331319788084, "z": "NaN"},
        {"x": 8.274545870981296, "y": 50.00334681532102, "z": "NaN"},
        {"x": 8.27458476301202, "y": 50.003390345561506, "z": "NaN"},
        {"x": 8.27458476301202, "y": 50.003390345561506, "z": "NaN"},
        {"x": 8.274594150743576, "y": 50.00343689270589, "z": "NaN"},
        {"x": 8.274576884023038, "y": 50.003493999094275, "z": "NaN"},
        {"x": 8.274488538763608, "y": 50.00359204952739, "z": "NaN"},
        {"x": 8.274416454396324, "y": 50.00369764207802, "z": "NaN"},
        {"x": 8.274416454396324, "y": 50.003697642077995, "z": "NaN"},
        {"x": 8.273315251288938, "y": 50.00481947302412, "z": "NaN"},
        {"x": 8.273255572138392, "y": 50.00490092807522, "z": "NaN"},
        {"x": 8.273228750048222, "y": 50.00500436286148, "z": "NaN"},
        {"x": 8.27325020772032, "y": 50.0050858175989, "z": "NaN"},
        {"x": 8.27325020772032, "y": 50.0050858175989, "z": "NaN"},
        {"x": 8.273308606093535, "y": 50.00515586872543, "z": "NaN"},
        {"x": 8.273381086064076, "y": 50.00520954266566, "z": "NaN"},
        {"x": 8.273584842682723, "y": 50.00532475365378, "z": "NaN"},
        {"x": 8.273584842682723, "y": 50.00532475365378, "z": "NaN"},
        {"x": 8.276032753295809, "y": 50.006327055101046, "z": "NaN"},
        {"x": 8.276032753295809, "y": 50.006327055101046, "z": "NaN"},
        {"x": 8.27967572957318, "y": 50.00781791594246, "z": "NaN"},
        {"x": 8.27967572957318, "y": 50.00781791594246, "z": "NaN"},
        {"x": 8.280186377466098, "y": 50.007979597478894, "z": "NaN"},
        {"x": 8.280588422753961, "y": 50.00817553744451, "z": "NaN"},
        {"x": 8.280588422753961, "y": 50.00817553744451, "z": "NaN"},
        {"x": 8.281030654908028, "y": 50.008406125706664, "z": "NaN"},
        {"x": 8.281030654908028, "y": 50.008406125706664, "z": "NaN"},
        {"x": 8.281167515223444, "y": 50.00846965427605, "z": "NaN"},
        {"x": 8.28125383786892, "y": 50.008529336001615, "z": "NaN"},
        {"x": 8.28129372524024, "y": 50.00858418944403, "z": "NaN"},
        {"x": 8.281298742764584, "y": 50.00867084273389, "z": "NaN"},
        {"x": 8.281298742764584, "y": 50.00867084273389, "z": "NaN"},
        {"x": 8.281272742532217, "y": 50.00874687903089, "z": "NaN"},
        {"x": 8.281234434580242, "y": 50.00881377267493, "z": "NaN"},
        {"x": 8.281234434580242, "y": 50.00881377267493, "z": "NaN"},
        {"x": 8.281176835299384, "y": 50.00902754771364, "z": "NaN"},
        {"x": 8.28098937901436, "y": 50.00943918092699, "z": "NaN"},
        {"x": 8.28098937901436, "y": 50.00943918092699, "z": "NaN"},
        {"x": 8.280677782232422, "y": 50.01019463503255, "z": "NaN"},
        {"x": 8.28062883191784, "y": 50.01034115144297, "z": "NaN"},
        {"x": 8.280615420872714, "y": 50.01046051889425, "z": "NaN"},
        {"x": 8.280625422582977, "y": 50.01058169175515, "z": "NaN"},
        {"x": 8.280644254619675, "y": 50.010657022067114, "z": "NaN"},
        {"x": 8.280682992090153, "y": 50.01073476651955, "z": "NaN"},
        {"x": 8.280682992090153, "y": 50.01073476651955, "z": "NaN"},
        {"x": 8.280826761776888, "y": 50.01085191942355, "z": "NaN"},
        {"x": 8.281045633316053, "y": 50.010974674057934, "z": "NaN"},
        {"x": 8.2813478562369, "y": 50.01108070814998, "z": "NaN"},
        {"x": 8.2813478562369, "y": 50.01108070814998, "z": "NaN"},
        {"x": 8.2814048338205, "y": 50.01107615172001, "z": "NaN"},
        {"x": 8.2814609537597, "y": 50.011079077743, "z": "NaN"},
        {"x": 8.2814609537597, "y": 50.011079077743, "z": "NaN"},
        {"x": 8.281514548394, "y": 50.011089395077995, "z": "NaN"},
        {"x": 8.2815640256469, "y": 50.01110679778399, "z": "NaN"},
        {"x": 8.2816079131098, "y": 50.01113077431699, "z": "NaN"},
        {"x": 8.2816245360294, "y": 50.01114278254401, "z": "NaN"},
        {"x": 8.2816582371136, "y": 50.01117486986799, "z": "NaN"},
        {"x": 8.2816835034332, "y": 50.011211538476026, "z": "NaN"},
        {"x": 8.2816835034332, "y": 50.011211538476026, "z": "NaN"},
        {"x": 8.2816988301225, "y": 50.011249176848, "z": "NaN"},
        {"x": 8.2817056796749, "y": 50.01129154713299, "z": "NaN"},
        {"x": 8.2817056796749, "y": 50.01129154713299, "z": "NaN"},
        {"x": 8.28177031873358, "y": 50.01135396752797, "z": "NaN"},
        {"x": 8.281870412588123, "y": 50.01164604939817, "z": "NaN"},
        {"x": 8.281870412588123, "y": 50.01164604939817, "z": "NaN"},
        {"x": 8.281943391027694, "y": 50.0118944330428, "z": "NaN"},
        {"x": 8.281943391027694, "y": 50.011894433042826, "z": "NaN"},
        {"x": 8.28224111622832, "y": 50.01257872283312, "z": "NaN"},
        {"x": 8.28224111622832, "y": 50.01257872283312, "z": "NaN"},
        {"x": 8.282388637724143, "y": 50.012875834289304, "z": "NaN"},
        {"x": 8.282603214445347, "y": 50.01341424986179, "z": "NaN"},
        {"x": 8.282603214445347, "y": 50.01341424986179, "z": "NaN"},
        {"x": 8.282966653766856, "y": 50.014246746098856, "z": "NaN"},
        {"x": 8.283088694277026, "y": 50.01447598166065, "z": "NaN"},
        {"x": 8.283244262399904, "y": 50.01471641928913, "z": "NaN"},
        {"x": 8.283469567957145, "y": 50.01499649744738, "z": "NaN"},
        {"x": 8.283469567957145, "y": 50.01499649744738, "z": "NaN"},
        {"x": 8.283965217828909, "y": 50.01547503651853, "z": "NaN"},
        {"x": 8.283965217828909, "y": 50.01547503651853, "z": "NaN"},
        {"x": 8.28415699577346, "y": 50.01563532507227, "z": "NaN"},
        {"x": 8.28415699577346, "y": 50.01563532507227, "z": "NaN"},
        {"x": 8.284319026554906, "y": 50.01577041640963, "z": "NaN"},
        {"x": 8.284319026554906, "y": 50.01577041640963, "z": "NaN"},
        {"x": 8.285279500246174, "y": 50.01657119272344, "z": "NaN"},
        {"x": 8.285279500246174, "y": 50.01657119272344, "z": "NaN"},
        {"x": 8.285704630375077, "y": 50.01699172400254, "z": "NaN"},
        {"x": 8.285704630375077, "y": 50.01699172400254, "z": "NaN"},
        {"x": 8.28592658317103, "y": 50.01723128730649, "z": "NaN"},
        {"x": 8.286282646417748, "y": 50.01767938812136, "z": "NaN"},
        {"x": 8.286282646417748, "y": 50.01767938812136, "z": "NaN"},
        {"x": 8.286489544612841, "y": 50.017924908846936, "z": "NaN"},
        {"x": 8.286489544612841, "y": 50.017924908846936, "z": "NaN"},
        {"x": 8.286934939940569, "y": 50.01850240828643, "z": "NaN"},
        {"x": 8.286934939940569, "y": 50.01850240828643, "z": "NaN"},
        {"x": 8.28721674105569, "y": 50.018805262484385, "z": "NaN"},
        {"x": 8.28721674105569, "y": 50.018805262484385, "z": "NaN"},
        {"x": 8.287313925309153, "y": 50.01892364901965, "z": "NaN"},
        {"x": 8.287313925309153, "y": 50.01892364901965, "z": "NaN"},
        {"x": 8.28752922463611, "y": 50.019200053936416, "z": "NaN"},
        {"x": 8.28752922463611, "y": 50.019200053936416, "z": "NaN"},
        {"x": 8.28757583140188, "y": 50.01926117012916, "z": "NaN"},
        {"x": 8.28757583140188, "y": 50.01926117012916, "z": "NaN"},
        {"x": 8.287890559637065, "y": 50.01964560749178, "z": "NaN"},
        {"x": 8.287890559637065, "y": 50.01964560749178, "z": "NaN"},
        {"x": 8.287942185469513, "y": 50.01970657605405, "z": "NaN"},
        {"x": 8.287942185469513, "y": 50.01970657605405, "z": "NaN"},
        {"x": 8.288386121202784, "y": 50.02031418188451, "z": "NaN"},
        {"x": 8.288474725703248, "y": 50.020464504410526, "z": "NaN"},
        {"x": 8.288762971569323, "y": 50.02107934857397, "z": "NaN"},
        {"x": 8.289386510174873, "y": 50.02294373296669, "z": "NaN"},
        {"x": 8.289386510174873, "y": 50.02294373296669, "z": "NaN"},
        {"x": 8.289451539417117, "y": 50.023119952514335, "z": "NaN"},
        {"x": 8.289451539417117, "y": 50.02311995251431, "z": "NaN"},
        {"x": 8.289570316482822, "y": 50.023429057938905, "z": "NaN"},
        {"x": 8.289810374189639, "y": 50.02386848477696, "z": "NaN"},
        {"x": 8.290116146017395, "y": 50.02439493006893, "z": "NaN"},
        {"x": 8.291147001107324, "y": 50.02588207737042, "z": "NaN"},
        {"x": 8.291147001107324, "y": 50.02588207737042, "z": "NaN"},
        {"x": 8.291934542212253, "y": 50.02701324997075, "z": "NaN"},
        {"x": 8.292195710524645, "y": 50.02741193482185, "z": "NaN"},
        {"x": 8.293392365649517, "y": 50.029480847228186, "z": "NaN"},
        {"x": 8.293392365649517, "y": 50.029480847228186, "z": "NaN"},
        {"x": 8.293529878657477, "y": 50.029718589523696, "z": "NaN"},
        {"x": 8.293529878657477, "y": 50.029718589523696, "z": "NaN"},
        {"x": 8.293760503833154, "y": 50.03007362370881, "z": "NaN"},
        {"x": 8.293760503833154, "y": 50.03007362370881, "z": "NaN"},
        {"x": 8.29435285802704, "y": 50.030968909449435, "z": "NaN"},
        {"x": 8.29435285802704, "y": 50.030968909449435, "z": "NaN"},
        {"x": 8.294596792107003, "y": 50.031353997435836, "z": "NaN"},
        {"x": 8.294596792107003, "y": 50.031353997435836, "z": "NaN"},
        {"x": 8.295158193051371, "y": 50.03241083660802, "z": "NaN"},
        {"x": 8.295513831213526, "y": 50.033195695906976, "z": "NaN"},
        {"x": 8.295513831213526, "y": 50.033195695906976, "z": "NaN"},
        {"x": 8.295886740089179, "y": 50.03415651417156, "z": "NaN"},
        {"x": 8.295886740089179, "y": 50.03415651417156, "z": "NaN"},
        {"x": 8.296048594639378, "y": 50.03455185634188, "z": "NaN"},
        {"x": 8.297329097986655, "y": 50.036971163222326, "z": "NaN"},
        {"x": 8.297822550832048, "y": 50.03799377196168, "z": "NaN"},
        {"x": 8.297822550832048, "y": 50.03799377196168, "z": "NaN"},
        {"x": 8.297987954086137, "y": 50.038376943311405, "z": "NaN"},
        {"x": 8.298202083954928, "y": 50.03892771095122, "z": "NaN"},
        {"x": 8.298357205225384, "y": 50.039416455948285, "z": "NaN"},
        {"x": 8.298357205225384, "y": 50.039416455948285, "z": "NaN"},
        {"x": 8.298474401235936, "y": 50.03986187508868, "z": "NaN"},
        {"x": 8.298591953176823, "y": 50.04038962508057, "z": "NaN"},
        {"x": 8.298668628761607, "y": 50.04091945585525, "z": "NaN"},
        {"x": 8.298718482256245, "y": 50.04139157351876, "z": "NaN"},
        {"x": 8.298718482256245, "y": 50.04139157351876, "z": "NaN"},
        {"x": 8.298729402636294, "y": 50.04208380332365, "z": "NaN"},
        {"x": 8.298700089881136, "y": 50.0425572580054, "z": "NaN"},
        {"x": 8.298631774061434, "y": 50.04300546319404, "z": "NaN"},
        {"x": 8.29852509925204, "y": 50.043444692526975, "z": "NaN"},
        {"x": 8.298347345903723, "y": 50.043939899594264, "z": "NaN"},
        {"x": 8.29805632622561, "y": 50.04454535961542, "z": "NaN"},
        {"x": 8.29805632622561, "y": 50.04454535961542, "z": "NaN"},
        {"x": 8.297821373516538, "y": 50.04489588718622, "z": "NaN"},
        {"x": 8.297516327543223, "y": 50.04531396423686, "z": "NaN"},
        {"x": 8.297155103996614, "y": 50.04576659144225, "z": "NaN"},
        {"x": 8.297155103996614, "y": 50.04576659144225, "z": "NaN"},
        {"x": 8.296811582103013, "y": 50.04614714651029, "z": "NaN"},
        {"x": 8.29600135584082, "y": 50.04697724849803, "z": "NaN"},
        {"x": 8.29600135584082, "y": 50.04697724849803, "z": "NaN"},
        {"x": 8.294721739533799, "y": 50.04823327747022, "z": "NaN"},
        {"x": 8.293654102615042, "y": 50.04922412977821, "z": "NaN"},
        {"x": 8.293654102615042, "y": 50.04922412977821, "z": "NaN"},
        {"x": 8.29308286073319, "y": 50.04973165478949, "z": "NaN"},
        {"x": 8.29308286073319, "y": 50.04973165478952, "z": "NaN"},
        {"x": 8.292609576691792, "y": 50.050143965989236, "z": "NaN"},
        {"x": 8.292173843576604, "y": 50.050504605307545, "z": "NaN"},
        {"x": 8.292173843576604, "y": 50.050504605307545, "z": "NaN"},
        {"x": 8.290699493331772, "y": 50.05171766253782, "z": "NaN"},
        {"x": 8.290016871137487, "y": 50.05231871891604, "z": "NaN"},
        {"x": 8.289468359393958, "y": 50.05283882466332, "z": "NaN"},
        {"x": 8.289468359393958, "y": 50.05283882466332, "z": "NaN"},
        {"x": 8.289066028041727, "y": 50.05326420497461, "z": "NaN"},
        {"x": 8.28852288071621, "y": 50.05387126953614, "z": "NaN"},
        {"x": 8.28805483524311, "y": 50.05446799359876, "z": "NaN"},
        {"x": 8.28805483524311, "y": 50.05446799359876, "z": "NaN"},
        {"x": 8.287677649600433, "y": 50.055013046755775, "z": "NaN"},
        {"x": 8.287297781748713, "y": 50.05565280899217, "z": "NaN"},
        {"x": 8.286292288644244, "y": 50.05745365513836, "z": "NaN"},
        {"x": 8.285977380542139, "y": 50.05796132827456, "z": "NaN"},
        {"x": 8.28563074693649, "y": 50.058441713203976, "z": "NaN"},
        {"x": 8.285203961381757, "y": 50.058958281728664, "z": "NaN"},
        {"x": 8.284841548843533, "y": 50.05933880989972, "z": "NaN"},
        {"x": 8.284356069011812, "y": 50.059779630105595, "z": "NaN"},
        {"x": 8.283967148704644, "y": 50.06009905002865, "z": "NaN"},
        {"x": 8.283454846782783, "y": 50.06047873509522, "z": "NaN"},
        {"x": 8.282826262764175, "y": 50.060871500175736, "z": "NaN"},
        {"x": 8.282227183044732, "y": 50.06121432712545, "z": "NaN"},
        {"x": 8.282227183044732, "y": 50.06121432712545, "z": "NaN"},
        {"x": 8.281438515095505, "y": 50.0616006334751, "z": "NaN"},
        {"x": 8.280727631207702, "y": 50.06190600890644, "z": "NaN"},
        {"x": 8.27977256780069, "y": 50.062280860212255, "z": "NaN"},
        {"x": 8.277999361532887, "y": 50.0629256573403, "z": "NaN"},
        {"x": 8.277999361532887, "y": 50.06292565734028, "z": "NaN"},
        {"x": 8.27463742134867, "y": 50.06415295898346, "z": "NaN"},
        {"x": 8.27463742134867, "y": 50.06415295898346, "z": "NaN"},
        {"x": 8.27425321254867, "y": 50.064296020265736, "z": "NaN"},
        {"x": 8.27425321254867, "y": 50.064296020265736, "z": "NaN"},
        {"x": 8.269241769018308, "y": 50.06610874780491, "z": "NaN"},
        {"x": 8.269241769018308, "y": 50.06610874780491, "z": "NaN"},
        {"x": 8.26874406645578, "y": 50.06628877186283, "z": "NaN"},
        {"x": 8.26874406645578, "y": 50.06628877186283, "z": "NaN"},
        {"x": 8.265260081930146, "y": 50.06756563810055, "z": "NaN"},
        {"x": 8.263319838984017, "y": 50.06830444256612, "z": "NaN"},
        {"x": 8.26285279933931, "y": 50.06849963310654, "z": "NaN"},
        {"x": 8.262006484131975, "y": 50.06891731088396, "z": "NaN"},
        {"x": 8.262006484131975, "y": 50.06891731088396, "z": "NaN"},
        {"x": 8.261520372879588, "y": 50.06920085482077, "z": "NaN"},
        {"x": 8.261065777583108, "y": 50.069508069042826, "z": "NaN"},
        {"x": 8.261065777583108, "y": 50.069508069042826, "z": "NaN"},
        {"x": 8.260545283556395, "y": 50.06987157781238, "z": "NaN"},
        {"x": 8.259829916060049, "y": 50.070401123780165, "z": "NaN"},
        {"x": 8.258151635527357, "y": 50.07169588488001, "z": "NaN"},
        {"x": 8.258151635527357, "y": 50.07169588488001, "z": "NaN"},
        {"x": 8.2579690105894, "y": 50.07187605329073, "z": "NaN"},
        {"x": 8.2579690105894, "y": 50.07187605329073, "z": "NaN"},
        {"x": 8.257601588468507, "y": 50.072117516562244, "z": "NaN"},
        {"x": 8.257601588468507, "y": 50.072117516562244, "z": "NaN"},
        {"x": 8.25684851918774, "y": 50.07256361594917, "z": "NaN"},
        {"x": 8.256560593230622, "y": 50.07276745207503, "z": "NaN"},
        {"x": 8.256560593230622, "y": 50.07276745207503, "z": "NaN"},
        {"x": 8.255321646661743, "y": 50.07364275376407, "z": "NaN"},
        {"x": 8.255321646661743, "y": 50.07364275376407, "z": "NaN"},
        {"x": 8.254181440178295, "y": 50.07447100898019, "z": "NaN"},
        {"x": 8.254181440178295, "y": 50.07447100898019, "z": "NaN"},
        {"x": 8.253719057391907, "y": 50.07482548165766, "z": "NaN"},
        {"x": 8.25355775933365, "y": 50.07497285202587, "z": "NaN"},
        {"x": 8.25338847826146, "y": 50.07509880761924, "z": "NaN"},
        {"x": 8.253178896805343, "y": 50.075209322489115, "z": "NaN"},
        {"x": 8.253178896805343, "y": 50.075209322489115, "z": "NaN"},
        {"x": 8.251714843135225, "y": 50.07628794135344, "z": "NaN"},
        {"x": 8.251714843135225, "y": 50.07628794135344, "z": "NaN"},
        {"x": 8.251541672219897, "y": 50.076426172858824, "z": "NaN"},
        {"x": 8.251541672219897, "y": 50.076426172858824, "z": "NaN"},
        {"x": 8.250227969999997, "y": 50.07738830905831, "z": "NaN"},
        {"x": 8.250227969999997, "y": 50.07738830905831, "z": "NaN"},
        {"x": 8.249803092149582, "y": 50.07769683498676, "z": "NaN"},
        {"x": 8.249803092149582, "y": 50.07769683498676, "z": "NaN"},
        {"x": 8.249134843004203, "y": 50.07821624167377, "z": "NaN"},
        {"x": 8.249134843004203, "y": 50.07821624167377, "z": "NaN"},
        {"x": 8.24901572883606, "y": 50.078303885124676, "z": "NaN"},
        {"x": 8.24901572883606, "y": 50.078303885124676, "z": "NaN"},
        {"x": 8.24814074994057, "y": 50.078263101664994, "z": "NaN"},
        {"x": 8.24814074994057, "y": 50.078263101664994, "z": "NaN"},
        {"x": 8.247843672467797, "y": 50.078272143791274, "z": "NaN"},
        {"x": 8.247843672467797, "y": 50.078272143791274, "z": "NaN"},
        {"x": 8.247427751188003, "y": 50.07827915252157, "z": "NaN"},
        {"x": 8.24644856601507, "y": 50.0782336621307, "z": "NaN"},
        {"x": 8.24644856601507, "y": 50.0782336621307, "z": "NaN"},
        {"x": 8.245525298961526, "y": 50.07818744325775, "z": "NaN"},
        {"x": 8.245279289684236, "y": 50.07815929784913, "z": "NaN"},
        {"x": 8.245279289684236, "y": 50.07815929784913, "z": "NaN"},
        {"x": 8.245128395879131, "y": 50.07814502445939, "z": "NaN"},
        {"x": 8.245128395879131, "y": 50.07814502445939, "z": "NaN"},
        {"x": 8.244831189277088, "y": 50.07811792804621, "z": "NaN"},
        {"x": 8.243880042685669, "y": 50.07807934305053, "z": "NaN"},
        {"x": 8.243880042685669, "y": 50.07807934305053, "z": "NaN"},
        {"x": 8.24236944, "y": 50.07799529999999, "z": "NaN"},
        {"x": 8.24236944, "y": 50.0779953, "z": "NaN"},
        {"x": 8.24141160513036, "y": 50.07794137500822, "z": "NaN"},
        {"x": 8.24141160513036, "y": 50.07794137500822, "z": "NaN"},
        {"x": 8.241277972353426, "y": 50.07793385163309, "z": "NaN"},
        {"x": 8.241277972353426, "y": 50.07793385163306, "z": "NaN"},
        {"x": 8.240210861336173, "y": 50.07788020660904, "z": "NaN"},
        {"x": 8.240210861336173, "y": 50.07788020660904, "z": "NaN"},
        {"x": 8.240081530382582, "y": 50.07787628925589, "z": "NaN"},
        {"x": 8.240081530382582, "y": 50.07787628925589, "z": "NaN"},
        {"x": 8.239685606729893, "y": 50.07785445485039, "z": "NaN"},
        {"x": 8.239685606729893, "y": 50.07785445485039, "z": "NaN"},
        {"x": 8.239433946715799, "y": 50.077842100632935, "z": "NaN"},
        {"x": 8.238334383737563, "y": 50.077781979097594, "z": "NaN"},
        {"x": 8.238250290118858, "y": 50.077777381051824, "z": "NaN"},
        {"x": 8.238250290118858, "y": 50.077777381051824, "z": "NaN"},
        {"x": 8.237228705551548, "y": 50.07771043947438, "z": "NaN"},
        {"x": 8.237228705551548, "y": 50.07771043947438, "z": "NaN"},
        {"x": 8.237095735967236, "y": 50.077745076775514, "z": "NaN"},
        {"x": 8.236962161030656, "y": 50.077740562256025, "z": "NaN"},
        {"x": 8.236847161319158, "y": 50.077763369492416, "z": "NaN"},
        {"x": 8.236781447198293, "y": 50.077802959386304, "z": "NaN"},
        {"x": 8.236747919585609, "y": 50.077858040923424, "z": "NaN"},
        {"x": 8.236684292492537, "y": 50.07827361403733, "z": "NaN"},
        {"x": 8.236684292492537, "y": 50.07827361403733, "z": "NaN"},
        {"x": 8.236759126186406, "y": 50.07851775761472, "z": "NaN"},
        {"x": 8.236717197938464, "y": 50.078941219925994, "z": "NaN"},
        {"x": 8.236717197938464, "y": 50.078941219926016, "z": "NaN"},
        {"x": 8.237438475187458, "y": 50.078971128845915, "z": "NaN"},
        {"x": 8.237438475187458, "y": 50.078971128845915, "z": "NaN"},
        {"x": 8.23813710334197, "y": 50.07900719018565, "z": "NaN"},
        {"x": 8.239249346021909, "y": 50.07906572480341, "z": "NaN"},
        {"x": 8.240203630431944, "y": 50.07911915385722, "z": "NaN"},
    ],
}
GET_ROUTE_RESPONSE_COORDS = {
    "response": {
        "results": [
            {
                "path": {
                    "segmentId": 72856060,
                    "nodeId": 79353354,
                    "x": 8.262231178841974,
                    "y": 50.00350434288446,
                    "direction": False,
                },
                "street": 1,
                "altStreets": [0],
                "distance": 0,
                "length": 42,
                "crossTime": 52,
                "crossTimeWithoutRealTime": 52,
                "knownDirection": True,
                "penalty": 6,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "TURN_LEFT", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72857068,
                    "nodeId": 79353353,
                    "x": 8.262884296737077,
                    "y": 50.003263849158074,
                    "direction": True,
                },
                "street": 1,
                "altStreets": [0],
                "distance": 52,
                "length": 83,
                "crossTime": 10,
                "crossTimeWithoutRealTime": 10,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72858741,
                    "nodeId": 79354848,
                    "x": 8.263474564170831,
                    "y": 50.00389912419096,
                    "direction": True,
                },
                "street": 1,
                "altStreets": [0],
                "distance": 62,
                "length": 110,
                "crossTime": 12,
                "crossTimeWithoutRealTime": 12,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72858742,
                    "nodeId": 79354852,
                    "x": 8.264312573037357,
                    "y": 50.004726618565144,
                    "direction": True,
                },
                "street": 1,
                "altStreets": [0],
                "distance": 74,
                "length": 126,
                "crossTime": 33,
                "crossTimeWithoutRealTime": 33,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [
                                {"angle": -90, "selected": False},
                                {"angle": 0, "selected": True},
                                {"angle": -180, "selected": False},
                            ],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [
                                {"angle": 90, "selected": False},
                                {"angle": 0, "selected": True},
                            ],
                        },
                    ],
                    "enable_voice_for_instruction": False,
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "NONE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 0, "to_lane_index": 2},
                        "angle": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 72858739,
                    "nodeId": 79354745,
                    "x": 8.265242629013304,
                    "y": 50.00568941892085,
                    "direction": True,
                },
                "street": 1,
                "altStreets": [0],
                "distance": 107,
                "length": 104,
                "crossTime": 12,
                "crossTimeWithoutRealTime": 12,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72858740,
                    "nodeId": 79356564,
                    "x": 8.266104288659388,
                    "y": 50.00642271162488,
                    "direction": True,
                },
                "street": 1,
                "altStreets": [0],
                "distance": 119,
                "length": 108,
                "crossTime": 15,
                "crossTimeWithoutRealTime": 15,
                "knownDirection": True,
                "penalty": 4,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "TURN_RIGHT", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72856282,
                    "nodeId": 79353550,
                    "x": 8.267026968560463,
                    "y": 50.00718314352199,
                    "direction": True,
                },
                "street": 2,
                "distance": 134,
                "length": 128,
                "crossTime": 23,
                "crossTimeWithoutRealTime": 23,
                "knownDirection": True,
                "penalty": 7,
                "roadType": 1,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "TURN_LEFT", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 246047066,
                    "nodeId": 79353551,
                    "x": 8.268418364486765,
                    "y": 50.006461713952184,
                    "direction": False,
                },
                "street": 3,
                "distance": 157,
                "length": 204,
                "crossTime": 49,
                "crossTimeWithoutRealTime": 49,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 1,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "TURN_RIGHT", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 246047440,
                    "nodeId": 209641300,
                    "x": 8.270667599646012,
                    "y": 50.007563160951484,
                    "direction": False,
                },
                "street": 5,
                "altStreets": [4],
                "distance": 206,
                "length": 141,
                "crossTime": 14,
                "crossTimeWithoutRealTime": 27,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [{"angle": 90, "selected": False}],
                        },
                    ],
                    "enable_voice_for_instruction": False,
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "NONE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 0, "to_lane_index": 1},
                        "angle": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 392387017,
                    "nodeId": 79353565,
                    "x": 8.271494187674573,
                    "y": 50.006420341318844,
                    "direction": False,
                },
                "street": 5,
                "altStreets": [4],
                "distance": 220,
                "length": 36,
                "crossTime": 4,
                "crossTimeWithoutRealTime": 4,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 162231268,
                    "nodeId": 162914110,
                    "x": 8.271637685856833,
                    "y": 50.00611392414356,
                    "direction": False,
                },
                "street": 5,
                "altStreets": [4],
                "distance": 224,
                "length": 191,
                "crossTime": 24,
                "crossTimeWithoutRealTime": 24,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 360439058,
                    "nodeId": 79354884,
                    "x": 8.273044504485089,
                    "y": 50.00466110951561,
                    "direction": False,
                },
                "street": 7,
                "altStreets": [6],
                "distance": 248,
                "length": 137,
                "crossTime": 16,
                "crossTimeWithoutRealTime": 16,
                "knownDirection": True,
                "penalty": 5,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": -90, "selected": True}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": False}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [
                                {"angle": 0, "selected": False},
                                {"angle": 90, "selected": False},
                            ],
                        },
                    ]
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "TURN_LEFT",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 0, "to_lane_index": 0},
                        "angle": -45,
                        "angle_override": -90,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 399190430,
                    "nodeId": 284052144,
                    "x": 8.273971790530663,
                    "y": 50.00359047306348,
                    "direction": False,
                },
                "street": 7,
                "altStreets": [6],
                "distance": 264,
                "length": 65,
                "crossTime": 5,
                "crossTimeWithoutRealTime": 10,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 399190429,
                    "nodeId": 309295012,
                    "x": 8.27458476301202,
                    "y": 50.003390345561506,
                    "direction": False,
                },
                "street": 7,
                "altStreets": [6],
                "distance": 269,
                "length": 37,
                "crossTime": 4,
                "crossTimeWithoutRealTime": 4,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 392386961,
                    "nodeId": 79358204,
                    "x": 8.274416454396324,
                    "y": 50.003697642077995,
                    "direction": False,
                },
                "street": 7,
                "altStreets": [6],
                "distance": 273,
                "length": 179,
                "crossTime": 17,
                "crossTimeWithoutRealTime": 17,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 270261228,
                    "nodeId": 225111472,
                    "x": 8.27325020772032,
                    "y": 50.0050858175989,
                    "direction": False,
                },
                "street": 9,
                "altStreets": [8],
                "distance": 290,
                "length": 36,
                "crossTime": 4,
                "crossTimeWithoutRealTime": 4,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 239674002,
                    "nodeId": 79353332,
                    "x": 8.273584842682723,
                    "y": 50.00532475365378,
                    "direction": False,
                },
                "street": 9,
                "altStreets": [8],
                "distance": 294,
                "length": 208,
                "crossTime": 19,
                "crossTimeWithoutRealTime": 17,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 369081994,
                    "nodeId": 205584787,
                    "x": 8.276032753295809,
                    "y": 50.006327055101046,
                    "direction": False,
                },
                "street": 11,
                "altStreets": [10],
                "distance": 313,
                "length": 309,
                "crossTime": 40,
                "crossTimeWithoutRealTime": 40,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": False}],
                        },
                    ]
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "KEEP_LEFT",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 0, "to_lane_index": 0},
                        "angle": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 403833198,
                    "nodeId": 225111842,
                    "x": 8.27967572957318,
                    "y": 50.00781791594246,
                    "direction": True,
                },
                "street": 12,
                "distance": 353,
                "length": 77,
                "crossTime": 10,
                "crossTimeWithoutRealTime": 10,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "entrySegment": {"segment_id": 369081994, "segment_direction": False},
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403833199,
                    "nodeId": 312426534,
                    "x": 8.280588422753961,
                    "y": 50.00817553744451,
                    "direction": True,
                },
                "street": 12,
                "distance": 363,
                "length": 41,
                "crossTime": 5,
                "crossTimeWithoutRealTime": 5,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "entrySegment": {"segment_id": 369081994, "segment_direction": False},
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 239540450,
                    "nodeId": 205500150,
                    "x": 8.281030654908028,
                    "y": 50.008406125706664,
                    "direction": True,
                },
                "street": 13,
                "distance": 368,
                "length": 38,
                "crossTime": 5,
                "crossTimeWithoutRealTime": 5,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 239540443,
                    "nodeId": 205500121,
                    "x": 8.281298742764584,
                    "y": 50.00867084273389,
                    "direction": True,
                },
                "street": 13,
                "distance": 373,
                "length": 17,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 2,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": -45, "selected": False}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [
                                {"angle": 45, "selected": True},
                                {"angle": -45, "selected": False},
                            ],
                        },
                    ]
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "entrySegment": {"segment_id": 239540450, "segment_direction": True},
                "instruction": {
                    "opcode": "KEEP_RIGHT",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 1, "to_lane_index": 1},
                        "angle": 45,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 416527190,
                    "nodeId": 205500130,
                    "x": 8.281234434580242,
                    "y": 50.00881377267493,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 375,
                "length": 72,
                "crossTime": 7,
                "crossTimeWithoutRealTime": 7,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 257351336,
                    "nodeId": 79357623,
                    "x": 8.28098937901436,
                    "y": 50.00943918092699,
                    "direction": False,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 382,
                "length": 148,
                "crossTime": 13,
                "crossTimeWithoutRealTime": 13,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 188953304,
                    "nodeId": 79356765,
                    "x": 8.280682992090153,
                    "y": 50.01073476651955,
                    "direction": True,
                },
                "street": 15,
                "altStreets": [14],
                "distance": 395,
                "length": 62,
                "crossTime": 8,
                "crossTimeWithoutRealTime": 8,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "ROUNDABOUT_ENTER", "arg": 2},
            },
            {
                "path": {
                    "segmentId": 405910183,
                    "nodeId": 313820661,
                    "x": 8.2813478562369,
                    "y": 50.01108070814998,
                    "direction": True,
                },
                "street": 13,
                "distance": 403,
                "length": 8,
                "crossTime": 1,
                "crossTimeWithoutRealTime": 1,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
            },
            {
                "path": {
                    "segmentId": 405910184,
                    "nodeId": 313820662,
                    "x": 8.2814609537597,
                    "y": 50.011079077743,
                    "direction": True,
                },
                "street": 13,
                "distance": 404,
                "length": 23,
                "crossTime": 3,
                "crossTimeWithoutRealTime": 3,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
            },
            {
                "path": {
                    "segmentId": 405910185,
                    "nodeId": 313820663,
                    "x": 8.2816835034332,
                    "y": 50.011211538476026,
                    "direction": True,
                },
                "street": 13,
                "distance": 407,
                "length": 9,
                "crossTime": 1,
                "crossTimeWithoutRealTime": 1,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "ROUNDABOUT_EXIT", "arg": 2},
            },
            {
                "path": {
                    "segmentId": 72861035,
                    "nodeId": 313820656,
                    "x": 8.2817056796749,
                    "y": 50.01129154713299,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 408,
                "length": 42,
                "crossTime": 5,
                "crossTimeWithoutRealTime": 5,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72858815,
                    "nodeId": 79355011,
                    "x": 8.281870412588123,
                    "y": 50.01164604939817,
                    "direction": False,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 413,
                "length": 28,
                "crossTime": 3,
                "crossTimeWithoutRealTime": 3,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72858814,
                    "nodeId": 79355010,
                    "x": 8.281943391027694,
                    "y": 50.0118944330428,
                    "direction": False,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 416,
                "length": 79,
                "crossTime": 7,
                "crossTimeWithoutRealTime": 7,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72857212,
                    "nodeId": 79355008,
                    "x": 8.28224111622832,
                    "y": 50.01257872283312,
                    "direction": False,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 423,
                "length": 97,
                "crossTime": 8,
                "crossTimeWithoutRealTime": 8,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 398640564,
                    "nodeId": 79355007,
                    "x": 8.282603214445347,
                    "y": 50.01341424986179,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 431,
                "length": 187,
                "crossTime": 14,
                "crossTimeWithoutRealTime": 14,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 398640565,
                    "nodeId": 308918826,
                    "x": 8.283469567957145,
                    "y": 50.01499649744738,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 445,
                "length": 64,
                "crossTime": 5,
                "crossTimeWithoutRealTime": 5,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72858822,
                    "nodeId": 79356588,
                    "x": 8.283965217828909,
                    "y": 50.01547503651856,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 450,
                "length": 23,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 2,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 398513278,
                    "nodeId": 79356589,
                    "x": 8.28415699577346,
                    "y": 50.01563532507227,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 452,
                "length": 19,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 2,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 398513280,
                    "nodeId": 308831979,
                    "x": 8.284319026554906,
                    "y": 50.01577041640963,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 454,
                "length": 113,
                "crossTime": 9,
                "crossTimeWithoutRealTime": 9,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72862730,
                    "nodeId": 79358197,
                    "x": 8.285279500246174,
                    "y": 50.01657119272344,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 463,
                "length": 56,
                "crossTime": 5,
                "crossTimeWithoutRealTime": 5,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 359201998,
                    "nodeId": 79355060,
                    "x": 8.285704630375077,
                    "y": 50.01699172400254,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 468,
                "length": 87,
                "crossTime": 7,
                "crossTimeWithoutRealTime": 7,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 359202001,
                    "nodeId": 283273243,
                    "x": 8.286282646417748,
                    "y": 50.01767938812136,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 475,
                "length": 31,
                "crossTime": 3,
                "crossTimeWithoutRealTime": 3,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 359202002,
                    "nodeId": 283273245,
                    "x": 8.286489544612841,
                    "y": 50.017924908846936,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 478,
                "length": 72,
                "crossTime": 6,
                "crossTimeWithoutRealTime": 6,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 369982948,
                    "nodeId": 79353652,
                    "x": 8.286934939940569,
                    "y": 50.01850240828643,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 484,
                "length": 39,
                "crossTime": 4,
                "crossTimeWithoutRealTime": 4,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 369982949,
                    "nodeId": 290265373,
                    "x": 8.28721674105569,
                    "y": 50.018805262484385,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 488,
                "length": 15,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 2,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 359202193,
                    "nodeId": 283273358,
                    "x": 8.287313925309153,
                    "y": 50.01892364901965,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 490,
                "length": 34,
                "crossTime": 5,
                "crossTimeWithoutRealTime": 5,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 359202190,
                    "nodeId": 283273356,
                    "x": 8.28752922463611,
                    "y": 50.019200053936416,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 495,
                "length": 8,
                "crossTime": 1,
                "crossTimeWithoutRealTime": 1,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 359202111,
                    "nodeId": 283273312,
                    "x": 8.28757583140188,
                    "y": 50.01926117012916,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 496,
                "length": 48,
                "crossTime": 14,
                "crossTimeWithoutRealTime": 14,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": -90, "selected": False}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [
                                {"angle": 0, "selected": True},
                                {"angle": 90, "selected": False},
                            ],
                        },
                    ],
                    "enable_voice_for_instruction": False,
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "NONE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 1, "to_lane_index": 2},
                        "angle": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 420571611,
                    "nodeId": 174344265,
                    "x": 8.287890559637065,
                    "y": 50.01964560749178,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 510,
                "length": 8,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 3,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "entrySegment": {"segment_id": 359202111, "segment_direction": True},
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 420571706,
                    "nodeId": 323291959,
                    "x": 8.287942185469513,
                    "y": 50.01970657605405,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 512,
                "length": 376,
                "crossTime": 28,
                "crossTimeWithoutRealTime": 28,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 420571708,
                    "nodeId": 323292020,
                    "x": 8.289386510174873,
                    "y": 50.02294373296669,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 540,
                "length": 20,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 1,
                "knownDirection": True,
                "penalty": 6,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 420572000,
                    "nodeId": 323291962,
                    "x": 8.289451539417117,
                    "y": 50.023119952514335,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 542,
                "length": 331,
                "crossTime": 26,
                "crossTimeWithoutRealTime": 26,
                "knownDirection": True,
                "penalty": 8,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 420572105,
                    "nodeId": 323292224,
                    "x": 8.291147001107324,
                    "y": 50.02588207737042,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 568,
                "length": 432,
                "crossTime": 27,
                "crossTimeWithoutRealTime": 27,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 420572106,
                    "nodeId": 323292298,
                    "x": 8.293392365649517,
                    "y": 50.029480847228186,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 595,
                "length": 28,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 2,
                "knownDirection": True,
                "penalty": 6,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403456941,
                    "nodeId": 323292225,
                    "x": 8.293529878657477,
                    "y": 50.029718589523696,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 597,
                "length": 43,
                "crossTime": 3,
                "crossTimeWithoutRealTime": 3,
                "knownDirection": True,
                "penalty": 6,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 45, "selected": False}],
                        },
                    ]
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "CONTINUE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 0, "to_lane_index": 0},
                        "angle": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 403456984,
                    "nodeId": 312171749,
                    "x": 8.293760503833154,
                    "y": 50.03007362370881,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 600,
                "length": 108,
                "crossTime": 6,
                "crossTimeWithoutRealTime": 6,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403456985,
                    "nodeId": 312171771,
                    "x": 8.29435285802704,
                    "y": 50.030968909449435,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 606,
                "length": 46,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 2,
                "knownDirection": True,
                "penalty": 6,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 45, "selected": False}],
                        },
                    ],
                    "enable_voice_for_instruction": False,
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "NONE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 0, "to_lane_index": 0},
                        "angle": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 403457477,
                    "nodeId": 312171938,
                    "x": 8.294596792107003,
                    "y": 50.031353997435836,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 608,
                "length": 215,
                "crossTime": 11,
                "crossTimeWithoutRealTime": 11,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403457478,
                    "nodeId": 312172067,
                    "x": 8.295513831213526,
                    "y": 50.033195695906976,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 619,
                "length": 110,
                "crossTime": 6,
                "crossTimeWithoutRealTime": 6,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403646272,
                    "nodeId": 214044048,
                    "x": 8.295886740089179,
                    "y": 50.034156514171585,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 625,
                "length": 449,
                "crossTime": 19,
                "crossTimeWithoutRealTime": 19,
                "knownDirection": True,
                "penalty": 4,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72857660,
                    "nodeId": 79355475,
                    "x": 8.297822550832048,
                    "y": 50.03799377196168,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 644,
                "length": 163,
                "crossTime": 7,
                "crossTimeWithoutRealTime": 7,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 270260191,
                    "nodeId": 152542831,
                    "x": 8.298357205225384,
                    "y": 50.039416455948285,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 651,
                "length": 221,
                "crossTime": 8,
                "crossTimeWithoutRealTime": 8,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 391255020,
                    "nodeId": 79353453,
                    "x": 8.298718482256245,
                    "y": 50.04139157351876,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 659,
                "length": 356,
                "crossTime": 14,
                "crossTimeWithoutRealTime": 14,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72856088,
                    "nodeId": 232259579,
                    "x": 8.29805632622561,
                    "y": 50.04454535961542,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 673,
                "length": 150,
                "crossTime": 6,
                "crossTimeWithoutRealTime": 6,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 270259997,
                    "nodeId": 232259577,
                    "x": 8.297155103996614,
                    "y": 50.04576659144225,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 679,
                "length": 158,
                "crossTime": 6,
                "crossTimeWithoutRealTime": 6,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [{"angle": 45, "selected": False}],
                        },
                    ],
                    "enable_voice_for_instruction": False,
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "NONE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 0, "to_lane_index": 1},
                        "angle": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 403644391,
                    "nodeId": 79353397,
                    "x": 8.29600135584082,
                    "y": 50.04697724849803,
                    "direction": True,
                },
                "street": 17,
                "altStreets": [16],
                "distance": 685,
                "length": 301,
                "crossTime": 12,
                "crossTimeWithoutRealTime": 12,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72856105,
                    "nodeId": 79353303,
                    "x": 8.293654102615042,
                    "y": 50.04922412977821,
                    "direction": True,
                },
                "street": 18,
                "distance": 697,
                "length": 70,
                "crossTime": 3,
                "crossTimeWithoutRealTime": 3,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [{"angle": 45, "selected": False}],
                        },
                    ],
                    "enable_voice_for_instruction": False,
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "NONE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 0, "to_lane_index": 1},
                        "angle": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 270468796,
                    "nodeId": 79353310,
                    "x": 8.29308286073319,
                    "y": 50.04973165478949,
                    "direction": True,
                },
                "street": 18,
                "distance": 700,
                "length": 108,
                "crossTime": 4,
                "crossTimeWithoutRealTime": 4,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "avoidStatus": "OPEN",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403644528,
                    "nodeId": 79353306,
                    "x": 8.292173843576604,
                    "y": 50.050504605307545,
                    "direction": True,
                },
                "street": 18,
                "distance": 704,
                "length": 324,
                "crossTime": 11,
                "crossTimeWithoutRealTime": 11,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403644909,
                    "nodeId": 216801994,
                    "x": 8.289468359393958,
                    "y": 50.05283882466332,
                    "direction": True,
                },
                "street": 18,
                "distance": 715,
                "length": 208,
                "crossTime": 8,
                "crossTimeWithoutRealTime": 8,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403645057,
                    "nodeId": 312297451,
                    "x": 8.28805483524311,
                    "y": 50.05446799359876,
                    "direction": True,
                },
                "street": 18,
                "distance": 723,
                "length": 871,
                "crossTime": 33,
                "crossTimeWithoutRealTime": 33,
                "knownDirection": True,
                "penalty": 4,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403645103,
                    "nodeId": 312297570,
                    "x": 8.282227183044732,
                    "y": 50.06121432712545,
                    "direction": True,
                },
                "street": 20,
                "altStreets": [19],
                "distance": 756,
                "length": 358,
                "crossTime": 15,
                "crossTimeWithoutRealTime": 14,
                "knownDirection": True,
                "penalty": 4,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [{"angle": 45, "selected": False}],
                        },
                    ],
                    "enable_voice_for_instruction": False,
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "NONE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 0, "to_lane_index": 1},
                        "angle": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 403645289,
                    "nodeId": 312297615,
                    "x": 8.277999361532887,
                    "y": 50.06292565734028,
                    "direction": True,
                },
                "street": 20,
                "altStreets": [19],
                "distance": 771,
                "length": 277,
                "crossTime": 11,
                "crossTimeWithoutRealTime": 11,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403645290,
                    "nodeId": 312297732,
                    "x": 8.27463742134867,
                    "y": 50.06415295898346,
                    "direction": True,
                },
                "street": 20,
                "altStreets": [19],
                "distance": 782,
                "length": 32,
                "crossTime": 1,
                "crossTimeWithoutRealTime": 1,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403645382,
                    "nodeId": 312297731,
                    "x": 8.27425321254867,
                    "y": 50.064296020265736,
                    "direction": True,
                },
                "street": 21,
                "altStreets": [19],
                "distance": 783,
                "length": 412,
                "crossTime": 20,
                "crossTimeWithoutRealTime": 20,
                "knownDirection": True,
                "penalty": 4,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403645384,
                    "nodeId": 312297772,
                    "x": 8.269241769018308,
                    "y": 50.06610874780491,
                    "direction": True,
                },
                "street": 21,
                "altStreets": [19],
                "distance": 803,
                "length": 41,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 2,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [{"angle": 45, "selected": False}],
                        },
                    ],
                    "enable_voice_for_instruction": False,
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "NONE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 0, "to_lane_index": 1},
                        "angle": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 403645575,
                    "nodeId": 312297803,
                    "x": 8.26874406645578,
                    "y": 50.06628877186283,
                    "direction": True,
                },
                "street": 21,
                "altStreets": [19],
                "distance": 805,
                "length": 565,
                "crossTime": 36,
                "crossTimeWithoutRealTime": 36,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 403645505,
                    "nodeId": 312297926,
                    "x": 8.262006484131975,
                    "y": 50.06891731088396,
                    "direction": True,
                },
                "street": 21,
                "altStreets": [19],
                "distance": 841,
                "length": 94,
                "crossTime": 8,
                "crossTimeWithoutRealTime": 7,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": 0, "selected": False}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [
                                {"angle": 0, "selected": False},
                                {"angle": 0, "selected": True},
                            ],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [{"angle": 45, "selected": False}],
                        },
                    ],
                    "enable_voice_for_instruction": False,
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "NONE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 0, "to_lane_index": 1},
                        "angle": 0,
                        "enable_display": True,
                        "enable_voice": False,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 403646403,
                    "nodeId": 312297993,
                    "x": 8.261065777583108,
                    "y": 50.069508069042826,
                    "direction": True,
                },
                "street": 21,
                "altStreets": [19],
                "distance": 849,
                "length": 321,
                "crossTime": 27,
                "crossTimeWithoutRealTime": 27,
                "knownDirection": True,
                "penalty": 4,
                "roadType": 6,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [{"angle": -45, "selected": False}],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": -45, "selected": False}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                    ]
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "CONTINUE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 2, "to_lane_index": 2},
                        "angle": 45,
                        "angle_override": 0,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 319869982,
                    "nodeId": 79354101,
                    "x": 8.258151635527357,
                    "y": 50.07169588488001,
                    "direction": True,
                },
                "street": 23,
                "altStreets": [22],
                "distance": 876,
                "length": 24,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 2,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 392456901,
                    "nodeId": 258526097,
                    "x": 8.2579690105894,
                    "y": 50.07187605329073,
                    "direction": True,
                },
                "street": 24,
                "altStreets": [22],
                "distance": 878,
                "length": 38,
                "crossTime": 3,
                "crossTimeWithoutRealTime": 3,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 392456904,
                    "nodeId": 304758949,
                    "x": 8.257601588468507,
                    "y": 50.072117516562244,
                    "direction": True,
                },
                "street": 24,
                "altStreets": [22],
                "distance": 881,
                "length": 104,
                "crossTime": 7,
                "crossTimeWithoutRealTime": 7,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 392456905,
                    "nodeId": 304758951,
                    "x": 8.256560593230622,
                    "y": 50.07276745207503,
                    "direction": True,
                },
                "street": 24,
                "altStreets": [22],
                "distance": 888,
                "length": 132,
                "crossTime": 10,
                "crossTimeWithoutRealTime": 10,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72857995,
                    "nodeId": 79353501,
                    "x": 8.255321646661743,
                    "y": 50.07364275376407,
                    "direction": False,
                },
                "street": 24,
                "altStreets": [22],
                "distance": 898,
                "length": 123,
                "crossTime": 20,
                "crossTimeWithoutRealTime": 20,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "clientLaneSet": {
                    "client_lane": [
                        {
                            "lane_index": 0,
                            "angle_object": [
                                {"angle": -90, "selected": False},
                                {"angle": -180, "selected": False},
                            ],
                        },
                        {
                            "lane_index": 1,
                            "angle_object": [{"angle": 0, "selected": True}],
                        },
                        {
                            "lane_index": 2,
                            "angle_object": [{"angle": 90, "selected": False}],
                        },
                    ],
                    "enable_voice_for_instruction": False,
                },
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {
                    "opcode": "NONE",
                    "arg": 0,
                    "laneGuidance": {
                        "lanes_range": {"from_lane_index": 1, "to_lane_index": 1},
                        "angle": 0,
                        "enable_display": True,
                        "enable_voice": False,
                    },
                },
            },
            {
                "path": {
                    "segmentId": 72857994,
                    "nodeId": 79355835,
                    "x": 8.254181440178295,
                    "y": 50.07447100898019,
                    "direction": False,
                },
                "street": 24,
                "altStreets": [22],
                "distance": 918,
                "length": 109,
                "crossTime": 11,
                "crossTimeWithoutRealTime": 11,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72858013,
                    "nodeId": 79355850,
                    "x": 8.253178896805343,
                    "y": 50.075209322489115,
                    "direction": False,
                },
                "street": 24,
                "altStreets": [22],
                "distance": 929,
                "length": 159,
                "crossTime": 15,
                "crossTimeWithoutRealTime": 15,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 238123028,
                    "nodeId": 79355857,
                    "x": 8.251714843135225,
                    "y": 50.07628794135344,
                    "direction": False,
                },
                "street": 24,
                "altStreets": [22],
                "distance": 944,
                "length": 20,
                "crossTime": 2,
                "crossTimeWithoutRealTime": 2,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 238123027,
                    "nodeId": 204585735,
                    "x": 8.251541672219897,
                    "y": 50.076426172858824,
                    "direction": False,
                },
                "street": 24,
                "altStreets": [22],
                "distance": 946,
                "length": 142,
                "crossTime": 13,
                "crossTimeWithoutRealTime": 13,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72862880,
                    "nodeId": 79358062,
                    "x": 8.250227969999997,
                    "y": 50.07738830905831,
                    "direction": False,
                },
                "street": 24,
                "altStreets": [22],
                "distance": 959,
                "length": 46,
                "crossTime": 4,
                "crossTimeWithoutRealTime": 4,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 241124839,
                    "nodeId": 79358269,
                    "x": 8.249803092149582,
                    "y": 50.07769683498676,
                    "direction": False,
                },
                "street": 24,
                "altStreets": [22],
                "distance": 963,
                "length": 75,
                "crossTime": 8,
                "crossTimeWithoutRealTime": 8,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 241124838,
                    "nodeId": 206526997,
                    "x": 8.249134843004203,
                    "y": 50.07821624167377,
                    "direction": False,
                },
                "street": 24,
                "altStreets": [22],
                "distance": 971,
                "length": 13,
                "crossTime": 1,
                "crossTimeWithoutRealTime": 1,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 7,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72863186,
                    "nodeId": 79358414,
                    "x": 8.24901572883606,
                    "y": 50.078303885124676,
                    "direction": True,
                },
                "street": 25,
                "altStreets": [22],
                "distance": 972,
                "length": 134,
                "crossTime": 14,
                "crossTimeWithoutRealTime": 14,
                "knownDirection": True,
                "penalty": 1,
                "roadType": 2,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72869087,
                    "nodeId": 79362696,
                    "x": 8.247797133764283,
                    "y": 50.07921321509809,
                    "direction": False,
                },
                "street": 25,
                "altStreets": [22],
                "distance": 986,
                "length": 104,
                "crossTime": 35,
                "crossTimeWithoutRealTime": 35,
                "knownDirection": True,
                "penalty": 4,
                "roadType": 2,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "TURN_RIGHT", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72867885,
                    "nodeId": 79360870,
                    "x": 8.246855598037282,
                    "y": 50.079919933026886,
                    "direction": False,
                },
                "street": 27,
                "altStreets": [26],
                "distance": 1021,
                "length": 65,
                "crossTime": 8,
                "crossTimeWithoutRealTime": 8,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 2,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72868025,
                    "nodeId": 79362297,
                    "x": 8.247670299643401,
                    "y": 50.080170316116096,
                    "direction": False,
                },
                "street": 27,
                "altStreets": [26],
                "distance": 1029,
                "length": 16,
                "crossTime": 4,
                "crossTimeWithoutRealTime": 4,
                "knownDirection": True,
                "penalty": 6,
                "roadType": 2,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "TURN_LEFT", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 72867525,
                    "nodeId": 79360553,
                    "x": 8.247869122268446,
                    "y": 50.08023121515301,
                    "direction": True,
                },
                "street": 28,
                "distance": 1033,
                "length": 219,
                "crossTime": 33,
                "crossTimeWithoutRealTime": 28,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 1,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 190701025,
                    "nodeId": 79362142,
                    "x": 8.247528659073788,
                    "y": 50.082191394844365,
                    "direction": True,
                },
                "street": 28,
                "distance": 1066,
                "length": 98,
                "crossTime": 17,
                "crossTimeWithoutRealTime": 17,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 1,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 252683862,
                    "nodeId": 177152399,
                    "x": 8.247405795329334,
                    "y": 50.08306966205819,
                    "direction": True,
                },
                "street": 28,
                "distance": 1083,
                "length": 61,
                "crossTime": 9,
                "crossTimeWithoutRealTime": 9,
                "knownDirection": True,
                "penalty": 2,
                "roadType": 1,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 387144732,
                    "nodeId": 79362140,
                    "x": 8.247339771792056,
                    "y": 50.08361622550607,
                    "direction": True,
                },
                "street": 28,
                "distance": 1092,
                "length": 16,
                "crossTime": 3,
                "crossTimeWithoutRealTime": 3,
                "knownDirection": True,
                "penalty": 0,
                "roadType": 1,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 387144733,
                    "nodeId": 301385364,
                    "x": 8.247321625448992,
                    "y": 50.08376342727354,
                    "direction": True,
                },
                "street": 28,
                "distance": 1095,
                "length": 28,
                "crossTime": 6,
                "crossTimeWithoutRealTime": 6,
                "knownDirection": True,
                "penalty": 3,
                "roadType": 1,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "NONE", "arg": 0},
            },
            {
                "path": {
                    "segmentId": 270634256,
                    "nodeId": 213790660,
                    "x": 8.247291101809203,
                    "y": 50.08401103171967,
                    "direction": True,
                },
                "street": 13,
                "distance": 1101,
                "length": 12,
                "crossTime": 3,
                "crossTimeWithoutRealTime": 3,
                "knownDirection": True,
                "penalty": 6,
                "roadType": 1,
                "isToll": False,
                "useHovLane": False,
                "attributes": 0,
                "lane": "WHOLE_SEGMENT",
                "areas": ["Umweltzone"],
                "avoidStatus": "MAYBE",
                "isInvalid": False,
                "isBlocked": False,
                "speedLimit": 0,
                "instruction": {"opcode": "APPROACHING_DESTINATION", "arg": 0},
            },
        ],
        "streetNames": [
            "Kaiserstraße",
            "B40 - Kaiserstraße",
            "Ernst-Ludwig-Straße",
            "Diether-von-Isenburg-Straße",
            "Peter-Altmeier-Allee",
            "B40 - Peter-Altmeier-Allee",
            "Rheinstraße",
            "B40 - Rheinstraße",
            "Theodor-Heuss-Brücke",
            "B40 - Theodor-Heuss-Brücke",
            "Theodor-Heuss-Brücke",
            "B40 - Theodor-Heuss-Brücke",
            "B40",
            None,
            "Ludwigsrampe",
            "B455 - Ludwigsrampe",
            "Boelckestraße",
            "B455 - Boelckestraße",
            "B455",
            "Berliner Straße",
            "B455 - Berliner Straße",
            "B54 - Berliner Straße",
            "Frankfurter Straße",
            "> Stadtmitte",
            "L3037 - Frankfurter Straße",
            "K658 - Frankfurter Straße",
            "Bierstadter Straße",
            "K659 - Bierstadter Straße",
            "Paulinenstraße",
        ],
        "fromFraction": 0.7886346623377086,
        "toFraction": 0.4876577222349604,
        "sameFromSegment": True,
        "sameToSegment": True,
        "tollMeters": 0,
        "preferedRouteId": -1,
        "isInvalid": False,
        "isBlocked": False,
        "serverUniqueId": "m8907133486308188220",
        "displayRoute": True,
        "astarVisited": 12196,
        "astarResult": "UNKNOWN",
        "isRestricted": False,
        "avoidStatus": "MAYBE",
        "passesThroughDangerArea": False,
        "distanceFromSource": 14,
        "distanceFromTarget": 39,
        "minPassengers": 0,
        "hovIndex": -1,
        "preRefinedRouteIndex": -1,
        "blockedRouteUid": -1,
        "alternativeRouteUuid": "e5c22d1d-ea15-4cfc-a877-fe4fb96285e2",
        "serverTilesVersion": 1691214914000,
        "rankBeforeReordering": 0,
        "serverType": "LIVEMAP",
        "routeType": ["Best"],
        "routeAttr": ["RestrictedZone"],
        "astarCost": 1303,
        "totalRouteTime": 1104,
        "totalRouteTimeWithoutRealtime": 1113,
        "carbonEmissionsGrams": 0,
        "creationMechanismSet": ["ASTAR", "AERIAL_TIME_HEURISTIC"],
        "laneTypes": [],
        "areas": ["Umweltzone"],
        "requiredPermits": [],
        "etaHistograms": [],
        "tollPrice": 0.0,
        "isInvalidForPrivateVehicle": False,
        "costInfo": {
            "unbiasedAstarCost": 0,
            "tollAsSeconds": 0,
            "keepForReordering": False,
        },
        "destinationInformation": {
            "segment_id": 270634256,
            "street_id": 7744185,
            "city_id": 27809,
            "country_id": 81,
            "city_name": "Wiesbaden",
        },
        "routeName": "B455 - Boelckestraße Wiesbaden",
        "totalRouteTimeWithoutMl": 1104,
        "open": False,
    },
    "coords": [
        {"x": 8.262364726690599, "y": 50.00345516735274, "z": "NaN"},
        {"x": 8.262884296737077, "y": 50.003263849158074, "z": "NaN"},
        {"x": 8.262884296737077, "y": 50.003263849158074, "z": "NaN"},
        {"x": 8.26296619483727, "y": 50.00339573042915, "z": "NaN"},
        {"x": 8.263474564170831, "y": 50.00389912419096, "z": "NaN"},
        {"x": 8.263474564170831, "y": 50.00389912419096, "z": "NaN"},
        {"x": 8.264312573037357, "y": 50.004726618565144, "z": "NaN"},
        {"x": 8.264312573037357, "y": 50.004726618565144, "z": "NaN"},
        {"x": 8.265242629013304, "y": 50.00568941892085, "z": "NaN"},
        {"x": 8.265242629013304, "y": 50.00568941892085, "z": "NaN"},
        {"x": 8.265759624800928, "y": 50.006232224674996, "z": "NaN"},
        {"x": 8.26586423095251, "y": 50.00630548897572, "z": "NaN"},
        {"x": 8.266104288659388, "y": 50.00642271162488, "z": "NaN"},
        {"x": 8.266104288659388, "y": 50.00642271162488, "z": "NaN"},
        {"x": 8.266304783783253, "y": 50.00653691723972, "z": "NaN"},
        {"x": 8.266579039655028, "y": 50.00674765820908, "z": "NaN"},
        {"x": 8.267026968560463, "y": 50.00718314352199, "z": "NaN"},
        {"x": 8.267026968560463, "y": 50.00718314352197, "z": "NaN"},
        {"x": 8.267619736752678, "y": 50.00692844650572, "z": "NaN"},
        {"x": 8.268418364486765, "y": 50.006461713952184, "z": "NaN"},
        {"x": 8.268418364486765, "y": 50.006461713952184, "z": "NaN"},
        {"x": 8.268526993951816, "y": 50.00647765964532, "z": "NaN"},
        {"x": 8.26905337747097, "y": 50.00678493642532, "z": "NaN"},
        {"x": 8.269656225245912, "y": 50.00712860410831, "z": "NaN"},
        {"x": 8.270667599646012, "y": 50.007563160951484, "z": "NaN"},
        {"x": 8.270667599646012, "y": 50.007563160951484, "z": "NaN"},
        {"x": 8.271037978316048, "y": 50.00715250234093, "z": "NaN"},
        {"x": 8.271365441641864, "y": 50.00671382766804, "z": "NaN"},
        {"x": 8.271431155762743, "y": 50.00660824174283, "z": "NaN"},
        {"x": 8.271494187674573, "y": 50.006420341318844, "z": "NaN"},
        {"x": 8.271494187674573, "y": 50.006420341318844, "z": "NaN"},
        {"x": 8.271637685856833, "y": 50.00611392414356, "z": "NaN"},
        {"x": 8.271637685856833, "y": 50.00611392414356, "z": "NaN"},
        {"x": 8.27170798235573, "y": 50.00600453636846, "z": "NaN"},
        {"x": 8.271787666586183, "y": 50.00591368004332, "z": "NaN"},
        {"x": 8.273044504485089, "y": 50.00466110951561, "z": "NaN"},
        {"x": 8.273044504485089, "y": 50.00466110951561, "z": "NaN"},
        {"x": 8.273474809463597, "y": 50.00421243931527, "z": "NaN"},
        {"x": 8.273716018706539, "y": 50.00393185031846, "z": "NaN"},
        {"x": 8.273971790530663, "y": 50.00359047306348, "z": "NaN"},
        {"x": 8.273971790530663, "y": 50.00359047306348, "z": "NaN"},
        {"x": 8.274058150504036, "y": 50.003546367736924, "z": "NaN"},
        {"x": 8.274210941546816, "y": 50.003356526900085, "z": "NaN"},
        {"x": 8.274288378915841, "y": 50.00331492185268, "z": "NaN"},
        {"x": 8.274394326171992, "y": 50.003298544117264, "z": "NaN"},
        {"x": 8.274480156860436, "y": 50.00331319788084, "z": "NaN"},
        {"x": 8.274545870981296, "y": 50.00334681532102, "z": "NaN"},
        {"x": 8.27458476301202, "y": 50.003390345561506, "z": "NaN"},
        {"x": 8.27458476301202, "y": 50.003390345561506, "z": "NaN"},
        {"x": 8.274594150743576, "y": 50.00343689270589, "z": "NaN"},
        {"x": 8.274576884023038, "y": 50.003493999094275, "z": "NaN"},
        {"x": 8.274488538763608, "y": 50.00359204952739, "z": "NaN"},
        {"x": 8.274416454396324, "y": 50.00369764207802, "z": "NaN"},
        {"x": 8.274416454396324, "y": 50.003697642077995, "z": "NaN"},
        {"x": 8.273315251288938, "y": 50.00481947302412, "z": "NaN"},
        {"x": 8.273255572138392, "y": 50.00490092807522, "z": "NaN"},
        {"x": 8.273228750048222, "y": 50.00500436286148, "z": "NaN"},
        {"x": 8.27325020772032, "y": 50.0050858175989, "z": "NaN"},
        {"x": 8.27325020772032, "y": 50.0050858175989, "z": "NaN"},
        {"x": 8.273308606093535, "y": 50.00515586872543, "z": "NaN"},
        {"x": 8.273381086064076, "y": 50.00520954266566, "z": "NaN"},
        {"x": 8.273584842682723, "y": 50.00532475365378, "z": "NaN"},
        {"x": 8.273584842682723, "y": 50.00532475365378, "z": "NaN"},
        {"x": 8.276032753295809, "y": 50.006327055101046, "z": "NaN"},
        {"x": 8.276032753295809, "y": 50.006327055101046, "z": "NaN"},
        {"x": 8.27967572957318, "y": 50.00781791594246, "z": "NaN"},
        {"x": 8.27967572957318, "y": 50.00781791594246, "z": "NaN"},
        {"x": 8.280186377466098, "y": 50.007979597478894, "z": "NaN"},
        {"x": 8.280588422753961, "y": 50.00817553744451, "z": "NaN"},
        {"x": 8.280588422753961, "y": 50.00817553744451, "z": "NaN"},
        {"x": 8.281030654908028, "y": 50.008406125706664, "z": "NaN"},
        {"x": 8.281030654908028, "y": 50.008406125706664, "z": "NaN"},
        {"x": 8.281167515223444, "y": 50.00846965427605, "z": "NaN"},
        {"x": 8.28125383786892, "y": 50.008529336001615, "z": "NaN"},
        {"x": 8.28129372524024, "y": 50.00858418944403, "z": "NaN"},
        {"x": 8.281298742764584, "y": 50.00867084273389, "z": "NaN"},
        {"x": 8.281298742764584, "y": 50.00867084273389, "z": "NaN"},
        {"x": 8.281272742532217, "y": 50.00874687903089, "z": "NaN"},
        {"x": 8.281234434580242, "y": 50.00881377267493, "z": "NaN"},
        {"x": 8.281234434580242, "y": 50.00881377267493, "z": "NaN"},
        {"x": 8.281176835299384, "y": 50.00902754771364, "z": "NaN"},
        {"x": 8.28098937901436, "y": 50.00943918092699, "z": "NaN"},
        {"x": 8.28098937901436, "y": 50.00943918092699, "z": "NaN"},
        {"x": 8.280677782232422, "y": 50.01019463503255, "z": "NaN"},
        {"x": 8.28062883191784, "y": 50.01034115144297, "z": "NaN"},
        {"x": 8.280615420872714, "y": 50.01046051889425, "z": "NaN"},
        {"x": 8.280625422582977, "y": 50.01058169175515, "z": "NaN"},
        {"x": 8.280644254619675, "y": 50.010657022067114, "z": "NaN"},
        {"x": 8.280682992090153, "y": 50.01073476651955, "z": "NaN"},
        {"x": 8.280682992090153, "y": 50.01073476651955, "z": "NaN"},
        {"x": 8.280826761776888, "y": 50.01085191942355, "z": "NaN"},
        {"x": 8.281045633316053, "y": 50.010974674057934, "z": "NaN"},
        {"x": 8.2813478562369, "y": 50.01108070814998, "z": "NaN"},
        {"x": 8.2813478562369, "y": 50.01108070814998, "z": "NaN"},
        {"x": 8.2814048338205, "y": 50.01107615172001, "z": "NaN"},
        {"x": 8.2814609537597, "y": 50.011079077743, "z": "NaN"},
        {"x": 8.2814609537597, "y": 50.011079077743, "z": "NaN"},
        {"x": 8.281514548394, "y": 50.011089395077995, "z": "NaN"},
        {"x": 8.2815640256469, "y": 50.01110679778399, "z": "NaN"},
        {"x": 8.2816079131098, "y": 50.01113077431699, "z": "NaN"},
        {"x": 8.2816245360294, "y": 50.01114278254401, "z": "NaN"},
        {"x": 8.2816582371136, "y": 50.01117486986799, "z": "NaN"},
        {"x": 8.2816835034332, "y": 50.011211538476026, "z": "NaN"},
        {"x": 8.2816835034332, "y": 50.011211538476026, "z": "NaN"},
        {"x": 8.2816988301225, "y": 50.011249176848, "z": "NaN"},
        {"x": 8.2817056796749, "y": 50.01129154713299, "z": "NaN"},
        {"x": 8.2817056796749, "y": 50.01129154713299, "z": "NaN"},
        {"x": 8.28177031873358, "y": 50.01135396752797, "z": "NaN"},
        {"x": 8.281870412588123, "y": 50.01164604939817, "z": "NaN"},
        {"x": 8.281870412588123, "y": 50.01164604939817, "z": "NaN"},
        {"x": 8.281943391027694, "y": 50.0118944330428, "z": "NaN"},
        {"x": 8.281943391027694, "y": 50.011894433042826, "z": "NaN"},
        {"x": 8.28224111622832, "y": 50.01257872283312, "z": "NaN"},
        {"x": 8.28224111622832, "y": 50.01257872283312, "z": "NaN"},
        {"x": 8.282388637724143, "y": 50.012875834289304, "z": "NaN"},
        {"x": 8.282603214445347, "y": 50.01341424986179, "z": "NaN"},
        {"x": 8.282603214445347, "y": 50.01341424986179, "z": "NaN"},
        {"x": 8.282966653766856, "y": 50.014246746098856, "z": "NaN"},
        {"x": 8.283088694277026, "y": 50.01447598166065, "z": "NaN"},
        {"x": 8.283244262399904, "y": 50.01471641928913, "z": "NaN"},
        {"x": 8.283469567957145, "y": 50.01499649744738, "z": "NaN"},
        {"x": 8.283469567957145, "y": 50.01499649744738, "z": "NaN"},
        {"x": 8.283965217828909, "y": 50.01547503651853, "z": "NaN"},
        {"x": 8.283965217828909, "y": 50.01547503651853, "z": "NaN"},
        {"x": 8.28415699577346, "y": 50.01563532507227, "z": "NaN"},
        {"x": 8.28415699577346, "y": 50.01563532507227, "z": "NaN"},
        {"x": 8.284319026554906, "y": 50.01577041640963, "z": "NaN"},
        {"x": 8.284319026554906, "y": 50.01577041640963, "z": "NaN"},
        {"x": 8.285279500246174, "y": 50.01657119272344, "z": "NaN"},
        {"x": 8.285279500246174, "y": 50.01657119272344, "z": "NaN"},
        {"x": 8.285704630375077, "y": 50.01699172400254, "z": "NaN"},
        {"x": 8.285704630375077, "y": 50.01699172400254, "z": "NaN"},
        {"x": 8.28592658317103, "y": 50.01723128730649, "z": "NaN"},
        {"x": 8.286282646417748, "y": 50.01767938812136, "z": "NaN"},
        {"x": 8.286282646417748, "y": 50.01767938812136, "z": "NaN"},
        {"x": 8.286489544612841, "y": 50.017924908846936, "z": "NaN"},
        {"x": 8.286489544612841, "y": 50.017924908846936, "z": "NaN"},
        {"x": 8.286934939940569, "y": 50.01850240828643, "z": "NaN"},
        {"x": 8.286934939940569, "y": 50.01850240828643, "z": "NaN"},
        {"x": 8.28721674105569, "y": 50.018805262484385, "z": "NaN"},
        {"x": 8.28721674105569, "y": 50.018805262484385, "z": "NaN"},
        {"x": 8.287313925309153, "y": 50.01892364901965, "z": "NaN"},
        {"x": 8.287313925309153, "y": 50.01892364901965, "z": "NaN"},
        {"x": 8.28752922463611, "y": 50.019200053936416, "z": "NaN"},
        {"x": 8.28752922463611, "y": 50.019200053936416, "z": "NaN"},
        {"x": 8.28757583140188, "y": 50.01926117012916, "z": "NaN"},
        {"x": 8.28757583140188, "y": 50.01926117012916, "z": "NaN"},
        {"x": 8.287890559637065, "y": 50.01964560749178, "z": "NaN"},
        {"x": 8.287890559637065, "y": 50.01964560749178, "z": "NaN"},
        {"x": 8.287942185469513, "y": 50.01970657605405, "z": "NaN"},
        {"x": 8.287942185469513, "y": 50.01970657605405, "z": "NaN"},
        {"x": 8.288386121202784, "y": 50.02031418188451, "z": "NaN"},
        {"x": 8.288474725703248, "y": 50.020464504410526, "z": "NaN"},
        {"x": 8.288762971569323, "y": 50.02107934857397, "z": "NaN"},
        {"x": 8.289386510174873, "y": 50.02294373296669, "z": "NaN"},
        {"x": 8.289386510174873, "y": 50.02294373296669, "z": "NaN"},
        {"x": 8.289451539417117, "y": 50.023119952514335, "z": "NaN"},
        {"x": 8.289451539417117, "y": 50.02311995251431, "z": "NaN"},
        {"x": 8.289570316482822, "y": 50.023429057938905, "z": "NaN"},
        {"x": 8.289810374189639, "y": 50.02386848477696, "z": "NaN"},
        {"x": 8.290116146017395, "y": 50.02439493006893, "z": "NaN"},
        {"x": 8.291147001107324, "y": 50.02588207737042, "z": "NaN"},
        {"x": 8.291147001107324, "y": 50.02588207737042, "z": "NaN"},
        {"x": 8.291934542212253, "y": 50.02701324997075, "z": "NaN"},
        {"x": 8.292195710524645, "y": 50.02741193482185, "z": "NaN"},
        {"x": 8.293392365649517, "y": 50.029480847228186, "z": "NaN"},
        {"x": 8.293392365649517, "y": 50.029480847228186, "z": "NaN"},
        {"x": 8.293529878657477, "y": 50.029718589523696, "z": "NaN"},
        {"x": 8.293529878657477, "y": 50.029718589523696, "z": "NaN"},
        {"x": 8.293760503833154, "y": 50.03007362370881, "z": "NaN"},
        {"x": 8.293760503833154, "y": 50.03007362370881, "z": "NaN"},
        {"x": 8.29435285802704, "y": 50.030968909449435, "z": "NaN"},
        {"x": 8.29435285802704, "y": 50.030968909449435, "z": "NaN"},
        {"x": 8.294596792107003, "y": 50.031353997435836, "z": "NaN"},
        {"x": 8.294596792107003, "y": 50.031353997435836, "z": "NaN"},
        {"x": 8.295158193051371, "y": 50.03241083660802, "z": "NaN"},
        {"x": 8.295513831213526, "y": 50.033195695906976, "z": "NaN"},
        {"x": 8.295513831213526, "y": 50.033195695906976, "z": "NaN"},
        {"x": 8.295886740089179, "y": 50.03415651417156, "z": "NaN"},
        {"x": 8.295886740089179, "y": 50.03415651417156, "z": "NaN"},
        {"x": 8.296048594639378, "y": 50.03455185634188, "z": "NaN"},
        {"x": 8.297329097986655, "y": 50.036971163222326, "z": "NaN"},
        {"x": 8.297822550832048, "y": 50.03799377196168, "z": "NaN"},
        {"x": 8.297822550832048, "y": 50.03799377196168, "z": "NaN"},
        {"x": 8.297987954086137, "y": 50.038376943311405, "z": "NaN"},
        {"x": 8.298202083954928, "y": 50.03892771095122, "z": "NaN"},
        {"x": 8.298357205225384, "y": 50.039416455948285, "z": "NaN"},
        {"x": 8.298357205225384, "y": 50.039416455948285, "z": "NaN"},
        {"x": 8.298474401235936, "y": 50.03986187508868, "z": "NaN"},
        {"x": 8.298591953176823, "y": 50.04038962508057, "z": "NaN"},
        {"x": 8.298668628761607, "y": 50.04091945585525, "z": "NaN"},
        {"x": 8.298718482256245, "y": 50.04139157351876, "z": "NaN"},
        {"x": 8.298718482256245, "y": 50.04139157351876, "z": "NaN"},
        {"x": 8.298729402636294, "y": 50.04208380332365, "z": "NaN"},
        {"x": 8.298700089881136, "y": 50.0425572580054, "z": "NaN"},
        {"x": 8.298631774061434, "y": 50.04300546319404, "z": "NaN"},
        {"x": 8.29852509925204, "y": 50.043444692526975, "z": "NaN"},
        {"x": 8.298347345903723, "y": 50.043939899594264, "z": "NaN"},
        {"x": 8.29805632622561, "y": 50.04454535961542, "z": "NaN"},
        {"x": 8.29805632622561, "y": 50.04454535961542, "z": "NaN"},
        {"x": 8.297821373516538, "y": 50.04489588718622, "z": "NaN"},
        {"x": 8.297516327543223, "y": 50.04531396423686, "z": "NaN"},
        {"x": 8.297155103996614, "y": 50.04576659144225, "z": "NaN"},
        {"x": 8.297155103996614, "y": 50.04576659144225, "z": "NaN"},
        {"x": 8.296811582103013, "y": 50.04614714651029, "z": "NaN"},
        {"x": 8.29600135584082, "y": 50.04697724849803, "z": "NaN"},
        {"x": 8.29600135584082, "y": 50.04697724849803, "z": "NaN"},
        {"x": 8.294721739533799, "y": 50.04823327747022, "z": "NaN"},
        {"x": 8.293654102615042, "y": 50.04922412977821, "z": "NaN"},
        {"x": 8.293654102615042, "y": 50.04922412977821, "z": "NaN"},
        {"x": 8.29308286073319, "y": 50.04973165478949, "z": "NaN"},
        {"x": 8.29308286073319, "y": 50.04973165478952, "z": "NaN"},
        {"x": 8.292609576691792, "y": 50.050143965989236, "z": "NaN"},
        {"x": 8.292173843576604, "y": 50.050504605307545, "z": "NaN"},
        {"x": 8.292173843576604, "y": 50.050504605307545, "z": "NaN"},
        {"x": 8.290699493331772, "y": 50.05171766253782, "z": "NaN"},
        {"x": 8.290016871137487, "y": 50.05231871891604, "z": "NaN"},
        {"x": 8.289468359393958, "y": 50.05283882466332, "z": "NaN"},
        {"x": 8.289468359393958, "y": 50.05283882466332, "z": "NaN"},
        {"x": 8.289066028041727, "y": 50.05326420497461, "z": "NaN"},
        {"x": 8.28852288071621, "y": 50.05387126953614, "z": "NaN"},
        {"x": 8.28805483524311, "y": 50.05446799359876, "z": "NaN"},
        {"x": 8.28805483524311, "y": 50.05446799359876, "z": "NaN"},
        {"x": 8.287677649600433, "y": 50.055013046755775, "z": "NaN"},
        {"x": 8.287297781748713, "y": 50.05565280899217, "z": "NaN"},
        {"x": 8.286292288644244, "y": 50.05745365513836, "z": "NaN"},
        {"x": 8.285977380542139, "y": 50.05796132827456, "z": "NaN"},
        {"x": 8.28563074693649, "y": 50.058441713203976, "z": "NaN"},
        {"x": 8.285203961381757, "y": 50.058958281728664, "z": "NaN"},
        {"x": 8.284841548843533, "y": 50.05933880989972, "z": "NaN"},
        {"x": 8.284356069011812, "y": 50.059779630105595, "z": "NaN"},
        {"x": 8.283967148704644, "y": 50.06009905002865, "z": "NaN"},
        {"x": 8.283454846782783, "y": 50.06047873509522, "z": "NaN"},
        {"x": 8.282826262764175, "y": 50.060871500175736, "z": "NaN"},
        {"x": 8.282227183044732, "y": 50.06121432712545, "z": "NaN"},
        {"x": 8.282227183044732, "y": 50.06121432712545, "z": "NaN"},
        {"x": 8.281438515095505, "y": 50.0616006334751, "z": "NaN"},
        {"x": 8.280727631207702, "y": 50.06190600890644, "z": "NaN"},
        {"x": 8.27977256780069, "y": 50.062280860212255, "z": "NaN"},
        {"x": 8.277999361532887, "y": 50.0629256573403, "z": "NaN"},
        {"x": 8.277999361532887, "y": 50.06292565734028, "z": "NaN"},
        {"x": 8.27463742134867, "y": 50.06415295898346, "z": "NaN"},
        {"x": 8.27463742134867, "y": 50.06415295898346, "z": "NaN"},
        {"x": 8.27425321254867, "y": 50.064296020265736, "z": "NaN"},
        {"x": 8.27425321254867, "y": 50.064296020265736, "z": "NaN"},
        {"x": 8.269241769018308, "y": 50.06610874780491, "z": "NaN"},
        {"x": 8.269241769018308, "y": 50.06610874780491, "z": "NaN"},
        {"x": 8.26874406645578, "y": 50.06628877186283, "z": "NaN"},
        {"x": 8.26874406645578, "y": 50.06628877186283, "z": "NaN"},
        {"x": 8.265260081930146, "y": 50.06756563810055, "z": "NaN"},
        {"x": 8.263319838984017, "y": 50.06830444256612, "z": "NaN"},
        {"x": 8.26285279933931, "y": 50.06849963310654, "z": "NaN"},
        {"x": 8.262006484131975, "y": 50.06891731088396, "z": "NaN"},
        {"x": 8.262006484131975, "y": 50.06891731088396, "z": "NaN"},
        {"x": 8.261520372879588, "y": 50.06920085482077, "z": "NaN"},
        {"x": 8.261065777583108, "y": 50.069508069042826, "z": "NaN"},
        {"x": 8.261065777583108, "y": 50.069508069042826, "z": "NaN"},
        {"x": 8.260545283556395, "y": 50.06987157781238, "z": "NaN"},
        {"x": 8.259829916060049, "y": 50.070401123780165, "z": "NaN"},
        {"x": 8.258151635527357, "y": 50.07169588488001, "z": "NaN"},
        {"x": 8.258151635527357, "y": 50.07169588488001, "z": "NaN"},
        {"x": 8.2579690105894, "y": 50.07187605329073, "z": "NaN"},
        {"x": 8.2579690105894, "y": 50.07187605329073, "z": "NaN"},
        {"x": 8.257601588468507, "y": 50.072117516562244, "z": "NaN"},
        {"x": 8.257601588468507, "y": 50.072117516562244, "z": "NaN"},
        {"x": 8.25684851918774, "y": 50.07256361594917, "z": "NaN"},
        {"x": 8.256560593230622, "y": 50.07276745207503, "z": "NaN"},
        {"x": 8.256560593230622, "y": 50.07276745207503, "z": "NaN"},
        {"x": 8.255321646661743, "y": 50.07364275376407, "z": "NaN"},
        {"x": 8.255321646661743, "y": 50.07364275376407, "z": "NaN"},
        {"x": 8.254181440178295, "y": 50.07447100898019, "z": "NaN"},
        {"x": 8.254181440178295, "y": 50.07447100898019, "z": "NaN"},
        {"x": 8.253719057391907, "y": 50.07482548165766, "z": "NaN"},
        {"x": 8.25355775933365, "y": 50.07497285202587, "z": "NaN"},
        {"x": 8.25338847826146, "y": 50.07509880761924, "z": "NaN"},
        {"x": 8.253178896805343, "y": 50.075209322489115, "z": "NaN"},
        {"x": 8.253178896805343, "y": 50.075209322489115, "z": "NaN"},
        {"x": 8.251714843135225, "y": 50.07628794135344, "z": "NaN"},
        {"x": 8.251714843135225, "y": 50.07628794135344, "z": "NaN"},
        {"x": 8.251541672219897, "y": 50.076426172858824, "z": "NaN"},
        {"x": 8.251541672219897, "y": 50.076426172858824, "z": "NaN"},
        {"x": 8.250227969999997, "y": 50.07738830905831, "z": "NaN"},
        {"x": 8.250227969999997, "y": 50.07738830905831, "z": "NaN"},
        {"x": 8.249803092149582, "y": 50.07769683498676, "z": "NaN"},
        {"x": 8.249803092149582, "y": 50.07769683498676, "z": "NaN"},
        {"x": 8.249134843004203, "y": 50.07821624167377, "z": "NaN"},
        {"x": 8.249134843004203, "y": 50.07821624167377, "z": "NaN"},
        {"x": 8.24901572883606, "y": 50.078303885124676, "z": "NaN"},
        {"x": 8.24901572883606, "y": 50.078303885124676, "z": "NaN"},
        {"x": 8.247797133764283, "y": 50.07921321509809, "z": "NaN"},
        {"x": 8.247797133764283, "y": 50.07921321509809, "z": "NaN"},
        {"x": 8.247029311252385, "y": 50.07976107460572, "z": "NaN"},
        {"x": 8.246855598037282, "y": 50.079919933026886, "z": "NaN"},
        {"x": 8.246855598037282, "y": 50.079919933026886, "z": "NaN"},
        {"x": 8.247065298718011, "y": 50.080003371615625, "z": "NaN"},
        {"x": 8.247670299643401, "y": 50.080170316116096, "z": "NaN"},
        {"x": 8.247670299643401, "y": 50.080170316116096, "z": "NaN"},
        {"x": 8.247869122268446, "y": 50.08023121515301, "z": "NaN"},
        {"x": 8.247869122268446, "y": 50.08023121515301, "z": "NaN"},
        {"x": 8.247528659073788, "y": 50.082191394844365, "z": "NaN"},
        {"x": 8.247528659073788, "y": 50.082191394844365, "z": "NaN"},
        {"x": 8.247405795329334, "y": 50.08306966205819, "z": "NaN"},
        {"x": 8.247405795329334, "y": 50.08306966205819, "z": "NaN"},
        {"x": 8.247339771792056, "y": 50.08361622550605, "z": "NaN"},
        {"x": 8.247339771792056, "y": 50.08361622550607, "z": "NaN"},
        {"x": 8.247321625448992, "y": 50.08376342727354, "z": "NaN"},
        {"x": 8.247321625448992, "y": 50.08376342727354, "z": "NaN"},
        {"x": 8.247291101809203, "y": 50.08401103171967, "z": "NaN"},
        {"x": 8.247291101809203, "y": 50.0840110317197, "z": "NaN"},
        {"x": 8.247286829865775, "y": 50.08411891532466, "z": "NaN"},
    ],
}

GET_ALL_ROUTES_RESPONSE = {
    "alternatives": [
        {
            "response": {
                "results": [
                    {
                        "path": {
                            "segmentId": 72856060,
                            "nodeId": 79353354,
                            "x": 8.262231178841974,
                            "y": 50.00350434288446,
                            "direction": False,
                        },
                        "street": 1,
                        "altStreets": [0],
                        "distance": 0,
                        "length": 42,
                        "crossTime": 52,
                        "crossTimeWithoutRealTime": 52,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 4,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "TURN_LEFT", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857068,
                            "nodeId": 79353353,
                            "x": 8.262884296737077,
                            "y": 50.003263849158074,
                            "direction": True,
                        },
                        "street": 1,
                        "altStreets": [0],
                        "distance": 52,
                        "length": 83,
                        "crossTime": 10,
                        "crossTimeWithoutRealTime": 10,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858741,
                            "nodeId": 79354848,
                            "x": 8.263474564170831,
                            "y": 50.00389912419096,
                            "direction": True,
                        },
                        "street": 1,
                        "altStreets": [0],
                        "distance": 62,
                        "length": 110,
                        "crossTime": 13,
                        "crossTimeWithoutRealTime": 13,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858742,
                            "nodeId": 79354852,
                            "x": 8.264312573037357,
                            "y": 50.004726618565144,
                            "direction": True,
                        },
                        "street": 1,
                        "altStreets": [0],
                        "distance": 75,
                        "length": 126,
                        "crossTime": 26,
                        "crossTimeWithoutRealTime": 26,
                        "crossTimeFreeFlow": 11,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [
                                        {"angle": -90, "selected": False},
                                        {"angle": 0, "selected": True},
                                        {"angle": -180, "selected": False},
                                    ],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [
                                        {"angle": 0, "selected": True},
                                        {"angle": 90, "selected": False},
                                    ],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 2,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 72858739,
                            "nodeId": 79354745,
                            "x": 8.265242629013304,
                            "y": 50.00568941892085,
                            "direction": True,
                        },
                        "street": 1,
                        "altStreets": [0],
                        "distance": 101,
                        "length": 104,
                        "crossTime": 12,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 4,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "TURN_RIGHT", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858752,
                            "nodeId": 79356564,
                            "x": 8.266104288659388,
                            "y": 50.00642271162488,
                            "direction": True,
                        },
                        "street": 2,
                        "distance": 113,
                        "length": 63,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858753,
                            "nodeId": 79354855,
                            "x": 8.266819097361882,
                            "y": 50.00609453058361,
                            "direction": True,
                        },
                        "street": 2,
                        "distance": 122,
                        "length": 55,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 7,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 246047547,
                            "nodeId": 79356559,
                            "x": 8.26742661770343,
                            "y": 50.005794575894285,
                            "direction": True,
                        },
                        "street": 2,
                        "distance": 129,
                        "length": 10,
                        "crossTime": 1,
                        "crossTimeWithoutRealTime": 1,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 436037939,
                            "nodeId": 209641384,
                            "x": 8.267532620513155,
                            "y": 50.005739026738965,
                            "direction": False,
                        },
                        "street": 2,
                        "distance": 130,
                        "length": 60,
                        "crossTime": 8,
                        "crossTimeWithoutRealTime": 8,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 436037938,
                            "nodeId": 333577572,
                            "x": 8.268170502719617,
                            "y": 50.00539613646547,
                            "direction": False,
                        },
                        "street": 2,
                        "distance": 138,
                        "length": 116,
                        "crossTime": 23,
                        "crossTimeWithoutRealTime": 23,
                        "crossTimeFreeFlow": 17,
                        "knownDirection": True,
                        "penalty": 7,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "TURN_LEFT", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 370095308,
                            "nodeId": 79356560,
                            "x": 8.269412793478955,
                            "y": 50.00472834248692,
                            "direction": True,
                        },
                        "street": 3,
                        "distance": 161,
                        "length": 83,
                        "crossTime": 22,
                        "crossTimeWithoutRealTime": 22,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 370095309,
                            "nodeId": 290337089,
                            "x": 8.270124537611794,
                            "y": 50.00532038803219,
                            "direction": True,
                        },
                        "street": 3,
                        "distance": 183,
                        "length": 46,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 246495731,
                            "nodeId": 209928281,
                            "x": 8.270532223008138,
                            "y": 50.00564317452125,
                            "direction": True,
                        },
                        "street": 3,
                        "distance": 192,
                        "length": 31,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 6,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858761,
                            "nodeId": 79354839,
                            "x": 8.27080083664418,
                            "y": 50.00585835952036,
                            "direction": True,
                        },
                        "street": 3,
                        "distance": 199,
                        "length": 74,
                        "crossTime": 27,
                        "crossTimeWithoutRealTime": 27,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "TURN_RIGHT", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 162231268,
                            "nodeId": 162914110,
                            "x": 8.271637685856833,
                            "y": 50.00611392414356,
                            "direction": False,
                        },
                        "street": 5,
                        "altStreets": [4],
                        "distance": 226,
                        "length": 191,
                        "crossTime": 26,
                        "crossTimeWithoutRealTime": 26,
                        "crossTimeFreeFlow": 17,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 360439058,
                            "nodeId": 79354884,
                            "x": 8.273044504485089,
                            "y": 50.00466110951561,
                            "direction": False,
                        },
                        "street": 7,
                        "altStreets": [6],
                        "distance": 252,
                        "length": 137,
                        "crossTime": 17,
                        "crossTimeWithoutRealTime": 17,
                        "crossTimeFreeFlow": 12,
                        "knownDirection": True,
                        "penalty": 5,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -90, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": False}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [
                                        {"angle": 0, "selected": False},
                                        {"angle": 90, "selected": False},
                                    ],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "TURN_LEFT",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 0,
                                },
                                "angle": -45,
                                "angle_override": -90,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 399190430,
                            "nodeId": 284052144,
                            "x": 8.273971790530663,
                            "y": 50.00359047306348,
                            "direction": False,
                        },
                        "street": 7,
                        "altStreets": [6],
                        "distance": 269,
                        "length": 65,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 6,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 399190429,
                            "nodeId": 309295012,
                            "x": 8.27458476301202,
                            "y": 50.003390345561506,
                            "direction": False,
                        },
                        "street": 7,
                        "altStreets": [6],
                        "distance": 278,
                        "length": 37,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 392386961,
                            "nodeId": 79358204,
                            "x": 8.274416454396324,
                            "y": 50.003697642077995,
                            "direction": False,
                        },
                        "street": 7,
                        "altStreets": [6],
                        "distance": 283,
                        "length": 179,
                        "crossTime": 16,
                        "crossTimeWithoutRealTime": 16,
                        "crossTimeFreeFlow": 16,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 270261228,
                            "nodeId": 225111472,
                            "x": 8.27325020772032,
                            "y": 50.0050858175989,
                            "direction": False,
                        },
                        "street": 9,
                        "altStreets": [8],
                        "distance": 299,
                        "length": 36,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 239674002,
                            "nodeId": 79353332,
                            "x": 8.273584842682723,
                            "y": 50.00532475365378,
                            "direction": False,
                        },
                        "street": 9,
                        "altStreets": [8],
                        "distance": 303,
                        "length": 208,
                        "crossTime": 15,
                        "crossTimeWithoutRealTime": 15,
                        "crossTimeFreeFlow": 16,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 369081994,
                            "nodeId": 205584787,
                            "x": 8.276032753295809,
                            "y": 50.006327055101046,
                            "direction": False,
                        },
                        "street": 11,
                        "altStreets": [10],
                        "distance": 318,
                        "length": 309,
                        "crossTime": 40,
                        "crossTimeWithoutRealTime": 40,
                        "crossTimeFreeFlow": 22,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": False}],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "KEEP_LEFT",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 0,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 403833198,
                            "nodeId": 225111842,
                            "x": 8.27967572957318,
                            "y": 50.00781791594246,
                            "direction": True,
                        },
                        "street": 12,
                        "distance": 358,
                        "length": 77,
                        "crossTime": 14,
                        "crossTimeWithoutRealTime": 10,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 369081994,
                            "segment_direction": False,
                        },
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 403833199,
                            "nodeId": 312426534,
                            "x": 8.280588422753961,
                            "y": 50.00817553744451,
                            "direction": True,
                        },
                        "street": 12,
                        "distance": 372,
                        "length": 41,
                        "crossTime": 8,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 369081994,
                            "segment_direction": False,
                        },
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 239540450,
                            "nodeId": 205500150,
                            "x": 8.281030654908028,
                            "y": 50.008406125706664,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 380,
                        "length": 38,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 239540443,
                            "nodeId": 205500121,
                            "x": 8.281298742764584,
                            "y": 50.00867084273389,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 385,
                        "length": 17,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -45, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [
                                        {"angle": 45, "selected": True},
                                        {"angle": -45, "selected": False},
                                    ],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 239540450,
                            "segment_direction": True,
                        },
                        "instruction": {
                            "opcode": "KEEP_RIGHT",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 1,
                                },
                                "angle": 45,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 416527190,
                            "nodeId": 205500130,
                            "x": 8.281234434580242,
                            "y": 50.00881377267493,
                            "direction": True,
                        },
                        "street": 15,
                        "altStreets": [14],
                        "distance": 387,
                        "length": 72,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 7,
                        "crossTimeFreeFlow": 6,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 257351336,
                            "nodeId": 79357623,
                            "x": 8.28098937901436,
                            "y": 50.00943918092699,
                            "direction": False,
                        },
                        "street": 15,
                        "altStreets": [14],
                        "distance": 394,
                        "length": 148,
                        "crossTime": 13,
                        "crossTimeWithoutRealTime": 13,
                        "crossTimeFreeFlow": 12,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 188953304,
                            "nodeId": 79356765,
                            "x": 8.280682992090153,
                            "y": 50.01073476651955,
                            "direction": True,
                        },
                        "street": 15,
                        "altStreets": [14],
                        "distance": 407,
                        "length": 62,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 6,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "ROUNDABOUT_ENTER", "arg": 2},
                    },
                    {
                        "path": {
                            "segmentId": 405910183,
                            "nodeId": 313820661,
                            "x": 8.2813478562369,
                            "y": 50.01108070814998,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 416,
                        "length": 8,
                        "crossTime": 1,
                        "crossTimeWithoutRealTime": 1,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                    },
                    {
                        "path": {
                            "segmentId": 405910184,
                            "nodeId": 313820662,
                            "x": 8.2814609537597,
                            "y": 50.011079077743,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 417,
                        "length": 23,
                        "crossTime": 3,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                    },
                    {
                        "path": {
                            "segmentId": 405910185,
                            "nodeId": 313820663,
                            "x": 8.2816835034332,
                            "y": 50.011211538476026,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 420,
                        "length": 9,
                        "crossTime": 1,
                        "crossTimeWithoutRealTime": 1,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "ROUNDABOUT_EXIT", "arg": 2},
                    },
                    {
                        "path": {
                            "segmentId": 72861035,
                            "nodeId": 313820656,
                            "x": 8.2817056796749,
                            "y": 50.01129154713299,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 421,
                        "length": 42,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858815,
                            "nodeId": 79355011,
                            "x": 8.281870412588123,
                            "y": 50.01164604939817,
                            "direction": False,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 426,
                        "length": 28,
                        "crossTime": 3,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858814,
                            "nodeId": 79355010,
                            "x": 8.281943391027694,
                            "y": 50.0118944330428,
                            "direction": False,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 429,
                        "length": 79,
                        "crossTime": 8,
                        "crossTimeWithoutRealTime": 8,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857212,
                            "nodeId": 79355008,
                            "x": 8.28224111622832,
                            "y": 50.01257872283312,
                            "direction": False,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 437,
                        "length": 97,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 398640564,
                            "nodeId": 79355007,
                            "x": 8.282603214445347,
                            "y": 50.01341424986179,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 446,
                        "length": 187,
                        "crossTime": 16,
                        "crossTimeWithoutRealTime": 16,
                        "crossTimeFreeFlow": 15,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 398640565,
                            "nodeId": 308918826,
                            "x": 8.283469567957145,
                            "y": 50.01499649744738,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 462,
                        "length": 64,
                        "crossTime": 6,
                        "crossTimeWithoutRealTime": 6,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858822,
                            "nodeId": 79356588,
                            "x": 8.283965217828909,
                            "y": 50.01547503651856,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 468,
                        "length": 23,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 398513278,
                            "nodeId": 79356589,
                            "x": 8.28415699577346,
                            "y": 50.01563532507227,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 470,
                        "length": 19,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 398513280,
                            "nodeId": 308831979,
                            "x": 8.284319026554906,
                            "y": 50.01577041640963,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 472,
                        "length": 113,
                        "crossTime": 11,
                        "crossTimeWithoutRealTime": 11,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72862730,
                            "nodeId": 79358197,
                            "x": 8.285279500246174,
                            "y": 50.01657119272344,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 483,
                        "length": 56,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 359201998,
                            "nodeId": 79355060,
                            "x": 8.285704630375077,
                            "y": 50.01699172400254,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 488,
                        "length": 87,
                        "crossTime": 8,
                        "crossTimeWithoutRealTime": 8,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 359202001,
                            "nodeId": 283273243,
                            "x": 8.286282646417748,
                            "y": 50.01767938812136,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 496,
                        "length": 31,
                        "crossTime": 3,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 359202002,
                            "nodeId": 283273245,
                            "x": 8.286489544612841,
                            "y": 50.017924908846936,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 499,
                        "length": 72,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 7,
                        "crossTimeFreeFlow": 6,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 369982948,
                            "nodeId": 79353652,
                            "x": 8.286934939940569,
                            "y": 50.01850240828643,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 506,
                        "length": 39,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 369982949,
                            "nodeId": 290265373,
                            "x": 8.28721674105569,
                            "y": 50.018805262484385,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 510,
                        "length": 15,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 359202193,
                            "nodeId": 283273358,
                            "x": 8.287313925309153,
                            "y": 50.01892364901965,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 512,
                        "length": 34,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 359202190,
                            "nodeId": 283273356,
                            "x": 8.28752922463611,
                            "y": 50.019200053936416,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 517,
                        "length": 8,
                        "crossTime": 1,
                        "crossTimeWithoutRealTime": 1,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 359202111,
                            "nodeId": 283273312,
                            "x": 8.28757583140188,
                            "y": 50.01926117012916,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 518,
                        "length": 48,
                        "crossTime": 15,
                        "crossTimeWithoutRealTime": 15,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -90, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [
                                        {"angle": 0, "selected": True},
                                        {"angle": 90, "selected": False},
                                    ],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 2,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 420571611,
                            "nodeId": 174344265,
                            "x": 8.287890559637065,
                            "y": 50.01964560749178,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 533,
                        "length": 8,
                        "crossTime": 3,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 359202111,
                            "segment_direction": True,
                        },
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 420571706,
                            "nodeId": 323291959,
                            "x": 8.287942185469513,
                            "y": 50.01970657605405,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 536,
                        "length": 376,
                        "crossTime": 28,
                        "crossTimeWithoutRealTime": 28,
                        "crossTimeFreeFlow": 27,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 420571708,
                            "nodeId": 323292020,
                            "x": 8.289386510174873,
                            "y": 50.02294373296669,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 564,
                        "length": 20,
                        "crossTime": 1,
                        "crossTimeWithoutRealTime": 1,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 6,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 420572000,
                            "nodeId": 323291962,
                            "x": 8.289451539417117,
                            "y": 50.023119952514335,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 565,
                        "length": 331,
                        "crossTime": 26,
                        "crossTimeWithoutRealTime": 26,
                        "crossTimeFreeFlow": 23,
                        "knownDirection": True,
                        "penalty": 8,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 420572105,
                            "nodeId": 323292224,
                            "x": 8.291147001107324,
                            "y": 50.02588207737042,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 591,
                        "length": 432,
                        "crossTime": 30,
                        "crossTimeWithoutRealTime": 30,
                        "crossTimeFreeFlow": 28,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 420572106,
                            "nodeId": 323292298,
                            "x": 8.293392365649517,
                            "y": 50.029480847228186,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 621,
                        "length": 28,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 6,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 403456941,
                            "nodeId": 323292225,
                            "x": 8.293529878657477,
                            "y": 50.029718589523696,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 623,
                        "length": 43,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 6,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 45, "selected": False}],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "CONTINUE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 0,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 403456984,
                            "nodeId": 312171749,
                            "x": 8.293760503833154,
                            "y": 50.03007362370881,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 627,
                        "length": 108,
                        "crossTime": 6,
                        "crossTimeWithoutRealTime": 6,
                        "crossTimeFreeFlow": 6,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 403456985,
                            "nodeId": 312171771,
                            "x": 8.29435285802704,
                            "y": 50.030968909449435,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 633,
                        "length": 46,
                        "crossTime": 3,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 6,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 45, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 0,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 403457477,
                            "nodeId": 312171938,
                            "x": 8.294596792107003,
                            "y": 50.031353997435836,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 636,
                        "length": 215,
                        "crossTime": 12,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 11,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 403457478,
                            "nodeId": 312172067,
                            "x": 8.295513831213526,
                            "y": 50.033195695906976,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 648,
                        "length": 110,
                        "crossTime": 6,
                        "crossTimeWithoutRealTime": 6,
                        "crossTimeFreeFlow": 6,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 403646272,
                            "nodeId": 214044048,
                            "x": 8.295886740089179,
                            "y": 50.034156514171585,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 654,
                        "length": 449,
                        "crossTime": 20,
                        "crossTimeWithoutRealTime": 20,
                        "crossTimeFreeFlow": 20,
                        "knownDirection": True,
                        "penalty": 4,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857660,
                            "nodeId": 79355475,
                            "x": 8.297822550832048,
                            "y": 50.03799377196168,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 674,
                        "length": 163,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 7,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 270260191,
                            "nodeId": 152542831,
                            "x": 8.298357205225384,
                            "y": 50.039416455948285,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 681,
                        "length": 221,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 391255020,
                            "nodeId": 79353453,
                            "x": 8.298718482256245,
                            "y": 50.04139157351876,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 690,
                        "length": 356,
                        "crossTime": 14,
                        "crossTimeWithoutRealTime": 14,
                        "crossTimeFreeFlow": 15,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72856088,
                            "nodeId": 232259579,
                            "x": 8.29805632622561,
                            "y": 50.04454535961542,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 704,
                        "length": 150,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 7,
                        "crossTimeFreeFlow": 6,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 270259997,
                            "nodeId": 232259577,
                            "x": 8.297155103996614,
                            "y": 50.04576659144225,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 711,
                        "length": 158,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 7,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 45, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 403644391,
                            "nodeId": 79353397,
                            "x": 8.29600135584082,
                            "y": 50.04697724849803,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 718,
                        "length": 301,
                        "crossTime": 12,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 12,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72856105,
                            "nodeId": 79353303,
                            "x": 8.293654102615042,
                            "y": 50.04922412977821,
                            "direction": True,
                        },
                        "street": 18,
                        "distance": 730,
                        "length": 70,
                        "crossTime": 3,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 45, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 270468796,
                            "nodeId": 79353310,
                            "x": 8.29308286073319,
                            "y": 50.04973165478949,
                            "direction": True,
                        },
                        "street": 18,
                        "distance": 733,
                        "length": 108,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 403644528,
                            "nodeId": 79353306,
                            "x": 8.292173843576604,
                            "y": 50.050504605307545,
                            "direction": True,
                        },
                        "street": 18,
                        "distance": 737,
                        "length": 324,
                        "crossTime": 12,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 12,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 403644909,
                            "nodeId": 216801994,
                            "x": 8.289468359393958,
                            "y": 50.05283882466332,
                            "direction": True,
                        },
                        "street": 18,
                        "distance": 749,
                        "length": 208,
                        "crossTime": 8,
                        "crossTimeWithoutRealTime": 8,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 403645057,
                            "nodeId": 312297451,
                            "x": 8.28805483524311,
                            "y": 50.05446799359876,
                            "direction": True,
                        },
                        "street": 18,
                        "distance": 757,
                        "length": 871,
                        "crossTime": 34,
                        "crossTimeWithoutRealTime": 34,
                        "crossTimeFreeFlow": 35,
                        "knownDirection": True,
                        "penalty": 4,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 403645103,
                            "nodeId": 312297570,
                            "x": 8.282227183044732,
                            "y": 50.06121432712545,
                            "direction": True,
                        },
                        "street": 20,
                        "altStreets": [19],
                        "distance": 791,
                        "length": 358,
                        "crossTime": 15,
                        "crossTimeWithoutRealTime": 15,
                        "crossTimeFreeFlow": 15,
                        "knownDirection": True,
                        "penalty": 4,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 45, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 403645289,
                            "nodeId": 312297615,
                            "x": 8.277999361532887,
                            "y": 50.06292565734028,
                            "direction": True,
                        },
                        "street": 20,
                        "altStreets": [19],
                        "distance": 806,
                        "length": 277,
                        "crossTime": 12,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 12,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 403645290,
                            "nodeId": 312297732,
                            "x": 8.27463742134867,
                            "y": 50.06415295898346,
                            "direction": True,
                        },
                        "street": 20,
                        "altStreets": [19],
                        "distance": 818,
                        "length": 32,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 1,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 403645382,
                            "nodeId": 312297731,
                            "x": 8.27425321254867,
                            "y": 50.064296020265736,
                            "direction": True,
                        },
                        "street": 21,
                        "altStreets": [19],
                        "distance": 820,
                        "length": 412,
                        "crossTime": 20,
                        "crossTimeWithoutRealTime": 20,
                        "crossTimeFreeFlow": 19,
                        "knownDirection": True,
                        "penalty": 4,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 403645384,
                            "nodeId": 312297772,
                            "x": 8.269241769018308,
                            "y": 50.06610874780491,
                            "direction": True,
                        },
                        "street": 21,
                        "altStreets": [19],
                        "distance": 840,
                        "length": 41,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 45, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 403645575,
                            "nodeId": 312297803,
                            "x": 8.26874406645578,
                            "y": 50.06628877186283,
                            "direction": True,
                        },
                        "street": 21,
                        "altStreets": [19],
                        "distance": 842,
                        "length": 565,
                        "crossTime": 71,
                        "crossTimeWithoutRealTime": 71,
                        "crossTimeFreeFlow": 34,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 403645505,
                            "nodeId": 312297926,
                            "x": 8.262006484131975,
                            "y": 50.06891731088396,
                            "direction": True,
                        },
                        "street": 21,
                        "altStreets": [19],
                        "distance": 913,
                        "length": 94,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 7,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [
                                        {"angle": 0, "selected": False},
                                        {"angle": 0, "selected": True},
                                    ],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 45, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                                "enable_display": True,
                                "enable_voice": False,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 403646403,
                            "nodeId": 312297993,
                            "x": 8.261065777583108,
                            "y": 50.069508069042826,
                            "direction": True,
                        },
                        "street": 21,
                        "altStreets": [19],
                        "distance": 920,
                        "length": 321,
                        "crossTime": 26,
                        "crossTimeWithoutRealTime": 26,
                        "crossTimeFreeFlow": 24,
                        "knownDirection": True,
                        "penalty": 4,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -45, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": -45, "selected": False}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "CONTINUE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 2,
                                    "to_lane_index": 2,
                                },
                                "angle": 45,
                                "angle_override": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 432698841,
                            "nodeId": 79354101,
                            "x": 8.258151635527357,
                            "y": 50.07169588488001,
                            "direction": True,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 946,
                        "length": 61,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 392456904,
                            "nodeId": 304758949,
                            "x": 8.257601588468507,
                            "y": 50.072117516562244,
                            "direction": True,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 950,
                        "length": 104,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 7,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 392456905,
                            "nodeId": 304758951,
                            "x": 8.256560593230622,
                            "y": 50.07276745207503,
                            "direction": True,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 957,
                        "length": 132,
                        "crossTime": 12,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857995,
                            "nodeId": 79353501,
                            "x": 8.255321646661743,
                            "y": 50.07364275376407,
                            "direction": False,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 969,
                        "length": 123,
                        "crossTime": 22,
                        "crossTimeWithoutRealTime": 22,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [
                                        {"angle": -90, "selected": False},
                                        {"angle": -180, "selected": False},
                                    ],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 90, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                                "enable_display": True,
                                "enable_voice": False,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 72857994,
                            "nodeId": 79355835,
                            "x": 8.254181440178295,
                            "y": 50.07447100898019,
                            "direction": False,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 991,
                        "length": 109,
                        "crossTime": 13,
                        "crossTimeWithoutRealTime": 13,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858013,
                            "nodeId": 79355850,
                            "x": 8.253178896805343,
                            "y": 50.075209322489115,
                            "direction": False,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 1004,
                        "length": 159,
                        "crossTime": 18,
                        "crossTimeWithoutRealTime": 18,
                        "crossTimeFreeFlow": 13,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 238123028,
                            "nodeId": 79355857,
                            "x": 8.251714843135225,
                            "y": 50.07628794135344,
                            "direction": False,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 1022,
                        "length": 20,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 238123027,
                            "nodeId": 204585735,
                            "x": 8.251541672219897,
                            "y": 50.076426172858824,
                            "direction": False,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 1024,
                        "length": 142,
                        "crossTime": 16,
                        "crossTimeWithoutRealTime": 16,
                        "crossTimeFreeFlow": 11,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72862880,
                            "nodeId": 79358062,
                            "x": 8.250227969999997,
                            "y": 50.07738830905831,
                            "direction": False,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 1040,
                        "length": 46,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 241124839,
                            "nodeId": 79358269,
                            "x": 8.249803092149582,
                            "y": 50.07769683498676,
                            "direction": False,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 1045,
                        "length": 75,
                        "crossTime": 11,
                        "crossTimeWithoutRealTime": 11,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 241124838,
                            "nodeId": 206526997,
                            "x": 8.249134843004203,
                            "y": 50.07821624167377,
                            "direction": False,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 1056,
                        "length": 13,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72863186,
                            "nodeId": 79358414,
                            "x": 8.24901572883606,
                            "y": 50.078303885124676,
                            "direction": True,
                        },
                        "street": 24,
                        "altStreets": [22],
                        "distance": 1058,
                        "length": 134,
                        "crossTime": 16,
                        "crossTimeWithoutRealTime": 16,
                        "crossTimeFreeFlow": 12,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72869087,
                            "nodeId": 79362696,
                            "x": 8.247797133764283,
                            "y": 50.07921321509809,
                            "direction": False,
                        },
                        "street": 24,
                        "altStreets": [22],
                        "distance": 1074,
                        "length": 104,
                        "crossTime": 50,
                        "crossTimeWithoutRealTime": 50,
                        "crossTimeFreeFlow": 14,
                        "knownDirection": True,
                        "penalty": 4,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "TURN_RIGHT", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72867885,
                            "nodeId": 79360870,
                            "x": 8.246855598037282,
                            "y": 50.079919933026886,
                            "direction": False,
                        },
                        "street": 26,
                        "altStreets": [25],
                        "distance": 1124,
                        "length": 65,
                        "crossTime": 10,
                        "crossTimeWithoutRealTime": 10,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72868025,
                            "nodeId": 79362297,
                            "x": 8.247670299643401,
                            "y": 50.080170316116096,
                            "direction": False,
                        },
                        "street": 26,
                        "altStreets": [25],
                        "distance": 1134,
                        "length": 16,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 6,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "TURN_LEFT", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72867525,
                            "nodeId": 79360553,
                            "x": 8.247869122268446,
                            "y": 50.08023121515301,
                            "direction": True,
                        },
                        "street": 27,
                        "distance": 1139,
                        "length": 219,
                        "crossTime": 32,
                        "crossTimeWithoutRealTime": 32,
                        "crossTimeFreeFlow": 27,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 190701025,
                            "nodeId": 79362142,
                            "x": 8.247528659073788,
                            "y": 50.082191394844365,
                            "direction": True,
                        },
                        "street": 27,
                        "distance": 1171,
                        "length": 98,
                        "crossTime": 22,
                        "crossTimeWithoutRealTime": 22,
                        "crossTimeFreeFlow": 15,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 252683862,
                            "nodeId": 177152399,
                            "x": 8.247405795329334,
                            "y": 50.08306966205819,
                            "direction": True,
                        },
                        "street": 27,
                        "distance": 1193,
                        "length": 61,
                        "crossTime": 20,
                        "crossTimeWithoutRealTime": 20,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 387144732,
                            "nodeId": 79362140,
                            "x": 8.247339771792056,
                            "y": 50.08361622550607,
                            "direction": True,
                        },
                        "street": 27,
                        "distance": 1213,
                        "length": 16,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 387144733,
                            "nodeId": 301385364,
                            "x": 8.247321625448992,
                            "y": 50.08376342727354,
                            "direction": True,
                        },
                        "street": 27,
                        "distance": 1217,
                        "length": 28,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 270634256,
                            "nodeId": 213790660,
                            "x": 8.247291101809203,
                            "y": 50.08401103171967,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 1226,
                        "length": 12,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "APPROACHING_DESTINATION", "arg": 0},
                    },
                ],
                "streetNames": [
                    "Kaiserstraße",
                    "B40 - Kaiserstraße",
                    "Kaiser-Friedrich-Straße",
                    "Große Bleiche",
                    "Peter-Altmeier-Allee",
                    "B40 - Peter-Altmeier-Allee",
                    "Rheinstraße",
                    "B40 - Rheinstraße",
                    "Theodor-Heuss-Brücke",
                    "B40 - Theodor-Heuss-Brücke",
                    "Theodor-Heuss-Brücke",
                    "B40 - Theodor-Heuss-Brücke",
                    "B40",
                    None,
                    "Ludwigsrampe",
                    "B455 - Ludwigsrampe",
                    "Boelckestraße",
                    "B455 - Boelckestraße",
                    "B455",
                    "Berliner Straße",
                    "B455 - Berliner Straße",
                    "B54 - Berliner Straße",
                    "Frankfurter Straße",
                    "L3037 - Frankfurter Straße",
                    "K658 - Frankfurter Straße",
                    "Bierstadter Straße",
                    "K659 - Bierstadter Straße",
                    "Paulinenstraße",
                ],
                "fromlocMetersFromGeom": 14.529273,
                "fromFraction": 0.7886346623377086,
                "toFraction": 0.4876577222349604,
                "sameFromSegment": True,
                "sameToSegment": True,
                "tollMeters": 0,
                "preferedRouteId": -1,
                "isInvalid": False,
                "isBlocked": False,
                "serverUniqueId": "m23130394891406600",
                "displayRoute": True,
                "astarVisited": 15280,
                "astarResult": "UNKNOWN",
                "isRestricted": False,
                "avoidStatus": "MAYBE",
                "passesThroughDangerArea": False,
                "distanceFromSource": 14,
                "distanceFromTarget": 39,
                "minPassengers": 0,
                "hovIndex": -1,
                "preRefinedRouteIndex": -1,
                "blockedRouteUid": -1,
                "alternativeRouteUuid": "76a668f4-f871-4f70-99cb-ee97be341183",
                "serverTilesVersion": 1705557311000,
                "rankBeforeReordering": 0,
                "serverType": "LIVEMAP",
                "routeType": ["Best", "Natural"],
                "routeAttr": ["RestrictedZone"],
                "astarCost": 1435,
                "totalRouteTime": 1230,
                "totalRouteTimeWithoutRealtime": 1217,
                "totalRouteTimeFreeFlow": 877,
                "carbonEmissionsGrams": 0,
                "creationMechanismSet": ["ASTAR", "AERIAL_TIME_HEURISTIC"],
                "laneTypes": [],
                "areas": ["Umweltzone"],
                "requiredPermits": [],
                "etaHistograms": [],
                "shortRouteName": "B455 - Boelckestraße Wiesbaden",
                "tollPrice": 0.0,
                "isInvalidForPrivateVehicle": False,
                "costInfo": {
                    "unbiasedAstarCost": 1433,
                    "tollAsSeconds": 0,
                    "keepForReordering": False,
                },
                "destinationInformation": {
                    "segment_id": 270634256,
                    "street_id": 7744185,
                    "city_id": 27809,
                    "country_id": 81,
                    "city_name": "Wiesbaden",
                    "exit_node_id": 226350621,
                },
                "routeName": "B455 - Boelckestraße Wiesbaden",
                "routeNameStreetIds": [28024652],
                "totalRouteTimeWithoutMl": 1230,
                "open": False,
            },
            "coords": [
                {"x": 8.262364726690599, "y": 50.00345516735274, "z": "NaN"},
                {"x": 8.262884296737077, "y": 50.003263849158074, "z": "NaN"},
                {"x": 8.262884296737077, "y": 50.003263849158074, "z": "NaN"},
                {"x": 8.26296619483727, "y": 50.00339573042915, "z": "NaN"},
                {"x": 8.263474564170831, "y": 50.00389912419096, "z": "NaN"},
                {"x": 8.263474564170831, "y": 50.00389912419096, "z": "NaN"},
                {"x": 8.264312573037357, "y": 50.004726618565144, "z": "NaN"},
                {"x": 8.264312573037357, "y": 50.004726618565144, "z": "NaN"},
                {"x": 8.265242629013304, "y": 50.00568941892085, "z": "NaN"},
                {"x": 8.265242629013304, "y": 50.00568941892085, "z": "NaN"},
                {"x": 8.265759624800928, "y": 50.006232224674996, "z": "NaN"},
                {"x": 8.26586423095251, "y": 50.00630548897572, "z": "NaN"},
                {"x": 8.266104288659388, "y": 50.00642271162488, "z": "NaN"},
                {"x": 8.266104288659388, "y": 50.00642271162488, "z": "NaN"},
                {"x": 8.266819097361882, "y": 50.00609453058361, "z": "NaN"},
                {"x": 8.266819097361882, "y": 50.00609453058361, "z": "NaN"},
                {"x": 8.26742661770343, "y": 50.005794575894285, "z": "NaN"},
                {"x": 8.26742661770343, "y": 50.005794575894285, "z": "NaN"},
                {"x": 8.267532620513155, "y": 50.005739026738965, "z": "NaN"},
                {"x": 8.267532620513155, "y": 50.005739026738965, "z": "NaN"},
                {"x": 8.268170502719617, "y": 50.00539613646547, "z": "NaN"},
                {"x": 8.268170502719617, "y": 50.00539613646547, "z": "NaN"},
                {"x": 8.269412793478955, "y": 50.00472834248692, "z": "NaN"},
                {"x": 8.269412793478955, "y": 50.00472834248692, "z": "NaN"},
                {"x": 8.270124537611794, "y": 50.00532038803219, "z": "NaN"},
                {"x": 8.270124537611794, "y": 50.00532038803219, "z": "NaN"},
                {"x": 8.270532223008138, "y": 50.00564317452125, "z": "NaN"},
                {"x": 8.270532223008138, "y": 50.00564317452125, "z": "NaN"},
                {"x": 8.27080083664418, "y": 50.00585835952036, "z": "NaN"},
                {"x": 8.27080083664418, "y": 50.00585835952036, "z": "NaN"},
                {"x": 8.271031506619494, "y": 50.00597041163063, "z": "NaN"},
                {"x": 8.271205561096314, "y": 50.00611311161945, "z": "NaN"},
                {"x": 8.271322907740654, "y": 50.00615405354942, "z": "NaN"},
                {"x": 8.271446959907625, "y": 50.00615405354976, "z": "NaN"},
                {"x": 8.271637685856833, "y": 50.00611392414356, "z": "NaN"},
                {"x": 8.271637685856833, "y": 50.00611392414356, "z": "NaN"},
                {"x": 8.27170798235573, "y": 50.00600453636846, "z": "NaN"},
                {"x": 8.271787666586183, "y": 50.00591368004332, "z": "NaN"},
                {"x": 8.273044504485089, "y": 50.00466110951561, "z": "NaN"},
                {"x": 8.273044504485089, "y": 50.00466110951561, "z": "NaN"},
                {"x": 8.273474809463597, "y": 50.00421243931527, "z": "NaN"},
                {"x": 8.273716018706539, "y": 50.00393185031846, "z": "NaN"},
                {"x": 8.273971790530663, "y": 50.00359047306348, "z": "NaN"},
                {"x": 8.273971790530663, "y": 50.00359047306348, "z": "NaN"},
                {"x": 8.274058150504036, "y": 50.003546367736924, "z": "NaN"},
                {"x": 8.274210941546816, "y": 50.003356526900085, "z": "NaN"},
                {"x": 8.274288378915841, "y": 50.00331492185268, "z": "NaN"},
                {"x": 8.274394326171992, "y": 50.003298544117264, "z": "NaN"},
                {"x": 8.274480156860436, "y": 50.00331319788084, "z": "NaN"},
                {"x": 8.274545870981296, "y": 50.00334681532102, "z": "NaN"},
                {"x": 8.27458476301202, "y": 50.003390345561506, "z": "NaN"},
                {"x": 8.27458476301202, "y": 50.003390345561506, "z": "NaN"},
                {"x": 8.274594150743576, "y": 50.00343689270589, "z": "NaN"},
                {"x": 8.274576884023038, "y": 50.003493999094275, "z": "NaN"},
                {"x": 8.274488538763608, "y": 50.00359204952739, "z": "NaN"},
                {"x": 8.274416454396324, "y": 50.00369764207802, "z": "NaN"},
                {"x": 8.274416454396324, "y": 50.003697642077995, "z": "NaN"},
                {"x": 8.273315251288938, "y": 50.00481947302412, "z": "NaN"},
                {"x": 8.273255572138392, "y": 50.00490092807522, "z": "NaN"},
                {"x": 8.273228750048222, "y": 50.00500436286148, "z": "NaN"},
                {"x": 8.27325020772032, "y": 50.0050858175989, "z": "NaN"},
                {"x": 8.27325020772032, "y": 50.0050858175989, "z": "NaN"},
                {"x": 8.273308606093535, "y": 50.00515586872543, "z": "NaN"},
                {"x": 8.273381086064076, "y": 50.00520954266566, "z": "NaN"},
                {"x": 8.273584842682723, "y": 50.00532475365378, "z": "NaN"},
                {"x": 8.273584842682723, "y": 50.00532475365378, "z": "NaN"},
                {"x": 8.276032753295809, "y": 50.006327055101046, "z": "NaN"},
                {"x": 8.276032753295809, "y": 50.006327055101046, "z": "NaN"},
                {"x": 8.27967572957318, "y": 50.00781791594246, "z": "NaN"},
                {"x": 8.27967572957318, "y": 50.00781791594246, "z": "NaN"},
                {"x": 8.280186377466098, "y": 50.007979597478894, "z": "NaN"},
                {"x": 8.280588422753961, "y": 50.00817553744451, "z": "NaN"},
                {"x": 8.280588422753961, "y": 50.00817553744451, "z": "NaN"},
                {"x": 8.281030654908028, "y": 50.008406125706664, "z": "NaN"},
                {"x": 8.281030654908028, "y": 50.008406125706664, "z": "NaN"},
                {"x": 8.281167515223444, "y": 50.00846965427605, "z": "NaN"},
                {"x": 8.28125383786892, "y": 50.008529336001615, "z": "NaN"},
                {"x": 8.28129372524024, "y": 50.00858418944403, "z": "NaN"},
                {"x": 8.281298742764584, "y": 50.00867084273389, "z": "NaN"},
                {"x": 8.281298742764584, "y": 50.00867084273389, "z": "NaN"},
                {"x": 8.281272742532217, "y": 50.00874687903089, "z": "NaN"},
                {"x": 8.281234434580242, "y": 50.00881377267493, "z": "NaN"},
                {"x": 8.281234434580242, "y": 50.00881377267493, "z": "NaN"},
                {"x": 8.281176835299384, "y": 50.00902754771364, "z": "NaN"},
                {"x": 8.28098937901436, "y": 50.00943918092699, "z": "NaN"},
                {"x": 8.28098937901436, "y": 50.00943918092699, "z": "NaN"},
                {"x": 8.280677782232422, "y": 50.01019463503255, "z": "NaN"},
                {"x": 8.28062883191784, "y": 50.01034115144297, "z": "NaN"},
                {"x": 8.280615420872714, "y": 50.01046051889425, "z": "NaN"},
                {"x": 8.280625422582977, "y": 50.01058169175515, "z": "NaN"},
                {"x": 8.280644254619675, "y": 50.010657022067114, "z": "NaN"},
                {"x": 8.280682992090153, "y": 50.01073476651955, "z": "NaN"},
                {"x": 8.280682992090153, "y": 50.01073476651955, "z": "NaN"},
                {"x": 8.280826761776888, "y": 50.01085191942355, "z": "NaN"},
                {"x": 8.281045633316053, "y": 50.010974674057934, "z": "NaN"},
                {"x": 8.2813478562369, "y": 50.01108070814998, "z": "NaN"},
                {"x": 8.2813478562369, "y": 50.01108070814998, "z": "NaN"},
                {"x": 8.2814048338205, "y": 50.01107615172001, "z": "NaN"},
                {"x": 8.2814609537597, "y": 50.011079077743, "z": "NaN"},
                {"x": 8.2814609537597, "y": 50.011079077743, "z": "NaN"},
                {"x": 8.281514548394, "y": 50.011089395077995, "z": "NaN"},
                {"x": 8.2815640256469, "y": 50.01110679778399, "z": "NaN"},
                {"x": 8.2816079131098, "y": 50.01113077431699, "z": "NaN"},
                {"x": 8.2816245360294, "y": 50.01114278254401, "z": "NaN"},
                {"x": 8.2816582371136, "y": 50.01117486986799, "z": "NaN"},
                {"x": 8.2816835034332, "y": 50.011211538476026, "z": "NaN"},
                {"x": 8.2816835034332, "y": 50.011211538476026, "z": "NaN"},
                {"x": 8.2816988301225, "y": 50.011249176848, "z": "NaN"},
                {"x": 8.2817056796749, "y": 50.01129154713299, "z": "NaN"},
                {"x": 8.2817056796749, "y": 50.01129154713299, "z": "NaN"},
                {"x": 8.28177031873358, "y": 50.01135396752797, "z": "NaN"},
                {"x": 8.281870412588123, "y": 50.01164604939817, "z": "NaN"},
                {"x": 8.281870412588123, "y": 50.01164604939817, "z": "NaN"},
                {"x": 8.281943391027694, "y": 50.0118944330428, "z": "NaN"},
                {"x": 8.281943391027694, "y": 50.011894433042826, "z": "NaN"},
                {"x": 8.28224111622832, "y": 50.01257872283312, "z": "NaN"},
                {"x": 8.28224111622832, "y": 50.01257872283312, "z": "NaN"},
                {"x": 8.282388637724143, "y": 50.012875834289304, "z": "NaN"},
                {"x": 8.282603214445347, "y": 50.01341424986179, "z": "NaN"},
                {"x": 8.282603214445347, "y": 50.01341424986179, "z": "NaN"},
                {"x": 8.282966653766856, "y": 50.014246746098856, "z": "NaN"},
                {"x": 8.283088694277026, "y": 50.01447598166065, "z": "NaN"},
                {"x": 8.283244262399904, "y": 50.01471641928913, "z": "NaN"},
                {"x": 8.283469567957145, "y": 50.01499649744738, "z": "NaN"},
                {"x": 8.283469567957145, "y": 50.01499649744738, "z": "NaN"},
                {"x": 8.283965217828909, "y": 50.01547503651853, "z": "NaN"},
                {"x": 8.283965217828909, "y": 50.01547503651853, "z": "NaN"},
                {"x": 8.28415699577346, "y": 50.01563532507227, "z": "NaN"},
                {"x": 8.28415699577346, "y": 50.01563532507227, "z": "NaN"},
                {"x": 8.284319026554906, "y": 50.01577041640963, "z": "NaN"},
                {"x": 8.284319026554906, "y": 50.01577041640963, "z": "NaN"},
                {"x": 8.285279500246174, "y": 50.01657119272344, "z": "NaN"},
                {"x": 8.285279500246174, "y": 50.01657119272344, "z": "NaN"},
                {"x": 8.285704630375077, "y": 50.01699172400254, "z": "NaN"},
                {"x": 8.285704630375077, "y": 50.01699172400254, "z": "NaN"},
                {"x": 8.28592658317103, "y": 50.01723128730649, "z": "NaN"},
                {"x": 8.286282646417748, "y": 50.01767938812136, "z": "NaN"},
                {"x": 8.286282646417748, "y": 50.01767938812136, "z": "NaN"},
                {"x": 8.286489544612841, "y": 50.017924908846936, "z": "NaN"},
                {"x": 8.286489544612841, "y": 50.017924908846936, "z": "NaN"},
                {"x": 8.286934939940569, "y": 50.01850240828643, "z": "NaN"},
                {"x": 8.286934939940569, "y": 50.01850240828643, "z": "NaN"},
                {"x": 8.28721674105569, "y": 50.018805262484385, "z": "NaN"},
                {"x": 8.28721674105569, "y": 50.018805262484385, "z": "NaN"},
                {"x": 8.287313925309153, "y": 50.01892364901965, "z": "NaN"},
                {"x": 8.287313925309153, "y": 50.01892364901965, "z": "NaN"},
                {"x": 8.28752922463611, "y": 50.019200053936416, "z": "NaN"},
                {"x": 8.28752922463611, "y": 50.019200053936416, "z": "NaN"},
                {"x": 8.28757583140188, "y": 50.01926117012916, "z": "NaN"},
                {"x": 8.28757583140188, "y": 50.01926117012916, "z": "NaN"},
                {"x": 8.287890559637065, "y": 50.01964560749178, "z": "NaN"},
                {"x": 8.287890559637065, "y": 50.01964560749178, "z": "NaN"},
                {"x": 8.287942185469513, "y": 50.01970657605405, "z": "NaN"},
                {"x": 8.287942185469513, "y": 50.01970657605405, "z": "NaN"},
                {"x": 8.288386121202784, "y": 50.02031418188451, "z": "NaN"},
                {"x": 8.288474725703248, "y": 50.020464504410526, "z": "NaN"},
                {"x": 8.288762971569323, "y": 50.02107934857397, "z": "NaN"},
                {"x": 8.289386510174873, "y": 50.02294373296669, "z": "NaN"},
                {"x": 8.289386510174873, "y": 50.02294373296669, "z": "NaN"},
                {"x": 8.289451539417117, "y": 50.023119952514335, "z": "NaN"},
                {"x": 8.289451539417117, "y": 50.02311995251431, "z": "NaN"},
                {"x": 8.289570316482822, "y": 50.023429057938905, "z": "NaN"},
                {"x": 8.289810374189639, "y": 50.02386848477696, "z": "NaN"},
                {"x": 8.290116146017395, "y": 50.02439493006893, "z": "NaN"},
                {"x": 8.291147001107324, "y": 50.02588207737042, "z": "NaN"},
                {"x": 8.291147001107324, "y": 50.02588207737042, "z": "NaN"},
                {"x": 8.291934542212253, "y": 50.02701324997075, "z": "NaN"},
                {"x": 8.292195710524645, "y": 50.02741193482185, "z": "NaN"},
                {"x": 8.293392365649517, "y": 50.029480847228186, "z": "NaN"},
                {"x": 8.293392365649517, "y": 50.029480847228186, "z": "NaN"},
                {"x": 8.293529878657477, "y": 50.029718589523696, "z": "NaN"},
                {"x": 8.293529878657477, "y": 50.029718589523696, "z": "NaN"},
                {"x": 8.293760503833154, "y": 50.03007362370881, "z": "NaN"},
                {"x": 8.293760503833154, "y": 50.03007362370881, "z": "NaN"},
                {"x": 8.29435285802704, "y": 50.030968909449435, "z": "NaN"},
                {"x": 8.29435285802704, "y": 50.030968909449435, "z": "NaN"},
                {"x": 8.294596792107003, "y": 50.031353997435836, "z": "NaN"},
                {"x": 8.294596792107003, "y": 50.031353997435836, "z": "NaN"},
                {"x": 8.295158193051371, "y": 50.03241083660802, "z": "NaN"},
                {"x": 8.295513831213526, "y": 50.033195695906976, "z": "NaN"},
                {"x": 8.295513831213526, "y": 50.033195695906976, "z": "NaN"},
                {"x": 8.295886740089179, "y": 50.03415651417156, "z": "NaN"},
                {"x": 8.295886740089179, "y": 50.03415651417156, "z": "NaN"},
                {"x": 8.296048594639378, "y": 50.03455185634188, "z": "NaN"},
                {"x": 8.297329097986655, "y": 50.036971163222326, "z": "NaN"},
                {"x": 8.297822550832048, "y": 50.03799377196168, "z": "NaN"},
                {"x": 8.297822550832048, "y": 50.03799377196168, "z": "NaN"},
                {"x": 8.297987954086137, "y": 50.038376943311405, "z": "NaN"},
                {"x": 8.298202083954928, "y": 50.03892771095122, "z": "NaN"},
                {"x": 8.298357205225384, "y": 50.039416455948285, "z": "NaN"},
                {"x": 8.298357205225384, "y": 50.039416455948285, "z": "NaN"},
                {"x": 8.298474401235936, "y": 50.03986187508868, "z": "NaN"},
                {"x": 8.298591953176823, "y": 50.04038962508057, "z": "NaN"},
                {"x": 8.298668628761607, "y": 50.04091945585525, "z": "NaN"},
                {"x": 8.298718482256245, "y": 50.04139157351876, "z": "NaN"},
                {"x": 8.298718482256245, "y": 50.04139157351876, "z": "NaN"},
                {"x": 8.298729402636294, "y": 50.04208380332365, "z": "NaN"},
                {"x": 8.298700089881136, "y": 50.0425572580054, "z": "NaN"},
                {"x": 8.298631774061434, "y": 50.04300546319404, "z": "NaN"},
                {"x": 8.29852509925204, "y": 50.043444692526975, "z": "NaN"},
                {"x": 8.298347345903723, "y": 50.043939899594264, "z": "NaN"},
                {"x": 8.29805632622561, "y": 50.04454535961542, "z": "NaN"},
                {"x": 8.29805632622561, "y": 50.04454535961542, "z": "NaN"},
                {"x": 8.297821373516538, "y": 50.04489588718622, "z": "NaN"},
                {"x": 8.297516327543223, "y": 50.04531396423686, "z": "NaN"},
                {"x": 8.297155103996614, "y": 50.04576659144225, "z": "NaN"},
                {"x": 8.297155103996614, "y": 50.04576659144225, "z": "NaN"},
                {"x": 8.296811582103013, "y": 50.04614714651029, "z": "NaN"},
                {"x": 8.29600135584082, "y": 50.04697724849803, "z": "NaN"},
                {"x": 8.29600135584082, "y": 50.04697724849803, "z": "NaN"},
                {"x": 8.294721739533799, "y": 50.04823327747022, "z": "NaN"},
                {"x": 8.293654102615042, "y": 50.04922412977821, "z": "NaN"},
                {"x": 8.293654102615042, "y": 50.04922412977821, "z": "NaN"},
                {"x": 8.29308286073319, "y": 50.04973165478949, "z": "NaN"},
                {"x": 8.29308286073319, "y": 50.04973165478952, "z": "NaN"},
                {"x": 8.292609576691792, "y": 50.050143965989236, "z": "NaN"},
                {"x": 8.292173843576604, "y": 50.050504605307545, "z": "NaN"},
                {"x": 8.292173843576604, "y": 50.050504605307545, "z": "NaN"},
                {"x": 8.290699493331772, "y": 50.05171766253782, "z": "NaN"},
                {"x": 8.290016871137487, "y": 50.05231871891604, "z": "NaN"},
                {"x": 8.289468359393958, "y": 50.05283882466332, "z": "NaN"},
                {"x": 8.289468359393958, "y": 50.05283882466332, "z": "NaN"},
                {"x": 8.289066028041727, "y": 50.05326420497461, "z": "NaN"},
                {"x": 8.28852288071621, "y": 50.05387126953614, "z": "NaN"},
                {"x": 8.28805483524311, "y": 50.05446799359876, "z": "NaN"},
                {"x": 8.28805483524311, "y": 50.05446799359876, "z": "NaN"},
                {"x": 8.287677649600433, "y": 50.055013046755775, "z": "NaN"},
                {"x": 8.287297781748713, "y": 50.05565280899217, "z": "NaN"},
                {"x": 8.286292288644244, "y": 50.05745365513836, "z": "NaN"},
                {"x": 8.285977380542139, "y": 50.05796132827456, "z": "NaN"},
                {"x": 8.28563074693649, "y": 50.058441713203976, "z": "NaN"},
                {"x": 8.285203961381757, "y": 50.058958281728664, "z": "NaN"},
                {"x": 8.284841548843533, "y": 50.05933880989972, "z": "NaN"},
                {"x": 8.284356069011812, "y": 50.059779630105595, "z": "NaN"},
                {"x": 8.283967148704644, "y": 50.06009905002865, "z": "NaN"},
                {"x": 8.283454846782783, "y": 50.06047873509522, "z": "NaN"},
                {"x": 8.282826262764175, "y": 50.060871500175736, "z": "NaN"},
                {"x": 8.282227183044732, "y": 50.06121432712545, "z": "NaN"},
                {"x": 8.282227183044732, "y": 50.06121432712545, "z": "NaN"},
                {"x": 8.281438515095505, "y": 50.0616006334751, "z": "NaN"},
                {"x": 8.280727631207702, "y": 50.06190600890644, "z": "NaN"},
                {"x": 8.27977256780069, "y": 50.062280860212255, "z": "NaN"},
                {"x": 8.277999361532887, "y": 50.0629256573403, "z": "NaN"},
                {"x": 8.277999361532887, "y": 50.06292565734028, "z": "NaN"},
                {"x": 8.27463742134867, "y": 50.06415295898346, "z": "NaN"},
                {"x": 8.27463742134867, "y": 50.06415295898346, "z": "NaN"},
                {"x": 8.27425321254867, "y": 50.064296020265736, "z": "NaN"},
                {"x": 8.27425321254867, "y": 50.064296020265736, "z": "NaN"},
                {"x": 8.269241769018308, "y": 50.06610874780491, "z": "NaN"},
                {"x": 8.269241769018308, "y": 50.06610874780491, "z": "NaN"},
                {"x": 8.26874406645578, "y": 50.06628877186283, "z": "NaN"},
                {"x": 8.26874406645578, "y": 50.06628877186283, "z": "NaN"},
                {"x": 8.265260081930146, "y": 50.06756563810055, "z": "NaN"},
                {"x": 8.263319838984017, "y": 50.06830444256612, "z": "NaN"},
                {"x": 8.26285279933931, "y": 50.06849963310654, "z": "NaN"},
                {"x": 8.262006484131975, "y": 50.06891731088396, "z": "NaN"},
                {"x": 8.262006484131975, "y": 50.06891731088396, "z": "NaN"},
                {"x": 8.261520372879588, "y": 50.06920085482077, "z": "NaN"},
                {"x": 8.261065777583108, "y": 50.069508069042826, "z": "NaN"},
                {"x": 8.261065777583108, "y": 50.069508069042826, "z": "NaN"},
                {"x": 8.260545283556395, "y": 50.06987157781238, "z": "NaN"},
                {"x": 8.259829916060049, "y": 50.070401123780165, "z": "NaN"},
                {"x": 8.258151635527357, "y": 50.07169588488001, "z": "NaN"},
                {"x": 8.258151635527357, "y": 50.07169588488001, "z": "NaN"},
                {"x": 8.257960963962354, "y": 50.07187347102294, "z": "NaN"},
                {"x": 8.257601588468507, "y": 50.07211751656222, "z": "NaN"},
                {"x": 8.257601588468507, "y": 50.072117516562244, "z": "NaN"},
                {"x": 8.25684851918774, "y": 50.07256361594917, "z": "NaN"},
                {"x": 8.256560593230622, "y": 50.07276745207503, "z": "NaN"},
                {"x": 8.256560593230622, "y": 50.07276745207503, "z": "NaN"},
                {"x": 8.255321646661743, "y": 50.07364275376407, "z": "NaN"},
                {"x": 8.255321646661743, "y": 50.07364275376407, "z": "NaN"},
                {"x": 8.254181440178295, "y": 50.07447100898019, "z": "NaN"},
                {"x": 8.254181440178295, "y": 50.07447100898019, "z": "NaN"},
                {"x": 8.253719057391907, "y": 50.07482548165766, "z": "NaN"},
                {"x": 8.25355775933365, "y": 50.07497285202587, "z": "NaN"},
                {"x": 8.25338847826146, "y": 50.07509880761924, "z": "NaN"},
                {"x": 8.253178896805343, "y": 50.075209322489115, "z": "NaN"},
                {"x": 8.253178896805343, "y": 50.075209322489115, "z": "NaN"},
                {"x": 8.251714843135225, "y": 50.07628794135344, "z": "NaN"},
                {"x": 8.251714843135225, "y": 50.07628794135344, "z": "NaN"},
                {"x": 8.251541672219897, "y": 50.076426172858824, "z": "NaN"},
                {"x": 8.251541672219897, "y": 50.076426172858824, "z": "NaN"},
                {"x": 8.250227969999997, "y": 50.07738830905831, "z": "NaN"},
                {"x": 8.250227969999997, "y": 50.07738830905831, "z": "NaN"},
                {"x": 8.249803092149582, "y": 50.07769683498676, "z": "NaN"},
                {"x": 8.249803092149582, "y": 50.07769683498676, "z": "NaN"},
                {"x": 8.249134843004203, "y": 50.07821624167377, "z": "NaN"},
                {"x": 8.249134843004203, "y": 50.07821624167377, "z": "NaN"},
                {"x": 8.24901572883606, "y": 50.078303885124676, "z": "NaN"},
                {"x": 8.24901572883606, "y": 50.078303885124676, "z": "NaN"},
                {"x": 8.247797133764283, "y": 50.07921321509809, "z": "NaN"},
                {"x": 8.247797133764283, "y": 50.07921321509809, "z": "NaN"},
                {"x": 8.247029311252385, "y": 50.07976107460572, "z": "NaN"},
                {"x": 8.246855598037282, "y": 50.079919933026886, "z": "NaN"},
                {"x": 8.246855598037282, "y": 50.079919933026886, "z": "NaN"},
                {"x": 8.247065298718011, "y": 50.080003371615625, "z": "NaN"},
                {"x": 8.247670299643401, "y": 50.080170316116096, "z": "NaN"},
                {"x": 8.247670299643401, "y": 50.080170316116096, "z": "NaN"},
                {"x": 8.247869122268446, "y": 50.08023121515301, "z": "NaN"},
                {"x": 8.247869122268446, "y": 50.08023121515301, "z": "NaN"},
                {"x": 8.247528659073788, "y": 50.082191394844365, "z": "NaN"},
                {"x": 8.247528659073788, "y": 50.082191394844365, "z": "NaN"},
                {"x": 8.247405795329334, "y": 50.08306966205819, "z": "NaN"},
                {"x": 8.247405795329334, "y": 50.08306966205819, "z": "NaN"},
                {"x": 8.247339771792056, "y": 50.08361622550605, "z": "NaN"},
                {"x": 8.247339771792056, "y": 50.08361622550607, "z": "NaN"},
                {"x": 8.247321625448992, "y": 50.08376342727354, "z": "NaN"},
                {"x": 8.247321625448992, "y": 50.08376342727354, "z": "NaN"},
                {"x": 8.247291101809203, "y": 50.08401103171967, "z": "NaN"},
                {"x": 8.247291101809203, "y": 50.0840110317197, "z": "NaN"},
                {"x": 8.247286829865775, "y": 50.08411891532466, "z": "NaN"},
            ],
        },
        {
            "response": {
                "results": [
                    {
                        "path": {
                            "segmentId": 72856060,
                            "nodeId": 79353354,
                            "x": 8.262231178841974,
                            "y": 50.00350434288446,
                            "direction": False,
                        },
                        "street": 1,
                        "altStreets": [0],
                        "distance": 0,
                        "length": 42,
                        "crossTime": 52,
                        "crossTimeWithoutRealTime": 52,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 4,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "TURN_LEFT", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857068,
                            "nodeId": 79353353,
                            "x": 8.262884296737077,
                            "y": 50.003263849158074,
                            "direction": True,
                        },
                        "street": 1,
                        "altStreets": [0],
                        "distance": 52,
                        "length": 83,
                        "crossTime": 10,
                        "crossTimeWithoutRealTime": 10,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858741,
                            "nodeId": 79354848,
                            "x": 8.263474564170831,
                            "y": 50.00389912419096,
                            "direction": True,
                        },
                        "street": 1,
                        "altStreets": [0],
                        "distance": 62,
                        "length": 110,
                        "crossTime": 13,
                        "crossTimeWithoutRealTime": 13,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858742,
                            "nodeId": 79354852,
                            "x": 8.264312573037357,
                            "y": 50.004726618565144,
                            "direction": True,
                        },
                        "street": 1,
                        "altStreets": [0],
                        "distance": 75,
                        "length": 126,
                        "crossTime": 26,
                        "crossTimeWithoutRealTime": 26,
                        "crossTimeFreeFlow": 11,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [
                                        {"angle": -90, "selected": False},
                                        {"angle": 0, "selected": True},
                                        {"angle": -180, "selected": False},
                                    ],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [
                                        {"angle": 0, "selected": True},
                                        {"angle": 90, "selected": False},
                                    ],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 2,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 72858739,
                            "nodeId": 79354745,
                            "x": 8.265242629013304,
                            "y": 50.00568941892085,
                            "direction": True,
                        },
                        "street": 1,
                        "altStreets": [0],
                        "distance": 101,
                        "length": 104,
                        "crossTime": 12,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 4,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "TURN_RIGHT", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858752,
                            "nodeId": 79356564,
                            "x": 8.266104288659388,
                            "y": 50.00642271162488,
                            "direction": True,
                        },
                        "street": 2,
                        "distance": 113,
                        "length": 63,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858753,
                            "nodeId": 79354855,
                            "x": 8.266819097361882,
                            "y": 50.00609453058361,
                            "direction": True,
                        },
                        "street": 2,
                        "distance": 122,
                        "length": 55,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 7,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 246047547,
                            "nodeId": 79356559,
                            "x": 8.26742661770343,
                            "y": 50.005794575894285,
                            "direction": True,
                        },
                        "street": 2,
                        "distance": 129,
                        "length": 10,
                        "crossTime": 1,
                        "crossTimeWithoutRealTime": 1,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 436037939,
                            "nodeId": 209641384,
                            "x": 8.267532620513155,
                            "y": 50.005739026738965,
                            "direction": False,
                        },
                        "street": 2,
                        "distance": 130,
                        "length": 60,
                        "crossTime": 8,
                        "crossTimeWithoutRealTime": 8,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 436037938,
                            "nodeId": 333577572,
                            "x": 8.268170502719617,
                            "y": 50.00539613646547,
                            "direction": False,
                        },
                        "street": 2,
                        "distance": 138,
                        "length": 116,
                        "crossTime": 23,
                        "crossTimeWithoutRealTime": 23,
                        "crossTimeFreeFlow": 17,
                        "knownDirection": True,
                        "penalty": 7,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "TURN_LEFT", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 370095308,
                            "nodeId": 79356560,
                            "x": 8.269412793478955,
                            "y": 50.00472834248692,
                            "direction": True,
                        },
                        "street": 3,
                        "distance": 161,
                        "length": 83,
                        "crossTime": 22,
                        "crossTimeWithoutRealTime": 22,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 370095309,
                            "nodeId": 290337089,
                            "x": 8.270124537611794,
                            "y": 50.00532038803219,
                            "direction": True,
                        },
                        "street": 3,
                        "distance": 183,
                        "length": 46,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 246495731,
                            "nodeId": 209928281,
                            "x": 8.270532223008138,
                            "y": 50.00564317452125,
                            "direction": True,
                        },
                        "street": 3,
                        "distance": 192,
                        "length": 31,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858761,
                            "nodeId": 79354839,
                            "x": 8.27080083664418,
                            "y": 50.00585835952036,
                            "direction": True,
                        },
                        "street": 3,
                        "distance": 199,
                        "length": 74,
                        "crossTime": 26,
                        "crossTimeWithoutRealTime": 26,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "TURN_RIGHT", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 162231268,
                            "nodeId": 162914110,
                            "x": 8.271637685856833,
                            "y": 50.00611392414356,
                            "direction": False,
                        },
                        "street": 5,
                        "altStreets": [4],
                        "distance": 225,
                        "length": 191,
                        "crossTime": 26,
                        "crossTimeWithoutRealTime": 26,
                        "crossTimeFreeFlow": 17,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 360439058,
                            "nodeId": 79354884,
                            "x": 8.273044504485089,
                            "y": 50.00466110951561,
                            "direction": False,
                        },
                        "street": 7,
                        "altStreets": [6],
                        "distance": 251,
                        "length": 137,
                        "crossTime": 17,
                        "crossTimeWithoutRealTime": 17,
                        "crossTimeFreeFlow": 12,
                        "knownDirection": True,
                        "penalty": 5,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -90, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": False}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [
                                        {"angle": 0, "selected": False},
                                        {"angle": 90, "selected": False},
                                    ],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "TURN_LEFT",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 0,
                                },
                                "angle": -45,
                                "angle_override": -90,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 399190430,
                            "nodeId": 284052144,
                            "x": 8.273971790530663,
                            "y": 50.00359047306348,
                            "direction": False,
                        },
                        "street": 7,
                        "altStreets": [6],
                        "distance": 268,
                        "length": 65,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 6,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 399190429,
                            "nodeId": 309295012,
                            "x": 8.27458476301202,
                            "y": 50.003390345561506,
                            "direction": False,
                        },
                        "street": 7,
                        "altStreets": [6],
                        "distance": 277,
                        "length": 37,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 392386961,
                            "nodeId": 79358204,
                            "x": 8.274416454396324,
                            "y": 50.003697642077995,
                            "direction": False,
                        },
                        "street": 7,
                        "altStreets": [6],
                        "distance": 282,
                        "length": 179,
                        "crossTime": 16,
                        "crossTimeWithoutRealTime": 16,
                        "crossTimeFreeFlow": 16,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 270261228,
                            "nodeId": 225111472,
                            "x": 8.27325020772032,
                            "y": 50.0050858175989,
                            "direction": False,
                        },
                        "street": 9,
                        "altStreets": [8],
                        "distance": 298,
                        "length": 36,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 239674002,
                            "nodeId": 79353332,
                            "x": 8.273584842682723,
                            "y": 50.00532475365378,
                            "direction": False,
                        },
                        "street": 9,
                        "altStreets": [8],
                        "distance": 302,
                        "length": 208,
                        "crossTime": 15,
                        "crossTimeWithoutRealTime": 15,
                        "crossTimeFreeFlow": 16,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 369081994,
                            "nodeId": 205584787,
                            "x": 8.276032753295809,
                            "y": 50.006327055101046,
                            "direction": False,
                        },
                        "street": 11,
                        "altStreets": [10],
                        "distance": 317,
                        "length": 309,
                        "crossTime": 40,
                        "crossTimeWithoutRealTime": 40,
                        "crossTimeFreeFlow": 22,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": False}],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "KEEP_LEFT",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 0,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 403833198,
                            "nodeId": 225111842,
                            "x": 8.27967572957318,
                            "y": 50.00781791594246,
                            "direction": True,
                        },
                        "street": 12,
                        "distance": 357,
                        "length": 77,
                        "crossTime": 14,
                        "crossTimeWithoutRealTime": 10,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 369081994,
                            "segment_direction": False,
                        },
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 403833199,
                            "nodeId": 312426534,
                            "x": 8.280588422753961,
                            "y": 50.00817553744451,
                            "direction": True,
                        },
                        "street": 12,
                        "distance": 371,
                        "length": 41,
                        "crossTime": 8,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 369081994,
                            "segment_direction": False,
                        },
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 239540450,
                            "nodeId": 205500150,
                            "x": 8.281030654908028,
                            "y": 50.008406125706664,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 379,
                        "length": 38,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 239540443,
                            "nodeId": 205500121,
                            "x": 8.281298742764584,
                            "y": 50.00867084273389,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 384,
                        "length": 17,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -45, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [
                                        {"angle": 45, "selected": False},
                                        {"angle": -45, "selected": True},
                                    ],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 239540450,
                            "segment_direction": True,
                        },
                        "instruction": {
                            "opcode": "KEEP_LEFT",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                                "angle_override": -45,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 239540444,
                            "nodeId": 205500130,
                            "x": 8.281234434580242,
                            "y": 50.00881377267493,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 386,
                        "length": 34,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 239540450,
                            "segment_direction": True,
                        },
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 239540445,
                            "nodeId": 205500137,
                            "x": 8.280849361789794,
                            "y": 50.008975478677336,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 390,
                        "length": 29,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [
                                        {"angle": 45, "selected": True},
                                        {"angle": 0, "selected": False},
                                    ],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 239540450,
                            "segment_direction": True,
                        },
                        "instruction": {
                            "opcode": "KEEP_RIGHT",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 1,
                                },
                                "angle": 45,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 72862896,
                            "nodeId": 205500142,
                            "x": 8.28045284284126,
                            "y": 50.00891461030903,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 394,
                        "length": 41,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 405166473,
                            "nodeId": 313334334,
                            "x": 8.28002089573558,
                            "y": 50.00912387495847,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 399,
                        "length": 111,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 409938838,
                            "nodeId": 313334326,
                            "x": 8.27950423955905,
                            "y": 50.01006660575547,
                            "direction": True,
                        },
                        "street": 15,
                        "altStreets": [14],
                        "distance": 408,
                        "length": 92,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 7,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 6,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 409938839,
                            "nodeId": 316442660,
                            "x": 8.27925263471346,
                            "y": 50.01088073325425,
                            "direction": True,
                        },
                        "street": 15,
                        "altStreets": [14],
                        "distance": 415,
                        "length": 29,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 6,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -90, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 2,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 405166584,
                            "nodeId": 313334419,
                            "x": 8.27922005408304,
                            "y": 50.01113661008851,
                            "direction": True,
                        },
                        "street": 15,
                        "altStreets": [14],
                        "distance": 417,
                        "length": 102,
                        "crossTime": 8,
                        "crossTimeWithoutRealTime": 8,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 409934684,
                            "nodeId": 313334327,
                            "x": 8.27924442517207,
                            "y": 50.01205562090193,
                            "direction": False,
                        },
                        "street": 15,
                        "altStreets": [14],
                        "distance": 425,
                        "length": 29,
                        "crossTime": 3,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 409934683,
                            "nodeId": 316440012,
                            "x": 8.279291535778537,
                            "y": 50.01231838716162,
                            "direction": False,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 428,
                        "length": 184,
                        "crossTime": 17,
                        "crossTimeWithoutRealTime": 17,
                        "crossTimeFreeFlow": 15,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857175,
                            "nodeId": 79353597,
                            "x": 8.278147418564016,
                            "y": 50.01377543212019,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 445,
                        "length": 23,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857178,
                            "nodeId": 79353599,
                            "x": 8.277986486023146,
                            "y": 50.0139555476341,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 447,
                        "length": 124,
                        "crossTime": 11,
                        "crossTimeWithoutRealTime": 11,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857180,
                            "nodeId": 79354969,
                            "x": 8.277121272327879,
                            "y": 50.01491582247074,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 458,
                        "length": 129,
                        "crossTime": 11,
                        "crossTimeWithoutRealTime": 11,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 411453967,
                            "nodeId": 79353601,
                            "x": 8.27620503,
                            "y": 50.0159094452043,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 469,
                        "length": 42,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 411453968,
                            "nodeId": 317414814,
                            "x": 8.275896263552331,
                            "y": 50.01622701328648,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 473,
                        "length": 103,
                        "crossTime": 12,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 376925116,
                            "nodeId": 79356582,
                            "x": 8.275136841045075,
                            "y": 50.01700807481023,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 485,
                        "length": 134,
                        "crossTime": 12,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 376925119,
                            "nodeId": 294660739,
                            "x": 8.274080971316163,
                            "y": 50.01800707734384,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 497,
                        "length": 30,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 376925120,
                            "nodeId": 294660742,
                            "x": 8.273845800939585,
                            "y": 50.0182337925526,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 501,
                        "length": 212,
                        "crossTime": 21,
                        "crossTimeWithoutRealTime": 21,
                        "crossTimeFreeFlow": 17,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858799,
                            "nodeId": 79354978,
                            "x": 8.272186157909847,
                            "y": 50.01980970338028,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 522,
                        "length": 24,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858794,
                            "nodeId": 79354963,
                            "x": 8.272001807158741,
                            "y": 50.019988165549115,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 524,
                        "length": 55,
                        "crossTime": 6,
                        "crossTimeWithoutRealTime": 6,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857188,
                            "nodeId": 79353614,
                            "x": 8.271565290118863,
                            "y": 50.02039464367526,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 530,
                        "length": 193,
                        "crossTime": 19,
                        "crossTimeWithoutRealTime": 19,
                        "crossTimeFreeFlow": 16,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857172,
                            "nodeId": 79354965,
                            "x": 8.270047914180301,
                            "y": 50.021831580077205,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 549,
                        "length": 52,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857189,
                            "nodeId": 79354966,
                            "x": 8.269664332090146,
                            "y": 50.022226366232545,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 554,
                        "length": 86,
                        "crossTime": 11,
                        "crossTimeWithoutRealTime": 11,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 248027520,
                            "nodeId": 79354979,
                            "x": 8.269044264418032,
                            "y": 50.02288556308001,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 565,
                        "length": 12,
                        "crossTime": 1,
                        "crossTimeWithoutRealTime": 1,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 295891796,
                            "nodeId": 210888815,
                            "x": 8.26896228510667,
                            "y": 50.0229821401884,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 566,
                        "length": 64,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 7,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 295891797,
                            "nodeId": 243067739,
                            "x": 8.26853368016802,
                            "y": 50.02348571230767,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 573,
                        "length": 76,
                        "crossTime": 27,
                        "crossTimeWithoutRealTime": 27,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 6,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -90, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": False}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 90, "selected": False}],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "TURN_LEFT",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 0,
                                },
                                "angle": -45,
                                "angle_override": -90,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 367970764,
                            "nodeId": 79354953,
                            "x": 8.268000148657764,
                            "y": 50.02408051128032,
                            "direction": False,
                        },
                        "street": 19,
                        "altStreets": [18],
                        "distance": 600,
                        "length": 42,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 7,
                        "crossTimeFreeFlow": 6,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 367970763,
                            "nodeId": 288925513,
                            "x": 8.267412867557791,
                            "y": 50.024079318032356,
                            "direction": False,
                        },
                        "street": 19,
                        "altStreets": [18],
                        "distance": 607,
                        "length": 55,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 399187037,
                            "nodeId": 79354980,
                            "x": 8.266642022090151,
                            "y": 50.02412284903554,
                            "direction": False,
                        },
                        "street": 19,
                        "altStreets": [18],
                        "distance": 612,
                        "length": 105,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 399187036,
                            "nodeId": 283089406,
                            "x": 8.265189150926211,
                            "y": 50.02421627028158,
                            "direction": False,
                        },
                        "street": 19,
                        "altStreets": [18],
                        "distance": 621,
                        "length": 169,
                        "crossTime": 14,
                        "crossTimeWithoutRealTime": 14,
                        "crossTimeFreeFlow": 14,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 380309639,
                            "nodeId": 79354982,
                            "x": 8.263387091401663,
                            "y": 50.02518788332397,
                            "direction": False,
                        },
                        "street": 19,
                        "altStreets": [18],
                        "distance": 635,
                        "length": 390,
                        "crossTime": 30,
                        "crossTimeWithoutRealTime": 30,
                        "crossTimeFreeFlow": 28,
                        "knownDirection": True,
                        "penalty": 4,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 380309636,
                            "nodeId": 296887078,
                            "x": 8.258992108078331,
                            "y": 50.027242058136395,
                            "direction": False,
                        },
                        "street": 19,
                        "altStreets": [18],
                        "distance": 665,
                        "length": 218,
                        "crossTime": 16,
                        "crossTimeWithoutRealTime": 16,
                        "crossTimeFreeFlow": 16,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 252596790,
                            "nodeId": 79354939,
                            "x": 8.256749585403675,
                            "y": 50.028571069197994,
                            "direction": False,
                        },
                        "street": 19,
                        "altStreets": [18],
                        "distance": 681,
                        "length": 213,
                        "crossTime": 16,
                        "crossTimeWithoutRealTime": 16,
                        "crossTimeFreeFlow": 16,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 360222704,
                            "nodeId": 79354941,
                            "x": 8.254426494774625,
                            "y": 50.029765873497695,
                            "direction": False,
                        },
                        "street": 19,
                        "altStreets": [18],
                        "distance": 697,
                        "length": 82,
                        "crossTime": 6,
                        "crossTimeWithoutRealTime": 6,
                        "crossTimeFreeFlow": 6,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 360222703,
                            "nodeId": 283916018,
                            "x": 8.253546304682127,
                            "y": 50.030241736830966,
                            "direction": False,
                        },
                        "street": 19,
                        "altStreets": [18],
                        "distance": 703,
                        "length": 190,
                        "crossTime": 14,
                        "crossTimeWithoutRealTime": 14,
                        "crossTimeFreeFlow": 15,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 405779449,
                            "nodeId": 79354936,
                            "x": 8.251510973432387,
                            "y": 50.03133189786561,
                            "direction": False,
                        },
                        "street": 21,
                        "altStreets": [20],
                        "distance": 717,
                        "length": 253,
                        "crossTime": 19,
                        "crossTimeWithoutRealTime": 19,
                        "crossTimeFreeFlow": 19,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 405779699,
                            "nodeId": 79357964,
                            "x": 8.24860505,
                            "y": 50.03261732,
                            "direction": False,
                        },
                        "street": 21,
                        "altStreets": [20],
                        "distance": 736,
                        "length": 225,
                        "crossTime": 17,
                        "crossTimeWithoutRealTime": 17,
                        "crossTimeFreeFlow": 17,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 430266671,
                            "nodeId": 79362956,
                            "x": 8.245824690687895,
                            "y": 50.03356230759473,
                            "direction": False,
                        },
                        "street": 21,
                        "altStreets": [20],
                        "distance": 753,
                        "length": 147,
                        "crossTime": 13,
                        "crossTimeWithoutRealTime": 13,
                        "crossTimeFreeFlow": 12,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 360870560,
                            "nodeId": 284329547,
                            "x": 8.244003180314357,
                            "y": 50.03417055337259,
                            "direction": False,
                        },
                        "street": 21,
                        "altStreets": [20],
                        "distance": 766,
                        "length": 22,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "ROUNDABOUT_ENTER", "arg": 1},
                    },
                    {
                        "path": {
                            "segmentId": 192084451,
                            "nodeId": 177737594,
                            "x": 8.2437299274568,
                            "y": 50.03426559888268,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 770,
                        "length": 21,
                        "crossTime": 3,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "ROUNDABOUT_EXIT", "arg": 1},
                    },
                    {
                        "path": {
                            "segmentId": 405779851,
                            "nodeId": 177737592,
                            "x": 8.2436432330844,
                            "y": 50.0344118246342,
                            "direction": False,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 773,
                        "length": 111,
                        "crossTime": 11,
                        "crossTimeWithoutRealTime": 11,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 405779850,
                            "nodeId": 313737017,
                            "x": 8.24427038412787,
                            "y": 50.03532077418847,
                            "direction": False,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 784,
                        "length": 126,
                        "crossTime": 10,
                        "crossTimeWithoutRealTime": 10,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 300611090,
                            "nodeId": 246110841,
                            "x": 8.244962725892483,
                            "y": 50.03635844817221,
                            "direction": False,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 794,
                        "length": 122,
                        "crossTime": 10,
                        "crossTimeWithoutRealTime": 10,
                        "crossTimeFreeFlow": 11,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 300611146,
                            "nodeId": 246110914,
                            "x": 8.24570097899871,
                            "y": 50.037351472377715,
                            "direction": False,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 804,
                        "length": 46,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 300611145,
                            "nodeId": 246110953,
                            "x": 8.245946998626719,
                            "y": 50.03772896343529,
                            "direction": False,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 808,
                        "length": 39,
                        "crossTime": 3,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 364597214,
                            "nodeId": 246110938,
                            "x": 8.2461535070694,
                            "y": 50.03805386208212,
                            "direction": True,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 811,
                        "length": 333,
                        "crossTime": 26,
                        "crossTimeWithoutRealTime": 26,
                        "crossTimeFreeFlow": 29,
                        "knownDirection": True,
                        "penalty": 4,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 364597215,
                            "nodeId": 286743665,
                            "x": 8.247882092976653,
                            "y": 50.04083147893723,
                            "direction": True,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 837,
                        "length": 178,
                        "crossTime": 18,
                        "crossTimeWithoutRealTime": 18,
                        "crossTimeFreeFlow": 18,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "ROUNDABOUT_ENTER", "arg": 1},
                    },
                    {
                        "path": {
                            "segmentId": 301217844,
                            "nodeId": 246499557,
                            "x": 8.248081119920416,
                            "y": 50.04232389919165,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 855,
                        "length": 28,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "ROUNDABOUT_EXIT", "arg": 1},
                    },
                    {
                        "path": {
                            "segmentId": 290159229,
                            "nodeId": 246499555,
                            "x": 8.24815845399989,
                            "y": 50.042514610053374,
                            "direction": False,
                        },
                        "street": 25,
                        "altStreets": [24],
                        "distance": 859,
                        "length": 134,
                        "crossTime": 14,
                        "crossTimeWithoutRealTime": 14,
                        "crossTimeFreeFlow": 13,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 151885311,
                            "nodeId": 79357962,
                            "x": 8.249761629073788,
                            "y": 50.043102284733855,
                            "direction": True,
                        },
                        "street": 25,
                        "altStreets": [24],
                        "distance": 873,
                        "length": 126,
                        "crossTime": 49,
                        "crossTimeWithoutRealTime": 49,
                        "crossTimeFreeFlow": 17,
                        "knownDirection": True,
                        "penalty": 5,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [
                                        {"angle": -180, "selected": False},
                                        {"angle": -90, "selected": False},
                                        {"angle": 0, "selected": True},
                                    ],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [
                                        {"angle": 90, "selected": False},
                                        {"angle": 0, "selected": True},
                                    ],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": -45,
                                "angle_override": 0,
                                "enable_display": True,
                                "enable_voice": False,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 151885312,
                            "nodeId": 79358412,
                            "x": 8.251391500234654,
                            "y": 50.0435269541452,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 922,
                        "length": 164,
                        "crossTime": 16,
                        "crossTimeWithoutRealTime": 16,
                        "crossTimeFreeFlow": 16,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [
                                        {"angle": 0, "selected": True},
                                        {"angle": -90, "selected": False},
                                    ],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 253091711,
                            "nodeId": 79357116,
                            "x": 8.252906019881138,
                            "y": 50.044607144908426,
                            "direction": False,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 938,
                        "length": 155,
                        "crossTime": 14,
                        "crossTimeWithoutRealTime": 14,
                        "crossTimeFreeFlow": 14,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 253091710,
                            "nodeId": 214041176,
                            "x": 8.255038386697224,
                            "y": 50.04476611821232,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 952,
                        "length": 29,
                        "crossTime": 3,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "ROUNDABOUT_ENTER", "arg": 3},
                    },
                    {
                        "path": {
                            "segmentId": 213667347,
                            "nodeId": 188885628,
                            "x": 8.2554310041829,
                            "y": 50.04472059420899,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 955,
                        "length": 3,
                        "crossTime": 0,
                        "crossTimeWithoutRealTime": 0,
                        "crossTimeFreeFlow": 0,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 4,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 253091710,
                            "segment_direction": True,
                        },
                    },
                    {
                        "path": {
                            "segmentId": 213667348,
                            "nodeId": 188885629,
                            "x": 8.2554573242754,
                            "y": 50.044694694854996,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 955,
                        "length": 31,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 4,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 253091710,
                            "segment_direction": True,
                        },
                    },
                    {
                        "path": {
                            "segmentId": 416793590,
                            "nodeId": 188885630,
                            "x": 8.2558465958018,
                            "y": 50.044664445759,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 959,
                        "length": 7,
                        "crossTime": 1,
                        "crossTimeWithoutRealTime": 1,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 4,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 253091710,
                            "segment_direction": True,
                        },
                    },
                    {
                        "path": {
                            "segmentId": 416793591,
                            "nodeId": 320845144,
                            "x": 8.2559113193144,
                            "y": 50.044710880911985,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 960,
                        "length": 17,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 4,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 253091710,
                            "segment_direction": True,
                        },
                    },
                    {
                        "path": {
                            "segmentId": 213667350,
                            "nodeId": 188885631,
                            "x": 8.2559385450179,
                            "y": 50.044861084982,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 962,
                        "length": 3,
                        "crossTime": 0,
                        "crossTimeWithoutRealTime": 0,
                        "crossTimeFreeFlow": 0,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 4,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 253091710,
                            "segment_direction": True,
                        },
                        "instruction": {"opcode": "ROUNDABOUT_EXIT", "arg": 3},
                    },
                    {
                        "path": {
                            "segmentId": 192085449,
                            "nodeId": 188885626,
                            "x": 8.2559191955111,
                            "y": 50.044889667846014,
                            "direction": False,
                        },
                        "street": 28,
                        "distance": 962,
                        "length": 14,
                        "crossTime": 1,
                        "crossTimeWithoutRealTime": 1,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 4,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 388554717,
                            "nodeId": 177738038,
                            "x": 8.2559276154642,
                            "y": 50.045016242769,
                            "direction": False,
                        },
                        "street": 28,
                        "distance": 963,
                        "length": 241,
                        "crossTime": 15,
                        "crossTimeWithoutRealTime": 15,
                        "crossTimeFreeFlow": 16,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 4,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 388554716,
                            "nodeId": 302265475,
                            "x": 8.256299997484708,
                            "y": 50.047167379263094,
                            "direction": False,
                        },
                        "street": 29,
                        "distance": 978,
                        "length": 152,
                        "crossTime": 8,
                        "crossTimeWithoutRealTime": 8,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 4,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 45, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 398631702,
                            "nodeId": 79353410,
                            "x": 8.25642748558197,
                            "y": 50.04852708999999,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 986,
                        "length": 144,
                        "crossTime": 6,
                        "crossTimeWithoutRealTime": 6,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 398631703,
                            "nodeId": 308912445,
                            "x": 8.256610947699954,
                            "y": 50.0498181204628,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 992,
                        "length": 50,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 45, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 192085814,
                            "nodeId": 79353339,
                            "x": 8.256654860237733,
                            "y": 50.05026480212614,
                            "direction": False,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 994,
                        "length": 185,
                        "crossTime": 10,
                        "crossTimeWithoutRealTime": 10,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857835,
                            "nodeId": 79353342,
                            "x": 8.25676439,
                            "y": 50.05192477,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1004,
                        "length": 68,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 45, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 257308322,
                            "nodeId": 79355652,
                            "x": 8.25688865828566,
                            "y": 50.052533113515985,
                            "direction": False,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1008,
                        "length": 152,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 318914784,
                            "nodeId": 79353343,
                            "x": 8.25741476209015,
                            "y": 50.05385447298824,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1017,
                        "length": 55,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 414474650,
                            "nodeId": 79355651,
                            "x": 8.25737296447746,
                            "y": 50.05435170319033,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1021,
                        "length": 268,
                        "crossTime": 41,
                        "crossTimeWithoutRealTime": 41,
                        "crossTimeFreeFlow": 21,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 414474648,
                            "nodeId": 319342534,
                            "x": 8.255949009982276,
                            "y": 50.05657261912583,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1062,
                        "length": 144,
                        "crossTime": 37,
                        "crossTimeWithoutRealTime": 37,
                        "crossTimeFreeFlow": 12,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [
                                        {"angle": 0, "selected": True},
                                        {"angle": 90, "selected": False},
                                    ],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 2,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 414093583,
                            "nodeId": 79353445,
                            "x": 8.255272064001733,
                            "y": 50.05779199336189,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1099,
                        "length": 25,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 90, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 414093679,
                            "nodeId": 79353446,
                            "x": 8.25515989469745,
                            "y": 50.05800579855292,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1103,
                        "length": 60,
                        "crossTime": 11,
                        "crossTimeWithoutRealTime": 11,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 414472195,
                            "nodeId": 177602314,
                            "x": 8.254886963718208,
                            "y": 50.0585156626875,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1114,
                        "length": 238,
                        "crossTime": 22,
                        "crossTimeWithoutRealTime": 22,
                        "crossTimeFreeFlow": 19,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 411787511,
                            "nodeId": 202531634,
                            "x": 8.253862111450907,
                            "y": 50.06055034148107,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1136,
                        "length": 70,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 7,
                        "crossTimeFreeFlow": 6,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 411787512,
                            "nodeId": 317631702,
                            "x": 8.253554206976274,
                            "y": 50.06114464730762,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1143,
                        "length": 109,
                        "crossTime": 18,
                        "crossTimeWithoutRealTime": 11,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 90, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 411787480,
                            "nodeId": 317471406,
                            "x": 8.253049724274469,
                            "y": 50.0620731612202,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1161,
                        "length": 112,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 411787481,
                            "nodeId": 317631683,
                            "x": 8.252466244738063,
                            "y": 50.06300306264103,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1170,
                        "length": 50,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 355013921,
                            "nodeId": 280523563,
                            "x": 8.252127110332939,
                            "y": 50.06339808569418,
                            "direction": False,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1174,
                        "length": 67,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 355013915,
                            "nodeId": 280523559,
                            "x": 8.251766217374437,
                            "y": 50.06395832826771,
                            "direction": False,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1179,
                        "length": 60,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 355014067,
                            "nodeId": 79355603,
                            "x": 8.25145103349182,
                            "y": 50.06445483177822,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1184,
                        "length": 126,
                        "crossTime": 10,
                        "crossTimeWithoutRealTime": 10,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 355014229,
                            "nodeId": 280523667,
                            "x": 8.250797582517666,
                            "y": 50.0655080086869,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1194,
                        "length": 26,
                        "crossTime": 3,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 355014234,
                            "nodeId": 280523754,
                            "x": 8.250657130353549,
                            "y": 50.06572768854873,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1197,
                        "length": 56,
                        "crossTime": 14,
                        "crossTimeWithoutRealTime": 14,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 355014235,
                            "nodeId": 280523757,
                            "x": 8.250364344542911,
                            "y": 50.0661972053194,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1211,
                        "length": 64,
                        "crossTime": 14,
                        "crossTimeWithoutRealTime": 8,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 90, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 414473214,
                            "nodeId": 79354087,
                            "x": 8.250099910554928,
                            "y": 50.06674223248515,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1225,
                        "length": 153,
                        "crossTime": 13,
                        "crossTimeWithoutRealTime": 13,
                        "crossTimeFreeFlow": 12,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [
                                        {"angle": -90, "selected": False},
                                        {"angle": -180, "selected": False},
                                    ],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 2,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 72857779,
                            "nodeId": 79358259,
                            "x": 8.249445183714606,
                            "y": 50.06805344437171,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1238,
                        "length": 143,
                        "crossTime": 11,
                        "crossTimeWithoutRealTime": 11,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": False}],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "KEEP_LEFT",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 0,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 414473217,
                            "nodeId": 79353499,
                            "x": 8.248994572600047,
                            "y": 50.069307649292625,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1249,
                        "length": 48,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 414473218,
                            "nodeId": 319341672,
                            "x": 8.248843063867406,
                            "y": 50.069732536184524,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1253,
                        "length": 199,
                        "crossTime": 15,
                        "crossTimeWithoutRealTime": 15,
                        "crossTimeFreeFlow": 13,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 392456999,
                            "nodeId": 304759027,
                            "x": 8.248356087562126,
                            "y": 50.07149753173964,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1268,
                        "length": 83,
                        "crossTime": 6,
                        "crossTimeWithoutRealTime": 6,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 392457000,
                            "nodeId": 304759029,
                            "x": 8.248101448921037,
                            "y": 50.07222192741763,
                            "direction": True,
                        },
                        "street": 27,
                        "altStreets": [26],
                        "distance": 1274,
                        "length": 147,
                        "crossTime": 15,
                        "crossTimeWithoutRealTime": 15,
                        "crossTimeFreeFlow": 13,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72869419,
                            "nodeId": 79359174,
                            "x": 8.247864171908676,
                            "y": 50.073476281575495,
                            "direction": True,
                        },
                        "street": 30,
                        "distance": 1289,
                        "length": 83,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72866471,
                            "nodeId": 79361222,
                            "x": 8.246710822032227,
                            "y": 50.07344142211254,
                            "direction": True,
                        },
                        "street": 30,
                        "distance": 1298,
                        "length": 93,
                        "crossTime": 12,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "TURN_RIGHT", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72866287,
                            "nodeId": 79361180,
                            "x": 8.245419195106509,
                            "y": 50.0733717716669,
                            "direction": True,
                        },
                        "street": 31,
                        "distance": 1310,
                        "length": 48,
                        "crossTime": 6,
                        "crossTimeWithoutRealTime": 6,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 408946965,
                            "nodeId": 151588560,
                            "x": 8.245439515955931,
                            "y": 50.07380732425315,
                            "direction": True,
                        },
                        "street": 31,
                        "distance": 1316,
                        "length": 348,
                        "crossTime": 33,
                        "crossTimeWithoutRealTime": 33,
                        "crossTimeFreeFlow": 29,
                        "knownDirection": True,
                        "penalty": 4,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 408946985,
                            "nodeId": 315848892,
                            "x": 8.245436812844245,
                            "y": 50.07691916374124,
                            "direction": True,
                        },
                        "street": 31,
                        "distance": 1349,
                        "length": 117,
                        "crossTime": 39,
                        "crossTimeWithoutRealTime": 39,
                        "crossTimeFreeFlow": 16,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [
                                        {"angle": 90, "selected": False},
                                        {"angle": 0, "selected": True},
                                    ],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                                "enable_display": True,
                                "enable_voice": False,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 408947079,
                            "nodeId": 315848893,
                            "x": 8.245287279691647,
                            "y": 50.077965291097755,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 1388,
                        "length": 22,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 408947080,
                            "nodeId": 315848979,
                            "x": 8.245279289684236,
                            "y": 50.07815929784913,
                            "direction": True,
                        },
                        "street": 32,
                        "distance": 1392,
                        "length": 67,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 408947076,
                            "nodeId": 315848977,
                            "x": 8.245149481203464,
                            "y": 50.0787555733245,
                            "direction": False,
                        },
                        "street": 32,
                        "distance": 1401,
                        "length": 69,
                        "crossTime": 25,
                        "crossTimeWithoutRealTime": 25,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -90, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [
                                        {"angle": 0, "selected": True},
                                        {"angle": 90, "selected": False},
                                    ],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 2,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 72864308,
                            "nodeId": 79359690,
                            "x": 8.245066524299165,
                            "y": 50.079377375536126,
                            "direction": False,
                        },
                        "street": 32,
                        "distance": 1426,
                        "length": 141,
                        "crossTime": 14,
                        "crossTimeWithoutRealTime": 14,
                        "crossTimeFreeFlow": 12,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 252683328,
                            "nodeId": 79359691,
                            "x": 8.244898982090154,
                            "y": 50.08064331957838,
                            "direction": False,
                        },
                        "street": 32,
                        "distance": 1440,
                        "length": 264,
                        "crossTime": 37,
                        "crossTimeWithoutRealTime": 37,
                        "crossTimeFreeFlow": 23,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 265980164,
                            "nodeId": 79361994,
                            "x": 8.244659504299173,
                            "y": 50.083009701140945,
                            "direction": True,
                        },
                        "street": 32,
                        "distance": 1477,
                        "length": 80,
                        "crossTime": 10,
                        "crossTimeWithoutRealTime": 10,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -90, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 2,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 265122151,
                            "nodeId": 221841730,
                            "x": 8.244592721561833,
                            "y": 50.08372858948899,
                            "direction": False,
                        },
                        "street": 32,
                        "distance": 1487,
                        "length": 59,
                        "crossTime": 12,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [
                                        {"angle": 0, "selected": False},
                                        {"angle": 90, "selected": True},
                                    ],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "TURN_RIGHT",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 1,
                                },
                                "angle": 90,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 298682381,
                            "nodeId": 87633896,
                            "x": 8.244525744314858,
                            "y": 50.084258866042525,
                            "direction": True,
                        },
                        "street": 33,
                        "distance": 1499,
                        "length": 190,
                        "crossTime": 43,
                        "crossTimeWithoutRealTime": 43,
                        "crossTimeFreeFlow": 28,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 298682382,
                            "nodeId": 230308637,
                            "x": 8.247080147906408,
                            "y": 50.084263068331595,
                            "direction": True,
                        },
                        "street": 33,
                        "distance": 1542,
                        "length": 8,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 270634255,
                            "nodeId": 226350620,
                            "x": 8.24713901617515,
                            "y": 50.08420523720755,
                            "direction": True,
                        },
                        "street": 33,
                        "distance": 1544,
                        "length": 24,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 9,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "TURN_LEFT", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 270634256,
                            "nodeId": 213790660,
                            "x": 8.247291101809203,
                            "y": 50.08401103171967,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 1549,
                        "length": 12,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "APPROACHING_DESTINATION", "arg": 0},
                    },
                ],
                "streetNames": [
                    "Kaiserstraße",
                    "B40 - Kaiserstraße",
                    "Kaiser-Friedrich-Straße",
                    "Große Bleiche",
                    "Peter-Altmeier-Allee",
                    "B40 - Peter-Altmeier-Allee",
                    "Rheinstraße",
                    "B40 - Rheinstraße",
                    "Theodor-Heuss-Brücke",
                    "B40 - Theodor-Heuss-Brücke",
                    "Theodor-Heuss-Brücke",
                    "B40 - Theodor-Heuss-Brücke",
                    "B40",
                    None,
                    "Rampenstraße",
                    "L3482 - Rampenstraße",
                    "Wiesbadener Straße",
                    "L3482 - Wiesbadener Straße",
                    "Biebricher Straße",
                    "K648 - Biebricher Straße",
                    "Rheingaustraße",
                    "K648 - Rheingaustraße",
                    "Glarusstraße",
                    "K649 - Glarusstraße",
                    "Breslauer Straße",
                    "K649 - Breslauer Straße",
                    "Mainzer Straße",
                    "K650 - Mainzer Straße",
                    None,
                    "> A66 / Wiesbaden-Stadtmitte",
                    "Lessingstraße",
                    "Friedrich-Ebert-Allee",
                    "Wilhelmstraße",
                    "Christian-Zais-Straße",
                ],
                "fromlocMetersFromGeom": 14.529273,
                "fromFraction": 0.7886346623377086,
                "toFraction": 0.4876577222349604,
                "sameFromSegment": True,
                "sameToSegment": True,
                "tollMeters": 0,
                "preferedRouteId": -1,
                "isInvalid": False,
                "isBlocked": False,
                "serverUniqueId": "m23130394891406600",
                "displayRoute": True,
                "astarVisited": 8128,
                "astarResult": "UNKNOWN",
                "isRestricted": False,
                "avoidStatus": "MAYBE",
                "passesThroughDangerArea": False,
                "distanceFromSource": 14,
                "distanceFromTarget": 39,
                "minPassengers": 0,
                "hovIndex": -1,
                "preRefinedRouteIndex": -1,
                "blockedRouteUid": -1,
                "alternativeRouteUuid": "bf0cf16d-f8f8-445f-a08f-9882b2e387e8",
                "serverTilesVersion": 1705557311000,
                "rankBeforeReordering": 1,
                "serverType": "LIVEMAP",
                "routeType": ["Natural"],
                "routeAttr": ["RestrictedZone"],
                "astarCost": 1356,
                "totalRouteTime": 1553,
                "totalRouteTimeWithoutRealtime": 1528,
                "totalRouteTimeFreeFlow": 1116,
                "carbonEmissionsGrams": 0,
                "creationMechanismSet": ["BIDI", "OTHER_HEURISTIC"],
                "laneTypes": [],
                "areas": ["Umweltzone"],
                "requiredPermits": [],
                "etaHistograms": [],
                "shortRouteName": "K650 - Mainzer Straße Wiesbaden",
                "tollPrice": 0.0,
                "isInvalidForPrivateVehicle": False,
                "costInfo": {
                    "unbiasedAstarCost": 1800,
                    "tollAsSeconds": 0,
                    "keepForReordering": False,
                },
                "destinationInformation": {
                    "segment_id": 270634256,
                    "street_id": 7744185,
                    "city_id": 27809,
                    "country_id": 81,
                    "city_name": "Wiesbaden",
                    "exit_node_id": 226350621,
                },
                "routeName": "K650 - Mainzer Straße Wiesbaden",
                "routeNameStreetIds": [20536351],
                "totalRouteTimeWithoutMl": 1553,
                "open": False,
            },
            "coords": [
                {"x": 8.262364726690599, "y": 50.00345516735274, "z": "NaN"},
                {"x": 8.262884296737077, "y": 50.003263849158074, "z": "NaN"},
                {"x": 8.262884296737077, "y": 50.003263849158074, "z": "NaN"},
                {"x": 8.26296619483727, "y": 50.00339573042915, "z": "NaN"},
                {"x": 8.263474564170831, "y": 50.00389912419096, "z": "NaN"},
                {"x": 8.263474564170831, "y": 50.00389912419096, "z": "NaN"},
                {"x": 8.264312573037357, "y": 50.004726618565144, "z": "NaN"},
                {"x": 8.264312573037357, "y": 50.004726618565144, "z": "NaN"},
                {"x": 8.265242629013304, "y": 50.00568941892085, "z": "NaN"},
                {"x": 8.265242629013304, "y": 50.00568941892085, "z": "NaN"},
                {"x": 8.265759624800928, "y": 50.006232224674996, "z": "NaN"},
                {"x": 8.26586423095251, "y": 50.00630548897572, "z": "NaN"},
                {"x": 8.266104288659388, "y": 50.00642271162488, "z": "NaN"},
                {"x": 8.266104288659388, "y": 50.00642271162488, "z": "NaN"},
                {"x": 8.266819097361882, "y": 50.00609453058361, "z": "NaN"},
                {"x": 8.266819097361882, "y": 50.00609453058361, "z": "NaN"},
                {"x": 8.26742661770343, "y": 50.005794575894285, "z": "NaN"},
                {"x": 8.26742661770343, "y": 50.005794575894285, "z": "NaN"},
                {"x": 8.267532620513155, "y": 50.005739026738965, "z": "NaN"},
                {"x": 8.267532620513155, "y": 50.005739026738965, "z": "NaN"},
                {"x": 8.268170502719617, "y": 50.00539613646547, "z": "NaN"},
                {"x": 8.268170502719617, "y": 50.00539613646547, "z": "NaN"},
                {"x": 8.269412793478955, "y": 50.00472834248692, "z": "NaN"},
                {"x": 8.269412793478955, "y": 50.00472834248692, "z": "NaN"},
                {"x": 8.270124537611794, "y": 50.00532038803219, "z": "NaN"},
                {"x": 8.270124537611794, "y": 50.00532038803219, "z": "NaN"},
                {"x": 8.270532223008138, "y": 50.00564317452125, "z": "NaN"},
                {"x": 8.270532223008138, "y": 50.00564317452125, "z": "NaN"},
                {"x": 8.27080083664418, "y": 50.00585835952036, "z": "NaN"},
                {"x": 8.27080083664418, "y": 50.00585835952036, "z": "NaN"},
                {"x": 8.271031506619494, "y": 50.00597041163063, "z": "NaN"},
                {"x": 8.271205561096314, "y": 50.00611311161945, "z": "NaN"},
                {"x": 8.271322907740654, "y": 50.00615405354942, "z": "NaN"},
                {"x": 8.271446959907625, "y": 50.00615405354976, "z": "NaN"},
                {"x": 8.271637685856833, "y": 50.00611392414356, "z": "NaN"},
                {"x": 8.271637685856833, "y": 50.00611392414356, "z": "NaN"},
                {"x": 8.27170798235573, "y": 50.00600453636846, "z": "NaN"},
                {"x": 8.271787666586183, "y": 50.00591368004332, "z": "NaN"},
                {"x": 8.273044504485089, "y": 50.00466110951561, "z": "NaN"},
                {"x": 8.273044504485089, "y": 50.00466110951561, "z": "NaN"},
                {"x": 8.273474809463597, "y": 50.00421243931527, "z": "NaN"},
                {"x": 8.273716018706539, "y": 50.00393185031846, "z": "NaN"},
                {"x": 8.273971790530663, "y": 50.00359047306348, "z": "NaN"},
                {"x": 8.273971790530663, "y": 50.00359047306348, "z": "NaN"},
                {"x": 8.274058150504036, "y": 50.003546367736924, "z": "NaN"},
                {"x": 8.274210941546816, "y": 50.003356526900085, "z": "NaN"},
                {"x": 8.274288378915841, "y": 50.00331492185268, "z": "NaN"},
                {"x": 8.274394326171992, "y": 50.003298544117264, "z": "NaN"},
                {"x": 8.274480156860436, "y": 50.00331319788084, "z": "NaN"},
                {"x": 8.274545870981296, "y": 50.00334681532102, "z": "NaN"},
                {"x": 8.27458476301202, "y": 50.003390345561506, "z": "NaN"},
                {"x": 8.27458476301202, "y": 50.003390345561506, "z": "NaN"},
                {"x": 8.274594150743576, "y": 50.00343689270589, "z": "NaN"},
                {"x": 8.274576884023038, "y": 50.003493999094275, "z": "NaN"},
                {"x": 8.274488538763608, "y": 50.00359204952739, "z": "NaN"},
                {"x": 8.274416454396324, "y": 50.00369764207802, "z": "NaN"},
                {"x": 8.274416454396324, "y": 50.003697642077995, "z": "NaN"},
                {"x": 8.273315251288938, "y": 50.00481947302412, "z": "NaN"},
                {"x": 8.273255572138392, "y": 50.00490092807522, "z": "NaN"},
                {"x": 8.273228750048222, "y": 50.00500436286148, "z": "NaN"},
                {"x": 8.27325020772032, "y": 50.0050858175989, "z": "NaN"},
                {"x": 8.27325020772032, "y": 50.0050858175989, "z": "NaN"},
                {"x": 8.273308606093535, "y": 50.00515586872543, "z": "NaN"},
                {"x": 8.273381086064076, "y": 50.00520954266566, "z": "NaN"},
                {"x": 8.273584842682723, "y": 50.00532475365378, "z": "NaN"},
                {"x": 8.273584842682723, "y": 50.00532475365378, "z": "NaN"},
                {"x": 8.276032753295809, "y": 50.006327055101046, "z": "NaN"},
                {"x": 8.276032753295809, "y": 50.006327055101046, "z": "NaN"},
                {"x": 8.27967572957318, "y": 50.00781791594246, "z": "NaN"},
                {"x": 8.27967572957318, "y": 50.00781791594246, "z": "NaN"},
                {"x": 8.280186377466098, "y": 50.007979597478894, "z": "NaN"},
                {"x": 8.280588422753961, "y": 50.00817553744451, "z": "NaN"},
                {"x": 8.280588422753961, "y": 50.00817553744451, "z": "NaN"},
                {"x": 8.281030654908028, "y": 50.008406125706664, "z": "NaN"},
                {"x": 8.281030654908028, "y": 50.008406125706664, "z": "NaN"},
                {"x": 8.281167515223444, "y": 50.00846965427605, "z": "NaN"},
                {"x": 8.28125383786892, "y": 50.008529336001615, "z": "NaN"},
                {"x": 8.28129372524024, "y": 50.00858418944403, "z": "NaN"},
                {"x": 8.281298742764584, "y": 50.00867084273389, "z": "NaN"},
                {"x": 8.281298742764584, "y": 50.00867084273389, "z": "NaN"},
                {"x": 8.281272742532217, "y": 50.00874687903089, "z": "NaN"},
                {"x": 8.281234434580242, "y": 50.00881377267493, "z": "NaN"},
                {"x": 8.281234434580242, "y": 50.00881377267493, "z": "NaN"},
                {"x": 8.281176991097208, "y": 50.008863886672565, "z": "NaN"},
                {"x": 8.281090965639427, "y": 50.00892008706766, "z": "NaN"},
                {"x": 8.281012530511466, "y": 50.008952701247296, "z": "NaN"},
                {"x": 8.280918672681663, "y": 50.008971525254964, "z": "NaN"},
                {"x": 8.280849361789794, "y": 50.008975478677336, "z": "NaN"},
                {"x": 8.280849361789794, "y": 50.008975478677336, "z": "NaN"},
                {"x": 8.280688000412901, "y": 50.00895987289514, "z": "NaN"},
                {"x": 8.28045284284126, "y": 50.00891461030903, "z": "NaN"},
                {"x": 8.28045284284126, "y": 50.00891461030903, "z": "NaN"},
                {"x": 8.280274478688465, "y": 50.00894244843801, "z": "NaN"},
                {"x": 8.28018529661207, "y": 50.008974251601806, "z": "NaN"},
                {"x": 8.280118913312304, "y": 50.00901962941356, "z": "NaN"},
                {"x": 8.28002089573558, "y": 50.00912387495847, "z": "NaN"},
                {"x": 8.28002089573558, "y": 50.00912387495847, "z": "NaN"},
                {"x": 8.279893198224418, "y": 50.00938668766275, "z": "NaN"},
                {"x": 8.27950423955905, "y": 50.01006660575547, "z": "NaN"},
                {"x": 8.27950423955905, "y": 50.01006660575547, "z": "NaN"},
                {"x": 8.279398292302963, "y": 50.01032710369956, "z": "NaN"},
                {"x": 8.279311120509973, "y": 50.01059654198169, "z": "NaN"},
                {"x": 8.27925263471346, "y": 50.01088073325425, "z": "NaN"},
                {"x": 8.27925263471346, "y": 50.01088073325425, "z": "NaN"},
                {"x": 8.27922005408304, "y": 50.01113661008851, "z": "NaN"},
                {"x": 8.27922005408304, "y": 50.01113661008851, "z": "NaN"},
                {"x": 8.279217423138183, "y": 50.01167497023296, "z": "NaN"},
                {"x": 8.27924442517207, "y": 50.01205562090193, "z": "NaN"},
                {"x": 8.27924442517207, "y": 50.01205562090193, "z": "NaN"},
                {"x": 8.279291535778537, "y": 50.01231838716162, "z": "NaN"},
                {"x": 8.279291535778537, "y": 50.01231838716162, "z": "NaN"},
                {"x": 8.279297077672123, "y": 50.01237063823606, "z": "NaN"},
                {"x": 8.279268412090154, "y": 50.01250035999999, "z": "NaN"},
                {"x": 8.279174857672123, "y": 50.01264408908465, "z": "NaN"},
                {"x": 8.278147418564016, "y": 50.01377543212019, "z": "NaN"},
                {"x": 8.278147418564016, "y": 50.01377543212019, "z": "NaN"},
                {"x": 8.277986486023146, "y": 50.0139555476341, "z": "NaN"},
                {"x": 8.277986486023146, "y": 50.0139555476341, "z": "NaN"},
                {"x": 8.277121272327879, "y": 50.01491582247077, "z": "NaN"},
                {"x": 8.277121272327879, "y": 50.01491582247077, "z": "NaN"},
                {"x": 8.27620503, "y": 50.0159094452043, "z": "NaN"},
                {"x": 8.27620503, "y": 50.0159094452043, "z": "NaN"},
                {"x": 8.275896263552331, "y": 50.01622701328648, "z": "NaN"},
                {"x": 8.275896263552331, "y": 50.01622701328648, "z": "NaN"},
                {"x": 8.275136841045075, "y": 50.01700807481023, "z": "NaN"},
                {"x": 8.275136841045075, "y": 50.01700807481023, "z": "NaN"},
                {"x": 8.274080971316163, "y": 50.01800707734384, "z": "NaN"},
                {"x": 8.274080971316163, "y": 50.01800707734384, "z": "NaN"},
                {"x": 8.273845800939585, "y": 50.0182337925526, "z": "NaN"},
                {"x": 8.273845800939585, "y": 50.0182337925526, "z": "NaN"},
                {"x": 8.272186157909847, "y": 50.01980970338028, "z": "NaN"},
                {"x": 8.272186157909847, "y": 50.01980970338028, "z": "NaN"},
                {"x": 8.272001807158741, "y": 50.019988165549115, "z": "NaN"},
                {"x": 8.272001807158741, "y": 50.019988165549115, "z": "NaN"},
                {"x": 8.271565290118863, "y": 50.02039464367526, "z": "NaN"},
                {"x": 8.271565290118863, "y": 50.02039464367526, "z": "NaN"},
                {"x": 8.270047914180301, "y": 50.021831580077226, "z": "NaN"},
                {"x": 8.270047914180301, "y": 50.021831580077205, "z": "NaN"},
                {"x": 8.269664332090146, "y": 50.022226366232545, "z": "NaN"},
                {"x": 8.269664332090146, "y": 50.022226366232545, "z": "NaN"},
                {"x": 8.269044264418032, "y": 50.02288556308003, "z": "NaN"},
                {"x": 8.269044264418032, "y": 50.02288556308001, "z": "NaN"},
                {"x": 8.26896228510667, "y": 50.0229821401884, "z": "NaN"},
                {"x": 8.26896228510667, "y": 50.0229821401884, "z": "NaN"},
                {"x": 8.26853368016802, "y": 50.02348571230767, "z": "NaN"},
                {"x": 8.26853368016802, "y": 50.02348571230767, "z": "NaN"},
                {"x": 8.268000148657764, "y": 50.02408051128032, "z": "NaN"},
                {"x": 8.268000148657764, "y": 50.02408051128032, "z": "NaN"},
                {"x": 8.267412867557791, "y": 50.024079318032356, "z": "NaN"},
                {"x": 8.267412867557791, "y": 50.024079318032356, "z": "NaN"},
                {"x": 8.266642022090151, "y": 50.02412284903554, "z": "NaN"},
                {"x": 8.266642022090151, "y": 50.02412284903554, "z": "NaN"},
                {"x": 8.265405126151588, "y": 50.024186737070934, "z": "NaN"},
                {"x": 8.265189150926211, "y": 50.02421627028158, "z": "NaN"},
                {"x": 8.265189150926211, "y": 50.02421627028158, "z": "NaN"},
                {"x": 8.265002333075792, "y": 50.0242723151698, "z": "NaN"},
                {"x": 8.26480611552254, "y": 50.02435988321699, "z": "NaN"},
                {"x": 8.26430637764741, "y": 50.024672617336144, "z": "NaN"},
                {"x": 8.263633498907847, "y": 50.025074999311485, "z": "NaN"},
                {"x": 8.263387091401663, "y": 50.025187883323994, "z": "NaN"},
                {"x": 8.263387091401663, "y": 50.02518788332397, "z": "NaN"},
                {"x": 8.26135032092621, "y": 50.0259773221143, "z": "NaN"},
                {"x": 8.26096129, "y": 50.026169259360756, "z": "NaN"},
                {"x": 8.258992108078331, "y": 50.027242058136395, "z": "NaN"},
                {"x": 8.258992108078331, "y": 50.027242058136395, "z": "NaN"},
                {"x": 8.258262644036721, "y": 50.027648192058, "z": "NaN"},
                {"x": 8.257051329549252, "y": 50.028395552140815, "z": "NaN"},
                {"x": 8.256749585403675, "y": 50.028571069197994, "z": "NaN"},
                {"x": 8.256749585403675, "y": 50.028571069197994, "z": "NaN"},
                {"x": 8.256156197810977, "y": 50.02889759661497, "z": "NaN"},
                {"x": 8.254426494774625, "y": 50.029765873497695, "z": "NaN"},
                {"x": 8.254426494774625, "y": 50.029765873497695, "z": "NaN"},
                {"x": 8.253546304682127, "y": 50.030241736830966, "z": "NaN"},
                {"x": 8.253546304682127, "y": 50.03024173683094, "z": "NaN"},
                {"x": 8.251510973432387, "y": 50.03133189786561, "z": "NaN"},
                {"x": 8.251510973432387, "y": 50.03133189786561, "z": "NaN"},
                {"x": 8.250338231480827, "y": 50.03195012741187, "z": "NaN"},
                {"x": 8.250094874952923, "y": 50.032063530051865, "z": "NaN"},
                {"x": 8.24860505, "y": 50.03261732, "z": "NaN"},
                {"x": 8.24860505, "y": 50.03261732000002, "z": "NaN"},
                {"x": 8.245824690687895, "y": 50.03356230759473, "z": "NaN"},
                {"x": 8.245824690687895, "y": 50.03356230759473, "z": "NaN"},
                {"x": 8.244433694434719, "y": 50.03404927379375, "z": "NaN"},
                {"x": 8.244003180314357, "y": 50.03417055337256, "z": "NaN"},
                {"x": 8.244003180314357, "y": 50.03417055337259, "z": "NaN"},
                {"x": 8.2437299274568, "y": 50.03426559888268, "z": "NaN"},
                {"x": 8.2437299274568, "y": 50.03426559888268, "z": "NaN"},
                {"x": 8.2437434541517, "y": 50.034278867318214, "z": "NaN"},
                {"x": 8.2437532065058, "y": 50.034293456642615, "z": "NaN"},
                {"x": 8.2437588759148, "y": 50.034308928269134, "z": "NaN"},
                {"x": 8.243760276694, "y": 50.03432481365356, "z": "NaN"},
                {"x": 8.2437573534706, "y": 50.03434062870111, "z": "NaN"},
                {"x": 8.243750184262, "y": 50.034355888967056, "z": "NaN"},
                {"x": 8.2437389790584, "y": 50.034370125062, "z": "NaN"},
                {"x": 8.2437240739538, "y": 50.03438289768247, "z": "NaN"},
                {"x": 8.2437059210484, "y": 50.03439381170545, "z": "NaN"},
                {"x": 8.2436850745052, "y": 50.03440252888492, "z": "NaN"},
                {"x": 8.2436621732523, "y": 50.03440877869886, "z": "NaN"},
                {"x": 8.2436432330844, "y": 50.0344118246342, "z": "NaN"},
                {"x": 8.2436432330844, "y": 50.0344118246342, "z": "NaN"},
                {"x": 8.243756602916655, "y": 50.034656179939226, "z": "NaN"},
                {"x": 8.243807671635109, "y": 50.03474085629556, "z": "NaN"},
                {"x": 8.24427038412787, "y": 50.03532077418847, "z": "NaN"},
                {"x": 8.24427038412787, "y": 50.03532077418847, "z": "NaN"},
                {"x": 8.244408593201626, "y": 50.03549399035947, "z": "NaN"},
                {"x": 8.244602489550159, "y": 50.03584914635245, "z": "NaN"},
                {"x": 8.244962725892483, "y": 50.03635844817221, "z": "NaN"},
                {"x": 8.244962725892483, "y": 50.03635844817221, "z": "NaN"},
                {"x": 8.24570097899871, "y": 50.037351472377715, "z": "NaN"},
                {"x": 8.24570097899871, "y": 50.037351472377715, "z": "NaN"},
                {"x": 8.245946998626719, "y": 50.03772896343527, "z": "NaN"},
                {"x": 8.245946998626719, "y": 50.03772896343529, "z": "NaN"},
                {"x": 8.2461535070694, "y": 50.03805386208212, "z": "NaN"},
                {"x": 8.2461535070694, "y": 50.03805386208212, "z": "NaN"},
                {"x": 8.246780919878468, "y": 50.039016583669515, "z": "NaN"},
                {"x": 8.247882092976653, "y": 50.04083147893723, "z": "NaN"},
                {"x": 8.247882092976653, "y": 50.04083147893723, "z": "NaN"},
                {"x": 8.248371850118868, "y": 50.0416392215605, "z": "NaN"},
                {"x": 8.24841103441803, "y": 50.04176237261754, "z": "NaN"},
                {"x": 8.248388385581968, "y": 50.04187400027666, "z": "NaN"},
                {"x": 8.248329240118858, "y": 50.04198777189137, "z": "NaN"},
                {"x": 8.248132958050208, "y": 50.04221649185538, "z": "NaN"},
                {"x": 8.248081119920416, "y": 50.04232389919163, "z": "NaN"},
                {"x": 8.248081119920416, "y": 50.04232389919165, "z": "NaN"},
                {"x": 8.248109547843264, "y": 50.042328850998864, "z": "NaN"},
                {"x": 8.248136204979145, "y": 50.042336897874854, "z": "NaN"},
                {"x": 8.248160281364475, "y": 50.04234779531794, "z": "NaN"},
                {"x": 8.248181045450469, "y": 50.04236121221296, "z": "NaN"},
                {"x": 8.248197866330882, "y": 50.04237674089248, "z": "NaN"},
                {"x": 8.248210232911774, "y": 50.04239390952357, "z": "NaN"},
                {"x": 8.248217769440842, "y": 50.04241219644466, "z": "NaN"},
                {"x": 8.248220246924463, "y": 50.04243104601592, "z": "NaN"},
                {"x": 8.248217590085556, "y": 50.04244988550233, "z": "NaN"},
                {"x": 8.24820987965082, "y": 50.042468142476004, "z": "NaN"},
                {"x": 8.248197349897916, "y": 50.04248526220902, "z": "NaN"},
                {"x": 8.248180381537045, "y": 50.0425007245284, "z": "NaN"},
                {"x": 8.248159490143266, "y": 50.04251405962121, "z": "NaN"},
                {"x": 8.24815845399989, "y": 50.042514610053374, "z": "NaN"},
                {"x": 8.24815845399989, "y": 50.042514610053374, "z": "NaN"},
                {"x": 8.248265952664456, "y": 50.04260616361699, "z": "NaN"},
                {"x": 8.248389544583103, "y": 50.0426684334931, "z": "NaN"},
                {"x": 8.249104140924606, "y": 50.04293162918285, "z": "NaN"},
                {"x": 8.24924742674591, "y": 50.04297433764763, "z": "NaN"},
                {"x": 8.249761629073788, "y": 50.043102284733855, "z": "NaN"},
                {"x": 8.249761629073788, "y": 50.043102284733855, "z": "NaN"},
                {"x": 8.250277644372764, "y": 50.043217325445895, "z": "NaN"},
                {"x": 8.251391500234654, "y": 50.0435269541452, "z": "NaN"},
                {"x": 8.251391500234654, "y": 50.0435269541452, "z": "NaN"},
                {"x": 8.25167095661177, "y": 50.04372255079444, "z": "NaN"},
                {"x": 8.252275282090155, "y": 50.044280667528476, "z": "NaN"},
                {"x": 8.252463447196659, "y": 50.04441982748446, "z": "NaN"},
                {"x": 8.252706744868789, "y": 50.04453460478373, "z": "NaN"},
                {"x": 8.252906019881138, "y": 50.044607144908426, "z": "NaN"},
                {"x": 8.252906019881138, "y": 50.044607144908426, "z": "NaN"},
                {"x": 8.253193072803347, "y": 50.044680367611335, "z": "NaN"},
                {"x": 8.253545595309525, "y": 50.04473835875705, "z": "NaN"},
                {"x": 8.253826755309522, "y": 50.04475727124256, "z": "NaN"},
                {"x": 8.255038386697224, "y": 50.04476611821232, "z": "NaN"},
                {"x": 8.255038386697224, "y": 50.04476611821232, "z": "NaN"},
                {"x": 8.255280746066138, "y": 50.0447440131108, "z": "NaN"},
                {"x": 8.2554310041829, "y": 50.04472059420899, "z": "NaN"},
                {"x": 8.2554310041829, "y": 50.04472059420899, "z": "NaN"},
                {"x": 8.2554573242754, "y": 50.044694694854996, "z": "NaN"},
                {"x": 8.2554573242754, "y": 50.044694694854996, "z": "NaN"},
                {"x": 8.2554902447613, "y": 50.044672097810015, "z": "NaN"},
                {"x": 8.2555287868037, "y": 50.04465349018301, "z": "NaN"},
                {"x": 8.2555717986999, "y": 50.04463944264, "z": "NaN"},
                {"x": 8.255617988465, "y": 50.04463039115299, "z": "NaN"},
                {"x": 8.2556659614434, "y": 50.044626622393984, "z": "NaN"},
                {"x": 8.2557142619501, "y": 50.044628263453, "z": "NaN"},
                {"x": 8.2557614176573, "y": 50.04463527643297, "z": "NaN"},
                {"x": 8.2558059852558, "y": 50.04464745824401, "z": "NaN"},
                {"x": 8.2558465958018, "y": 50.044664445759, "z": "NaN"},
                {"x": 8.2558465958018, "y": 50.044664445759, "z": "NaN"},
                {"x": 8.2558819981495, "y": 50.044685726225, "z": "NaN"},
                {"x": 8.2558822769973, "y": 50.04468592626701, "z": "NaN"},
                {"x": 8.2559113193144, "y": 50.044710880911985, "z": "NaN"},
                {"x": 8.2559113193144, "y": 50.044710880911985, "z": "NaN"},
                {"x": 8.2559331527336, "y": 50.04473871312102, "z": "NaN"},
                {"x": 8.2559471006559, "y": 50.044768570087015, "z": "NaN"},
                {"x": 8.2559527304286, "y": 50.044799535208995, "z": "NaN"},
                {"x": 8.2559527353624, "y": 50.04479964715302, "z": "NaN"},
                {"x": 8.2559498417985, "y": 50.044830767714004, "z": "NaN"},
                {"x": 8.2559385450179, "y": 50.044861084982, "z": "NaN"},
                {"x": 8.2559385450179, "y": 50.044861084982, "z": "NaN"},
                {"x": 8.2559191955111, "y": 50.044889667846014, "z": "NaN"},
                {"x": 8.2559191955111, "y": 50.044889667846014, "z": "NaN"},
                {"x": 8.2559276154642, "y": 50.04501624276902, "z": "NaN"},
                {"x": 8.2559276154642, "y": 50.04501624276902, "z": "NaN"},
                {"x": 8.255919693729549, "y": 50.045296838897876, "z": "NaN"},
                {"x": 8.255988773741912, "y": 50.04572838612692, "z": "NaN"},
                {"x": 8.256299997484708, "y": 50.047167379263094, "z": "NaN"},
                {"x": 8.256299997484708, "y": 50.047167379263094, "z": "NaN"},
                {"x": 8.25641136, "y": 50.04781557999998, "z": "NaN"},
                {"x": 8.25642748558197, "y": 50.04852708999999, "z": "NaN"},
                {"x": 8.25642748558197, "y": 50.04852708999999, "z": "NaN"},
                {"x": 8.256610947699954, "y": 50.0498181204628, "z": "NaN"},
                {"x": 8.256610947699954, "y": 50.0498181204628, "z": "NaN"},
                {"x": 8.256654860237733, "y": 50.05026480212614, "z": "NaN"},
                {"x": 8.256654860237733, "y": 50.050264802126165, "z": "NaN"},
                {"x": 8.25676439, "y": 50.05192476999999, "z": "NaN"},
                {"x": 8.25676439, "y": 50.05192476999999, "z": "NaN"},
                {"x": 8.25680467, "y": 50.052198900000015, "z": "NaN"},
                {"x": 8.25688865828566, "y": 50.052533113515985, "z": "NaN"},
                {"x": 8.25688865828566, "y": 50.05253311351596, "z": "NaN"},
                {"x": 8.257038762387307, "y": 50.05288066545237, "z": "NaN"},
                {"x": 8.25727274, "y": 50.05332595088899, "z": "NaN"},
                {"x": 8.257360429940569, "y": 50.05357322114287, "z": "NaN"},
                {"x": 8.25741476209015, "y": 50.05385447298824, "z": "NaN"},
                {"x": 8.25741476209015, "y": 50.05385447298824, "z": "NaN"},
                {"x": 8.257419525130478, "y": 50.05401822489295, "z": "NaN"},
                {"x": 8.257402904857274, "y": 50.054202423042824, "z": "NaN"},
                {"x": 8.25737296447746, "y": 50.05435170319033, "z": "NaN"},
                {"x": 8.25737296447746, "y": 50.05435170319033, "z": "NaN"},
                {"x": 8.257284826593558, "y": 50.05462724886433, "z": "NaN"},
                {"x": 8.257186538592022, "y": 50.05484632567146, "z": "NaN"},
                {"x": 8.25708450367004, "y": 50.055018902278086, "z": "NaN"},
                {"x": 8.256924149690876, "y": 50.0552614141797, "z": "NaN"},
                {"x": 8.256143106700007, "y": 50.0562816387799, "z": "NaN"},
                {"x": 8.255949009982276, "y": 50.05657261912583, "z": "NaN"},
                {"x": 8.255949009982276, "y": 50.05657261912583, "z": "NaN"},
                {"x": 8.255650443044354, "y": 50.0570784277481, "z": "NaN"},
                {"x": 8.255272064001733, "y": 50.05779199336189, "z": "NaN"},
                {"x": 8.255272064001733, "y": 50.05779199336189, "z": "NaN"},
                {"x": 8.25515989469745, "y": 50.05800579855292, "z": "NaN"},
                {"x": 8.25515989469745, "y": 50.05800579855292, "z": "NaN"},
                {"x": 8.254886963718208, "y": 50.05851566268752, "z": "NaN"},
                {"x": 8.254886963718208, "y": 50.05851566268752, "z": "NaN"},
                {"x": 8.2541334331032, "y": 50.05994482808402, "z": "NaN"},
                {"x": 8.2539287580863, "y": 50.06042006565054, "z": "NaN"},
                {"x": 8.253862111450907, "y": 50.06055034148107, "z": "NaN"},
                {"x": 8.253862111450907, "y": 50.06055034148107, "z": "NaN"},
                {"x": 8.253554206976274, "y": 50.06114464730762, "z": "NaN"},
                {"x": 8.253554206976274, "y": 50.06114464730762, "z": "NaN"},
                {"x": 8.253049724274469, "y": 50.0620731612202, "z": "NaN"},
                {"x": 8.253049724274469, "y": 50.0620731612202, "z": "NaN"},
                {"x": 8.252758300131108, "y": 50.062566971157494, "z": "NaN"},
                {"x": 8.252466244738063, "y": 50.06300306264103, "z": "NaN"},
                {"x": 8.252466244738063, "y": 50.06300306264103, "z": "NaN"},
                {"x": 8.252127110332939, "y": 50.06339808569418, "z": "NaN"},
                {"x": 8.252127110332939, "y": 50.06339808569418, "z": "NaN"},
                {"x": 8.251766217374437, "y": 50.06395832826771, "z": "NaN"},
                {"x": 8.251766217374437, "y": 50.06395832826771, "z": "NaN"},
                {"x": 8.25145103349182, "y": 50.06445483177822, "z": "NaN"},
                {"x": 8.25145103349182, "y": 50.06445483177822, "z": "NaN"},
                {"x": 8.250797582517666, "y": 50.0655080086869, "z": "NaN"},
                {"x": 8.250797582517666, "y": 50.0655080086869, "z": "NaN"},
                {"x": 8.250657130353549, "y": 50.06572768854873, "z": "NaN"},
                {"x": 8.250657130353549, "y": 50.06572768854873, "z": "NaN"},
                {"x": 8.250364344542911, "y": 50.0661972053194, "z": "NaN"},
                {"x": 8.250364344542911, "y": 50.0661972053194, "z": "NaN"},
                {"x": 8.250099910554928, "y": 50.06674223248515, "z": "NaN"},
                {"x": 8.250099910554928, "y": 50.06674223248515, "z": "NaN"},
                {"x": 8.249445183714606, "y": 50.06805344437171, "z": "NaN"},
                {"x": 8.249445183714606, "y": 50.06805344437171, "z": "NaN"},
                {"x": 8.249323206034386, "y": 50.068300937057245, "z": "NaN"},
                {"x": 8.249252933280344, "y": 50.06848636636108, "z": "NaN"},
                {"x": 8.248994572600047, "y": 50.069307649292625, "z": "NaN"},
                {"x": 8.248994572600047, "y": 50.069307649292625, "z": "NaN"},
                {"x": 8.248843063867406, "y": 50.069732536184524, "z": "NaN"},
                {"x": 8.248843063867406, "y": 50.069732536184524, "z": "NaN"},
                {"x": 8.248592940926214, "y": 50.07076076140972, "z": "NaN"},
                {"x": 8.248506786360023, "y": 50.07106828319159, "z": "NaN"},
                {"x": 8.248356087562126, "y": 50.07149753173962, "z": "NaN"},
                {"x": 8.248356087562126, "y": 50.07149753173964, "z": "NaN"},
                {"x": 8.248200605046922, "y": 50.07189545231536, "z": "NaN"},
                {"x": 8.248101448921037, "y": 50.07222192741763, "z": "NaN"},
                {"x": 8.248101448921037, "y": 50.07222192741763, "z": "NaN"},
                {"x": 8.248062892166464, "y": 50.07238331771403, "z": "NaN"},
                {"x": 8.24803640535246, "y": 50.072561061598606, "z": "NaN"},
                {"x": 8.2480229943073, "y": 50.07282875211401, "z": "NaN"},
                {"x": 8.248066678689275, "y": 50.073302844735295, "z": "NaN"},
                {"x": 8.248049642471019, "y": 50.07337039856564, "z": "NaN"},
                {"x": 8.248016041516681, "y": 50.07342309801962, "z": "NaN"},
                {"x": 8.247955618472194, "y": 50.07345686141376, "z": "NaN"},
                {"x": 8.247864171908676, "y": 50.073476281575495, "z": "NaN"},
                {"x": 8.247864171908676, "y": 50.073476281575495, "z": "NaN"},
                {"x": 8.247673818887645, "y": 50.0734931733436, "z": "NaN"},
                {"x": 8.246710822032227, "y": 50.073441422112516, "z": "NaN"},
                {"x": 8.246710822032227, "y": 50.073441422112516, "z": "NaN"},
                {"x": 8.245419195106509, "y": 50.0733717716669, "z": "NaN"},
                {"x": 8.245419195106509, "y": 50.0733717716669, "z": "NaN"},
                {"x": 8.245439515955931, "y": 50.07380732425315, "z": "NaN"},
                {"x": 8.245439515955931, "y": 50.07380732425315, "z": "NaN"},
                {"x": 8.245608233135245, "y": 50.074862309735494, "z": "NaN"},
                {"x": 8.24563081349182, "y": 50.07512832913964, "z": "NaN"},
                {"x": 8.245527682209014, "y": 50.076768476099275, "z": "NaN"},
                {"x": 8.245501843623556, "y": 50.076833909122406, "z": "NaN"},
                {"x": 8.245436812844245, "y": 50.07691916374124, "z": "NaN"},
                {"x": 8.245436812844245, "y": 50.07691916374124, "z": "NaN"},
                {"x": 8.245392891671628, "y": 50.077014052005445, "z": "NaN"},
                {"x": 8.24537311038015, "y": 50.07709172683927, "z": "NaN"},
                {"x": 8.24528996190067, "y": 50.077779821396504, "z": "NaN"},
                {"x": 8.245287279691647, "y": 50.077965291097755, "z": "NaN"},
                {"x": 8.245287279691647, "y": 50.077965291097755, "z": "NaN"},
                {"x": 8.245279289684236, "y": 50.07815929784913, "z": "NaN"},
                {"x": 8.245279289684236, "y": 50.07815929784913, "z": "NaN"},
                {"x": 8.245149481203464, "y": 50.0787555733245, "z": "NaN"},
                {"x": 8.245149481203464, "y": 50.0787555733245, "z": "NaN"},
                {"x": 8.245066524299165, "y": 50.079377375536126, "z": "NaN"},
                {"x": 8.245066524299165, "y": 50.079377375536126, "z": "NaN"},
                {"x": 8.244898982090154, "y": 50.08064331957836, "z": "NaN"},
                {"x": 8.244898982090154, "y": 50.08064331957836, "z": "NaN"},
                {"x": 8.244829059771991, "y": 50.081355750883446, "z": "NaN"},
                {"x": 8.244659504299173, "y": 50.083009701140945, "z": "NaN"},
                {"x": 8.244659504299173, "y": 50.083009701140945, "z": "NaN"},
                {"x": 8.24465695833418, "y": 50.083181546484354, "z": "NaN"},
                {"x": 8.244592721561833, "y": 50.08372858948899, "z": "NaN"},
                {"x": 8.244592721561833, "y": 50.08372858948899, "z": "NaN"},
                {"x": 8.244525744314858, "y": 50.084258866042504, "z": "NaN"},
                {"x": 8.244525744314858, "y": 50.084258866042525, "z": "NaN"},
                {"x": 8.246953814025584, "y": 50.0843694444855, "z": "NaN"},
                {"x": 8.246999579216904, "y": 50.08436223753256, "z": "NaN"},
                {"x": 8.247032603915406, "y": 50.08433695940545, "z": "NaN"},
                {"x": 8.247080147906408, "y": 50.084263068331595, "z": "NaN"},
                {"x": 8.247080147906408, "y": 50.084263068331595, "z": "NaN"},
                {"x": 8.24713901617515, "y": 50.08420523720755, "z": "NaN"},
                {"x": 8.24713901617515, "y": 50.08420523720755, "z": "NaN"},
                {"x": 8.247291101809203, "y": 50.0840110317197, "z": "NaN"},
                {"x": 8.247291101809203, "y": 50.0840110317197, "z": "NaN"},
                {"x": 8.247286829865775, "y": 50.08411891532466, "z": "NaN"},
            ],
        },
        {
            "response": {
                "results": [
                    {
                        "path": {
                            "segmentId": 72856060,
                            "nodeId": 79353353,
                            "x": 8.262884296737077,
                            "y": 50.003263849158074,
                            "direction": True,
                        },
                        "street": 1,
                        "altStreets": [0],
                        "distance": 0,
                        "length": 11,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 1,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -90, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 246045337,
                            "nodeId": 79353354,
                            "x": 8.262231178841974,
                            "y": 50.00350434288446,
                            "direction": True,
                        },
                        "street": 3,
                        "altStreets": [2],
                        "distance": 9,
                        "length": 71,
                        "crossTime": 28,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858711,
                            "nodeId": 79353534,
                            "x": 8.261405058465337,
                            "y": 50.003853444538585,
                            "direction": False,
                        },
                        "street": 3,
                        "altStreets": [2],
                        "distance": 37,
                        "length": 25,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858710,
                            "nodeId": 79356530,
                            "x": 8.261106662712432,
                            "y": 50.0039745520515,
                            "direction": False,
                        },
                        "street": 3,
                        "altStreets": [2],
                        "distance": 42,
                        "length": 29,
                        "crossTime": 6,
                        "crossTimeWithoutRealTime": 6,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858709,
                            "nodeId": 79353532,
                            "x": 8.26076937492879,
                            "y": 50.00411893249527,
                            "direction": False,
                        },
                        "street": 3,
                        "altStreets": [2],
                        "distance": 48,
                        "length": 89,
                        "crossTime": 20,
                        "crossTimeWithoutRealTime": 20,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858708,
                            "nodeId": 79356551,
                            "x": 8.259711914024582,
                            "y": 50.00454517551499,
                            "direction": False,
                        },
                        "street": 3,
                        "altStreets": [2],
                        "distance": 68,
                        "length": 71,
                        "crossTime": 16,
                        "crossTimeWithoutRealTime": 16,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858704,
                            "nodeId": 79354796,
                            "x": 8.25887037094613,
                            "y": 50.00488651199142,
                            "direction": False,
                        },
                        "street": 3,
                        "altStreets": [2],
                        "distance": 84,
                        "length": 24,
                        "crossTime": 6,
                        "crossTimeWithoutRealTime": 6,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858703,
                            "nodeId": 79354802,
                            "x": 8.25858549,
                            "y": 50.00500608,
                            "direction": False,
                        },
                        "street": 3,
                        "altStreets": [2],
                        "distance": 90,
                        "length": 60,
                        "crossTime": 10,
                        "crossTimeWithoutRealTime": 10,
                        "crossTimeFreeFlow": 6,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72860930,
                            "nodeId": 79353526,
                            "x": 8.257875941953877,
                            "y": 50.00528990652044,
                            "direction": False,
                        },
                        "street": 3,
                        "altStreets": [2],
                        "distance": 100,
                        "length": 94,
                        "crossTime": 18,
                        "crossTimeWithoutRealTime": 18,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 187906992,
                            "nodeId": 79354737,
                            "x": 8.256777577362033,
                            "y": 50.00574975491552,
                            "direction": False,
                        },
                        "street": 3,
                        "altStreets": [2],
                        "distance": 118,
                        "length": 84,
                        "crossTime": 15,
                        "crossTimeWithoutRealTime": 15,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 187906995,
                            "nodeId": 175960625,
                            "x": 8.255772419533788,
                            "y": 50.006143229946886,
                            "direction": False,
                        },
                        "street": 3,
                        "altStreets": [2],
                        "distance": 133,
                        "length": 47,
                        "crossTime": 8,
                        "crossTimeWithoutRealTime": 8,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 187906998,
                            "nodeId": 79354736,
                            "x": 8.255221225581261,
                            "y": 50.00636474678355,
                            "direction": True,
                        },
                        "street": 5,
                        "altStreets": [4],
                        "distance": 141,
                        "length": 29,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 246044662,
                            "nodeId": 79353518,
                            "x": 8.254931547007622,
                            "y": 50.00654833778641,
                            "direction": True,
                        },
                        "street": 5,
                        "altStreets": [4],
                        "distance": 145,
                        "length": 132,
                        "crossTime": 18,
                        "crossTimeWithoutRealTime": 18,
                        "crossTimeFreeFlow": 13,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858639,
                            "nodeId": 79354731,
                            "x": 8.253787584862806,
                            "y": 50.00748093476955,
                            "direction": True,
                        },
                        "street": 5,
                        "altStreets": [4],
                        "distance": 163,
                        "length": 89,
                        "crossTime": 11,
                        "crossTimeWithoutRealTime": 11,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72859244,
                            "nodeId": 79356517,
                            "x": 8.253045954070139,
                            "y": 50.00812219243653,
                            "direction": True,
                        },
                        "street": 5,
                        "altStreets": [4],
                        "distance": 174,
                        "length": 124,
                        "crossTime": 54,
                        "crossTimeWithoutRealTime": 54,
                        "crossTimeFreeFlow": 13,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [
                                        {"angle": -180, "selected": False}
                                    ],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [
                                        {"angle": 0, "selected": True},
                                        {"angle": 90, "selected": False},
                                    ],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 406854564,
                            "nodeId": 79356528,
                            "x": 8.252052866182382,
                            "y": 50.00903321180373,
                            "direction": False,
                        },
                        "street": 7,
                        "altStreets": [6],
                        "distance": 228,
                        "length": 16,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -90, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 406854563,
                            "nodeId": 314450778,
                            "x": 8.251915911180072,
                            "y": 50.00914479017255,
                            "direction": False,
                        },
                        "street": 7,
                        "altStreets": [6],
                        "distance": 230,
                        "length": 210,
                        "crossTime": 23,
                        "crossTimeWithoutRealTime": 23,
                        "crossTimeFreeFlow": 21,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 148856550,
                            "nodeId": 79353513,
                            "x": 8.25014053,
                            "y": 50.010642,
                            "direction": True,
                        },
                        "street": 7,
                        "altStreets": [6],
                        "distance": 253,
                        "length": 81,
                        "crossTime": 8,
                        "crossTimeWithoutRealTime": 8,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 148856675,
                            "nodeId": 155037741,
                            "x": 8.2495161454498,
                            "y": 50.011245441565,
                            "direction": True,
                        },
                        "street": 7,
                        "altStreets": [6],
                        "distance": 261,
                        "length": 155,
                        "crossTime": 36,
                        "crossTimeWithoutRealTime": 36,
                        "crossTimeFreeFlow": 16,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -90, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                                "enable_display": True,
                                "enable_voice": False,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 394471043,
                            "nodeId": 79360012,
                            "x": 8.248990618893608,
                            "y": 50.01257042185178,
                            "direction": True,
                        },
                        "street": 8,
                        "distance": 297,
                        "length": 136,
                        "crossTime": 21,
                        "crossTimeWithoutRealTime": 21,
                        "crossTimeFreeFlow": 16,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 148856762,
                            "nodeId": 79359490,
                            "x": 8.249559193907851,
                            "y": 50.01373440777294,
                            "direction": False,
                        },
                        "street": 8,
                        "distance": 318,
                        "length": 159,
                        "crossTime": 18,
                        "crossTimeWithoutRealTime": 18,
                        "crossTimeFreeFlow": 15,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 394436128,
                            "nodeId": 79354765,
                            "x": 8.250746771401674,
                            "y": 50.01494282644239,
                            "direction": True,
                        },
                        "street": 8,
                        "distance": 336,
                        "length": 132,
                        "crossTime": 14,
                        "crossTimeWithoutRealTime": 14,
                        "crossTimeFreeFlow": 12,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 394436130,
                            "nodeId": 306127265,
                            "x": 8.252098997836136,
                            "y": 50.015745687310805,
                            "direction": True,
                        },
                        "street": 8,
                        "distance": 350,
                        "length": 17,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 394436131,
                            "nodeId": 79354768,
                            "x": 8.252305123432388,
                            "y": 50.01582494994901,
                            "direction": False,
                        },
                        "street": 8,
                        "distance": 352,
                        "length": 90,
                        "crossTime": 43,
                        "crossTimeWithoutRealTime": 43,
                        "crossTimeFreeFlow": 12,
                        "knownDirection": True,
                        "penalty": 6,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [
                                        {"angle": -90, "selected": True},
                                        {"angle": -180, "selected": False},
                                    ],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [
                                        {"angle": 90, "selected": False},
                                        {"angle": 0, "selected": False},
                                    ],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "TURN_LEFT",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 0,
                                },
                                "angle": -90,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 382831429,
                            "nodeId": 176073660,
                            "x": 8.253119044265704,
                            "y": 50.01643708155337,
                            "direction": False,
                        },
                        "street": 10,
                        "altStreets": [9],
                        "distance": 395,
                        "length": 19,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -90, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 2,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 382831427,
                            "nodeId": 298549028,
                            "x": 8.25293337395933,
                            "y": 50.016552715386695,
                            "direction": False,
                        },
                        "street": 10,
                        "altStreets": [9],
                        "distance": 397,
                        "length": 112,
                        "crossTime": 12,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 11,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 350793179,
                            "nodeId": 277847840,
                            "x": 8.251707813441712,
                            "y": 50.01718037115454,
                            "direction": False,
                        },
                        "street": 10,
                        "altStreets": [9],
                        "distance": 409,
                        "length": 180,
                        "crossTime": 17,
                        "crossTimeWithoutRealTime": 17,
                        "crossTimeFreeFlow": 14,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [
                                        {"angle": 0, "selected": True},
                                        {"angle": -90, "selected": False},
                                    ],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [
                                        {"angle": 90, "selected": False},
                                        {"angle": 0, "selected": True},
                                    ],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 277142302,
                            "nodeId": 79357965,
                            "x": 8.2497482112828,
                            "y": 50.01819872062916,
                            "direction": False,
                        },
                        "street": 10,
                        "altStreets": [9],
                        "distance": 426,
                        "length": 282,
                        "crossTime": 33,
                        "crossTimeWithoutRealTime": 33,
                        "crossTimeFreeFlow": 22,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 277142299,
                            "nodeId": 230367599,
                            "x": 8.246541399941647,
                            "y": 50.01966096951187,
                            "direction": False,
                        },
                        "street": 10,
                        "altStreets": [9],
                        "distance": 459,
                        "length": 97,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 416469020,
                            "nodeId": 171195731,
                            "x": 8.245400432815696,
                            "y": 50.02012196764528,
                            "direction": True,
                        },
                        "street": 10,
                        "altStreets": [9],
                        "distance": 468,
                        "length": 164,
                        "crossTime": 31,
                        "crossTimeWithoutRealTime": 20,
                        "crossTimeFreeFlow": 22,
                        "knownDirection": True,
                        "penalty": 7,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [
                                        {"angle": -90, "selected": False},
                                        {"angle": -180, "selected": False},
                                    ],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [
                                        {"angle": 0, "selected": True},
                                        {"angle": 90, "selected": False},
                                    ],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                                "enable_display": True,
                                "enable_voice": False,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 418824810,
                            "nodeId": 320630177,
                            "x": 8.243462717903718,
                            "y": 50.02091014197717,
                            "direction": True,
                        },
                        "street": 10,
                        "altStreets": [9],
                        "distance": 499,
                        "length": 67,
                        "crossTime": 6,
                        "crossTimeWithoutRealTime": 6,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 6,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 418824811,
                            "nodeId": 322157872,
                            "x": 8.242655622167794,
                            "y": 50.02120999773974,
                            "direction": True,
                        },
                        "street": 10,
                        "altStreets": [9],
                        "distance": 505,
                        "length": 38,
                        "crossTime": 3,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 6,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 416469102,
                            "nodeId": 320630222,
                            "x": 8.242190576621487,
                            "y": 50.021382772659436,
                            "direction": True,
                        },
                        "street": 10,
                        "altStreets": [9],
                        "distance": 508,
                        "length": 71,
                        "crossTime": 6,
                        "crossTimeWithoutRealTime": 6,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 416469116,
                            "nodeId": 320630223,
                            "x": 8.241327962040168,
                            "y": 50.02169609336127,
                            "direction": False,
                        },
                        "street": 10,
                        "altStreets": [9],
                        "distance": 514,
                        "length": 112,
                        "crossTime": 13,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [
                                        {"angle": -90, "selected": False},
                                        {"angle": 0, "selected": True},
                                    ],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [
                                        {"angle": 0, "selected": True},
                                        {"angle": 90, "selected": False},
                                    ],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 316008126,
                            "nodeId": 256052778,
                            "x": 8.239959297842791,
                            "y": 50.02218317258784,
                            "direction": False,
                        },
                        "street": 10,
                        "altStreets": [9],
                        "distance": 527,
                        "length": 50,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 321753678,
                            "nodeId": 79359111,
                            "x": 8.23934324536893,
                            "y": 50.02239945344938,
                            "direction": True,
                        },
                        "street": 10,
                        "altStreets": [9],
                        "distance": 531,
                        "length": 224,
                        "crossTime": 17,
                        "crossTimeWithoutRealTime": 17,
                        "crossTimeFreeFlow": 17,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [
                                        {"angle": 0, "selected": True},
                                        {"angle": 45, "selected": False},
                                    ],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "CONTINUE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 408977796,
                            "nodeId": 259703288,
                            "x": 8.236558596706194,
                            "y": 50.023308604431385,
                            "direction": True,
                        },
                        "street": 10,
                        "altStreets": [9],
                        "distance": 548,
                        "length": 76,
                        "crossTime": 25,
                        "crossTimeWithoutRealTime": 8,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 270183483,
                            "nodeId": 155089409,
                            "x": 8.235590749858485,
                            "y": 50.02359538567201,
                            "direction": True,
                        },
                        "street": 11,
                        "altStreets": [9],
                        "distance": 573,
                        "length": 47,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [
                                        {"angle": 0, "selected": False},
                                        {"angle": 45, "selected": True},
                                    ],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 45, "selected": True}],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "KEEP_RIGHT",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 2,
                                },
                                "angle": 45,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 245730527,
                            "nodeId": 209439299,
                            "x": 8.234997981666178,
                            "y": 50.02377804923328,
                            "direction": True,
                        },
                        "street": 12,
                        "distance": 577,
                        "length": 18,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 1,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 245730543,
                            "nodeId": 209439312,
                            "x": 8.234841801485837,
                            "y": 50.02390960160955,
                            "direction": True,
                        },
                        "street": 10,
                        "altStreets": [9],
                        "distance": 579,
                        "length": 198,
                        "crossTime": 12,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 12,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -45, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": False}],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "KEEP_LEFT",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 0,
                                },
                                "angle": -45,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 144734307,
                            "nodeId": 153162766,
                            "x": 8.232382886371434,
                            "y": 50.02471994516111,
                            "direction": True,
                        },
                        "street": 12,
                        "distance": 591,
                        "length": 91,
                        "crossTime": 6,
                        "crossTimeWithoutRealTime": 6,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 422534527,
                            "nodeId": 318347580,
                            "x": 8.231205895098276,
                            "y": 50.025020737914836,
                            "direction": True,
                        },
                        "street": 11,
                        "altStreets": [9],
                        "distance": 597,
                        "length": 588,
                        "crossTime": 42,
                        "crossTimeWithoutRealTime": 42,
                        "crossTimeFreeFlow": 38,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 412900598,
                            "nodeId": 79358521,
                            "x": 8.223907135510688,
                            "y": 50.027428038992305,
                            "direction": True,
                        },
                        "street": 11,
                        "altStreets": [9],
                        "distance": 639,
                        "length": 158,
                        "crossTime": 15,
                        "crossTimeWithoutRealTime": 15,
                        "crossTimeFreeFlow": 11,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -45, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "KEEP_RIGHT",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 2,
                                },
                                "angle": 0,
                                "angle_override": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 377923490,
                            "nodeId": 295322055,
                            "x": 8.221945055140937,
                            "y": 50.02807753575487,
                            "direction": True,
                        },
                        "street": 12,
                        "distance": 654,
                        "length": 56,
                        "crossTime": 17,
                        "crossTimeWithoutRealTime": 17,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 377923681,
                            "nodeId": 204938076,
                            "x": 8.221326594704127,
                            "y": 50.02838294945588,
                            "direction": True,
                        },
                        "street": 12,
                        "distance": 671,
                        "length": 48,
                        "crossTime": 6,
                        "crossTimeWithoutRealTime": 6,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 4,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 252901083,
                            "nodeId": 295322143,
                            "x": 8.220772658073832,
                            "y": 50.02857279231876,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 677,
                        "length": 157,
                        "crossTime": 11,
                        "crossTimeWithoutRealTime": 11,
                        "crossTimeFreeFlow": 12,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 4,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 45, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                                "enable_display": True,
                                "enable_voice": False,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 377934608,
                            "nodeId": 213929291,
                            "x": 8.218761335378296,
                            "y": 50.02910073477668,
                            "direction": True,
                        },
                        "street": 14,
                        "distance": 688,
                        "length": 606,
                        "crossTime": 36,
                        "crossTimeWithoutRealTime": 36,
                        "crossTimeFreeFlow": 35,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 4,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 393600800,
                            "nodeId": 305563784,
                            "x": 8.211691254839037,
                            "y": 50.03043458162623,
                            "direction": True,
                        },
                        "street": 15,
                        "distance": 724,
                        "length": 43,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 3,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 345370230,
                            "nodeId": 274442545,
                            "x": 8.211725202938748,
                            "y": 50.03082346533934,
                            "direction": True,
                        },
                        "street": 15,
                        "distance": 726,
                        "length": 266,
                        "crossTime": 12,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 11,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 3,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 432884042,
                            "nodeId": 274304345,
                            "x": 8.211992269022183,
                            "y": 50.03321278645702,
                            "direction": True,
                        },
                        "street": 16,
                        "distance": 738,
                        "length": 440,
                        "crossTime": 18,
                        "crossTimeWithoutRealTime": 18,
                        "crossTimeFreeFlow": 18,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 3,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 432901192,
                            "nodeId": 331502556,
                            "x": 8.212418515929832,
                            "y": 50.03716254330283,
                            "direction": True,
                        },
                        "street": 16,
                        "distance": 756,
                        "length": 413,
                        "crossTime": 19,
                        "crossTimeWithoutRealTime": 19,
                        "crossTimeFreeFlow": 18,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 3,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 432901193,
                            "nodeId": 331514374,
                            "x": 8.212833382040218,
                            "y": 50.0408687665798,
                            "direction": True,
                        },
                        "street": 16,
                        "distance": 775,
                        "length": 57,
                        "crossTime": 3,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 3,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 45, "selected": False}],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "CONTINUE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 381075021,
                            "nodeId": 213928392,
                            "x": 8.21289104218487,
                            "y": 50.04138385318259,
                            "direction": False,
                        },
                        "street": 16,
                        "distance": 778,
                        "length": 516,
                        "crossTime": 30,
                        "crossTimeWithoutRealTime": 30,
                        "crossTimeFreeFlow": 29,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 3,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 379759250,
                            "nodeId": 296528938,
                            "x": 8.213261996983642,
                            "y": 50.04601206416771,
                            "direction": False,
                        },
                        "street": 16,
                        "distance": 808,
                        "length": 406,
                        "crossTime": 21,
                        "crossTimeWithoutRealTime": 21,
                        "crossTimeFreeFlow": 21,
                        "knownDirection": True,
                        "penalty": 4,
                        "roadType": 3,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [
                                        {"angle": 0, "selected": True},
                                        {"angle": 0, "selected": False},
                                    ],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 45, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 252896526,
                            "nodeId": 213926479,
                            "x": 8.213118670395547,
                            "y": 50.04965954786453,
                            "direction": False,
                        },
                        "street": 16,
                        "distance": 829,
                        "length": 312,
                        "crossTime": 15,
                        "crossTimeWithoutRealTime": 15,
                        "crossTimeFreeFlow": 14,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 3,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 278592762,
                            "nodeId": 213926297,
                            "x": 8.212844297609562,
                            "y": 50.05245521157355,
                            "direction": True,
                        },
                        "street": 16,
                        "distance": 844,
                        "length": 44,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 3,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 45, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 278592763,
                            "nodeId": 231278216,
                            "x": 8.2127989478662,
                            "y": 50.052849629878864,
                            "direction": True,
                        },
                        "street": 16,
                        "distance": 846,
                        "length": 299,
                        "crossTime": 14,
                        "crossTimeWithoutRealTime": 14,
                        "crossTimeFreeFlow": 14,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 3,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 252897721,
                            "nodeId": 213926749,
                            "x": 8.212486576545613,
                            "y": 50.055529247397,
                            "direction": True,
                        },
                        "street": 16,
                        "distance": 860,
                        "length": 494,
                        "crossTime": 21,
                        "crossTimeWithoutRealTime": 21,
                        "crossTimeFreeFlow": 22,
                        "knownDirection": True,
                        "penalty": 4,
                        "roadType": 3,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 366190463,
                            "nodeId": 213927162,
                            "x": 8.213796225968,
                            "y": 50.059807828617,
                            "direction": False,
                        },
                        "street": 16,
                        "distance": 881,
                        "length": 503,
                        "crossTime": 63,
                        "crossTimeWithoutRealTime": 63,
                        "crossTimeFreeFlow": 20,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 3,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 366190466,
                            "nodeId": 287763523,
                            "x": 8.218072891322226,
                            "y": 50.06339565366394,
                            "direction": False,
                        },
                        "street": 16,
                        "distance": 944,
                        "length": 178,
                        "crossTime": 46,
                        "crossTimeWithoutRealTime": 46,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 3,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 366190465,
                            "nodeId": 287763525,
                            "x": 8.219601497728076,
                            "y": 50.064659729230826,
                            "direction": False,
                        },
                        "street": 16,
                        "distance": 990,
                        "length": 67,
                        "crossTime": 33,
                        "crossTimeWithoutRealTime": 33,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 3,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "CONTINUE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 270214555,
                            "nodeId": 79358611,
                            "x": 8.220131118137546,
                            "y": 50.06515133536746,
                            "direction": True,
                        },
                        "street": 18,
                        "altStreets": [17],
                        "distance": 1023,
                        "length": 108,
                        "crossTime": 55,
                        "crossTimeWithoutRealTime": 55,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 270214556,
                            "nodeId": 79361338,
                            "x": 8.221017569303536,
                            "y": 50.06593415411581,
                            "direction": True,
                        },
                        "street": 18,
                        "altStreets": [17],
                        "distance": 1078,
                        "length": 93,
                        "crossTime": 47,
                        "crossTimeWithoutRealTime": 47,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 270214555,
                            "segment_direction": True,
                        },
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 374279468,
                            "nodeId": 79359829,
                            "x": 8.22188258171079,
                            "y": 50.06655827540674,
                            "direction": True,
                        },
                        "street": 18,
                        "altStreets": [17],
                        "distance": 1125,
                        "length": 26,
                        "crossTime": 13,
                        "crossTimeWithoutRealTime": 13,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 270214555,
                            "segment_direction": True,
                        },
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 374280935,
                            "nodeId": 292979045,
                            "x": 8.222142849960445,
                            "y": 50.06672437322747,
                            "direction": True,
                        },
                        "street": 18,
                        "altStreets": [17],
                        "distance": 1138,
                        "length": 34,
                        "crossTime": 17,
                        "crossTimeWithoutRealTime": 17,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 270214555,
                            "segment_direction": True,
                        },
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 374279481,
                            "nodeId": 292978809,
                            "x": 8.222460125349738,
                            "y": 50.066947921874515,
                            "direction": True,
                        },
                        "street": 18,
                        "altStreets": [17],
                        "distance": 1155,
                        "length": 51,
                        "crossTime": 26,
                        "crossTimeWithoutRealTime": 26,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [
                                        {"angle": -90, "selected": False},
                                        {"angle": -180, "selected": False},
                                    ],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 3,
                                    "angle_object": [{"angle": 90, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 270214555,
                            "segment_direction": True,
                        },
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 2,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 72864858,
                            "nodeId": 288859055,
                            "x": 8.222934486122151,
                            "y": 50.067284829515415,
                            "direction": True,
                        },
                        "street": 18,
                        "altStreets": [17],
                        "distance": 1181,
                        "length": 80,
                        "crossTime": 8,
                        "crossTimeWithoutRealTime": 8,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 415927469,
                            "nodeId": 79359832,
                            "x": 8.223689385641402,
                            "y": 50.067819944972506,
                            "direction": True,
                        },
                        "street": 18,
                        "altStreets": [17],
                        "distance": 1189,
                        "length": 17,
                        "crossTime": 3,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 415927471,
                            "nodeId": 207623192,
                            "x": 8.223850197214025,
                            "y": 50.06793209840469,
                            "direction": True,
                        },
                        "street": 18,
                        "altStreets": [17],
                        "distance": 1192,
                        "length": 30,
                        "crossTime": 3,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 415927472,
                            "nodeId": 320276440,
                            "x": 8.22413450065365,
                            "y": 50.068131875083466,
                            "direction": True,
                        },
                        "street": 18,
                        "altStreets": [17],
                        "distance": 1195,
                        "length": 37,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 416412684,
                            "nodeId": 211990431,
                            "x": 8.224483653903016,
                            "y": 50.06837721982127,
                            "direction": True,
                        },
                        "street": 18,
                        "altStreets": [17],
                        "distance": 1199,
                        "length": 123,
                        "crossTime": 12,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 415927598,
                            "nodeId": 307071774,
                            "x": 8.22563890739817,
                            "y": 50.06919046065067,
                            "direction": True,
                        },
                        "street": 18,
                        "altStreets": [17],
                        "distance": 1211,
                        "length": 69,
                        "crossTime": 10,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [
                                        {"angle": -90, "selected": False},
                                        {"angle": -180, "selected": False},
                                    ],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 2,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 415927599,
                            "nodeId": 320276522,
                            "x": 8.226262345467662,
                            "y": 50.06966651621979,
                            "direction": True,
                        },
                        "street": 18,
                        "altStreets": [17],
                        "distance": 1221,
                        "length": 62,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 7,
                        "crossTimeFreeFlow": 6,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 415927594,
                            "nodeId": 320276520,
                            "x": 8.226812215212771,
                            "y": 50.07009700279809,
                            "direction": True,
                        },
                        "street": 18,
                        "altStreets": [17],
                        "distance": 1228,
                        "length": 11,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 415927595,
                            "nodeId": 320276521,
                            "x": 8.226910519633872,
                            "y": 50.07016850474712,
                            "direction": True,
                        },
                        "street": 18,
                        "altStreets": [17],
                        "distance": 1230,
                        "length": 59,
                        "crossTime": 13,
                        "crossTimeWithoutRealTime": 13,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [
                                        {"angle": -90, "selected": False},
                                        {"angle": -180, "selected": False},
                                    ],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": -90, "selected": False}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 3,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 4,
                                    "angle_object": [{"angle": 90, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 2,
                                    "to_lane_index": 3,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 377952485,
                            "nodeId": 320276445,
                            "x": 8.227414230058935,
                            "y": 50.07058959000111,
                            "direction": True,
                        },
                        "street": 18,
                        "altStreets": [17],
                        "distance": 1243,
                        "length": 83,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 270214173,
                            "nodeId": 171704490,
                            "x": 8.22807222780158,
                            "y": 50.07119903261557,
                            "direction": True,
                        },
                        "street": 18,
                        "altStreets": [17],
                        "distance": 1252,
                        "length": 150,
                        "crossTime": 18,
                        "crossTimeWithoutRealTime": 18,
                        "crossTimeFreeFlow": 12,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 415902118,
                            "nodeId": 79361387,
                            "x": 8.2292658388955,
                            "y": 50.07230759068745,
                            "direction": True,
                        },
                        "street": 18,
                        "altStreets": [17],
                        "distance": 1270,
                        "length": 106,
                        "crossTime": 15,
                        "crossTimeWithoutRealTime": 15,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 415901538,
                            "nodeId": 79359839,
                            "x": 8.230133204715196,
                            "y": 50.07307646972054,
                            "direction": True,
                        },
                        "street": 18,
                        "altStreets": [17],
                        "distance": 1285,
                        "length": 169,
                        "crossTime": 37,
                        "crossTimeWithoutRealTime": 37,
                        "crossTimeFreeFlow": 15,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -90, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": -90, "selected": False}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 3,
                                    "angle_object": [{"angle": 90, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": True,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "CONTINUE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 415901561,
                            "nodeId": 79358629,
                            "x": 8.231541216373333,
                            "y": 50.07429067972235,
                            "direction": False,
                        },
                        "street": 19,
                        "distance": 1322,
                        "length": 12,
                        "crossTime": 3,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 415901538,
                            "segment_direction": True,
                        },
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 415901560,
                            "nodeId": 320259754,
                            "x": 8.231642853216755,
                            "y": 50.074372906418596,
                            "direction": False,
                        },
                        "street": 19,
                        "distance": 1325,
                        "length": 12,
                        "crossTime": 3,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 415901538,
                            "segment_direction": True,
                        },
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72864327,
                            "nodeId": 79358627,
                            "x": 8.23173768818361,
                            "y": 50.0744589487339,
                            "direction": True,
                        },
                        "street": 20,
                        "altStreets": [17],
                        "distance": 1328,
                        "length": 80,
                        "crossTime": 11,
                        "crossTimeWithoutRealTime": 11,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 407118357,
                            "nodeId": 320260522,
                            "x": 8.232343690845257,
                            "y": 50.07505820018802,
                            "direction": True,
                        },
                        "street": 20,
                        "altStreets": [17],
                        "distance": 1339,
                        "length": 94,
                        "crossTime": 16,
                        "crossTimeWithoutRealTime": 16,
                        "crossTimeFreeFlow": 11,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 409300617,
                            "nodeId": 314624504,
                            "x": 8.233111572083141,
                            "y": 50.07573609631465,
                            "direction": False,
                        },
                        "street": 22,
                        "altStreets": [21],
                        "distance": 1355,
                        "length": 34,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 409300616,
                            "nodeId": 316085494,
                            "x": 8.233584081087796,
                            "y": 50.075763170353056,
                            "direction": False,
                        },
                        "street": 22,
                        "altStreets": [21],
                        "distance": 1360,
                        "length": 108,
                        "crossTime": 16,
                        "crossTimeWithoutRealTime": 16,
                        "crossTimeFreeFlow": 14,
                        "knownDirection": True,
                        "penalty": 5,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 378337880,
                            "nodeId": 295596898,
                            "x": 8.235089955364234,
                            "y": 50.07586511054219,
                            "direction": False,
                        },
                        "street": 22,
                        "altStreets": [21],
                        "distance": 1376,
                        "length": 32,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 378337875,
                            "nodeId": 295596895,
                            "x": 8.235338589760463,
                            "y": 50.07609134509815,
                            "direction": False,
                        },
                        "street": 24,
                        "altStreets": [23],
                        "distance": 1380,
                        "length": 64,
                        "crossTime": 10,
                        "crossTimeWithoutRealTime": 10,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72864320,
                            "nodeId": 79359704,
                            "x": 8.235251736745907,
                            "y": 50.07666816613729,
                            "direction": False,
                        },
                        "street": 24,
                        "altStreets": [23],
                        "distance": 1390,
                        "length": 81,
                        "crossTime": 30,
                        "crossTimeWithoutRealTime": 30,
                        "crossTimeFreeFlow": 11,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "TURN_RIGHT", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72864318,
                            "nodeId": 79359701,
                            "x": 8.235193053254092,
                            "y": 50.07739107760376,
                            "direction": False,
                        },
                        "street": 26,
                        "altStreets": [25],
                        "distance": 1420,
                        "length": 115,
                        "crossTime": 28,
                        "crossTimeWithoutRealTime": 28,
                        "crossTimeFreeFlow": 12,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [
                                        {"angle": 90, "selected": False},
                                        {"angle": 0, "selected": True},
                                    ],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 2,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 72864735,
                            "nodeId": 79359285,
                            "x": 8.236797139881135,
                            "y": 50.07747547541377,
                            "direction": False,
                        },
                        "street": 26,
                        "altStreets": [25],
                        "distance": 1448,
                        "length": 109,
                        "crossTime": 29,
                        "crossTimeWithoutRealTime": 29,
                        "crossTimeFreeFlow": 11,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [
                                        {"angle": 0, "selected": True},
                                        {"angle": -90, "selected": False},
                                        {"angle": -180, "selected": False},
                                    ],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 2,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 72864734,
                            "nodeId": 79360052,
                            "x": 8.238318793058424,
                            "y": 50.0775622730385,
                            "direction": False,
                        },
                        "street": 26,
                        "altStreets": [25],
                        "distance": 1477,
                        "length": 110,
                        "crossTime": 12,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 11,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 86291486,
                            "nodeId": 79359283,
                            "x": 8.239855418836061,
                            "y": 50.07762370762943,
                            "direction": False,
                        },
                        "street": 26,
                        "altStreets": [25],
                        "distance": 1489,
                        "length": 17,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 258967042,
                            "nodeId": 92813490,
                            "x": 8.240095034142405,
                            "y": 50.077633824965424,
                            "direction": True,
                        },
                        "street": 26,
                        "altStreets": [25],
                        "distance": 1491,
                        "length": 99,
                        "crossTime": 12,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 258967043,
                            "nodeId": 217863801,
                            "x": 8.241469636926308,
                            "y": 50.07772100669905,
                            "direction": True,
                        },
                        "street": 26,
                        "altStreets": [25],
                        "distance": 1503,
                        "length": 67,
                        "crossTime": 11,
                        "crossTimeWithoutRealTime": 11,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [
                                        {"angle": -90, "selected": False},
                                        {"angle": -180, "selected": False},
                                    ],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 3,
                                    "angle_object": [
                                        {"angle": 0, "selected": True},
                                        {"angle": 90, "selected": False},
                                    ],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 3,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 205226835,
                            "nodeId": 79360100,
                            "x": 8.242403912209015,
                            "y": 50.077765884307716,
                            "direction": True,
                        },
                        "street": 26,
                        "altStreets": [25],
                        "distance": 1514,
                        "length": 66,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 7,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 409751229,
                            "nodeId": 79359727,
                            "x": 8.243328173591273,
                            "y": 50.07782116573763,
                            "direction": True,
                        },
                        "street": 26,
                        "altStreets": [25],
                        "distance": 1521,
                        "length": 50,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 409751230,
                            "nodeId": 316335320,
                            "x": 8.244019452489036,
                            "y": 50.07786177053813,
                            "direction": True,
                        },
                        "street": 26,
                        "altStreets": [25],
                        "distance": 1526,
                        "length": 80,
                        "crossTime": 20,
                        "crossTimeWithoutRealTime": 20,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 408946983,
                            "nodeId": 79362631,
                            "x": 8.24513598246734,
                            "y": 50.077932189354556,
                            "direction": True,
                        },
                        "street": 27,
                        "distance": 1546,
                        "length": 11,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 6,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -90, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": False}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 90, "selected": False}],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "TURN_LEFT", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 408947079,
                            "nodeId": 315848893,
                            "x": 8.245287279691647,
                            "y": 50.077965291097755,
                            "direction": True,
                        },
                        "street": 27,
                        "distance": 1550,
                        "length": 22,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 408947080,
                            "nodeId": 315848979,
                            "x": 8.245279289684236,
                            "y": 50.07815929784913,
                            "direction": True,
                        },
                        "street": 27,
                        "distance": 1554,
                        "length": 67,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 408947076,
                            "nodeId": 315848977,
                            "x": 8.245149481203464,
                            "y": 50.0787555733245,
                            "direction": False,
                        },
                        "street": 27,
                        "distance": 1563,
                        "length": 69,
                        "crossTime": 24,
                        "crossTimeWithoutRealTime": 24,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -90, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [
                                        {"angle": 0, "selected": True},
                                        {"angle": 90, "selected": False},
                                    ],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 2,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 72864308,
                            "nodeId": 79359690,
                            "x": 8.245066524299165,
                            "y": 50.079377375536126,
                            "direction": False,
                        },
                        "street": 27,
                        "distance": 1587,
                        "length": 141,
                        "crossTime": 14,
                        "crossTimeWithoutRealTime": 14,
                        "crossTimeFreeFlow": 12,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 252683328,
                            "nodeId": 79359691,
                            "x": 8.244898982090154,
                            "y": 50.08064331957838,
                            "direction": False,
                        },
                        "street": 27,
                        "distance": 1601,
                        "length": 264,
                        "crossTime": 37,
                        "crossTimeWithoutRealTime": 37,
                        "crossTimeFreeFlow": 23,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 265980164,
                            "nodeId": 79361994,
                            "x": 8.244659504299173,
                            "y": 50.083009701140945,
                            "direction": True,
                        },
                        "street": 27,
                        "distance": 1638,
                        "length": 80,
                        "crossTime": 10,
                        "crossTimeWithoutRealTime": 10,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -90, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 2,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 265122151,
                            "nodeId": 221841730,
                            "x": 8.244592721561833,
                            "y": 50.08372858948899,
                            "direction": False,
                        },
                        "street": 27,
                        "distance": 1648,
                        "length": 59,
                        "crossTime": 12,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [
                                        {"angle": 0, "selected": False},
                                        {"angle": 90, "selected": True},
                                    ],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "TURN_RIGHT",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 1,
                                },
                                "angle": 90,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 298682381,
                            "nodeId": 87633896,
                            "x": 8.244525744314858,
                            "y": 50.084258866042525,
                            "direction": True,
                        },
                        "street": 28,
                        "distance": 1660,
                        "length": 190,
                        "crossTime": 43,
                        "crossTimeWithoutRealTime": 43,
                        "crossTimeFreeFlow": 28,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 298682382,
                            "nodeId": 230308637,
                            "x": 8.247080147906408,
                            "y": 50.084263068331595,
                            "direction": True,
                        },
                        "street": 28,
                        "distance": 1703,
                        "length": 8,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 270634255,
                            "nodeId": 226350620,
                            "x": 8.24713901617515,
                            "y": 50.08420523720755,
                            "direction": True,
                        },
                        "street": 28,
                        "distance": 1705,
                        "length": 24,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 9,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "TURN_LEFT", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 270634256,
                            "nodeId": 213790660,
                            "x": 8.247291101809203,
                            "y": 50.08401103171967,
                            "direction": True,
                        },
                        "street": 19,
                        "distance": 1710,
                        "length": 12,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "APPROACHING_DESTINATION", "arg": 0},
                    },
                ],
                "streetNames": [
                    "Kaiserstraße",
                    "B40 - Kaiserstraße",
                    "Boppstraße",
                    "L424 - Boppstraße",
                    "Kaiser-Wilhelm-Ring",
                    "L424 - Kaiser-Wilhelm-Ring",
                    "Barbarossaring",
                    "L424 - Barbarossaring",
                    "Kaiser-Karl-Ring",
                    "Rheinallee",
                    "K6 - Rheinallee",
                    "K17 - Rheinallee",
                    None,
                    None,
                    "A643 > Frankfurt / Wiesbaden",
                    "A643",
                    "A643",
                    "Schiersteiner Straße",
                    "B262 - Schiersteiner Straße",
                    None,
                    "K644 - Schiersteiner Straße",
                    "Adelheidstraße",
                    "K644 - Adelheidstraße",
                    "Karlstraße",
                    "K644 - Karlstraße",
                    "Rheinstraße",
                    "L3037 - Rheinstraße",
                    "Wilhelmstraße",
                    "Christian-Zais-Straße",
                ],
                "fromlocMetersFromGeom": 14.529273,
                "fromFraction": 0.7886346623377086,
                "toFraction": 0.4876577222349604,
                "sameFromSegment": True,
                "sameToSegment": True,
                "tollMeters": 0,
                "preferedRouteId": -1,
                "isInvalid": False,
                "isBlocked": False,
                "serverUniqueId": "m23130394891406600",
                "displayRoute": True,
                "astarVisited": 7237,
                "astarResult": "UNKNOWN",
                "isRestricted": False,
                "avoidStatus": "MAYBE",
                "passesThroughDangerArea": False,
                "distanceFromSource": 14,
                "distanceFromTarget": 39,
                "minPassengers": 0,
                "hovIndex": -1,
                "preRefinedRouteIndex": -1,
                "blockedRouteUid": -1,
                "alternativeRouteUuid": "a863ebe4-08db-47e9-975d-8f432ea07683",
                "serverTilesVersion": 1705557311000,
                "rankBeforeReordering": 2,
                "serverType": "LIVEMAP",
                "routeType": ["Natural"],
                "routeAttr": ["RestrictedZone"],
                "astarCost": 1199,
                "totalRouteTime": 1714,
                "totalRouteTimeWithoutRealtime": 1654,
                "totalRouteTimeFreeFlow": 992,
                "carbonEmissionsGrams": 0,
                "creationMechanismSet": ["BIDI", "OTHER_HEURISTIC"],
                "laneTypes": [],
                "areas": ["Umweltzone"],
                "requiredPermits": [],
                "etaHistograms": [],
                "shortRouteName": "A643",
                "tollPrice": 0.0,
                "isInvalidForPrivateVehicle": False,
                "costInfo": {
                    "unbiasedAstarCost": 1918,
                    "tollAsSeconds": 0,
                    "keepForReordering": False,
                },
                "destinationInformation": {
                    "segment_id": 270634256,
                    "street_id": 7744185,
                    "city_id": 27809,
                    "country_id": 81,
                    "city_name": "Wiesbaden",
                    "exit_node_id": 226350621,
                },
                "routeName": "A643",
                "routeNameStreetIds": [36220372],
                "totalRouteTimeWithoutMl": 1714,
                "open": False,
            },
            "coords": [
                {"x": 8.262374386769602, "y": 50.00345161027918, "z": "NaN"},
                {"x": 8.262231178841974, "y": 50.00350434288446, "z": "NaN"},
                {"x": 8.262231178841974, "y": 50.00350434288446, "z": "NaN"},
                {"x": 8.261405058465337, "y": 50.003853444538585, "z": "NaN"},
                {"x": 8.261405058465337, "y": 50.003853444538585, "z": "NaN"},
                {"x": 8.261106662712432, "y": 50.0039745520515, "z": "NaN"},
                {"x": 8.261106662712432, "y": 50.0039745520515, "z": "NaN"},
                {"x": 8.26076937492879, "y": 50.00411893249527, "z": "NaN"},
                {"x": 8.26076937492879, "y": 50.00411893249527, "z": "NaN"},
                {"x": 8.259711914024582, "y": 50.00454517551499, "z": "NaN"},
                {"x": 8.259711914024582, "y": 50.00454517551499, "z": "NaN"},
                {"x": 8.25887037094613, "y": 50.00488651199142, "z": "NaN"},
                {"x": 8.25887037094613, "y": 50.00488651199142, "z": "NaN"},
                {"x": 8.25858549, "y": 50.00500608, "z": "NaN"},
                {"x": 8.25858549, "y": 50.00500608, "z": "NaN"},
                {"x": 8.257875941953877, "y": 50.00528990652044, "z": "NaN"},
                {"x": 8.257875941953877, "y": 50.00528990652042, "z": "NaN"},
                {"x": 8.256777577362033, "y": 50.00574975491552, "z": "NaN"},
                {"x": 8.256777577362033, "y": 50.00574975491552, "z": "NaN"},
                {"x": 8.255772419533788, "y": 50.006143229946865, "z": "NaN"},
                {"x": 8.255772419533788, "y": 50.006143229946886, "z": "NaN"},
                {"x": 8.255221225581261, "y": 50.00636474678355, "z": "NaN"},
                {"x": 8.255221225581261, "y": 50.00636474678355, "z": "NaN"},
                {"x": 8.254931547007622, "y": 50.00654833778641, "z": "NaN"},
                {"x": 8.254931547007622, "y": 50.00654833778641, "z": "NaN"},
                {"x": 8.253787584862806, "y": 50.00748093476955, "z": "NaN"},
                {"x": 8.253787584862806, "y": 50.00748093476955, "z": "NaN"},
                {"x": 8.253045954070139, "y": 50.00812219243653, "z": "NaN"},
                {"x": 8.253045954070139, "y": 50.00812219243653, "z": "NaN"},
                {"x": 8.252052866182382, "y": 50.00903321180373, "z": "NaN"},
                {"x": 8.252052866182382, "y": 50.00903321180373, "z": "NaN"},
                {"x": 8.251915911180072, "y": 50.00914479017255, "z": "NaN"},
                {"x": 8.251915911180072, "y": 50.00914479017255, "z": "NaN"},
                {"x": 8.25014053, "y": 50.01064199999999, "z": "NaN"},
                {"x": 8.25014053, "y": 50.010642, "z": "NaN"},
                {"x": 8.2495161454498, "y": 50.011245441565, "z": "NaN"},
                {"x": 8.2495161454498, "y": 50.01124544156499, "z": "NaN"},
                {"x": 8.24928926, "y": 50.01152167, "z": "NaN"},
                {"x": 8.24909656614973, "y": 50.01181459981645, "z": "NaN"},
                {"x": 8.24900470049095, "y": 50.01205505076115, "z": "NaN"},
                {"x": 8.24897989005755, "y": 50.01230153327666, "z": "NaN"},
                {"x": 8.248990618893608, "y": 50.01257042185178, "z": "NaN"},
                {"x": 8.248990618893608, "y": 50.01257042185178, "z": "NaN"},
                {"x": 8.249046945282945, "y": 50.012781567274644, "z": "NaN"},
                {"x": 8.249559193907851, "y": 50.01373440777294, "z": "NaN"},
                {"x": 8.249559193907851, "y": 50.01373440777294, "z": "NaN"},
                {"x": 8.250746771401674, "y": 50.01494282644239, "z": "NaN"},
                {"x": 8.250746771401674, "y": 50.01494282644239, "z": "NaN"},
                {"x": 8.251000436699046, "y": 50.01511158003646, "z": "NaN"},
                {"x": 8.252098997836136, "y": 50.015745687310805, "z": "NaN"},
                {"x": 8.252098997836136, "y": 50.015745687310805, "z": "NaN"},
                {"x": 8.252305123432388, "y": 50.01582494994901, "z": "NaN"},
                {"x": 8.252305123432388, "y": 50.01582494994901, "z": "NaN"},
                {"x": 8.252445809802945, "y": 50.015901931451054, "z": "NaN"},
                {"x": 8.253119044265704, "y": 50.01643708155337, "z": "NaN"},
                {"x": 8.253119044265704, "y": 50.01643708155337, "z": "NaN"},
                {"x": 8.25293337395933, "y": 50.016552715386695, "z": "NaN"},
                {"x": 8.25293337395933, "y": 50.016552715386695, "z": "NaN"},
                {"x": 8.251707813441712, "y": 50.01718037115454, "z": "NaN"},
                {"x": 8.251707813441712, "y": 50.01718037115454, "z": "NaN"},
                {"x": 8.2497482112828, "y": 50.01819872062916, "z": "NaN"},
                {"x": 8.2497482112828, "y": 50.01819872062916, "z": "NaN"},
                {"x": 8.248313577790984, "y": 50.01892390588318, "z": "NaN"},
                {"x": 8.24700368, "y": 50.01948125000002, "z": "NaN"},
                {"x": 8.246541399941647, "y": 50.01966096951187, "z": "NaN"},
                {"x": 8.246541399941647, "y": 50.01966096951187, "z": "NaN"},
                {"x": 8.245400432815696, "y": 50.02012196764528, "z": "NaN"},
                {"x": 8.245400432815696, "y": 50.02012196764528, "z": "NaN"},
                {"x": 8.244862126122408, "y": 50.020365538347924, "z": "NaN"},
                {"x": 8.243462717903718, "y": 50.02091014197717, "z": "NaN"},
                {"x": 8.243462717903718, "y": 50.02091014197717, "z": "NaN"},
                {"x": 8.242655622167794, "y": 50.02120999773974, "z": "NaN"},
                {"x": 8.242655622167794, "y": 50.02120999773974, "z": "NaN"},
                {"x": 8.242190576621487, "y": 50.021382772659436, "z": "NaN"},
                {"x": 8.242190576621487, "y": 50.021382772659436, "z": "NaN"},
                {"x": 8.241327962040168, "y": 50.02169609336127, "z": "NaN"},
                {"x": 8.241327962040168, "y": 50.02169609336127, "z": "NaN"},
                {"x": 8.239959297842791, "y": 50.02218317258784, "z": "NaN"},
                {"x": 8.239959297842791, "y": 50.02218317258784, "z": "NaN"},
                {"x": 8.23934324536893, "y": 50.02239945344938, "z": "NaN"},
                {"x": 8.23934324536893, "y": 50.02239945344938, "z": "NaN"},
                {"x": 8.237194538095363, "y": 50.02313966241233, "z": "NaN"},
                {"x": 8.236558596706194, "y": 50.023308604431385, "z": "NaN"},
                {"x": 8.236558596706194, "y": 50.023308604431385, "z": "NaN"},
                {"x": 8.235590749858485, "y": 50.02359538567201, "z": "NaN"},
                {"x": 8.235590749858485, "y": 50.02359538567201, "z": "NaN"},
                {"x": 8.234997981666178, "y": 50.02377804923328, "z": "NaN"},
                {"x": 8.234997981666178, "y": 50.02377804923328, "z": "NaN"},
                {"x": 8.234841801485837, "y": 50.02390960160955, "z": "NaN"},
                {"x": 8.234841801485837, "y": 50.02390960160955, "z": "NaN"},
                {"x": 8.232382886371434, "y": 50.02471994516111, "z": "NaN"},
                {"x": 8.232382886371434, "y": 50.02471994516111, "z": "NaN"},
                {"x": 8.232224775810002, "y": 50.02475685510192, "z": "NaN"},
                {"x": 8.231736473998803, "y": 50.02490475844311, "z": "NaN"},
                {"x": 8.231205895098276, "y": 50.025020737914836, "z": "NaN"},
                {"x": 8.231205895098276, "y": 50.025020737914836, "z": "NaN"},
                {"x": 8.223907135510688, "y": 50.027428038992305, "z": "NaN"},
                {"x": 8.223907135510688, "y": 50.027428038992305, "z": "NaN"},
                {"x": 8.221945055140937, "y": 50.02807753575487, "z": "NaN"},
                {"x": 8.221945055140937, "y": 50.02807753575487, "z": "NaN"},
                {"x": 8.22180648047111, "y": 50.02813870423456, "z": "NaN"},
                {"x": 8.221586654155239, "y": 50.028213442358286, "z": "NaN"},
                {"x": 8.221450114063913, "y": 50.02828503234596, "z": "NaN"},
                {"x": 8.221326594704127, "y": 50.02838294945588, "z": "NaN"},
                {"x": 8.221326594704127, "y": 50.02838294945588, "z": "NaN"},
                {"x": 8.221259803702997, "y": 50.02845497850985, "z": "NaN"},
                {"x": 8.22116674867733, "y": 50.028510107117576, "z": "NaN"},
                {"x": 8.221054918188555, "y": 50.0285505895977, "z": "NaN"},
                {"x": 8.220914474087069, "y": 50.02856914784092, "z": "NaN"},
                {"x": 8.220772658073832, "y": 50.02857279231876, "z": "NaN"},
                {"x": 8.220772658073832, "y": 50.02857279231876, "z": "NaN"},
                {"x": 8.220464490614058, "y": 50.028584936399255, "z": "NaN"},
                {"x": 8.220268689356024, "y": 50.0286142285022, "z": "NaN"},
                {"x": 8.218761335378296, "y": 50.02910073477668, "z": "NaN"},
                {"x": 8.218761335378296, "y": 50.02910073477668, "z": "NaN"},
                {"x": 8.217466587219223, "y": 50.029520785332465, "z": "NaN"},
                {"x": 8.216970378551444, "y": 50.02966724281598, "z": "NaN"},
                {"x": 8.21643661895754, "y": 50.02975511709165, "z": "NaN"},
                {"x": 8.215967232379914, "y": 50.029789577547966, "z": "NaN"},
                {"x": 8.215390421710076, "y": 50.02978826713412, "z": "NaN"},
                {"x": 8.214824014838385, "y": 50.02973838666199, "z": "NaN"},
                {"x": 8.213281861520526, "y": 50.029388807105384, "z": "NaN"},
                {"x": 8.213011681852414, "y": 50.02935898587837, "z": "NaN"},
                {"x": 8.212778982090153, "y": 50.029361521551664, "z": "NaN"},
                {"x": 8.212491377102499, "y": 50.029422623999814, "z": "NaN"},
                {"x": 8.212261610807344, "y": 50.029508879424725, "z": "NaN"},
                {"x": 8.212093875225381, "y": 50.029617695775045, "z": "NaN"},
                {"x": 8.211945442090151, "y": 50.02976886999999, "z": "NaN"},
                {"x": 8.211854256240995, "y": 50.0299030532137, "z": "NaN"},
                {"x": 8.211751358266435, "y": 50.030146468892646, "z": "NaN"},
                {"x": 8.211691254839037, "y": 50.03043458162623, "z": "NaN"},
                {"x": 8.211691254839037, "y": 50.03043458162623, "z": "NaN"},
                {"x": 8.211725202938748, "y": 50.03082346533931, "z": "NaN"},
                {"x": 8.211725202938748, "y": 50.03082346533934, "z": "NaN"},
                {"x": 8.211992269022183, "y": 50.03321278645702, "z": "NaN"},
                {"x": 8.211992269022183, "y": 50.03321278645702, "z": "NaN"},
                {"x": 8.212418515929832, "y": 50.03716254330283, "z": "NaN"},
                {"x": 8.212418515929832, "y": 50.03716254330283, "z": "NaN"},
                {"x": 8.212833382040218, "y": 50.0408687665798, "z": "NaN"},
                {"x": 8.212833382040218, "y": 50.0408687665798, "z": "NaN"},
                {"x": 8.21289104218487, "y": 50.04138385318259, "z": "NaN"},
                {"x": 8.21289104218487, "y": 50.04138385318259, "z": "NaN"},
                {"x": 8.212913107744475, "y": 50.04240001029987, "z": "NaN"},
                {"x": 8.212869226942612, "y": 50.04295633826568, "z": "NaN"},
                {"x": 8.21294146343018, "y": 50.043789733488595, "z": "NaN"},
                {"x": 8.213261996983642, "y": 50.04601206416771, "z": "NaN"},
                {"x": 8.213261996983642, "y": 50.04601206416771, "z": "NaN"},
                {"x": 8.2133172750471, "y": 50.047607982192, "z": "NaN"},
                {"x": 8.213118670395547, "y": 50.04965954786453, "z": "NaN"},
                {"x": 8.213118670395547, "y": 50.04965954786453, "z": "NaN"},
                {"x": 8.212844297609562, "y": 50.05245521157355, "z": "NaN"},
                {"x": 8.212844297609562, "y": 50.05245521157355, "z": "NaN"},
                {"x": 8.2127989478662, "y": 50.052849629878864, "z": "NaN"},
                {"x": 8.2127989478662, "y": 50.052849629878864, "z": "NaN"},
                {"x": 8.212651947503948, "y": 50.053995331819394, "z": "NaN"},
                {"x": 8.212486576545613, "y": 50.055529247397, "z": "NaN"},
                {"x": 8.212486576545613, "y": 50.055529247397, "z": "NaN"},
                {"x": 8.212415945463103, "y": 50.056181375244876, "z": "NaN"},
                {"x": 8.212423374418032, "y": 50.05666920885921, "z": "NaN"},
                {"x": 8.212492140639743, "y": 50.05725464497221, "z": "NaN"},
                {"x": 8.21258772895161, "y": 50.05769198036888, "z": "NaN"},
                {"x": 8.212676241849106, "y": 50.05798988906827, "z": "NaN"},
                {"x": 8.212828389846408, "y": 50.05839836795877, "z": "NaN"},
                {"x": 8.212965920422755, "y": 50.058672661276255, "z": "NaN"},
                {"x": 8.213137468602415, "y": 50.05897243274258, "z": "NaN"},
                {"x": 8.213315701426009, "y": 50.05920981296193, "z": "NaN"},
                {"x": 8.213524653448738, "y": 50.059488842427974, "z": "NaN"},
                {"x": 8.213796225968, "y": 50.059807828617004, "z": "NaN"},
                {"x": 8.213796225968, "y": 50.059807828617004, "z": "NaN"},
                {"x": 8.214036121819651, "y": 50.06005797881144, "z": "NaN"},
                {"x": 8.214398220036683, "y": 50.06040925247503, "z": "NaN"},
                {"x": 8.214784458134867, "y": 50.06075363592249, "z": "NaN"},
                {"x": 8.215564980958206, "y": 50.06141312332489, "z": "NaN"},
                {"x": 8.218072891322226, "y": 50.06339565366394, "z": "NaN"},
                {"x": 8.218072891322226, "y": 50.06339565366394, "z": "NaN"},
                {"x": 8.219297465938563, "y": 50.06439932330405, "z": "NaN"},
                {"x": 8.219601497728076, "y": 50.0646597292308, "z": "NaN"},
                {"x": 8.219601497728076, "y": 50.0646597292308, "z": "NaN"},
                {"x": 8.220131118137546, "y": 50.06515133536746, "z": "NaN"},
                {"x": 8.220131118137546, "y": 50.06515133536746, "z": "NaN"},
                {"x": 8.220681632081131, "y": 50.06565164621677, "z": "NaN"},
                {"x": 8.221017569303536, "y": 50.06593415411581, "z": "NaN"},
                {"x": 8.221017569303536, "y": 50.06593415411581, "z": "NaN"},
                {"x": 8.221741981680447, "y": 50.06647238360936, "z": "NaN"},
                {"x": 8.22188258171079, "y": 50.06655827540674, "z": "NaN"},
                {"x": 8.22188258171079, "y": 50.06655827540674, "z": "NaN"},
                {"x": 8.222142849960445, "y": 50.06672437322747, "z": "NaN"},
                {"x": 8.222142849960445, "y": 50.06672437322747, "z": "NaN"},
                {"x": 8.222460125349738, "y": 50.066947921874515, "z": "NaN"},
                {"x": 8.222460125349738, "y": 50.066947921874515, "z": "NaN"},
                {"x": 8.222934486122151, "y": 50.067284829515415, "z": "NaN"},
                {"x": 8.222934486122151, "y": 50.067284829515415, "z": "NaN"},
                {"x": 8.223689385641402, "y": 50.067819944972506, "z": "NaN"},
                {"x": 8.223689385641402, "y": 50.067819944972506, "z": "NaN"},
                {"x": 8.223850197214025, "y": 50.06793209840469, "z": "NaN"},
                {"x": 8.223850197214025, "y": 50.06793209840469, "z": "NaN"},
                {"x": 8.22413450065365, "y": 50.068131875083466, "z": "NaN"},
                {"x": 8.22413450065365, "y": 50.068131875083466, "z": "NaN"},
                {"x": 8.224483653903016, "y": 50.06837721982127, "z": "NaN"},
                {"x": 8.224483653903016, "y": 50.06837721982127, "z": "NaN"},
                {"x": 8.22563890739817, "y": 50.06919046065067, "z": "NaN"},
                {"x": 8.22563890739817, "y": 50.06919046065067, "z": "NaN"},
                {"x": 8.226262345467662, "y": 50.06966651621979, "z": "NaN"},
                {"x": 8.226262345467662, "y": 50.06966651621979, "z": "NaN"},
                {"x": 8.226812215212771, "y": 50.07009700279809, "z": "NaN"},
                {"x": 8.226812215212771, "y": 50.07009700279809, "z": "NaN"},
                {"x": 8.226910519633872, "y": 50.07016850474712, "z": "NaN"},
                {"x": 8.226910519633872, "y": 50.07016850474712, "z": "NaN"},
                {"x": 8.227276806490979, "y": 50.07046702032975, "z": "NaN"},
                {"x": 8.227414230058935, "y": 50.07058959000109, "z": "NaN"},
                {"x": 8.227414230058935, "y": 50.07058959000109, "z": "NaN"},
                {"x": 8.22807222780158, "y": 50.07119903261557, "z": "NaN"},
                {"x": 8.22807222780158, "y": 50.07119903261557, "z": "NaN"},
                {"x": 8.2292658388955, "y": 50.07230759068745, "z": "NaN"},
                {"x": 8.2292658388955, "y": 50.07230759068745, "z": "NaN"},
                {"x": 8.230133204715196, "y": 50.07307646972054, "z": "NaN"},
                {"x": 8.230133204715196, "y": 50.07307646972054, "z": "NaN"},
                {"x": 8.231541216373333, "y": 50.07429067972238, "z": "NaN"},
                {"x": 8.231541216373333, "y": 50.07429067972238, "z": "NaN"},
                {"x": 8.231642853216755, "y": 50.074372906418596, "z": "NaN"},
                {"x": 8.231642853216755, "y": 50.074372906418596, "z": "NaN"},
                {"x": 8.23173768818361, "y": 50.0744589487339, "z": "NaN"},
                {"x": 8.23173768818361, "y": 50.07445894873393, "z": "NaN"},
                {"x": 8.232343690845257, "y": 50.07505820018802, "z": "NaN"},
                {"x": 8.232343690845257, "y": 50.07505820018802, "z": "NaN"},
                {"x": 8.232791543581612, "y": 50.07550755836257, "z": "NaN"},
                {"x": 8.232943758943277, "y": 50.07564311695911, "z": "NaN"},
                {"x": 8.233030930736241, "y": 50.07569863132171, "z": "NaN"},
                {"x": 8.233111572083141, "y": 50.07573609631465, "z": "NaN"},
                {"x": 8.233111572083141, "y": 50.07573609631465, "z": "NaN"},
                {"x": 8.233584081087796, "y": 50.075763170353056, "z": "NaN"},
                {"x": 8.233584081087796, "y": 50.075763170353056, "z": "NaN"},
                {"x": 8.234904056866888, "y": 50.0758405822, "z": "NaN"},
                {"x": 8.235089955364234, "y": 50.07586511054219, "z": "NaN"},
                {"x": 8.235089955364234, "y": 50.07586511054219, "z": "NaN"},
                {"x": 8.235193688203042, "y": 50.07590854385937, "z": "NaN"},
                {"x": 8.235292056623797, "y": 50.0759881257987, "z": "NaN"},
                {"x": 8.235338589760463, "y": 50.07609134509815, "z": "NaN"},
                {"x": 8.235338589760463, "y": 50.07609134509815, "z": "NaN"},
                {"x": 8.235251736745907, "y": 50.07666816613729, "z": "NaN"},
                {"x": 8.235251736745907, "y": 50.07666816613729, "z": "NaN"},
                {"x": 8.235193053254092, "y": 50.07739107760376, "z": "NaN"},
                {"x": 8.235193053254092, "y": 50.07739107760376, "z": "NaN"},
                {"x": 8.236797139881135, "y": 50.07747547541377, "z": "NaN"},
                {"x": 8.236797139881135, "y": 50.07747547541377, "z": "NaN"},
                {"x": 8.238318793058424, "y": 50.0775622730385, "z": "NaN"},
                {"x": 8.238318793058424, "y": 50.0775622730385, "z": "NaN"},
                {"x": 8.239855418836061, "y": 50.07762370762943, "z": "NaN"},
                {"x": 8.239855418836061, "y": 50.07762370762943, "z": "NaN"},
                {"x": 8.240095034142405, "y": 50.077633824965424, "z": "NaN"},
                {"x": 8.240095034142405, "y": 50.077633824965424, "z": "NaN"},
                {"x": 8.241469636926308, "y": 50.07772100669905, "z": "NaN"},
                {"x": 8.241469636926308, "y": 50.07772100669905, "z": "NaN"},
                {"x": 8.242403912209015, "y": 50.077765884307716, "z": "NaN"},
                {"x": 8.242403912209015, "y": 50.077765884307716, "z": "NaN"},
                {"x": 8.243328173591273, "y": 50.07782116573763, "z": "NaN"},
                {"x": 8.243328173591273, "y": 50.07782116573766, "z": "NaN"},
                {"x": 8.244019452489036, "y": 50.07786177053813, "z": "NaN"},
                {"x": 8.244019452489036, "y": 50.07786177053813, "z": "NaN"},
                {"x": 8.24513598246734, "y": 50.077932189354556, "z": "NaN"},
                {"x": 8.24513598246734, "y": 50.077932189354556, "z": "NaN"},
                {"x": 8.245287279691647, "y": 50.077965291097755, "z": "NaN"},
                {"x": 8.245287279691647, "y": 50.077965291097755, "z": "NaN"},
                {"x": 8.245279289684236, "y": 50.07815929784913, "z": "NaN"},
                {"x": 8.245279289684236, "y": 50.07815929784913, "z": "NaN"},
                {"x": 8.245149481203464, "y": 50.0787555733245, "z": "NaN"},
                {"x": 8.245149481203464, "y": 50.0787555733245, "z": "NaN"},
                {"x": 8.245066524299165, "y": 50.079377375536126, "z": "NaN"},
                {"x": 8.245066524299165, "y": 50.079377375536126, "z": "NaN"},
                {"x": 8.244898982090154, "y": 50.08064331957836, "z": "NaN"},
                {"x": 8.244898982090154, "y": 50.08064331957836, "z": "NaN"},
                {"x": 8.244829059771991, "y": 50.081355750883446, "z": "NaN"},
                {"x": 8.244659504299173, "y": 50.083009701140945, "z": "NaN"},
                {"x": 8.244659504299173, "y": 50.083009701140945, "z": "NaN"},
                {"x": 8.24465695833418, "y": 50.083181546484354, "z": "NaN"},
                {"x": 8.244592721561833, "y": 50.08372858948899, "z": "NaN"},
                {"x": 8.244592721561833, "y": 50.08372858948899, "z": "NaN"},
                {"x": 8.244525744314858, "y": 50.084258866042504, "z": "NaN"},
                {"x": 8.244525744314858, "y": 50.084258866042525, "z": "NaN"},
                {"x": 8.246953814025584, "y": 50.0843694444855, "z": "NaN"},
                {"x": 8.246999579216904, "y": 50.08436223753256, "z": "NaN"},
                {"x": 8.247032603915406, "y": 50.08433695940545, "z": "NaN"},
                {"x": 8.247080147906408, "y": 50.084263068331595, "z": "NaN"},
                {"x": 8.247080147906408, "y": 50.084263068331595, "z": "NaN"},
                {"x": 8.24713901617515, "y": 50.08420523720755, "z": "NaN"},
                {"x": 8.24713901617515, "y": 50.08420523720755, "z": "NaN"},
                {"x": 8.247291101809203, "y": 50.0840110317197, "z": "NaN"},
                {"x": 8.247291101809203, "y": 50.0840110317197, "z": "NaN"},
                {"x": 8.247286829865775, "y": 50.08411891532466, "z": "NaN"},
            ],
        },
        {
            "response": {
                "results": [
                    {
                        "path": {
                            "segmentId": 72856060,
                            "nodeId": 79353354,
                            "x": 8.262231178841974,
                            "y": 50.00350434288446,
                            "direction": False,
                        },
                        "street": 1,
                        "altStreets": [0],
                        "distance": 0,
                        "length": 42,
                        "crossTime": 52,
                        "crossTimeWithoutRealTime": 52,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 4,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "TURN_LEFT", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857068,
                            "nodeId": 79353353,
                            "x": 8.262884296737077,
                            "y": 50.003263849158074,
                            "direction": True,
                        },
                        "street": 1,
                        "altStreets": [0],
                        "distance": 52,
                        "length": 83,
                        "crossTime": 10,
                        "crossTimeWithoutRealTime": 10,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858741,
                            "nodeId": 79354848,
                            "x": 8.263474564170831,
                            "y": 50.00389912419096,
                            "direction": True,
                        },
                        "street": 1,
                        "altStreets": [0],
                        "distance": 62,
                        "length": 110,
                        "crossTime": 13,
                        "crossTimeWithoutRealTime": 13,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858742,
                            "nodeId": 79354852,
                            "x": 8.264312573037357,
                            "y": 50.004726618565144,
                            "direction": True,
                        },
                        "street": 1,
                        "altStreets": [0],
                        "distance": 75,
                        "length": 126,
                        "crossTime": 26,
                        "crossTimeWithoutRealTime": 26,
                        "crossTimeFreeFlow": 11,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [
                                        {"angle": -90, "selected": False},
                                        {"angle": 0, "selected": True},
                                        {"angle": -180, "selected": False},
                                    ],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [
                                        {"angle": 0, "selected": True},
                                        {"angle": 90, "selected": False},
                                    ],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 2,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 72858739,
                            "nodeId": 79354745,
                            "x": 8.265242629013304,
                            "y": 50.00568941892085,
                            "direction": True,
                        },
                        "street": 1,
                        "altStreets": [0],
                        "distance": 101,
                        "length": 104,
                        "crossTime": 12,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 4,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "TURN_RIGHT", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858752,
                            "nodeId": 79356564,
                            "x": 8.266104288659388,
                            "y": 50.00642271162488,
                            "direction": True,
                        },
                        "street": 2,
                        "distance": 113,
                        "length": 63,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858753,
                            "nodeId": 79354855,
                            "x": 8.266819097361882,
                            "y": 50.00609453058361,
                            "direction": True,
                        },
                        "street": 2,
                        "distance": 122,
                        "length": 55,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 7,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 246047547,
                            "nodeId": 79356559,
                            "x": 8.26742661770343,
                            "y": 50.005794575894285,
                            "direction": True,
                        },
                        "street": 2,
                        "distance": 129,
                        "length": 10,
                        "crossTime": 1,
                        "crossTimeWithoutRealTime": 1,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 436037939,
                            "nodeId": 209641384,
                            "x": 8.267532620513155,
                            "y": 50.005739026738965,
                            "direction": False,
                        },
                        "street": 2,
                        "distance": 130,
                        "length": 60,
                        "crossTime": 8,
                        "crossTimeWithoutRealTime": 8,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 436037938,
                            "nodeId": 333577572,
                            "x": 8.268170502719617,
                            "y": 50.00539613646547,
                            "direction": False,
                        },
                        "street": 2,
                        "distance": 138,
                        "length": 116,
                        "crossTime": 23,
                        "crossTimeWithoutRealTime": 23,
                        "crossTimeFreeFlow": 17,
                        "knownDirection": True,
                        "penalty": 7,
                        "roadType": 1,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "TURN_LEFT", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 370095308,
                            "nodeId": 79356560,
                            "x": 8.269412793478955,
                            "y": 50.00472834248692,
                            "direction": True,
                        },
                        "street": 3,
                        "distance": 161,
                        "length": 83,
                        "crossTime": 22,
                        "crossTimeWithoutRealTime": 22,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 370095309,
                            "nodeId": 290337089,
                            "x": 8.270124537611794,
                            "y": 50.00532038803219,
                            "direction": True,
                        },
                        "street": 3,
                        "distance": 183,
                        "length": 46,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 246495731,
                            "nodeId": 209928281,
                            "x": 8.270532223008138,
                            "y": 50.00564317452125,
                            "direction": True,
                        },
                        "street": 3,
                        "distance": 192,
                        "length": 31,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858761,
                            "nodeId": 79354839,
                            "x": 8.27080083664418,
                            "y": 50.00585835952036,
                            "direction": True,
                        },
                        "street": 3,
                        "distance": 199,
                        "length": 74,
                        "crossTime": 26,
                        "crossTimeWithoutRealTime": 26,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "TURN_RIGHT", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 162231268,
                            "nodeId": 162914110,
                            "x": 8.271637685856833,
                            "y": 50.00611392414356,
                            "direction": False,
                        },
                        "street": 5,
                        "altStreets": [4],
                        "distance": 225,
                        "length": 191,
                        "crossTime": 26,
                        "crossTimeWithoutRealTime": 26,
                        "crossTimeFreeFlow": 17,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 360439058,
                            "nodeId": 79354884,
                            "x": 8.273044504485089,
                            "y": 50.00466110951561,
                            "direction": False,
                        },
                        "street": 7,
                        "altStreets": [6],
                        "distance": 251,
                        "length": 137,
                        "crossTime": 17,
                        "crossTimeWithoutRealTime": 17,
                        "crossTimeFreeFlow": 12,
                        "knownDirection": True,
                        "penalty": 5,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -90, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": False}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [
                                        {"angle": 0, "selected": False},
                                        {"angle": 90, "selected": False},
                                    ],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "TURN_LEFT",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 0,
                                },
                                "angle": -45,
                                "angle_override": -90,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 399190430,
                            "nodeId": 284052144,
                            "x": 8.273971790530663,
                            "y": 50.00359047306348,
                            "direction": False,
                        },
                        "street": 7,
                        "altStreets": [6],
                        "distance": 268,
                        "length": 65,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 6,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 399190429,
                            "nodeId": 309295012,
                            "x": 8.27458476301202,
                            "y": 50.003390345561506,
                            "direction": False,
                        },
                        "street": 7,
                        "altStreets": [6],
                        "distance": 277,
                        "length": 37,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 392386961,
                            "nodeId": 79358204,
                            "x": 8.274416454396324,
                            "y": 50.003697642077995,
                            "direction": False,
                        },
                        "street": 7,
                        "altStreets": [6],
                        "distance": 282,
                        "length": 179,
                        "crossTime": 16,
                        "crossTimeWithoutRealTime": 16,
                        "crossTimeFreeFlow": 16,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 270261228,
                            "nodeId": 225111472,
                            "x": 8.27325020772032,
                            "y": 50.0050858175989,
                            "direction": False,
                        },
                        "street": 9,
                        "altStreets": [8],
                        "distance": 298,
                        "length": 36,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 239674002,
                            "nodeId": 79353332,
                            "x": 8.273584842682723,
                            "y": 50.00532475365378,
                            "direction": False,
                        },
                        "street": 9,
                        "altStreets": [8],
                        "distance": 302,
                        "length": 208,
                        "crossTime": 15,
                        "crossTimeWithoutRealTime": 15,
                        "crossTimeFreeFlow": 16,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 369081994,
                            "nodeId": 205584787,
                            "x": 8.276032753295809,
                            "y": 50.006327055101046,
                            "direction": False,
                        },
                        "street": 11,
                        "altStreets": [10],
                        "distance": 317,
                        "length": 309,
                        "crossTime": 40,
                        "crossTimeWithoutRealTime": 40,
                        "crossTimeFreeFlow": 22,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": False}],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "KEEP_LEFT",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 0,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 403833198,
                            "nodeId": 225111842,
                            "x": 8.27967572957318,
                            "y": 50.00781791594246,
                            "direction": True,
                        },
                        "street": 12,
                        "distance": 357,
                        "length": 77,
                        "crossTime": 14,
                        "crossTimeWithoutRealTime": 10,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 369081994,
                            "segment_direction": False,
                        },
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 403833199,
                            "nodeId": 312426534,
                            "x": 8.280588422753961,
                            "y": 50.00817553744451,
                            "direction": True,
                        },
                        "street": 12,
                        "distance": 371,
                        "length": 41,
                        "crossTime": 8,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 369081994,
                            "segment_direction": False,
                        },
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 239540450,
                            "nodeId": 205500150,
                            "x": 8.281030654908028,
                            "y": 50.008406125706664,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 379,
                        "length": 38,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 239540443,
                            "nodeId": 205500121,
                            "x": 8.281298742764584,
                            "y": 50.00867084273389,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 384,
                        "length": 17,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -45, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [
                                        {"angle": 45, "selected": False},
                                        {"angle": -45, "selected": True},
                                    ],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 239540450,
                            "segment_direction": True,
                        },
                        "instruction": {
                            "opcode": "KEEP_LEFT",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                                "angle_override": -45,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 239540444,
                            "nodeId": 205500130,
                            "x": 8.281234434580242,
                            "y": 50.00881377267493,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 386,
                        "length": 34,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 239540450,
                            "segment_direction": True,
                        },
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 239540445,
                            "nodeId": 205500137,
                            "x": 8.280849361789794,
                            "y": 50.008975478677336,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 390,
                        "length": 29,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 6,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [
                                        {"angle": 45, "selected": True},
                                        {"angle": 0, "selected": False},
                                    ],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 239540450,
                            "segment_direction": True,
                        },
                        "instruction": {
                            "opcode": "KEEP_RIGHT",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 1,
                                },
                                "angle": 45,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 72862896,
                            "nodeId": 205500142,
                            "x": 8.28045284284126,
                            "y": 50.00891461030903,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 394,
                        "length": 41,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 405166473,
                            "nodeId": 313334334,
                            "x": 8.28002089573558,
                            "y": 50.00912387495847,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 399,
                        "length": 111,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 409938838,
                            "nodeId": 313334326,
                            "x": 8.27950423955905,
                            "y": 50.01006660575547,
                            "direction": True,
                        },
                        "street": 15,
                        "altStreets": [14],
                        "distance": 408,
                        "length": 92,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 7,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 6,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 409938839,
                            "nodeId": 316442660,
                            "x": 8.27925263471346,
                            "y": 50.01088073325425,
                            "direction": True,
                        },
                        "street": 15,
                        "altStreets": [14],
                        "distance": 415,
                        "length": 29,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 6,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -90, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 2,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 405166584,
                            "nodeId": 313334419,
                            "x": 8.27922005408304,
                            "y": 50.01113661008851,
                            "direction": True,
                        },
                        "street": 15,
                        "altStreets": [14],
                        "distance": 417,
                        "length": 102,
                        "crossTime": 8,
                        "crossTimeWithoutRealTime": 8,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 409934684,
                            "nodeId": 313334327,
                            "x": 8.27924442517207,
                            "y": 50.01205562090193,
                            "direction": False,
                        },
                        "street": 15,
                        "altStreets": [14],
                        "distance": 425,
                        "length": 29,
                        "crossTime": 3,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 409934683,
                            "nodeId": 316440012,
                            "x": 8.279291535778537,
                            "y": 50.01231838716162,
                            "direction": False,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 428,
                        "length": 184,
                        "crossTime": 17,
                        "crossTimeWithoutRealTime": 17,
                        "crossTimeFreeFlow": 15,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857175,
                            "nodeId": 79353597,
                            "x": 8.278147418564016,
                            "y": 50.01377543212019,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 445,
                        "length": 23,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857178,
                            "nodeId": 79353599,
                            "x": 8.277986486023146,
                            "y": 50.0139555476341,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 447,
                        "length": 124,
                        "crossTime": 11,
                        "crossTimeWithoutRealTime": 11,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857180,
                            "nodeId": 79354969,
                            "x": 8.277121272327879,
                            "y": 50.01491582247074,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 458,
                        "length": 129,
                        "crossTime": 11,
                        "crossTimeWithoutRealTime": 11,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 411453967,
                            "nodeId": 79353601,
                            "x": 8.27620503,
                            "y": 50.0159094452043,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 469,
                        "length": 42,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 411453968,
                            "nodeId": 317414814,
                            "x": 8.275896263552331,
                            "y": 50.01622701328648,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 473,
                        "length": 103,
                        "crossTime": 12,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 376925116,
                            "nodeId": 79356582,
                            "x": 8.275136841045075,
                            "y": 50.01700807481023,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 485,
                        "length": 134,
                        "crossTime": 12,
                        "crossTimeWithoutRealTime": 12,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 376925119,
                            "nodeId": 294660739,
                            "x": 8.274080971316163,
                            "y": 50.01800707734384,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 497,
                        "length": 30,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 376925120,
                            "nodeId": 294660742,
                            "x": 8.273845800939585,
                            "y": 50.0182337925526,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 501,
                        "length": 212,
                        "crossTime": 21,
                        "crossTimeWithoutRealTime": 21,
                        "crossTimeFreeFlow": 17,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858799,
                            "nodeId": 79354978,
                            "x": 8.272186157909847,
                            "y": 50.01980970338028,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 522,
                        "length": 24,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858794,
                            "nodeId": 79354963,
                            "x": 8.272001807158741,
                            "y": 50.019988165549115,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 524,
                        "length": 55,
                        "crossTime": 6,
                        "crossTimeWithoutRealTime": 6,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857188,
                            "nodeId": 79353614,
                            "x": 8.271565290118863,
                            "y": 50.02039464367526,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 530,
                        "length": 193,
                        "crossTime": 19,
                        "crossTimeWithoutRealTime": 19,
                        "crossTimeFreeFlow": 16,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857172,
                            "nodeId": 79354965,
                            "x": 8.270047914180301,
                            "y": 50.021831580077205,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 549,
                        "length": 52,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857189,
                            "nodeId": 79354966,
                            "x": 8.269664332090146,
                            "y": 50.022226366232545,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 554,
                        "length": 86,
                        "crossTime": 11,
                        "crossTimeWithoutRealTime": 11,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 248027520,
                            "nodeId": 79354979,
                            "x": 8.269044264418032,
                            "y": 50.02288556308001,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 565,
                        "length": 12,
                        "crossTime": 1,
                        "crossTimeWithoutRealTime": 1,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 295891796,
                            "nodeId": 210888815,
                            "x": 8.26896228510667,
                            "y": 50.0229821401884,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 566,
                        "length": 64,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 7,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 295891797,
                            "nodeId": 243067739,
                            "x": 8.26853368016802,
                            "y": 50.02348571230767,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 573,
                        "length": 76,
                        "crossTime": 21,
                        "crossTimeWithoutRealTime": 21,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": -90, "selected": False}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 90, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                                "enable_display": True,
                                "enable_voice": False,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 367970761,
                            "nodeId": 79354953,
                            "x": 8.268000148657764,
                            "y": 50.02408051128032,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 594,
                        "length": 47,
                        "crossTime": 6,
                        "crossTimeWithoutRealTime": 6,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 390471869,
                            "nodeId": 288925512,
                            "x": 8.267692503386082,
                            "y": 50.024450898477824,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 600,
                        "length": 47,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 390471870,
                            "nodeId": 303450084,
                            "x": 8.267378525697433,
                            "y": 50.02481847197901,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 605,
                        "length": 185,
                        "crossTime": 15,
                        "crossTimeWithoutRealTime": 15,
                        "crossTimeFreeFlow": 14,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858805,
                            "nodeId": 79354954,
                            "x": 8.266131809881136,
                            "y": 50.02627243833795,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 620,
                        "length": 28,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858806,
                            "nodeId": 79354983,
                            "x": 8.265937126389316,
                            "y": 50.026494102900536,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 622,
                        "length": 66,
                        "crossTime": 5,
                        "crossTimeWithoutRealTime": 5,
                        "crossTimeFreeFlow": 5,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857196,
                            "nodeId": 79354987,
                            "x": 8.265504254180303,
                            "y": 50.0270157643426,
                            "direction": True,
                        },
                        "street": 17,
                        "altStreets": [16],
                        "distance": 627,
                        "length": 128,
                        "crossTime": 10,
                        "crossTimeWithoutRealTime": 10,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 371272297,
                            "nodeId": 79354956,
                            "x": 8.264674321909698,
                            "y": 50.028033734884026,
                            "direction": False,
                        },
                        "street": 19,
                        "altStreets": [18],
                        "distance": 637,
                        "length": 38,
                        "crossTime": 3,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 409967229,
                            "nodeId": 291089325,
                            "x": 8.264455273747524,
                            "y": 50.02834929646948,
                            "direction": False,
                        },
                        "street": 19,
                        "altStreets": [18],
                        "distance": 640,
                        "length": 22,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 409967228,
                            "nodeId": 316458967,
                            "x": 8.264331912081579,
                            "y": 50.02852586399634,
                            "direction": False,
                        },
                        "street": 19,
                        "altStreets": [18],
                        "distance": 642,
                        "length": 144,
                        "crossTime": 11,
                        "crossTimeWithoutRealTime": 11,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72858792,
                            "nodeId": 79353588,
                            "x": 8.263507879881136,
                            "y": 50.02970528446402,
                            "direction": True,
                        },
                        "street": 19,
                        "altStreets": [18],
                        "distance": 653,
                        "length": 188,
                        "crossTime": 18,
                        "crossTimeWithoutRealTime": 18,
                        "crossTimeFreeFlow": 14,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 257354949,
                            "nodeId": 79354948,
                            "x": 8.262456448776632,
                            "y": 50.031250719999996,
                            "direction": True,
                        },
                        "street": 19,
                        "altStreets": [18],
                        "distance": 671,
                        "length": 15,
                        "crossTime": 1,
                        "crossTimeWithoutRealTime": 1,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 257354950,
                            "nodeId": 216832380,
                            "x": 8.262374952416609,
                            "y": 50.03137463231125,
                            "direction": True,
                        },
                        "street": 19,
                        "altStreets": [18],
                        "distance": 672,
                        "length": 241,
                        "crossTime": 19,
                        "crossTimeWithoutRealTime": 19,
                        "crossTimeFreeFlow": 17,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857157,
                            "nodeId": 79354946,
                            "x": 8.26103504110451,
                            "y": 50.033363165399535,
                            "direction": True,
                        },
                        "street": 19,
                        "altStreets": [18],
                        "distance": 691,
                        "length": 332,
                        "crossTime": 25,
                        "crossTimeWithoutRealTime": 25,
                        "crossTimeFreeFlow": 24,
                        "knownDirection": True,
                        "penalty": 4,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 416794858,
                            "nodeId": 79354947,
                            "x": 8.259169669881137,
                            "y": 50.0360954231343,
                            "direction": True,
                        },
                        "street": 19,
                        "altStreets": [18],
                        "distance": 716,
                        "length": 439,
                        "crossTime": 32,
                        "crossTimeWithoutRealTime": 32,
                        "crossTimeFreeFlow": 29,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 416794859,
                            "nodeId": 320846004,
                            "x": 8.256689410926219,
                            "y": 50.03970829733373,
                            "direction": True,
                        },
                        "street": 19,
                        "altStreets": [18],
                        "distance": 748,
                        "length": 88,
                        "crossTime": 7,
                        "crossTimeWithoutRealTime": 7,
                        "crossTimeFreeFlow": 6,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [
                                        {"angle": -90, "selected": False},
                                        {"angle": -180, "selected": False},
                                    ],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 1,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 416794252,
                            "nodeId": 320846001,
                            "x": 8.256051338219386,
                            "y": 50.04038437688719,
                            "direction": True,
                        },
                        "street": 21,
                        "altStreets": [20],
                        "distance": 755,
                        "length": 237,
                        "crossTime": 19,
                        "crossTimeWithoutRealTime": 19,
                        "crossTimeFreeFlow": 16,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 416794253,
                            "nodeId": 320845573,
                            "x": 8.25378076676872,
                            "y": 50.041939028597206,
                            "direction": True,
                        },
                        "street": 21,
                        "altStreets": [20],
                        "distance": 774,
                        "length": 246,
                        "crossTime": 24,
                        "crossTimeWithoutRealTime": 24,
                        "crossTimeFreeFlow": 25,
                        "knownDirection": True,
                        "penalty": 4,
                        "roadType": 7,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [
                                        {"angle": -90, "selected": False},
                                        {"angle": -180, "selected": False},
                                    ],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": False}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 0, "selected": False}],
                                },
                                {
                                    "lane_index": 3,
                                    "angle_object": [{"angle": 90, "selected": True}],
                                },
                            ]
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "TURN_RIGHT",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 3,
                                    "to_lane_index": 3,
                                },
                                "angle": 90,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 151885312,
                            "nodeId": 79358412,
                            "x": 8.251391500234654,
                            "y": 50.0435269541452,
                            "direction": True,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 798,
                        "length": 164,
                        "crossTime": 16,
                        "crossTimeWithoutRealTime": 16,
                        "crossTimeFreeFlow": 16,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [
                                        {"angle": 0, "selected": True},
                                        {"angle": -90, "selected": False},
                                    ],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 253091711,
                            "nodeId": 79357116,
                            "x": 8.252906019881138,
                            "y": 50.044607144908426,
                            "direction": False,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 814,
                        "length": 155,
                        "crossTime": 14,
                        "crossTimeWithoutRealTime": 14,
                        "crossTimeFreeFlow": 14,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 253091710,
                            "nodeId": 214041176,
                            "x": 8.255038386697224,
                            "y": 50.04476611821232,
                            "direction": True,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 828,
                        "length": 29,
                        "crossTime": 3,
                        "crossTimeWithoutRealTime": 3,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "ROUNDABOUT_ENTER", "arg": 3},
                    },
                    {
                        "path": {
                            "segmentId": 213667347,
                            "nodeId": 188885628,
                            "x": 8.2554310041829,
                            "y": 50.04472059420899,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 831,
                        "length": 3,
                        "crossTime": 0,
                        "crossTimeWithoutRealTime": 0,
                        "crossTimeFreeFlow": 0,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 4,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 253091710,
                            "segment_direction": True,
                        },
                    },
                    {
                        "path": {
                            "segmentId": 213667348,
                            "nodeId": 188885629,
                            "x": 8.2554573242754,
                            "y": 50.044694694854996,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 831,
                        "length": 31,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 4,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 253091710,
                            "segment_direction": True,
                        },
                    },
                    {
                        "path": {
                            "segmentId": 416793590,
                            "nodeId": 188885630,
                            "x": 8.2558465958018,
                            "y": 50.044664445759,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 835,
                        "length": 7,
                        "crossTime": 1,
                        "crossTimeWithoutRealTime": 1,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 4,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 253091710,
                            "segment_direction": True,
                        },
                    },
                    {
                        "path": {
                            "segmentId": 416793591,
                            "nodeId": 320845144,
                            "x": 8.2559113193144,
                            "y": 50.044710880911985,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 836,
                        "length": 17,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 2,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 4,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 253091710,
                            "segment_direction": True,
                        },
                    },
                    {
                        "path": {
                            "segmentId": 213667350,
                            "nodeId": 188885631,
                            "x": 8.2559385450179,
                            "y": 50.044861084982,
                            "direction": True,
                        },
                        "street": 13,
                        "distance": 838,
                        "length": 3,
                        "crossTime": 0,
                        "crossTimeWithoutRealTime": 0,
                        "crossTimeFreeFlow": 0,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 4,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "entrySegment": {
                            "segment_id": 253091710,
                            "segment_direction": True,
                        },
                        "instruction": {"opcode": "ROUNDABOUT_EXIT", "arg": 3},
                    },
                    {
                        "path": {
                            "segmentId": 192085449,
                            "nodeId": 188885626,
                            "x": 8.2559191955111,
                            "y": 50.044889667846014,
                            "direction": False,
                        },
                        "street": 24,
                        "distance": 838,
                        "length": 14,
                        "crossTime": 1,
                        "crossTimeWithoutRealTime": 1,
                        "crossTimeFreeFlow": 1,
                        "knownDirection": True,
                        "penalty": 0,
                        "roadType": 4,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 388554717,
                            "nodeId": 177738038,
                            "x": 8.2559276154642,
                            "y": 50.045016242769,
                            "direction": False,
                        },
                        "street": 24,
                        "distance": 839,
                        "length": 241,
                        "crossTime": 15,
                        "crossTimeWithoutRealTime": 15,
                        "crossTimeFreeFlow": 16,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 4,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 388554716,
                            "nodeId": 302265475,
                            "x": 8.256299997484708,
                            "y": 50.047167379263094,
                            "direction": False,
                        },
                        "street": 25,
                        "distance": 854,
                        "length": 152,
                        "crossTime": 8,
                        "crossTimeWithoutRealTime": 8,
                        "crossTimeFreeFlow": 8,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 4,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 45, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 398631702,
                            "nodeId": 79353410,
                            "x": 8.25642748558197,
                            "y": 50.04852708999999,
                            "direction": True,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 862,
                        "length": 144,
                        "crossTime": 6,
                        "crossTimeWithoutRealTime": 6,
                        "crossTimeFreeFlow": 7,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 398631703,
                            "nodeId": 308912445,
                            "x": 8.256610947699954,
                            "y": 50.0498181204628,
                            "direction": True,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 868,
                        "length": 50,
                        "crossTime": 2,
                        "crossTimeWithoutRealTime": 2,
                        "crossTimeFreeFlow": 3,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 45, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 192085814,
                            "nodeId": 79353339,
                            "x": 8.256654860237733,
                            "y": 50.05026480212614,
                            "direction": False,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 870,
                        "length": 185,
                        "crossTime": 10,
                        "crossTimeWithoutRealTime": 10,
                        "crossTimeFreeFlow": 10,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 72857835,
                            "nodeId": 79353342,
                            "x": 8.25676439,
                            "y": 50.05192477,
                            "direction": True,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 880,
                        "length": 68,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "avoidStatus": "OPEN",
                        "clientLaneSet": {
                            "client_lane": [
                                {
                                    "lane_index": 0,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 1,
                                    "angle_object": [{"angle": 0, "selected": True}],
                                },
                                {
                                    "lane_index": 2,
                                    "angle_object": [{"angle": 45, "selected": False}],
                                },
                            ],
                            "enable_voice_for_instruction": False,
                        },
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {
                            "opcode": "NONE",
                            "arg": 0,
                            "laneGuidance": {
                                "lanes_range": {
                                    "from_lane_index": 0,
                                    "to_lane_index": 1,
                                },
                                "angle": 0,
                            },
                        },
                    },
                    {
                        "path": {
                            "segmentId": 257308322,
                            "nodeId": 79355652,
                            "x": 8.25688865828566,
                            "y": 50.052533113515985,
                            "direction": False,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 884,
                        "length": 152,
                        "crossTime": 9,
                        "crossTimeWithoutRealTime": 9,
                        "crossTimeFreeFlow": 9,
                        "knownDirection": True,
                        "penalty": 1,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 318914784,
                            "nodeId": 79353343,
                            "x": 8.25741476209015,
                            "y": 50.05385447298824,
                            "direction": True,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 893,
                        "length": 55,
                        "crossTime": 4,
                        "crossTimeWithoutRealTime": 4,
                        "crossTimeFreeFlow": 4,
                        "knownDirection": True,
                        "penalty": 2,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 414474650,
                            "nodeId": 79355651,
                            "x": 8.25737296447746,
                            "y": 50.05435170319033,
                            "direction": True,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 897,
                        "length": 268,
                        "crossTime": 41,
                        "crossTimeWithoutRealTime": 41,
                        "crossTimeFreeFlow": 21,
                        "knownDirection": True,
                        "penalty": 3,
                        "roadType": 2,
                        "isToll": False,
                        "useHovLane": False,
                        "attributes": 0,
                        "lane": "WHOLE_SEGMENT",
                        "areas": ["Umweltzone"],
                        "avoidStatus": "MAYBE",
                        "isInvalid": False,
                        "isBlocked": False,
                        "speedLimit": 0,
                        "instruction": {"opcode": "NONE", "arg": 0},
                    },
                    {
                        "path": {
                            "segmentId": 414474648,
                            "nodeId": 319342534,
                            "x": 8.255949009982276,
                            "y": 50.05657261912583,
                            "direction": True,
                        },
                        "street": 23,
                        "altStreets": [22],
                        "distance": 938,
                        "length": 144,
                        "crossTime": 37,
                        "crossTi