import vant_hoff_analysis as vh
import pytest

# from https://nrel.sharepoint.com/sites/DAVDataHubs/Shared%20Documents/Forms/AllItems.aspx?viewid=225ee237%2Db42a%2D4ccb%2D9d09%2D5fc9bef33ec2&id=%2Fsites%2FDAVDataHubs%2FShared%20Documents%2FGeneral%2FMetal%20Hydrides%20Database

curve1_concentrations = [0.830957077, 0.837267117, 0.85312786, 0.868995454, 0.900853965, 0.926340774, 0.964605243, 1.009282523, 1.057152505, 1.101836636, 1.156112577, 1.207195815, 1.258272202, 1.309348589, 1.360424976, 1.414694065, 1.468970006, 1.523239095, 1.580694036, 1.638142125, 1.695535404, 1.752798508, 1.762287549, 1.775003548, 1.778120886, 1.793981629, 1.819276601, 1.828683426, 1.838090251, 1.841145928]
curve1_pressures = [0.044032853, 0.054726469, 0.073612707, 0.097078814, 0.118293634, 0.138557775, 0.159117057, 0.168837072, 0.179150855, 0.186374403, 0.186374403, 0.186374403, 0.190094677, 0.193889213, 0.197759493, 0.201707028, 0.201707028, 0.205733361, 0.214028744, 0.227103159, 0.282256386, 0.510686652, 0.660301812, 0.773413979, 0.961241734, 1.292968614, 2.633909559, 4.317110183, 7.075960628, 10.50652813]
curve1_temperature = 348 # Kelvin

curve2_concentrations = [0.846947994, 0.856423332, 0.869050264, 0.888014642, 0.919736127, 0.977040339, 1.08871641, 1.232353762, 1.391968327, 1.545211191, 1.717596567, 1.781368399, 1.835425098, 1.867036963, 1.886001341, 1.892188058]
curve2_pressures = [0.040685725, 0.054726469, 0.082880991, 0.144144569, 0.260800856, 0.419099938, 0.510686652, 0.563732355, 0.598169182, 0.610109413, 0.647379284, 0.820659668, 1.544689526, 3.83434324, 6.668594882, 11.82936339]
curve2_temperature = 373 # Kelvin

curve3_concentrations = [0.923518041, 0.936151825, 0.951916649, 0.974012068, 1.018428999, 1.066216765, 1.133201854, 1.219377413, 1.318337485, 1.426882515, 1.557769611, 1.685457153, 1.778011265, 1.813076181, 1.832170734, 1.87349088, 1.908377663, 1.917784488, 1.933439691]
curve3_pressures = [0.047655342, 0.070759606, 0.12551986, 0.260800856, 0.58646263, 0.788852322, 0.942429619, 1.019961293, 1.061087193, 1.082267866, 1.125906032, 1.194684472, 1.31877794, 1.544689526, 1.84541659, 3.14669085, 6.161686113, 10.09931331, 24.57864517]
curve3_temperature = 388 # Kelvin

def test_example_data():
    curve1 = vh.PCTCurve(curve1_concentrations, curve1_pressures, curve1_temperature)
    curve2 = vh.PCTCurve(curve2_concentrations, curve2_pressures, curve2_temperature)
    curve3 = vh.PCTCurve(curve3_concentrations, curve3_pressures, curve3_temperature)

    fitter = vh.Fitter()

    deltaH, deltaS = fitter.fit_at_concentration(1.3, [curve1, curve2, curve3])

    assert deltaH == pytest.approx(-47.5702081)
    assert deltaS == pytest.approx(123.0147293420)



