## Sub-SBML
Sub-SBML is a Python based toolbox  

# Sub-SBML
## Python toolbox to to create, edit, combine, and model interactions among multiple Systems Biology Markup Language [(SBML)](http://sbml.org) models.

[![Build Status](https://travis-ci.com/BuildACell/subsbml.svg?branch=master)](https://travis-ci.com/BuildACell/subsbml)
[![codecov](https://codecov.io/gh/BuildACell/subsbml/branch/master/graph/badge.svg)](https://codecov.io/gh/BuildACell/subsbml)
[![PyPI version](https://badge.fury.io/py/subsbml.svg)](https://badge.fury.io/py/subsbml)

Sub-SBML works with a "subsystem" architecture of modeling where a single SBML model can be contained within a subsystem. 
Three major functionalities are developed in Sub-SBML that take advantage of this subsystem framework of modeling –  
creating subsystems, combining multiple subsystems, and modeling interactions such as transport of molecules and input-output relationships among multiple subsystems. 

Refer to the [Wiki](https://github.com/BuildACell/subsbml/wiki) for more information. 

To run - Go through tutorial files inside tutorials folder then check out some common examples in the examples folder. To check if different tools are working properly, run tests. 

Contact : Ayush Pandey (apandet at caltech dot edu) for any feedback or suggestions.


- **Website:** https://github.com/BuildACell/subsbml
- **Source:** https://github.com/BuildACell/subsbml
- **Bug reports:** https://github.com/buildacell/subsbml/issues
- **Documentation:** Coming Soon on: [subsbml.readthedocs.io](https://readthedocs.org/projects/subsbml/)

# Simple example

# Installation

Install the latest version of AutoReduce::

    $ pip install subsbml 

Install with all optional dependencies::

    $ pip install subsbml[all]

# Bugs

Report any bugs that you find [here](https://github.com/BuildACell/subsbml/issues).
You can also fork the repository on [GitHub](https://github.com/BuildACell/subsbml),
and the create a pull request (PR) with any changes. We welcome all changes, big or small, and we
will help you make the PR if you are new to `git` (just create a new issue)

# Versions

Sub-SBML versions:

* 1.0.0 (beta release): To install run `pip install subsbml==1.0.0`

# License
Released under the BSD 3-Clause License (see `LICENSE`)

Copyright (c) 2020, Ayush Pandey. All rights reserved.
