"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsOktaSamlStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
class AwsOktaSamlStack extends cdk.NestedStack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const oktaUser = new iam.User(this, 'OktaUser', {
            userName: 'okta-gateway-user',
        });
        oktaUser.addToPolicy(new iam.PolicyStatement({
            actions: ['iam:ListRoles', 'iam:ListAccountAliases'],
            resources: ['*'],
        }));
        if (props.metadataDocument) {
            const samlProvider = new iam.SamlProvider(this, 'OktaProvider', {
                name: 'okta',
                metadataDocument: props.metadataDocument,
            });
            const federatedPrincipal = new iam.FederatedPrincipal(samlProvider.samlProviderArn, {
                StringEquals: {
                    'SAML:aud': 'https://signin.aws.amazon.com/saml',
                },
            }, 'sts:AssumeRoleWithSAML');
            const adminPolicy = iam.ManagedPolicy.fromManagedPolicyArn(this, 'AdministratorPolicy', 'arn:aws:iam::aws:policy/AdministratorAccess');
            const billingPolicy = iam.ManagedPolicy.fromManagedPolicyArn(this, 'BillingPolicy', 'arn:aws:iam::aws:policy/job-function/Billing');
            const viewOnlyPolicy = iam.ManagedPolicy.fromManagedPolicyArn(this, 'ViewOnlyPolicy', 'arn:aws:iam::aws:policy/job-function/ViewOnlyAccess');
            const billingRole = new iam.Role(this, 'BillingRole', {
                roleName: 'okta-billing-role',
                assumedBy: federatedPrincipal,
            });
            billingRole.addManagedPolicy(billingPolicy);
            billingRole.addManagedPolicy(viewOnlyPolicy);
            const readOnlyRole = new iam.Role(this, 'ReadOnlyRole', {
                roleName: 'okta-readonly-role',
                assumedBy: federatedPrincipal,
            });
            readOnlyRole.addManagedPolicy(viewOnlyPolicy);
            const adminRole = new iam.Role(this, 'AdminRole', {
                roleName: 'okta-admin-role',
                assumedBy: federatedPrincipal,
            });
            adminRole.addManagedPolicy(adminPolicy);
            adminRole.addManagedPolicy(billingPolicy);
            const developerRole = new iam.Role(this, 'DeveloperRole', {
                roleName: 'okta-developer-role',
                assumedBy: federatedPrincipal,
            });
            if (props.adminForDeveloper) {
                developerRole.addManagedPolicy(adminPolicy);
            }
            props.developerPolicies.forEach((policy) => developerRole.addToPolicy(policy));
            developerRole.addToPolicy(new iam.PolicyStatement({
                effect: aws_iam_1.Effect.DENY,
                actions: ['organizations:*', 'billing:*'],
            }));
        }
    }
}
exports.AwsOktaSamlStack = AwsOktaSamlStack;
_a = JSII_RTTI_SYMBOL_1;
AwsOktaSamlStack[_a] = { fqn: "@justinm/cdk-constructs.management.AwsOktaSamlStack", version: "0.1.16" };
//# sourceMappingURL=data:application/json;base64,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