"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsAccountCloudTrailStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudtrail = require("@aws-cdk/aws-cloudtrail");
const iam = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
class AwsAccountCloudTrailStack extends cdk.NestedStack {
    constructor(scope, id) {
        super(scope, id);
        const cloudTrailBucket = new s3.Bucket(this, 'CloudTrail');
        cloudTrailBucket.addToResourcePolicy(new iam.PolicyStatement({
            actions: ['s3:GetBucketAcl'],
            resources: [cloudTrailBucket.bucketArn],
            principals: [new iam.ServicePrincipal('cloudtrail.amazonaws.com')],
        }));
        cloudTrailBucket.addToResourcePolicy(new iam.PolicyStatement({
            actions: ['s3:PutObject'],
            resources: [cloudTrailBucket.arnForObjects(`AWSLogs/${this.account}/*`)],
            principals: [new iam.ServicePrincipal('cloudtrail.amazonaws.com')],
        }));
        new cloudtrail.Trail(this, 'CloudTrail', {
            bucket: cloudTrailBucket,
            sendToCloudWatchLogs: false,
            isMultiRegionTrail: true,
            includeGlobalServiceEvents: true,
            enableFileValidation: true,
        });
    }
}
exports.AwsAccountCloudTrailStack = AwsAccountCloudTrailStack;
_a = JSII_RTTI_SYMBOL_1;
AwsAccountCloudTrailStack[_a] = { fqn: "@justinm/cdk-constructs.management.AwsAccountCloudTrailStack", version: "0.1.16" };
//# sourceMappingURL=data:application/json;base64,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