"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsAccountBudgetsStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const budgets = require("@aws-cdk/aws-budgets");
const cdk = require("@aws-cdk/core");
class AwsAccountBudgetsStack extends cdk.NestedStack {
    constructor(scope, id, props) {
        super(scope, id, props);
        new budgets.CfnBudget(this, 'Budget', {
            budget: {
                budgetName: 'AccountBudget',
                budgetType: 'COST',
                budgetLimit: {
                    amount: props.budgetLimit,
                    unit: 'USD',
                },
                timeUnit: 'MONTHLY',
            },
            notificationsWithSubscribers: [
                {
                    notification: {
                        comparisonOperator: 'GREATER_THAN',
                        threshold: 75,
                        thresholdType: 'PERCENTAGE',
                        notificationType: 'FORECASTED',
                    },
                    subscribers: props.emailAddresses.map((address) => ({
                        subscriptionType: 'EMAIL',
                        address,
                    })),
                },
            ],
        });
    }
}
exports.AwsAccountBudgetsStack = AwsAccountBudgetsStack;
_a = JSII_RTTI_SYMBOL_1;
AwsAccountBudgetsStack[_a] = { fqn: "@justinm/cdk-constructs.management.AwsAccountBudgetsStack", version: "0.1.16" };
//# sourceMappingURL=data:application/json;base64,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