# coding: utf-8

"""
    Wavefront REST API

    <p>The Wavefront REST API enables you to interact with Wavefront servers using standard REST API tools. You can use the REST API to automate commonly executed operations such as automatically tagging sources.</p><p>When you make REST API calls outside the Wavefront REST API documentation you must add the header \"Authorization: Bearer &lt;&lt;API-TOKEN&gt;&gt;\" to your HTTP requests.</p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class RoleDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'created_epoch_millis': 'int',
        'customer': 'str',
        'description': 'str',
        'id': 'str',
        'last_updated_account_id': 'str',
        'last_updated_ms': 'int',
        'linked_accounts_count': 'int',
        'linked_groups_count': 'int',
        'name': 'str',
        'permissions': 'list[str]',
        'sample_linked_accounts': 'list[str]',
        'sample_linked_groups': 'list[UserGroup]'
    }

    attribute_map = {
        'created_epoch_millis': 'createdEpochMillis',
        'customer': 'customer',
        'description': 'description',
        'id': 'id',
        'last_updated_account_id': 'lastUpdatedAccountId',
        'last_updated_ms': 'lastUpdatedMs',
        'linked_accounts_count': 'linkedAccountsCount',
        'linked_groups_count': 'linkedGroupsCount',
        'name': 'name',
        'permissions': 'permissions',
        'sample_linked_accounts': 'sampleLinkedAccounts',
        'sample_linked_groups': 'sampleLinkedGroups'
    }

    def __init__(self, created_epoch_millis=None, customer=None, description=None, id=None, last_updated_account_id=None, last_updated_ms=None, linked_accounts_count=None, linked_groups_count=None, name=None, permissions=None, sample_linked_accounts=None, sample_linked_groups=None):  # noqa: E501
        """RoleDTO - a model defined in Swagger"""  # noqa: E501

        self._created_epoch_millis = None
        self._customer = None
        self._description = None
        self._id = None
        self._last_updated_account_id = None
        self._last_updated_ms = None
        self._linked_accounts_count = None
        self._linked_groups_count = None
        self._name = None
        self._permissions = None
        self._sample_linked_accounts = None
        self._sample_linked_groups = None
        self.discriminator = None

        if created_epoch_millis is not None:
            self.created_epoch_millis = created_epoch_millis
        if customer is not None:
            self.customer = customer
        if description is not None:
            self.description = description
        if id is not None:
            self.id = id
        if last_updated_account_id is not None:
            self.last_updated_account_id = last_updated_account_id
        if last_updated_ms is not None:
            self.last_updated_ms = last_updated_ms
        if linked_accounts_count is not None:
            self.linked_accounts_count = linked_accounts_count
        if linked_groups_count is not None:
            self.linked_groups_count = linked_groups_count
        if name is not None:
            self.name = name
        if permissions is not None:
            self.permissions = permissions
        if sample_linked_accounts is not None:
            self.sample_linked_accounts = sample_linked_accounts
        if sample_linked_groups is not None:
            self.sample_linked_groups = sample_linked_groups

    @property
    def created_epoch_millis(self):
        """Gets the created_epoch_millis of this RoleDTO.  # noqa: E501


        :return: The created_epoch_millis of this RoleDTO.  # noqa: E501
        :rtype: int
        """
        return self._created_epoch_millis

    @created_epoch_millis.setter
    def created_epoch_millis(self, created_epoch_millis):
        """Sets the created_epoch_millis of this RoleDTO.


        :param created_epoch_millis: The created_epoch_millis of this RoleDTO.  # noqa: E501
        :type: int
        """

        self._created_epoch_millis = created_epoch_millis

    @property
    def customer(self):
        """Gets the customer of this RoleDTO.  # noqa: E501

        The id of the customer to which the role belongs  # noqa: E501

        :return: The customer of this RoleDTO.  # noqa: E501
        :rtype: str
        """
        return self._customer

    @customer.setter
    def customer(self, customer):
        """Sets the customer of this RoleDTO.

        The id of the customer to which the role belongs  # noqa: E501

        :param customer: The customer of this RoleDTO.  # noqa: E501
        :type: str
        """

        self._customer = customer

    @property
    def description(self):
        """Gets the description of this RoleDTO.  # noqa: E501

        The description of the role  # noqa: E501

        :return: The description of this RoleDTO.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this RoleDTO.

        The description of the role  # noqa: E501

        :param description: The description of this RoleDTO.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def id(self):
        """Gets the id of this RoleDTO.  # noqa: E501

        The unique identifier of the role  # noqa: E501

        :return: The id of this RoleDTO.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this RoleDTO.

        The unique identifier of the role  # noqa: E501

        :param id: The id of this RoleDTO.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def last_updated_account_id(self):
        """Gets the last_updated_account_id of this RoleDTO.  # noqa: E501

        The account that updated this role last time  # noqa: E501

        :return: The last_updated_account_id of this RoleDTO.  # noqa: E501
        :rtype: str
        """
        return self._last_updated_account_id

    @last_updated_account_id.setter
    def last_updated_account_id(self, last_updated_account_id):
        """Sets the last_updated_account_id of this RoleDTO.

        The account that updated this role last time  # noqa: E501

        :param last_updated_account_id: The last_updated_account_id of this RoleDTO.  # noqa: E501
        :type: str
        """

        self._last_updated_account_id = last_updated_account_id

    @property
    def last_updated_ms(self):
        """Gets the last_updated_ms of this RoleDTO.  # noqa: E501

        The last time when the role is updated, in epoch milliseconds  # noqa: E501

        :return: The last_updated_ms of this RoleDTO.  # noqa: E501
        :rtype: int
        """
        return self._last_updated_ms

    @last_updated_ms.setter
    def last_updated_ms(self, last_updated_ms):
        """Sets the last_updated_ms of this RoleDTO.

        The last time when the role is updated, in epoch milliseconds  # noqa: E501

        :param last_updated_ms: The last_updated_ms of this RoleDTO.  # noqa: E501
        :type: int
        """

        self._last_updated_ms = last_updated_ms

    @property
    def linked_accounts_count(self):
        """Gets the linked_accounts_count of this RoleDTO.  # noqa: E501

        Total number of accounts that are linked to the role  # noqa: E501

        :return: The linked_accounts_count of this RoleDTO.  # noqa: E501
        :rtype: int
        """
        return self._linked_accounts_count

    @linked_accounts_count.setter
    def linked_accounts_count(self, linked_accounts_count):
        """Sets the linked_accounts_count of this RoleDTO.

        Total number of accounts that are linked to the role  # noqa: E501

        :param linked_accounts_count: The linked_accounts_count of this RoleDTO.  # noqa: E501
        :type: int
        """

        self._linked_accounts_count = linked_accounts_count

    @property
    def linked_groups_count(self):
        """Gets the linked_groups_count of this RoleDTO.  # noqa: E501

        Total number of groups that are linked to the role  # noqa: E501

        :return: The linked_groups_count of this RoleDTO.  # noqa: E501
        :rtype: int
        """
        return self._linked_groups_count

    @linked_groups_count.setter
    def linked_groups_count(self, linked_groups_count):
        """Sets the linked_groups_count of this RoleDTO.

        Total number of groups that are linked to the role  # noqa: E501

        :param linked_groups_count: The linked_groups_count of this RoleDTO.  # noqa: E501
        :type: int
        """

        self._linked_groups_count = linked_groups_count

    @property
    def name(self):
        """Gets the name of this RoleDTO.  # noqa: E501

        The name of the role  # noqa: E501

        :return: The name of this RoleDTO.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this RoleDTO.

        The name of the role  # noqa: E501

        :param name: The name of this RoleDTO.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def permissions(self):
        """Gets the permissions of this RoleDTO.  # noqa: E501

        List of permissions the role has been granted access to  # noqa: E501

        :return: The permissions of this RoleDTO.  # noqa: E501
        :rtype: list[str]
        """
        return self._permissions

    @permissions.setter
    def permissions(self, permissions):
        """Sets the permissions of this RoleDTO.

        List of permissions the role has been granted access to  # noqa: E501

        :param permissions: The permissions of this RoleDTO.  # noqa: E501
        :type: list[str]
        """

        self._permissions = permissions

    @property
    def sample_linked_accounts(self):
        """Gets the sample_linked_accounts of this RoleDTO.  # noqa: E501

        A sample of the accounts assigned to this role. Please use the Role facet of the Account Search API to get the full list of accounts for this role  # noqa: E501

        :return: The sample_linked_accounts of this RoleDTO.  # noqa: E501
        :rtype: list[str]
        """
        return self._sample_linked_accounts

    @sample_linked_accounts.setter
    def sample_linked_accounts(self, sample_linked_accounts):
        """Sets the sample_linked_accounts of this RoleDTO.

        A sample of the accounts assigned to this role. Please use the Role facet of the Account Search API to get the full list of accounts for this role  # noqa: E501

        :param sample_linked_accounts: The sample_linked_accounts of this RoleDTO.  # noqa: E501
        :type: list[str]
        """

        self._sample_linked_accounts = sample_linked_accounts

    @property
    def sample_linked_groups(self):
        """Gets the sample_linked_groups of this RoleDTO.  # noqa: E501

        A sample of the groups assigned to this role. Please use the Role facet of the Group Search API to get the full list of groups for this role  # noqa: E501

        :return: The sample_linked_groups of this RoleDTO.  # noqa: E501
        :rtype: list[UserGroup]
        """
        return self._sample_linked_groups

    @sample_linked_groups.setter
    def sample_linked_groups(self, sample_linked_groups):
        """Sets the sample_linked_groups of this RoleDTO.

        A sample of the groups assigned to this role. Please use the Role facet of the Group Search API to get the full list of groups for this role  # noqa: E501

        :param sample_linked_groups: The sample_linked_groups of this RoleDTO.  # noqa: E501
        :type: list[UserGroup]
        """

        self._sample_linked_groups = sample_linked_groups

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RoleDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RoleDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
