# coding: utf-8

"""
    Wavefront REST API

    <p>The Wavefront REST API enables you to interact with Wavefront servers using standard REST API tools. You can use the REST API to automate commonly executed operations such as automatically tagging sources.</p><p>When you make REST API calls outside the Wavefront REST API documentation you must add the header \"Authorization: Bearer &lt;&lt;API-TOKEN&gt;&gt;\" to your HTTP requests.</p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class DerivedMetricDefinition(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'additional_information': 'str',
        'create_user_id': 'str',
        'created': 'int',
        'created_epoch_millis': 'int',
        'creator_id': 'str',
        'deleted': 'bool',
        'hosts_used': 'list[str]',
        'id': 'str',
        'in_trash': 'bool',
        'include_obsolete_metrics': 'bool',
        'last_error_message': 'str',
        'last_failed_time': 'int',
        'last_processed_millis': 'int',
        'last_query_time': 'int',
        'metrics_used': 'list[str]',
        'minutes': 'int',
        'name': 'str',
        'points_scanned_at_last_query': 'int',
        'process_rate_minutes': 'int',
        'query': 'str',
        'query_failing': 'bool',
        'query_qb_enabled': 'bool',
        'query_qb_serialization': 'str',
        'status': 'list[str]',
        'tags': 'WFTags',
        'update_user_id': 'str',
        'updated': 'int',
        'updated_epoch_millis': 'int',
        'updater_id': 'str'
    }

    attribute_map = {
        'additional_information': 'additionalInformation',
        'create_user_id': 'createUserId',
        'created': 'created',
        'created_epoch_millis': 'createdEpochMillis',
        'creator_id': 'creatorId',
        'deleted': 'deleted',
        'hosts_used': 'hostsUsed',
        'id': 'id',
        'in_trash': 'inTrash',
        'include_obsolete_metrics': 'includeObsoleteMetrics',
        'last_error_message': 'lastErrorMessage',
        'last_failed_time': 'lastFailedTime',
        'last_processed_millis': 'lastProcessedMillis',
        'last_query_time': 'lastQueryTime',
        'metrics_used': 'metricsUsed',
        'minutes': 'minutes',
        'name': 'name',
        'points_scanned_at_last_query': 'pointsScannedAtLastQuery',
        'process_rate_minutes': 'processRateMinutes',
        'query': 'query',
        'query_failing': 'queryFailing',
        'query_qb_enabled': 'queryQBEnabled',
        'query_qb_serialization': 'queryQBSerialization',
        'status': 'status',
        'tags': 'tags',
        'update_user_id': 'updateUserId',
        'updated': 'updated',
        'updated_epoch_millis': 'updatedEpochMillis',
        'updater_id': 'updaterId'
    }

    def __init__(self, additional_information=None, create_user_id=None, created=None, created_epoch_millis=None, creator_id=None, deleted=None, hosts_used=None, id=None, in_trash=None, include_obsolete_metrics=None, last_error_message=None, last_failed_time=None, last_processed_millis=None, last_query_time=None, metrics_used=None, minutes=None, name=None, points_scanned_at_last_query=None, process_rate_minutes=None, query=None, query_failing=None, query_qb_enabled=None, query_qb_serialization=None, status=None, tags=None, update_user_id=None, updated=None, updated_epoch_millis=None, updater_id=None):  # noqa: E501
        """DerivedMetricDefinition - a model defined in Swagger"""  # noqa: E501

        self._additional_information = None
        self._create_user_id = None
        self._created = None
        self._created_epoch_millis = None
        self._creator_id = None
        self._deleted = None
        self._hosts_used = None
        self._id = None
        self._in_trash = None
        self._include_obsolete_metrics = None
        self._last_error_message = None
        self._last_failed_time = None
        self._last_processed_millis = None
        self._last_query_time = None
        self._metrics_used = None
        self._minutes = None
        self._name = None
        self._points_scanned_at_last_query = None
        self._process_rate_minutes = None
        self._query = None
        self._query_failing = None
        self._query_qb_enabled = None
        self._query_qb_serialization = None
        self._status = None
        self._tags = None
        self._update_user_id = None
        self._updated = None
        self._updated_epoch_millis = None
        self._updater_id = None
        self.discriminator = None

        if additional_information is not None:
            self.additional_information = additional_information
        if create_user_id is not None:
            self.create_user_id = create_user_id
        if created is not None:
            self.created = created
        if created_epoch_millis is not None:
            self.created_epoch_millis = created_epoch_millis
        if creator_id is not None:
            self.creator_id = creator_id
        if deleted is not None:
            self.deleted = deleted
        if hosts_used is not None:
            self.hosts_used = hosts_used
        if id is not None:
            self.id = id
        if in_trash is not None:
            self.in_trash = in_trash
        if include_obsolete_metrics is not None:
            self.include_obsolete_metrics = include_obsolete_metrics
        if last_error_message is not None:
            self.last_error_message = last_error_message
        if last_failed_time is not None:
            self.last_failed_time = last_failed_time
        if last_processed_millis is not None:
            self.last_processed_millis = last_processed_millis
        if last_query_time is not None:
            self.last_query_time = last_query_time
        if metrics_used is not None:
            self.metrics_used = metrics_used
        self.minutes = minutes
        self.name = name
        if points_scanned_at_last_query is not None:
            self.points_scanned_at_last_query = points_scanned_at_last_query
        if process_rate_minutes is not None:
            self.process_rate_minutes = process_rate_minutes
        self.query = query
        if query_failing is not None:
            self.query_failing = query_failing
        if query_qb_enabled is not None:
            self.query_qb_enabled = query_qb_enabled
        if query_qb_serialization is not None:
            self.query_qb_serialization = query_qb_serialization
        if status is not None:
            self.status = status
        if tags is not None:
            self.tags = tags
        if update_user_id is not None:
            self.update_user_id = update_user_id
        if updated is not None:
            self.updated = updated
        if updated_epoch_millis is not None:
            self.updated_epoch_millis = updated_epoch_millis
        if updater_id is not None:
            self.updater_id = updater_id

    @property
    def additional_information(self):
        """Gets the additional_information of this DerivedMetricDefinition.  # noqa: E501

        User-supplied additional explanatory information for the derived metric  # noqa: E501

        :return: The additional_information of this DerivedMetricDefinition.  # noqa: E501
        :rtype: str
        """
        return self._additional_information

    @additional_information.setter
    def additional_information(self, additional_information):
        """Sets the additional_information of this DerivedMetricDefinition.

        User-supplied additional explanatory information for the derived metric  # noqa: E501

        :param additional_information: The additional_information of this DerivedMetricDefinition.  # noqa: E501
        :type: str
        """

        self._additional_information = additional_information

    @property
    def create_user_id(self):
        """Gets the create_user_id of this DerivedMetricDefinition.  # noqa: E501


        :return: The create_user_id of this DerivedMetricDefinition.  # noqa: E501
        :rtype: str
        """
        return self._create_user_id

    @create_user_id.setter
    def create_user_id(self, create_user_id):
        """Sets the create_user_id of this DerivedMetricDefinition.


        :param create_user_id: The create_user_id of this DerivedMetricDefinition.  # noqa: E501
        :type: str
        """

        self._create_user_id = create_user_id

    @property
    def created(self):
        """Gets the created of this DerivedMetricDefinition.  # noqa: E501

        When this derived metric was created, in epoch millis  # noqa: E501

        :return: The created of this DerivedMetricDefinition.  # noqa: E501
        :rtype: int
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this DerivedMetricDefinition.

        When this derived metric was created, in epoch millis  # noqa: E501

        :param created: The created of this DerivedMetricDefinition.  # noqa: E501
        :type: int
        """

        self._created = created

    @property
    def created_epoch_millis(self):
        """Gets the created_epoch_millis of this DerivedMetricDefinition.  # noqa: E501


        :return: The created_epoch_millis of this DerivedMetricDefinition.  # noqa: E501
        :rtype: int
        """
        return self._created_epoch_millis

    @created_epoch_millis.setter
    def created_epoch_millis(self, created_epoch_millis):
        """Sets the created_epoch_millis of this DerivedMetricDefinition.


        :param created_epoch_millis: The created_epoch_millis of this DerivedMetricDefinition.  # noqa: E501
        :type: int
        """

        self._created_epoch_millis = created_epoch_millis

    @property
    def creator_id(self):
        """Gets the creator_id of this DerivedMetricDefinition.  # noqa: E501


        :return: The creator_id of this DerivedMetricDefinition.  # noqa: E501
        :rtype: str
        """
        return self._creator_id

    @creator_id.setter
    def creator_id(self, creator_id):
        """Sets the creator_id of this DerivedMetricDefinition.


        :param creator_id: The creator_id of this DerivedMetricDefinition.  # noqa: E501
        :type: str
        """

        self._creator_id = creator_id

    @property
    def deleted(self):
        """Gets the deleted of this DerivedMetricDefinition.  # noqa: E501


        :return: The deleted of this DerivedMetricDefinition.  # noqa: E501
        :rtype: bool
        """
        return self._deleted

    @deleted.setter
    def deleted(self, deleted):
        """Sets the deleted of this DerivedMetricDefinition.


        :param deleted: The deleted of this DerivedMetricDefinition.  # noqa: E501
        :type: bool
        """

        self._deleted = deleted

    @property
    def hosts_used(self):
        """Gets the hosts_used of this DerivedMetricDefinition.  # noqa: E501

        Number of hosts checked by the query  # noqa: E501

        :return: The hosts_used of this DerivedMetricDefinition.  # noqa: E501
        :rtype: list[str]
        """
        return self._hosts_used

    @hosts_used.setter
    def hosts_used(self, hosts_used):
        """Sets the hosts_used of this DerivedMetricDefinition.

        Number of hosts checked by the query  # noqa: E501

        :param hosts_used: The hosts_used of this DerivedMetricDefinition.  # noqa: E501
        :type: list[str]
        """

        self._hosts_used = hosts_used

    @property
    def id(self):
        """Gets the id of this DerivedMetricDefinition.  # noqa: E501


        :return: The id of this DerivedMetricDefinition.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DerivedMetricDefinition.


        :param id: The id of this DerivedMetricDefinition.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def in_trash(self):
        """Gets the in_trash of this DerivedMetricDefinition.  # noqa: E501


        :return: The in_trash of this DerivedMetricDefinition.  # noqa: E501
        :rtype: bool
        """
        return self._in_trash

    @in_trash.setter
    def in_trash(self, in_trash):
        """Sets the in_trash of this DerivedMetricDefinition.


        :param in_trash: The in_trash of this DerivedMetricDefinition.  # noqa: E501
        :type: bool
        """

        self._in_trash = in_trash

    @property
    def include_obsolete_metrics(self):
        """Gets the include_obsolete_metrics of this DerivedMetricDefinition.  # noqa: E501

        Whether to include obsolete metrics in query  # noqa: E501

        :return: The include_obsolete_metrics of this DerivedMetricDefinition.  # noqa: E501
        :rtype: bool
        """
        return self._include_obsolete_metrics

    @include_obsolete_metrics.setter
    def include_obsolete_metrics(self, include_obsolete_metrics):
        """Sets the include_obsolete_metrics of this DerivedMetricDefinition.

        Whether to include obsolete metrics in query  # noqa: E501

        :param include_obsolete_metrics: The include_obsolete_metrics of this DerivedMetricDefinition.  # noqa: E501
        :type: bool
        """

        self._include_obsolete_metrics = include_obsolete_metrics

    @property
    def last_error_message(self):
        """Gets the last_error_message of this DerivedMetricDefinition.  # noqa: E501

        The last error encountered when running the query  # noqa: E501

        :return: The last_error_message of this DerivedMetricDefinition.  # noqa: E501
        :rtype: str
        """
        return self._last_error_message

    @last_error_message.setter
    def last_error_message(self, last_error_message):
        """Sets the last_error_message of this DerivedMetricDefinition.

        The last error encountered when running the query  # noqa: E501

        :param last_error_message: The last_error_message of this DerivedMetricDefinition.  # noqa: E501
        :type: str
        """

        self._last_error_message = last_error_message

    @property
    def last_failed_time(self):
        """Gets the last_failed_time of this DerivedMetricDefinition.  # noqa: E501

        The time of the last error encountered when running the query, in epoch millis  # noqa: E501

        :return: The last_failed_time of this DerivedMetricDefinition.  # noqa: E501
        :rtype: int
        """
        return self._last_failed_time

    @last_failed_time.setter
    def last_failed_time(self, last_failed_time):
        """Sets the last_failed_time of this DerivedMetricDefinition.

        The time of the last error encountered when running the query, in epoch millis  # noqa: E501

        :param last_failed_time: The last_failed_time of this DerivedMetricDefinition.  # noqa: E501
        :type: int
        """

        self._last_failed_time = last_failed_time

    @property
    def last_processed_millis(self):
        """Gets the last_processed_millis of this DerivedMetricDefinition.  # noqa: E501

        The last time when the derived metric query was run, in epoch millis  # noqa: E501

        :return: The last_processed_millis of this DerivedMetricDefinition.  # noqa: E501
        :rtype: int
        """
        return self._last_processed_millis

    @last_processed_millis.setter
    def last_processed_millis(self, last_processed_millis):
        """Sets the last_processed_millis of this DerivedMetricDefinition.

        The last time when the derived metric query was run, in epoch millis  # noqa: E501

        :param last_processed_millis: The last_processed_millis of this DerivedMetricDefinition.  # noqa: E501
        :type: int
        """

        self._last_processed_millis = last_processed_millis

    @property
    def last_query_time(self):
        """Gets the last_query_time of this DerivedMetricDefinition.  # noqa: E501

        Time for the query execute, averaged on hourly basis  # noqa: E501

        :return: The last_query_time of this DerivedMetricDefinition.  # noqa: E501
        :rtype: int
        """
        return self._last_query_time

    @last_query_time.setter
    def last_query_time(self, last_query_time):
        """Sets the last_query_time of this DerivedMetricDefinition.

        Time for the query execute, averaged on hourly basis  # noqa: E501

        :param last_query_time: The last_query_time of this DerivedMetricDefinition.  # noqa: E501
        :type: int
        """

        self._last_query_time = last_query_time

    @property
    def metrics_used(self):
        """Gets the metrics_used of this DerivedMetricDefinition.  # noqa: E501

        Number of metrics checked by the query  # noqa: E501

        :return: The metrics_used of this DerivedMetricDefinition.  # noqa: E501
        :rtype: list[str]
        """
        return self._metrics_used

    @metrics_used.setter
    def metrics_used(self, metrics_used):
        """Sets the metrics_used of this DerivedMetricDefinition.

        Number of metrics checked by the query  # noqa: E501

        :param metrics_used: The metrics_used of this DerivedMetricDefinition.  # noqa: E501
        :type: list[str]
        """

        self._metrics_used = metrics_used

    @property
    def minutes(self):
        """Gets the minutes of this DerivedMetricDefinition.  # noqa: E501

        Number of minutes to query for the derived metric  # noqa: E501

        :return: The minutes of this DerivedMetricDefinition.  # noqa: E501
        :rtype: int
        """
        return self._minutes

    @minutes.setter
    def minutes(self, minutes):
        """Sets the minutes of this DerivedMetricDefinition.

        Number of minutes to query for the derived metric  # noqa: E501

        :param minutes: The minutes of this DerivedMetricDefinition.  # noqa: E501
        :type: int
        """
        if minutes is None:
            raise ValueError("Invalid value for `minutes`, must not be `None`")  # noqa: E501

        self._minutes = minutes

    @property
    def name(self):
        """Gets the name of this DerivedMetricDefinition.  # noqa: E501


        :return: The name of this DerivedMetricDefinition.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this DerivedMetricDefinition.


        :param name: The name of this DerivedMetricDefinition.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def points_scanned_at_last_query(self):
        """Gets the points_scanned_at_last_query of this DerivedMetricDefinition.  # noqa: E501

        A derived field recording the number of data points scanned when the system last computed the query  # noqa: E501

        :return: The points_scanned_at_last_query of this DerivedMetricDefinition.  # noqa: E501
        :rtype: int
        """
        return self._points_scanned_at_last_query

    @points_scanned_at_last_query.setter
    def points_scanned_at_last_query(self, points_scanned_at_last_query):
        """Sets the points_scanned_at_last_query of this DerivedMetricDefinition.

        A derived field recording the number of data points scanned when the system last computed the query  # noqa: E501

        :param points_scanned_at_last_query: The points_scanned_at_last_query of this DerivedMetricDefinition.  # noqa: E501
        :type: int
        """

        self._points_scanned_at_last_query = points_scanned_at_last_query

    @property
    def process_rate_minutes(self):
        """Gets the process_rate_minutes of this DerivedMetricDefinition.  # noqa: E501

        The interval between executing the query, in minutes.  Defaults to 1 minute  # noqa: E501

        :return: The process_rate_minutes of this DerivedMetricDefinition.  # noqa: E501
        :rtype: int
        """
        return self._process_rate_minutes

    @process_rate_minutes.setter
    def process_rate_minutes(self, process_rate_minutes):
        """Sets the process_rate_minutes of this DerivedMetricDefinition.

        The interval between executing the query, in minutes.  Defaults to 1 minute  # noqa: E501

        :param process_rate_minutes: The process_rate_minutes of this DerivedMetricDefinition.  # noqa: E501
        :type: int
        """

        self._process_rate_minutes = process_rate_minutes

    @property
    def query(self):
        """Gets the query of this DerivedMetricDefinition.  # noqa: E501

        A Wavefront query that is evaluated at regular intervals (default 1m).  # noqa: E501

        :return: The query of this DerivedMetricDefinition.  # noqa: E501
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query):
        """Sets the query of this DerivedMetricDefinition.

        A Wavefront query that is evaluated at regular intervals (default 1m).  # noqa: E501

        :param query: The query of this DerivedMetricDefinition.  # noqa: E501
        :type: str
        """
        if query is None:
            raise ValueError("Invalid value for `query`, must not be `None`")  # noqa: E501

        self._query = query

    @property
    def query_failing(self):
        """Gets the query_failing of this DerivedMetricDefinition.  # noqa: E501

        Whether there was an exception when the query last ran  # noqa: E501

        :return: The query_failing of this DerivedMetricDefinition.  # noqa: E501
        :rtype: bool
        """
        return self._query_failing

    @query_failing.setter
    def query_failing(self, query_failing):
        """Sets the query_failing of this DerivedMetricDefinition.

        Whether there was an exception when the query last ran  # noqa: E501

        :param query_failing: The query_failing of this DerivedMetricDefinition.  # noqa: E501
        :type: bool
        """

        self._query_failing = query_failing

    @property
    def query_qb_enabled(self):
        """Gets the query_qb_enabled of this DerivedMetricDefinition.  # noqa: E501

        Whether the query was created using the Query Builder. Default false  # noqa: E501

        :return: The query_qb_enabled of this DerivedMetricDefinition.  # noqa: E501
        :rtype: bool
        """
        return self._query_qb_enabled

    @query_qb_enabled.setter
    def query_qb_enabled(self, query_qb_enabled):
        """Sets the query_qb_enabled of this DerivedMetricDefinition.

        Whether the query was created using the Query Builder. Default false  # noqa: E501

        :param query_qb_enabled: The query_qb_enabled of this DerivedMetricDefinition.  # noqa: E501
        :type: bool
        """

        self._query_qb_enabled = query_qb_enabled

    @property
    def query_qb_serialization(self):
        """Gets the query_qb_serialization of this DerivedMetricDefinition.  # noqa: E501

        The special serialization of the Query Builder that corresponds to the query.  Applicable only when queryQBEnabled is true  # noqa: E501

        :return: The query_qb_serialization of this DerivedMetricDefinition.  # noqa: E501
        :rtype: str
        """
        return self._query_qb_serialization

    @query_qb_serialization.setter
    def query_qb_serialization(self, query_qb_serialization):
        """Sets the query_qb_serialization of this DerivedMetricDefinition.

        The special serialization of the Query Builder that corresponds to the query.  Applicable only when queryQBEnabled is true  # noqa: E501

        :param query_qb_serialization: The query_qb_serialization of this DerivedMetricDefinition.  # noqa: E501
        :type: str
        """

        self._query_qb_serialization = query_qb_serialization

    @property
    def status(self):
        """Gets the status of this DerivedMetricDefinition.  # noqa: E501

        Lists the current state of the derived metric. Can be one or more of: INVALID, ACTIVE, TRASH, NO_DATA  # noqa: E501

        :return: The status of this DerivedMetricDefinition.  # noqa: E501
        :rtype: list[str]
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this DerivedMetricDefinition.

        Lists the current state of the derived metric. Can be one or more of: INVALID, ACTIVE, TRASH, NO_DATA  # noqa: E501

        :param status: The status of this DerivedMetricDefinition.  # noqa: E501
        :type: list[str]
        """

        self._status = status

    @property
    def tags(self):
        """Gets the tags of this DerivedMetricDefinition.  # noqa: E501


        :return: The tags of this DerivedMetricDefinition.  # noqa: E501
        :rtype: WFTags
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this DerivedMetricDefinition.


        :param tags: The tags of this DerivedMetricDefinition.  # noqa: E501
        :type: WFTags
        """

        self._tags = tags

    @property
    def update_user_id(self):
        """Gets the update_user_id of this DerivedMetricDefinition.  # noqa: E501

        The user that last updated this derived metric definition  # noqa: E501

        :return: The update_user_id of this DerivedMetricDefinition.  # noqa: E501
        :rtype: str
        """
        return self._update_user_id

    @update_user_id.setter
    def update_user_id(self, update_user_id):
        """Sets the update_user_id of this DerivedMetricDefinition.

        The user that last updated this derived metric definition  # noqa: E501

        :param update_user_id: The update_user_id of this DerivedMetricDefinition.  # noqa: E501
        :type: str
        """

        self._update_user_id = update_user_id

    @property
    def updated(self):
        """Gets the updated of this DerivedMetricDefinition.  # noqa: E501

        When the derived metric definition was last updated, in epoch millis  # noqa: E501

        :return: The updated of this DerivedMetricDefinition.  # noqa: E501
        :rtype: int
        """
        return self._updated

    @updated.setter
    def updated(self, updated):
        """Sets the updated of this DerivedMetricDefinition.

        When the derived metric definition was last updated, in epoch millis  # noqa: E501

        :param updated: The updated of this DerivedMetricDefinition.  # noqa: E501
        :type: int
        """

        self._updated = updated

    @property
    def updated_epoch_millis(self):
        """Gets the updated_epoch_millis of this DerivedMetricDefinition.  # noqa: E501


        :return: The updated_epoch_millis of this DerivedMetricDefinition.  # noqa: E501
        :rtype: int
        """
        return self._updated_epoch_millis

    @updated_epoch_millis.setter
    def updated_epoch_millis(self, updated_epoch_millis):
        """Sets the updated_epoch_millis of this DerivedMetricDefinition.


        :param updated_epoch_millis: The updated_epoch_millis of this DerivedMetricDefinition.  # noqa: E501
        :type: int
        """

        self._updated_epoch_millis = updated_epoch_millis

    @property
    def updater_id(self):
        """Gets the updater_id of this DerivedMetricDefinition.  # noqa: E501


        :return: The updater_id of this DerivedMetricDefinition.  # noqa: E501
        :rtype: str
        """
        return self._updater_id

    @updater_id.setter
    def updater_id(self, updater_id):
        """Sets the updater_id of this DerivedMetricDefinition.


        :param updater_id: The updater_id of this DerivedMetricDefinition.  # noqa: E501
        :type: str
        """

        self._updater_id = updater_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DerivedMetricDefinition, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DerivedMetricDefinition):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
