# Onono! The Puzzle Game

Implementation of a known *puzzle* game [Nonogram](https://en.wikipedia.org/wiki/Nonogram), consisting of coloring
a white grid based on given instructions. Game was created using the `pygame` library, responsible for all the GUI interactions.

One of the main extensions of this game is the possibility of converting any image (PNG) to a game puzzle. This results 
in a quick and an efficient way of creating new puzzles and brings a whole new level of replayability to the game. Puzzles
can also be generated completely randomly.

Closer information about the project itself, algorithms used and possible extensions can be found in the attached `report.pdf` file.

## Dependencies, installation

Dependencies are listed in the `requirements.txt` text file. Most notable of them are:
- pygame (GUI)
- numpy (savegame representation, game logic operations)
- PIL (image operations)
- pytest, pylint, pyautogui (testing)

Installation process:
- Make sure you are in the root repository (same one as this README).
- Install the dependencies with the `pip install -r requirements.txt` command.
- Launch the game with the `python onono` command.
- You can exit the game from the GUI window or by pressing Ctrl+C in the terminal.

## Testing

Test files were contained in the `tests/` directory. Further directory structure is determined by the logical modules of the code.

Some of the things that are tested:
- Linting with PEP-8 (using `pylint`)
- Basic GUI testing (using `pyautogui`)
- Incorrect save files, corrupted images
- Internal game logic

Tests can be launched with the `pytest` command.

# Onono! The Puzzle Game - Czech

Semestrální práce implementuje známou *puzzle* hru [Nonogram](https://en.wikipedia.org/wiki/Nonogram), spočívající v obarvování bílé mřížky na základě zadaných instrukcí. Hra je implementována za pomocí knihovny `pygame`, která se stará o veškeré vykreslování GUI. 

Jedním z hlavních rozšíření této hry je možnost nahrát libovolný obrázek formátu PNG a nechat jej převést na samotnou hádanku. To umožní ve hře rychlé a jednoduché vytváření hádanek a velkou míru znovuhratelnosti.

Bližší informace o práci jako takové, jejím vývoji a možném rozšíření se nachází tzv. *reportu* v souboru `report.pdf`.

## Závislosti a instalace

Závislosti jsou popsány v souboru `requirements.txt`. Jediné velké externí balíčky, o které se práce opírá, jsou `pygame` (pro celé vykreslování GUI), `numpy` (pro práci s herními savy a víceméně veškeré operace s poli) a `PIL` (tj. *Python Imaging Library*; pro zpracování vstupního obrázku). Pro testování jsou dále využity balíčky `pytest`, `pylint` a `pyautogui`.

Proces instalace a spuštění:
- Ujistěte se, že se nacházíte v kořenovém adresáří.
- Nainstalujte veškeré závislosti pomocí příkazu `pip install -r requirements.txt`.
- Spusťte hru pomocí zadání příkazu `python onono` do příkazové řádky.
- Hru můžete ukončit tlačítkem v menu, zavřením okna nebo klávesovou zkratkou Ctrl+C v terminálu.

## Testování

Testovací soubory jsou obsaženy v adresáří `tests`. Některé z nich pracují i s vlastními herními savy (mezní případy nesprávných vstupů), takové jsou v adresáři `saves\tests`, resp. `saves\images\tests`. V souboru `test_lint` se nachází automatická kontrola linterem `pylint`, všechny moduly by měly (s vyjímkou uvedených odůvodněných varování) procházet na plné skóre, což znamená že zdrojový kód semestrální práce je v souladu s PEP 8.

Testy je možné spustit pomocí příkazu `pytest`, spuštěného v domovském adresáří.
