"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubjectAlternativeNames = exports.MutualTlsValidationTrust = exports.TlsValidationTrust = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Defines the TLS Validation Context Trust.
 */
class TlsValidationTrust {
    /**
     * Tells envoy where to fetch the validation context from
     */
    static file(certificateChain) {
        return new TlsValidationFileTrust(certificateChain);
    }
    /**
     * TLS Validation Context Trust for ACM Private Certificate Authority (CA).
     */
    static acm(certificateAuthorities) {
        return new TlsValidationAcmTrust(certificateAuthorities);
    }
    /**
     * TLS Validation Context Trust for Envoy' service discovery service.
     */
    static sds(secretName) {
        return new TlsValidationSdsTrust(secretName);
    }
}
exports.TlsValidationTrust = TlsValidationTrust;
_a = JSII_RTTI_SYMBOL_1;
TlsValidationTrust[_a] = { fqn: "@aws-cdk/aws-appmesh.TlsValidationTrust", version: "1.156.0" };
/**
 * Represents a TLS Validation Context Trust that is supported for mutual TLS authentication.
 */
class MutualTlsValidationTrust extends TlsValidationTrust {
    constructor() {
        super(...arguments);
        // TypeScript uses structural typing, so we need a property different from TlsValidationTrust
        this.differentiator = false;
    }
}
exports.MutualTlsValidationTrust = MutualTlsValidationTrust;
_b = JSII_RTTI_SYMBOL_1;
MutualTlsValidationTrust[_b] = { fqn: "@aws-cdk/aws-appmesh.MutualTlsValidationTrust", version: "1.156.0" };
class TlsValidationAcmTrust extends TlsValidationTrust {
    constructor(certificateAuthorities) {
        super();
        this.certificateAuthorities = certificateAuthorities;
    }
    bind(_scope) {
        if (this.certificateAuthorities.length === 0) {
            throw new Error('you must provide at least one Certificate Authority when creating an ACM Trust ClientPolicy');
        }
        else {
            return {
                tlsValidationTrust: {
                    acm: {
                        certificateAuthorityArns: this.certificateAuthorities.map(certificateArn => certificateArn.certificateAuthorityArn),
                    },
                },
            };
        }
    }
}
class TlsValidationFileTrust extends MutualTlsValidationTrust {
    constructor(certificateChain) {
        super();
        this.certificateChain = certificateChain;
    }
    bind(_scope) {
        return {
            tlsValidationTrust: {
                file: {
                    certificateChain: this.certificateChain,
                },
            },
        };
    }
}
class TlsValidationSdsTrust extends MutualTlsValidationTrust {
    constructor(secretName) {
        super();
        this.secretName = secretName;
    }
    bind(_scope) {
        return {
            tlsValidationTrust: {
                sds: {
                    secretName: this.secretName,
                },
            },
        };
    }
}
/**
 * Used to generate Subject Alternative Names Matchers
 */
class SubjectAlternativeNames {
    /**
     * The values of the SAN must match the specified values exactly.
     *
     * @param names The exact values to test against.
     */
    static matchingExactly(...names) {
        return new SubjectAlternativeNamesImpl({ exact: names });
    }
}
exports.SubjectAlternativeNames = SubjectAlternativeNames;
_c = JSII_RTTI_SYMBOL_1;
SubjectAlternativeNames[_c] = { fqn: "@aws-cdk/aws-appmesh.SubjectAlternativeNames", version: "1.156.0" };
class SubjectAlternativeNamesImpl extends SubjectAlternativeNames {
    constructor(matchProperty) {
        super();
        this.matchProperty = matchProperty;
    }
    bind(_scope) {
        return {
            subjectAlternativeNamesMatch: this.matchProperty,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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