# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sunix_ledstrip_controller_client', 'sunix_ledstrip_controller_client.packets']

package_data = \
{'': ['*']}

install_requires = \
['construct', 'typing']

setup_kwargs = {
    'name': 'sunix-ledstrip-controller-client',
    'version': '2.0.5',
    'description': 'A library for controlling the Sunix RGB / RGBWWCW WiFi LED Strip controller',
    'long_description': '.. |pypi_version| image:: https://badge.fury.io/py/sunix-ledstrip-controller-client.svg\n    :target: https://badge.fury.io/py/sunix-ledstrip-controller-client\n\nsunix-ledstrip-controller-client  |pypi_version|\n================================================\n\nA python 3.7+ library for controlling the Sunix® RGB / RGBWWCW WiFi LED Strip controller.\n\nBuild Status\n============\n\n.. |build_master| image:: https://travis-ci.org/markusressel/sunix-ledstrip-controller-client.svg?branch=master\n    :target: https://travis-ci.org/markusressel/sunix-ledstrip-controller-client/branches\n\n.. |build_beta| image:: https://travis-ci.org/markusressel/sunix-ledstrip-controller-client.svg?branch=beta\n    :target: https://travis-ci.org/markusressel/sunix-ledstrip-controller-client/branches\n\n.. |build_dev| image:: https://travis-ci.org/markusressel/sunix-ledstrip-controller-client.svg?branch=dev\n    :target: https://travis-ci.org/markusressel/sunix-ledstrip-controller-client/branches\n\n\n.. |codebeat_master| image:: https://codebeat.co/badges/9dd4227d-a247-4c9b-9091-7472f3e19434\n    :target: https://codebeat.co/projects/github-com-markusressel-sunix-ledstrip-controller-client-master\n\n.. |codebeat_beta| image:: https://codebeat.co/badges/68d80d07-2c69-4320-9f0a-02165dafae11\n    :target: https://codebeat.co/projects/github-com-markusressel-sunix-ledstrip-controller-client-beta\n\n.. |codebeat_dev| image:: https://codebeat.co/badges/256be541-3755-45f3-91ca-12f1257cd9a5\n    :target: https://codebeat.co/projects/github-com-markusressel-sunix-ledstrip-controller-client-dev\n\n+--------------------+------------------+-----------------+\n| Master             | Beta             | Dev             |\n+====================+==================+=================+\n| |build_master|     | |build_beta|     | |build_dev|     |\n+--------------------+------------------+-----------------+\n| |codebeat_master|  | |codebeat_beta|  | |codebeat_dev|  |\n+--------------------+------------------+-----------------+\n\n\nHow to use\n==========\n\nInstallation\n------------\n\n:code:`pip install sunix-ledstrip-controller-client`\n\nUsage\n-----\n\nFor a basic example have a look at the `example.py <https://github.com/markusressel/sunix-ledstrip-controller-client/blob/master/example.py>`_ file.\nIf you need more info have a look at the `documentation <http://sunix-ledstrip-controller-client.readthedocs.io/>`_ which should help.\n\nBasic Example\n=============\n\nCreate the :code:`LEDStripControllerClient` object\n--------------------------------------------------\n\nThe first thing you need to communicate with any controller is the api client.\nCreate one like this:\n\n.. code-block:: python\n\n    from sunix_ledstrip_controller_client import LEDStripControllerClient\n\n    api = LEDStripControllerClient()\n\nThe next thing you need is a :code:`Controller` object that specifies the basics about your Sunix controller hardware.\nYou can either let the api search automatically for your controller using:\n\n.. code-block:: python\n\n    devices = api.discover_controllers()\n\nor create one manually like this:\n\n.. code-block:: python\n\n    from sunix_ledstrip_controller_client import Controller\n    device = Controller(api, "192.168.2.23")\n\nor including a port if you want to access it from outside of your local network:\n\n.. code-block:: python\n\n    device = Controller(api, "my-dyndns-address.org", 12345)\n\nNote that you have to supply an api object so the Controller can fetch is state.\n\nTurn it on!\n-----------\n\nNow you have all that is needed to control your device. It\'s time to turn it on and off!\nUse this method to turn it on:\n\n.. code-block:: python\n\n    device.turn_on()\n\nand this to turn it off:\n\n.. code-block:: python\n\n    device.turn_off()\n\nMake it a rainbow (changing colors)\n-----------------------------------\n\nNow to the fun part. The RGB values and the WW (warm white and cold white) value can be adjusted\nseparately (while keeping the other value) or both at the same time.\n\nAll values have a valid range of :code:`0` to :code:`255`.\n\nIf you only want to change the RGB values use:\n\n.. code-block:: python\n\n    device.set_rgb(255, 255, 255)\n\nand this one if you only want to change the WW value:\n\n.. code-block:: python\n\n    device.set_ww(255, 255)\n\nTo set both at the same time use (you guessed it):\n\n.. code-block:: python\n\n    device.set_rgbww(255, 255, 255, 255, 255)\n\nFunctions\n---------\n\nThe official app for the Sunix controller offers 20 different functions that can be activated and customized in speed.\nThese functions are hardcoded in the controller so they can not be altered in any way.\nYou can activate them though using:\n\n.. code-block:: python\n\n    from sunix_ledstrip_controller_client import FunctionId\n    device.set_function(FunctionId.RED_GRADUAL_CHANGE, 240)\n\nFunction ids can be found in the :code:`FunctionId` enum class.\n\n**0 is slow - 255 is fast.**\n\nIn the network protocol the speed is actually reversed (0 is fast, 255 is slow) but I changed this for the sake of simplicity.\nYou should be aware though that the **speed curve seems to be exponential**. This means 255 is very fast but 240 is\nalready **a lot** slower.\n\nCustom Functions\n----------------\n\nAnother feature of the official app is to set a custom color loop with a custom transition and speed between the colors.\nSince v1.2.0 of this library you can set those too :)\n\nSimply have a look at the `example_custom_function.py <https://github.com/markusressel/sunix-ledstrip-controller-client/blob/master/example_custom_function.py>`_ file\nfor a detailed example.\n\nSet/Get Time\n------------\n\nThe Sunix® controller has a build in clock to be able to execute timer actions.\nCurrently there is no way to get or set timers with this library.\nYou can however get and set the current time of the controller.\n\nTo get the currently set time use:\n\n.. code-block:: python\n\n    time = device.get_time()\n\nNote that this might be :code:`None` though if you have never set a time for this controller before.\nTo set a new value use:\n\n.. code-block:: python\n\n    dt = datetime.datetime.now()\n    device.set_time(dt)\n\n\nAttributions\n============\n\nI want to give a huge shoutout to `Chris Mullins (alias sidoh) <https://github.com/sidoh>`_ and his\n`ledenet_api <https://github.com/sidoh/ledenet_api>`_ library. Although the protocol used by the sunix controller\nis not exactly the same to the one used by the LEDENET Magic UFO controller it\'s quite similar and his work was a\ngreat starting point for me.\n\nContributing\n============\n\nGithub is for social coding: if you want to write code, I encourage contributions through pull requests from forks\nof this repository. Create Github tickets for bugs and new features and comment on the ones that you are interested in.\n\nLicense\n=======\n\n::\n\n    sunix-ledstrip-controller-client by Markus Ressel\n    Copyright (C) 2017  Markus Ressel\n\n    This program is free software: you can redistribute it and/or modify\n    it under the terms of the GNU General Public License as published by\n    the Free Software Foundation, either version 3 of the License, or\n    (at your option) any later version.\n\n    This program is distributed in the hope that it will be useful,\n    but WITHOUT ANY WARRANTY; without even the implied warranty of\n    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n    GNU General Public License for more details.\n\n    You should have received a copy of the GNU General Public License\n    along with this program.  If not, see <http://www.gnu.org/licenses/>.\n\n',
    'author': 'Markus Ressel',
    'author_email': 'mail@markusressel.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/markusressel/sunix-ledstrip-controller-client',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
