def expand_urls(stub, rng):
    """
    Generate list of urls over range index given a service stub.

    :param stub: Url base string for map service.
    :param rng: List of numbers generated by range() call.
    :return: List of urls beginning in stub and ending in rng values.
    """
    urls = []
    for i in rng:
        urls.append(stub + str(i))
    return urls


# address layers for planning map
address_corvo = "https://gis.corvallisoregon.gov/pub2/rest/services/Base/CorvallisAddress/MapServer/0"
address_stub = (
    "https://gis.co.benton.or.us/arcgis/rest/services/Public/AddressService/MapServer/"
)
address_range = [2, 1, 0]
address_url = expand_urls(address_stub, address_range)
ADDRESS_URLS = [address_url[0]]
ADDRESS_URLS.append(address_url[1])
ADDRESS_URLS.append(address_corvo)
ADDRESS_URLS.append(address_url[2])


appraisal_stub = (
    "https://gis.co.benton.or.us/arcgis/rest/services/Public/Appraisal/MapServer/"
)
appraisal_range = range(1, 9)
APPRAISAL_URLS = expand_urls(appraisal_stub, appraisal_range)


# boundaries layer for planning map
boundary_stub = (
    "https://gis.co.benton.or.us/arcgis/rest/services/Public/Boundaries/MapServer/"
)
boundary_range = range(6, -1, -1)
BOUNDARY_URLS = expand_urls(boundary_stub, boundary_range)

eam_stub = (
    "https://gis.co.benton.or.us/arcgis/rest/services/Public/EAM_Service/MapServer/"
)
eam_rng = range(0, 9)
EAM_URLS = expand_urls(eam_stub, eam_rng)

eh_stub = "https://gis.co.benton.or.us/arcgis/rest/services/Public/EHMap/MapServer/"
eh_range = range(0, 7)
EH_URLS = expand_urls(eh_stub, eh_range)

hazard_stub = (
    "https://gis.co.benton.or.us/arcgis/rest/services/Public/HazardService/MapServer/"
)
hazard_range = range(0, 2)
HAZARD_URLS = expand_urls(hazard_stub, hazard_range)

natural_stub = (
    "https://gis.co.benton.or.us/arcgis/rest/services/Public/NaturalService/MapServer/"
)
natural_range = range(0, 6)
NATURAL_URLS = expand_urls(natural_stub, natural_range)

hydro_hucs = natural_stub + "0"
hydro_polys = natural_stub + "1"
hydro_lines = natural_stub + "2"
natural_soils = natural_stub + "3"
natural_wetlands = natural_stub + "5"

PUBLIC_LANDS_URL = "https://gis.co.benton.or.us/arcgis/rest/services/Public/PublicLandsService/MapServer/0"

PUBLIC_WATER_SYSTEM_URL = "https://gis.co.benton.or.us/arcgis/rest/services/Public/PublicWaterSystemService/MapServer/0"

elect_2021_stub = "https://gis.co.benton.or.us/arcgis/rest/services/Public/Redistricting2021/MapServer/"
elect_2021_rng = [0, 20, 21]
elect_districts_rng = range(1, 19)
ELECTION_URLS = expand_urls(elect_2021_stub, elect_2021_rng)
ELECTION_DISTRICTS_URLS = expand_urls(elect_2021_stub, elect_districts_rng)

ROADS_BC_URL = (
    "https://gis.co.benton.or.us/arcgis/rest/services/Public/Roads_BC/MapServer/0"
)

SLOPE_LIDAR_URL = (
    "https://gis.co.benton.or.us/arcgis/rest/services/Public/SlopeService/MapServer/0"
)

survey_stub = (
    "https://gis.co.benton.or.us/arcgis/rest/services/Public/SurveyService/MapServer/"
)
# survey_range = range(0, 9)
survey_range = [8, 7, 1, 6, 4, 2, 0]
SURVEY_URLS = expand_urls(survey_stub, survey_range)

TAXLOT_OWNERS_URL = (
    "https://gis.co.benton.or.us/arcgis/rest/services/Public/TaxlotOwners/MapServer/0"
)

taxlot_stub = (
    "https://gis.co.benton.or.us/arcgis/rest/services/Public/TaxlotService/MapServer/"
)
anno_0020_rng = range(1, 38)
anno_0050_rng = range(39, 76)
anno_0100_rng = range(77, 114)
anno_0200_rng = range(115, 150)
anno_0400_rng = range(151, 186)
taxlot_rng = range(186, 199)
ANNO_0020_URLS = expand_urls(taxlot_stub, anno_0020_rng)
ANNO_0050_URLS = expand_urls(taxlot_stub, anno_0050_rng)
ANNO_0100_URLS = expand_urls(taxlot_stub, anno_0100_rng)
ANNO_0200_URLS = expand_urls(taxlot_stub, anno_0200_rng)
ANNO_0400_URLS = expand_urls(taxlot_stub, anno_0400_rng)
layer_ord = [198, 194, 193, 192, 190, 189, 191, 186]
TAXLOT_URLS = expand_urls(taxlot_stub, layer_ord)


TAX_CODE_AREAS_URL = (
    "https://gis.co.benton.or.us/arcgis/rest/services/Public/TCAService/MapServer/0"
)

topo_stub = "https://gis.co.benton.or.us/arcgis/rest/services/Public/TopoServiceContours20ft/MapServer/"
topo_range = [3, 1, 2, 0]
TOPO_CONTOURS_URLS = expand_urls(topo_stub, topo_range)

transport_stub = "https://gis.co.benton.or.us/arcgis/rest/services/Public/TransportationService/MapServer/"
# transport_range = range(0, 5)
transport_range = [1, 3, 2, 4]
TRANSPORT_URLS = expand_urls(transport_stub, transport_range)

# zoning compliance map
compliance_stub = "https://gis.co.benton.or.us/arcgis/rest/services/Public/ZoningCompliance/MapServer/"
compliance_range = [0, 1, range(8, 16)]
COMPLIANCE_URLS = expand_urls(compliance_stub, compliance_range)
earthquake_faults = compliance_stub + "1"
big_game = compliance_stub + "8"
rip_buff = compliance_stub + "9"
shpo_buff = compliance_stub + "10"
bc_landslide = compliance_stub + "13"
bc_eq_slope = compliance_stub + "14"

# Blue Fender Butterfly Zone
butterfly_range = range(7, 2, -1)
HCP_BUTTERFLY_URLS = expand_urls(compliance_stub, butterfly_range)

# Zoning
zoning_stub = (
    "https://gis.co.benton.or.us/arcgis/rest/services/Public/ZoningService/MapServer/"
)
# zoning_range = range(0, 7)
zoning_range = range(6, -1, -1)
ZONING_URLS = expand_urls(zoning_stub, zoning_range)

ZONING_URLS_DRAFT = []
ZONING_URLS_DRAFT.append(
    "https://services5.arcgis.com/U7TbEknoCzTtNGz4/arcgis/rest/services/zoning_service_test/FeatureServer/4"
)
ZONING_URLS_DRAFT.append(ZONING_URLS[1])
ZONING_URLS_DRAFT.append(ZONING_URLS[2])
ZONING_URLS_DRAFT.append(ZONING_URLS[3])
ZONING_URLS_DRAFT.append(ZONING_URLS[5])
ZONING_URLS_DRAFT.append(
    "https://services5.arcgis.com/U7TbEknoCzTtNGz4/arcgis/rest/services/zoning_service_test/FeatureServer/2"
)
ZONING_URLS_DRAFT.append(
    "https://services5.arcgis.com/U7TbEknoCzTtNGz4/arcgis/rest/services/zoning_service_test/FeatureServer/0"
)

# web hosted county layers

NFI_HPSV = "35ce1b83017b4b4591fec665d7213499"
NFI_HPSV_TILES = "1ecbb53e004a4e82a3be15900e906d59"
NFI_HPSV_TILES_URL = "https://vectortileservices5.arcgis.com/U7TbEknoCzTtNGz4/arcgis/rest/services/tiles_nfi_incentive_vegetation/VectorTileServer/"
hpsv_stub = "https://services5.arcgis.com/U7TbEknoCzTtNGz4/arcgis/rest/services/tiles_nfi_incentive_vegetation/FeatureServer/"
hpsv_range = range(8, -1, -1)
NFI_HPSV_URLS = expand_urls(hpsv_stub, hpsv_range)

ppsv_range = range(15, 8, -1)
NFI_PPSV_URLS = expand_urls(hpsv_stub, ppsv_range)


# Corvallis Natural Features Inventory
nfi_fs_stub = "https://services5.arcgis.com/U7TbEknoCzTtNGz4/arcgis/rest/services/NaturalFeaturesInventoryService2022_DRAFT/FeatureServer/"
riparian_ord = range(29, 23, -1)
RIPARIAN_URLS = expand_urls(nfi_fs_stub, riparian_ord)

# replace wetlands within raas (squaw creek changed to dunawi creek)
# Wetlands Within RAAs
nfi_wwr = "https://services5.arcgis.com/U7TbEknoCzTtNGz4/arcgis/rest/services/nfi_locally_significant_wetlands/FeatureServer"
RIPARIAN_URLS[0] = nfi_wwr

# replace 100ft buffer
RIPARIAN_URLS[
    3
] = "https://services5.arcgis.com/U7TbEknoCzTtNGz4/arcgis/rest/services/riparian_buffer_100ft/FeatureServer"
RIPARIAN_100ft = "https://services5.arcgis.com/U7TbEknoCzTtNGz4/arcgis/rest/services/riparian_buffer_100ft/FeatureServer"

features_ord = [33, 31, 3]
FEATURES_URLS = expand_urls(nfi_fs_stub, features_ord)
# Locally Significant Wetlands
nfi_lsw = "https://services5.arcgis.com/U7TbEknoCzTtNGz4/arcgis/rest/services/nfi_locally_significant_wetlands/FeatureServer"

flood_ord = range(44, 35, -1)
NFI_FLOOD_URLS = expand_urls(nfi_fs_stub, flood_ord)

hazard_ord = [50, 48, 47, 46]
NFI_HAZARD_URLS = expand_urls(nfi_fs_stub, hazard_ord)

# Outside Resources

# Fish & Wildlife NWI Wetlands
fw_nwi_wetlands = (
    "https://www.fws.gov/wetlandsmapservice/rest/services/Wetlands/MapServer/0"
)

# NRCS Hydric Soils
# nrcs_hydric_soils = "https://gisdata.dsl.state.or.us/arcgis/rest/services/Maps/SWI_HydricSoil_2020_B/MapServer/0"
nrcs_hydric_soils = (
    "https://maps.dsl.state.or.us/arcgis/rest/services/HydricSoil/MapServer/0"
)

# OSU M49 Authorizations
osu_m49 = "https://lib-gis2.library.oregonstate.edu/arcgis/rest/services/land_use_planning/M49_2018/MapServer/0"


# add fw_nwi_wetlands
# add nrcs_hydric_soils
environment_urls = [
    nrcs_hydric_soils,
    natural_soils,
    natural_wetlands,
    fw_nwi_wetlands,
    bc_eq_slope,
    bc_landslide,
    shpo_buff,
    rip_buff,
    big_game,
    earthquake_faults,
    hydro_lines,
    hydro_polys,
    hydro_hucs,
]


# aerial imagery

# Corvallis
corvallis_image_2019 = {
    "id": "CorvallisAGI2019Orthos",
    "layerType": "ArcGISTiledMapServiceLayer",
    "url": "https://tiles.arcgis.com/tiles/NNPaUnXVoJt8FVVE/arcgis/rest/services/CorvallisAGI2019Orthos/MapServer",
    # "url": "https://gis.corvallisoregon.gov/pub2/rest/services/Imagery/Ortho_2019/ImageServer",
    "visibility": False,
    "opacity": 1,
    "title": "Aerial Photo - Corvallis (2019)",
    "itemId": "b6d1d578364d4d548f741d613a6201df",
    "showLegend": True,
    "layers": [],
}

corvallis_image_2021 = {
    "id": "Ortho_2021_6642",
    "layerType": "ArcGISImageServiceLayer",
    "url": "https://gis.corvallisoregon.gov/pub2/rest/services/Imagery/Ortho_2021/ImageServer",
    "visibility": False,
    "opacity": 1,
    "title": "Aerial Photo - Corvallis (2021)",
    "itemId": "71adc148d2ec43048fddd3d341ba6d61",
    "showLegend": True,
    "layers": [],
}

# esri

esri_imagery_stub = (
    "https://services.arcgisonline.com/arcgis/rest/services/World_Imagery/MapServer/"
)

esri_imagery_range = range(3, -1, -1)
esri_imagery_urls = expand_urls(esri_imagery_stub, esri_imagery_range)

esri_image_def = {
    "id": "World_Imagery_9777",
    "layerType": "ArcGISTiledMapServiceLayer",
    "url": "https://services.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer",
    "visibility": False,
    "opacity": 1,
    "title": "Aerial Photo - ESRI (2021)",
    "itemId": "10df2279f9684e4a9f6a7f08febac2a9",
    "showLegend": True,
    "layers": [],
}


# FEMA hazards

fema_nfhl_stub = (
    "https://hazards.fema.gov/gis/nfhl/rest/services/public/NFHL/MapServer/"
)
fema_nfhl_rng = [i for i in range(32, -1, -1) if i != 21]
fema_nfhlwms_stub = (
    "https://hazards.fema.gov/gis/nfhl/rest/services/public/NFHLWMS/MapServer/"
)
fema_nfhlwms_rng = range(1, 33)
FEMA_NFHL_URLS = expand_urls(fema_nfhl_stub, fema_nfhl_rng)
FEMA_NFHLWMS_URLS = expand_urls(fema_nfhlwms_stub, fema_nfhlwms_rng)

# Corvallis Address MapService
CORVALLIS_ADDRESS_URL = "https://gis.corvallisoregon.gov/pub2/rest/services/Base/CorvallisAddress/MapServer/0"

# aerial imagery
# esri
ESRI_IMAGERY_30CM = (
    "https://services.arcgisonline.com/arcgis/rest/services/World_Imagery/MapServer/3"
)

# benton 2014 aerial imagery
BC_IMAGERY_2014_URL = (
    "https://gis.co.benton.or.us/arcgis/rest/services/Public/Benton_2014/MapServer/0"
)
