"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextractPOCDecider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const sfn = require("aws-cdk-lib/aws-stepfunctions");
const tasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
/**
 * This construct takes in a manifest definition or a plain JSON with a s3Path:
 *
 * example s3Path:
 * {"s3Path": "s3://bucketname/prefix/image.png"}
 *
 *
 * Then it generated the numberOfPages attribute and the mime on the context.
 * The mime types checked against the supported mime types for Textract and if fails, will raise an Exception failing the workflow.
 *
 * Example (Python)
 * ```python
   decider_task_id = tcdk.TextractPOCDecider(
        self,
        f"InsuranceDecider",
   )
  ```

 *
 */
class TextractPOCDecider extends sfn.StateMachineFragment {
    constructor(parent, id, props) {
        super(parent, id);
        var lambdaMemoryMB = props.lambdaMemoryMB === undefined ? 1024 : props.lambdaMemoryMB;
        var lambdaTimeout = props.lambdaTimeout === undefined ? 900 : props.lambdaTimeout;
        const deciderFunction = new lambda.DockerImageFunction(this, 'TextractDecider', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/decider/')),
            architecture: lambda.Architecture.X86_64,
            memorySize: lambdaMemoryMB,
            timeout: aws_cdk_lib_1.Duration.seconds(lambdaTimeout),
        });
        deciderFunction.addToRolePolicy(new iam.PolicyStatement({ actions: ['s3:GetObject'], resources: ['*'] }));
        const deciderLambdaInvoke = new tasks.LambdaInvoke(this, id, {
            lambdaFunction: deciderFunction,
            timeout: aws_cdk_lib_1.Duration.seconds(100),
            outputPath: '$.Payload',
        });
        this.startState = deciderLambdaInvoke;
        this.endStates = [deciderLambdaInvoke];
    }
}
exports.TextractPOCDecider = TextractPOCDecider;
_a = JSII_RTTI_SYMBOL_1;
TextractPOCDecider[_a] = { fqn: "amazon-textract-idp-cdk-constructs.TextractPOCDecider", version: "0.0.8" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGV4dHJhY3REZWNpZGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3RleHRyYWN0RGVjaWRlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZCQUE2QjtBQUM3Qiw2Q0FBdUM7QUFDdkMsMkNBQTJDO0FBQzNDLGlEQUFpRDtBQUNqRCxxREFBcUQ7QUFDckQsNkRBQTZEO0FBUTdEOzs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBbUJHO0FBQ0gsTUFBYSxrQkFBbUIsU0FBUSxHQUFHLENBQUMsb0JBQW9CO0lBRzlELFlBQVksTUFBaUIsRUFBRSxFQUFVLEVBQUUsS0FBZ0M7UUFDekUsS0FBSyxDQUFDLE1BQU0sRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVsQixJQUFJLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsY0FBYyxDQUFDO1FBQ3RGLElBQUksYUFBYSxHQUFHLEtBQUssQ0FBQyxhQUFhLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxhQUFhLENBQUM7UUFFbEYsTUFBTSxlQUFlLEdBQUcsSUFBSSxNQUFNLENBQUMsbUJBQW1CLENBQUMsSUFBSSxFQUFFLGlCQUFpQixFQUFFO1lBQzlFLElBQUksRUFBRSxNQUFNLENBQUMsZUFBZSxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxvQkFBb0IsQ0FBQyxDQUFDO1lBQ3ZGLFlBQVksRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU07WUFDeEMsVUFBVSxFQUFFLGNBQWM7WUFDMUIsT0FBTyxFQUFFLHNCQUFRLENBQUMsT0FBTyxDQUFDLGFBQWEsQ0FBQztTQUN6QyxDQUFDLENBQUM7UUFDSCxlQUFlLENBQUMsZUFBZSxDQUFDLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQyxFQUFFLE9BQU8sRUFBRSxDQUFDLGNBQWMsQ0FBQyxFQUFFLFNBQVMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBRTFHLE1BQU0sbUJBQW1CLEdBQUcsSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLElBQUksRUFBRSxFQUFFLEVBQUU7WUFDM0QsY0FBYyxFQUFFLGVBQWU7WUFDL0IsT0FBTyxFQUFFLHNCQUFRLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQztZQUM5QixVQUFVLEVBQUUsV0FBVztTQUN4QixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsVUFBVSxHQUFDLG1CQUFtQixDQUFDO1FBQ3BDLElBQUksQ0FBQyxTQUFTLEdBQUMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7O0FBeEJILGdEQXlCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgeyBEdXJhdGlvbiB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCAqIGFzIGlhbSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtbGFtYmRhJztcbmltcG9ydCAqIGFzIHNmbiBmcm9tICdhd3MtY2RrLWxpYi9hd3Mtc3RlcGZ1bmN0aW9ucyc7XG5pbXBvcnQgKiBhcyB0YXNrcyBmcm9tICdhd3MtY2RrLWxpYi9hd3Mtc3RlcGZ1bmN0aW9ucy10YXNrcyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuZXhwb3J0IGludGVyZmFjZSBUZXh0cmFjdERQUE9DRGVjaWRlclByb3BzIHtcbiAgLyoqIG1lbW9yeSBvZiBMYW1iZGEgZnVuY3Rpb24gKG1heSBuZWVkIHRvIGluY3JlYXNlIGZvciBsYXJnZXIgZG9jdW1lbnRzKSAqL1xuICByZWFkb25seSBsYW1iZGFNZW1vcnlNQj86bnVtYmVyO1xuICByZWFkb25seSBsYW1iZGFUaW1lb3V0PzpudW1iZXI7XG59XG4vKipcbiAqIFRoaXMgY29uc3RydWN0IHRha2VzIGluIGEgbWFuaWZlc3QgZGVmaW5pdGlvbiBvciBhIHBsYWluIEpTT04gd2l0aCBhIHMzUGF0aDpcbiAqXG4gKiBleGFtcGxlIHMzUGF0aDpcbiAqIHtcInMzUGF0aFwiOiBcInMzOi8vYnVja2V0bmFtZS9wcmVmaXgvaW1hZ2UucG5nXCJ9XG4gKlxuICpcbiAqIFRoZW4gaXQgZ2VuZXJhdGVkIHRoZSBudW1iZXJPZlBhZ2VzIGF0dHJpYnV0ZSBhbmQgdGhlIG1pbWUgb24gdGhlIGNvbnRleHQuXG4gKiBUaGUgbWltZSB0eXBlcyBjaGVja2VkIGFnYWluc3QgdGhlIHN1cHBvcnRlZCBtaW1lIHR5cGVzIGZvciBUZXh0cmFjdCBhbmQgaWYgZmFpbHMsIHdpbGwgcmFpc2UgYW4gRXhjZXB0aW9uIGZhaWxpbmcgdGhlIHdvcmtmbG93LlxuICpcbiAqIEV4YW1wbGUgKFB5dGhvbilcbiAqIGBgYHB5dGhvblxuICAgZGVjaWRlcl90YXNrX2lkID0gdGNkay5UZXh0cmFjdFBPQ0RlY2lkZXIoXG4gICAgICAgIHNlbGYsXG4gICAgICAgIGZcIkluc3VyYW5jZURlY2lkZXJcIixcbiAgIClcbiAgYGBgXG5cbiAqXG4gKi9cbmV4cG9ydCBjbGFzcyBUZXh0cmFjdFBPQ0RlY2lkZXIgZXh0ZW5kcyBzZm4uU3RhdGVNYWNoaW5lRnJhZ21lbnQge1xuICBwdWJsaWMgcmVhZG9ubHkgc3RhcnRTdGF0ZTogc2ZuLlN0YXRlO1xuICBwdWJsaWMgcmVhZG9ubHkgZW5kU3RhdGVzOiBzZm4uSU5leHRhYmxlW107XG4gIGNvbnN0cnVjdG9yKHBhcmVudDogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogVGV4dHJhY3REUFBPQ0RlY2lkZXJQcm9wcykge1xuICAgIHN1cGVyKHBhcmVudCwgaWQpO1xuXG4gICAgdmFyIGxhbWJkYU1lbW9yeU1CID0gcHJvcHMubGFtYmRhTWVtb3J5TUIgPT09IHVuZGVmaW5lZCA/IDEwMjQgOiBwcm9wcy5sYW1iZGFNZW1vcnlNQjtcbiAgICB2YXIgbGFtYmRhVGltZW91dCA9IHByb3BzLmxhbWJkYVRpbWVvdXQgPT09IHVuZGVmaW5lZCA/IDkwMCA6IHByb3BzLmxhbWJkYVRpbWVvdXQ7XG5cbiAgICBjb25zdCBkZWNpZGVyRnVuY3Rpb24gPSBuZXcgbGFtYmRhLkRvY2tlckltYWdlRnVuY3Rpb24odGhpcywgJ1RleHRyYWN0RGVjaWRlcicsIHtcbiAgICAgIGNvZGU6IGxhbWJkYS5Eb2NrZXJJbWFnZUNvZGUuZnJvbUltYWdlQXNzZXQocGF0aC5qb2luKF9fZGlybmFtZSwgJy4uL2xhbWJkYS9kZWNpZGVyLycpKSxcbiAgICAgIGFyY2hpdGVjdHVyZTogbGFtYmRhLkFyY2hpdGVjdHVyZS5YODZfNjQsXG4gICAgICBtZW1vcnlTaXplOiBsYW1iZGFNZW1vcnlNQixcbiAgICAgIHRpbWVvdXQ6IER1cmF0aW9uLnNlY29uZHMobGFtYmRhVGltZW91dCksXG4gICAgfSk7XG4gICAgZGVjaWRlckZ1bmN0aW9uLmFkZFRvUm9sZVBvbGljeShuZXcgaWFtLlBvbGljeVN0YXRlbWVudCh7IGFjdGlvbnM6IFsnczM6R2V0T2JqZWN0J10sIHJlc291cmNlczogWycqJ10gfSkpO1xuXG4gICAgY29uc3QgZGVjaWRlckxhbWJkYUludm9rZSA9IG5ldyB0YXNrcy5MYW1iZGFJbnZva2UodGhpcywgaWQsIHtcbiAgICAgIGxhbWJkYUZ1bmN0aW9uOiBkZWNpZGVyRnVuY3Rpb24sXG4gICAgICB0aW1lb3V0OiBEdXJhdGlvbi5zZWNvbmRzKDEwMCksXG4gICAgICBvdXRwdXRQYXRoOiAnJC5QYXlsb2FkJyxcbiAgICB9KTtcbiAgICB0aGlzLnN0YXJ0U3RhdGU9ZGVjaWRlckxhbWJkYUludm9rZTtcbiAgICB0aGlzLmVuZFN0YXRlcz1bZGVjaWRlckxhbWJkYUludm9rZV07XG4gIH1cbn1cbiJdfQ==