"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextractClassificationConfigurator = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const dynamodb = require("aws-cdk-lib/aws-dynamodb");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const sfn = require("aws-cdk-lib/aws-stepfunctions");
const tasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
const cfnCustomResourceConfiguratorPrefill_1 = require("./cfnCustomResourceConfiguratorPrefill");
/**
 * Looks for a matching DOCYMENT_TYPE in the configurationTableName
 * and sets the CONFIG value (when found) to the context, so subsequent calls to
 * Textract use those values.
 *
 * This is an entry from the default config
 * AWS_PAYSTUBS,"{""queriesConfig"": [{""alias"": ""PAYSTUB_PERIOD_START_DATE"", ""text"": ""What is the Pay Period Start Date?""}, {""alias"": ""PAYSTUB_PERIOD_END_DATE"", ""text"": ""What is the Pay Period End Date?""}, {""alias"": ""PAYSTUB_PERIOD_PAY_DATE"", ""text"": ""What is the Pay Date?""}, {""alias"": ""PAYSTUB_PERIOD_EMPLOYEE_NAME"", ""text"": ""What is the Employee Name?""}, {""alias"": ""PAYSTUB_PERIOD_COMPANY_NAME"", ""text"": ""What is the company Name?""}, {""alias"": ""PAYSTUB_PERIOD_CURRENT_GROSS_PAY"", ""text"": ""What is the Current Gross Pay?""}, {""alias"": ""PAYSTUB_PERIOD_YTD_GROSS_PAY"", ""text"": ""What is the YTD Gross Pay?""}, {""alias"": ""PAYSTUB_PERIOD_REGULAR_HOURLY_RATE"", ""text"": ""What is the regular hourly rate?""}, {""alias"": ""PAYSTUB_PERIOD_HOLIDAY_RATE"", ""text"": ""What is the holiday rate?""}], ""textractFeatures"": [""QUERIES""]}"
 *
 * So, if the "classification"."documentType" in the Step Function Input is AWS_PAYSTUBS
 * then it will set the queriesConfig in the manifest for the subsequent Textract Calls in the Step Function flow
 *
 * Input: "classification"."documentType"
 * Output: config set to manifest
 *
 * Example (Python)
 * ```
    configurator_task = tcdk.TextractClassificationConfigurator(
        self, f"{workflow_name}-Configurator",
    )

 * ```
 */
class TextractClassificationConfigurator extends sfn.StateMachineFragment {
    constructor(parent, id, props) {
        super(parent, id);
        const configurationTable = new dynamodb.Table(this, 'TextractConfigurationTable', {
            partitionKey: {
                name: 'DOCUMENT_TYPE',
                type: dynamodb.AttributeType.STRING,
            },
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
            billingMode: dynamodb.BillingMode.PAY_PER_REQUEST,
        });
        this.configurationTableName = configurationTable.tableName;
        const textractDocTypeConfig = new cfnCustomResourceConfiguratorPrefill_1.TextractConfiguration(this, 'DocTypeConfig', {
            configuration_table: configurationTable.tableName,
        });
        textractDocTypeConfig.node.addDependency(configurationTable);
        var lambdaMemoryMB = props.lambdaMemoryMB === undefined ? 1024 : props.lambdaMemoryMB;
        var lambdaTimeout = props.lambdaTimeout === undefined ? 900 : props.lambdaTimeout;
        var lambdaLogLevel = props.lambdaLogLevel === undefined ? 'DEBUG' : props.lambdaLogLevel;
        this.configuratorFunction = new lambda.DockerImageFunction(this, 'ClassificationConfigurator', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/configurator/')),
            memorySize: lambdaMemoryMB,
            architecture: lambda.Architecture.X86_64,
            timeout: aws_cdk_lib_1.Duration.seconds(lambdaTimeout),
            environment: {
                CONFIGURATION_TABLE: configurationTable.tableName,
                LOG_LEVEL: lambdaLogLevel,
            },
        });
        this.configuratorFunction.addToRolePolicy(new iam.PolicyStatement({
            actions: ['dynamodb:PutItem', 'dynamodb:GetItem'],
            resources: [configurationTable.tableArn],
        }));
        this.configuratorFunctionLogGroupName = this.configuratorFunction.logGroup.logGroupName;
        const configuratorLambdaInvoke = new tasks.LambdaInvoke(this, id, {
            lambdaFunction: this.configuratorFunction,
            timeout: aws_cdk_lib_1.Duration.seconds(100),
            outputPath: '$.Payload',
        });
        this.startState = configuratorLambdaInvoke;
        this.endStates = [configuratorLambdaInvoke];
    }
}
exports.TextractClassificationConfigurator = TextractClassificationConfigurator;
_a = JSII_RTTI_SYMBOL_1;
TextractClassificationConfigurator[_a] = { fqn: "amazon-textract-idp-cdk-constructs.TextractClassificationConfigurator", version: "0.0.8" };
//# sourceMappingURL=data:application/json;base64,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