import logging

from peek_plugin_base.worker.PluginWorkerEntryHookABC import PluginWorkerEntryHookABC
from peek_plugin_docdb._private.storage.DeclarativeBase import loadStorageTuples
from peek_plugin_docdb._private.tuples import loadPrivateTuples
from peek_plugin_docdb._private.worker.tasks import ChunkCompilerTask, ImportTask
from peek_plugin_docdb.tuples import loadPublicTuples

logger = logging.getLogger(__name__)


class WorkerEntryHook(PluginWorkerEntryHookABC):
    def load(self):
        loadPrivateTuples()
        loadStorageTuples()
        loadPublicTuples()
        logger.debug("loaded")

    def start(self):
        logger.debug("started")

    def stop(self):
        logger.debug("stopped")

    def unload(self):
        logger.debug("unloaded")

    @property
    def celeryAppIncludes(self):
        return [ImportTask.__name__,
                ChunkCompilerTask.__name__]
