/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.common.sql.builtin.string;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.flink.table.functions.ScalarFunction;

public class UnixTimeStamp
extends ScalarFunction {
    public boolean isDeterministic() {
        return false;
    }

    public long eval() {
        return System.currentTimeMillis() / 1000L;
    }

    public Long eval(String in) {
        if (in == null) {
            return null;
        }
        return Timestamp.valueOf(in).getTime() / 1000L;
    }

    public Long eval(String in, String format) {
        if (in == null || format == null) {
            return null;
        }
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            date = sdf.parse(in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date.getTime() / 1000L;
    }
}

