# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Volume']


class Volume(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 billing_cycle: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 facility: Optional[pulumi.Input[str]] = None,
                 locked: Optional[pulumi.Input[bool]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 snapshot_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VolumeSnapshotPolicyArgs']]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a Volume resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] billing_cycle: The billing cycle, defaults to "hourly"
        :param pulumi.Input[str] description: Optional description for the volume
        :param pulumi.Input[str] facility: The facility to create the volume in
        :param pulumi.Input[bool] locked: Lock or unlock the volume
        :param pulumi.Input[str] plan: The service plan slug of the volume
        :param pulumi.Input[str] project_id: The packet project ID to deploy the volume in
        :param pulumi.Input[int] size: The size in GB to make the volume
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VolumeSnapshotPolicyArgs']]]] snapshot_policies: Optional list of snapshot policies
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['billing_cycle'] = billing_cycle
            __props__['description'] = description
            if facility is None:
                raise TypeError("Missing required property 'facility'")
            __props__['facility'] = facility
            __props__['locked'] = locked
            if plan is None:
                raise TypeError("Missing required property 'plan'")
            __props__['plan'] = plan
            if project_id is None:
                raise TypeError("Missing required property 'project_id'")
            __props__['project_id'] = project_id
            if size is None:
                raise TypeError("Missing required property 'size'")
            __props__['size'] = size
            __props__['snapshot_policies'] = snapshot_policies
            __props__['attachments'] = None
            __props__['created'] = None
            __props__['name'] = None
            __props__['state'] = None
            __props__['updated'] = None
        super(Volume, __self__).__init__(
            'packet:index/volume:Volume',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attachments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VolumeAttachmentArgs']]]]] = None,
            billing_cycle: Optional[pulumi.Input[str]] = None,
            created: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            facility: Optional[pulumi.Input[str]] = None,
            locked: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            plan: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            size: Optional[pulumi.Input[int]] = None,
            snapshot_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VolumeSnapshotPolicyArgs']]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            updated: Optional[pulumi.Input[str]] = None) -> 'Volume':
        """
        Get an existing Volume resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VolumeAttachmentArgs']]]] attachments: A list of attachments, each with it's own `href` attribute
        :param pulumi.Input[str] billing_cycle: The billing cycle, defaults to "hourly"
        :param pulumi.Input[str] created: The timestamp for when the volume was created
        :param pulumi.Input[str] description: Optional description for the volume
        :param pulumi.Input[str] facility: The facility to create the volume in
        :param pulumi.Input[bool] locked: Lock or unlock the volume
        :param pulumi.Input[str] name: The name of the volume
        :param pulumi.Input[str] plan: The service plan slug of the volume
        :param pulumi.Input[str] project_id: The packet project ID to deploy the volume in
        :param pulumi.Input[int] size: The size in GB to make the volume
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VolumeSnapshotPolicyArgs']]]] snapshot_policies: Optional list of snapshot policies
        :param pulumi.Input[str] state: The state of the volume
        :param pulumi.Input[str] updated: The timestamp for the last time the volume was updated
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["attachments"] = attachments
        __props__["billing_cycle"] = billing_cycle
        __props__["created"] = created
        __props__["description"] = description
        __props__["facility"] = facility
        __props__["locked"] = locked
        __props__["name"] = name
        __props__["plan"] = plan
        __props__["project_id"] = project_id
        __props__["size"] = size
        __props__["snapshot_policies"] = snapshot_policies
        __props__["state"] = state
        __props__["updated"] = updated
        return Volume(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def attachments(self) -> pulumi.Output[Sequence['outputs.VolumeAttachment']]:
        """
        A list of attachments, each with it's own `href` attribute
        """
        return pulumi.get(self, "attachments")

    @property
    @pulumi.getter(name="billingCycle")
    def billing_cycle(self) -> pulumi.Output[str]:
        """
        The billing cycle, defaults to "hourly"
        """
        return pulumi.get(self, "billing_cycle")

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[str]:
        """
        The timestamp for when the volume was created
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Optional description for the volume
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def facility(self) -> pulumi.Output[str]:
        """
        The facility to create the volume in
        """
        return pulumi.get(self, "facility")

    @property
    @pulumi.getter
    def locked(self) -> pulumi.Output[Optional[bool]]:
        """
        Lock or unlock the volume
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the volume
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[str]:
        """
        The service plan slug of the volume
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The packet project ID to deploy the volume in
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[int]:
        """
        The size in GB to make the volume
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="snapshotPolicies")
    def snapshot_policies(self) -> pulumi.Output[Optional[Sequence['outputs.VolumeSnapshotPolicy']]]:
        """
        Optional list of snapshot policies
        """
        return pulumi.get(self, "snapshot_policies")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the volume
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def updated(self) -> pulumi.Output[str]:
        """
        The timestamp for the last time the volume was updated
        """
        return pulumi.get(self, "updated")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

