from .types import Model, SampleParam

_ANTHROPIC_MODELS = [
    Model(
        id="claude-opus-4-5",
        provider="claude",
        name="Claude 4.5 Opus",
        description="Premium model combining maximum intelligence with practical performance",
        capabilities=["thinking", "tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=5.0,
        output_token_price_1m=25.0,
    ),
    Model(
        id="claude-opus-4-1",
        provider="claude",
        name="Claude 4.1 Opus",
        description="Exceptional model for specialized reasoning tasks",
        capabilities=["thinking", "tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=15.0,
        output_token_price_1m=75.0,
    ),
    Model(
        id="claude-sonnet-4-5",
        provider="claude",
        name="Claude 4.5 Sonnet",
        description="Our smartest model for complex agents and coding",
        capabilities=["thinking", "tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=3.0,
        output_token_price_1m=15.0,
    ),
    Model(
        id="claude-haiku-4-5",
        provider="claude",
        name="Claude 4.5 Haiku",
        description="Our fastest model with near-frontier intelligence",
        capabilities=["tool_use", "vision", "stream", "thinking"],
        input_token_price_1m=0.8,
        output_token_price_1m=4.0,
    ),
]

_OPENAI_MODELS = [
    Model(
        id="gpt-5",
        provider="openai",
        name="GPT-5",
        description="GPT-5 is our flagship model for coding, reasoning, and agentic tasks across domains",
        capabilities=["tool_use", "vision", "thinking", "stream", "structured_output"],
        input_token_price_1m=1.25,
        output_token_price_1m=10,
        default=True,
    ),
    Model(
        id="gpt-5-codex",
        provider="openai",
        name="GPT-5 Codex",
        description="GPT-5-Codex is a version of GPT-5 optimized for agentic coding tasks in Codex or similar environments",
        capabilities=["tool_use", "vision", "thinking", "stream", "structured_output"],
        input_token_price_1m=1.25,
        output_token_price_1m=10,
    ),
    Model(
        id="gpt-5.1",
        provider="openai",
        name="GPT-5.1",
        description="GPT-5 is our flagship model for coding, reasoning, and agentic tasks across domains",
        capabilities=["tool_use", "vision", "thinking", "stream", "structured_output"],
        max_context_token=400_000,
        input_token_price_1m=1.25,
        output_token_price_1m=10,
    ),
    Model(
        id="gpt-5.1-codex",
        provider="openai",
        name="GPT-5.1 Codex",
        description="GPT-5-Codex is a version of GPT-5 optimized for agentic coding tasks in Codex or similar environments",
        capabilities=["tool_use", "vision", "thinking", "stream", "structured_output"],
        input_token_price_1m=1.25,
        output_token_price_1m=10,
    ),
    Model(
        id="gpt-5.1-codex-mini",
        provider="openai",
        name="GPT-5.1 Codex Mini",
        description="GPT-5-Codex is a version of GPT-5 optimized for agentic coding tasks in Codex or similar environments",
        capabilities=["tool_use", "vision", "thinking", "stream", "structured_output"],
        input_token_price_1m=0.25,
        output_token_price_1m=2.0,
    ),
    Model(
        id="gpt-5.1-codex-max",
        provider="openai",
        name="GPT-5.1 Codex Max",
        description="GPT‑5.1-Codex-Max is purpose-built for agentic coding",
        capabilities=["tool_use", "vision", "thinking", "stream", "structured_output"],
        input_token_price_1m=1.25,
        output_token_price_1m=10.0,
    ),
    Model(
        id="gpt-4.1-mini",
        provider="openai",
        name="GPT-4.1 Mini",
        description="small, quick GPT model",
        capabilities=["tool_use", "vision", "stream", "structured_output"],
        input_token_price_1m=0.15,
        output_token_price_1m=0.6,
    ),
    Model(
        id="gpt-4.1",
        provider="openai",
        name="GPT-4.1",
        description="Flagship model for complex tasks. It is well suited for problem solving across domains",
        capabilities=["tool_use", "vision", "stream", "structured_output"],
        input_token_price_1m=2,
        output_token_price_1m=8,
    ),
    Model(
        id="o3-mini",
        provider="openai",
        name="GPT o3 mini",
        description="Fast, flexible, intelligent reasoning model",
        capabilities=["thinking", "stream", "structured_output"],
        input_token_price_1m=1.1,
        output_token_price_1m=4.4,
    ),
    Model(
        id="o4-mini",
        provider="openai",
        name="GPT o4 mini",
        description="o4-mini is our latest small o-series model. It's optimized for fast, effective reasoning with exceptionally efficient performance in coding and visual tasks.",
        capabilities=["thinking", "tool_use", "vision", "stream", "structured_output"],
        input_token_price_1m=1.1,
        output_token_price_1m=4.4,
    ),
    Model(
        id="o3",
        provider="openai",
        name="GPT o3",
        description="a well-rounded and powerful model across domains. It sets a new standard for math, science, coding, and visual reasoning tasks. ",
        capabilities=["thinking", "tool_use", "vision", "stream", "structured_output"],
        input_token_price_1m=2.0,
        output_token_price_1m=8.0,
    ),
]

_GROQ_MODELS = [
    Model(
        id="compound-beta",
        provider="groq",
        name="Agentic Tooling model",
        description="Groq's first compound models with tooling",
        capabilities=["thinking"],
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="deepseek-r1-distill-llama-70b",
        provider="groq",
        name="DeepSeek R1 Distill",
        description="DeepSeek's powerful model optimized for Groq",
        capabilities=["thinking", "tool_use"],
        input_token_price_1m=0.75,
        output_token_price_1m=0.99,
    ),
    Model(
        id="llama-3.3-70b-versatile",
        provider="groq",
        name="Llama 3.3 70B",
        description="Meta's Llama 3 70B model optimized for Groq",
        capabilities=["tool_use"],
        input_token_price_1m=0.59,
        output_token_price_1m=0.79,
    ),
    Model(
        id="meta-llama/llama-4-scout-17b-16e-instruct",
        provider="groq",
        name="Llama 4 Scout",
        description="The Llama 4 collection of models are natively multimodal AI models that enable text and multimodal experiences. These models leverage a mixture-of-experts architecture to offer industry-leading performance in text and image understanding.",
        capabilities=["tool_use", "vision"],
        input_token_price_1m=0.11,
        output_token_price_1m=0.34,
    ),
    Model(
        id="meta-llama/llama-4-maverick-17b-128e-instruct",
        provider="groq",
        name="Llama 4 Maverick",
        description="The Llama 4 collection of models are natively multimodal AI models that enable text and multimodal experiences. These models leverage a mixture-of-experts architecture to offer industry-leading performance in text and image understanding.",
        capabilities=["tool_use"],
        input_token_price_1m=0.5,
        output_token_price_1m=0.77,
    ),
    Model(
        id="openai/gpt-oss-120b",
        provider="groq",
        name="GPT OSS 120B",
        description="OpenAI's flagship open-weight MoE model with 120B total parameters",
        capabilities=["tool_use"],
        default=False,
        input_token_price_1m=0.15,
        output_token_price_1m=0.75,
    ),
    Model(
        id="moonshotai/kimi-k2-instruct",
        provider="groq",
        name="Kimi K2 Instruct",
        description="Kimi K2 is Moonshot AI's state-of-the-art Mixture-of-Experts (MoE) language model with 1 trillion total parameters and 32 billion activated parameters",
        capabilities=["tool_use", "stream"],
        default=False,
        input_token_price_1m=1.0,
        output_token_price_1m=3.0,
    ),
]

_GOOGLE_MODELS = [
    Model(
        id="gemini-2.5-flash-lite",
        provider="google",
        name="Gemini 2.5 Lite",
        description="Gemini 2.0 Flash Lite is low latancy, balanced language model from Google, designed for both text and visual inputs.",
        max_context_token=1_000_000,
        capabilities=["tool_use", "vision", "structured_output"],
        input_token_price_1m=0.1,
        output_token_price_1m=0.4,
    ),
    Model(
        id="gemini-2.5-flash",
        provider="google",
        max_context_token=1_000_000,
        name="Gemini 2.5 Flash ",
        description="Gemini 2.5 Flash is Google's first fully hybrid reasoning AI model, designed for high speed and cost-efficiency, allowing developers to toggle advanced reasoning on or off as needed.",
        capabilities=["tool_use", "vision", "thinking", "structured_output"],
        input_token_price_1m=0.3,
        output_token_price_1m=2.5,
        default=True,
    ),
    Model(
        id="gemini-2.5-pro",
        provider="google",
        name="Gemini 2.5 Pro Thinking",
        max_context_token=1_000_000,
        description="Gemini 2.5 Pro with thinking",
        capabilities=["tool_use", "thinking", "vision", "structured_output"],
        input_token_price_1m=1.25,
        output_token_price_1m=10,
    ),
    Model(
        id="gemini-3-pro-preview",
        provider="google",
        name="Gemini 3 Pro",
        max_context_token=1_000_000,
        description="Google's most intelligent model family to date, built on a foundation of state-of-the-art reasoning",
        capabilities=["tool_use", "thinking", "vision", "structured_output"],
        force_sample_params=SampleParam(temperature=1.0),
        input_token_price_1m=2,
        output_token_price_1m=12,
    ),
]

_DEEPINFRA_MODELS = [
    Model(
        id="google/gemma-3-27b-it",
        provider="deepinfra",
        name="Gemma 3 27B",
        description="Gemma is a family of lightweight, state-of-the-art open models from Google, built from the same research and technology used to create the Gemini models",
        capabilities=["tool_use", "stream", "structured_output"],
        input_token_price_1m=0.1,
        output_token_price_1m=0.2,
    ),
    Model(
        id="openai/gpt-oss-120b",
        provider="deepinfra",
        name="GPT-OSS 120B",
        description="gpt-oss-120b is an open-weight, 117B-parameter Mixture-of-Experts (MoE) language model from OpenAI designed for high-reasoning, agentic, and general-purpose production use cases",
        capabilities=["tool_use", "stream", "thinking"],
        input_token_price_1m=0.09,
        output_token_price_1m=0.45,
    ),
    Model(
        id="Qwen/Qwen3-Coder-480B-A35B-Instruct",
        provider="deepinfra",
        name="Qwen 3 Coder",
        description="Qwen3-Coder-480B-A35B-Instruct is the Qwen3's most agentic code model",
        capabilities=["tool_use", "stream", "structured_output"],
        force_sample_params=SampleParam(
            temperature=0.7, top_p=0.8, top_k=20, repetition_penalty=1.05
        ),
        input_token_price_1m=0.4,
        output_token_price_1m=1.6,
    ),
    Model(
        id="Qwen/Qwen3-Next-80B-A3B-Instruct",
        provider="deepinfra",
        name="Qwen 3 Coder",
        description="Qwen3-Coder-480B-A35B-Instruct is the Qwen3's most agentic code model",
        capabilities=["tool_use", "stream", "structured_output"],
        force_sample_params=SampleParam(
            temperature=0.7, top_p=0.8, top_k=20, min_p=0.0
        ),
        input_token_price_1m=0.14,
        output_token_price_1m=1.1,
    ),
    Model(
        id="Qwen/Qwen3-235B-A22B-Thinking-2507",
        provider="deepinfra",
        name="Qwen 3 MoE 235B-22B",
        description="Qwen3 is the latest generation of large language models in Qwen series, offering a comprehensive suite of dense and mixture-of-experts (MoE) models",
        capabilities=["tool_use", "thinking", "stream", "structured_output"],
        force_sample_params=SampleParam(
            temperature=0.6, top_p=0.95, top_k=20, min_p=0.0
        ),
        input_token_price_1m=0.2,
        output_token_price_1m=0.6,
    ),
    Model(
        id="zai-org/GLM-4.6",
        provider="deepinfra",
        name="Zai GLM-4.6",
        description="The GLM-4.6 series models are foundation models designed for intelligent agents",
        force_sample_params=SampleParam(temperature=1, top_p=0.95, top_k=40),
        capabilities=["tool_use", "stream", "structured_output"],
        input_token_price_1m=0.6,
        output_token_price_1m=2.0,
    ),
    Model(
        id="Qwen/Qwen3-32B",
        provider="deepinfra",
        name="Qwen 3 32B",
        description="Qwen3 is the latest generation of large language models in Qwen series, offering a comprehensive suite of dense and mixture-of-experts (MoE) models",
        capabilities=["tool_use", "stream", "structured_output"],
        force_sample_params=SampleParam(
            temperature=0.6, top_p=0.95, top_k=20, min_p=0.0
        ),
        input_token_price_1m=0.1,
        output_token_price_1m=0.3,
    ),
    Model(
        id="deepseek-ai/DeepSeek-V3.1-Terminus",
        provider="deepinfra",
        name="DeepSeek V3.1",
        description="DeepSeek-V3.1 is post-trained on the top of DeepSeek-V3.1-Base, which is built upon the original V3 base checkpoint through a two-phase long context extension approach",
        capabilities=["tool_use", "stream", "structured_output"],
        input_token_price_1m=0.3,
        output_token_price_1m=1.0,
    ),
    Model(
        id="deepseek-ai/DeepSeek-R1-0528",
        provider="deepinfra",
        name="DeepSeek R1 0528",
        description="The DeepSeek R1 model has undergone a minor version upgrade, with the current version being DeepSeek-R1-0528.",
        capabilities=["tool_use", "thinking", "stream", "structured_output"],
        force_sample_params=SampleParam(temperature=0.6),
        input_token_price_1m=0.5,
        output_token_price_1m=2.18,
    ),
    Model(
        id="moonshotai/Kimi-K2-Instruct-0905",
        provider="deepinfra",
        name="Kimi K2 Instruct",
        description="Kimi K2 is a large-scale Mixture-of-Experts (MoE) language model developed by Moonshot AI, featuring 1 trillion total parameters with 32 billion active per forward pass",
        capabilities=["tool_use", "stream", "structured_output"],
        force_sample_params=SampleParam(temperature=0.6),
        input_token_price_1m=0.5,
        output_token_price_1m=2.0,
    ),
]
_GITHUB_COPILOT_MODELS = [
    Model(
        id="claude-haiku-4.5",
        provider="github_copilot",
        name="Claude 4.5 Haiku",
        description="",
        capabilities=["tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="gemini-2.5-pro",
        provider="github_copilot",
        name="Gemini 2.5 Pro",
        description="",
        capabilities=["tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="gemini-3-pro-preview",
        provider="github_copilot",
        name="Gemini 3 Pro",
        description="",
        capabilities=["tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=0.0,
        force_sample_params=SampleParam(temperature=1.0),
        output_token_price_1m=0.0,
    ),
    Model(
        id="gpt-4.1",
        provider="github_copilot",
        name="GPT 4.1",
        description="",
        capabilities=["tool_use", "vision", "stream", "structured_output"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="grok-code-fast-1",
        provider="github_copilot",
        name="Grok Code Fast 1",
        description="",
        capabilities=["tool_use", "vision", "stream", "structured_output"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="gpt-4o",
        provider="github_copilot",
        name="GPT 4o",
        description="",
        capabilities=["tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="gpt-5",
        provider="github_copilot",
        name="GPT 5",
        description="",
        capabilities=["tool_use", "vision", "stream", "structured_output"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="gpt-5-codex",
        provider="copilot_response",
        name="GPT 5 Codex",
        description="",
        capabilities=["tool_use", "vision", "stream", "structured_output"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
        endpoint="response",
    ),
    Model(
        id="gpt-5.1-codex-max",
        provider="copilot_response",
        name="GPT 5.1 Codex Max",
        description="",
        capabilities=["tool_use", "vision", "stream", "structured_output"],
        default=False,
        max_context_token=400_000,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
        endpoint="response",
    ),
    Model(
        id="gpt-5-mini",
        provider="github_copilot",
        name="GPT 5 mini",
        description="",
        capabilities=["tool_use", "vision", "stream", "thinking", "structured_output"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="gpt-5.1",
        provider="github_copilot",
        name="GPT 5.1",
        description="",
        capabilities=["tool_use", "vision", "stream", "structured_output"],
        max_context_token=264_000,
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="gpt-5.1-codex",
        provider="copilot_response",
        name="GPT 5 Codex",
        description="",
        capabilities=["tool_use", "vision", "stream", "structured_output"],
        max_context_token=400_000,
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
        endpoint="response",
    ),
    Model(
        id="gpt-5.1-codex-mini",
        provider="github_copilot",
        name="GPT 5 mini",
        description="",
        capabilities=["tool_use", "vision", "stream", "thinking", "structured_output"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
        endpoint="response",
    ),
    Model(
        id="oswe-vscode-prime",
        provider="github_copilot",
        name="Raptor mini",
        max_context_token=200_000,
        description="",
        capabilities=["tool_use", "vision", "stream", "structured_output"],
        default=True,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="claude-sonnet-4",
        provider="github_copilot",
        name="Claude Sonnet 4",
        description="",
        capabilities=["tool_use", "vision", "stream", "thinking"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="claude-sonnet-4.5",
        provider="github_copilot",
        name="Claude Sonnet 4.5",
        description="",
        capabilities=["tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="claude-opus-41",
        provider="github_copilot",
        name="Claude Opus 4.1 (Preview)",
        description="",
        capabilities=["tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="claude-opus-4.5",
        provider="github_copilot",
        name="Claude Opus 4.5 (Preview)",
        description="",
        capabilities=["tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
]
AVAILABLE_MODELS = (
    _ANTHROPIC_MODELS
    + _OPENAI_MODELS
    + _GROQ_MODELS
    + _GOOGLE_MODELS
    + _DEEPINFRA_MODELS
    + _GITHUB_COPILOT_MODELS
)
