from descarteslabs.common.dotdict import DotDict
import json
import numpy as np

# flake8: noqa: E501

# this file contains mock data for the Metadata and Raster services, extracted from the production
# services, which is shared across multiple tests in this directory.

METADATA = {
    "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1": '{"acquired": "2016-07-06T16:59:42.753476Z", "cs_code": "EPSG:32615", "product": "landsat:LC08:PRE:TOAR", "bits_per_pixel": [0.836, 1.767, 0.804], "id": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "cloud_fraction": 0.5646, "solar_azimuth_angle": 131.36710631, "bright_fraction": 0.2848, "file_sizes": [49721086, 43577223], "area": 35619.4, "terrain_correction": "L1T", "cloud_fraction_0": 0.3264, "ction": 0.6319, "raster_size": [15696, 15960], "reflectance_scale": [0.1781, 0.1746, 0.1907, 0.2252, 0.3711, 1.4732, 4.5285, 0.903, 0.1999], "files": ["2016-07-06_027031_L8_432.jp2", "2016-07-06_027031_L8_567_19a.jp2"], "geolocation_accuracy": 4.958, "solar_elevation_angle": 64.12277058, "confidence_dlsr": 1.0, "descartes_version": "hedj-landsat-0.9.7.4", "key": "meta_LC80270312016188_v1", "roll_angle": -0.001, "tile_id": "027031", "sw_version": "LPGS_2.6.2", "identifier": "LC80270312016188LGN00.tar.bz", "projcs": "WGS 84 / UTM zone 15N", "geometry": {"type": "Polygon", "coordinates": [[[-95.2989209, 42.7999878], [-93.1167728, 42.3858464], [-93.7138666, 40.703737], [-95.8364984, 41.1150618], [-95.2989209, 42.7999878]]]}, "bucket": ["gs://descartes-l8/", "gs://descartes-l8/"], "file_md5s": ["5b12fa74275aee3234428fc996429256", "efb979aeda1b2fbd58fd689f84540165"], "processed": 1468251918, "published": "2016-07-06T23:11:30Z", "sat_id": "LANDSAT_8", "geotrans": [258292.5, 15.0, 0.0, 4743307.5, 0.0, -15.0]}',  # noqa
    "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1": '{"acquired": "2016-07-15T16:53:59.495435Z", "cs_code": "EPSG:32615", "product": "landsat:LC08:PRE:TOAR", "bits_per_pixel": [1.022, 2.61, 0.804], "id": "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1", "cloud_fraction": 0.1705, "solar_azimuth_angle": 129.79642888, "bright_fraction": 0.0571, "file_sizes": [60751671, 56534564], "area": 35599.3, "terrain_correction": "L1T", "cloud_fraction_0": 0.0947, "ction": 0.6439, "raster_size": [15536, 15816], "reflectance_scale": [0.1786, 0.1751, 0.1913, 0.2258, 0.3721, 1.4773, 4.5414, 0.9055, 0.2005], "files": ["2016-07-15_026032_L8_432.jp2", "2016-07-15_026032_L8_567_19a.jp2"], "geolocation_accuracy": 4.269, "solar_elevation_angle": 63.72682179, "confidence_dlsr": 1.0, "descartes_version": "hedj-landsat-0.9.7.4", "key": "meta_LC80260322016197_v1", "roll_angle": -0.001, "tile_id": "026032", "sw_version": "LPGS_2.6.2", "identifier": "LC80260322016197LGN00.tar.bz", "projcs": "WGS 84 / UTM zone 15N", "geometry": {"type": "Polygon", "coordinates": [[[-94.2036617, 41.3717716], [-92.0686956, 40.9629603], [-92.6448116, 39.2784859], [-94.724166, 39.6850062], [-94.2036617, 41.3717716]]]}, "bucket": ["gs://descartes-l8/", "gs://descartes-l8/"], "file_md5s": ["c80038509ca5572ecdba473bc3931fab", "92b10252278663b0b2d438bfa6c6b494"], "processed": 1469372319, "published": "2016-07-22T04:49:40Z", "sat_id": "LANDSAT_8", "geotrans": [348592.5, 15, 0, 4582807.5, 0, -15]}',  # noqa
    "modis:mod11a2:006:meta_MOD11A2.A2017305.h09v05.006.2017314042814_v1": '{"acquired": "2017-11-01T00:00:00+00:00","area": 1236433958410.1,"bits_per_pixel": [16.24028611111111, 2.332976111111111],"bucket": ["dl-satin_modis-mod11a2-006_r", "dl-satin_modis-mod11a2-006_r"], "descartes_version": "satin-v1", "directory": ["modis:mod11a2:006", "modis:mod11a2:006"], "file_md5s": ["dcab9cdeace57fa4a275e51892e1d95f", "6c026381b1e03c6b2ddbdda96a4358c0"], "file_sizes": [5846503, 4199357], "files": ["MOD11A2.A2017305.h09v05.006.2017314042814.UInt16.tif", "MOD11A2.A2017305.h09v05.006.2017314042814.Byte.tif"], "fill_fraction": 0.9842958333333334,"geometry": {      "coordinates": [[[-117.48665603990703, 39.999999999999154], [-104.4325831465788, 39.999999999999154], [-102.94076527145069, 38.99999999999963], [-102.22229259882958, 38.49999999999986], [-100.83779312081948, 37.500000000000334], [-99.52020554825341, 36.5000000000008], [-97.66196710091624, 35.00000000000151], [-96.49743588031265, 34.00000000000198], [-94.85512379473369, 32.500000000002686], [-93.82621572912193, 31.50000000000316], [-92.37604307034178, 30.000000000003865], [-103.92304845413969, 30.000000000003865], [-105.55449269526743, 31.50000000000316], [-106.71201426908073, 32.500000000002686], [-108.55961536535716, 34.00000000000198], [-109.86971298853625, 35.00000000000151], [-111.24611797498575, 36.00000000000104], [-111.96023124179068, 36.5000000000008], [-113.4425172609276, 37.500000000000334], [-115.00007917368902, 38.49999999999986], [-115.8083609303878, 38.99999999999963], [-117.48665603990703, 39.999999999999154]]],  "type": "Polygon"},"geotrans": [-10007554.677899, 926.6254331391661, 0.0, 4447802.079066, 0.0, -926.6254331383334],"id": "modis:mod11a2:006:meta_MOD11A2.A2017305.h09v05.006.2017314042814_v1","identifier": "MOD11A2.A2017305.h09v05.006.2017314042814","key": "meta_MOD11A2.A2017305.h09v05.006.2017314042814_v1","modified": "2018-11-12T03:25:33.871326+00:00","owner_type": "core","processed": "2018-11-12T03:25:31+00:00","product": "modis:mod11a2:006","proj4": "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6371007.181 +b=6371007.181 +units=m +no_defs ","published": "2017-11-10T00:00:00+00:00","raster_size": [1200, 1200],"sat_id": "modis"}',  # noqa
    "modis:mod11a2:006:meta_MOD11A2.A2000049.h08v05.006.2015058135046_v1": '{"acquired": "2000-02-18T00:00:00+00:00", "area": 1236433958407.88, "bits_per_pixel": [5.416830555555555, 0.8889755555555555], "bucket": ["dl-satin_modis-mod11a2-006_r", "dl-satin_modis-mod11a2-006_r"], "descartes_version": "satin-v1", "directory": ["modis:mod11a2:006", "modis:mod11a2:006"], "file_md5s": ["19ab952b0ee2997a26cc854b0b1225ba", "7cdcc274be7bd6b0a206949cc8978ced"], "file_sizes": [1950059, 1600156], "files": ["MOD11A2.A2000049.h08v05.006.2015058135046.UInt16.tif", "MOD11A2.A2000049.h08v05.006.2015058135046.Byte.tif"], "fill_fraction": 0.5317729166666667, "geometry": {"coordinates": [[[-130.5407289332235, 39.999999999999154], [-117.48665603990703, 39.999999999999154], [-115.8083609303878, 38.99999999999963], [-115.00007917368902, 38.49999999999986], [-113.4425172609276, 37.500000000000334], [-111.96023124179068, 36.5000000000008], [-111.24611797498575, 36.00000000000104], [-109.86971298853625, 35.00000000000151], [-108.55961536535716, 34.00000000000198], [-106.71201426908073, 32.500000000002686], [-105.55449269526743, 31.50000000000316], [-103.92304845413969, 30.000000000003865], [-115.47005383792722, 30.000000000003865], [-117.28276966140238, 31.50000000000316], [-118.56890474341712, 32.500000000002686], [-119.92049433351035, 33.50000000000222], [-120.6217948503908, 34.00000000000198], [-122.0774588761453, 35.00000000000151], [-123.606797749978, 36.00000000000104], [-124.40025693531675, 36.5000000000008], [-126.04724140102435, 37.500000000000334], [-127.77786574853697, 38.49999999999986], [-128.67595658931336, 38.99999999999963], [-130.5407289332235, 39.999999999999154]]], "type": "Polygon"}, "geotrans": [-11119505.197665, 926.6254331383342, 0.0, 4447802.079066, 0.0, -926.6254331383334], "id": "modis:mod11a2:006:meta_MOD11A2.A2000049.h08v05.006.2015058135046_v1", "identifier": "MOD11A2.A2000049.h08v05.006.2015058135046", "key": "meta_MOD11A2.A2000049.h08v05.006.2015058135046_v1", "modified": "2018-11-15T21:12:31.874628+00:00", "owner_type": "core", "processed": "2018-11-15T21:12:30+00:00", "product": "modis:mod11a2:006", "proj4": "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6371007.181 +b=6371007.181 +units=m +no_defs ", "published": "2015-02-27T00:00:00+00:00", "raster_size": [1200, 1200], "sat_id": "modis", "storage_state": "available"}',  # noqa
}


def _metadata_get(self, id):
    return DotDict(json.loads(METADATA[id]))


BANDS = {
    "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1": '{"derived:bai": {"description": "Burned Area Index", "bands": ["red", "nir"], "data_range": [0, 65535], "name_common": "derived:bai", "physical_range": [-1.0, 1.0], "function_name": "bai_uint16", "dtype": "UInt16", "id": "derived:bai", "name": "derived:bai"}, "landsat:LC08:PRE:TOAR:qa_cloud": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Cloud Classification", "tags": ["class", "cloud", "30m", "landsat"], "color": "Gray", "dtype": "UInt16", "name_vendor": "qa_cloud", "data_description": "0: not measured. 1: low-probability. 2: medium-probability. 3: high-probability.", "srcband": 4, "name_common": "qa_cloud", "id": "landsat:LC08:PRE:TOAR:qa_cloud", "nbits": 2, "name": "qa_cloud", "srcfile": 1, "type": "classification", "resolution": 30, "data_range": [0, 3], "resolution_unit": "m", "jpx_layer": 1, "owner_type": "core", "nodata": null, "default_range": [0, 3], "res_factor": 2}, "landsat:LC08:PRE:TOAR:tirs1": {"wavelength_max": 11200, "data_unit_description": "Top of atmosphere reflectance", "data_unit": "TOAR", "description": "Thermal infrared TIRS 1", "tags": ["spectral", "thermal", "tirs1", "100m", "landsat"], "color": "Gray", "dtype": "UInt16", "jpx_layer": 3, "name_vendor": "B10", "product": "landsat:LC08:PRE:TOAR", "vendor_order": 10, "physical_range": [-32, 64], "srcband": 3, "name_common": "tirs1", "id": "landsat:LC08:PRE:TOAR:tirs1", "nbits": 14, "type": "spectral", "name": "tirs1", "srcfile": 1, "wavelength_min": 10600, "resolution": 100, "data_range": [0, 16383], "resolution_unit": "m", "wavelength_unit": "nm", "res_factor": 2, "wavelength_fwhm": 600, "owner_type": "core", "default_range": [0, 16383], "processing_level": "TOAR", "data_description": "TOAR, 0-10000 is 0 - 100% reflective"}, "derived:ndwi": {"description": "Normalized Difference Water Index (with SWIR1)", "bands": ["nir", "swir1"], "data_range": [0, 65535], "name_common": "derived:ndwi", "physical_range": [-1.0, 1.0], "function_name": "ndi_uint16", "dtype": "UInt16", "id": "derived:ndwi", "name": "derived:ndwi"}, "derived:ndvi": {"description": "Normalized Difference Vegetation Index", "bands": ["nir", "red"], "data_range": [0, 65535], "name_common": "derived:ndvi", "physical_range": [-1.0, 1.0], "function_name": "ndi_uint16", "dtype": "UInt16", "id": "derived:ndvi", "name": "derived:ndvi"}, "derived:rsqrt": {"description": "SQRT of R", "bands": ["red"], "data_range": [0, 1000], "name_common": "derived:rsqrt", "physical_range": [0, 1.0], "function_name": "sqrt", "dtype": "Float64", "id": "derived:rsqrt", "name": "derived:rsqrt"}, "derived:visual_cloud_mask": {"description": "Visual cloud mask based on grayness and green brightness", "bands": ["red", "green", "blue"], "data_range": [0, 1], "name_common": "derived:visual_cloud_mask", "physical_range": null, "function_name": "visual_cloud_mask", "dtype": "UInt16", "id": "derived:visual_cloud_mask", "name": "derived:visual_cloud_mask"}, "landsat:LC08:PRE:TOAR:qa_water": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Water Classification", "tags": ["class", "water", "30m", "landsat"], "color": "Gray", "dtype": "UInt16", "name_vendor": "qa_water", "data_description": "0: not measured. 1: low-probability. 2: medium-probability. 3: high-probability.", "srcband": 1, "name_common": "qa_water", "id": "landsat:LC08:PRE:TOAR:qa_water", "nbits": 2, "name": "qa_water", "srcfile": 1, "type": "classification", "resolution": 30, "data_range": [0, 3], "resolution_unit": "m", "jpx_layer": 1, "owner_type": "core", "nodata": null, "default_range": [0, 3], "res_factor": 2}, "derived:evi": {"description": "Enhanced Vegetation Index", "bands": ["blue", "red", "nir"], "data_range": [0, 65535], "name_common": "derived:evi", "physical_range": [-1.0, 1.0], "function_name": "evi_uint16", "dtype": "UInt16", "id": "derived:evi", "name": "derived:evi"}, "landsat:LC08:PRE:TOAR:alpha": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Alpha (valid data)", "tags": ["mask", "alpha", "15m", "landsat"], "color": "Alpha", "dtype": "UInt16", "resolution": 15, "data_description": "0: nodata, 1: valid data", "srcband": 1, "name_common": "alpha", "id": "landsat:LC08:PRE:TOAR:alpha", "nbits": 1, "name": "alpha", "srcfile": 0, "default_range": [0, 1], "data_range": [0, 1], "resolution_unit": "m", "jpx_layer": 1, "owner_type": "core", "nodata": null, "type": "mask", "res_factor": 1}, "derived:nbr": {"description": "Normalized Burned Ratio (nir - swir2)/(nir + swir2)", "bands": ["nir", "swir2"], "data_range": [0, 65535], "name_common": "derived:nbr", "physical_range": [-1, 1], "function_name": "ndi_uint16", "dtype": "UInt16", "id": "derived:nbr", "name": "derived:nbr"}, "landsat:LC08:PRE:TOAR:nir": {"wavelength_max": 878.85, "data_unit": "TOAR", "color": "Gray", "dtype": "UInt16", "name_vendor": "B5", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:nir", "nbits": 14, "srcfile": 1, "wavelength_unit": "nm", "wavelength_center": 864.7, "processing_level": "TOAR", "jpx_layer": 2, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Near Infrared", "tags": ["spectral", "nir", "near-infrared", "30m", "landsat"], "resolution_unit": "m", "wavelength_min": 850.5500000000001, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 1, "name_common": "nir", "vendor_order": 5, "name": "nir", "default_range": [0, 10000], "data_range": [0, 10000], "res_factor": 2, "wavelength_fwhm": 28.3, "owner_type": "core", "nodata": null, "resolution": 30}, "derived:ndwi2": {"description": "Normalized Difference Water Index (with SWIR2)", "bands": ["nir", "swir2"], "data_range": [0, 65535], "name_common": "derived:ndwi2", "physical_range": [-1.0, 1.0], "function_name": "ndi_uint16", "dtype": "UInt16", "id": "derived:ndwi2", "name": "derived:ndwi2"}, "landsat:LC08:PRE:TOAR:cirrus": {"wavelength_max": 1375.0, "data_unit": "TOAR", "color": "Gray", "dtype": "UInt16", "name_vendor": "B9", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:cirrus", "nbits": 14, "srcfile": 1, "wavelength_unit": "nm", "wavelength_center": 1370, "processing_level": "TOAR", "jpx_layer": 3, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Cirrus", "tags": ["spectral", "cirrus", "30m", "landsat"], "resolution_unit": "m", "wavelength_min": 1365.0, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 2, "name_common": "cirrus", "vendor_order": 9, "name": "cirrus", "default_range": [0, 10000], "data_range": [0, 10000], "res_factor": 2, "wavelength_fwhm": 10, "owner_type": "core", "nodata": null, "resolution": 30}, "derived:ndwi1": {"description": "Normalized Difference Water Index (with SWIR1)", "bands": ["nir", "swir1"], "data_range": [0, 65535], "name_common": "derived:ndwi1", "physical_range": [-1.0, 1.0], "function_name": "ndi_uint16", "dtype": "UInt16", "id": "derived:ndwi1", "name": "derived:ndwi1"}, "landsat:LC08:PRE:TOAR:swir1": {"wavelength_max": 1651.25, "data_unit": "TOAR", "color": "Gray", "dtype": "UInt16", "name_vendor": "B6", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:swir1", "nbits": 14, "srcfile": 1, "wavelength_unit": "nm", "wavelength_center": 1608.9, "processing_level": "TOAR", "jpx_layer": 2, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Short wave infrared 1", "tags": ["spectral", "swir", "swir1", "30m", "landsat"], "resolution_unit": "m", "wavelength_min": 1566.5500000000002, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 2, "name_common": "swir1", "vendor_order": 6, "name": "swir1", "default_range": [0, 10000], "data_range": [0, 10000], "res_factor": 2, "wavelength_fwhm": 84.7, "owner_type": "core", "nodata": null, "resolution": 30}, "landsat:LC08:PRE:TOAR:swir2": {"wavelength_max": 2294.0499999999997, "data_unit": "TOAR", "color": "Gray", "dtype": "UInt16", "name_vendor": "B7", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:swir2", "nbits": 14, "srcfile": 1, "wavelength_unit": "nm", "wavelength_center": 2200.7, "processing_level": "TOAR", "jpx_layer": 2, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Short wave infrared 2", "tags": ["spectral", "swir", "swir2", "30m", "landsat"], "resolution_unit": "m", "wavelength_min": 2107.35, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 3, "name_common": "swir2", "vendor_order": 7, "name": "swir2", "default_range": [0, 10000], "data_range": [0, 10000], "res_factor": 2, "wavelength_fwhm": 186.7, "owner_type": "core", "nodata": null, "resolution": 30}, "landsat:LC08:PRE:TOAR:qa_cirrus": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Cirrus Classification", "tags": ["class", "cirrus", "30m", "landsat"], "color": "Gray", "dtype": "UInt16", "name_vendor": "qa_cirrus", "data_description": "0: not measured. 1: low-probability. 2: medium-probability. 3: high-probability.", "srcband": 3, "name_common": "qa_cirrus", "id": "landsat:LC08:PRE:TOAR:qa_cirrus", "nbits": 2, "name": "qa_cirrus", "srcfile": 1, "type": "classification", "resolution": 30, "data_range": [0, 3], "resolution_unit": "m", "jpx_layer": 1, "owner_type": "core", "nodata": null, "default_range": [0, 3], "res_factor": 2}, "landsat:LC08:PRE:TOAR:blue": {"wavelength_max": 512.0, "data_unit": "TOAR", "color": "Blue", "dtype": "UInt16", "name_vendor": "B2", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:blue", "nbits": 14, "srcfile": 0, "wavelength_unit": "nm", "wavelength_center": 482, "processing_level": "TOAR", "jpx_layer": 0, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Blue, Pansharpened", "tags": ["spectral", "blue", "15m", "landsat"], "resolution_unit": "m", "wavelength_min": 452.0, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 3, "name_common": "blue", "vendor_order": 2, "name": "blue", "default_range": [0, 4000], "data_range": [0, 10000], "res_factor": 1, "wavelength_fwhm": 60, "owner_type": "core", "nodata": null, "resolution": 15}, "landsat:LC08:PRE:TOAR:bright-mask": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Bright Mask (blue > 20% reflective)", "tags": ["mask", "bright", "30m", "landsat"], "color": "Gray", "dtype": "UInt16", "resolution": 30, "data_description": "Bright mask. 0: not-bright, 1: bright", "srcband": 3, "name_common": "bright-mask", "id": "landsat:LC08:PRE:TOAR:bright-mask", "nbits": 1, "name": "bright-mask", "srcfile": 1, "default_range": [0, 1], "data_range": [0, 1], "resolution_unit": "m", "jpx_layer": 0, "owner_type": "core", "nodata": null, "type": "mask", "res_factor": 2}, "landsat:LC08:PRE:TOAR:green": {"wavelength_max": 590.05, "data_unit": "TOAR", "color": "Green", "dtype": "UInt16", "name_vendor": "B3", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:green", "nbits": 14, "srcfile": 0, "wavelength_unit": "nm", "wavelength_center": 561.4, "processing_level": "TOAR", "jpx_layer": 0, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Green, Pansharpened", "tags": ["spectral", "green", "15m", "landsat"], "resolution_unit": "m", "wavelength_min": 532.75, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 2, "name_common": "green", "vendor_order": 3, "name": "green", "default_range": [0, 4000], "data_range": [0, 10000], "res_factor": 1, "wavelength_fwhm": 57.3, "owner_type": "core", "nodata": null, "resolution": 15}, "landsat:LC08:PRE:TOAR:qa_snow": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Snow Classification", "tags": ["class", "snow", "30m", "landsat"], "color": "Gray", "dtype": "UInt16", "name_vendor": "qa_snow", "data_description": "0: not measured. 1: low-probability. 2: medium-probability. 3: high-probability.", "srcband": 2, "name_common": "qa_snow", "id": "landsat:LC08:PRE:TOAR:qa_snow", "nbits": 2, "name": "qa_snow", "srcfile": 1, "type": "classification", "resolution": 30, "data_range": [0, 3], "resolution_unit": "m", "jpx_layer": 1, "owner_type": "core", "nodata": null, "default_range": [0, 3], "res_factor": 2}, "landsat:LC08:PRE:TOAR:red": {"wavelength_max": 673.35, "data_unit": "TOAR", "color": "Red", "dtype": "UInt16", "name_vendor": "B4", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:red", "nbits": 14, "srcfile": 0, "wavelength_unit": "nm", "wavelength_center": 654.6, "processing_level": "TOAR", "jpx_layer": 0, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Red, Pansharpened", "tags": ["spectral", "red", "15m", "landsat"], "resolution_unit": "m", "wavelength_min": 635.85, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 1, "name_common": "red", "vendor_order": 4, "name": "red", "default_range": [0, 4000], "data_range": [0, 10000], "res_factor": 1, "wavelength_fwhm": 37.5, "owner_type": "core", "nodata": null, "resolution": 15}, "landsat:LC08:PRE:TOAR:cloud-mask": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Binary Cloud Mask", "tags": ["mask", "cloud", "30m", "landsat"], "color": "Gray", "dtype": "UInt16", "resolution": 30, "data_description": "Cloud mask. 0: cloud-free, 1: cloud", "srcband": 2, "name_common": "cloud-mask", "id": "landsat:LC08:PRE:TOAR:cloud-mask", "nbits": 1, "name": "cloud-mask", "srcfile": 1, "default_range": [0, 1], "data_range": [0, 1], "resolution_unit": "m", "jpx_layer": 0, "owner_type": "core", "nodata": null, "type": "mask", "res_factor": 2}, "landsat:LC08:PRE:TOAR:coastal-aerosol": {"wavelength_max": 451.0, "data_unit": "TOAR", "color": "Gray", "dtype": "UInt16", "name_vendor": "B1", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:coastal-aerosol", "nbits": 14, "srcfile": 1, "wavelength_unit": "nm", "wavelength_center": 443, "processing_level": "TOAR", "jpx_layer": 3, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Coastal Aerosol", "tags": ["spectral", "aerosol", "coastal", "30m", "landsat"], "resolution_unit": "m", "wavelength_min": 435.0, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 1, "name_common": "coastal-aerosol", "vendor_order": 1, "name": "coastal-aerosol", "default_range": [0, 10000], "data_range": [0, 10000], "res_factor": 2, "wavelength_fwhm": 16, "owner_type": "core", "nodata": null, "resolution": 30}}',  # noqa
    "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1": '{"derived:bai": {"description": "Burned Area Index", "bands": ["red", "nir"], "data_range": [0, 65535], "name_common": "derived:bai", "physical_range": [-1.0, 1.0], "function_name": "bai_uint16", "dtype": "UInt16", "id": "derived:bai", "name": "derived:bai"}, "landsat:LC08:PRE:TOAR:qa_cloud": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Cloud Classification", "tags": ["class", "cloud", "30m", "landsat"], "color": "Gray", "dtype": "UInt16", "name_vendor": "qa_cloud", "data_description": "0: not measured. 1: low-probability. 2: medium-probability. 3: high-probability.", "srcband": 4, "name_common": "qa_cloud", "id": "landsat:LC08:PRE:TOAR:qa_cloud", "nbits": 2, "name": "qa_cloud", "srcfile": 1, "type": "classification", "resolution": 30, "data_range": [0, 3], "resolution_unit": "m", "jpx_layer": 1, "owner_type": "core", "nodata": null, "default_range": [0, 3], "res_factor": 2}, "landsat:LC08:PRE:TOAR:tirs1": {"wavelength_max": 11200, "data_unit_description": "Top of atmosphere reflectance", "data_unit": "TOAR", "description": "Thermal infrared TIRS 1", "tags": ["spectral", "thermal", "tirs1", "100m", "landsat"], "color": "Gray", "dtype": "UInt16", "jpx_layer": 3, "name_vendor": "B10", "product": "landsat:LC08:PRE:TOAR", "vendor_order": 10, "physical_range": [-32, 64], "srcband": 3, "name_common": "tirs1", "id": "landsat:LC08:PRE:TOAR:tirs1", "nbits": 14, "type": "spectral", "name": "tirs1", "srcfile": 1, "wavelength_min": 10600, "resolution": 100, "data_range": [0, 16383], "resolution_unit": "m", "wavelength_unit": "nm", "res_factor": 2, "wavelength_fwhm": 600, "owner_type": "core", "default_range": [0, 16383], "processing_level": "TOAR", "data_description": "TOAR, 0-10000 is 0 - 100% reflective"}, "derived:ndwi": {"description": "Normalized Difference Water Index (with SWIR1)", "bands": ["nir", "swir1"], "data_range": [0, 65535], "name_common": "derived:ndwi", "physical_range": [-1.0, 1.0], "function_name": "ndi_uint16", "dtype": "UInt16", "id": "derived:ndwi", "name": "derived:ndwi"}, "derived:ndvi": {"description": "Normalized Difference Vegetation Index", "bands": ["nir", "red"], "data_range": [0, 65535], "name_common": "derived:ndvi", "physical_range": [-1.0, 1.0], "function_name": "ndi_uint16", "dtype": "UInt16", "id": "derived:ndvi", "name": "derived:ndvi"}, "derived:rsqrt": {"description": "SQRT of R", "bands": ["red"], "data_range": [0, 1000], "name_common": "derived:rsqrt", "physical_range": [0, 1.0], "function_name": "sqrt", "dtype": "Float64", "id": "derived:rsqrt", "name": "derived:rsqrt"}, "derived:visual_cloud_mask": {"description": "Visual cloud mask based on grayness and green brightness", "bands": ["red", "green", "blue"], "data_range": [0, 1], "name_common": "derived:visual_cloud_mask", "physical_range": null, "function_name": "visual_cloud_mask", "dtype": "UInt16", "id": "derived:visual_cloud_mask", "name": "derived:visual_cloud_mask"}, "landsat:LC08:PRE:TOAR:qa_water": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Water Classification", "tags": ["class", "water", "30m", "landsat"], "color": "Gray", "dtype": "UInt16", "name_vendor": "qa_water", "data_description": "0: not measured. 1: low-probability. 2: medium-probability. 3: high-probability.", "srcband": 1, "name_common": "qa_water", "id": "landsat:LC08:PRE:TOAR:qa_water", "nbits": 2, "name": "qa_water", "srcfile": 1, "type": "classification", "resolution": 30, "data_range": [0, 3], "resolution_unit": "m", "jpx_layer": 1, "owner_type": "core", "nodata": null, "default_range": [0, 3], "res_factor": 2}, "derived:evi": {"description": "Enhanced Vegetation Index", "bands": ["blue", "red", "nir"], "data_range": [0, 65535], "name_common": "derived:evi", "physical_range": [-1.0, 1.0], "function_name": "evi_uint16", "dtype": "UInt16", "id": "derived:evi", "name": "derived:evi"}, "landsat:LC08:PRE:TOAR:alpha": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Alpha (valid data)", "tags": ["mask", "alpha", "15m", "landsat"], "color": "Alpha", "dtype": "UInt16", "resolution": 15, "data_description": "0: nodata, 1: valid data", "srcband": 1, "name_common": "alpha", "id": "landsat:LC08:PRE:TOAR:alpha", "nbits": 1, "name": "alpha", "srcfile": 0, "default_range": [0, 1], "data_range": [0, 1], "resolution_unit": "m", "jpx_layer": 1, "owner_type": "core", "nodata": null, "type": "mask", "res_factor": 1}, "derived:nbr": {"description": "Normalized Burned Ratio (nir - swir2)/(nir + swir2)", "bands": ["nir", "swir2"], "data_range": [0, 65535], "name_common": "derived:nbr", "physical_range": [-1, 1], "function_name": "ndi_uint16", "dtype": "UInt16", "id": "derived:nbr", "name": "derived:nbr"}, "landsat:LC08:PRE:TOAR:nir": {"wavelength_max": 878.85, "data_unit": "TOAR", "color": "Gray", "dtype": "UInt16", "name_vendor": "B5", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:nir", "nbits": 14, "srcfile": 1, "wavelength_unit": "nm", "wavelength_center": 864.7, "processing_level": "TOAR", "jpx_layer": 2, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Near Infrared", "tags": ["spectral", "nir", "near-infrared", "30m", "landsat"], "resolution_unit": "m", "wavelength_min": 850.5500000000001, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 1, "name_common": "nir", "vendor_order": 5, "name": "nir", "default_range": [0, 10000], "data_range": [0, 10000], "res_factor": 2, "wavelength_fwhm": 28.3, "owner_type": "core", "nodata": null, "resolution": 30}, "derived:ndwi2": {"description": "Normalized Difference Water Index (with SWIR2)", "bands": ["nir", "swir2"], "data_range": [0, 65535], "name_common": "derived:ndwi2", "physical_range": [-1.0, 1.0], "function_name": "ndi_uint16", "dtype": "UInt16", "id": "derived:ndwi2", "name": "derived:ndwi2"}, "landsat:LC08:PRE:TOAR:cirrus": {"wavelength_max": 1375.0, "data_unit": "TOAR", "color": "Gray", "dtype": "UInt16", "name_vendor": "B9", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:cirrus", "nbits": 14, "srcfile": 1, "wavelength_unit": "nm", "wavelength_center": 1370, "processing_level": "TOAR", "jpx_layer": 3, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Cirrus", "tags": ["spectral", "cirrus", "30m", "landsat"], "resolution_unit": "m", "wavelength_min": 1365.0, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 2, "name_common": "cirrus", "vendor_order": 9, "name": "cirrus", "default_range": [0, 10000], "data_range": [0, 10000], "res_factor": 2, "wavelength_fwhm": 10, "owner_type": "core", "nodata": null, "resolution": 30}, "derived:ndwi1": {"description": "Normalized Difference Water Index (with SWIR1)", "bands": ["nir", "swir1"], "data_range": [0, 65535], "name_common": "derived:ndwi1", "physical_range": [-1.0, 1.0], "function_name": "ndi_uint16", "dtype": "UInt16", "id": "derived:ndwi1", "name": "derived:ndwi1"}, "landsat:LC08:PRE:TOAR:swir1": {"wavelength_max": 1651.25, "data_unit": "TOAR", "color": "Gray", "dtype": "UInt16", "name_vendor": "B6", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:swir1", "nbits": 14, "srcfile": 1, "wavelength_unit": "nm", "wavelength_center": 1608.9, "processing_level": "TOAR", "jpx_layer": 2, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Short wave infrared 1", "tags": ["spectral", "swir", "swir1", "30m", "landsat"], "resolution_unit": "m", "wavelength_min": 1566.5500000000002, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 2, "name_common": "swir1", "vendor_order": 6, "name": "swir1", "default_range": [0, 10000], "data_range": [0, 10000], "res_factor": 2, "wavelength_fwhm": 84.7, "owner_type": "core", "nodata": null, "resolution": 30}, "landsat:LC08:PRE:TOAR:swir2": {"wavelength_max": 2294.0499999999997, "data_unit": "TOAR", "color": "Gray", "dtype": "UInt16", "name_vendor": "B7", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:swir2", "nbits": 14, "srcfile": 1, "wavelength_unit": "nm", "wavelength_center": 2200.7, "processing_level": "TOAR", "jpx_layer": 2, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Short wave infrared 2", "tags": ["spectral", "swir", "swir2", "30m", "landsat"], "resolution_unit": "m", "wavelength_min": 2107.35, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 3, "name_common": "swir2", "vendor_order": 7, "name": "swir2", "default_range": [0, 10000], "data_range": [0, 10000], "res_factor": 2, "wavelength_fwhm": 186.7, "owner_type": "core", "nodata": null, "resolution": 30}, "landsat:LC08:PRE:TOAR:qa_cirrus": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Cirrus Classification", "tags": ["class", "cirrus", "30m", "landsat"], "color": "Gray", "dtype": "UInt16", "name_vendor": "qa_cirrus", "data_description": "0: not measured. 1: low-probability. 2: medium-probability. 3: high-probability.", "srcband": 3, "name_common": "qa_cirrus", "id": "landsat:LC08:PRE:TOAR:qa_cirrus", "nbits": 2, "name": "qa_cirrus", "srcfile": 1, "type": "classification", "resolution": 30, "data_range": [0, 3], "resolution_unit": "m", "jpx_layer": 1, "owner_type": "core", "nodata": null, "default_range": [0, 3], "res_factor": 2}, "landsat:LC08:PRE:TOAR:blue": {"wavelength_max": 512.0, "data_unit": "TOAR", "color": "Blue", "dtype": "UInt16", "name_vendor": "B2", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:blue", "nbits": 14, "srcfile": 0, "wavelength_unit": "nm", "wavelength_center": 482, "processing_level": "TOAR", "jpx_layer": 0, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Blue, Pansharpened", "tags": ["spectral", "blue", "15m", "landsat"], "resolution_unit": "m", "wavelength_min": 452.0, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 3, "name_common": "blue", "vendor_order": 2, "name": "blue", "default_range": [0, 4000], "data_range": [0, 10000], "res_factor": 1, "wavelength_fwhm": 60, "owner_type": "core", "nodata": null, "resolution": 15}, "landsat:LC08:PRE:TOAR:bright-mask": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Bright Mask (blue > 20% reflective)", "tags": ["mask", "bright", "30m", "landsat"], "color": "Gray", "dtype": "UInt16", "resolution": 30, "data_description": "Bright mask. 0: not-bright, 1: bright", "srcband": 3, "name_common": "bright-mask", "id": "landsat:LC08:PRE:TOAR:bright-mask", "nbits": 1, "name": "bright-mask", "srcfile": 1, "default_range": [0, 1], "data_range": [0, 1], "resolution_unit": "m", "jpx_layer": 0, "owner_type": "core", "nodata": null, "type": "mask", "res_factor": 2}, "landsat:LC08:PRE:TOAR:green": {"wavelength_max": 590.05, "data_unit": "TOAR", "color": "Green", "dtype": "UInt16", "name_vendor": "B3", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:green", "nbits": 14, "srcfile": 0, "wavelength_unit": "nm", "wavelength_center": 561.4, "processing_level": "TOAR", "jpx_layer": 0, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Green, Pansharpened", "tags": ["spectral", "green", "15m", "landsat"], "resolution_unit": "m", "wavelength_min": 532.75, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 2, "name_common": "green", "vendor_order": 3, "name": "green", "default_range": [0, 4000], "data_range": [0, 10000], "res_factor": 1, "wavelength_fwhm": 57.3, "owner_type": "core", "nodata": null, "resolution": 15}, "landsat:LC08:PRE:TOAR:qa_snow": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Snow Classification", "tags": ["class", "snow", "30m", "landsat"], "color": "Gray", "dtype": "UInt16", "name_vendor": "qa_snow", "data_description": "0: not measured. 1: low-probability. 2: medium-probability. 3: high-probability.", "srcband": 2, "name_common": "qa_snow", "id": "landsat:LC08:PRE:TOAR:qa_snow", "nbits": 2, "name": "qa_snow", "srcfile": 1, "type": "classification", "resolution": 30, "data_range": [0, 3], "resolution_unit": "m", "jpx_layer": 1, "owner_type": "core", "nodata": null, "default_range": [0, 3], "res_factor": 2}, "landsat:LC08:PRE:TOAR:red": {"wavelength_max": 673.35, "data_unit": "TOAR", "color": "Red", "dtype": "UInt16", "name_vendor": "B4", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:red", "nbits": 14, "srcfile": 0, "wavelength_unit": "nm", "wavelength_center": 654.6, "processing_level": "TOAR", "jpx_layer": 0, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Red, Pansharpened", "tags": ["spectral", "red", "15m", "landsat"], "resolution_unit": "m", "wavelength_min": 635.85, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 1, "name_common": "red", "vendor_order": 4, "name": "red", "default_range": [0, 4000], "data_range": [0, 10000], "res_factor": 1, "wavelength_fwhm": 37.5, "owner_type": "core", "nodata": null, "resolution": 15}, "landsat:LC08:PRE:TOAR:cloud-mask": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Binary Cloud Mask", "tags": ["mask", "cloud", "30m", "landsat"], "color": "Gray", "dtype": "UInt16", "resolution": 30, "data_description": "Cloud mask. 0: cloud-free, 1: cloud", "srcband": 2, "name_common": "cloud-mask", "id": "landsat:LC08:PRE:TOAR:cloud-mask", "nbits": 1, "name": "cloud-mask", "srcfile": 1, "default_range": [0, 1], "data_range": [0, 1], "resolution_unit": "m", "jpx_layer": 0, "owner_type": "core", "nodata": null, "type": "mask", "res_factor": 2}, "landsat:LC08:PRE:TOAR:coastal-aerosol": {"wavelength_max": 451.0, "data_unit": "TOAR", "color": "Gray", "dtype": "UInt16", "name_vendor": "B1", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:coastal-aerosol", "nbits": 14, "srcfile": 1, "wavelength_unit": "nm", "wavelength_center": 443, "processing_level": "TOAR", "jpx_layer": 3, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Coastal Aerosol", "tags": ["spectral", "aerosol", "coastal", "30m", "landsat"], "resolution_unit": "m", "wavelength_min": 435.0, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 1, "name_common": "coastal-aerosol", "vendor_order": 1, "name": "coastal-aerosol", "default_range": [0, 10000], "data_range": [0, 10000], "res_factor": 2, "wavelength_fwhm": 16, "owner_type": "core", "nodata": null, "resolution": 30}}',  # noqa
    "modis:mod11a2:006:meta_MOD11A2.A2017305.h09v05.006.2017314042814_v1": '{"LST_Day_1km": {"data_range": [0, 65535],"data_unit": "kelvin","default_range": [7500, 65535],"description": "Daytime Land Surface Temperature","dtype": "UInt16","id": "modis:mod11a2:006:LST_Day_1km","jpx_layer": 0,"name": "LST_Day_1km","name_vendor": "LST_Day_1km","nbits": 16,"nodata": 0,"owner_type": "core","physical_range": [0.0, 1310.7],"product": "modis:mod11a2:006","res_factor": 1,"resolution": 1000,"resolution_unit": "m","srcband": 1,"srcfile": 0,"type": "spectral","vendor_order": 1},"QC_Day": {"data_range": [0, 255],"data_unit": "bitfield","default_range": [0, 255],"description": "Daytime LST Quality Indicators","dtype": "Byte","id": "modis:mod11a2:006:QC_Day","jpx_layer": 0,"name": "QC_Day","name_vendor": "QC_Day","nbits": 8,"owner_type": "core","physical_range": [0, 255],"product": "modis:mod11a2:006","res_factor": 1,"resolution": 1000,"resolution_unit": "m","srcband": 1,"srcfile": 1,"type": "class","vendor_order": 2},"Day_view_time": {"data_range": [0, 255],"data_unit": "hour","default_range": [0, 240],"description": "Local time of day observation","dtype": "Byte","id": "modis:mod11a2:006:Day_view_time","jpx_layer": 0,"name": "Day_view_time","name_vendor": "Day_view_time","nbits": 8,"nodata": 255,"owner_type": "core","physical_range": [0.0, 25.5],"product": "modis:mod11a2:006","res_factor": 1,"resolution": 1000,"resolution_unit": "m","srcband": 2,"srcfile": 1,"type": "spectral","vendor_order": 3},"Day_view_angl": {"data_range": [0, 255],"data_unit": "degree","default_range": [0, 130],"description": "View zenith angle of day observation","dtype": "Byte","id": "modis:mod11a2:006:Day_view_angl","jpx_layer": 0,"name": "Day_view_angl","name_vendor": "Day_view_angl","nbits": 8,"nodata": 255,"owner_type": "core","physical_range": [-65.0, 190.0],"product": "modis:mod11a2:006","res_factor": 1,"resolution": 1000,"resolution_unit": "m","srcband": 3,"srcfile": 1,"type": "spectral","vendor_order": 4},"LST_Night_1km": {"data_range": [0, 65535],"data_unit": "kelvin","default_range": [7500, 65535],"description": "Nighttime Land Surface Temperature","dtype": "UInt16","id": "modis:mod11a2:006:LST_Night_1km","jpx_layer": 0,"name": "LST_Night_1km","name_vendor": "LST_Day_1km","nbits": 16,"nodata": 0,"owner_type": "core","physical_range": [0.0, 1310.7],"product": "modis:mod11a2:006","res_factor": 1,"resolution": 1000,"resolution_unit": "m","srcband": 2,"srcfile": 0,"type": "spectral","vendor_order": 5},"QC_Night": {"data_range": [0, 255],"data_unit": "bitfield","default_range": [0, 255],"description": "Nighttime LST Quality Indicators","dtype": "Byte","id": "modis:mod11a2:006:QC_Night","jpx_layer": 0,"name": "QC_Night","name_vendor": "QC_Night","nbits": 8,"owner_type": "core","physical_range": [0, 255],"product": "modis:mod11a2:006","res_factor": 1,"resolution": 1000,"resolution_unit": "m","srcband": 4,"srcfile": 1,"type": "class","vendor_order": 6},"Night_view_angl": {"data_range": [0, 255],"data_unit": "degree","default_range": [0, 130],"description": "View zenith angle of night observation","dtype": "Byte","id": "modis:mod11a2:006:Night_view_angl","jpx_layer": 0,"name": "Night_view_angl","name_vendor": "Night_view_angl","nbits": 8,"nodata": 255,"owner_type": "core","physical_range": [-65.0, 190.0],"product": "modis:mod11a2:006","res_factor": 1,"resolution": 1000,"resolution_unit": "m","srcband": 6,"srcfile": 1,"type": "spectral","vendor_order": 8},"Night_view_time": {"data_range": [0, 255],"data_unit": "hour","default_range": [0, 240],"description": "Local time of night observation","dtype": "Byte","id": "modis:mod11a2:006:Night_view_time","jpx_layer": 0,"name": "Night_view_time","name_vendor": "Night_view_time","nbits": 8,"nodata": 255,"owner_type": "core","physical_range": [0.0, 25.5],"product": "modis:mod11a2:006","res_factor": 1,"resolution": 1000,"resolution_unit": "m","srcband": 5,"srcfile": 1,"type": "spectral","vendor_order": 7},"Emis_31": {"data_range": [0, 255],"data_unit": "degree","default_range": [1, 255],"description": "Band 31 emissivity","dtype": "Byte","id": "modis:mod11a2:006:Emis_31","jpx_layer": 0,"name": "Emis_31","name_vendor": "Emis_31","nbits": 8,"nodata": 255,"owner_type": "core","physical_range": [0.49, 1.0],"product": "modis:mod11a2:006","res_factor": 1,"resolution": 1000,"resolution_unit": "m","srcband": 7,"srcfile": 1,"type": "spectral","vendor_order": 9},"Emis_32": {"data_range": [0, 255],"data_unit": "degree","default_range": [1, 255],"description": "Band 32 emissivity","dtype": "Byte","id": "modis:mod11a2:006:Emis_32","jpx_layer": 0,"name": "Emis_32","name_vendor": "Emis_32","nbits": 8,"nodata": 255,"owner_type": "core","physical_range": [0.49, 1.0],"product": "modis:mod11a2:006","res_factor": 1,"resolution": 1000,"resolution_unit": "m","srcband": 8,"srcfile": 1,"type": "spectral","vendor_order": 9},"Clear_sky_days": {"data_range": [0, 255],"data_unit": "unitless","default_range": [1, 255],"description": "Day clear-sky coverage","dtype": "Byte","id": "modis:mod11a2:006:Clear_sky_days","jpx_layer": 0,"name": "Clear_sky_days","name_vendor": "Clear_sky_days","nbits": 8,"nodata": 0,"owner_type": "core","physical_range": [0, 255],"product": "modis:mod11a2:006","res_factor": 1,"resolution": 1000,"resolution_unit": "m","srcband": 9,"srcfile": 1,"type": "spectral","vendor_order": 11},"Clear_sky_nights": {"data_range": [0, 255],"data_unit": "unitless","default_range": [1, 255],"description": "Night clear-sky coverage","dtype": "Byte","id": "modis:mod11a2:006:Clear_sky_nights","jpx_layer": 0,"name": "Clear_sky_nights","name_vendor": "Clear_sky_nights","nbits": 8,"nodata": 0,"owner_type": "core","physical_range": [0, 255],"product": "modis:mod11a2:006","res_factor": 1,"resolution": 1000,"resolution_unit": "m","srcband": 10,"srcfile": 1,"type": "spectral","vendor_order": 12}}',  # noqa
    "modis:mod11a2:006:meta_MOD11A2.A2000049.h08v05.006.2015058135046_v1": '{"modis:mod11a2:006:Clear_sky_days": {"data_range": [0, 255], "data_unit": "unitless", "default_range": [1, 255], "description": "Day clear-sky coverage", "dtype": "Byte", "id": "modis:mod11a2:006:Clear_sky_days", "jpx_layer": 0, "name": "Clear_sky_days", "name_vendor": "Clear_sky_days", "nbits": 8, "nodata": 0, "owner_type": "core", "physical_range": [0.0, 255.0], "product": "modis:mod11a2:006", "res_factor": 1, "resolution": 1000, "resolution_unit": "meters", "srcband": 9, "srcfile": 1, "type": "spectral", "vendor_order": 11}, "modis:mod11a2:006:Clear_sky_nights": {"data_range": [0, 255], "data_unit": "unitless", "default_range": [1, 255], "description": "Night clear-sky coverage", "dtype": "Byte", "id": "modis:mod11a2:006:Clear_sky_nights", "jpx_layer": 0, "name": "Clear_sky_nights", "name_vendor": "Clear_sky_nights", "nbits": 8, "nodata": 0, "owner_type": "core", "physical_range": [0.0, 255.0], "product": "modis:mod11a2:006", "res_factor": 1, "resolution": 1000, "resolution_unit": "meters", "srcband": 10, "srcfile": 1, "type": "spectral", "vendor_order": 12}, "modis:mod11a2:006:Day_view_angl": {"data_range": [0, 255], "data_unit": "degree", "default_range": [0, 130], "description": "View zenith angle of day observation", "dtype": "Byte", "id": "modis:mod11a2:006:Day_view_angl", "jpx_layer": 0, "name": "Day_view_angl", "name_vendor": "Day_view_angl", "nbits": 8, "nodata": 255, "owner_type": "core", "physical_range": [-65.0, 190.0], "product": "modis:mod11a2:006", "res_factor": 1, "resolution": 1000, "resolution_unit": "meters", "srcband": 3, "srcfile": 1, "type": "spectral", "vendor_order": 4}, "modis:mod11a2:006:Day_view_time": {"data_range": [0, 255], "data_unit": "hour", "default_range": [0, 240], "description": "Local time of day observation", "dtype": "Byte", "id": "modis:mod11a2:006:Day_view_time", "jpx_layer": 0, "name": "Day_view_time", "name_vendor": "Day_view_time", "nbits": 8, "nodata": 255, "owner_type": "core", "physical_range": [0.0, 25.5], "product": "modis:mod11a2:006", "res_factor": 1, "resolution": 1000, "resolution_unit": "meters", "srcband": 2, "srcfile": 1, "type": "spectral", "vendor_order": 3}, "modis:mod11a2:006:Emis_31": {"data_range": [0, 255], "data_unit": "degree", "default_range": [1, 255], "description": "Band 31 emissivity", "dtype": "Byte", "id": "modis:mod11a2:006:Emis_31", "jpx_layer": 0, "name": "Emis_31", "name_vendor": "Emis_31", "nbits": 8, "nodata": 255, "owner_type": "core", "physical_range": [0.49, 1.0], "product": "modis:mod11a2:006", "res_factor": 1, "resolution": 1000, "resolution_unit": "meters", "srcband": 7, "srcfile": 1, "type": "spectral", "vendor_order": 9}, "modis:mod11a2:006:Emis_32": {"data_range": [0, 255], "data_unit": "degree", "default_range": [1, 255], "description": "Band 32 emissivity", "dtype": "Byte", "id": "modis:mod11a2:006:Emis_32", "jpx_layer": 0, "name": "Emis_32", "name_vendor": "Emis_32", "nbits": 8, "nodata": 255, "owner_type": "core", "physical_range": [0.49, 1.0], "product": "modis:mod11a2:006", "res_factor": 1, "resolution": 1000, "resolution_unit": "meters", "srcband": 8, "srcfile": 1, "type": "spectral", "vendor_order": 9}, "modis:mod11a2:006:LST_Day_1km": {"data_range": [0, 65535], "data_unit": "kelvin", "default_range": [7500, 65535], "description": "Daytime Land Surface Temperature", "dtype": "UInt16", "id": "modis:mod11a2:006:LST_Day_1km", "jpx_layer": 0, "name": "LST_Day_1km", "name_vendor": "LST_Day_1km", "nbits": 16, "nodata": 0, "owner_type": "core", "physical_range": [0.0, 1310.7], "product": "modis:mod11a2:006", "res_factor": 1, "resolution": 1000, "resolution_unit": "meters", "srcband": 1, "srcfile": 0, "type": "spectral", "vendor_order": 1}, "modis:mod11a2:006:LST_Night_1km": {"data_range": [0, 65535], "data_unit": "kelvin", "default_range": [7500, 65535], "description": "Nighttime Land Surface Temperature", "dtype": "UInt16", "id": "modis:mod11a2:006:LST_Night_1km", "jpx_layer": 0, "name": "LST_Night_1km", "name_vendor": "LST_Day_1km", "nbits": 16, "nodata": 0, "owner_type": "core", "physical_range": [0.0, 1310.7], "product": "modis:mod11a2:006", "res_factor": 1, "resolution": 1000, "resolution_unit": "meters", "srcband": 2, "srcfile": 0, "type": "spectral", "vendor_order": 5}, "modis:mod11a2:006:Night_view_angl": {"data_range": [0, 255], "data_unit": "degree", "default_range": [0, 130], "description": "View zenith angle of night observation", "dtype": "Byte", "id": "modis:mod11a2:006:Night_view_angl", "jpx_layer": 0, "name": "Night_view_angl", "name_vendor": "Night_view_angl", "nbits": 8, "nodata": 255, "owner_type": "core", "physical_range": [-65.0, 190.0], "product": "modis:mod11a2:006", "res_factor": 1, "resolution": 1000, "resolution_unit": "meters", "srcband": 6, "srcfile": 1, "type": "spectral", "vendor_order": 8}, "modis:mod11a2:006:Night_view_time": {"data_range": [0, 255], "data_unit": "hour", "default_range": [0, 240], "description": "Local time of night observation", "dtype": "Byte", "id": "modis:mod11a2:006:Night_view_time", "jpx_layer": 0, "name": "Night_view_time", "name_vendor": "Night_view_time", "nbits": 8, "nodata": 255, "owner_type": "core", "physical_range": [0.0, 25.5], "product": "modis:mod11a2:006", "res_factor": 1, "resolution": 1000, "resolution_unit": "meters", "srcband": 5, "srcfile": 1, "type": "spectral", "vendor_order": 7}, "modis:mod11a2:006:QC_Day": {"data_range": [0, 255], "data_unit": "bitfield", "default_range": [0, 255], "description": "Daytime LST Quality Indicators", "dtype": "Byte", "id": "modis:mod11a2:006:QC_Day", "jpx_layer": 0, "name": "QC_Day", "name_vendor": "QC_Day", "nbits": 8, "owner_type": "core", "physical_range": [0.0, 255.0], "product": "modis:mod11a2:006", "res_factor": 1, "resolution": 1000, "resolution_unit": "meters", "srcband": 1, "srcfile": 1, "type": "class", "vendor_order": 2}, "modis:mod11a2:006:QC_Night": {"data_range": [0, 255], "data_unit": "bitfield", "default_range": [0, 255], "description": "Nighttime LST Quality Indicators", "dtype": "Byte", "id": "modis:mod11a2:006:QC_Night", "jpx_layer": 0, "name": "QC_Night", "name_vendor": "QC_Night", "nbits": 8, "owner_type": "core", "physical_range": [0.0, 255.0], "product": "modis:mod11a2:006", "res_factor": 1, "resolution": 1000, "resolution_unit": "meters", "srcband": 4, "srcfile": 1, "type": "class", "vendor_order": 6}}',  # noqa
}


def _metadata_get_bands(self, id):
    return DotDict(json.loads(BANDS[id]))


BANDS_BY_PRODUCT = {
    "landsat:LC08:PRE:TOAR": '{"derived:bai": {"description": "Burned Area Index", "bands": ["red", "nir"], "data_range": [0, 65535], "name_common": "derived:bai", "physical_range": [-1.0, 1.0], "function_name": "bai_uint16", "dtype": "UInt16", "id": "derived:bai", "name": "derived:bai"}, "landsat:LC08:PRE:TOAR:qa_cloud": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Cloud Classification", "tags": ["class", "cloud", "30m", "landsat"], "color": "Gray", "dtype": "UInt16", "name_vendor": "qa_cloud", "data_description": "0: not measured. 1: low-probability. 2: medium-probability. 3: high-probability.", "srcband": 4, "name_common": "qa_cloud", "id": "landsat:LC08:PRE:TOAR:qa_cloud", "nbits": 2, "name": "qa_cloud", "srcfile": 1, "type": "classification", "resolution": 30, "data_range": [0, 3], "resolution_unit": "m", "jpx_layer": 1, "owner_type": "core", "nodata": null, "default_range": [0, 3], "res_factor": 2}, "landsat:LC08:PRE:TOAR:tirs1": {"wavelength_max": 11200, "data_unit_description": "Top of atmosphere reflectance", "data_unit": "TOAR", "description": "Thermal infrared TIRS 1", "tags": ["spectral", "thermal", "tirs1", "100m", "landsat"], "color": "Gray", "dtype": "UInt16", "jpx_layer": 3, "name_vendor": "B10", "product": "landsat:LC08:PRE:TOAR", "vendor_order": 10, "physical_range": [-32, 64], "srcband": 3, "name_common": "tirs1", "id": "landsat:LC08:PRE:TOAR:tirs1", "nbits": 14, "type": "spectral", "name": "tirs1", "srcfile": 1, "wavelength_min": 10600, "resolution": 100, "data_range": [0, 16383], "resolution_unit": "m", "wavelength_unit": "nm", "res_factor": 2, "wavelength_fwhm": 600, "owner_type": "core", "default_range": [0, 16383], "processing_level": "TOAR", "data_description": "TOAR, 0-10000 is 0 - 100% reflective"}, "derived:ndwi": {"description": "Normalized Difference Water Index (with SWIR1)", "bands": ["nir", "swir1"], "data_range": [0, 65535], "name_common": "derived:ndwi", "physical_range": [-1.0, 1.0], "function_name": "ndi_uint16", "dtype": "UInt16", "id": "derived:ndwi", "name": "derived:ndwi"}, "derived:ndvi": {"description": "Normalized Difference Vegetation Index", "bands": ["nir", "red"], "data_range": [0, 65535], "name_common": "derived:ndvi", "physical_range": [-1.0, 1.0], "function_name": "ndi_uint16", "dtype": "UInt16", "id": "derived:ndvi", "name": "derived:ndvi"}, "derived:rsqrt": {"description": "SQRT of R", "bands": ["red"], "data_range": [0, 1000], "name_common": "derived:rsqrt", "physical_range": [0, 1.0], "function_name": "sqrt", "dtype": "Float64", "id": "derived:rsqrt", "name": "derived:rsqrt"}, "derived:visual_cloud_mask": {"description": "Visual cloud mask based on grayness and green brightness", "bands": ["red", "green", "blue"], "data_range": [0, 1], "name_common": "derived:visual_cloud_mask", "physical_range": null, "function_name": "visual_cloud_mask", "dtype": "UInt16", "id": "derived:visual_cloud_mask", "name": "derived:visual_cloud_mask"}, "landsat:LC08:PRE:TOAR:qa_water": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Water Classification", "tags": ["class", "water", "30m", "landsat"], "color": "Gray", "dtype": "UInt16", "name_vendor": "qa_water", "data_description": "0: not measured. 1: low-probability. 2: medium-probability. 3: high-probability.", "srcband": 1, "name_common": "qa_water", "id": "landsat:LC08:PRE:TOAR:qa_water", "nbits": 2, "name": "qa_water", "srcfile": 1, "type": "classification", "resolution": 30, "data_range": [0, 3], "resolution_unit": "m", "jpx_layer": 1, "owner_type": "core", "nodata": null, "default_range": [0, 3], "res_factor": 2}, "derived:evi": {"description": "Enhanced Vegetation Index", "bands": ["blue", "red", "nir"], "data_range": [0, 65535], "name_common": "derived:evi", "physical_range": [-1.0, 1.0], "function_name": "evi_uint16", "dtype": "UInt16", "id": "derived:evi", "name": "derived:evi"}, "landsat:LC08:PRE:TOAR:alpha": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Alpha (valid data)", "tags": ["mask", "alpha", "15m", "landsat"], "color": "Alpha", "dtype": "UInt16", "resolution": 15, "data_description": "0: nodata, 1: valid data", "srcband": 1, "name_common": "alpha", "id": "landsat:LC08:PRE:TOAR:alpha", "nbits": 1, "name": "alpha", "srcfile": 0, "default_range": [0, 1], "data_range": [0, 1], "resolution_unit": "m", "jpx_layer": 1, "owner_type": "core", "nodata": null, "type": "mask", "res_factor": 1}, "landsat:LC08:PRE:TOAR:nir": {"wavelength_max": 878.85, "data_unit": "TOAR", "color": "Gray", "dtype": "UInt16", "name_vendor": "B5", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:nir", "nbits": 14, "srcfile": 1, "wavelength_unit": "nm", "wavelength_center": 864.7, "processing_level": "TOAR", "jpx_layer": 2, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Near Infrared", "tags": ["spectral", "nir", "near-infrared", "30m", "landsat"], "resolution_unit": "m", "wavelength_min": 850.5500000000001, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 1, "name_common": "nir", "vendor_order": 5, "name": "nir", "default_range": [0, 10000], "data_range": [0, 10000], "res_factor": 2, "wavelength_fwhm": 28.3, "owner_type": "core", "nodata": null, "resolution": 30}, "derived:ndwi2": {"description": "Normalized Difference Water Index (with SWIR2)", "bands": ["nir", "swir2"], "data_range": [0, 65535], "name_common": "derived:ndwi2", "physical_range": [-1.0, 1.0], "function_name": "ndi_uint16", "dtype": "UInt16", "id": "derived:ndwi2", "name": "derived:ndwi2"}, "landsat:LC08:PRE:TOAR:cirrus": {"wavelength_max": 1375.0, "data_unit": "TOAR", "color": "Gray", "dtype": "UInt16", "name_vendor": "B9", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:cirrus", "nbits": 14, "srcfile": 1, "wavelength_unit": "nm", "wavelength_center": 1370, "processing_level": "TOAR", "jpx_layer": 3, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Cirrus", "tags": ["spectral", "cirrus", "30m", "landsat"], "resolution_unit": "m", "wavelength_min": 1365.0, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 2, "name_common": "cirrus", "vendor_order": 9, "name": "cirrus", "default_range": [0, 10000], "data_range": [0, 10000], "res_factor": 2, "wavelength_fwhm": 10, "owner_type": "core", "nodata": null, "resolution": 30}, "derived:ndwi1": {"description": "Normalized Difference Water Index (with SWIR1)", "bands": ["nir", "swir1"], "data_range": [0, 65535], "name_common": "derived:ndwi1", "physical_range": [-1.0, 1.0], "function_name": "ndi_uint16", "dtype": "UInt16", "id": "derived:ndwi1", "name": "derived:ndwi1"}, "landsat:LC08:PRE:TOAR:swir1": {"wavelength_max": 1651.25, "data_unit": "TOAR", "color": "Gray", "dtype": "UInt16", "name_vendor": "B6", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:swir1", "nbits": 14, "srcfile": 1, "wavelength_unit": "nm", "wavelength_center": 1608.9, "processing_level": "TOAR", "jpx_layer": 2, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Short wave infrared 1", "tags": ["spectral", "swir", "swir1", "30m", "landsat"], "resolution_unit": "m", "wavelength_min": 1566.5500000000002, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 2, "name_common": "swir1", "vendor_order": 6, "name": "swir1", "default_range": [0, 10000], "data_range": [0, 10000], "res_factor": 2, "wavelength_fwhm": 84.7, "owner_type": "core", "nodata": null, "resolution": 30}, "landsat:LC08:PRE:TOAR:swir2": {"wavelength_max": 2294.0499999999997, "data_unit": "TOAR", "color": "Gray", "dtype": "UInt16", "name_vendor": "B7", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:swir2", "nbits": 14, "srcfile": 1, "wavelength_unit": "nm", "wavelength_center": 2200.7, "processing_level": "TOAR", "jpx_layer": 2, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Short wave infrared 2", "tags": ["spectral", "swir", "swir2", "30m", "landsat"], "resolution_unit": "m", "wavelength_min": 2107.35, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 3, "name_common": "swir2", "vendor_order": 7, "name": "swir2", "default_range": [0, 10000], "data_range": [0, 10000], "res_factor": 2, "wavelength_fwhm": 186.7, "owner_type": "core", "nodata": null, "resolution": 30}, "landsat:LC08:PRE:TOAR:qa_cirrus": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Cirrus Classification", "tags": ["class", "cirrus", "30m", "landsat"], "color": "Gray", "dtype": "UInt16", "name_vendor": "qa_cirrus", "data_description": "0: not measured. 1: low-probability. 2: medium-probability. 3: high-probability.", "srcband": 3, "name_common": "qa_cirrus", "id": "landsat:LC08:PRE:TOAR:qa_cirrus", "nbits": 2, "name": "qa_cirrus", "srcfile": 1, "type": "classification", "resolution": 30, "data_range": [0, 3], "resolution_unit": "m", "jpx_layer": 1, "owner_type": "core", "nodata": null, "default_range": [0, 3], "res_factor": 2}, "landsat:LC08:PRE:TOAR:blue": {"wavelength_max": 512.0, "data_unit": "TOAR", "color": "Blue", "dtype": "UInt16", "name_vendor": "B2", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:blue", "nbits": 14, "srcfile": 0, "wavelength_unit": "nm", "wavelength_center": 482, "processing_level": "TOAR", "jpx_layer": 0, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Blue, Pansharpened", "tags": ["spectral", "blue", "15m", "landsat"], "resolution_unit": "m", "wavelength_min": 452.0, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 3, "name_common": "blue", "vendor_order": 2, "name": "blue", "default_range": [0, 4000], "data_range": [0, 10000], "res_factor": 1, "wavelength_fwhm": 60, "owner_type": "core", "nodata": null, "resolution": 15}, "landsat:LC08:PRE:TOAR:bright-mask": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Bright Mask (blue > 20% reflective)", "tags": ["mask", "bright", "30m", "landsat"], "color": "Gray", "dtype": "UInt16", "resolution": 30, "data_description": "Bright mask. 0: not-bright, 1: bright", "srcband": 3, "name_common": "bright-mask", "id": "landsat:LC08:PRE:TOAR:bright-mask", "nbits": 1, "name": "bright-mask", "srcfile": 1, "default_range": [0, 1], "data_range": [0, 1], "resolution_unit": "m", "jpx_layer": 0, "owner_type": "core", "nodata": null, "type": "mask", "res_factor": 2}, "landsat:LC08:PRE:TOAR:green": {"wavelength_max": 590.05, "data_unit": "TOAR", "color": "Green", "dtype": "UInt16", "name_vendor": "B3", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:green", "nbits": 14, "srcfile": 0, "wavelength_unit": "nm", "wavelength_center": 561.4, "processing_level": "TOAR", "jpx_layer": 0, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Green, Pansharpened", "tags": ["spectral", "green", "15m", "landsat"], "resolution_unit": "m", "wavelength_min": 532.75, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 2, "name_common": "green", "vendor_order": 3, "name": "green", "default_range": [0, 4000], "data_range": [0, 10000], "res_factor": 1, "wavelength_fwhm": 57.3, "owner_type": "core", "nodata": null, "resolution": 15}, "landsat:LC08:PRE:TOAR:qa_snow": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Snow Classification", "tags": ["class", "snow", "30m", "landsat"], "color": "Gray", "dtype": "UInt16", "name_vendor": "qa_snow", "data_description": "0: not measured. 1: low-probability. 2: medium-probability. 3: high-probability.", "srcband": 2, "name_common": "qa_snow", "id": "landsat:LC08:PRE:TOAR:qa_snow", "nbits": 2, "name": "qa_snow", "srcfile": 1, "type": "classification", "resolution": 30, "data_range": [0, 3], "resolution_unit": "m", "jpx_layer": 1, "owner_type": "core", "nodata": null, "default_range": [0, 3], "res_factor": 2}, "landsat:LC08:PRE:TOAR:red": {"wavelength_max": 673.35, "data_unit": "TOAR", "color": "Red", "dtype": "UInt16", "name_vendor": "B4", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:red", "nbits": 14, "srcfile": 0, "wavelength_unit": "nm", "wavelength_center": 654.6, "processing_level": "TOAR", "jpx_layer": 0, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Red, Pansharpened", "tags": ["spectral", "red", "15m", "landsat"], "resolution_unit": "m", "wavelength_min": 635.85, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 1, "name_common": "red", "vendor_order": 4, "name": "red", "default_range": [0, 4000], "data_range": [0, 10000], "res_factor": 1, "wavelength_fwhm": 37.5, "owner_type": "core", "nodata": null, "resolution": 15}, "landsat:LC08:PRE:TOAR:cloud-mask": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Binary Cloud Mask", "tags": ["mask", "cloud", "30m", "landsat"], "color": "Gray", "dtype": "UInt16", "resolution": 30, "data_description": "Cloud mask. 0: cloud-free, 1: cloud", "srcband": 2, "name_common": "cloud-mask", "id": "landsat:LC08:PRE:TOAR:cloud-mask", "nbits": 1, "name": "cloud-mask", "srcfile": 1, "default_range": [0, 1], "data_range": [0, 1], "resolution_unit": "m", "jpx_layer": 0, "owner_type": "core", "nodata": null, "type": "mask", "res_factor": 2}, "landsat:LC08:PRE:TOAR:coastal-aerosol": {"wavelength_max": 451.0, "data_unit": "TOAR", "color": "Gray", "dtype": "UInt16", "name_vendor": "B1", "type": "spectral", "id": "landsat:LC08:PRE:TOAR:coastal-aerosol", "nbits": 14, "srcfile": 1, "wavelength_unit": "nm", "wavelength_center": 443, "processing_level": "TOAR", "jpx_layer": 3, "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Coastal Aerosol", "tags": ["spectral", "aerosol", "coastal", "30m", "landsat"], "resolution_unit": "m", "wavelength_min": 435.0, "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "srcband": 1, "name_common": "coastal-aerosol", "vendor_order": 1, "name": "coastal-aerosol", "default_range": [0, 10000], "data_range": [0, 10000], "res_factor": 2, "wavelength_fwhm": 16, "owner_type": "core", "nodata": null, "resolution": 30}}'  # noqa
}


def _metadata_get_bands_by_product(self, product):
    return DotDict(json.loads(BANDS_BY_PRODUCT[product]))


SEARCH = {
    '{"end_datetime": null, "geom": {"coordinates": [[[-95.836498, 39.278486], [-92.068696, 39.278486], [-92.068696, 42.799988], [-95.836498, 42.799988], [-95.836498, 39.278486]]], "type": "Polygon"}, "products": ["landsat:LC08:PRE:TOAR"], "start_datetime": null}': '{"type": "FeatureCollection", "features": [{"geometry": {"type": "Polygon", "coordinates": [[[-94.2036617, 41.3717716], [-92.0686956, 40.9629603], [-92.6448116, 39.2784859], [-94.724166, 39.6850062], [-94.2036617, 41.3717716]]]}, "type": "Feature", "id": "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1", "key": "meta_LC80260322016197_v1", "properties": {"files": ["2016-07-15_026032_L8_432.jp2", "2016-07-15_026032_L8_567_19a.jp2"], "product": "landsat:LC08:PRE:TOAR", "solar_elevation_angle": 63.72682179, "sw_version": "LPGS_2.6.2", "acquired": "2016-07-15T16:53:59.495435Z", "cs_code": "EPSG:32615", "roll_angle": -0.001, "geolocation_accuracy": 4.269, "descartes_version": "hedj-landsat-0.9.7.4", "geotrans": [348592.5, 15, 0, 4582807.5, 0, -15], "key": "meta_LC80260322016197_v1", "bits_per_pixel": [1.022, 2.61, 0.804], "tile_id": "026032", "ction": 0.6439, "raster_size": [15536, 15816], "solar_azimuth_angle": 129.79642888, "bright_fraction": 0.0571, "file_sizes": [60751671, 56534564], "projcs": "WGS 84 / UTM zone 15N", "area": 35599.3, "terrain_correction": "L1T", "bucket": ["gs://descartes-l8/", "gs://descartes-l8/"], "cloud_fraction_0": 0.0947, "file_md5s": ["c80038509ca5572ecdba473bc3931fab", "92b10252278663b0b2d438bfa6c6b494"], "published": "2016-07-22T04:49:40Z", "cloud_fraction": 0.1705, "confidence_dlsr": 1.0, "reflectance_scale": [0.1786, 0.1751, 0.1913, 0.2258, 0.3721, 1.4773, 4.5414, 0.9055, 0.2005], "sat_id": "LANDSAT_8", "identifier": "LC80260322016197LGN00.tar.bz", "processed": 1469372319}}, {"geometry": {"type": "Polygon", "coordinates": [[[-95.2989209, 42.7999878], [-93.1167728, 42.3858464], [-93.7138666, 40.703737], [-95.8364984, 41.1150618], [-95.2989209, 42.7999878]]]}, "type": "Feature", "id": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "key": "meta_LC80270312016188_v1", "properties": {"files": ["2016-07-06_027031_L8_432.jp2", "2016-07-06_027031_L8_567_19a.jp2"], "product": "landsat:LC08:PRE:TOAR", "solar_elevation_angle": 64.12277058, "sw_version": "LPGS_2.6.2", "acquired": "2016-07-06T16:59:42.753476Z", "cs_code": "EPSG:32615", "roll_angle": -0.001, "geolocation_accuracy": 4.958, "descartes_version": "hedj-landsat-0.9.7.4", "geotrans": [258292.5, 15.0, 0.0, 4743307.5, 0.0, -15.0], "key": "meta_LC80270312016188_v1", "bits_per_pixel": [0.836, 1.767, 0.804], "tile_id": "027031", "ction": 0.6319, "raster_size": [15696, 15960], "solar_azimuth_angle": 131.36710631, "bright_fraction": 0.2848, "file_sizes": [49721086, 43577223], "projcs": "WGS 84 / UTM zone 15N", "area": 35619.4, "terrain_correction": "L1T", "bucket": "gs://descartes-l8/", "cloud_fraction_0": 0.3264, "file_md5s": ["5b12fa74275aee3234428fc996429256", "efb979aeda1b2fbd58fd689f84540165"], "published": "2016-07-06T23:11:30Z", "cloud_fraction": 0.5646, "confidence_dlsr": 1.0, "reflectance_scale": [0.1781, 0.1746, 0.1907, 0.2252, 0.3711, 1.4732, 4.5285, 0.903, 0.1999], "sat_id": "LANDSAT_8", "identifier": "LC80270312016188LGN00.tar.bz", "processed": 1468251918}}], "properties": {"continuation_token": "eyJhIjpbMC4wLCJlbnRyeSNsYW5kc2F0OkxDMDg6UFJFOlRPQVI6bWV0YV9MQzgwMjcwMzEyMDE2MTg4X3YxIl0sInEiOiI5Y2VhYjEwY2M0ZTJlZmY1MjMxOTdiNjg2ODJjMjFkZWUwMmIwNDE5In0.3gfqZBkMQCDvlaoqyWAJWtaPqLc"}}',  # noqa
    '{"end_datetime": "2016-07-15T00:00:00", "geom": {"coordinates": [[[-95.836498, 39.278486], [-92.068696, 39.278486], [-92.068696, 42.799988], [-95.836498, 42.799988], [-95.836498, 39.278486]]], "type": "Polygon"}, "products": ["landsat:LC08:PRE:TOAR"], "start_datetime": "2016-07-06T00:00:00"}': '{"type": "FeatureCollection", "features": [{"geometry": {"type": "Polygon", "coordinates": [[[-95.2989209, 42.7999878], [-93.1167728, 42.3858464], [-93.7138666, 40.703737], [-95.8364984, 41.1150618], [-95.2989209, 42.7999878]]]}, "type": "Feature", "id": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "key": "meta_LC80270312016188_v1", "properties": {"files": ["2016-07-06_027031_L8_432.jp2", "2016-07-06_027031_L8_567_19a.jp2"], "product": "landsat:LC08:PRE:TOAR", "solar_elevation_angle": 64.12277058, "sw_version": "LPGS_2.6.2", "acquired": "2016-07-06T16:59:42.753476Z", "cs_code": "EPSG:32615", "roll_angle": -0.001, "geolocation_accuracy": 4.958, "descartes_version": "hedj-landsat-0.9.7.4", "geotrans": [258292.5, 15.0, 0.0, 4743307.5, 0.0, -15.0], "key": "meta_LC80270312016188_v1", "bits_per_pixel": [0.836, 1.767, 0.804], "tile_id": "027031", "ction": 0.6319, "raster_size": [15696, 15960], "solar_azimuth_angle": 131.36710631, "bright_fraction": 0.2848, "file_sizes": [49721086, 43577223], "projcs": "WGS 84 / UTM zone 15N", "area": 35619.4, "terrain_correction": "L1T", "bucket": ["gs://descartes-l8/", "gs://descartes-l8/"], "cloud_fraction_0": 0.3264, "file_md5s": ["5b12fa74275aee3234428fc996429256", "efb979aeda1b2fbd58fd689f84540165"], "published": "2016-07-06T23:11:30Z", "cloud_fraction": 0.5646, "confidence_dlsr": 1.0, "reflectance_scale": [0.1781, 0.1746, 0.1907, 0.2252, 0.3711, 1.4732, 4.5285, 0.903, 0.1999], "sat_id": "LANDSAT_8", "identifier": "LC80270312016188LGN00.tar.bz", "processed": 1468251918}}], "properties": {"continuation_token": "eyJhIjpbMC4wLCJlbnRyeSNsYW5kc2F0OkxDMDg6UFJFOlRPQVI6bWV0YV9MQzgwMjcwMzEyMDE2MTg4X3YxIl0sInEiOiJmM2YzNGEzMmFkY2I4MmE2Zjc5YjgwYThlZGQ1NDVmYjJlNThjODZjIn0.KApImo8w0A9OhHJbUHD_QV4qom4"}}',  # noqa
    '{"end_datetime": null, "geom": {"coordinates": [[[-94.50970627780103, 40.460817879515986], [-93.75494640538922, 40.468212507270195], [-93.76149667591069, 41.04471363474632], [-94.5228005945451, 41.03716803374444], [-94.50970627780103, 40.460817879515986]]], "type": "Polygon"}, "products": ["landsat:LC08:PRE:TOAR"], "start_datetime": null}': '{"type": "FeatureCollection", "features": [{"geometry": {"type": "Polygon", "coordinates": [[[-94.2036617, 41.3717716], [-92.0686956, 40.9629603], [-92.6448116, 39.2784859], [-94.724166, 39.6850062], [-94.2036617, 41.3717716]]]}, "type": "Feature", "id": "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1", "key": "meta_LC80260322016197_v1", "properties": {"files": ["2016-07-15_026032_L8_432.jp2", "2016-07-15_026032_L8_567_19a.jp2"], "product": "landsat:LC08:PRE:TOAR", "solar_elevation_angle": 63.72682179, "sw_version": "LPGS_2.6.2", "acquired": "2016-07-15T16:53:59.495435Z", "cs_code": "EPSG:32615", "roll_angle": -0.001, "geolocation_accuracy": 4.269, "descartes_version": "hedj-landsat-0.9.7.4", "geotrans": [348592.5, 15, 0, 4582807.5, 0, -15], "key": "meta_LC80260322016197_v1", "bits_per_pixel": [1.022, 2.61, 0.804], "tile_id": "026032", "ction": 0.6439, "raster_size": [15536, 15816], "solar_azimuth_angle": 129.79642888, "bright_fraction": 0.0571, "file_sizes": [60751671, 56534564], "projcs": "WGS 84 / UTM zone 15N", "area": 35599.3, "terrain_correction": "L1T", "bucket": ["gs://descartes-l8/", "gs://descartes-l8/"], "cloud_fraction_0": 0.0947, "file_md5s": ["c80038509ca5572ecdba473bc3931fab", "92b10252278663b0b2d438bfa6c6b494"], "published": "2016-07-22T04:49:40Z", "cloud_fraction": 0.1705, "confidence_dlsr": 1.0, "reflectance_scale": [0.1786, 0.1751, 0.1913, 0.2258, 0.3721, 1.4773, 4.5414, 0.9055, 0.2005], "sat_id": "LANDSAT_8", "identifier": "LC80260322016197LGN00.tar.bz", "processed": 1469372319}}, {"geometry": {"type": "Polygon", "coordinates": [[[-95.2989209, 42.7999878], [-93.1167728, 42.3858464], [-93.7138666, 40.703737], [-95.8364984, 41.1150618], [-95.2989209, 42.7999878]]]}, "type": "Feature", "id": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "key": "meta_LC80270312016188_v1", "properties": {"files": ["2016-07-06_027031_L8_432.jp2", "2016-07-06_027031_L8_567_19a.jp2"], "product": "landsat:LC08:PRE:TOAR", "solar_elevation_angle": 64.12277058, "sw_version": "LPGS_2.6.2", "acquired": "2016-07-06T16:59:42.753476Z", "cs_code": "EPSG:32615", "roll_angle": -0.001, "geolocation_accuracy": 4.958, "descartes_version": "hedj-landsat-0.9.7.4", "geotrans": [258292.5, 15.0, 0.0, 4743307.5, 0.0, -15.0], "key": "meta_LC80270312016188_v1", "bits_per_pixel": [0.836, 1.767, 0.804], "tile_id": "027031", "ction": 0.6319, "raster_size": [15696, 15960], "solar_azimuth_angle": 131.36710631, "bright_fraction": 0.2848, "file_sizes": [49721086, 43577223], "projcs": "WGS 84 / UTM zone 15N", "area": 35619.4, "terrain_correction": "L1T", "bucket": "gs://descartes-l8/", "cloud_fraction_0": 0.3264, "file_md5s": ["5b12fa74275aee3234428fc996429256", "efb979aeda1b2fbd58fd689f84540165"], "published": "2016-07-06T23:11:30Z", "cloud_fraction": 0.5646, "confidence_dlsr": 1.0, "reflectance_scale": [0.1781, 0.1746, 0.1907, 0.2252, 0.3711, 1.4732, 4.5285, 0.903, 0.1999], "sat_id": "LANDSAT_8", "identifier": "LC80270312016188LGN00.tar.bz", "processed": 1468251918}}], "properties": {"continuation_token": "eyJhIjpbMC4wLCJlbnRyeSNsYW5kc2F0OkxDMDg6UFJFOlRPQVI6bWV0YV9MQzgwMjcwMzEyMDE2MTg4X3YxIl0sInEiOiJjNzdiNTFjMWE2ODkxYzA3ZmQwZDAzNDdhNGFiODljM2IzMDdjMzlmIn0.eWJvgO5AdrRz2ubnvEFx92PxJ0s"}}',  # noqa
    '{"end_datetime": null, "geom": {"coordinates": [[[-95.836498, 39.278486], [-92.068696, 39.278486], [-92.068696, 42.799988], [-95.836498, 42.799988], [-95.836498, 39.278486]]], "type": "Polygon"}, "products": null, "start_datetime": null}': '{"type": "FeatureCollection", "features": [{"geometry": {"type": "Polygon", "coordinates": [[[-94.2036617, 41.3717716], [-92.0686956, 40.9629603], [-92.6448116, 39.2784859], [-94.724166, 39.6850062], [-94.2036617, 41.3717716]]]}, "type": "Feature", "id": "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1", "key": "meta_LC80260322016197_v1", "properties": {"files": ["2016-07-15_026032_L8_432.jp2", "2016-07-15_026032_L8_567_19a.jp2"], "product": "landsat:LC08:PRE:TOAR", "solar_elevation_angle": 63.72682179, "sw_version": "LPGS_2.6.2", "acquired": "2016-07-15T16:53:59.495435Z", "cs_code": "EPSG:32615", "roll_angle": -0.001, "geolocation_accuracy": 4.269, "descartes_version": "hedj-landsat-0.9.7.4", "geotrans": [348592.5, 15, 0, 4582807.5, 0, -15], "key": "meta_LC80260322016197_v1", "bits_per_pixel": [1.022, 2.61, 0.804], "tile_id": "026032", "ction": 0.6439, "raster_size": [15536, 15816], "solar_azimuth_angle": 129.79642888, "bright_fraction": 0.0571, "file_sizes": [60751671, 56534564], "projcs": "WGS 84 / UTM zone 15N", "area": 35599.3, "terrain_correction": "L1T", "bucket": "gs://descartes-l8/", "cloud_fraction_0": 0.0947, "file_md5s": ["c80038509ca5572ecdba473bc3931fab", "92b10252278663b0b2d438bfa6c6b494"], "published": "2016-07-22T04:49:40Z", "cloud_fraction": 0.1705, "confidence_dlsr": 1.0, "reflectance_scale": [0.1786, 0.1751, 0.1913, 0.2258, 0.3721, 1.4773, 4.5414, 0.9055, 0.2005], "sat_id": "LANDSAT_8", "identifier": "LC80260322016197LGN00.tar.bz", "processed": 1469372319}}, {"geometry": {"type": "Polygon", "coordinates": [[[-95.2989209, 42.7999878], [-93.1167728, 42.3858464], [-93.7138666, 40.703737], [-95.8364984, 41.1150618], [-95.2989209, 42.7999878]]]}, "type": "Feature", "id": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "key": "meta_LC80270312016188_v1", "properties": {"files": ["2016-07-06_027031_L8_432.jp2", "2016-07-06_027031_L8_567_19a.jp2"], "product": "landsat:LC08:PRE:TOAR", "solar_elevation_angle": 64.12277058, "sw_version": "LPGS_2.6.2", "acquired": "2016-07-06T16:59:42.753476Z", "cs_code": "EPSG:32615", "roll_angle": -0.001, "geolocation_accuracy": 4.958, "descartes_version": "hedj-landsat-0.9.7.4", "geotrans": [258292.5, 15.0, 0.0, 4743307.5, 0.0, -15.0], "key": "meta_LC80270312016188_v1", "bits_per_pixel": [0.836, 1.767, 0.804], "tile_id": "027031", "ction": 0.6319, "raster_size": [15696, 15960], "solar_azimuth_angle": 131.36710631, "bright_fraction": 0.2848, "file_sizes": [49721086, 43577223], "projcs": "WGS 84 / UTM zone 15N", "area": 35619.4, "terrain_correction": "L1T", "bucket": ["gs://descartes-l8/", "gs://descartes-l8/"], "cloud_fraction_0": 0.3264, "file_md5s": ["5b12fa74275aee3234428fc996429256", "efb979aeda1b2fbd58fd689f84540165"], "published": "2016-07-06T23:11:30Z", "cloud_fraction": 0.5646, "confidence_dlsr": 1.0, "reflectance_scale": [0.1781, 0.1746, 0.1907, 0.2252, 0.3711, 1.4732, 4.5285, 0.903, 0.1999], "sat_id": "LANDSAT_8", "identifier": "LC80270312016188LGN00.tar.bz", "processed": 1468251918}}], "properties": {"continuation_token": "eyJhIjpbMC4wLCJlbnRyeSNsYW5kc2F0OkxDMDg6UFJFOlRPQVI6bWV0YV9MQzgwMjcwMzEyMDE2MTg4X3YxIl0sInEiOiJhMjcxZjU0Zjg3NjZkMjE2YjNjNmYwYzA3ZTI0MDZkYTRkOGYzMjlhIn0.CeuBS_JoWC5BqlVQYuh92BmHB94"}}',  # noqa
}


def _metadata_search(self, **kwargs):
    return DotDict(
        json.loads(
            SEARCH[
                json.dumps(
                    {
                        k: kwargs[k]
                        for k in ("geom", "products", "start_datetime", "end_datetime")
                    },
                    sort_keys=True,
                )
            ]
        )
    )


alpha = np.ones((122, 120), dtype="uint16")
alpha[2, 2] = 0

alpha1000 = np.ones((239, 235), dtype="uint16")
alpha1000[2, 2] = 0


RASTER = {
    '{"bands": ["nir", "alpha"], "data_type": "UInt16", "inputs": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "resolution": 600}': (
        np.stack([np.zeros((122, 120), dtype="uint16"), alpha]),
        '{"files": [], "cornerCoordinates": {"upperRight": [456219.441, 4580160.511], "lowerLeft": [384219.441, 4506960.511], "lowerRight": [456219.441, 4506960.511], "upperLeft": [384219.441, 4580160.511], "center": [420219.441, 4543560.511]}, "wgs84Extent": {"type": "Polygon", "coordinates": [[[-94.3843159, 41.3646333], [-94.3705723, 40.7054251], [-93.5183204, 40.7123983], [-93.5235196, 41.3717692], [-94.3843159, 41.3646333]]]}, "driverShortName": "MEM", "driverLongName": "In Memory Raster", "bands": [{"description": {"default_range": [0, 10000], "wavelength_max": 878.85, "data_unit": "TOAR", "wavelength_center": 864.7, "color": "Gray", "dtype": "UInt16", "name_vendor": "B5", "id": "landsat:LC08:PRE:TOAR:nir", "nbits": 14, "wavelength_unit": "nm", "wavelength_min": 850.55, "processing_level": "TOAR", "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Near Infrared", "tags": ["spectral", "nir", "near-infrared", "30m", "landsat"], "resolution_unit": "m", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "name_common": "nir", "vendor_order": 5, "name": "nir", "type": "spectral", "data_range": [0, 10000], "wavelength_fwhm": 28.3, "owner_type": "core", "nodata": null, "resolution": 30}, "band": 1, "colorInterpretation": "Gray", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "14"}}}, {"description": {"product": "landsat:LC08:PRE:TOAR", "nbits": 1, "description": "Alpha (valid data)", "data_description": "0: nodata, 1: valid data", "tags": ["mask", "alpha", "15m", "landsat"], "color": "Alpha", "dtype": "UInt16", "data_range": [0, 1], "resolution": 15, "resolution_unit": "m", "data_unit_description": "unitless", "name_common": "alpha", "type": "mask", "owner_type": "core", "nodata": null, "default_range": [0, 1], "id": "landsat:LC08:PRE:TOAR:alpha", "name": "alpha"}, "band": 2, "colorInterpretation": "Alpha", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "1"}}}], "coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 15N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-93],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32615\\"]]"}, "geoTransform": [384219.440777, 600.0, 0.0, 4580160.51059, 0.0, -600.0], "size": [120, 122], "metadata": {"": {"id": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "Corder": "RPCL"}}}',
    ),  # noqa
    '{"bands": ["nir", "alpha"], "data_type": "Int32", "inputs": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "resolution": 600}': (
        np.stack([np.zeros((122, 120), dtype="int32"), alpha]),
        '{"files": [], "cornerCoordinates": {"upperRight": [456219.441, 4580160.511], "lowerLeft": [384219.441, 4506960.511], "lowerRight": [456219.441, 4506960.511], "upperLeft": [384219.441, 4580160.511], "center": [420219.441, 4543560.511]}, "wgs84Extent": {"type": "Polygon", "coordinates": [[[-94.3843159, 41.3646333], [-94.3705723, 40.7054251], [-93.5183204, 40.7123983], [-93.5235196, 41.3717692], [-94.3843159, 41.3646333]]]}, "driverShortName": "MEM", "driverLongName": "In Memory Raster", "bands": [{"description": {"default_range": [0, 10000], "wavelength_max": 878.85, "data_unit": "TOAR", "wavelength_center": 864.7, "color": "Gray", "dtype": "UInt16", "name_vendor": "B5", "id": "landsat:LC08:PRE:TOAR:nir", "nbits": 14, "wavelength_unit": "nm", "wavelength_min": 850.55, "processing_level": "TOAR", "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Near Infrared", "tags": ["spectral", "nir", "near-infrared", "30m", "landsat"], "resolution_unit": "m", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "name_common": "nir", "vendor_order": 5, "name": "nir", "type": "spectral", "data_range": [0, 10000], "wavelength_fwhm": 28.3, "owner_type": "core", "nodata": null, "resolution": 30}, "band": 1, "colorInterpretation": "Gray", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "14"}}}, {"description": {"product": "landsat:LC08:PRE:TOAR", "nbits": 1, "description": "Alpha (valid data)", "data_description": "0: nodata, 1: valid data", "tags": ["mask", "alpha", "15m", "landsat"], "color": "Alpha", "dtype": "UInt16", "data_range": [0, 1], "resolution": 15, "resolution_unit": "m", "data_unit_description": "unitless", "name_common": "alpha", "type": "mask", "owner_type": "core", "nodata": null, "default_range": [0, 1], "id": "landsat:LC08:PRE:TOAR:alpha", "name": "alpha"}, "band": 2, "colorInterpretation": "Alpha", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "1"}}}], "coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 15N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-93],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32615\\"]]"}, "geoTransform": [384219.440777, 600.0, 0.0, 4580160.51059, 0.0, -600.0], "size": [120, 122], "metadata": {"": {"id": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "Corder": "RPCL"}}}',
    ),  # noqa
    '{"bands": ["nir", "alpha"], "data_type": "UInt16", "inputs": "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1", "resolution": 600}': (
        np.stack([np.zeros((122, 120), dtype="uint16"), alpha]),
        '{"files": [], "cornerCoordinates": {"upperRight": [456219.441, 4580160.511], "lowerLeft": [384219.441, 4506960.511], "lowerRight": [456219.441, 4506960.511], "upperLeft": [384219.441, 4580160.511], "center": [420219.441, 4543560.511]}, "wgs84Extent": {"type": "Polygon", "coordinates": [[[-94.3843159, 41.3646333], [-94.3705723, 40.7054251], [-93.5183204, 40.7123983], [-93.5235196, 41.3717692], [-94.3843159, 41.3646333]]]}, "driverShortName": "MEM", "driverLongName": "In Memory Raster", "bands": [{"description": {"default_range": [0, 10000], "wavelength_max": 878.85, "data_unit": "TOAR", "wavelength_center": 864.7, "color": "Gray", "dtype": "UInt16", "name_vendor": "B5", "id": "landsat:LC08:PRE:TOAR:nir", "nbits": 14, "wavelength_unit": "nm", "wavelength_min": 850.55, "processing_level": "TOAR", "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Near Infrared", "tags": ["spectral", "nir", "near-infrared", "30m", "landsat"], "resolution_unit": "m", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "name_common": "nir", "vendor_order": 5, "name": "nir", "type": "spectral", "data_range": [0, 10000], "wavelength_fwhm": 28.3, "owner_type": "core", "nodata": null, "resolution": 30}, "band": 1, "colorInterpretation": "Gray", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "14"}}}, {"description": {"product": "landsat:LC08:PRE:TOAR", "nbits": 1, "description": "Alpha (valid data)", "data_description": "0: nodata, 1: valid data", "tags": ["mask", "alpha", "15m", "landsat"], "color": "Alpha", "dtype": "UInt16", "data_range": [0, 1], "resolution": 15, "resolution_unit": "m", "data_unit_description": "unitless", "name_common": "alpha", "type": "mask", "owner_type": "core", "nodata": null, "default_range": [0, 1], "id": "landsat:LC08:PRE:TOAR:alpha", "name": "alpha"}, "band": 2, "colorInterpretation": "Alpha", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "1"}}}], "coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 15N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-93],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32615\\"]]"}, "geoTransform": [384219.440777, 600.0, 0.0, 4580160.51059, 0.0, -600.0], "size": [120, 122], "metadata": {"": {"id": "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1", "Corder": "RPCL"}}}',
    ),  # noqa
    '{"bands": ["nir", "alpha"], "data_type": "Int32", "inputs": "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1", "resolution": 600}': (
        np.stack([np.zeros((122, 120), dtype="int32"), alpha]),
        '{"files": [], "cornerCoordinates": {"upperRight": [456219.441, 4580160.511], "lowerLeft": [384219.441, 4506960.511], "lowerRight": [456219.441, 4506960.511], "upperLeft": [384219.441, 4580160.511], "center": [420219.441, 4543560.511]}, "wgs84Extent": {"type": "Polygon", "coordinates": [[[-94.3843159, 41.3646333], [-94.3705723, 40.7054251], [-93.5183204, 40.7123983], [-93.5235196, 41.3717692], [-94.3843159, 41.3646333]]]}, "driverShortName": "MEM", "driverLongName": "In Memory Raster", "bands": [{"description": {"default_range": [0, 10000], "wavelength_max": 878.85, "data_unit": "TOAR", "wavelength_center": 864.7, "color": "Gray", "dtype": "UInt16", "name_vendor": "B5", "id": "landsat:LC08:PRE:TOAR:nir", "nbits": 14, "wavelength_unit": "nm", "wavelength_min": 850.55, "processing_level": "TOAR", "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Near Infrared", "tags": ["spectral", "nir", "near-infrared", "30m", "landsat"], "resolution_unit": "m", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "name_common": "nir", "vendor_order": 5, "name": "nir", "type": "spectral", "data_range": [0, 10000], "wavelength_fwhm": 28.3, "owner_type": "core", "nodata": null, "resolution": 30}, "band": 1, "colorInterpretation": "Gray", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "14"}}}, {"description": {"product": "landsat:LC08:PRE:TOAR", "nbits": 1, "description": "Alpha (valid data)", "data_description": "0: nodata, 1: valid data", "tags": ["mask", "alpha", "15m", "landsat"], "color": "Alpha", "dtype": "UInt16", "data_range": [0, 1], "resolution": 15, "resolution_unit": "m", "data_unit_description": "unitless", "name_common": "alpha", "type": "mask", "owner_type": "core", "nodata": null, "default_range": [0, 1], "id": "landsat:LC08:PRE:TOAR:alpha", "name": "alpha"}, "band": 2, "colorInterpretation": "Alpha", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "1"}}}], "coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 15N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-93],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32615\\"]]"}, "geoTransform": [384219.440777, 600.0, 0.0, 4580160.51059, 0.0, -600.0], "size": [120, 122], "metadata": {"": {"id": "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1", "Corder": "RPCL"}}}',
    ),  # noqa
    '{"bands": ["nir", "red", "alpha"], "data_type": "UInt16", "inputs": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "resolution": 600}': (
        np.stack(
            [
                np.zeros((122, 120), dtype="uint16"),
                np.zeros((122, 120), dtype="uint16"),
                alpha,
            ]
        ),
        '{"files": [], "cornerCoordinates": {"upperRight": [456219.441, 4580160.511], "lowerLeft": [384219.441, 4506960.511], "lowerRight": [456219.441, 4506960.511], "upperLeft": [384219.441, 4580160.511], "center": [420219.441, 4543560.511]}, "wgs84Extent": {"type": "Polygon", "coordinates": [[[-94.3843159, 41.3646333], [-94.3705723, 40.7054251], [-93.5183204, 40.7123983], [-93.5235196, 41.3717692], [-94.3843159, 41.3646333]]]}, "driverShortName": "MEM", "driverLongName": "In Memory Raster", "bands": [{"description": {"default_range": [0, 10000], "wavelength_max": 878.85, "data_unit": "TOAR", "wavelength_center": 864.7, "color": "Gray", "dtype": "UInt16", "name_vendor": "B5", "id": "landsat:LC08:PRE:TOAR:nir", "nbits": 14, "wavelength_unit": "nm", "wavelength_min": 850.55, "processing_level": "TOAR", "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Near Infrared", "tags": ["spectral", "nir", "near-infrared", "30m", "landsat"], "resolution_unit": "m", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "name_common": "nir", "vendor_order": 5, "name": "nir", "type": "spectral", "data_range": [0, 10000], "wavelength_fwhm": 28.3, "owner_type": "core", "nodata": null, "resolution": 30}, "band": 1, "colorInterpretation": "Gray", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "14"}}}, {"description": {"default_range": [0, 4000], "wavelength_max": 673.35, "data_unit": "TOAR", "wavelength_center": 654.6, "color": "Red", "dtype": "UInt16", "name_vendor": "B4", "id": "landsat:LC08:PRE:TOAR:red", "nbits": 14, "wavelength_unit": "nm", "wavelength_min": 635.85, "processing_level": "TOAR", "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Red, Pansharpened", "tags": ["spectral", "red", "15m", "landsat"], "resolution_unit": "m", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "name_common": "red", "vendor_order": 4, "name": "red", "type": "spectral", "data_range": [0, 10000], "wavelength_fwhm": 37.5, "owner_type": "core", "nodata": null, "resolution": 15}, "band": 2, "colorInterpretation": "Red", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "14"}}}, {"description": {"product": "landsat:LC08:PRE:TOAR", "nbits": 1, "description": "Alpha (valid data)", "data_description": "0: nodata, 1: valid data", "tags": ["mask", "alpha", "15m", "landsat"], "color": "Alpha", "dtype": "UInt16", "data_range": [0, 1], "resolution": 15, "resolution_unit": "m", "data_unit_description": "unitless", "name_common": "alpha", "type": "mask", "owner_type": "core", "nodata": null, "default_range": [0, 1], "id": "landsat:LC08:PRE:TOAR:alpha", "name": "alpha"}, "band": 3, "colorInterpretation": "Alpha", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "1"}}}], "coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 15N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-93],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32615\\"]]"}, "geoTransform": [384219.440777, 600.0, 0.0, 4580160.51059, 0.0, -600.0], "size": [120, 122], "metadata": {"": {"id": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "Corder": "RPCL"}}}',
    ),  # noqa
    '{"bands": ["nir", "red", "alpha"], "data_type": "UInt16", "inputs": "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1", "resolution": 600}': (
        np.stack(
            [
                np.zeros((122, 120), dtype="uint16"),
                np.zeros((122, 120), dtype="uint16"),
                alpha,
            ]
        ),
        '{"files": [], "cornerCoordinates": {"upperRight": [456219.441, 4580160.511], "lowerLeft": [384219.441, 4506960.511], "lowerRight": [456219.441, 4506960.511], "upperLeft": [384219.441, 4580160.511], "center": [420219.441, 4543560.511]}, "wgs84Extent": {"type": "Polygon", "coordinates": [[[-94.3843159, 41.3646333], [-94.3705723, 40.7054251], [-93.5183204, 40.7123983], [-93.5235196, 41.3717692], [-94.3843159, 41.3646333]]]}, "driverShortName": "MEM", "driverLongName": "In Memory Raster", "bands": [{"description": {"default_range": [0, 10000], "wavelength_max": 878.85, "data_unit": "TOAR", "wavelength_center": 864.7, "color": "Gray", "dtype": "UInt16", "name_vendor": "B5", "id": "landsat:LC08:PRE:TOAR:nir", "nbits": 14, "wavelength_unit": "nm", "wavelength_min": 850.55, "processing_level": "TOAR", "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Near Infrared", "tags": ["spectral", "nir", "near-infrared", "30m", "landsat"], "resolution_unit": "m", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "name_common": "nir", "vendor_order": 5, "name": "nir", "type": "spectral", "data_range": [0, 10000], "wavelength_fwhm": 28.3, "owner_type": "core", "nodata": null, "resolution": 30}, "band": 1, "colorInterpretation": "Gray", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "14"}}}, {"description": {"default_range": [0, 4000], "wavelength_max": 673.35, "data_unit": "TOAR", "wavelength_center": 654.6, "color": "Red", "dtype": "UInt16", "name_vendor": "B4", "id": "landsat:LC08:PRE:TOAR:red", "nbits": 14, "wavelength_unit": "nm", "wavelength_min": 635.85, "processing_level": "TOAR", "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Red, Pansharpened", "tags": ["spectral", "red", "15m", "landsat"], "resolution_unit": "m", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "name_common": "red", "vendor_order": 4, "name": "red", "type": "spectral", "data_range": [0, 10000], "wavelength_fwhm": 37.5, "owner_type": "core", "nodata": null, "resolution": 15}, "band": 2, "colorInterpretation": "Red", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "14"}}}, {"description": {"product": "landsat:LC08:PRE:TOAR", "nbits": 1, "description": "Alpha (valid data)", "data_description": "0: nodata, 1: valid data", "tags": ["mask", "alpha", "15m", "landsat"], "color": "Alpha", "dtype": "UInt16", "data_range": [0, 1], "resolution": 15, "resolution_unit": "m", "data_unit_description": "unitless", "name_common": "alpha", "type": "mask", "owner_type": "core", "nodata": null, "default_range": [0, 1], "id": "landsat:LC08:PRE:TOAR:alpha", "name": "alpha"}, "band": 3, "colorInterpretation": "Alpha", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "1"}}}], "coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 15N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-93],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32615\\"]]"}, "geoTransform": [384219.440777, 600.0, 0.0, 4580160.51059, 0.0, -600.0], "size": [120, 122], "metadata": {"": {"id": "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1", "Corder": "RPCL"}}}',
    ),  # noqa
    '{"bands": ["nir"], "data_type": "UInt16", "inputs": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "resolution": 600}': (
        np.zeros((122, 120), dtype="uint16"),
        '{"files": [], "cornerCoordinates": {"upperRight": [456219.441, 4580160.511], "lowerLeft": [384219.441, 4506960.511], "lowerRight": [456219.441, 4506960.511], "upperLeft": [384219.441, 4580160.511], "center": [420219.441, 4543560.511]}, "wgs84Extent": {"type": "Polygon", "coordinates": [[[-94.3843159, 41.3646333], [-94.3705723, 40.7054251], [-93.5183204, 40.7123983], [-93.5235196, 41.3717692], [-94.3843159, 41.3646333]]]}, "driverShortName": "MEM", "driverLongName": "In Memory Raster", "bands": [{"band": 1, "description": {"wavelength_max": 878.85, "data_unit_description": "Top of atmosphere reflectance", "data_unit": "TOAR", "description": "Near Infrared", "tags": ["spectral", "nir", "near-infrared", "30m", "landsat"], "color": "Gray", "dtype": "UInt16", "wavelength_min": 850.55, "name_vendor": "B5", "product": "landsat:LC08:PRE:TOAR", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "name_common": "nir", "id": "landsat:LC08:PRE:TOAR:nir", "vendor_order": 5, "nbits": 14, "type": "spectral", "name": "nir", "wavelength_center": 864.7, "data_range": [0, 10000], "resolution_unit": "m", "wavelength_unit": "nm", "resolution": 30, "wavelength_fwhm": 28.3, "owner_type": "core", "nodata": null, "default_range": [0, 10000], "processing_level": "TOAR"}, "colorInterpretation": "Gray", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "14"}}}], "coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 15N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-93],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32615\\"]]"}, "geoTransform": [384219.440777, 600.0, 0.0, 4580160.51059, 0.0, -600.0], "metadata": {"": {"id": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "Corder": "RPCL"}}, "size": [120, 122]}',
    ),  # noqa
    '{"bands": ["nir"], "data_type": "UInt16", "inputs": "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1", "resolution": 600}': (
        np.zeros((122, 120), dtype="uint16"),
        '{"files": [], "cornerCoordinates": {"upperRight": [456219.441, 4580160.511], "lowerLeft": [384219.441, 4506960.511], "lowerRight": [456219.441, 4506960.511], "upperLeft": [384219.441, 4580160.511], "center": [420219.441, 4543560.511]}, "wgs84Extent": {"type": "Polygon", "coordinates": [[[-94.3843159, 41.3646333], [-94.3705723, 40.7054251], [-93.5183204, 40.7123983], [-93.5235196, 41.3717692], [-94.3843159, 41.3646333]]]}, "driverShortName": "MEM", "driverLongName": "In Memory Raster", "bands": [{"band": 1, "description": {"wavelength_max": 878.85, "data_unit_description": "Top of atmosphere reflectance", "data_unit": "TOAR", "description": "Near Infrared", "tags": ["spectral", "nir", "near-infrared", "30m", "landsat"], "color": "Gray", "dtype": "UInt16", "wavelength_min": 850.55, "name_vendor": "B5", "product": "landsat:LC08:PRE:TOAR", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "name_common": "nir", "id": "landsat:LC08:PRE:TOAR:nir", "vendor_order": 5, "nbits": 14, "type": "spectral", "name": "nir", "wavelength_center": 864.7, "data_range": [0, 10000], "resolution_unit": "m", "wavelength_unit": "nm", "resolution": 30, "wavelength_fwhm": 28.3, "owner_type": "core", "nodata": null, "default_range": [0, 10000], "processing_level": "TOAR"}, "colorInterpretation": "Gray", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "14"}}}], "coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 15N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-93],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32615\\"]]"}, "geoTransform": [384219.440777, 600.0, 0.0, 4580160.51059, 0.0, -600.0], "metadata": {"": {"id": "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1", "Corder": "RPCL"}}, "size": [120, 122]}',
    ),  # noqa
    '{"bands": ["nir", "alpha"], "data_type": "UInt16", "inputs": ["landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1"], "resolution": 600}': (
        np.stack([np.zeros((122, 120), dtype="uint16"), alpha]),
        '{"files": [], "cornerCoordinates": {"upperRight": [456219.441, 4580160.511], "lowerLeft": [384219.441, 4506960.511], "lowerRight": [456219.441, 4506960.511], "upperLeft": [384219.441, 4580160.511], "center": [420219.441, 4543560.511]}, "wgs84Extent": {"type": "Polygon", "coordinates": [[[-94.3843159, 41.3646333], [-94.3705723, 40.7054251], [-93.5183204, 40.7123983], [-93.5235196, 41.3717692], [-94.3843159, 41.3646333]]]}, "driverShortName": "MEM", "driverLongName": "In Memory Raster", "bands": [{"description": {"default_range": [0, 10000], "wavelength_max": 878.85, "data_unit": "TOAR", "wavelength_center": 864.7, "color": "Gray", "dtype": "UInt16", "name_vendor": "B5", "id": "landsat:LC08:PRE:TOAR:nir", "nbits": 14, "wavelength_unit": "nm", "wavelength_min": 850.55, "processing_level": "TOAR", "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Near Infrared", "tags": ["spectral", "nir", "near-infrared", "30m", "landsat"], "resolution_unit": "m", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "name_common": "nir", "vendor_order": 5, "name": "nir", "type": "spectral", "data_range": [0, 10000], "wavelength_fwhm": 28.3, "owner_type": "core", "nodata": null, "resolution": 30}, "band": 1, "colorInterpretation": "Gray", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "14"}}}, {"description": {"product": "landsat:LC08:PRE:TOAR", "nbits": 1, "description": "Alpha (valid data)", "data_description": "0: nodata, 1: valid data", "tags": ["mask", "alpha", "15m", "landsat"], "color": "Alpha", "dtype": "UInt16", "data_range": [0, 1], "resolution": 15, "resolution_unit": "m", "data_unit_description": "unitless", "name_common": "alpha", "type": "mask", "owner_type": "core", "nodata": null, "default_range": [0, 1], "id": "landsat:LC08:PRE:TOAR:alpha", "name": "alpha"}, "band": 2, "colorInterpretation": "Alpha", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "1"}}}], "coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 15N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-93],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32615\\"]]"}, "geoTransform": [384219.440777, 600.0, 0.0, 4580160.51059, 0.0, -600.0], "size": [120, 122], "metadata": {"": {"id": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "Corder": "RPCL"}}}',
    ),  # noqa
    '{"bands": ["nir", "alpha"], "data_type": "UInt16", "inputs": ["landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1"], "resolution": 600}': (
        np.stack([np.zeros((122, 120), dtype="uint16"), alpha]),
        '{"files": [], "cornerCoordinates": {"upperRight": [456219.441, 4580160.511], "lowerLeft": [384219.441, 4506960.511], "lowerRight": [456219.441, 4506960.511], "upperLeft": [384219.441, 4580160.511], "center": [420219.441, 4543560.511]}, "wgs84Extent": {"type": "Polygon", "coordinates": [[[-94.3843159, 41.3646333], [-94.3705723, 40.7054251], [-93.5183204, 40.7123983], [-93.5235196, 41.3717692], [-94.3843159, 41.3646333]]]}, "driverShortName": "MEM", "driverLongName": "In Memory Raster", "bands": [{"description": {"default_range": [0, 10000], "wavelength_max": 878.85, "data_unit": "TOAR", "wavelength_center": 864.7, "color": "Gray", "dtype": "UInt16", "name_vendor": "B5", "id": "landsat:LC08:PRE:TOAR:nir", "nbits": 14, "wavelength_unit": "nm", "wavelength_min": 850.55, "processing_level": "TOAR", "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Near Infrared", "tags": ["spectral", "nir", "near-infrared", "30m", "landsat"], "resolution_unit": "m", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "name_common": "nir", "vendor_order": 5, "name": "nir", "type": "spectral", "data_range": [0, 10000], "wavelength_fwhm": 28.3, "owner_type": "core", "nodata": null, "resolution": 30}, "band": 1, "colorInterpretation": "Gray", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "14"}}}, {"description": {"product": "landsat:LC08:PRE:TOAR", "nbits": 1, "description": "Alpha (valid data)", "data_description": "0: nodata, 1: valid data", "tags": ["mask", "alpha", "15m", "landsat"], "color": "Alpha", "dtype": "UInt16", "data_range": [0, 1], "resolution": 15, "resolution_unit": "m", "data_unit_description": "unitless", "name_common": "alpha", "type": "mask", "owner_type": "core", "nodata": null, "default_range": [0, 1], "id": "landsat:LC08:PRE:TOAR:alpha", "name": "alpha"}, "band": 2, "colorInterpretation": "Alpha", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "1"}}}], "coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 15N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-93],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32615\\"]]"}, "geoTransform": [384219.440777, 600.0, 0.0, 4580160.51059, 0.0, -600.0], "size": [120, 122], "metadata": {"": {"id": "*", "Corder": "RPCL"}}}',
    ),  # noqa
    '{"bands": ["nir", "alpha"], "data_type": "UInt16", "inputs": ["landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1"], "resolution": 600}': (
        np.stack([np.zeros((122, 120), dtype="uint16"), alpha]),
        '{"files": [], "cornerCoordinates": {"upperRight": [456219.441, 4580160.511], "lowerLeft": [384219.441, 4506960.511], "lowerRight": [456219.441, 4506960.511], "upperLeft": [384219.441, 4580160.511], "center": [420219.441, 4543560.511]}, "wgs84Extent": {"type": "Polygon", "coordinates": [[[-94.3843159, 41.3646333], [-94.3705723, 40.7054251], [-93.5183204, 40.7123983], [-93.5235196, 41.3717692], [-94.3843159, 41.3646333]]]}, "driverShortName": "MEM", "driverLongName": "In Memory Raster", "bands": [{"description": {"default_range": [0, 10000], "wavelength_max": 878.85, "data_unit": "TOAR", "wavelength_center": 864.7, "color": "Gray", "dtype": "UInt16", "name_vendor": "B5", "id": "landsat:LC08:PRE:TOAR:nir", "nbits": 14, "wavelength_unit": "nm", "wavelength_min": 850.55, "processing_level": "TOAR", "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Near Infrared", "tags": ["spectral", "nir", "near-infrared", "30m", "landsat"], "resolution_unit": "m", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "name_common": "nir", "vendor_order": 5, "name": "nir", "type": "spectral", "data_range": [0, 10000], "wavelength_fwhm": 28.3, "owner_type": "core", "nodata": null, "resolution": 30}, "band": 1, "colorInterpretation": "Gray", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "14"}}}, {"description": {"product": "landsat:LC08:PRE:TOAR", "nbits": 1, "description": "Alpha (valid data)", "data_description": "0: nodata, 1: valid data", "tags": ["mask", "alpha", "15m", "landsat"], "color": "Alpha", "dtype": "UInt16", "data_range": [0, 1], "resolution": 15, "resolution_unit": "m", "data_unit_description": "unitless", "name_common": "alpha", "type": "mask", "owner_type": "core", "nodata": null, "default_range": [0, 1], "id": "landsat:LC08:PRE:TOAR:alpha", "name": "alpha"}, "band": 2, "colorInterpretation": "Alpha", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "1"}}}], "coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 15N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-93],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32615\\"]]"}, "geoTransform": [384219.440777, 600.0, 0.0, 4580160.51059, 0.0, -600.0], "size": [120, 122], "metadata": {"": {"id": "*", "Corder": "RPCL"}}}',
    ),  # noqa
    '{"bands": ["nir", "alpha"], "data_type": "Int32", "inputs": ["landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1"], "resolution": 600}': (
        np.stack([np.zeros((122, 120), dtype="int32"), alpha]),
        '{"files": [], "cornerCoordinates": {"upperRight": [456219.441, 4580160.511], "lowerLeft": [384219.441, 4506960.511], "lowerRight": [456219.441, 4506960.511], "upperLeft": [384219.441, 4580160.511], "center": [420219.441, 4543560.511]}, "wgs84Extent": {"type": "Polygon", "coordinates": [[[-94.3843159, 41.3646333], [-94.3705723, 40.7054251], [-93.5183204, 40.7123983], [-93.5235196, 41.3717692], [-94.3843159, 41.3646333]]]}, "driverShortName": "MEM", "driverLongName": "In Memory Raster", "bands": [{"description": {"default_range": [0, 10000], "wavelength_max": 878.85, "data_unit": "TOAR", "wavelength_center": 864.7, "color": "Gray", "dtype": "UInt16", "name_vendor": "B5", "id": "landsat:LC08:PRE:TOAR:nir", "nbits": 14, "wavelength_unit": "nm", "wavelength_min": 850.55, "processing_level": "TOAR", "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Near Infrared", "tags": ["spectral", "nir", "near-infrared", "30m", "landsat"], "resolution_unit": "m", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "name_common": "nir", "vendor_order": 5, "name": "nir", "type": "spectral", "data_range": [0, 10000], "wavelength_fwhm": 28.3, "owner_type": "core", "nodata": null, "resolution": 30}, "band": 1, "colorInterpretation": "Gray", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "14"}}}, {"description": {"product": "landsat:LC08:PRE:TOAR", "nbits": 1, "description": "Alpha (valid data)", "data_description": "0: nodata, 1: valid data", "tags": ["mask", "alpha", "15m", "landsat"], "color": "Alpha", "dtype": "UInt16", "data_range": [0, 1], "resolution": 15, "resolution_unit": "m", "data_unit_description": "unitless", "name_common": "alpha", "type": "mask", "owner_type": "core", "nodata": null, "default_range": [0, 1], "id": "landsat:LC08:PRE:TOAR:alpha", "name": "alpha"}, "band": 2, "colorInterpretation": "Alpha", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "1"}}}], "coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 15N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-93],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32615\\"]]"}, "geoTransform": [384219.440777, 600.0, 0.0, 4580160.51059, 0.0, -600.0], "size": [120, 122], "metadata": {"": {"id": "*", "Corder": "RPCL"}}}',
    ),  # noqa
    '{"bands": ["nir", "red", "alpha"], "data_type": "UInt16", "inputs": ["landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1"], "resolution": 600}': (
        np.stack(
            [
                np.zeros((122, 120), dtype="uint16"),
                np.zeros((122, 120), dtype="uint16"),
                alpha,
            ]
        ),
        '{"files": [], "cornerCoordinates": {"upperRight": [456219.441, 4580160.511], "lowerLeft": [384219.441, 4506960.511], "lowerRight": [456219.441, 4506960.511], "upperLeft": [384219.441, 4580160.511], "center": [420219.441, 4543560.511]}, "wgs84Extent": {"type": "Polygon", "coordinates": [[[-94.3843159, 41.3646333], [-94.3705723, 40.7054251], [-93.5183204, 40.7123983], [-93.5235196, 41.3717692], [-94.3843159, 41.3646333]]]}, "driverShortName": "MEM", "driverLongName": "In Memory Raster", "bands": [{"description": {"default_range": [0, 10000], "wavelength_max": 878.85, "data_unit": "TOAR", "wavelength_center": 864.7, "color": "Gray", "dtype": "UInt16", "name_vendor": "B5", "id": "landsat:LC08:PRE:TOAR:nir", "nbits": 14, "wavelength_unit": "nm", "wavelength_min": 850.55, "processing_level": "TOAR", "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Near Infrared", "tags": ["spectral", "nir", "near-infrared", "30m", "landsat"], "resolution_unit": "m", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "name_common": "nir", "vendor_order": 5, "name": "nir", "type": "spectral", "data_range": [0, 10000], "wavelength_fwhm": 28.3, "owner_type": "core", "nodata": null, "resolution": 30}, "band": 1, "colorInterpretation": "Gray", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "14"}}}, {"description": {"default_range": [0, 4000], "wavelength_max": 673.35, "data_unit": "TOAR", "wavelength_center": 654.6, "color": "Red", "dtype": "UInt16", "name_vendor": "B4", "id": "landsat:LC08:PRE:TOAR:red", "nbits": 14, "wavelength_unit": "nm", "wavelength_min": 635.85, "processing_level": "TOAR", "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Red, Pansharpened", "tags": ["spectral", "red", "15m", "landsat"], "resolution_unit": "m", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "name_common": "red", "vendor_order": 4, "name": "red", "type": "spectral", "data_range": [0, 10000], "wavelength_fwhm": 37.5, "owner_type": "core", "nodata": null, "resolution": 15}, "band": 2, "colorInterpretation": "Red", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "14"}}}, {"description": {"product": "landsat:LC08:PRE:TOAR", "nbits": 1, "description": "Alpha (valid data)", "data_description": "0: nodata, 1: valid data", "tags": ["mask", "alpha", "15m", "landsat"], "color": "Alpha", "dtype": "UInt16", "data_range": [0, 1], "resolution": 15, "resolution_unit": "m", "data_unit_description": "unitless", "name_common": "alpha", "type": "mask", "owner_type": "core", "nodata": null, "default_range": [0, 1], "id": "landsat:LC08:PRE:TOAR:alpha", "name": "alpha"}, "band": 3, "colorInterpretation": "Alpha", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "1"}}}], "coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 15N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-93],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32615\\"]]"}, "geoTransform": [384219.440777, 600.0, 0.0, 4580160.51059, 0.0, -600.0], "size": [120, 122], "metadata": {"": {"id": "*", "Corder": "RPCL"}}}',
    ),  # noqa
    '{"bands": ["nir", "red"], "data_type": "UInt16", "inputs": ["landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1"], "resolution": 600}': (
        np.stack(
            [np.zeros((122, 120), dtype="uint16"), np.zeros((122, 120), dtype="uint16")]
        ),
        '{"files": [], "cornerCoordinates": {"upperRight": [456219.441, 4580160.511], "lowerLeft": [384219.441, 4506960.511], "lowerRight": [456219.441, 4506960.511], "upperLeft": [384219.441, 4580160.511], "center": [420219.441, 4543560.511]}, "wgs84Extent": {"type": "Polygon", "coordinates": [[[-94.3843159, 41.3646333], [-94.3705723, 40.7054251], [-93.5183204, 40.7123983], [-93.5235196, 41.3717692], [-94.3843159, 41.3646333]]]}, "driverShortName": "MEM", "driverLongName": "In Memory Raster", "bands": [{"description": {"default_range": [0, 10000], "wavelength_max": 878.85, "data_unit": "TOAR", "wavelength_center": 864.7, "color": "Gray", "dtype": "UInt16", "name_vendor": "B5", "id": "landsat:LC08:PRE:TOAR:nir", "nbits": 14, "wavelength_unit": "nm", "wavelength_min": 850.55, "processing_level": "TOAR", "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Near Infrared", "tags": ["spectral", "nir", "near-infrared", "30m", "landsat"], "resolution_unit": "m", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "name_common": "nir", "vendor_order": 5, "name": "nir", "type": "spectral", "data_range": [0, 10000], "wavelength_fwhm": 28.3, "owner_type": "core", "nodata": null, "resolution": 30}, "band": 1, "colorInterpretation": "Gray", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "14"}}}, {"description": {"default_range": [0, 4000], "wavelength_max": 673.35, "data_unit": "TOAR", "wavelength_center": 654.6, "color": "Red", "dtype": "UInt16", "name_vendor": "B4", "id": "landsat:LC08:PRE:TOAR:red", "nbits": 14, "wavelength_unit": "nm", "wavelength_min": 635.85, "processing_level": "TOAR", "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Red, Pansharpened", "tags": ["spectral", "red", "15m", "landsat"], "resolution_unit": "m", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "name_common": "red", "vendor_order": 4, "name": "red", "type": "spectral", "data_range": [0, 10000], "wavelength_fwhm": 37.5, "owner_type": "core", "nodata": null, "resolution": 15}, "band": 2, "colorInterpretation": "Red", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "14"}}}, {"description": {"product": "landsat:LC08:PRE:TOAR", "nbits": 1, "description": "Alpha (valid data)", "data_description": "0: nodata, 1: valid data", "tags": ["mask", "alpha", "15m", "landsat"], "color": "Alpha", "dtype": "UInt16", "data_range": [0, 1], "resolution": 15, "resolution_unit": "m", "data_unit_description": "unitless", "name_common": "alpha", "type": "mask", "owner_type": "core", "nodata": null, "default_range": [0, 1], "id": "landsat:LC08:PRE:TOAR:alpha", "name": "alpha"}, "band": 3, "colorInterpretation": "Alpha", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "1"}}}], "coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 15N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-93],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32615\\"]]"}, "geoTransform": [384219.440777, 600.0, 0.0, 4580160.51059, 0.0, -600.0], "size": [120, 122], "metadata": {"": {"id": "*", "Corder": "RPCL"}}}',
    ),  # noqa
    '{"bands": ["red", "alpha"], "data_type": "UInt16", "inputs": ["landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1"], "resolution": 600}': (
        np.stack([np.zeros((122, 120), dtype="uint16"), alpha]),
        '{"files": [], "cornerCoordinates": {"upperRight": [456219.441, 4580160.511], "lowerLeft": [384219.441, 4506960.511], "lowerRight": [456219.441, 4506960.511], "upperLeft": [384219.441, 4580160.511], "center": [420219.441, 4543560.511]}, "wgs84Extent": {"type": "Polygon", "coordinates": [[[-94.3843159, 41.3646333], [-94.3705723, 40.7054251], [-93.5183204, 40.7123983], [-93.5235196, 41.3717692], [-94.3843159, 41.3646333]]]}, "driverShortName": "MEM", "driverLongName": "In Memory Raster", "bands": [{"description": {"default_range": [0, 4000], "wavelength_max": 673.35, "data_unit": "TOAR", "wavelength_center": 654.6, "color": "Red", "dtype": "UInt16", "name_vendor": "B4", "id": "landsat:LC08:PRE:TOAR:red", "nbits": 14, "wavelength_unit": "nm", "wavelength_min": 635.85, "processing_level": "TOAR", "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "Top of atmosphere reflectance", "description": "Red, Pansharpened", "tags": ["spectral", "red", "15m", "landsat"], "resolution_unit": "m", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "name_common": "red", "vendor_order": 4, "name": "red", "type": "spectral", "data_range": [0, 10000], "wavelength_fwhm": 37.5, "owner_type": "core", "nodata": null, "resolution": 15}, "band": 1, "colorInterpretation": "Red", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "14"}}}, {"description": {"product": "landsat:LC08:PRE:TOAR", "nbits": 1, "description": "Alpha (valid data)", "data_description": "0: nodata, 1: valid data", "tags": ["mask", "alpha", "15m", "landsat"], "color": "Alpha", "dtype": "UInt16", "data_range": [0, 1], "resolution": 15, "resolution_unit": "m", "data_unit_description": "unitless", "name_common": "alpha", "type": "mask", "owner_type": "core", "nodata": null, "default_range": [0, 1], "id": "landsat:LC08:PRE:TOAR:alpha", "name": "alpha"}, "band": 2, "colorInterpretation": "Alpha", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "1"}}}], "coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 15N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-93],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32615\\"]]"}, "geoTransform": [384219.440777, 600.0, 0.0, 4580160.51059, 0.0, -600.0], "size": [120, 122], "metadata": {"": {"id": "*", "Corder": "RPCL"}}}',
    ),  # noqa
    '{"bands": ["alpha"], "data_type": "UInt16", "inputs": ["landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1"], "resolution": 600}': (
        np.stack([alpha]),
        '{"files": [], "cornerCoordinates": {"upperRight": [456219.441, 4580160.511], "lowerLeft": [384219.441, 4506960.511], "lowerRight": [456219.441, 4506960.511], "upperLeft": [384219.441, 4580160.511], "center": [420219.441, 4543560.511]}, "wgs84Extent": {"type": "Polygon", "coordinates": [[[-94.3843159, 41.3646333], [-94.3705723, 40.7054251], [-93.5183204, 40.7123983], [-93.5235196, 41.3717692], [-94.3843159, 41.3646333]]]}, "driverShortName": "MEM", "driverLongName": "In Memory Raster", "bands": [{"band": 1, "description": {"product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "description": "Alpha (valid data)", "tags": ["mask", "alpha", "15m", "landsat"], "color": "Alpha", "dtype": "UInt16", "data_description": "0: nodata, 1: valid data", "name_common": "alpha", "id": "landsat:LC08:PRE:TOAR:alpha", "nbits": 1, "name": "alpha", "type": "mask", "data_range": [0, 1], "resolution_unit": "m", "default_range": [0, 1], "owner_type": "core", "nodata": null, "resolution": 15}, "colorInterpretation": "Alpha", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "1"}}}], "coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 15N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-93],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32615\\"]]"}, "geoTransform": [384219.440777, 600.0, 0.0, 4580160.51059, 0.0, -600.0], "metadata": {"": {"id": "*", "Corder": "RPCL"}}, "size": [120, 122]}',
    ),  # noqa
    '{"bands": ["nir"], "data_type": "UInt16", "inputs": ["landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "landsat:LC08:PRE:TOAR:meta_LC80260322016197_v1"], "resolution": 600}': (
        np.zeros((122, 120), dtype="uint16"),
        '{"files": [], "cornerCoordinates": {"upperRight": [456219.441, 4580160.511], "lowerLeft": [384219.441, 4506960.511], "lowerRight": [456219.441, 4506960.511], "upperLeft": [384219.441, 4580160.511], "center": [420219.441, 4543560.511]}, "wgs84Extent": {"type": "Polygon", "coordinates": [[[-94.3843159, 41.3646333], [-94.3705723, 40.7054251], [-93.5183204, 40.7123983], [-93.5235196, 41.3717692], [-94.3843159, 41.3646333]]]}, "driverShortName": "MEM", "driverLongName": "In Memory Raster", "bands": [{"band": 1, "description": {"wavelength_max": 878.85, "data_unit_description": "Top of atmosphere reflectance", "data_unit": "TOAR", "description": "Near Infrared", "tags": ["spectral", "nir", "near-infrared", "30m", "landsat"], "color": "Gray", "dtype": "UInt16", "wavelength_min": 850.55, "name_vendor": "B5", "product": "landsat:LC08:PRE:TOAR", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "physical_range": [0.0, 1.0], "name_common": "nir", "id": "landsat:LC08:PRE:TOAR:nir", "vendor_order": 5, "nbits": 14, "type": "spectral", "name": "nir", "wavelength_center": 864.7, "data_range": [0, 10000], "resolution_unit": "m", "wavelength_unit": "nm", "resolution": 30, "wavelength_fwhm": 28.3, "owner_type": "core", "nodata": null, "default_range": [0, 10000], "processing_level": "TOAR"}, "colorInterpretation": "Gray", "type": "UInt16", "block": [120, 1], "metadata": {"": {"NBITS": "14"}}}], "coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 15N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-93],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32615\\"]]"}, "geoTransform": [384219.440777, 600.0, 0.0, 4580160.51059, 0.0, -600.0], "metadata": {"": {"id": "*", "Corder": "RPCL"}}, "size": [120, 122]}',
    ),  # noqa
    '{"bands": ["red", "alpha"], "data_type": "UInt16", "inputs": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "resolution": 1000}': (
        np.stack([np.zeros((239, 235), dtype="uint16"), alpha1000]),
        '{"metadata": {"": {"Corder": "RPCL", "id": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1"}}, "driverShortName": "MEM", "wgs84Extent": {"coordinates": [[[-95.9559596, 42.8041728], [-95.8589268, 40.654253], [-93.0793836, 40.6896344], [-93.0820826, 42.8423136], [-95.9559596, 42.8041728]]], "type": "Polygon"}, "geoTransform": [258292.5, 1000.0, 0.0, 4743307.5, 0.0, -1000.0], "coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 15N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-93],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32615\\"]]"}, "cornerCoordinates": {"upperRight": [493292.5, 4743307.5], "center": [375792.5, 4623807.5], "upperLeft": [258292.5, 4743307.5], "lowerRight": [493292.5, 4504307.5], "lowerLeft": [258292.5, 4504307.5]}, "files": [], "bands": [{"block": [235, 1], "metadata": {"": {"NBITS": "14"}}, "type": "UInt16", "description": {"nodata": null, "data_unit_description": "Top of atmosphere reflectance", "id": "landsat:LC08:PRE:TOAR:red", "processing_level": "TOAR", "description": "Red, Pansharpened", "resolution_unit": "m", "wavelength_max": 673.35, "product": "landsat:LC08:PRE:TOAR", "nbits": 14, "wavelength_unit": "nm", "color": "Red", "name_common": "red", "name": "red", "name_vendor": "B4", "data_unit": "TOAR", "data_range": [0, 10000], "wavelength_min": 635.85, "type": "spectral", "dtype": "UInt16", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "owner_type": "core", "tags": ["spectral", "red", "15m", "landsat"], "physical_range": [0.0, 1.0], "default_range": [0, 4000], "vendor_order": 4, "resolution": 15, "wavelength_center": 654.6, "wavelength_fwhm": 37.5}, "band": 1, "colorInterpretation": "Red"}, {"block": [235, 1], "metadata": {"": {"NBITS": "1"}}, "type": "UInt16", "description": {"nodata": null, "color": "Alpha", "type": "mask", "id": "landsat:LC08:PRE:TOAR:alpha", "description": "Alpha (valid data)", "resolution_unit": "m", "data_description": "0: nodata, 1: valid data", "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "nbits": 1, "owner_type": "core", "tags": ["mask", "alpha", "15m", "landsat"], "name_common": "alpha", "default_range": [0, 1], "name": "alpha", "data_range": [0, 1], "dtype": "UInt16", "resolution": 15}, "band": 2, "colorInterpretation": "Alpha"}], "size": [235, 239], "driverLongName": "In Memory Raster"}',
    ),  # noqa
    '{"bands": ["red", "green"], "data_type": "Int32", "inputs": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "resolution": 600}': (
        np.stack(
            [np.zeros((122, 120), dtype="int32"), np.zeros((122, 120), dtype="int32")]
        ),
        '{"metadata": {"": {"Corder": "RPCL", "id": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1"}}, "driverShortName": "MEM", "wgs84Extent": {"coordinates": [[[-95.9559596, 42.8041728], [-95.8589268, 40.654253], [-93.0793836, 40.6896344], [-93.0820826, 42.8423136], [-95.9559596, 42.8041728]]], "type": "Polygon"}, "geoTransform": [258292.5, 1000.0, 0.0, 4743307.5, 0.0, -1000.0], "coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 15N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-93],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32615\\"]]"}, "cornerCoordinates": {"upperRight": [493292.5, 4743307.5], "center": [375792.5, 4623807.5], "upperLeft": [258292.5, 4743307.5], "lowerRight": [493292.5, 4504307.5], "lowerLeft": [258292.5, 4504307.5]}, "files": [], "bands": [{"block": [235, 1], "mask": {"flags": ["PER_DATASET", "ALPHA"], "overviews": []}, "metadata": {"": {"NBITS": "14"}}, "type": "UInt16", "description": {"nodata": null, "data_unit_description": "Top of atmosphere reflectance", "id": "landsat:LC08:PRE:TOAR:red", "processing_level": "TOAR", "description": "Red, Pansharpened", "resolution_unit": "m", "wavelength_max": 673.35, "product": "landsat:LC08:PRE:TOAR", "nbits": 14, "wavelength_unit": "nm", "color": "Red", "name_common": "red", "name": "red", "name_vendor": "B4", "data_unit": "TOAR", "data_range": [0, 10000], "wavelength_min": 635.85, "type": "spectral", "dtype": "UInt16", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "owner_type": "core", "tags": ["spectral", "red", "15m", "landsat"], "physical_range": [0.0, 1.0], "default_range": [0, 4000], "vendor_order": 4, "resolution": 15, "wavelength_center": 654.6, "wavelength_fwhm": 37.5}, "band": 1, "colorInterpretation": "Red"}, {"block": [235, 1], "mask": {"flags": ["PER_DATASET", "ALPHA"], "overviews": []}, "metadata": {"": {"NBITS": "14"}}, "type": "UInt16", "description": {"nodata": null, "data_unit_description": "Top of atmosphere reflectance", "id": "landsat:LC08:PRE:TOAR:green", "processing_level": "TOAR", "description": "Green, Pansharpened", "resolution_unit": "m", "wavelength_max": 590.05, "product": "landsat:LC08:PRE:TOAR", "nbits": 14, "wavelength_unit": "nm", "color": "Green", "name_common": "green", "name": "green", "name_vendor": "B3", "data_unit": "TOAR", "data_range": [0, 10000], "wavelength_min": 532.75, "type": "spectral", "dtype": "UInt16", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "owner_type": "core", "tags": ["spectral", "green", "15m", "landsat"], "physical_range": [0.0, 1.0], "default_range": [0, 4000], "vendor_order": 3, "resolution": 15, "wavelength_center": 561.4, "wavelength_fwhm": 57.3}, "band": 2, "colorInterpretation": "Green"}], "size": [235, 239], "driverLongName": "In Memory Raster"}',
    ),  # noqa
    '{"bands": ["red", "green", "blue", "alpha"], "data_type": "UInt16", "inputs": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "resolution": 1000}': (
        np.stack(
            [
                np.zeros((239, 235), dtype="uint16"),
                np.zeros((239, 235), dtype="uint16"),
                np.zeros((239, 235), dtype="uint16"),
                alpha1000,
            ]
        ),
        '{"metadata": {"": {"Corder": "RPCL", "id": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1"}}, "driverShortName": "MEM", "wgs84Extent": {"coordinates": [[[-95.9559596, 42.8041728], [-95.8589268, 40.654253], [-93.0793836, 40.6896344], [-93.0820826, 42.8423136], [-95.9559596, 42.8041728]]], "type": "Polygon"}, "geoTransform": [258292.5, 1000.0, 0.0, 4743307.5, 0.0, -1000.0], "coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 15N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-93],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32615\\"]]"}, "cornerCoordinates": {"upperRight": [493292.5, 4743307.5], "center": [375792.5, 4623807.5], "upperLeft": [258292.5, 4743307.5], "lowerRight": [493292.5, 4504307.5], "lowerLeft": [258292.5, 4504307.5]}, "files": [], "bands": [{"block": [235, 1], "mask": {"flags": ["PER_DATASET", "ALPHA"], "overviews": []}, "metadata": {"": {"NBITS": "14"}}, "type": "UInt16", "description": {"nodata": null, "data_unit_description": "Top of atmosphere reflectance", "id": "landsat:LC08:PRE:TOAR:red", "processing_level": "TOAR", "description": "Red, Pansharpened", "resolution_unit": "m", "wavelength_max": 673.35, "product": "landsat:LC08:PRE:TOAR", "nbits": 14, "wavelength_unit": "nm", "color": "Red", "name_common": "red", "name": "red", "name_vendor": "B4", "data_unit": "TOAR", "data_range": [0, 10000], "wavelength_min": 635.85, "type": "spectral", "dtype": "UInt16", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "owner_type": "core", "tags": ["spectral", "red", "15m", "landsat"], "physical_range": [0.0, 1.0], "default_range": [0, 4000], "vendor_order": 4, "resolution": 15, "wavelength_center": 654.6, "wavelength_fwhm": 37.5}, "band": 1, "colorInterpretation": "Red"}, {"block": [235, 1], "mask": {"flags": ["PER_DATASET", "ALPHA"], "overviews": []}, "metadata": {"": {"NBITS": "14"}}, "type": "UInt16", "description": {"nodata": null, "data_unit_description": "Top of atmosphere reflectance", "id": "landsat:LC08:PRE:TOAR:green", "processing_level": "TOAR", "description": "Green, Pansharpened", "resolution_unit": "m", "wavelength_max": 590.05, "product": "landsat:LC08:PRE:TOAR", "nbits": 14, "wavelength_unit": "nm", "color": "Green", "name_common": "green", "name": "green", "name_vendor": "B3", "data_unit": "TOAR", "data_range": [0, 10000], "wavelength_min": 532.75, "type": "spectral", "dtype": "UInt16", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "owner_type": "core", "tags": ["spectral", "green", "15m", "landsat"], "physical_range": [0.0, 1.0], "default_range": [0, 4000], "vendor_order": 3, "resolution": 15, "wavelength_center": 561.4, "wavelength_fwhm": 57.3}, "band": 2, "colorInterpretation": "Green"}, {"block": [235, 1], "mask": {"flags": ["PER_DATASET", "ALPHA"], "overviews": []}, "metadata": {"": {"NBITS": "14"}}, "type": "UInt16", "description": {"nodata": null, "data_unit_description": "Top of atmosphere reflectance", "id": "landsat:LC08:PRE:TOAR:blue", "processing_level": "TOAR", "description": "Blue, Pansharpened", "resolution_unit": "m", "wavelength_max": 512.0, "product": "landsat:LC08:PRE:TOAR", "nbits": 14, "wavelength_unit": "nm", "color": "Blue", "name_common": "blue", "name": "blue", "name_vendor": "B2", "data_unit": "TOAR", "data_range": [0, 10000], "wavelength_min": 452.0, "type": "spectral", "dtype": "UInt16", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "owner_type": "core", "tags": ["spectral", "blue", "15m", "landsat"], "physical_range": [0.0, 1.0], "default_range": [0, 4000], "vendor_order": 2, "resolution": 15, "wavelength_center": 482, "wavelength_fwhm": 60}, "band": 3, "colorInterpretation": "Blue"}, {"block": [235, 1], "metadata": {"": {"NBITS": "1"}}, "type": "UInt16", "description": {"nodata": null, "color": "Alpha", "type": "mask", "id": "landsat:LC08:PRE:TOAR:alpha", "description": "Alpha (valid data)", "resolution_unit": "m", "data_description": "0: nodata, 1: valid data", "product": "landsat:LC08:PRE:TOAR", "data_unit_description": "unitless", "nbits": 1, "owner_type": "core", "tags": ["mask", "alpha", "15m", "landsat"], "name_common": "alpha", "default_range": [0, 1], "name": "alpha", "data_range": [0, 1], "dtype": "UInt16", "resolution": 15}, "band": 4, "colorInterpretation": "Alpha"}], "size": [235, 239], "driverLongName": "In Memory Raster"}',
    ),  # noqa
    '{"bands": ["red", "nir"], "data_type": "UInt16", "inputs": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1", "resolution": 1000}': (
        np.stack(
            [np.zeros((239, 235), dtype="uint16"), np.zeros((239, 235), dtype="uint16")]
        ),
        '{"metadata": {"": {"Corder": "RPCL", "id": "landsat:LC08:PRE:TOAR:meta_LC80270312016188_v1"}}, "driverShortName": "MEM", "wgs84Extent": {"coordinates": [[[-95.9559596, 42.8041728], [-95.8589268, 40.654253], [-93.0793836, 40.6896344], [-93.0820826, 42.8423136], [-95.9559596, 42.8041728]]], "type": "Polygon"}, "geoTransform": [258292.5, 1000.0, 0.0, 4743307.5, 0.0, -1000.0], "coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 15N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-93],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32615\\"]]"}, "cornerCoordinates": {"upperRight": [493292.5, 4743307.5], "center": [375792.5, 4623807.5], "upperLeft": [258292.5, 4743307.5], "lowerRight": [493292.5, 4504307.5], "lowerLeft": [258292.5, 4504307.5]}, "files": [], "bands": [{"block": [235, 1], "metadata": {"": {"NBITS": "14"}}, "type": "UInt16", "description": {"nodata": null, "data_unit_description": "Top of atmosphere reflectance", "id": "landsat:LC08:PRE:TOAR:red", "processing_level": "TOAR", "description": "Red, Pansharpened", "resolution_unit": "m", "wavelength_max": 673.35, "product": "landsat:LC08:PRE:TOAR", "nbits": 14, "wavelength_unit": "nm", "color": "Red", "name_common": "red", "name": "red", "name_vendor": "B4", "data_unit": "TOAR", "data_range": [0, 10000], "wavelength_min": 635.85, "type": "spectral", "dtype": "UInt16", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "owner_type": "core", "tags": ["spectral", "red", "15m", "landsat"], "physical_range": [0.0, 1.0], "default_range": [0, 4000], "vendor_order": 4, "resolution": 15, "wavelength_center": 654.6, "wavelength_fwhm": 37.5}, "band": 1, "colorInterpretation": "Red"}, {"block": [235, 1], "metadata": {"": {"NBITS": "14"}}, "type": "UInt16", "description": {"nodata": null, "data_unit_description": "Top of atmosphere reflectance", "id": "landsat:LC08:PRE:TOAR:nir", "processing_level": "TOAR", "description": "Near Infrared", "resolution_unit": "m", "wavelength_max": 878.85, "product": "landsat:LC08:PRE:TOAR", "nbits": 14, "wavelength_unit": "nm", "color": "Gray", "name_common": "nir", "name": "nir", "name_vendor": "B5", "data_unit": "TOAR", "data_range": [0, 10000], "wavelength_min": 850.55, "type": "spectral", "dtype": "UInt16", "data_description": "TOAR, 0-10000 is 0 - 100% reflective", "owner_type": "core", "tags": ["spectral", "nir", "near-infrared", "30m", "landsat"], "physical_range": [0.0, 1.0], "default_range": [0, 10000], "vendor_order": 5, "resolution": 30, "wavelength_center": 864.7, "wavelength_fwhm": 28.3}, "band": 2, "colorInterpretation": "Gray"}], "size": [235, 239], "driverLongName": "In Memory Raster"}',
    ),  # noqa
    '{"bands": ["Clear_sky_days", "Clear_sky_nights"], "data_type": "Byte", "inputs": "modis:mod11a2:006:meta_MOD11A2.A2017305.h09v05.006.2017314042814_v1", "resolution": 1000}': (
        np.stack(
            [np.zeros((688, 473), dtype="uint16"), np.zeros((688, 473), dtype="uint16")]
        ),
        '{"files": [],"cornerCoordinates": {"upperRight": [340252.341, 6855234.987], "lowerLeft": [298972.341, 6826854.987], "lowerRight": [340252.341, 6826854.987], "upperLeft": [298972.341, 6855234.987], "center": [319612.341, 6841044.987]},"wgs84Extent": {"type": "Polygon", "coordinates": [[[-144.8118058, 61.7770149],   [-144.7805921, 61.5228056],   [-144.0056918, 61.5420874],   [-144.0305346, 61.7965016],   [-144.8118058, 61.7770149]]]},"driverShortName": "MEM","driverLongName": "In Memory Raster","bands": [{"description": {"default_range": [0, 4000],   "wavelength_max": 680.0,   "data_unit": "TOAR",   "color": "Red",   "dtype": "UInt16",   "name_vendor": "B4",   "type": "spectral",   "id": "sentinel-2:L1C:red",   "nbits": 14,   "wavelength_unit": "nm",   "wavelength_min": 650.0,   "processing_level": "TOAR",   "product": "sentinel-2:L1C",   "data_unit_description": "Top of atmosphere reflectance",   "description": "Red",   "tags": ["spectral", "red", "10m", "sentinel-2"],   "resolution_unit": "m",   "vendor_order": 4,   "physical_range": [0.0, 1.0],   "name_common": "red",   "data_description": "TOAR, 0-10000 is 0 - 100% reflective",   "name": "red",   "wavelength_center": 665,   "data_range": [0, 10000],   "wavelength_fwhm": 30,   "owner_type": "core",   "nodata": null,   "resolution": 10},  "mask": {"overviews": [], "flags": ["PER_DATASET", "ALPHA"]},  "band": 1,  "colorInterpretation": "Red",  "type": "Byte",  "block": [688, 1],  "metadata": {"": {"NBITS": "14"}}}, {"description": {"default_range": [0, 4000],   "wavelength_max": 577.5,   "data_unit": "TOAR",   "color": "Green",   "dtype": "UInt16",   "name_vendor": "B3",   "type": "spectral",   "id": "sentinel-2:L1C:green",   "nbits": 14,   "wavelength_unit": "nm",   "wavelength_min": 542.5,   "processing_level": "TOAR",   "product": "sentinel-2:L1C",   "data_unit_description": "Top of atmosphere reflectance",   "description": "Green",   "tags": ["spectral", "green", "10m", "sentinel-2"],   "resolution_unit": "m",   "vendor_order": 3,   "physical_range": [0.0, 1.0],   "name_common": "green",   "data_description": "TOAR, 0-10000 is 0 - 100% reflective",   "name": "green",   "wavelength_center": 560,   "data_range": [0, 10000],   "wavelength_fwhm": 35,   "owner_type": "core",   "nodata": null,   "resolution": 10},  "mask": {"overviews": [], "flags": ["PER_DATASET", "ALPHA"]},  "band": 2,  "colorInterpretation": "Green",  "type": "Byte",  "block": [688, 1],  "metadata": {"": {"NBITS": "14"}}}, {"description": {"default_range": [0, 4000],   "wavelength_max": 522.5,   "data_unit": "TOAR",   "color": "Blue",   "dtype": "UInt16",   "name_vendor": "B2",   "type": "spectral",   "id": "sentinel-2:L1C:blue",   "nbits": 14,   "wavelength_unit": "nm",   "wavelength_min": 457.5,   "processing_level": "TOAR",   "product": "sentinel-2:L1C",   "data_unit_description": "Top of atmosphere reflectance",   "description": "Blue",   "tags": ["spectral", "blue", "10m", "sentinel-2"],   "resolution_unit": "m",   "vendor_order": 2,   "physical_range": [0.0, 1.0],   "name_common": "blue",   "data_description": "TOAR, 0-10000 is 0 - 100% reflective",   "name": "blue",   "wavelength_center": 490,   "data_range": [0, 10000],   "wavelength_fwhm": 65,   "owner_type": "core",   "nodata": null,   "resolution": 10},  "mask": {"overviews": [], "flags": ["PER_DATASET", "ALPHA"]},  "band": 3,  "colorInterpretation": "Blue",  "type": "Byte",  "block": [688, 1],  "metadata": {"": {"NBITS": "14"}}}, {"description": {"default_range": [0, 1],   "product": "sentinel-2:L1C",   "nbits": 1,   "description": "Alpha (valid data)",   "tags": ["mask", "alpha", "10m", "sentinel-2"],   "color": "Alpha",   "dtype": "UInt16",   "data_range": [0, 1],   "resolution": 10,   "name": "alpha",   "resolution_unit": "m",   "data_unit_description": "unitless",   "name_common": "alpha",   "owner_type": "core",   "nodata": null,   "type": "mask",   "id": "sentinel-2:L1C:alpha",   "data_description": "0: nodata, 1: valid data"},  "band": 4,  "colorInterpretation": "Alpha",  "type": "Byte",  "block": [688, 1],  "metadata": {"": {"NBITS": "1"}}}],"coordinateSystem": {"wkt": "PROJCS[\\"WGS 84 / UTM zone 7N\\",\\n    GEOGCS[\\"WGS 84\\",\\n        DATUM[\\"WGS_1984\\",\\n            SPHEROID[\\"WGS 84\\",6378137,298.257223563,\\n                AUTHORITY[\\"EPSG\\",\\"7030\\"]],\\n            AUTHORITY[\\"EPSG\\",\\"6326\\"]],\\n        PRIMEM[\\"Greenwich\\",0,\\n            AUTHORITY[\\"EPSG\\",\\"8901\\"]],\\n        UNIT[\\"degree\\",0.0174532925199433,\\n            AUTHORITY[\\"EPSG\\",\\"9122\\"]],\\n        AUTHORITY[\\"EPSG\\",\\"4326\\"]],\\n    PROJECTION[\\"Transverse_Mercator\\"],\\n    PARAMETER[\\"latitude_of_origin\\",0],\\n    PARAMETER[\\"central_meridian\\",-141],\\n    PARAMETER[\\"scale_factor\\",0.9996],\\n    PARAMETER[\\"false_easting\\",500000],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"metre\\",1,\\n        AUTHORITY[\\"EPSG\\",\\"9001\\"]],\\n    AXIS[\\"Easting\\",EAST],\\n    AXIS[\\"Northing\\",NORTH],\\n    AUTHORITY[\\"EPSG\\",\\"32607\\"]]"},"geoTransform": [298972.341031, 60.0, 0.0, 6855234.98696, 0.0, -60.0],"metadata": {"": {"id": "sentinel-2:L1C:2017-08-07_07VCJ_99_S2A_v1",  "Corder": "RPCL"}},"size": [688, 473]}',
    ),  # noqa
    '{"bands": ["Clear_sky_days", "Clear_sky_nights"], "data_type": "Byte", "inputs": ["modis:mod11a2:006:meta_MOD11A2.A2017305.h09v05.006.2017314042814_v1", "modis:mod11a2:006:meta_MOD11A2.A2000049.h08v05.006.2015058135046_v1"], "resolution": 600}': (
        np.stack(
            [
                np.zeros((1853, 3707), dtype="uint16"),
                np.zeros((1853, 3707), dtype="uint16"),
            ]
        ),
        '{"files": [], "cornerCoordinates": {"upperRight": [-8895305.198, 4447802.079], "lowerLeft": [-11119505.198, 3336002.079], "lowerRight": [-8895305.198, 3336002.079], "upperLeft": [-11119505.198, 4447802.079], "center": [-10007405.198, 3891902.079]}, "wgs84Extent": {"type": "Polygon", "coordinates": [[[-130.5407289, 40.0], [-115.4716289, 30.0013537], [-92.3741986, 30.0013537], [-104.4290734, 40.0], [-130.5407289, 40.0]]]}, "driverShortName": "MEM", "driverLongName": "In Memory Raster", "bands": [{"description": {"default_range": [1, 255], "product": "modis:mod11a2:006", "vendor_order": 11, "data_unit": "unitless", "description": "Day clear-sky coverage", "resolution_unit": "meters", "dtype": "Byte", "physical_range": [0.0, 255.0], "data_range": [0, 255], "name_vendor": "Clear_sky_days", "nbits": 8, "type": "spectral", "owner_type": "core", "nodata": 0, "resolution": 1000, "id": "modis:mod11a2:006:Clear_sky_days", "name": "Clear_sky_days"}, "noDataValue": 0.0, "band": 1, "colorInterpretation": "Undefined", "type": "Byte", "block": [3707, 1], "metadata": {"": {"NBITS": "8"}}}, {"description": {"default_range": [1, 255], "product": "modis:mod11a2:006", "vendor_order": 12, "data_unit": "unitless", "description": "Night clear-sky coverage", "resolution_unit": "meters", "dtype": "Byte", "physical_range": [0.0, 255.0], "data_range": [0, 255], "name_vendor": "Clear_sky_nights", "nbits": 8, "type": "spectral", "owner_type": "core", "nodata": 0, "resolution": 1000, "id": "modis:mod11a2:006:Clear_sky_nights", "name": "Clear_sky_nights"}, "noDataValue": 0.0, "band": 2, "colorInterpretation": "Undefined", "type": "Byte", "block": [3707, 1], "metadata": {"": {"NBITS": "8"}}}], "coordinateSystem": {"wkt": "PROJCS[\\"unnamed\\",\\n    GEOGCS[\\"unnamed ellipse\\",\\n        DATUM[\\"unknown\\",\\n            SPHEROID[\\"unnamed\\",6371007.181,0]],\\n        PRIMEM[\\"Greenwich\\",0],\\n        UNIT[\\"degree\\",0.0174532925199433]],\\n    PROJECTION[\\"Sinusoidal\\"],\\n    PARAMETER[\\"longitude_of_center\\",0],\\n    PARAMETER[\\"false_easting\\",0],\\n    PARAMETER[\\"false_northing\\",0],\\n    UNIT[\\"Meter\\",1]]"}, "geoTransform": [-11119505.197665, 600.0, 0.0, 4447802.079066, 0.0, -600.0], "metadata": {"": {"id": "*", "Corder": "RPCL"}}, "size": [3707, 1853]}',
    ),  # noqa
}


def _raster_ndarray(self, **kwargs):
    a, meta = RASTER[
        json.dumps(
            {k: kwargs[k] for k in ("bands", "data_type", "inputs", "resolution")},
            sort_keys=True,
        )
    ]

    if not np.ma.is_masked(a):
        mask = np.zeros(a.shape)
        a = np.ma.array(a, mask=mask)

    return a, json.loads(meta)
