"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosReadOnlyDBInstance = exports.RosPrepayDBInstance = exports.RosDatabase = exports.RosDBInstanceSecurityIps = exports.RosDBInstanceParameterGroup = exports.RosDBInstanceClone = exports.RosDBInstance = exports.RosAccountPrivilege = exports.RosAccount = exports.RosADInfo = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosADInfoProps`
 *
 * @param properties - the TypeScript properties of a `RosADInfoProps`
 *
 * @returns the result of the validation.
 */
function RosADInfoPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('adServerIpAddress', ros.requiredValidator)(properties.adServerIpAddress));
    errors.collect(ros.propertyValidator('adServerIpAddress', ros.validateString)(properties.adServerIpAddress));
    errors.collect(ros.propertyValidator('addns', ros.requiredValidator)(properties.addns));
    errors.collect(ros.propertyValidator('addns', ros.validateString)(properties.addns));
    errors.collect(ros.propertyValidator('dbInstanceId', ros.requiredValidator)(properties.dbInstanceId));
    errors.collect(ros.propertyValidator('dbInstanceId', ros.validateString)(properties.dbInstanceId));
    errors.collect(ros.propertyValidator('adPassword', ros.requiredValidator)(properties.adPassword));
    errors.collect(ros.propertyValidator('adPassword', ros.validateString)(properties.adPassword));
    errors.collect(ros.propertyValidator('adAccountName', ros.requiredValidator)(properties.adAccountName));
    errors.collect(ros.propertyValidator('adAccountName', ros.validateString)(properties.adAccountName));
    return errors.wrap('supplied properties not correct for "RosADInfoProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::RDS::ADInfo` resource
 *
 * @param properties - the TypeScript properties of a `RosADInfoProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::RDS::ADInfo` resource.
 */
// @ts-ignore TS6133
function rosADInfoPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosADInfoPropsValidator(properties).assertSuccess();
    }
    return {
        ADAccountName: ros.stringToRosTemplate(properties.adAccountName),
        ADDNS: ros.stringToRosTemplate(properties.addns),
        ADPassword: ros.stringToRosTemplate(properties.adPassword),
        ADServerIpAddress: ros.stringToRosTemplate(properties.adServerIpAddress),
        DBInstanceId: ros.stringToRosTemplate(properties.dbInstanceId),
    };
}
/**
 * A ROS template type:  `ALIYUN::RDS::ADInfo`
 */
class RosADInfo extends ros.RosResource {
    /**
     * Create a new `ALIYUN::RDS::ADInfo`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosADInfo.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrAddns = this.getAtt('ADDNS');
        this.attrDbInstanceId = this.getAtt('DBInstanceId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.adAccountName = props.adAccountName;
        this.addns = props.addns;
        this.adPassword = props.adPassword;
        this.adServerIpAddress = props.adServerIpAddress;
        this.dbInstanceId = props.dbInstanceId;
    }
    get rosProperties() {
        return {
            adAccountName: this.adAccountName,
            addns: this.addns,
            adPassword: this.adPassword,
            adServerIpAddress: this.adServerIpAddress,
            dbInstanceId: this.dbInstanceId,
        };
    }
    renderProperties(props) {
        return rosADInfoPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosADInfo = RosADInfo;
/**
 * The resource type name for this resource class.
 */
RosADInfo.ROS_RESOURCE_TYPE_NAME = "ALIYUN::RDS::ADInfo";
/**
 * Determine whether the given properties match those of a `RosAccountProps`
 *
 * @param properties - the TypeScript properties of a `RosAccountProps`
 *
 * @returns the result of the validation.
 */
function RosAccountPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('accountDescription', ros.validateString)(properties.accountDescription));
    errors.collect(ros.propertyValidator('dbInstanceId', ros.requiredValidator)(properties.dbInstanceId));
    errors.collect(ros.propertyValidator('dbInstanceId', ros.validateString)(properties.dbInstanceId));
    if (properties.accountType && (typeof properties.accountType) !== 'object') {
        errors.collect(ros.propertyValidator('accountType', ros.validateAllowedValues)({
            data: properties.accountType,
            allowedValues: ["Normal", "Super"],
        }));
    }
    errors.collect(ros.propertyValidator('accountType', ros.validateString)(properties.accountType));
    errors.collect(ros.propertyValidator('accountPassword', ros.requiredValidator)(properties.accountPassword));
    if (properties.accountPassword && (Array.isArray(properties.accountPassword) || (typeof properties.accountPassword) === 'string')) {
        errors.collect(ros.propertyValidator('accountPassword', ros.validateLength)({
            data: properties.accountPassword.length,
            min: 8,
            max: 32,
        }));
    }
    errors.collect(ros.propertyValidator('accountPassword', ros.validateString)(properties.accountPassword));
    errors.collect(ros.propertyValidator('accountName', ros.requiredValidator)(properties.accountName));
    errors.collect(ros.propertyValidator('accountName', ros.validateString)(properties.accountName));
    return errors.wrap('supplied properties not correct for "RosAccountProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::RDS::Account` resource
 *
 * @param properties - the TypeScript properties of a `RosAccountProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::RDS::Account` resource.
 */
// @ts-ignore TS6133
function rosAccountPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosAccountPropsValidator(properties).assertSuccess();
    }
    return {
        AccountName: ros.stringToRosTemplate(properties.accountName),
        AccountPassword: ros.stringToRosTemplate(properties.accountPassword),
        DBInstanceId: ros.stringToRosTemplate(properties.dbInstanceId),
        AccountDescription: ros.stringToRosTemplate(properties.accountDescription),
        AccountType: ros.stringToRosTemplate(properties.accountType),
    };
}
/**
 * A ROS template type:  `ALIYUN::RDS::Account`
 */
class RosAccount extends ros.RosResource {
    /**
     * Create a new `ALIYUN::RDS::Account`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosAccount.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrAccountName = this.getAtt('AccountName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.accountName = props.accountName;
        this.accountPassword = props.accountPassword;
        this.dbInstanceId = props.dbInstanceId;
        this.accountDescription = props.accountDescription;
        this.accountType = props.accountType;
    }
    get rosProperties() {
        return {
            accountName: this.accountName,
            accountPassword: this.accountPassword,
            dbInstanceId: this.dbInstanceId,
            accountDescription: this.accountDescription,
            accountType: this.accountType,
        };
    }
    renderProperties(props) {
        return rosAccountPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosAccount = RosAccount;
/**
 * The resource type name for this resource class.
 */
RosAccount.ROS_RESOURCE_TYPE_NAME = "ALIYUN::RDS::Account";
/**
 * Determine whether the given properties match those of a `RosAccountPrivilegeProps`
 *
 * @param properties - the TypeScript properties of a `RosAccountPrivilegeProps`
 *
 * @returns the result of the validation.
 */
function RosAccountPrivilegePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('accountPrivilege', ros.requiredValidator)(properties.accountPrivilege));
    if (properties.accountPrivilege && (typeof properties.accountPrivilege) !== 'object') {
        errors.collect(ros.propertyValidator('accountPrivilege', ros.validateAllowedValues)({
            data: properties.accountPrivilege,
            allowedValues: ["ReadOnly", "ReadWrite", "DDLOnly", "DMLOnly", "DBOwner"],
        }));
    }
    errors.collect(ros.propertyValidator('accountPrivilege', ros.validateString)(properties.accountPrivilege));
    errors.collect(ros.propertyValidator('dbInstanceId', ros.requiredValidator)(properties.dbInstanceId));
    errors.collect(ros.propertyValidator('dbInstanceId', ros.validateString)(properties.dbInstanceId));
    errors.collect(ros.propertyValidator('dbName', ros.requiredValidator)(properties.dbName));
    errors.collect(ros.propertyValidator('dbName', ros.validateString)(properties.dbName));
    errors.collect(ros.propertyValidator('accountName', ros.requiredValidator)(properties.accountName));
    errors.collect(ros.propertyValidator('accountName', ros.validateString)(properties.accountName));
    return errors.wrap('supplied properties not correct for "RosAccountPrivilegeProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::RDS::AccountPrivilege` resource
 *
 * @param properties - the TypeScript properties of a `RosAccountPrivilegeProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::RDS::AccountPrivilege` resource.
 */
// @ts-ignore TS6133
function rosAccountPrivilegePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosAccountPrivilegePropsValidator(properties).assertSuccess();
    }
    return {
        AccountName: ros.stringToRosTemplate(properties.accountName),
        AccountPrivilege: ros.stringToRosTemplate(properties.accountPrivilege),
        DBInstanceId: ros.stringToRosTemplate(properties.dbInstanceId),
        DBName: ros.stringToRosTemplate(properties.dbName),
    };
}
/**
 * A ROS template type:  `ALIYUN::RDS::AccountPrivilege`
 */
class RosAccountPrivilege extends ros.RosResource {
    /**
     * Create a new `ALIYUN::RDS::AccountPrivilege`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosAccountPrivilege.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.accountName = props.accountName;
        this.accountPrivilege = props.accountPrivilege;
        this.dbInstanceId = props.dbInstanceId;
        this.dbName = props.dbName;
    }
    get rosProperties() {
        return {
            accountName: this.accountName,
            accountPrivilege: this.accountPrivilege,
            dbInstanceId: this.dbInstanceId,
            dbName: this.dbName,
        };
    }
    renderProperties(props) {
        return rosAccountPrivilegePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosAccountPrivilege = RosAccountPrivilege;
/**
 * The resource type name for this resource class.
 */
RosAccountPrivilege.ROS_RESOURCE_TYPE_NAME = "ALIYUN::RDS::AccountPrivilege";
/**
 * Determine whether the given properties match those of a `RosDBInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosDBInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosDBInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.periodType && (typeof properties.periodType) !== 'object') {
        errors.collect(ros.propertyValidator('periodType', ros.validateAllowedValues)({
            data: properties.periodType,
            allowedValues: ["Month", "Year"],
        }));
    }
    errors.collect(ros.propertyValidator('periodType', ros.validateString)(properties.periodType));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    if (properties.archiveBackupRetentionPeriod && (typeof properties.archiveBackupRetentionPeriod) !== 'object') {
        errors.collect(ros.propertyValidator('archiveBackupRetentionPeriod', ros.validateRange)({
            data: properties.archiveBackupRetentionPeriod,
            min: 30,
            max: 1095,
        }));
    }
    errors.collect(ros.propertyValidator('archiveBackupRetentionPeriod', ros.validateNumber)(properties.archiveBackupRetentionPeriod));
    errors.collect(ros.propertyValidator('dbTimeZone', ros.validateString)(properties.dbTimeZone));
    if (properties.port && (typeof properties.port) !== 'object') {
        errors.collect(ros.propertyValidator('port', ros.validateRange)({
            data: properties.port,
            min: 1,
            max: 65535,
        }));
    }
    errors.collect(ros.propertyValidator('port', ros.validateNumber)(properties.port));
    if (properties.archiveBackupKeepCount && (typeof properties.archiveBackupKeepCount) !== 'object') {
        errors.collect(ros.propertyValidator('archiveBackupKeepCount', ros.validateRange)({
            data: properties.archiveBackupKeepCount,
            min: 1,
            max: 31,
        }));
    }
    errors.collect(ros.propertyValidator('archiveBackupKeepCount', ros.validateNumber)(properties.archiveBackupKeepCount));
    if (properties.logBackupRetentionPeriod && (typeof properties.logBackupRetentionPeriod) !== 'object') {
        errors.collect(ros.propertyValidator('logBackupRetentionPeriod', ros.validateRange)({
            data: properties.logBackupRetentionPeriod,
            min: 7,
            max: 730,
        }));
    }
    errors.collect(ros.propertyValidator('logBackupRetentionPeriod', ros.validateNumber)(properties.logBackupRetentionPeriod));
    errors.collect(ros.propertyValidator('dbInstanceStorage', ros.requiredValidator)(properties.dbInstanceStorage));
    errors.collect(ros.propertyValidator('dbInstanceStorage', ros.validateNumber)(properties.dbInstanceStorage));
    errors.collect(ros.propertyValidator('dbMappings', ros.listValidator(RosDBInstance_DBMappingsPropertyValidator))(properties.dbMappings));
    if (properties.connectionStringPrefix && (typeof properties.connectionStringPrefix) !== 'object') {
        errors.collect(ros.propertyValidator('connectionStringPrefix', ros.validateAllowedPattern)({
            data: properties.connectionStringPrefix,
            reg: /[a-zA-Z0-9-]{8,64}/
        }));
    }
    errors.collect(ros.propertyValidator('connectionStringPrefix', ros.validateString)(properties.connectionStringPrefix));
    errors.collect(ros.propertyValidator('multiAz', ros.validateBoolean)(properties.multiAz));
    errors.collect(ros.propertyValidator('engine', ros.requiredValidator)(properties.engine));
    if (properties.engine && (typeof properties.engine) !== 'object') {
        errors.collect(ros.propertyValidator('engine', ros.validateAllowedValues)({
            data: properties.engine,
            allowedValues: ["MySQL", "SQLServer", "PostgreSQL", "PPAS", "MariaDB"],
        }));
    }
    errors.collect(ros.propertyValidator('engine', ros.validateString)(properties.engine));
    errors.collect(ros.propertyValidator('tags', ros.hashValidator(ros.validateAny))(properties.tags));
    errors.collect(ros.propertyValidator('dbInstanceDescription', ros.validateString)(properties.dbInstanceDescription));
    errors.collect(ros.propertyValidator('targetDedicatedHostIdForMaster', ros.validateString)(properties.targetDedicatedHostIdForMaster));
    errors.collect(ros.propertyValidator('engineVersion', ros.requiredValidator)(properties.engineVersion));
    errors.collect(ros.propertyValidator('engineVersion', ros.validateString)(properties.engineVersion));
    errors.collect(ros.propertyValidator('dbInstanceClass', ros.requiredValidator)(properties.dbInstanceClass));
    errors.collect(ros.propertyValidator('dbInstanceClass', ros.validateString)(properties.dbInstanceClass));
    if (properties.archiveBackupKeepPolicy && (typeof properties.archiveBackupKeepPolicy) !== 'object') {
        errors.collect(ros.propertyValidator('archiveBackupKeepPolicy', ros.validateAllowedValues)({
            data: properties.archiveBackupKeepPolicy,
            allowedValues: ["ByMonth", "ByWeek", "KeepAll"],
        }));
    }
    errors.collect(ros.propertyValidator('archiveBackupKeepPolicy', ros.validateString)(properties.archiveBackupKeepPolicy));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    if (properties.backupPolicyMode && (typeof properties.backupPolicyMode) !== 'object') {
        errors.collect(ros.propertyValidator('backupPolicyMode', ros.validateAllowedValues)({
            data: properties.backupPolicyMode,
            allowedValues: ["DataBackupPolicy", "LogBackupPolicy"],
        }));
    }
    errors.collect(ros.propertyValidator('backupPolicyMode', ros.validateString)(properties.backupPolicyMode));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateRange)({
            data: properties.period,
            min: 1,
            max: 9,
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    if (properties.localLogRetentionHours && (typeof properties.localLogRetentionHours) !== 'object') {
        errors.collect(ros.propertyValidator('localLogRetentionHours', ros.validateRange)({
            data: properties.localLogRetentionHours,
            min: 0,
            max: 168,
        }));
    }
    errors.collect(ros.propertyValidator('localLogRetentionHours', ros.validateNumber)(properties.localLogRetentionHours));
    if (properties.payType && (typeof properties.payType) !== 'object') {
        errors.collect(ros.propertyValidator('payType', ros.validateAllowedValues)({
            data: properties.payType,
            allowedValues: ["Subscription", "PrePaid", "PrePay", "Prepaid", "PayAsYouGo", "PostPaid", "PayOnDemand", "Postpaid"],
        }));
    }
    errors.collect(ros.propertyValidator('payType', ros.validateString)(properties.payType));
    if (properties.highSpaceUsageProtection && (typeof properties.highSpaceUsageProtection) !== 'object') {
        errors.collect(ros.propertyValidator('highSpaceUsageProtection', ros.validateAllowedValues)({
            data: properties.highSpaceUsageProtection,
            allowedValues: ["Enable", "Disable"],
        }));
    }
    errors.collect(ros.propertyValidator('highSpaceUsageProtection', ros.validateString)(properties.highSpaceUsageProtection));
    errors.collect(ros.propertyValidator('roleArn', ros.validateString)(properties.roleArn));
    if (properties.masterUserPassword && (Array.isArray(properties.masterUserPassword) || (typeof properties.masterUserPassword) === 'string')) {
        errors.collect(ros.propertyValidator('masterUserPassword', ros.validateLength)({
            data: properties.masterUserPassword.length,
            min: 8,
            max: 32,
        }));
    }
    errors.collect(ros.propertyValidator('masterUserPassword', ros.validateString)(properties.masterUserPassword));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    if (properties.sslSetting && (typeof properties.sslSetting) !== 'object') {
        errors.collect(ros.propertyValidator('sslSetting', ros.validateAllowedValues)({
            data: properties.sslSetting,
            allowedValues: ["Disabled", "EnabledForPublicConnection", "EnabledForInnerConnection"],
        }));
    }
    errors.collect(ros.propertyValidator('sslSetting', ros.validateString)(properties.sslSetting));
    errors.collect(ros.propertyValidator('masterUsername', ros.validateString)(properties.masterUsername));
    errors.collect(ros.propertyValidator('connectionMode', ros.validateString)(properties.connectionMode));
    if (properties.localLogRetentionSpace && (typeof properties.localLogRetentionSpace) !== 'object') {
        errors.collect(ros.propertyValidator('localLogRetentionSpace', ros.validateRange)({
            data: properties.localLogRetentionSpace,
            min: 0,
            max: 50,
        }));
    }
    errors.collect(ros.propertyValidator('localLogRetentionSpace', ros.validateNumber)(properties.localLogRetentionSpace));
    if (properties.category && (typeof properties.category) !== 'object') {
        errors.collect(ros.propertyValidator('category', ros.validateAllowedValues)({
            data: properties.category,
            allowedValues: ["Basic", "HighAvailability", "AlwaysOn", "Finance"],
        }));
    }
    errors.collect(ros.propertyValidator('category', ros.validateString)(properties.category));
    errors.collect(ros.propertyValidator('privateIpAddress', ros.validateString)(properties.privateIpAddress));
    errors.collect(ros.propertyValidator('targetDedicatedHostIdForSlave', ros.validateString)(properties.targetDedicatedHostIdForSlave));
    if (properties.dbInstanceNetType && (typeof properties.dbInstanceNetType) !== 'object') {
        errors.collect(ros.propertyValidator('dbInstanceNetType', ros.validateAllowedValues)({
            data: properties.dbInstanceNetType,
            allowedValues: ["Internet", "Intranet"],
        }));
    }
    errors.collect(ros.propertyValidator('dbInstanceNetType', ros.validateString)(properties.dbInstanceNetType));
    if (properties.releasedKeepPolicy && (typeof properties.releasedKeepPolicy) !== 'object') {
        errors.collect(ros.propertyValidator('releasedKeepPolicy', ros.validateAllowedValues)({
            data: properties.releasedKeepPolicy,
            allowedValues: ["Lastest", "All"],
        }));
    }
    errors.collect(ros.propertyValidator('releasedKeepPolicy', ros.validateString)(properties.releasedKeepPolicy));
    errors.collect(ros.propertyValidator('dedicatedHostGroupId', ros.validateString)(properties.dedicatedHostGroupId));
    errors.collect(ros.propertyValidator('autoRenew', ros.validateBoolean)(properties.autoRenew));
    errors.collect(ros.propertyValidator('encryptionKey', ros.validateString)(properties.encryptionKey));
    errors.collect(ros.propertyValidator('preferredBackupPeriod', ros.listValidator(ros.validateAny))(properties.preferredBackupPeriod));
    if (properties.logBackupLocalRetentionNumber && (typeof properties.logBackupLocalRetentionNumber) !== 'object') {
        errors.collect(ros.propertyValidator('logBackupLocalRetentionNumber', ros.validateRange)({
            data: properties.logBackupLocalRetentionNumber,
            min: 6,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('logBackupLocalRetentionNumber', ros.validateNumber)(properties.logBackupLocalRetentionNumber));
    if (properties.slaveZoneIds && (Array.isArray(properties.slaveZoneIds) || (typeof properties.slaveZoneIds) === 'string')) {
        errors.collect(ros.propertyValidator('slaveZoneIds', ros.validateLength)({
            data: properties.slaveZoneIds.length,
            min: undefined,
            max: 2,
        }));
    }
    errors.collect(ros.propertyValidator('slaveZoneIds', ros.listValidator(ros.validateString))(properties.slaveZoneIds));
    errors.collect(ros.propertyValidator('securityIpList', ros.requiredValidator)(properties.securityIpList));
    errors.collect(ros.propertyValidator('securityIpList', ros.validateString)(properties.securityIpList));
    errors.collect(ros.propertyValidator('dbIsIgnoreCase', ros.validateNumber)(properties.dbIsIgnoreCase));
    errors.collect(ros.propertyValidator('maintainTime', ros.validateString)(properties.maintainTime));
    errors.collect(ros.propertyValidator('dbParamGroupId', ros.validateString)(properties.dbParamGroupId));
    errors.collect(ros.propertyValidator('zoneId', ros.validateString)(properties.zoneId));
    errors.collect(ros.propertyValidator('targetDedicatedHostIdForLog', ros.validateString)(properties.targetDedicatedHostIdForLog));
    errors.collect(ros.propertyValidator('allocatePublicConnection', ros.validateBoolean)(properties.allocatePublicConnection));
    errors.collect(ros.propertyValidator('securityGroupId', ros.validateString)(properties.securityGroupId));
    errors.collect(ros.propertyValidator('preferredBackupTime', ros.validateString)(properties.preferredBackupTime));
    errors.collect(ros.propertyValidator('dbInstanceStorageType', ros.validateString)(properties.dbInstanceStorageType));
    if (properties.backUpCategory && (typeof properties.backUpCategory) !== 'object') {
        errors.collect(ros.propertyValidator('backUpCategory', ros.validateAllowedValues)({
            data: properties.backUpCategory,
            allowedValues: ["Flash", "Standard"],
        }));
    }
    errors.collect(ros.propertyValidator('backUpCategory', ros.validateString)(properties.backUpCategory));
    errors.collect(ros.propertyValidator('compressType', ros.validateNumber)(properties.compressType));
    if (properties.connectionStringType && (typeof properties.connectionStringType) !== 'object') {
        errors.collect(ros.propertyValidator('connectionStringType', ros.validateAllowedValues)({
            data: properties.connectionStringType,
            allowedValues: ["Inner", "Public"],
        }));
    }
    errors.collect(ros.propertyValidator('connectionStringType', ros.validateString)(properties.connectionStringType));
    errors.collect(ros.propertyValidator('logBackupFrequency', ros.validateString)(properties.logBackupFrequency));
    if (properties.masterUserType && (typeof properties.masterUserType) !== 'object') {
        errors.collect(ros.propertyValidator('masterUserType', ros.validateAllowedValues)({
            data: properties.masterUserType,
            allowedValues: ["Normal", "Super", "Sysadmin"],
        }));
    }
    errors.collect(ros.propertyValidator('masterUserType', ros.validateString)(properties.masterUserType));
    errors.collect(ros.propertyValidator('enableBackupLog', ros.validateBoolean)(properties.enableBackupLog));
    if (properties.sqlCollectorStatus && (typeof properties.sqlCollectorStatus) !== 'object') {
        errors.collect(ros.propertyValidator('sqlCollectorStatus', ros.validateAllowedValues)({
            data: properties.sqlCollectorStatus,
            allowedValues: ["Enable", "Disabled"],
        }));
    }
    errors.collect(ros.propertyValidator('sqlCollectorStatus', ros.validateString)(properties.sqlCollectorStatus));
    errors.collect(ros.propertyValidator('backupRetentionPeriod', ros.validateNumber)(properties.backupRetentionPeriod));
    return errors.wrap('supplied properties not correct for "RosDBInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::RDS::DBInstance` resource
 *
 * @param properties - the TypeScript properties of a `RosDBInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::RDS::DBInstance` resource.
 */
// @ts-ignore TS6133
function rosDBInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDBInstancePropsValidator(properties).assertSuccess();
    }
    return {
        DBInstanceClass: ros.stringToRosTemplate(properties.dbInstanceClass),
        DBInstanceStorage: ros.numberToRosTemplate(properties.dbInstanceStorage),
        Engine: ros.stringToRosTemplate(properties.engine),
        EngineVersion: ros.stringToRosTemplate(properties.engineVersion),
        SecurityIPList: ros.stringToRosTemplate(properties.securityIpList),
        AllocatePublicConnection: ros.booleanToRosTemplate(properties.allocatePublicConnection),
        ArchiveBackupKeepCount: ros.numberToRosTemplate(properties.archiveBackupKeepCount),
        ArchiveBackupKeepPolicy: ros.stringToRosTemplate(properties.archiveBackupKeepPolicy),
        ArchiveBackupRetentionPeriod: ros.numberToRosTemplate(properties.archiveBackupRetentionPeriod),
        AutoRenew: ros.booleanToRosTemplate(properties.autoRenew),
        BackUpCategory: ros.stringToRosTemplate(properties.backUpCategory),
        BackupPolicyMode: ros.stringToRosTemplate(properties.backupPolicyMode),
        BackupRetentionPeriod: ros.numberToRosTemplate(properties.backupRetentionPeriod),
        Category: ros.stringToRosTemplate(properties.category),
        CompressType: ros.numberToRosTemplate(properties.compressType),
        ConnectionMode: ros.stringToRosTemplate(properties.connectionMode),
        ConnectionStringPrefix: ros.stringToRosTemplate(properties.connectionStringPrefix),
        ConnectionStringType: ros.stringToRosTemplate(properties.connectionStringType),
        DBInstanceDescription: ros.stringToRosTemplate(properties.dbInstanceDescription),
        DBInstanceNetType: ros.stringToRosTemplate(properties.dbInstanceNetType),
        DBInstanceStorageType: ros.stringToRosTemplate(properties.dbInstanceStorageType),
        DBIsIgnoreCase: ros.numberToRosTemplate(properties.dbIsIgnoreCase),
        DBMappings: ros.listMapper(rosDBInstanceDBMappingsPropertyToRosTemplate)(properties.dbMappings),
        DBParamGroupId: ros.stringToRosTemplate(properties.dbParamGroupId),
        DBTimeZone: ros.stringToRosTemplate(properties.dbTimeZone),
        DedicatedHostGroupId: ros.stringToRosTemplate(properties.dedicatedHostGroupId),
        EnableBackupLog: ros.booleanToRosTemplate(properties.enableBackupLog),
        EncryptionKey: ros.stringToRosTemplate(properties.encryptionKey),
        HighSpaceUsageProtection: ros.stringToRosTemplate(properties.highSpaceUsageProtection),
        LocalLogRetentionHours: ros.numberToRosTemplate(properties.localLogRetentionHours),
        LocalLogRetentionSpace: ros.numberToRosTemplate(properties.localLogRetentionSpace),
        LogBackupFrequency: ros.stringToRosTemplate(properties.logBackupFrequency),
        LogBackupLocalRetentionNumber: ros.numberToRosTemplate(properties.logBackupLocalRetentionNumber),
        LogBackupRetentionPeriod: ros.numberToRosTemplate(properties.logBackupRetentionPeriod),
        MaintainTime: ros.stringToRosTemplate(properties.maintainTime),
        MasterUsername: ros.stringToRosTemplate(properties.masterUsername),
        MasterUserPassword: ros.stringToRosTemplate(properties.masterUserPassword),
        MasterUserType: ros.stringToRosTemplate(properties.masterUserType),
        MultiAZ: ros.booleanToRosTemplate(properties.multiAz),
        PayType: ros.stringToRosTemplate(properties.payType),
        Period: ros.numberToRosTemplate(properties.period),
        PeriodType: ros.stringToRosTemplate(properties.periodType),
        Port: ros.numberToRosTemplate(properties.port),
        PreferredBackupPeriod: ros.listMapper(ros.objectToRosTemplate)(properties.preferredBackupPeriod),
        PreferredBackupTime: ros.stringToRosTemplate(properties.preferredBackupTime),
        PrivateIpAddress: ros.stringToRosTemplate(properties.privateIpAddress),
        ReleasedKeepPolicy: ros.stringToRosTemplate(properties.releasedKeepPolicy),
        ResourceGroupId: ros.stringToRosTemplate(properties.resourceGroupId),
        RoleARN: ros.stringToRosTemplate(properties.roleArn),
        SecurityGroupId: ros.stringToRosTemplate(properties.securityGroupId),
        SlaveZoneIds: ros.listMapper(ros.stringToRosTemplate)(properties.slaveZoneIds),
        SQLCollectorStatus: ros.stringToRosTemplate(properties.sqlCollectorStatus),
        SSLSetting: ros.stringToRosTemplate(properties.sslSetting),
        Tags: ros.hashMapper(ros.objectToRosTemplate)(properties.tags),
        TargetDedicatedHostIdForLog: ros.stringToRosTemplate(properties.targetDedicatedHostIdForLog),
        TargetDedicatedHostIdForMaster: ros.stringToRosTemplate(properties.targetDedicatedHostIdForMaster),
        TargetDedicatedHostIdForSlave: ros.stringToRosTemplate(properties.targetDedicatedHostIdForSlave),
        VpcId: ros.stringToRosTemplate(properties.vpcId),
        VSwitchId: ros.stringToRosTemplate(properties.vSwitchId),
        ZoneId: ros.stringToRosTemplate(properties.zoneId),
    };
}
/**
 * A ROS template type:  `ALIYUN::RDS::DBInstance`
 */
class RosDBInstance extends ros.RosResource {
    /**
     * Create a new `ALIYUN::RDS::DBInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDBInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrDbInstanceId = this.getAtt('DBInstanceId');
        this.attrInnerConnectionString = this.getAtt('InnerConnectionString');
        this.attrInnerIpAddress = this.getAtt('InnerIPAddress');
        this.attrInnerPort = this.getAtt('InnerPort');
        this.attrPublicConnectionString = this.getAtt('PublicConnectionString');
        this.attrPublicIpAddress = this.getAtt('PublicIPAddress');
        this.attrPublicPort = this.getAtt('PublicPort');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.dbInstanceClass = props.dbInstanceClass;
        this.dbInstanceStorage = props.dbInstanceStorage;
        this.engine = props.engine;
        this.engineVersion = props.engineVersion;
        this.securityIpList = props.securityIpList;
        this.allocatePublicConnection = props.allocatePublicConnection;
        this.archiveBackupKeepCount = props.archiveBackupKeepCount;
        this.archiveBackupKeepPolicy = props.archiveBackupKeepPolicy;
        this.archiveBackupRetentionPeriod = props.archiveBackupRetentionPeriod;
        this.autoRenew = props.autoRenew;
        this.backUpCategory = props.backUpCategory;
        this.backupPolicyMode = props.backupPolicyMode;
        this.backupRetentionPeriod = props.backupRetentionPeriod;
        this.category = props.category;
        this.compressType = props.compressType;
        this.connectionMode = props.connectionMode;
        this.connectionStringPrefix = props.connectionStringPrefix;
        this.connectionStringType = props.connectionStringType;
        this.dbInstanceDescription = props.dbInstanceDescription;
        this.dbInstanceNetType = props.dbInstanceNetType;
        this.dbInstanceStorageType = props.dbInstanceStorageType;
        this.dbIsIgnoreCase = props.dbIsIgnoreCase;
        this.dbMappings = props.dbMappings;
        this.dbParamGroupId = props.dbParamGroupId;
        this.dbTimeZone = props.dbTimeZone;
        this.dedicatedHostGroupId = props.dedicatedHostGroupId;
        this.enableBackupLog = props.enableBackupLog;
        this.encryptionKey = props.encryptionKey;
        this.highSpaceUsageProtection = props.highSpaceUsageProtection;
        this.localLogRetentionHours = props.localLogRetentionHours;
        this.localLogRetentionSpace = props.localLogRetentionSpace;
        this.logBackupFrequency = props.logBackupFrequency;
        this.logBackupLocalRetentionNumber = props.logBackupLocalRetentionNumber;
        this.logBackupRetentionPeriod = props.logBackupRetentionPeriod;
        this.maintainTime = props.maintainTime;
        this.masterUsername = props.masterUsername;
        this.masterUserPassword = props.masterUserPassword;
        this.masterUserType = props.masterUserType;
        this.multiAz = props.multiAz;
        this.payType = props.payType;
        this.period = props.period;
        this.periodType = props.periodType;
        this.port = props.port;
        this.preferredBackupPeriod = props.preferredBackupPeriod;
        this.preferredBackupTime = props.preferredBackupTime;
        this.privateIpAddress = props.privateIpAddress;
        this.releasedKeepPolicy = props.releasedKeepPolicy;
        this.resourceGroupId = props.resourceGroupId;
        this.roleArn = props.roleArn;
        this.securityGroupId = props.securityGroupId;
        this.slaveZoneIds = props.slaveZoneIds;
        this.sqlCollectorStatus = props.sqlCollectorStatus;
        this.sslSetting = props.sslSetting;
        this.tags = props.tags;
        this.targetDedicatedHostIdForLog = props.targetDedicatedHostIdForLog;
        this.targetDedicatedHostIdForMaster = props.targetDedicatedHostIdForMaster;
        this.targetDedicatedHostIdForSlave = props.targetDedicatedHostIdForSlave;
        this.vpcId = props.vpcId;
        this.vSwitchId = props.vSwitchId;
        this.zoneId = props.zoneId;
    }
    get rosProperties() {
        return {
            dbInstanceClass: this.dbInstanceClass,
            dbInstanceStorage: this.dbInstanceStorage,
            engine: this.engine,
            engineVersion: this.engineVersion,
            securityIpList: this.securityIpList,
            allocatePublicConnection: this.allocatePublicConnection,
            archiveBackupKeepCount: this.archiveBackupKeepCount,
            archiveBackupKeepPolicy: this.archiveBackupKeepPolicy,
            archiveBackupRetentionPeriod: this.archiveBackupRetentionPeriod,
            autoRenew: this.autoRenew,
            backUpCategory: this.backUpCategory,
            backupPolicyMode: this.backupPolicyMode,
            backupRetentionPeriod: this.backupRetentionPeriod,
            category: this.category,
            compressType: this.compressType,
            connectionMode: this.connectionMode,
            connectionStringPrefix: this.connectionStringPrefix,
            connectionStringType: this.connectionStringType,
            dbInstanceDescription: this.dbInstanceDescription,
            dbInstanceNetType: this.dbInstanceNetType,
            dbInstanceStorageType: this.dbInstanceStorageType,
            dbIsIgnoreCase: this.dbIsIgnoreCase,
            dbMappings: this.dbMappings,
            dbParamGroupId: this.dbParamGroupId,
            dbTimeZone: this.dbTimeZone,
            dedicatedHostGroupId: this.dedicatedHostGroupId,
            enableBackupLog: this.enableBackupLog,
            encryptionKey: this.encryptionKey,
            highSpaceUsageProtection: this.highSpaceUsageProtection,
            localLogRetentionHours: this.localLogRetentionHours,
            localLogRetentionSpace: this.localLogRetentionSpace,
            logBackupFrequency: this.logBackupFrequency,
            logBackupLocalRetentionNumber: this.logBackupLocalRetentionNumber,
            logBackupRetentionPeriod: this.logBackupRetentionPeriod,
            maintainTime: this.maintainTime,
            masterUsername: this.masterUsername,
            masterUserPassword: this.masterUserPassword,
            masterUserType: this.masterUserType,
            multiAz: this.multiAz,
            payType: this.payType,
            period: this.period,
            periodType: this.periodType,
            port: this.port,
            preferredBackupPeriod: this.preferredBackupPeriod,
            preferredBackupTime: this.preferredBackupTime,
            privateIpAddress: this.privateIpAddress,
            releasedKeepPolicy: this.releasedKeepPolicy,
            resourceGroupId: this.resourceGroupId,
            roleArn: this.roleArn,
            securityGroupId: this.securityGroupId,
            slaveZoneIds: this.slaveZoneIds,
            sqlCollectorStatus: this.sqlCollectorStatus,
            sslSetting: this.sslSetting,
            tags: this.tags,
            targetDedicatedHostIdForLog: this.targetDedicatedHostIdForLog,
            targetDedicatedHostIdForMaster: this.targetDedicatedHostIdForMaster,
            targetDedicatedHostIdForSlave: this.targetDedicatedHostIdForSlave,
            vpcId: this.vpcId,
            vSwitchId: this.vSwitchId,
            zoneId: this.zoneId,
        };
    }
    renderProperties(props) {
        return rosDBInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDBInstance = RosDBInstance;
/**
 * The resource type name for this resource class.
 */
RosDBInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::RDS::DBInstance";
/**
 * Determine whether the given properties match those of a `DBMappingsProperty`
 *
 * @param properties - the TypeScript properties of a `DBMappingsProperty`
 *
 * @returns the result of the validation.
 */
function RosDBInstance_DBMappingsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('characterSetName', ros.requiredValidator)(properties.characterSetName));
    errors.collect(ros.propertyValidator('characterSetName', ros.validateString)(properties.characterSetName));
    if (properties.dbDescription && (Array.isArray(properties.dbDescription) || (typeof properties.dbDescription) === 'string')) {
        errors.collect(ros.propertyValidator('dbDescription', ros.validateLength)({
            data: properties.dbDescription.length,
            min: undefined,
            max: 256,
        }));
    }
    errors.collect(ros.propertyValidator('dbDescription', ros.validateString)(properties.dbDescription));
    errors.collect(ros.propertyValidator('dbName', ros.requiredValidator)(properties.dbName));
    errors.collect(ros.propertyValidator('dbName', ros.validateString)(properties.dbName));
    return errors.wrap('supplied properties not correct for "DBMappingsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::RDS::DBInstance.DBMappings` resource
 *
 * @param properties - the TypeScript properties of a `DBMappingsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::RDS::DBInstance.DBMappings` resource.
 */
// @ts-ignore TS6133
function rosDBInstanceDBMappingsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosDBInstance_DBMappingsPropertyValidator(properties).assertSuccess();
    return {
        CharacterSetName: ros.stringToRosTemplate(properties.characterSetName),
        DBDescription: ros.stringToRosTemplate(properties.dbDescription),
        DBName: ros.stringToRosTemplate(properties.dbName),
    };
}
/**
 * Determine whether the given properties match those of a `RosDBInstanceCloneProps`
 *
 * @param properties - the TypeScript properties of a `RosDBInstanceCloneProps`
 *
 * @returns the result of the validation.
 */
function RosDBInstanceClonePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.periodType && (typeof properties.periodType) !== 'object') {
        errors.collect(ros.propertyValidator('periodType', ros.validateAllowedValues)({
            data: properties.periodType,
            allowedValues: ["Month", "Year"],
        }));
    }
    errors.collect(ros.propertyValidator('periodType', ros.validateString)(properties.periodType));
    if (properties.category && (typeof properties.category) !== 'object') {
        errors.collect(ros.propertyValidator('category', ros.validateAllowedValues)({
            data: properties.category,
            allowedValues: ["Basic", "HighAvailability", "AlwaysOn", "Finance"],
        }));
    }
    errors.collect(ros.propertyValidator('category', ros.validateString)(properties.category));
    errors.collect(ros.propertyValidator('privateIpAddress', ros.validateString)(properties.privateIpAddress));
    errors.collect(ros.propertyValidator('dedicatedHostGroupId', ros.validateString)(properties.dedicatedHostGroupId));
    if (properties.port && (typeof properties.port) !== 'object') {
        errors.collect(ros.propertyValidator('port', ros.validateRange)({
            data: properties.port,
            min: 1,
            max: 65535,
        }));
    }
    errors.collect(ros.propertyValidator('port', ros.validateNumber)(properties.port));
    errors.collect(ros.propertyValidator('backupId', ros.validateString)(properties.backupId));
    errors.collect(ros.propertyValidator('instanceNetworkType', ros.validateString)(properties.instanceNetworkType));
    errors.collect(ros.propertyValidator('restoreTime', ros.validateString)(properties.restoreTime));
    errors.collect(ros.propertyValidator('dbNames', ros.validateString)(properties.dbNames));
    errors.collect(ros.propertyValidator('preferredBackupPeriod', ros.listValidator(ros.validateAny))(properties.preferredBackupPeriod));
    if (properties.slaveZoneIds && (Array.isArray(properties.slaveZoneIds) || (typeof properties.slaveZoneIds) === 'string')) {
        errors.collect(ros.propertyValidator('slaveZoneIds', ros.validateLength)({
            data: properties.slaveZoneIds.length,
            min: undefined,
            max: 2,
        }));
    }
    errors.collect(ros.propertyValidator('slaveZoneIds', ros.listValidator(ros.validateString))(properties.slaveZoneIds));
    errors.collect(ros.propertyValidator('dbInstanceId', ros.requiredValidator)(properties.dbInstanceId));
    errors.collect(ros.propertyValidator('dbInstanceId', ros.validateString)(properties.dbInstanceId));
    errors.collect(ros.propertyValidator('securityIpList', ros.validateString)(properties.securityIpList));
    errors.collect(ros.propertyValidator('dbInstanceStorage', ros.validateNumber)(properties.dbInstanceStorage));
    if (properties.backupType && (typeof properties.backupType) !== 'object') {
        errors.collect(ros.propertyValidator('backupType', ros.validateAllowedValues)({
            data: properties.backupType,
            allowedValues: ["FullBackup", "IncrementalBackup"],
        }));
    }
    errors.collect(ros.propertyValidator('backupType', ros.validateString)(properties.backupType));
    errors.collect(ros.propertyValidator('dbMappings', ros.listValidator(RosDBInstanceClone_DBMappingsPropertyValidator))(properties.dbMappings));
    if (properties.connectionStringPrefix && (typeof properties.connectionStringPrefix) !== 'object') {
        errors.collect(ros.propertyValidator('connectionStringPrefix', ros.validateAllowedPattern)({
            data: properties.connectionStringPrefix,
            reg: /[a-zA-Z0-9-]{8,64}/
        }));
    }
    errors.collect(ros.propertyValidator('connectionStringPrefix', ros.validateString)(properties.connectionStringPrefix));
    errors.collect(ros.propertyValidator('maintainTime', ros.validateString)(properties.maintainTime));
    errors.collect(ros.propertyValidator('tags', ros.hashValidator(ros.validateAny))(properties.tags));
    errors.collect(ros.propertyValidator('dbInstanceDescription', ros.validateString)(properties.dbInstanceDescription));
    errors.collect(ros.propertyValidator('zoneId', ros.validateString)(properties.zoneId));
    errors.collect(ros.propertyValidator('dbInstanceClass', ros.validateString)(properties.dbInstanceClass));
    errors.collect(ros.propertyValidator('allocatePublicConnection', ros.validateBoolean)(properties.allocatePublicConnection));
    errors.collect(ros.propertyValidator('preferredBackupTime', ros.validateString)(properties.preferredBackupTime));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('securityGroupId', ros.validateString)(properties.securityGroupId));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateRange)({
            data: properties.period,
            min: 1,
            max: 9,
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    errors.collect(ros.propertyValidator('payType', ros.requiredValidator)(properties.payType));
    if (properties.payType && (typeof properties.payType) !== 'object') {
        errors.collect(ros.propertyValidator('payType', ros.validateAllowedValues)({
            data: properties.payType,
            allowedValues: ["Subscription", "PrePaid", "PrePay", "Prepaid", "PayAsYouGo", "PostPaid", "PayOnDemand", "Postpaid"],
        }));
    }
    errors.collect(ros.propertyValidator('payType', ros.validateString)(properties.payType));
    errors.collect(ros.propertyValidator('dbInstanceStorageType', ros.validateString)(properties.dbInstanceStorageType));
    if (properties.connectionStringType && (typeof properties.connectionStringType) !== 'object') {
        errors.collect(ros.propertyValidator('connectionStringType', ros.validateAllowedValues)({
            data: properties.connectionStringType,
            allowedValues: ["Inner", "Public"],
        }));
    }
    errors.collect(ros.propertyValidator('connectionStringType', ros.validateString)(properties.connectionStringType));
    errors.collect(ros.propertyValidator('restoreTable', ros.validateString)(properties.restoreTable));
    if (properties.masterUserPassword && (Array.isArray(properties.masterUserPassword) || (typeof properties.masterUserPassword) === 'string')) {
        errors.collect(ros.propertyValidator('masterUserPassword', ros.validateLength)({
            data: properties.masterUserPassword.length,
            min: 8,
            max: 32,
        }));
    }
    errors.collect(ros.propertyValidator('masterUserPassword', ros.validateString)(properties.masterUserPassword));
    if (properties.masterUserType && (typeof properties.masterUserType) !== 'object') {
        errors.collect(ros.propertyValidator('masterUserType', ros.validateAllowedValues)({
            data: properties.masterUserType,
            allowedValues: ["Normal", "Super", "Sysadmin"],
        }));
    }
    errors.collect(ros.propertyValidator('masterUserType', ros.validateString)(properties.masterUserType));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    if (properties.sslSetting && (typeof properties.sslSetting) !== 'object') {
        errors.collect(ros.propertyValidator('sslSetting', ros.validateAllowedValues)({
            data: properties.sslSetting,
            allowedValues: ["Disabled", "EnabledForPublicConnection", "EnabledForInnerConnection"],
        }));
    }
    errors.collect(ros.propertyValidator('sslSetting', ros.validateString)(properties.sslSetting));
    errors.collect(ros.propertyValidator('masterUsername', ros.validateString)(properties.masterUsername));
    if (properties.sqlCollectorStatus && (typeof properties.sqlCollectorStatus) !== 'object') {
        errors.collect(ros.propertyValidator('sqlCollectorStatus', ros.validateAllowedValues)({
            data: properties.sqlCollectorStatus,
            allowedValues: ["Enable", "Disabled"],
        }));
    }
    errors.collect(ros.propertyValidator('sqlCollectorStatus', ros.validateString)(properties.sqlCollectorStatus));
    errors.collect(ros.propertyValidator('backupRetentionPeriod', ros.validateNumber)(properties.backupRetentionPeriod));
    errors.collect(ros.propertyValidator('tableMeta', ros.listValidator(RosDBInstanceClone_TableMetaPropertyValidator))(properties.tableMeta));
    if (properties.timeoutInMinutes && (typeof properties.timeoutInMinutes) !== 'object') {
        errors.collect(ros.propertyValidator('timeoutInMinutes', ros.validateAllowedValues)({
            data: properties.timeoutInMinutes,
            allowedValues: [30, 60, 90, 120, 150, 180, 210, 240, 270, 300, 330, 360],
        }));
    }
    errors.collect(ros.propertyValidator('timeoutInMinutes', ros.validateNumber)(properties.timeoutInMinutes));
    return errors.wrap('supplied properties not correct for "RosDBInstanceCloneProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::RDS::DBInstanceClone` resource
 *
 * @param properties - the TypeScript properties of a `RosDBInstanceCloneProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::RDS::DBInstanceClone` resource.
 */
// @ts-ignore TS6133
function rosDBInstanceClonePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDBInstanceClonePropsValidator(properties).assertSuccess();
    }
    return {
        DBInstanceId: ros.stringToRosTemplate(properties.dbInstanceId),
        PayType: ros.stringToRosTemplate(properties.payType),
        AllocatePublicConnection: ros.booleanToRosTemplate(properties.allocatePublicConnection),
        BackupId: ros.stringToRosTemplate(properties.backupId),
        BackupRetentionPeriod: ros.numberToRosTemplate(properties.backupRetentionPeriod),
        BackupType: ros.stringToRosTemplate(properties.backupType),
        Category: ros.stringToRosTemplate(properties.category),
        ConnectionStringPrefix: ros.stringToRosTemplate(properties.connectionStringPrefix),
        ConnectionStringType: ros.stringToRosTemplate(properties.connectionStringType),
        DBInstanceClass: ros.stringToRosTemplate(properties.dbInstanceClass),
        DBInstanceDescription: ros.stringToRosTemplate(properties.dbInstanceDescription),
        DBInstanceStorage: ros.numberToRosTemplate(properties.dbInstanceStorage),
        DBInstanceStorageType: ros.stringToRosTemplate(properties.dbInstanceStorageType),
        DBMappings: ros.listMapper(rosDBInstanceCloneDBMappingsPropertyToRosTemplate)(properties.dbMappings),
        DbNames: ros.stringToRosTemplate(properties.dbNames),
        DedicatedHostGroupId: ros.stringToRosTemplate(properties.dedicatedHostGroupId),
        InstanceNetworkType: ros.stringToRosTemplate(properties.instanceNetworkType),
        MaintainTime: ros.stringToRosTemplate(properties.maintainTime),
        MasterUsername: ros.stringToRosTemplate(properties.masterUsername),
        MasterUserPassword: ros.stringToRosTemplate(properties.masterUserPassword),
        MasterUserType: ros.stringToRosTemplate(properties.masterUserType),
        Period: ros.numberToRosTemplate(properties.period),
        PeriodType: ros.stringToRosTemplate(properties.periodType),
        Port: ros.numberToRosTemplate(properties.port),
        PreferredBackupPeriod: ros.listMapper(ros.objectToRosTemplate)(properties.preferredBackupPeriod),
        PreferredBackupTime: ros.stringToRosTemplate(properties.preferredBackupTime),
        PrivateIpAddress: ros.stringToRosTemplate(properties.privateIpAddress),
        RestoreTable: ros.stringToRosTemplate(properties.restoreTable),
        RestoreTime: ros.stringToRosTemplate(properties.restoreTime),
        SecurityGroupId: ros.stringToRosTemplate(properties.securityGroupId),
        SecurityIPList: ros.stringToRosTemplate(properties.securityIpList),
        SlaveZoneIds: ros.listMapper(ros.stringToRosTemplate)(properties.slaveZoneIds),
        SQLCollectorStatus: ros.stringToRosTemplate(properties.sqlCollectorStatus),
        SSLSetting: ros.stringToRosTemplate(properties.sslSetting),
        TableMeta: ros.listMapper(rosDBInstanceCloneTableMetaPropertyToRosTemplate)(properties.tableMeta),
        Tags: ros.hashMapper(ros.objectToRosTemplate)(properties.tags),
        TimeoutInMinutes: ros.numberToRosTemplate(properties.timeoutInMinutes),
        VpcId: ros.stringToRosTemplate(properties.vpcId),
        VSwitchId: ros.stringToRosTemplate(properties.vSwitchId),
        ZoneId: ros.stringToRosTemplate(properties.zoneId),
    };
}
/**
 * A ROS template type:  `ALIYUN::RDS::DBInstanceClone`
 */
class RosDBInstanceClone extends ros.RosResource {
    /**
     * Create a new `ALIYUN::RDS::DBInstanceClone`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDBInstanceClone.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrDbInstanceId = this.getAtt('DBInstanceId');
        this.attrInnerConnectionString = this.getAtt('InnerConnectionString');
        this.attrInnerIpAddress = this.getAtt('InnerIPAddress');
        this.attrInnerPort = this.getAtt('InnerPort');
        this.attrPublicConnectionString = this.getAtt('PublicConnectionString');
        this.attrPublicIpAddress = this.getAtt('PublicIPAddress');
        this.attrPublicPort = this.getAtt('PublicPort');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.dbInstanceId = props.dbInstanceId;
        this.payType = props.payType;
        this.allocatePublicConnection = props.allocatePublicConnection;
        this.backupId = props.backupId;
        this.backupRetentionPeriod = props.backupRetentionPeriod;
        this.backupType = props.backupType;
        this.category = props.category;
        this.connectionStringPrefix = props.connectionStringPrefix;
        this.connectionStringType = props.connectionStringType;
        this.dbInstanceClass = props.dbInstanceClass;
        this.dbInstanceDescription = props.dbInstanceDescription;
        this.dbInstanceStorage = props.dbInstanceStorage;
        this.dbInstanceStorageType = props.dbInstanceStorageType;
        this.dbMappings = props.dbMappings;
        this.dbNames = props.dbNames;
        this.dedicatedHostGroupId = props.dedicatedHostGroupId;
        this.instanceNetworkType = props.instanceNetworkType;
        this.maintainTime = props.maintainTime;
        this.masterUsername = props.masterUsername;
        this.masterUserPassword = props.masterUserPassword;
        this.masterUserType = props.masterUserType;
        this.period = props.period;
        this.periodType = props.periodType;
        this.port = props.port;
        this.preferredBackupPeriod = props.preferredBackupPeriod;
        this.preferredBackupTime = props.preferredBackupTime;
        this.privateIpAddress = props.privateIpAddress;
        this.restoreTable = props.restoreTable;
        this.restoreTime = props.restoreTime;
        this.securityGroupId = props.securityGroupId;
        this.securityIpList = props.securityIpList;
        this.slaveZoneIds = props.slaveZoneIds;
        this.sqlCollectorStatus = props.sqlCollectorStatus;
        this.sslSetting = props.sslSetting;
        this.tableMeta = props.tableMeta;
        this.tags = props.tags;
        this.timeoutInMinutes = props.timeoutInMinutes;
        this.vpcId = props.vpcId;
        this.vSwitchId = props.vSwitchId;
        this.zoneId = props.zoneId;
    }
    get rosProperties() {
        return {
            dbInstanceId: this.dbInstanceId,
            payType: this.payType,
            allocatePublicConnection: this.allocatePublicConnection,
            backupId: this.backupId,
            backupRetentionPeriod: this.backupRetentionPeriod,
            backupType: this.backupType,
            category: this.category,
            connectionStringPrefix: this.connectionStringPrefix,
            connectionStringType: this.connectionStringType,
            dbInstanceClass: this.dbInstanceClass,
            dbInstanceDescription: this.dbInstanceDescription,
            dbInstanceStorage: this.dbInstanceStorage,
            dbInstanceStorageType: this.dbInstanceStorageType,
            dbMappings: this.dbMappings,
            dbNames: this.dbNames,
            dedicatedHostGroupId: this.dedicatedHostGroupId,
            instanceNetworkType: this.instanceNetworkType,
            maintainTime: this.maintainTime,
            masterUsername: this.masterUsername,
            masterUserPassword: this.masterUserPassword,
            masterUserType: this.masterUserType,
            period: this.period,
            periodType: this.periodType,
            port: this.port,
            preferredBackupPeriod: this.preferredBackupPeriod,
            preferredBackupTime: this.preferredBackupTime,
            privateIpAddress: this.privateIpAddress,
            restoreTable: this.restoreTable,
            restoreTime: this.restoreTime,
            securityGroupId: this.securityGroupId,
            securityIpList: this.securityIpList,
            slaveZoneIds: this.slaveZoneIds,
            sqlCollectorStatus: this.sqlCollectorStatus,
            sslSetting: this.sslSetting,
            tableMeta: this.tableMeta,
            tags: this.tags,
            timeoutInMinutes: this.timeoutInMinutes,
            vpcId: this.vpcId,
            vSwitchId: this.vSwitchId,
            zoneId: this.zoneId,
        };
    }
    renderProperties(props) {
        return rosDBInstanceClonePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDBInstanceClone = RosDBInstanceClone;
/**
 * The resource type name for this resource class.
 */
RosDBInstanceClone.ROS_RESOURCE_TYPE_NAME = "ALIYUN::RDS::DBInstanceClone";
/**
 * Determine whether the given properties match those of a `DBMappingsProperty`
 *
 * @param properties - the TypeScript properties of a `DBMappingsProperty`
 *
 * @returns the result of the validation.
 */
function RosDBInstanceClone_DBMappingsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('characterSetName', ros.requiredValidator)(properties.characterSetName));
    errors.collect(ros.propertyValidator('characterSetName', ros.validateString)(properties.characterSetName));
    if (properties.dbDescription && (Array.isArray(properties.dbDescription) || (typeof properties.dbDescription) === 'string')) {
        errors.collect(ros.propertyValidator('dbDescription', ros.validateLength)({
            data: properties.dbDescription.length,
            min: undefined,
            max: 256,
        }));
    }
    errors.collect(ros.propertyValidator('dbDescription', ros.validateString)(properties.dbDescription));
    errors.collect(ros.propertyValidator('dbName', ros.requiredValidator)(properties.dbName));
    errors.collect(ros.propertyValidator('dbName', ros.validateString)(properties.dbName));
    return errors.wrap('supplied properties not correct for "DBMappingsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::RDS::DBInstanceClone.DBMappings` resource
 *
 * @param properties - the TypeScript properties of a `DBMappingsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::RDS::DBInstanceClone.DBMappings` resource.
 */
// @ts-ignore TS6133
function rosDBInstanceCloneDBMappingsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosDBInstanceClone_DBMappingsPropertyValidator(properties).assertSuccess();
    return {
        CharacterSetName: ros.stringToRosTemplate(properties.characterSetName),
        DBDescription: ros.stringToRosTemplate(properties.dbDescription),
        DBName: ros.stringToRosTemplate(properties.dbName),
    };
}
/**
 * Determine whether the given properties match those of a `TableMetaProperty`
 *
 * @param properties - the TypeScript properties of a `TableMetaProperty`
 *
 * @returns the result of the validation.
 */
function RosDBInstanceClone_TableMetaPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('type', ros.validateString)(properties.type));
    errors.collect(ros.propertyValidator('tables', ros.listValidator(RosDBInstanceClone_TablesPropertyValidator))(properties.tables));
    errors.collect(ros.propertyValidator('newName', ros.validateString)(properties.newName));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "TableMetaProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::RDS::DBInstanceClone.TableMeta` resource
 *
 * @param properties - the TypeScript properties of a `TableMetaProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::RDS::DBInstanceClone.TableMeta` resource.
 */
// @ts-ignore TS6133
function rosDBInstanceCloneTableMetaPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosDBInstanceClone_TableMetaPropertyValidator(properties).assertSuccess();
    return {
        Type: ros.stringToRosTemplate(properties.type),
        Tables: ros.listMapper(rosDBInstanceCloneTablesPropertyToRosTemplate)(properties.tables),
        NewName: ros.stringToRosTemplate(properties.newName),
        Name: ros.stringToRosTemplate(properties.name),
    };
}
/**
 * Determine whether the given properties match those of a `TablesProperty`
 *
 * @param properties - the TypeScript properties of a `TablesProperty`
 *
 * @returns the result of the validation.
 */
function RosDBInstanceClone_TablesPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('type', ros.validateString)(properties.type));
    errors.collect(ros.propertyValidator('newName', ros.validateString)(properties.newName));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "TablesProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::RDS::DBInstanceClone.Tables` resource
 *
 * @param properties - the TypeScript properties of a `TablesProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::RDS::DBInstanceClone.Tables` resource.
 */
// @ts-ignore TS6133
function rosDBInstanceCloneTablesPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosDBInstanceClone_TablesPropertyValidator(properties).assertSuccess();
    return {
        Type: ros.stringToRosTemplate(properties.type),
        NewName: ros.stringToRosTemplate(properties.newName),
        Name: ros.stringToRosTemplate(properties.name),
    };
}
/**
 * Determine whether the given properties match those of a `RosDBInstanceParameterGroupProps`
 *
 * @param properties - the TypeScript properties of a `RosDBInstanceParameterGroupProps`
 *
 * @returns the result of the validation.
 */
function RosDBInstanceParameterGroupPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('parameters', ros.requiredValidator)(properties.parameters));
    errors.collect(ros.propertyValidator('parameters', ros.listValidator(RosDBInstanceParameterGroup_ParametersPropertyValidator))(properties.parameters));
    errors.collect(ros.propertyValidator('dbInstanceId', ros.requiredValidator)(properties.dbInstanceId));
    errors.collect(ros.propertyValidator('dbInstanceId', ros.validateString)(properties.dbInstanceId));
    if (properties.forcerestart && (typeof properties.forcerestart) !== 'object') {
        errors.collect(ros.propertyValidator('forcerestart', ros.validateAllowedValues)({
            data: properties.forcerestart,
            allowedValues: ["true", "false"],
        }));
    }
    errors.collect(ros.propertyValidator('forcerestart', ros.validateString)(properties.forcerestart));
    return errors.wrap('supplied properties not correct for "RosDBInstanceParameterGroupProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::RDS::DBInstanceParameterGroup` resource
 *
 * @param properties - the TypeScript properties of a `RosDBInstanceParameterGroupProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::RDS::DBInstanceParameterGroup` resource.
 */
// @ts-ignore TS6133
function rosDBInstanceParameterGroupPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDBInstanceParameterGroupPropsValidator(properties).assertSuccess();
    }
    return {
        DBInstanceId: ros.stringToRosTemplate(properties.dbInstanceId),
        Parameters: ros.listMapper(rosDBInstanceParameterGroupParametersPropertyToRosTemplate)(properties.parameters),
        Forcerestart: ros.stringToRosTemplate(properties.forcerestart),
    };
}
/**
 * A ROS template type:  `ALIYUN::RDS::DBInstanceParameterGroup`
 */
class RosDBInstanceParameterGroup extends ros.RosResource {
    /**
     * Create a new `ALIYUN::RDS::DBInstanceParameterGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDBInstanceParameterGroup.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.dbInstanceId = props.dbInstanceId;
        this.parameters = props.parameters;
        this.forcerestart = props.forcerestart;
    }
    get rosProperties() {
        return {
            dbInstanceId: this.dbInstanceId,
            parameters: this.parameters,
            forcerestart: this.forcerestart,
        };
    }
    renderProperties(props) {
        return rosDBInstanceParameterGroupPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDBInstanceParameterGroup = RosDBInstanceParameterGroup;
/**
 * The resource type name for this resource class.
 */
RosDBInstanceParameterGroup.ROS_RESOURCE_TYPE_NAME = "ALIYUN::RDS::DBInstanceParameterGroup";
/**
 * Determine whether the given properties match those of a `ParametersProperty`
 *
 * @param properties - the TypeScript properties of a `ParametersProperty`
 *
 * @returns the result of the validation.
 */
function RosDBInstanceParameterGroup_ParametersPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.requiredValidator)(properties.value));
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "ParametersProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::RDS::DBInstanceParameterGroup.Parameters` resource
 *
 * @param properties - the TypeScript properties of a `ParametersProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::RDS::DBInstanceParameterGroup.Parameters` resource.
 */
// @ts-ignore TS6133
function rosDBInstanceParameterGroupParametersPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosDBInstanceParameterGroup_ParametersPropertyValidator(properties).assertSuccess();
    return {
        Value: ros.stringToRosTemplate(properties.value),
        Key: ros.stringToRosTemplate(properties.key),
    };
}
/**
 * Determine whether the given properties match those of a `RosDBInstanceSecurityIpsProps`
 *
 * @param properties - the TypeScript properties of a `RosDBInstanceSecurityIpsProps`
 *
 * @returns the result of the validation.
 */
function RosDBInstanceSecurityIpsPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('dbInstanceIpArrayAttribute', ros.requiredValidator)(properties.dbInstanceIpArrayAttribute));
    errors.collect(ros.propertyValidator('dbInstanceIpArrayAttribute', ros.validateString)(properties.dbInstanceIpArrayAttribute));
    errors.collect(ros.propertyValidator('dbInstanceId', ros.requiredValidator)(properties.dbInstanceId));
    errors.collect(ros.propertyValidator('dbInstanceId', ros.validateString)(properties.dbInstanceId));
    errors.collect(ros.propertyValidator('dbInstanceIpArrayName', ros.validateString)(properties.dbInstanceIpArrayName));
    return errors.wrap('supplied properties not correct for "RosDBInstanceSecurityIpsProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::RDS::DBInstanceSecurityIps` resource
 *
 * @param properties - the TypeScript properties of a `RosDBInstanceSecurityIpsProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::RDS::DBInstanceSecurityIps` resource.
 */
// @ts-ignore TS6133
function rosDBInstanceSecurityIpsPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDBInstanceSecurityIpsPropsValidator(properties).assertSuccess();
    }
    return {
        DBInstanceId: ros.stringToRosTemplate(properties.dbInstanceId),
        DBInstanceIPArrayAttribute: ros.stringToRosTemplate(properties.dbInstanceIpArrayAttribute),
        DBInstanceIPArrayName: ros.stringToRosTemplate(properties.dbInstanceIpArrayName),
    };
}
/**
 * A ROS template type:  `ALIYUN::RDS::DBInstanceSecurityIps`
 */
class RosDBInstanceSecurityIps extends ros.RosResource {
    /**
     * Create a new `ALIYUN::RDS::DBInstanceSecurityIps`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDBInstanceSecurityIps.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrSecurityIps = this.getAtt('SecurityIps');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.dbInstanceId = props.dbInstanceId;
        this.dbInstanceIpArrayAttribute = props.dbInstanceIpArrayAttribute;
        this.dbInstanceIpArrayName = props.dbInstanceIpArrayName;
    }
    get rosProperties() {
        return {
            dbInstanceId: this.dbInstanceId,
            dbInstanceIpArrayAttribute: this.dbInstanceIpArrayAttribute,
            dbInstanceIpArrayName: this.dbInstanceIpArrayName,
        };
    }
    renderProperties(props) {
        return rosDBInstanceSecurityIpsPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDBInstanceSecurityIps = RosDBInstanceSecurityIps;
/**
 * The resource type name for this resource class.
 */
RosDBInstanceSecurityIps.ROS_RESOURCE_TYPE_NAME = "ALIYUN::RDS::DBInstanceSecurityIps";
/**
 * Determine whether the given properties match those of a `RosDatabaseProps`
 *
 * @param properties - the TypeScript properties of a `RosDatabaseProps`
 *
 * @returns the result of the validation.
 */
function RosDatabasePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('characterSetName', ros.requiredValidator)(properties.characterSetName));
    errors.collect(ros.propertyValidator('characterSetName', ros.validateString)(properties.characterSetName));
    errors.collect(ros.propertyValidator('dbInstanceId', ros.requiredValidator)(properties.dbInstanceId));
    errors.collect(ros.propertyValidator('dbInstanceId', ros.validateString)(properties.dbInstanceId));
    errors.collect(ros.propertyValidator('dbDescription', ros.validateString)(properties.dbDescription));
    errors.collect(ros.propertyValidator('dbName', ros.requiredValidator)(properties.dbName));
    errors.collect(ros.propertyValidator('dbName', ros.validateString)(properties.dbName));
    return errors.wrap('supplied properties not correct for "RosDatabaseProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::RDS::Database` resource
 *
 * @param properties - the TypeScript properties of a `RosDatabaseProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::RDS::Database` resource.
 */
// @ts-ignore TS6133
function rosDatabasePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDatabasePropsValidator(properties).assertSuccess();
    }
    return {
        CharacterSetName: ros.stringToRosTemplate(properties.characterSetName),
        DBInstanceId: ros.stringToRosTemplate(properties.dbInstanceId),
        DBName: ros.stringToRosTemplate(properties.dbName),
        DBDescription: ros.stringToRosTemplate(properties.dbDescription),
    };
}
/**
 * A ROS template type:  `ALIYUN::RDS::Database`
 */
class RosDatabase extends ros.RosResource {
    /**
     * Create a new `ALIYUN::RDS::Database`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDatabase.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrDbInstanceId = this.getAtt('DBInstanceId');
        this.attrDbName = this.getAtt('DBName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.characterSetName = props.characterSetName;
        this.dbInstanceId = props.dbInstanceId;
        this.dbName = props.dbName;
        this.dbDescription = props.dbDescription;
    }
    get rosProperties() {
        return {
            characterSetName: this.characterSetName,
            dbInstanceId: this.dbInstanceId,
            dbName: this.dbName,
            dbDescription: this.dbDescription,
        };
    }
    renderProperties(props) {
        return rosDatabasePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDatabase = RosDatabase;
/**
 * The resource type name for this resource class.
 */
RosDatabase.ROS_RESOURCE_TYPE_NAME = "ALIYUN::RDS::Database";
/**
 * Determine whether the given properties match those of a `RosPrepayDBInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosPrepayDBInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosPrepayDBInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('periodType', ros.requiredValidator)(properties.periodType));
    if (properties.periodType && (typeof properties.periodType) !== 'object') {
        errors.collect(ros.propertyValidator('periodType', ros.validateAllowedValues)({
            data: properties.periodType,
            allowedValues: ["Month", "Year"],
        }));
    }
    errors.collect(ros.propertyValidator('periodType', ros.validateString)(properties.periodType));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    if (properties.archiveBackupRetentionPeriod && (typeof properties.archiveBackupRetentionPeriod) !== 'object') {
        errors.collect(ros.propertyValidator('archiveBackupRetentionPeriod', ros.validateRange)({
            data: properties.archiveBackupRetentionPeriod,
            min: 30,
            max: 1095,
        }));
    }
    errors.collect(ros.propertyValidator('archiveBackupRetentionPeriod', ros.validateNumber)(properties.archiveBackupRetentionPeriod));
    errors.collect(ros.propertyValidator('dbTimeZone', ros.validateString)(properties.dbTimeZone));
    if (properties.port && (typeof properties.port) !== 'object') {
        errors.collect(ros.propertyValidator('port', ros.validateRange)({
            data: properties.port,
            min: 1,
            max: 65535,
        }));
    }
    errors.collect(ros.propertyValidator('port', ros.validateNumber)(properties.port));
    if (properties.archiveBackupKeepCount && (typeof properties.archiveBackupKeepCount) !== 'object') {
        errors.collect(ros.propertyValidator('archiveBackupKeepCount', ros.validateRange)({
            data: properties.archiveBackupKeepCount,
            min: 1,
            max: 31,
        }));
    }
    errors.collect(ros.propertyValidator('archiveBackupKeepCount', ros.validateNumber)(properties.archiveBackupKeepCount));
    if (properties.logBackupRetentionPeriod && (typeof properties.logBackupRetentionPeriod) !== 'object') {
        errors.collect(ros.propertyValidator('logBackupRetentionPeriod', ros.validateRange)({
            data: properties.logBackupRetentionPeriod,
            min: 7,
            max: 730,
        }));
    }
    errors.collect(ros.propertyValidator('logBackupRetentionPeriod', ros.validateNumber)(properties.logBackupRetentionPeriod));
    errors.collect(ros.propertyValidator('dbInstanceStorage', ros.requiredValidator)(properties.dbInstanceStorage));
    errors.collect(ros.propertyValidator('dbInstanceStorage', ros.validateNumber)(properties.dbInstanceStorage));
    errors.collect(ros.propertyValidator('dbMappings', ros.listValidator(RosPrepayDBInstance_DBMappingsPropertyValidator))(properties.dbMappings));
    if (properties.connectionStringPrefix && (typeof properties.connectionStringPrefix) !== 'object') {
        errors.collect(ros.propertyValidator('connectionStringPrefix', ros.validateAllowedPattern)({
            data: properties.connectionStringPrefix,
            reg: /[a-zA-Z0-9-]{8,64}/
        }));
    }
    errors.collect(ros.propertyValidator('connectionStringPrefix', ros.validateString)(properties.connectionStringPrefix));
    errors.collect(ros.propertyValidator('multiAz', ros.validateBoolean)(properties.multiAz));
    errors.collect(ros.propertyValidator('engine', ros.requiredValidator)(properties.engine));
    if (properties.engine && (typeof properties.engine) !== 'object') {
        errors.collect(ros.propertyValidator('engine', ros.validateAllowedValues)({
            data: properties.engine,
            allowedValues: ["MySQL", "SQLServer", "PostgreSQL", "PPAS", "MariaDB"],
        }));
    }
    errors.collect(ros.propertyValidator('engine', ros.validateString)(properties.engine));
    errors.collect(ros.propertyValidator('tags', ros.hashValidator(ros.validateAny))(properties.tags));
    errors.collect(ros.propertyValidator('dbInstanceDescription', ros.validateString)(properties.dbInstanceDescription));
    errors.collect(ros.propertyValidator('targetDedicatedHostIdForMaster', ros.validateString)(properties.targetDedicatedHostIdForMaster));
    errors.collect(ros.propertyValidator('engineVersion', ros.requiredValidator)(properties.engineVersion));
    errors.collect(ros.propertyValidator('engineVersion', ros.validateString)(properties.engineVersion));
    errors.collect(ros.propertyValidator('dbInstanceClass', ros.requiredValidator)(properties.dbInstanceClass));
    errors.collect(ros.propertyValidator('dbInstanceClass', ros.validateString)(properties.dbInstanceClass));
    if (properties.archiveBackupKeepPolicy && (typeof properties.archiveBackupKeepPolicy) !== 'object') {
        errors.collect(ros.propertyValidator('archiveBackupKeepPolicy', ros.validateAllowedValues)({
            data: properties.archiveBackupKeepPolicy,
            allowedValues: ["ByMonth", "ByWeek", "KeepAll"],
        }));
    }
    errors.collect(ros.propertyValidator('archiveBackupKeepPolicy', ros.validateString)(properties.archiveBackupKeepPolicy));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    if (properties.backupPolicyMode && (typeof properties.backupPolicyMode) !== 'object') {
        errors.collect(ros.propertyValidator('backupPolicyMode', ros.validateAllowedValues)({
            data: properties.backupPolicyMode,
            allowedValues: ["DataBackupPolicy", "LogBackupPolicy"],
        }));
    }
    errors.collect(ros.propertyValidator('backupPolicyMode', ros.validateString)(properties.backupPolicyMode));
    errors.collect(ros.propertyValidator('period', ros.requiredValidator)(properties.period));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateRange)({
            data: properties.period,
            min: 1,
            max: 9,
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    if (properties.localLogRetentionHours && (typeof properties.localLogRetentionHours) !== 'object') {
        errors.collect(ros.propertyValidator('localLogRetentionHours', ros.validateRange)({
            data: properties.localLogRetentionHours,
            min: 0,
            max: 168,
        }));
    }
    errors.collect(ros.propertyValidator('localLogRetentionHours', ros.validateNumber)(properties.localLogRetentionHours));
    if (properties.highSpaceUsageProtection && (typeof properties.highSpaceUsageProtection) !== 'object') {
        errors.collect(ros.propertyValidator('highSpaceUsageProtection', ros.validateAllowedValues)({
            data: properties.highSpaceUsageProtection,
            allowedValues: ["Enable", "Disable"],
        }));
    }
    errors.collect(ros.propertyValidator('highSpaceUsageProtection', ros.validateString)(properties.highSpaceUsageProtection));
    errors.collect(ros.propertyValidator('roleArn', ros.validateString)(properties.roleArn));
    if (properties.masterUserPassword && (Array.isArray(properties.masterUserPassword) || (typeof properties.masterUserPassword) === 'string')) {
        errors.collect(ros.propertyValidator('masterUserPassword', ros.validateLength)({
            data: properties.masterUserPassword.length,
            min: 8,
            max: 32,
        }));
    }
    errors.collect(ros.propertyValidator('masterUserPassword', ros.validateString)(properties.masterUserPassword));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    if (properties.sslSetting && (typeof properties.sslSetting) !== 'object') {
        errors.collect(ros.propertyValidator('sslSetting', ros.validateAllowedValues)({
            data: properties.sslSetting,
            allowedValues: ["Disabled", "EnabledForPublicConnection", "EnabledForInnerConnection"],
        }));
    }
    errors.collect(ros.propertyValidator('sslSetting', ros.validateString)(properties.sslSetting));
    errors.collect(ros.propertyValidator('masterUsername', ros.validateString)(properties.masterUsername));
    errors.collect(ros.propertyValidator('connectionMode', ros.validateString)(properties.connectionMode));
    if (properties.localLogRetentionSpace && (typeof properties.localLogRetentionSpace) !== 'object') {
        errors.collect(ros.propertyValidator('localLogRetentionSpace', ros.validateRange)({
            data: properties.localLogRetentionSpace,
            min: 0,
            max: 50,
        }));
    }
    errors.collect(ros.propertyValidator('localLogRetentionSpace', ros.validateNumber)(properties.localLogRetentionSpace));
    if (properties.category && (typeof properties.category) !== 'object') {
        errors.collect(ros.propertyValidator('category', ros.validateAllowedValues)({
            data: properties.category,
            allowedValues: ["Basic", "HighAvailability", "AlwaysOn", "Finance"],
        }));
    }
    errors.collect(ros.propertyValidator('category', ros.validateString)(properties.category));
    errors.collect(ros.propertyValidator('privateIpAddress', ros.validateString)(properties.privateIpAddress));
    errors.collect(ros.propertyValidator('targetDedicatedHostIdForSlave', ros.validateString)(properties.targetDedicatedHostIdForSlave));
    if (properties.dbInstanceNetType && (typeof properties.dbInstanceNetType) !== 'object') {
        errors.collect(ros.propertyValidator('dbInstanceNetType', ros.validateAllowedValues)({
            data: properties.dbInstanceNetType,
            allowedValues: ["Internet", "Intranet"],
        }));
    }
    errors.collect(ros.propertyValidator('dbInstanceNetType', ros.validateString)(properties.dbInstanceNetType));
    if (properties.releasedKeepPolicy && (typeof properties.releasedKeepPolicy) !== 'object') {
        errors.collect(ros.propertyValidator('releasedKeepPolicy', ros.validateAllowedValues)({
            data: properties.releasedKeepPolicy,
            allowedValues: ["Lastest", "All"],
        }));
    }
    errors.collect(ros.propertyValidator('releasedKeepPolicy', ros.validateString)(properties.releasedKeepPolicy));
    errors.collect(ros.propertyValidator('dedicatedHostGroupId', ros.validateString)(properties.dedicatedHostGroupId));
    errors.collect(ros.propertyValidator('autoRenew', ros.validateBoolean)(properties.autoRenew));
    errors.collect(ros.propertyValidator('encryptionKey', ros.validateString)(properties.encryptionKey));
    errors.collect(ros.propertyValidator('preferredBackupPeriod', ros.listValidator(ros.validateAny))(properties.preferredBackupPeriod));
    if (properties.logBackupLocalRetentionNumber && (typeof properties.logBackupLocalRetentionNumber) !== 'object') {
        errors.collect(ros.propertyValidator('logBackupLocalRetentionNumber', ros.validateRange)({
            data: properties.logBackupLocalRetentionNumber,
            min: 6,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('logBackupLocalRetentionNumber', ros.validateNumber)(properties.logBackupLocalRetentionNumber));
    if (properties.slaveZoneIds && (Array.isArray(properties.slaveZoneIds) || (typeof properties.slaveZoneIds) === 'string')) {
        errors.collect(ros.propertyValidator('slaveZoneIds', ros.validateLength)({
            data: properties.slaveZoneIds.length,
            min: undefined,
            max: 2,
        }));
    }
    errors.collect(ros.propertyValidator('slaveZoneIds', ros.listValidator(ros.validateString))(properties.slaveZoneIds));
    errors.collect(ros.propertyValidator('dbIsIgnoreCase', ros.validateNumber)(properties.dbIsIgnoreCase));
    errors.collect(ros.propertyValidator('commodityCode', ros.requiredValidator)(properties.commodityCode));
    if (properties.commodityCode && (typeof properties.commodityCode) !== 'object') {
        errors.collect(ros.propertyValidator('commodityCode', ros.validateAllowedValues)({
            data: properties.commodityCode,
            allowedValues: ["rds", "bards", "rords"],
        }));
    }
    errors.collect(ros.propertyValidator('commodityCode', ros.validateString)(properties.commodityCode));
    errors.collect(ros.propertyValidator('maintainTime', ros.validateString)(properties.maintainTime));
    errors.collect(ros.propertyValidator('dbParamGroupId', ros.validateString)(properties.dbParamGroupId));
    errors.collect(ros.propertyValidator('zoneId', ros.validateString)(properties.zoneId));
    errors.collect(ros.propertyValidator('targetDedicatedHostIdForLog', ros.validateString)(properties.targetDedicatedHostIdForLog));
    errors.collect(ros.propertyValidator('allocatePublicConnection', ros.validateBoolean)(properties.allocatePublicConnection));
    errors.collect(ros.propertyValidator('securityGroupId', ros.validateString)(properties.securityGroupId));
    errors.collect(ros.propertyValidator('preferredBackupTime', ros.validateString)(properties.preferredBackupTime));
    if (properties.quantity && (typeof properties.quantity) !== 'object') {
        errors.collect(ros.propertyValidator('quantity', ros.validateRange)({
            data: properties.quantity,
            min: 1,
            max: 99,
        }));
    }
    errors.collect(ros.propertyValidator('quantity', ros.validateNumber)(properties.quantity));
    errors.collect(ros.propertyValidator('autoPay', ros.validateBoolean)(properties.autoPay));
    errors.collect(ros.propertyValidator('dbInstanceStorageType', ros.validateString)(properties.dbInstanceStorageType));
    if (properties.backUpCategory && (typeof properties.backUpCategory) !== 'object') {
        errors.collect(ros.propertyValidator('backUpCategory', ros.validateAllowedValues)({
            data: properties.backUpCategory,
            allowedValues: ["Flash", "Standard"],
        }));
    }
    errors.collect(ros.propertyValidator('backUpCategory', ros.validateString)(properties.backUpCategory));
    errors.collect(ros.propertyValidator('compressType', ros.validateNumber)(properties.compressType));
    if (properties.connectionStringType && (typeof properties.connectionStringType) !== 'object') {
        errors.collect(ros.propertyValidator('connectionStringType', ros.validateAllowedValues)({
            data: properties.connectionStringType,
            allowedValues: ["Inner", "Public"],
        }));
    }
    errors.collect(ros.propertyValidator('connectionStringType', ros.validateString)(properties.connectionStringType));
    errors.collect(ros.propertyValidator('logBackupFrequency', ros.validateString)(properties.logBackupFrequency));
    errors.collect(ros.propertyValidator('couponCode', ros.validateString)(properties.couponCode));
    if (properties.masterUserType && (typeof properties.masterUserType) !== 'object') {
        errors.collect(ros.propertyValidator('masterUserType', ros.validateAllowedValues)({
            data: properties.masterUserType,
            allowedValues: ["Normal", "Super", "Sysadmin"],
        }));
    }
    errors.collect(ros.propertyValidator('masterUserType', ros.validateString)(properties.masterUserType));
    errors.collect(ros.propertyValidator('enableBackupLog', ros.validateBoolean)(properties.enableBackupLog));
    if (properties.sqlCollectorStatus && (typeof properties.sqlCollectorStatus) !== 'object') {
        errors.collect(ros.propertyValidator('sqlCollectorStatus', ros.validateAllowedValues)({
            data: properties.sqlCollectorStatus,
            allowedValues: ["Enable", "Disabled"],
        }));
    }
    errors.collect(ros.propertyValidator('sqlCollectorStatus', ros.validateString)(properties.sqlCollectorStatus));
    errors.collect(ros.propertyValidator('backupRetentionPeriod', ros.validateNumber)(properties.backupRetentionPeriod));
    return errors.wrap('supplied properties not correct for "RosPrepayDBInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::RDS::PrepayDBInstance` resource
 *
 * @param properties - the TypeScript properties of a `RosPrepayDBInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::RDS::PrepayDBInstance` resource.
 */
// @ts-ignore TS6133
function rosPrepayDBInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosPrepayDBInstancePropsValidator(properties).assertSuccess();
    }
    return {
        CommodityCode: ros.stringToRosTemplate(properties.commodityCode),
        DBInstanceClass: ros.stringToRosTemplate(properties.dbInstanceClass),
        DBInstanceStorage: ros.numberToRosTemplate(properties.dbInstanceStorage),
        Engine: ros.stringToRosTemplate(properties.engine),
        EngineVersion: ros.stringToRosTemplate(properties.engineVersion),
        Period: ros.numberToRosTemplate(properties.period),
        PeriodType: ros.stringToRosTemplate(properties.periodType),
        AllocatePublicConnection: ros.booleanToRosTemplate(properties.allocatePublicConnection),
        ArchiveBackupKeepCount: ros.numberToRosTemplate(properties.archiveBackupKeepCount),
        ArchiveBackupKeepPolicy: ros.stringToRosTemplate(properties.archiveBackupKeepPolicy),
        ArchiveBackupRetentionPeriod: ros.numberToRosTemplate(properties.archiveBackupRetentionPeriod),
        AutoPay: ros.booleanToRosTemplate(properties.autoPay),
        AutoRenew: ros.booleanToRosTemplate(properties.autoRenew),
        BackUpCategory: ros.stringToRosTemplate(properties.backUpCategory),
        BackupPolicyMode: ros.stringToRosTemplate(properties.backupPolicyMode),
        BackupRetentionPeriod: ros.numberToRosTemplate(properties.backupRetentionPeriod),
        Category: ros.stringToRosTemplate(properties.category),
        CompressType: ros.numberToRosTemplate(properties.compressType),
        ConnectionMode: ros.stringToRosTemplate(properties.connectionMode),
        ConnectionStringPrefix: ros.stringToRosTemplate(properties.connectionStringPrefix),
        ConnectionStringType: ros.stringToRosTemplate(properties.connectionStringType),
        CouponCode: ros.stringToRosTemplate(properties.couponCode),
        DBInstanceDescription: ros.stringToRosTemplate(properties.dbInstanceDescription),
        DBInstanceNetType: ros.stringToRosTemplate(properties.dbInstanceNetType),
        DBInstanceStorageType: ros.stringToRosTemplate(properties.dbInstanceStorageType),
        DBIsIgnoreCase: ros.numberToRosTemplate(properties.dbIsIgnoreCase),
        DBMappings: ros.listMapper(rosPrepayDBInstanceDBMappingsPropertyToRosTemplate)(properties.dbMappings),
        DBParamGroupId: ros.stringToRosTemplate(properties.dbParamGroupId),
        DBTimeZone: ros.stringToRosTemplate(properties.dbTimeZone),
        DedicatedHostGroupId: ros.stringToRosTemplate(properties.dedicatedHostGroupId),
        EnableBackupLog: ros.booleanToRosTemplate(properties.enableBackupLog),
        EncryptionKey: ros.stringToRosTemplate(properties.encryptionKey),
        HighSpaceUsageProtection: ros.stringToRosTemplate(properties.highSpaceUsageProtection),
        LocalLogRetentionHours: ros.numberToRosTemplate(properties.localLogRetentionHours),
        LocalLogRetentionSpace: ros.numberToRosTemplate(properties.localLogRetentionSpace),
        LogBackupFrequency: ros.stringToRosTemplate(properties.logBackupFrequency),
        LogBackupLocalRetentionNumber: ros.numberToRosTemplate(properties.logBackupLocalRetentionNumber),
        LogBackupRetentionPeriod: ros.numberToRosTemplate(properties.logBackupRetentionPeriod),
        MaintainTime: ros.stringToRosTemplate(properties.maintainTime),
        MasterUsername: ros.stringToRosTemplate(properties.masterUsername),
        MasterUserPassword: ros.stringToRosTemplate(properties.masterUserPassword),
        MasterUserType: ros.stringToRosTemplate(properties.masterUserType),
        MultiAZ: ros.booleanToRosTemplate(properties.multiAz),
        Port: ros.numberToRosTemplate(properties.port),
        PreferredBackupPeriod: ros.listMapper(ros.objectToRosTemplate)(properties.preferredBackupPeriod),
        PreferredBackupTime: ros.stringToRosTemplate(properties.preferredBackupTime),
        PrivateIpAddress: ros.stringToRosTemplate(properties.privateIpAddress),
        Quantity: ros.numberToRosTemplate(properties.quantity),
        ReleasedKeepPolicy: ros.stringToRosTemplate(properties.releasedKeepPolicy),
        ResourceGroupId: ros.stringToRosTemplate(properties.resourceGroupId),
        RoleARN: ros.stringToRosTemplate(properties.roleArn),
        SecurityGroupId: ros.stringToRosTemplate(properties.securityGroupId),
        SlaveZoneIds: ros.listMapper(ros.stringToRosTemplate)(properties.slaveZoneIds),
        SQLCollectorStatus: ros.stringToRosTemplate(properties.sqlCollectorStatus),
        SSLSetting: ros.stringToRosTemplate(properties.sslSetting),
        Tags: ros.hashMapper(ros.objectToRosTemplate)(properties.tags),
        TargetDedicatedHostIdForLog: ros.stringToRosTemplate(properties.targetDedicatedHostIdForLog),
        TargetDedicatedHostIdForMaster: ros.stringToRosTemplate(properties.targetDedicatedHostIdForMaster),
        TargetDedicatedHostIdForSlave: ros.stringToRosTemplate(properties.targetDedicatedHostIdForSlave),
        VpcId: ros.stringToRosTemplate(properties.vpcId),
        VSwitchId: ros.stringToRosTemplate(properties.vSwitchId),
        ZoneId: ros.stringToRosTemplate(properties.zoneId),
    };
}
/**
 * A ROS template type:  `ALIYUN::RDS::PrepayDBInstance`
 */
class RosPrepayDBInstance extends ros.RosResource {
    /**
     * Create a new `ALIYUN::RDS::PrepayDBInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosPrepayDBInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrDbInstanceId = this.getAtt('DBInstanceId');
        this.attrInnerConnectionString = this.getAtt('InnerConnectionString');
        this.attrInnerIpAddress = this.getAtt('InnerIPAddress');
        this.attrInnerPort = this.getAtt('InnerPort');
        this.attrOrderId = this.getAtt('OrderId');
        this.attrPublicConnectionString = this.getAtt('PublicConnectionString');
        this.attrPublicIpAddress = this.getAtt('PublicIPAddress');
        this.attrPublicPort = this.getAtt('PublicPort');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.commodityCode = props.commodityCode;
        this.dbInstanceClass = props.dbInstanceClass;
        this.dbInstanceStorage = props.dbInstanceStorage;
        this.engine = props.engine;
        this.engineVersion = props.engineVersion;
        this.period = props.period;
        this.periodType = props.periodType;
        this.allocatePublicConnection = props.allocatePublicConnection;
        this.archiveBackupKeepCount = props.archiveBackupKeepCount;
        this.archiveBackupKeepPolicy = props.archiveBackupKeepPolicy;
        this.archiveBackupRetentionPeriod = props.archiveBackupRetentionPeriod;
        this.autoPay = props.autoPay;
        this.autoRenew = props.autoRenew;
        this.backUpCategory = props.backUpCategory;
        this.backupPolicyMode = props.backupPolicyMode;
        this.backupRetentionPeriod = props.backupRetentionPeriod;
        this.category = props.category;
        this.compressType = props.compressType;
        this.connectionMode = props.connectionMode;
        this.connectionStringPrefix = props.connectionStringPrefix;
        this.connectionStringType = props.connectionStringType;
        this.couponCode = props.couponCode;
        this.dbInstanceDescription = props.dbInstanceDescription;
        this.dbInstanceNetType = props.dbInstanceNetType;
        this.dbInstanceStorageType = props.dbInstanceStorageType;
        this.dbIsIgnoreCase = props.dbIsIgnoreCase;
        this.dbMappings = props.dbMappings;
        this.dbParamGroupId = props.dbParamGroupId;
        this.dbTimeZone = props.dbTimeZone;
        this.dedicatedHostGroupId = props.dedicatedHostGroupId;
        this.enableBackupLog = props.enableBackupLog;
        this.encryptionKey = props.encryptionKey;
        this.highSpaceUsageProtection = props.highSpaceUsageProtection;
        this.localLogRetentionHours = props.localLogRetentionHours;
        this.localLogRetentionSpace = props.localLogRetentionSpace;
        this.logBackupFrequency = props.logBackupFrequency;
        this.logBackupLocalRetentionNumber = props.logBackupLocalRetentionNumber;
        this.logBackupRetentionPeriod = props.logBackupRetentionPeriod;
        this.maintainTime = props.maintainTime;
        this.masterUsername = props.masterUsername;
        this.masterUserPassword = props.masterUserPassword;
        this.masterUserType = props.masterUserType;
        this.multiAz = props.multiAz;
        this.port = props.port;
        this.preferredBackupPeriod = props.preferredBackupPeriod;
        this.preferredBackupTime = props.preferredBackupTime;
        this.privateIpAddress = props.privateIpAddress;
        this.quantity = props.quantity;
        this.releasedKeepPolicy = props.releasedKeepPolicy;
        this.resourceGroupId = props.resourceGroupId;
        this.roleArn = props.roleArn;
        this.securityGroupId = props.securityGroupId;
        this.slaveZoneIds = props.slaveZoneIds;
        this.sqlCollectorStatus = props.sqlCollectorStatus;
        this.sslSetting = props.sslSetting;
        this.tags = props.tags;
        this.targetDedicatedHostIdForLog = props.targetDedicatedHostIdForLog;
        this.targetDedicatedHostIdForMaster = props.targetDedicatedHostIdForMaster;
        this.targetDedicatedHostIdForSlave = props.targetDedicatedHostIdForSlave;
        this.vpcId = props.vpcId;
        this.vSwitchId = props.vSwitchId;
        this.zoneId = props.zoneId;
    }
    get rosProperties() {
        return {
            commodityCode: this.commodityCode,
            dbInstanceClass: this.dbInstanceClass,
            dbInstanceStorage: this.dbInstanceStorage,
            engine: this.engine,
            engineVersion: this.engineVersion,
            period: this.period,
            periodType: this.periodType,
            allocatePublicConnection: this.allocatePublicConnection,
            archiveBackupKeepCount: this.archiveBackupKeepCount,
            archiveBackupKeepPolicy: this.archiveBackupKeepPolicy,
            archiveBackupRetentionPeriod: this.archiveBackupRetentionPeriod,
            autoPay: this.autoPay,
            autoRenew: this.autoRenew,
            backUpCategory: this.backUpCategory,
            backupPolicyMode: this.backupPolicyMode,
            backupRetentionPeriod: this.backupRetentionPeriod,
            category: this.category,
            compressType: this.compressType,
            connectionMode: this.connectionMode,
            connectionStringPrefix: this.connectionStringPrefix,
            connectionStringType: this.connectionStringType,
            couponCode: this.couponCode,
            dbInstanceDescription: this.dbInstanceDescription,
            dbInstanceNetType: this.dbInstanceNetType,
            dbInstanceStorageType: this.dbInstanceStorageType,
            dbIsIgnoreCase: this.dbIsIgnoreCase,
            dbMappings: this.dbMappings,
            dbParamGroupId: this.dbParamGroupId,
            dbTimeZone: this.dbTimeZone,
            dedicatedHostGroupId: this.dedicatedHostGroupId,
            enableBackupLog: this.enableBackupLog,
            encryptionKey: this.encryptionKey,
            highSpaceUsageProtection: this.highSpaceUsageProtection,
            localLogRetentionHours: this.localLogRetentionHours,
            localLogRetentionSpace: this.localLogRetentionSpace,
            logBackupFrequency: this.logBackupFrequency,
            logBackupLocalRetentionNumber: this.logBackupLocalRetentionNumber,
            logBackupRetentionPeriod: this.logBackupRetentionPeriod,
            maintainTime: this.maintainTime,
            masterUsername: this.masterUsername,
            masterUserPassword: this.masterUserPassword,
            masterUserType: this.masterUserType,
            multiAz: this.multiAz,
            port: this.port,
            preferredBackupPeriod: this.preferredBackupPeriod,
            preferredBackupTime: this.preferredBackupTime,
            privateIpAddress: this.privateIpAddress,
            quantity: this.quantity,
            releasedKeepPolicy: this.releasedKeepPolicy,
            resourceGroupId: this.resourceGroupId,
            roleArn: this.roleArn,
            securityGroupId: this.securityGroupId,
            slaveZoneIds: this.slaveZoneIds,
            sqlCollectorStatus: this.sqlCollectorStatus,
            sslSetting: this.sslSetting,
            tags: this.tags,
            targetDedicatedHostIdForLog: this.targetDedicatedHostIdForLog,
            targetDedicatedHostIdForMaster: this.targetDedicatedHostIdForMaster,
            targetDedicatedHostIdForSlave: this.targetDedicatedHostIdForSlave,
            vpcId: this.vpcId,
            vSwitchId: this.vSwitchId,
            zoneId: this.zoneId,
        };
    }
    renderProperties(props) {
        return rosPrepayDBInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosPrepayDBInstance = RosPrepayDBInstance;
/**
 * The resource type name for this resource class.
 */
RosPrepayDBInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::RDS::PrepayDBInstance";
/**
 * Determine whether the given properties match those of a `DBMappingsProperty`
 *
 * @param properties - the TypeScript properties of a `DBMappingsProperty`
 *
 * @returns the result of the validation.
 */
function RosPrepayDBInstance_DBMappingsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('characterSetName', ros.requiredValidator)(properties.characterSetName));
    errors.collect(ros.propertyValidator('characterSetName', ros.validateString)(properties.characterSetName));
    if (properties.dbDescription && (Array.isArray(properties.dbDescription) || (typeof properties.dbDescription) === 'string')) {
        errors.collect(ros.propertyValidator('dbDescription', ros.validateLength)({
            data: properties.dbDescription.length,
            min: undefined,
            max: 256,
        }));
    }
    errors.collect(ros.propertyValidator('dbDescription', ros.validateString)(properties.dbDescription));
    errors.collect(ros.propertyValidator('dbName', ros.requiredValidator)(properties.dbName));
    errors.collect(ros.propertyValidator('dbName', ros.validateString)(properties.dbName));
    return errors.wrap('supplied properties not correct for "DBMappingsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::RDS::PrepayDBInstance.DBMappings` resource
 *
 * @param properties - the TypeScript properties of a `DBMappingsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::RDS::PrepayDBInstance.DBMappings` resource.
 */
// @ts-ignore TS6133
function rosPrepayDBInstanceDBMappingsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosPrepayDBInstance_DBMappingsPropertyValidator(properties).assertSuccess();
    return {
        CharacterSetName: ros.stringToRosTemplate(properties.characterSetName),
        DBDescription: ros.stringToRosTemplate(properties.dbDescription),
        DBName: ros.stringToRosTemplate(properties.dbName),
    };
}
/**
 * Determine whether the given properties match those of a `RosReadOnlyDBInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosReadOnlyDBInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosReadOnlyDBInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.category && (typeof properties.category) !== 'object') {
        errors.collect(ros.propertyValidator('category', ros.validateAllowedValues)({
            data: properties.category,
            allowedValues: ["Basic", "HighAvailability", "AlwaysOn"],
        }));
    }
    errors.collect(ros.propertyValidator('category', ros.validateString)(properties.category));
    errors.collect(ros.propertyValidator('engineVersion', ros.requiredValidator)(properties.engineVersion));
    if (properties.engineVersion && (typeof properties.engineVersion) !== 'object') {
        errors.collect(ros.propertyValidator('engineVersion', ros.validateAllowedValues)({
            data: properties.engineVersion,
            allowedValues: ["5.6", "5.7", "8.0", "2017_ent"],
        }));
    }
    errors.collect(ros.propertyValidator('engineVersion', ros.validateString)(properties.engineVersion));
    errors.collect(ros.propertyValidator('privateIpAddress', ros.validateString)(properties.privateIpAddress));
    errors.collect(ros.propertyValidator('zoneId', ros.requiredValidator)(properties.zoneId));
    errors.collect(ros.propertyValidator('zoneId', ros.validateString)(properties.zoneId));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    errors.collect(ros.propertyValidator('dbInstanceClass', ros.requiredValidator)(properties.dbInstanceClass));
    errors.collect(ros.propertyValidator('dbInstanceClass', ros.validateString)(properties.dbInstanceClass));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    if (properties.payType && (typeof properties.payType) !== 'object') {
        errors.collect(ros.propertyValidator('payType', ros.validateAllowedValues)({
            data: properties.payType,
            allowedValues: ["Postpaid"],
        }));
    }
    errors.collect(ros.propertyValidator('payType', ros.validateString)(properties.payType));
    if (properties.dbInstanceStorageType && (typeof properties.dbInstanceStorageType) !== 'object') {
        errors.collect(ros.propertyValidator('dbInstanceStorageType', ros.validateAllowedValues)({
            data: properties.dbInstanceStorageType,
            allowedValues: ["local_ssd/ephemeral_ssd", "cloud_ssd", "cloud_essd"],
        }));
    }
    errors.collect(ros.propertyValidator('dbInstanceStorageType', ros.validateString)(properties.dbInstanceStorageType));
    errors.collect(ros.propertyValidator('dbInstanceId', ros.requiredValidator)(properties.dbInstanceId));
    errors.collect(ros.propertyValidator('dbInstanceId', ros.validateString)(properties.dbInstanceId));
    errors.collect(ros.propertyValidator('dbInstanceStorage', ros.requiredValidator)(properties.dbInstanceStorage));
    errors.collect(ros.propertyValidator('dbInstanceStorage', ros.validateNumber)(properties.dbInstanceStorage));
    errors.collect(ros.propertyValidator('dbInstanceDescription', ros.validateString)(properties.dbInstanceDescription));
    errors.collect(ros.propertyValidator('tags', ros.hashValidator(ros.validateAny))(properties.tags));
    return errors.wrap('supplied properties not correct for "RosReadOnlyDBInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::RDS::ReadOnlyDBInstance` resource
 *
 * @param properties - the TypeScript properties of a `RosReadOnlyDBInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::RDS::ReadOnlyDBInstance` resource.
 */
// @ts-ignore TS6133
function rosReadOnlyDBInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosReadOnlyDBInstancePropsValidator(properties).assertSuccess();
    }
    return {
        DBInstanceClass: ros.stringToRosTemplate(properties.dbInstanceClass),
        DBInstanceId: ros.stringToRosTemplate(properties.dbInstanceId),
        DBInstanceStorage: ros.numberToRosTemplate(properties.dbInstanceStorage),
        EngineVersion: ros.stringToRosTemplate(properties.engineVersion),
        ZoneId: ros.stringToRosTemplate(properties.zoneId),
        Category: ros.stringToRosTemplate(properties.category),
        DBInstanceDescription: ros.stringToRosTemplate(properties.dbInstanceDescription),
        DBInstanceStorageType: ros.stringToRosTemplate(properties.dbInstanceStorageType),
        PayType: ros.stringToRosTemplate(properties.payType),
        PrivateIpAddress: ros.stringToRosTemplate(properties.privateIpAddress),
        ResourceGroupId: ros.stringToRosTemplate(properties.resourceGroupId),
        Tags: ros.hashMapper(ros.objectToRosTemplate)(properties.tags),
        VPCId: ros.stringToRosTemplate(properties.vpcId),
        VSwitchId: ros.stringToRosTemplate(properties.vSwitchId),
    };
}
/**
 * A ROS template type:  `ALIYUN::RDS::ReadOnlyDBInstance`
 */
class RosReadOnlyDBInstance extends ros.RosResource {
    /**
     * Create a new `ALIYUN::RDS::ReadOnlyDBInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosReadOnlyDBInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrConnectionString = this.getAtt('ConnectionString');
        this.attrDbInstanceId = this.getAtt('DBInstanceId');
        this.attrPort = this.getAtt('Port');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.dbInstanceClass = props.dbInstanceClass;
        this.dbInstanceId = props.dbInstanceId;
        this.dbInstanceStorage = props.dbInstanceStorage;
        this.engineVersion = props.engineVersion;
        this.zoneId = props.zoneId;
        this.category = props.category;
        this.dbInstanceDescription = props.dbInstanceDescription;
        this.dbInstanceStorageType = props.dbInstanceStorageType;
        this.payType = props.payType;
        this.privateIpAddress = props.privateIpAddress;
        this.resourceGroupId = props.resourceGroupId;
        this.tags = props.tags;
        this.vpcId = props.vpcId;
        this.vSwitchId = props.vSwitchId;
    }
    get rosProperties() {
        return {
            dbInstanceClass: this.dbInstanceClass,
            dbInstanceId: this.dbInstanceId,
            dbInstanceStorage: this.dbInstanceStorage,
            engineVersion: this.engineVersion,
            zoneId: this.zoneId,
            category: this.category,
            dbInstanceDescription: this.dbInstanceDescription,
            dbInstanceStorageType: this.dbInstanceStorageType,
            payType: this.payType,
            privateIpAddress: this.privateIpAddress,
            resourceGroupId: this.resourceGroupId,
            tags: this.tags,
            vpcId: this.vpcId,
            vSwitchId: this.vSwitchId,
        };
    }
    renderProperties(props) {
        return rosReadOnlyDBInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosReadOnlyDBInstance = RosReadOnlyDBInstance;
/**
 * The resource type name for this resource class.
 */
RosReadOnlyDBInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::RDS::ReadOnlyDBInstance";
//# sourceMappingURL=data:application/json;base64,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