# Generated by Django 4.0.1 on 2022-02-06 23:54

from django.conf import settings
import django.contrib.auth.models
import django.contrib.auth.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=150, unique=True, validators=[django.contrib.auth.validators.UnicodeUsernameValidator()], verbose_name='username')),
                ('first_name', models.CharField(blank=True, max_length=150, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=150, verbose_name='last name')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email address')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('is_doctor', models.BooleanField(default=False)),
                ('is_admin', models.BooleanField(default=False)),
                ('is_assistant', models.BooleanField(default=False)),
                ('fn', models.CharField(default='', max_length=25)),
                ('ln', models.CharField(default='', max_length=25)),
                ('age', models.IntegerField(default=0)),
                ('phone', models.IntegerField(default=0)),
                ('address', models.CharField(default='', max_length=30)),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions')),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
                'abstract': False,
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='food',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='', max_length=25)),
                ('type', models.CharField(default='', max_length=25)),
                ('quantity', models.IntegerField(default=1)),
                ('prix', models.FloatField(default=0)),
                ('total', models.FloatField(default=0)),
            ],
        ),
        migrations.CreateModel(
            name='medecines',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='', max_length=25)),
                ('type', models.CharField(default='', max_length=25)),
                ('quantity', models.IntegerField(default=1)),
                ('prix', models.FloatField(default=0)),
                ('total', models.FloatField(default=0)),
            ],
        ),
        migrations.CreateModel(
            name='Patient',
            fields=[
                ('auto_increment_id', models.AutoField(primary_key=True, serialize=False)),
                ('firstname', models.CharField(default='', max_length=25)),
                ('lastname', models.CharField(default='', max_length=25)),
                ('age_patient', models.IntegerField(default=0)),
                ('phonep', models.IntegerField(default=0)),
                ('addressp', models.CharField(max_length=30)),
                ('currentstate', models.CharField(default='', max_length=10)),
                ('casp', models.CharField(default='', max_length=10)),
                ('cast', models.CharField(default='', max_length=10)),
                ('isin', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='TimeSlot',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('h', models.IntegerField()),
                ('m', models.CharField(max_length=2)),
            ],
        ),
        migrations.CreateModel(
            name='Dctr',
            fields=[
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to=settings.AUTH_USER_MODEL)),
                ('sector', models.CharField(default='', max_length=30)),
                ('spec', models.CharField(default='', max_length=25)),
                ('paymanet', models.FloatField(default=0)),
            ],
        ),
        migrations.CreateModel(
            name='Rdv',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200)),
                ('description', models.TextField()),
                ('paid', models.DecimalField(decimal_places=2, max_digits=8)),
                ('rdvtime', models.DateTimeField()),
                ('hr', models.IntegerField()),
                ('mn', models.CharField(max_length=2)),
                ('nature', models.CharField(default='', max_length=20)),
                ('prixprop', models.DecimalField(decimal_places=2, max_digits=8)),
                ('pp', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='med.patient')),
                ('dr', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='med.dctr')),
            ],
        ),
        migrations.AddField(
            model_name='patient',
            name='drid',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='med.dctr'),
        ),
        migrations.CreateModel(
            name='Assistant',
            fields=[
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to=settings.AUTH_USER_MODEL)),
                ('role', models.CharField(default='', max_length=25)),
                ('drid', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='med.dctr')),
            ],
        ),
    ]
