# Configuration file for the Sphinx documentation builder.
#
# For the full list of built-in configuration values, see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Project information -----------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#project-information

project = 'myforestplot'
copyright = '2022, Toshiaki Asakura'
author = 'Toshiaki Asakura'

import myforestplot
release = myforestplot.__version__

# -- General configuration ---------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#general-configuration
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.napoleon",
    "sphinx.ext.viewcode",
    "sphinx_autodoc_typehints",
    "nbsphinx",
    "sphinx.ext.mathjax",
    "sphinx_sitemap",
]

templates_path = ['_templates']
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']



# -- Options for HTML output -------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#options-for-html-output

import sphinx_rtd_theme
html_theme = "sphinx_rtd_theme"
html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]
# for edit on github.
html_context = {
  'display_github': True,
  'github_user': 'toshiakiasakura',
  'github_repo': 'myforestplot',
  'github_version': 'main/docs_src/',
}

html_baseurl = "https://toshiakiasakura.github.io/myforestplot/" # for sphinx-sitemap.
html_static_path = ['_static']
