/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.mixin.core.world.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.world.storage.SaveHandlerBridge;
import org.spongepowered.common.world.WorldManager;

@Mixin(value={SaveHandler.class})
public abstract class SaveHandlerMixin_Vanilla
implements SaveHandlerBridge {
    @Shadow
    @Final
    private File field_75770_b;

    @Inject(method={"saveWorldInfoWithPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/NBTTagCompound;setTag(Ljava/lang/String;Lnet/minecraft/nbt/NBTBase;)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void vanilla$saveDimensionMapping(WorldInfo worldInformation, NBTTagCompound tagCompound, CallbackInfo ci, NBTTagCompound nbttagcompound1, NBTTagCompound nbttagcompound2) {
        if (this.field_75770_b.getParentFile() == null || SpongeImpl.getGame().getPlatform().getType().isClient() && this.field_75770_b.getParentFile().toPath().equals(SpongeImpl.getGame().getSavesDirectory())) {
            if (!nbttagcompound2.func_150297_b("forge", 10)) {
                nbttagcompound2.func_74782_a("forge", (NBTBase)new NBTTagCompound());
            }
            NBTTagCompound forgeTag = nbttagcompound2.func_74775_l("forge");
            NBTTagCompound customDimensionDataCompound = WorldManager.saveDimensionDataMap();
            forgeTag.func_74782_a("DimensionData", (NBTBase)customDimensionDataCompound);
        }
    }

    @Redirect(method={"loadWorldInfo"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/storage/SaveFormatOld;getWorldData(Ljava/io/File;Lnet/minecraft/util/datafix/DataFixer;)Lnet/minecraft/world/storage/WorldInfo;"), require=2)
    @Nullable
    private WorldInfo vanilla$loadDimensionDataAndSpongeDataFromLevelDat(File file, DataFixer fixer) {
        try {
            NBTTagCompound root = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
            NBTTagCompound data = root.func_74775_l("Data");
            WorldInfo info = new WorldInfo(fixer.func_188257_a((IFixType)FixTypes.LEVEL, data));
            if (root.func_150297_b("forge", 10)) {
                NBTTagCompound forgeData = root.func_74775_l("forge");
                WorldManager.loadDimensionDataMap(forgeData.func_74775_l("DimensionData"));
            }
            try {
                this.bridge$loadSpongeDatData(info);
            }
            catch (Exception ex) {
                SpongeImpl.getLogger().error("Exception reading Sponge level data", (Throwable)ex);
                return null;
            }
            return info;
        }
        catch (Exception exception) {
            SpongeImpl.getLogger().error("Exception reading " + file, (Throwable)exception);
            return null;
        }
    }
}

