/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.mixin.core.world;

import net.minecraft.network.Packet;
import net.minecraft.server.management.PlayerList;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.world.WorldManager;
import org.spongepowered.server.mixin.core.world.WorldMixin_Vanilla;

@Mixin(value={WorldServer.class})
public abstract class WorldServerMixin_Vanilla
extends WorldMixin_Vanilla
implements WorldServerBridge {
    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/DimensionType;getById(I)Lnet/minecraft/world/DimensionType;"))
    private static DimensionType vanilla$getDimensionType(int dimensionId) {
        return WorldManager.getDimensionType(dimensionId).orElseThrow(() -> new IllegalArgumentException("Invalid dimension id: " + dimensionId));
    }

    @Redirect(method={"updateWeather"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/DimensionType;getId()I"))
    private int vanilla$onGetDimensionIdForWeather(DimensionType type) {
        return this.bridge$getDimensionId();
    }

    @Redirect(method={"updateWeather"}, require=4, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V"))
    private void vanilla$onSendWeatherPacket(PlayerList manager, Packet<?> packet) {
        manager.func_148537_a(packet, this.bridge$getDimensionId());
    }

    @Override
    public int bridge$getDimensionId() {
        return ((WorldInfoBridge)this.field_72986_A).bridge$getDimensionId();
    }

    @Override
    int vanillaImpl$updateRainTimeStart(int newRainTime) {
        if (!((WorldBridge)((Object)this)).bridge$isFake() && this.field_72986_A.func_76083_p() - 1 != newRainTime) {
            this.bridge$setWeatherStartTime(this.func_82737_E());
        }
        return newRainTime;
    }

    @Override
    int vanillaImpl$updateThunderTimeStart(int newThunderTime) {
        if (!((WorldBridge)((Object)this)).bridge$isFake() && this.field_72986_A.func_76071_n() - 1 != newThunderTime) {
            this.bridge$setWeatherStartTime(this.func_82737_E());
        }
        return newThunderTime;
    }
}

