/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.mixin.core.common;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.server.launch.VanillaLaunch;
import org.spongepowered.server.launch.plugin.PluginSource;

@Mixin(value={SpongeImplHooks.class}, remap=false)
public abstract class SpongeImplHooksMixin_Vanilla {
    @Overwrite
    public static boolean isDeobfuscatedEnvironment() {
        return VanillaLaunch.ENVIRONMENT == VanillaLaunch.Environment.DEVELOPMENT;
    }

    @Overwrite
    public static String getModIdFromClass(Class<?> clazz) {
        String className = clazz.getName();
        if (className.startsWith("net.minecraft.")) {
            return "minecraft";
        }
        if (className.startsWith("org.spongepowered.")) {
            return "sponge";
        }
        return PluginSource.find(clazz).map(classSource -> {
            for (PluginContainer plugin : Sponge.getPluginManager().getPlugins()) {
                Optional<Path> pluginSource = plugin.getSource();
                try {
                    if (!pluginSource.isPresent() || !Files.isSameFile(classSource, pluginSource.get())) continue;
                    return plugin.getId();
                }
                catch (IOException iOException) {
                }
            }
            return null;
        }).orElse("unknown");
    }

    @Overwrite
    public static String getImplementationId() {
        return "spongevanilla";
    }
}

