/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch.transformer.at;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.spongepowered.server.launch.VanillaLaunch;
import org.spongepowered.server.launch.transformer.at.AccessModifier;
import org.spongepowered.server.launch.transformer.at.ClassAccessModifiers;
import org.spongepowered.server.launch.transformer.deobf.SrgRemapper;

public final class AccessTransformers {
    private static final char COMMENT_PREFIX = '#';
    private static final Splitter SEPARATOR = Splitter.on((char)' ').trimResults().omitEmptyStrings();
    private static final char WILDCARD = '*';
    @Nullable
    private static Map<String, ClassAccessModifiers.Builder> rules = new HashMap<String, ClassAccessModifiers.Builder>();

    private AccessTransformers() {
    }

    private static void verifyState() {
        Preconditions.checkState((rules != null ? 1 : 0) != 0, (Object)"Attempted to register after access transformer was initialized");
    }

    public static void register(Path path) throws IOException {
        AccessTransformers.verifyState();
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            AccessTransformers.register(reader);
        }
    }

    public static void register(URL url) throws IOException {
        AccessTransformers.verifyState();
        try (InputStream in = url.openStream();){
            AccessTransformers.register(in);
        }
    }

    public static void register(InputStream in) throws IOException {
        AccessTransformers.verifyState();
        AccessTransformers.register(new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)));
    }

    public static void register(BufferedReader reader) throws IOException {
        String line;
        AccessTransformers.verifyState();
        while ((line = reader.readLine()) != null) {
            boolean method;
            if ((line = AccessTransformers.substringBefore(line, '#').trim()).isEmpty()) continue;
            List parts = SEPARATOR.splitToList((CharSequence)line);
            Preconditions.checkArgument((parts.size() <= 3 ? 1 : 0) != 0, (String)"Invalid access transformer config line: %s", (Object)line);
            AccessModifier modifier = null;
            String access = (String)parts.get(0);
            if (access.startsWith("public")) {
                modifier = AccessModifier.PUBLIC;
            } else if (access.startsWith("protected")) {
                modifier = AccessModifier.PROTECTED;
            }
            if (access.endsWith("-f")) {
                modifier = AccessModifier.REMOVE_FINAL.merge(modifier);
            }
            if (modifier == null) continue;
            String className = (String)parts.get(1);
            ClassAccessModifiers.Builder builder = rules.get(className);
            if (builder == null) {
                builder = new ClassAccessModifiers.Builder();
                rules.put(className, builder);
            }
            if (parts.size() == 2) {
                builder.applyToClass(modifier);
                continue;
            }
            String name = (String)parts.get(2);
            boolean bl = method = name.indexOf(40) > 0;
            if (name.charAt(0) == '*') {
                if (method) {
                    builder.applyToMethods(modifier);
                    continue;
                }
                builder.applyToFields(modifier);
                continue;
            }
            if (method) {
                builder.applyToMethod(name, modifier);
                continue;
            }
            builder.applyToField(name, modifier);
        }
    }

    private static String substringBefore(String s, char c) {
        int pos = s.indexOf(c);
        return pos >= 0 ? s.substring(0, pos) : s;
    }

    static ImmutableMap<String, ClassAccessModifiers> build() {
        SrgRemapper remapper = VanillaLaunch.getRemapper();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, ClassAccessModifiers.Builder> entry : rules.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue().build(remapper));
        }
        rules = null;
        return builder.build();
    }
}

