/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.NoSuchElementException;
import joptsimple.BuiltinHelpFormatter;
import joptsimple.OptionSet;
import net.minecraft.launchwrapper.Launch;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.spongepowered.server.launch.VanillaCommandLine;

public final class VanillaServerMain {
    private static final String LIBRARIES_DIR = "libraries";
    private static final String MINECRAFT_SERVER_VERSION = "1.12.2";
    private static final String MINECRAFT_SERVER_LOCAL = "minecraft_server.1.12.2.jar";
    private static final String MINECRAFT_MANIFEST_REMOTE = "https://launchermeta.mojang.com/mc/game/version_manifest.json";
    private static final String LAUNCHWRAPPER_PATH = "/net/minecraft/launchwrapper/1.12/launchwrapper-1.12.jar";
    private static final String LAUNCHWRAPPER_LOCAL = "libraries/net/minecraft/launchwrapper/1.12/launchwrapper-1.12.jar";
    private static final String LAUNCHWRAPPER_REMOTE = "https://libraries.minecraft.net/net/minecraft/launchwrapper/1.12/launchwrapper-1.12.jar";
    private static final String LAUNCHWRAPPER_SHA1 = "111e7bea9c968cdb3d06ef4632bf7ff0824d0f36";
    private static final String TWEAK_ARGUMENT = "--tweakClass";
    private static final String TWEAKER = "org.spongepowered.server.launch.VanillaServerTweaker";
    private static final char[] hexArray = "0123456789abcdef".toCharArray();

    private VanillaServerMain() {
    }

    public static void main(String[] args) throws Exception {
        OptionSet options;
        block8: {
            options = VanillaCommandLine.parse(args);
            if (options.has(VanillaCommandLine.HELP)) {
                if (System.console() == null) {
                    VanillaCommandLine.printHelp(System.err);
                } else {
                    Terminal terminal = TerminalBuilder.builder().dumb(true).build();
                    VanillaCommandLine.printHelp(new BuiltinHelpFormatter(terminal.getWidth(), 3), System.err);
                }
                return;
            }
            if (options.has(VanillaCommandLine.VERSION)) {
                Package pack = VanillaServerMain.class.getPackage();
                System.out.println(pack.getImplementationTitle() + ' ' + pack.getImplementationVersion());
                System.out.println(pack.getSpecificationTitle() + ' ' + pack.getSpecificationVersion());
                return;
            }
            if (!options.has(VanillaCommandLine.NO_VERIFY_CLASSPATH)) {
                Path base = Paths.get(VanillaServerMain.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent();
                try {
                    if (!VanillaServerMain.downloadMinecraft(base, !options.has(VanillaCommandLine.NO_DOWNLOAD))) {
                        System.err.println("Failed to load all required dependencies. Please download them manually:");
                        System.err.println("Download the Minecraft server version 1.12.2 and copy it to " + base.resolve(MINECRAFT_SERVER_LOCAL).toAbsolutePath());
                        System.err.println("Download https://libraries.minecraft.net/net/minecraft/launchwrapper/1.12/launchwrapper-1.12.jar and copy it to " + base.resolve(LAUNCHWRAPPER_LOCAL).toAbsolutePath());
                        System.exit(1);
                        return;
                    }
                    break block8;
                }
                catch (IOException e) {
                    System.err.println("Failed to download required dependencies. Please try again later.");
                    e.printStackTrace();
                    System.exit(1);
                    return;
                }
            }
            System.err.println("Classpath verification is disabled. The server may NOT start properly unless you have all required dependencies on the classpath!");
        }
        Launch.main((String[])VanillaServerMain.getLaunchArguments(TWEAKER, options.valuesOf(VanillaCommandLine.TWEAK_CLASS)));
    }

    private static String[] getLaunchArguments(String primaryTweaker, List<String> tweakers) {
        if (tweakers.isEmpty()) {
            return new String[]{TWEAK_ARGUMENT, primaryTweaker};
        }
        String[] result = new String[tweakers.size() * 2 + 2];
        result[0] = TWEAK_ARGUMENT;
        result[1] = primaryTweaker;
        int i = 2;
        for (String tweaker : tweakers) {
            result[i++] = TWEAK_ARGUMENT;
            result[i++] = tweaker;
        }
        return result;
    }

    private static boolean downloadMinecraft(Path base, boolean autoDownload) throws IOException, NoSuchAlgorithmException {
        Path path = base.resolve(MINECRAFT_SERVER_LOCAL);
        if (Files.notExists(path, new LinkOption[0])) {
            if (!autoDownload) {
                return false;
            }
            System.out.println("Downloading the versions manifest...");
            JsonValue versions = VanillaServerMain.downloadJson(MINECRAFT_MANIFEST_REMOTE);
            String versionManifestRemote = null;
            for (JsonValue versionInfo : versions.asObject().get("versions").asArray()) {
                JsonObject obj = versionInfo.asObject();
                String versionId = obj.get("id").asString();
                if (!versionId.equals(MINECRAFT_SERVER_VERSION)) continue;
                versionManifestRemote = obj.get("url").asString();
                break;
            }
            if (versionManifestRemote == null) {
                throw new NoSuchElementException("Could not find 1.12.2's manifest URL");
            }
            JsonValue versionManifest = VanillaServerMain.downloadJson(versionManifestRemote);
            JsonObject serverObj = versionManifest.asObject().get("downloads").asObject().get("server").asObject();
            String serverRemote = serverObj.get("url").asString();
            String sha1 = serverObj.get("sha1").asString();
            VanillaServerMain.downloadAndVerify(serverRemote, path, sha1);
        }
        if (!Files.exists(path = base.resolve(LAUNCHWRAPPER_LOCAL), new LinkOption[0])) {
            if (!autoDownload) {
                return false;
            }
            VanillaServerMain.downloadAndVerify(LAUNCHWRAPPER_REMOTE, path, LAUNCHWRAPPER_SHA1);
        }
        return true;
    }

    private static JsonValue downloadJson(String remote) throws IOException {
        URL url = new URL(remote);
        try (InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);){
            JsonValue jsonValue = Json.parse(reader);
            return jsonValue;
        }
    }

    private static void downloadAndVerify(String remote, Path path, String expected) throws IOException, NoSuchAlgorithmException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        String name = path.getFileName().toString();
        URL url = new URL(remote);
        System.out.println("Downloading " + name + "... This can take a while.");
        System.out.println(url);
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        try (DigestInputStream stream = new DigestInputStream(url.openStream(), sha1);
             ReadableByteChannel in = Channels.newChannel(stream);
             FileChannel out = FileChannel.open(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
            out.transferFrom(in, 0L, Long.MAX_VALUE);
        }
        String fileSha1 = VanillaServerMain.toHexString(sha1.digest());
        if (!expected.equals(fileSha1)) {
            Files.delete(path);
            throw new IOException("Checksum verification failed: Expected " + expected + ", got " + fileSha1);
        }
        System.out.println("Successfully downloaded " + name + " and verified checksum!");
    }

    private static String toHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

