/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.schematic;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.world.schematic.BlockPalette;
import org.spongepowered.api.world.schematic.BlockPaletteType;
import org.spongepowered.api.world.schematic.Palette;

public class BlockPaletteWrapper
implements BlockPalette {
    private final Palette<BlockState> palette;
    private final BlockPaletteType type;

    public BlockPaletteWrapper(Palette<BlockState> palette, BlockPaletteType type) {
        this.palette = palette;
        this.type = type;
    }

    @Override
    public BlockPaletteType getType() {
        return this.type;
    }

    @Override
    public int getHighestId() {
        return this.palette.getHighestId();
    }

    @Override
    public Optional<BlockState> get(int id) {
        return this.palette.get((BlockState)id);
    }

    @Override
    public Optional<Integer> get(BlockState state) {
        return this.palette.get(state);
    }

    @Override
    public int getOrAssign(BlockState state) {
        return this.palette.getOrAssign(state);
    }

    @Override
    public boolean remove(BlockState state) {
        return this.palette.remove(state);
    }

    @Override
    public Collection<BlockState> getEntries() {
        return this.palette.getEntries();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockPaletteWrapper that = (BlockPaletteWrapper)o;
        return this.palette.equals(that.palette) && this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.palette, this.type);
    }
}

