/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import net.minecraft.world.gen.feature.WorldGenDeadBush;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.populator.DeadBush;

public class DeadBushBuilder
implements DeadBush.Builder {
    private VariableAmount count;

    public DeadBushBuilder() {
        this.reset();
    }

    @Override
    public DeadBush.Builder perChunk(VariableAmount count) {
        this.count = (VariableAmount)Preconditions.checkNotNull((Object)count, (Object)"count");
        return this;
    }

    @Override
    public DeadBush.Builder from(DeadBush value) {
        this.perChunk(value.getShrubsPerChunk());
        return this;
    }

    @Override
    public DeadBush.Builder reset() {
        this.count = VariableAmount.fixed(128.0);
        return this;
    }

    @Override
    public DeadBush build() throws IllegalStateException {
        DeadBush pop = (DeadBush)new WorldGenDeadBush();
        pop.setShrubsPerChunk(this.count);
        return pop;
    }
}

