/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.selector;

import org.spongepowered.api.CatalogType;
import org.spongepowered.api.text.selector.Argument;
import org.spongepowered.api.text.selector.ArgumentType;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public class SpongeArgument<T>
implements Argument<T> {
    private final ArgumentType<T> type;
    private final T value;

    private static String toSelectorArgument(Object val) {
        if (val instanceof CatalogType) {
            return ((CatalogType)val).getName();
        }
        return String.valueOf(val);
    }

    public SpongeArgument(ArgumentType<T> type, T value) {
        this.type = type;
        this.value = value;
    }

    String getEqualitySymbols() {
        return "=";
    }

    @Override
    public ArgumentType<T> getType() {
        return this.type;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public String toPlain() {
        return this.type.getKey() + this.getEqualitySymbols() + SpongeArgument.toSelectorArgument(this.getValue());
    }

    public static class Invertible<T>
    extends SpongeArgument<T>
    implements Argument.Invertible<T> {
        private final boolean inverted;

        public Invertible(ArgumentType.Invertible<T> type, T value, boolean inverted) {
            super(type, value);
            this.inverted = inverted;
        }

        @Override
        String getEqualitySymbols() {
            return this.isInverted() ? "!=" : "=";
        }

        @Override
        public boolean isInverted() {
            return this.inverted;
        }

        @Override
        public Argument.Invertible<T> invert() {
            return new Invertible((ArgumentType.Invertible)this.getType(), this.getValue(), !this.isInverted());
        }
    }
}

