/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.relocate.co.aikar.timings;

import com.google.gson.JsonArray;
import java.util.function.Function;
import org.spongepowered.common.relocate.co.aikar.util.JSONUtil;

class TimingData {
    static Function<Integer, TimingData> LOADER = new Function<Integer, TimingData>(){

        @Override
        public TimingData apply(Integer input) {
            return new TimingData(input);
        }
    };
    private int id;
    int count = 0;
    private int lagCount = 0;
    long totalTime = 0L;
    private long lagTotalTime = 0L;
    int curTickCount = 0;
    long curTickTotal = 0L;

    TimingData(int id) {
        this.id = id;
    }

    TimingData(TimingData data) {
        this.id = data.id;
        this.totalTime = data.totalTime;
        this.lagTotalTime = data.lagTotalTime;
        this.count = data.count;
        this.lagCount = data.lagCount;
    }

    void add(long diff) {
        ++this.curTickCount;
        this.curTickTotal += diff;
    }

    void processTick(boolean violated) {
        this.totalTime += this.curTickTotal;
        this.count += this.curTickCount;
        if (violated) {
            this.lagTotalTime += this.curTickTotal;
            this.lagCount += this.curTickCount;
        }
        this.curTickTotal = 0L;
        this.curTickCount = 0;
    }

    void reset() {
        this.count = 0;
        this.lagCount = 0;
        this.curTickTotal = 0L;
        this.curTickCount = 0;
        this.totalTime = 0L;
        this.lagTotalTime = 0L;
    }

    protected TimingData clone() {
        return new TimingData(this);
    }

    public JsonArray export() {
        JsonArray array = JSONUtil.arrayOf(this.id, this.count, this.totalTime);
        if (this.lagCount > 0) {
            array.addAll(JSONUtil.arrayOf(this.lagCount, this.lagTotalTime));
        }
        return array;
    }

    boolean hasData() {
        return this.count > 0;
    }

    long getTotalTime() {
        return this.totalTime;
    }

    int getCurTickCount() {
        return this.curTickCount;
    }

    void setCurTickCount(int curTickCount) {
        this.curTickCount = curTickCount;
    }

    long getCurTickTotal() {
        return this.curTickTotal;
    }

    void setCurTickTotal(long curTickTotal) {
        this.curTickTotal = curTickTotal;
    }
}

