/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.statistic;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.statistic.StatisticType;
import org.spongepowered.api.statistic.StatisticTypes;
import org.spongepowered.common.statistic.SpongeStatisticType;

public final class StatisticTypeRegistryModule
implements CatalogRegistryModule<StatisticType> {
    @RegisterCatalog(value=StatisticTypes.class)
    private final Map<String, StatisticType> statisticTypeMappings = Maps.newHashMap();

    @Override
    public Optional<StatisticType> getById(String id) {
        return Optional.ofNullable(this.statisticTypeMappings.get(id.toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<StatisticType> getAll() {
        return ImmutableSet.copyOf(this.statisticTypeMappings.values());
    }

    @Override
    public void registerDefaults() {
        this.registerDefault("basic");
        this.registerDefault("blocks_broken", "mine_block");
        this.registerDefault("entities_killed", "kill_entity");
        this.registerDefault("items_broken", "break_item");
        this.registerDefault("items_crafted", "craft_item");
        this.registerDefault("items_dropped", "drop");
        this.registerDefault("items_picked_up", "pickup");
        this.registerDefault("items_used", "use_item");
        this.registerDefault("killed_by_entity", "entity_killed_by");
    }

    private void registerDefault(String id) {
        this.statisticTypeMappings.put(id, new SpongeStatisticType(id));
    }

    private void registerDefault(String id, String alias) {
        SpongeStatisticType type = new SpongeStatisticType(id);
        this.statisticTypeMappings.put(id, type);
        this.statisticTypeMappings.put(alias, type);
    }
}

