/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.item.inventory.property.GuiId;
import org.spongepowered.api.item.inventory.property.GuiIds;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.data.type.SpongeGuiId;

public class GuiIdRegistryModule
implements CatalogRegistryModule<GuiId>,
AdditionalCatalogRegistryModule<GuiId> {
    @RegisterCatalog(value=GuiIds.class)
    private final Map<String, GuiId> guiIdMap = new HashMap<String, GuiId>();

    public static GuiIdRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public Optional<GuiId> getById(String id) {
        return Optional.ofNullable(this.guiIdMap.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<GuiId> getAll() {
        return ImmutableList.copyOf(this.guiIdMap.values());
    }

    @Override
    public void registerDefaults() {
        this.register("minecraft:chest");
        this.register("minecraft:furnace");
        this.register("minecraft:dispenser");
        this.register("minecraft:crafting_table");
        this.register("minecraft:brewing_stand");
        this.register("minecraft:hopper");
        this.register("minecraft:beacon");
        this.register("minecraft:enchanting_table");
        this.register("minecraft:anvil");
        this.register("minecraft:villager");
        this.register("minecraft:horse", "EntityHorse");
        this.register("minecraft:shulker_box");
    }

    private void register(String id) {
        this.guiIdMap.put(id, new SpongeGuiId(id));
    }

    private void register(String id, String internalId) {
        this.guiIdMap.put(id, new SpongeGuiId(id, internalId));
    }

    @Override
    public void registerAdditionalCatalog(GuiId guiId) {
        if (this.guiIdMap.containsKey(guiId.getId())) {
            throw new IllegalArgumentException("GuiId is already registered");
        }
        this.guiIdMap.put(guiId.getId(), guiId);
    }

    private GuiIdRegistryModule() {
    }

    private static final class Holder {
        static final GuiIdRegistryModule INSTANCE = new GuiIdRegistryModule();

        private Holder() {
        }
    }
}

