/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.AbstractChestHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.play.client.CPacketClientSettings;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.EnumHand;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.entity.player.EntityPlayerMPBridge;
import org.spongepowered.common.bridge.inventory.TrackedInventoryBridge;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.item.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.inventory.util.ContainerUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.entity.EntityAccessor;
import org.spongepowered.common.mixin.core.entity.passive.AbstractChestHorseAccessor;
import org.spongepowered.common.mixin.core.entity.passive.EntityPigAccessor;
import org.spongepowered.common.mixin.core.entity.passive.EntitySheepAccessor;
import org.spongepowered.common.mixin.core.entity.passive.EntityWolfAccessor;
import org.spongepowered.common.mixin.core.network.play.client.CPacketPlayerAccessor;

public final class PacketPhaseUtil {
    public static void handleSlotRestore(EntityPlayer player, @Nullable Container openContainer, List<SlotTransaction> slotTransactions, boolean eventCancelled) {
        for (SlotTransaction slotTransaction : slotTransactions) {
            if (!slotTransaction.getCustom().isPresent() && slotTransaction.isValid() && !eventCancelled) continue;
            SlotAdapter slot = (SlotAdapter)slotTransaction.getSlot();
            ItemStackSnapshot snapshot = eventCancelled || !slotTransaction.isValid() ? (ItemStackSnapshot)slotTransaction.getOriginal() : (ItemStackSnapshot)slotTransaction.getCustom().get();
            net.minecraft.item.ItemStack originalStack = ItemStackUtil.fromSnapshotToNative(snapshot);
            if (openContainer == null) {
                slot.set((ItemStack)originalStack);
                continue;
            }
            int slotNumber = slot.slotNumber;
            Slot nmsSlot = openContainer.func_75139_a(slotNumber);
            if (nmsSlot == null) continue;
            nmsSlot.func_75215_d(originalStack);
        }
        if (openContainer != null) {
            boolean capture = ((TrackedInventoryBridge)openContainer).bridge$capturingInventory();
            ((TrackedInventoryBridge)openContainer).bridge$setCaptureInventory(false);
            openContainer.func_75142_b();
            ((TrackedInventoryBridge)openContainer).bridge$setCaptureInventory(capture);
            if (eventCancelled && player.field_71070_bA == openContainer && player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).func_71120_a(openContainer);
            }
        }
    }

    public static void handleCustomCursor(EntityPlayer player, ItemStackSnapshot customCursor) {
        net.minecraft.item.ItemStack cursor = ItemStackUtil.fromSnapshotToNative(customCursor);
        player.field_71071_by.func_70437_b(cursor);
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(-1, -1, cursor));
        }
    }

    public static void validateCapturedTransactions(int slotId, Container openContainer, List<SlotTransaction> capturedTransactions) {
        Slot slot;
        if (capturedTransactions.size() == 0 && slotId >= 0 && slotId < openContainer.field_75151_b.size() && (slot = openContainer.func_75139_a(slotId)) != null) {
            ItemStackSnapshot snapshot = slot.func_75216_d() ? ((ItemStack)slot.func_75211_c()).createSnapshot() : ItemStackSnapshot.NONE;
            SlotTransaction slotTransaction = new SlotTransaction(ContainerUtil.getSlot(openContainer, slotId), snapshot, snapshot);
            capturedTransactions.add(slotTransaction);
        }
    }

    public static void handlePlayerSlotRestore(EntityPlayerMP player, net.minecraft.item.ItemStack itemStack, EnumHand hand) {
        if (itemStack.func_190926_b()) {
            return;
        }
        player.field_71137_h = false;
        int slotId = 0;
        if (hand == EnumHand.OFF_HAND) {
            player.field_71071_by.field_184439_c.set(0, (Object)itemStack);
            slotId = player.field_71071_by.field_70462_a.size() + InventoryPlayer.func_70451_h();
        } else {
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)itemStack);
            Slot slot = player.field_71070_bA.func_75147_a((IInventory)player.field_71071_by, player.field_71071_by.field_70461_c);
            slotId = slot.field_75222_d;
        }
        player.field_71070_bA.func_75142_b();
        player.field_71137_h = false;
        player.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(player.field_71070_bA.field_75152_c, slotId, itemStack));
    }

    public static boolean allTransactionsInvalid(List<SlotTransaction> slotTransactions) {
        if (slotTransactions.size() == 0) {
            return false;
        }
        for (SlotTransaction slotTransaction : slotTransactions) {
            if (!slotTransaction.isValid()) continue;
            return false;
        }
        return true;
    }

    public static void onProcessPacket(Packet packetIn, INetHandler netHandler) {
        if (netHandler instanceof NetHandlerPlayServer) {
            EntityPlayerMP packetPlayer = ((NetHandlerPlayServer)netHandler).field_147369_b;
            if (!(packetPlayer.func_70089_S() || packetIn instanceof CPacketCustomPayload || packetIn instanceof CPacketClientStatus && ((CPacketClientStatus)packetIn).func_149435_c() == CPacketClientStatus.State.PERFORM_RESPAWN)) {
                return;
            }
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                CPacketPlayer movingPacket;
                frame.pushCause(packetPlayer);
                if (SpongeImplHooks.creativeExploitCheck(packetIn, packetPlayer)) {
                    return;
                }
                boolean ignoreMovementCapture = packetIn instanceof CPacketPlayer ? ((movingPacket = (CPacketPlayer)packetIn) instanceof CPacketPlayer.Rotation ? true : packetPlayer.field_70165_t == ((CPacketPlayerAccessor)movingPacket).accessor$getX() && packetPlayer.field_70163_u == ((CPacketPlayerAccessor)movingPacket).accessor$getY() && packetPlayer.field_70161_v == ((CPacketPlayerAccessor)movingPacket).accessor$getZ()) : false;
                if (ignoreMovementCapture || packetIn instanceof CPacketClientSettings) {
                    packetIn.func_148833_a(netHandler);
                }
                ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(packetPlayer.field_71071_by.func_70445_o());
                IPhaseState<PacketContext<?>> packetState = PacketPhase.getInstance().getStateForPacket(packetIn);
                PacketContext<?> context = packetState.createPhaseContext();
                if (!PacketPhase.getInstance().isPacketInvalid(packetIn, packetPlayer, packetState)) {
                    ((PacketContext)((PacketContext)((PacketContext)context.source(packetPlayer)).packetPlayer(packetPlayer)).packet(packetIn)).cursor(cursor);
                    PacketPhase.getInstance().populateContext(packetIn, packetPlayer, packetState, context);
                    context.owner((Player)packetPlayer);
                    context.notifier((Player)packetPlayer);
                }
                try (PacketContext<?> packetContext = context;){
                    packetContext.buildAndSwitch();
                    packetIn.func_148833_a(netHandler);
                }
                if (packetIn instanceof CPacketClientStatus) {
                    packetPlayer = ((NetHandlerPlayServer)netHandler).field_147369_b;
                }
                ((EntityPlayerMPBridge)packetPlayer).bridge$setPacketItem(net.minecraft.item.ItemStack.field_190927_a);
            }
        } else {
            packetIn.func_148833_a(netHandler);
        }
    }

    @Nullable
    public static DataParameter<?> findModifiedEntityInteractDataParameter(net.minecraft.item.ItemStack stack, Entity entity) {
        Item item = stack.func_77973_b();
        if (item == Items.field_151100_aR) {
            if (entity instanceof EntitySheep) {
                return EntitySheepAccessor.accessor$getDyeColorParameter();
            }
            if (entity instanceof EntityWolf) {
                return EntityWolfAccessor.accessor$getCollarColorParameter();
            }
            return null;
        }
        if (item == Items.field_151057_cb) {
            return entity instanceof EntityLivingBase && !(entity instanceof EntityPlayer) && stack.func_82837_s() ? EntityAccessor.accessor$getCustomNameParameter() : null;
        }
        if (item == Items.field_151141_av) {
            return entity instanceof EntityPig ? EntityPigAccessor.accessor$getSaddledParameter() : null;
        }
        if (item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() == Blocks.field_150486_ae) {
            return entity instanceof AbstractChestHorse ? AbstractChestHorseAccessor.accessor$getDataIdChestParameter() : null;
        }
        return null;
    }
}

