/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.type;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.block.tileentity.TileEntityType;
import org.spongepowered.common.SpongeCatalogType;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.category.TileEntityTrackerCategory;
import org.spongepowered.common.config.category.TileEntityTrackerModCategory;
import org.spongepowered.common.config.type.TrackerConfig;

public class SpongeTileEntityType
extends SpongeCatalogType
implements TileEntityType {
    private final String name;
    private final String modId;
    private final Class<? extends TileEntity> clazz;
    private final boolean canTick;
    public boolean allowsBlockBulkCapture = true;
    public boolean allowsEntityBulkCapture = true;
    public boolean allowsBlockEventCreation = true;
    public boolean allowsEntityEventCreation = true;

    public SpongeTileEntityType(Class<? extends TileEntity> clazz, String name, String id, boolean canTick, String modId) {
        super(id);
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.clazz = (Class)Preconditions.checkNotNull(clazz, (Object)"clazz");
        this.canTick = canTick;
        this.modId = modId;
        this.initializeTrackerState();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getModId() {
        return this.modId;
    }

    public boolean canTick() {
        return this.canTick;
    }

    public void initializeTrackerState() {
        SpongeConfig<TrackerConfig> trackerConfigAdapter = SpongeImpl.getTrackerConfigAdapter();
        TileEntityTrackerCategory tileEntityTracker = trackerConfigAdapter.getConfig().getTileEntityTracker();
        String modId = this.modId;
        String name = this.name;
        TileEntityTrackerModCategory modCapturing = tileEntityTracker.getModMappings().get(modId);
        if (modCapturing == null) {
            modCapturing = new TileEntityTrackerModCategory();
            tileEntityTracker.getModMappings().put(modId, modCapturing);
        }
        if (!modCapturing.isEnabled()) {
            this.allowsBlockBulkCapture = false;
            this.allowsEntityBulkCapture = false;
            this.allowsBlockEventCreation = false;
            this.allowsEntityEventCreation = false;
            modCapturing.getBlockBulkCaptureMap().computeIfAbsent(name.toLowerCase(), k -> this.allowsBlockBulkCapture);
            modCapturing.getEntityBulkCaptureMap().computeIfAbsent(name.toLowerCase(), k -> this.allowsEntityBulkCapture);
            modCapturing.getBlockEventCreationMap().computeIfAbsent(name.toLowerCase(), k -> this.allowsBlockEventCreation);
            modCapturing.getEntityEventCreationMap().computeIfAbsent(name.toLowerCase(), k -> this.allowsEntityEventCreation);
        } else {
            this.allowsBlockBulkCapture = modCapturing.getBlockBulkCaptureMap().computeIfAbsent(name.toLowerCase(), k -> true);
            this.allowsEntityBulkCapture = modCapturing.getEntityBulkCaptureMap().computeIfAbsent(name.toLowerCase(), k -> true);
            this.allowsBlockEventCreation = modCapturing.getBlockEventCreationMap().computeIfAbsent(name.toLowerCase(), k -> true);
            this.allowsEntityEventCreation = modCapturing.getEntityEventCreationMap().computeIfAbsent(name.toLowerCase(), k -> true);
        }
        if (tileEntityTracker.autoPopulateData()) {
            trackerConfigAdapter.save();
        }
    }

    @Override
    public Class<? extends TileEntity> getTileEntityType() {
        return this.clazz;
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("TileEntityClass", this.clazz);
    }
}

