/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.common;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;

public abstract class AbstractSingleData<T, M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>>
extends AbstractData<M, I> {
    protected final Key<? extends BaseValue<T>> usedKey;
    private T value;

    protected AbstractSingleData(Class<M> manipulatorClass, T value, Key<? extends BaseValue<T>> usedKey) {
        super(manipulatorClass);
        this.value = Preconditions.checkNotNull(value);
        this.usedKey = (Key)Preconditions.checkNotNull(usedKey);
        this.registerGettersAndSetters();
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(this.usedKey, this::getValue);
        this.registerFieldSetter(this.usedKey, this::setValue);
        this.registerKeyValue(this.usedKey, this::getValueGetter);
    }

    protected abstract Value<?> getValueGetter();

    @Override
    public <E> Optional<E> get(Key<? extends BaseValue<E>> key) {
        return key == this.usedKey ? Optional.of(this.value) : super.get(key);
    }

    @Override
    public boolean supports(Key<?> key) {
        return Preconditions.checkNotNull(key) == this.usedKey;
    }

    @Override
    public abstract I asImmutable();

    protected T getValue() {
        return this.value;
    }

    protected M setValue(T value) {
        this.value = Preconditions.checkNotNull(value);
        return (M)this;
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(this.usedKey, (Object)this.getValue());
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode((Object[])new Object[]{this.value});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractSingleData other = (AbstractSingleData)obj;
        return Objects.equal(this.value, other.value);
    }
}

