/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.Optional;
import net.minecraft.util.math.MathHelper;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.AdvancementProgress;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.CriterionProgress;
import org.spongepowered.api.advancement.criteria.ScoreAdvancementCriterion;
import org.spongepowered.api.advancement.criteria.ScoreCriterionProgress;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.advancement.CriterionEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.advancement.ImplementationBackedCriterionProgress;
import org.spongepowered.common.advancement.SpongeScoreCriterion;
import org.spongepowered.common.bridge.advancements.AdvancementProgressBridge;
import org.spongepowered.common.bridge.advancements.PlayerAdvancementsBridge;

public class SpongeScoreCriterionProgress
implements ScoreCriterionProgress,
ImplementationBackedCriterionProgress {
    private final SpongeScoreCriterion criterion;
    private final AdvancementProgress progress;
    private int score = -1;

    public SpongeScoreCriterionProgress(AdvancementProgress progress, SpongeScoreCriterion criterion) {
        this.criterion = criterion;
        this.progress = progress;
    }

    @Override
    public ScoreAdvancementCriterion getCriterion() {
        return this.criterion;
    }

    @Override
    public int getScore() {
        if (this.score == -1) {
            this.score = 0;
            for (AdvancementCriterion advancementCriterion : this.criterion.internalCriteria) {
                Optional<Instant> time1 = this.progress.get(advancementCriterion).get().get();
                if (!time1.isPresent()) continue;
                ++this.score;
            }
        }
        return this.score;
    }

    @Override
    public Optional<Instant> set(int score) {
        Preconditions.checkState((score >= 0 && score <= this.getGoal() ? 1 : 0) != 0, (Object)"Score cannot be negative or greater than the goal.");
        int lastScore = this.getScore();
        if (lastScore == score) {
            return this.get();
        }
        Cause cause = SpongeImpl.getCauseStackManager().getCurrentCause();
        Advancement advancement = this.progress.getAdvancement();
        Player player = ((PlayerAdvancementsBridge)((AdvancementProgressBridge)((Object)this.progress)).bridge$getPlayerAdvancements()).bridge$getPlayer();
        CriterionEvent.Score.Change event = lastScore == this.getGoal() ? SpongeEventFactory.createCriterionEventScoreRevoke(cause, advancement, this.getCriterion(), player, lastScore, score) : (score == this.getGoal() ? SpongeEventFactory.createCriterionEventScoreGrant(cause, advancement, this.getCriterion(), player, Instant.now(), lastScore, score) : SpongeEventFactory.createCriterionEventScoreChange(cause, advancement, this.getCriterion(), player, lastScore, score));
        if (SpongeImpl.postEvent(event)) {
            return this.get();
        }
        SpongeScoreCriterion.BYPASS_EVENT = true;
        if (score == this.getGoal()) {
            Instant instant = null;
            for (AdvancementCriterion advancementCriterion : this.criterion.internalCriteria) {
                CriterionProgress progress = this.progress.get(advancementCriterion).get();
                if (progress.achieved()) continue;
                instant = progress.grant();
            }
            this.score = score;
            return Optional.of(instant == null ? Instant.now() : instant);
        }
        for (AdvancementCriterion advancementCriterion : this.criterion.internalCriteria) {
            CriterionProgress criterionProgress = this.progress.get(advancementCriterion).get();
            if (lastScore < score && !criterionProgress.achieved()) {
                criterionProgress.grant();
                ++lastScore;
            } else if (lastScore > score && criterionProgress.achieved()) {
                criterionProgress.revoke();
                --lastScore;
            }
            if (lastScore != score) continue;
            break;
        }
        this.score = score;
        SpongeScoreCriterion.BYPASS_EVENT = false;
        return Optional.empty();
    }

    @Override
    public Optional<Instant> add(int score) {
        return this.set(MathHelper.func_76125_a((int)(this.getScore() + score), (int)0, (int)this.getGoal()));
    }

    @Override
    public Optional<Instant> remove(int score) {
        return this.set(MathHelper.func_76125_a((int)(this.getScore() - score), (int)0, (int)this.getGoal()));
    }

    @Override
    public Optional<Instant> get() {
        Optional<Instant> time = Optional.empty();
        for (AdvancementCriterion advancementCriterion : this.criterion.internalCriteria) {
            Optional<Instant> time1 = this.progress.get(advancementCriterion).get().get();
            if (!time1.isPresent()) {
                return Optional.empty();
            }
            if (time.isPresent() && !time1.get().isAfter(time.get())) continue;
            time = time1;
        }
        return time;
    }

    @Override
    public Instant grant() {
        return this.set(this.getGoal()).get();
    }

    @Override
    public Optional<Instant> revoke() {
        Optional<Instant> previousState = this.get();
        this.set(0);
        return previousState;
    }

    @Override
    public void invalidateAchievedState() {
        this.score = -1;
    }
}

