/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.extent.worker.MutableBiomeVolumeWorker;
import org.spongepowered.api.world.extent.worker.MutableBlockVolumeWorker;

public interface Chunk
extends Extent {
    default public Location<Chunk> getLocation(Vector3i position) {
        return new Location<Chunk>(this, position);
    }

    default public Location<Chunk> getLocation(int x, int y, int z) {
        return this.getLocation(new Vector3i(x, y, z));
    }

    default public Location<Chunk> getLocation(Vector3d position) {
        return new Location<Chunk>(this, position);
    }

    default public Location<Chunk> getLocation(double x, double y, double z) {
        return this.getLocation(new Vector3d(x, y, z));
    }

    public Vector3i getPosition();

    public World getWorld();

    public boolean isPopulated();

    public boolean loadChunk(boolean var1);

    public boolean unloadChunk();

    @Deprecated
    public int getInhabittedTime();

    public int getInhabitedTime();

    public double getRegionalDifficultyFactor();

    public double getRegionalDifficultyPercentage();

    default public Optional<Chunk> getNeighbor(Direction direction) {
        return this.getNeighbor(direction, false);
    }

    default public Optional<Chunk> getNeighbor(Direction direction, boolean shouldLoad) {
        Optional<Vector3i> neighborPosition = Sponge.getServer().getChunkLayout().moveToChunk(this.getPosition(), direction);
        return neighborPosition.flatMap(vector3i -> this.getWorld().loadChunk((Vector3i)vector3i, shouldLoad));
    }

    @Override
    public MutableBiomeVolumeWorker<Chunk> getBiomeWorker();

    @Override
    public MutableBlockVolumeWorker<Chunk> getBlockWorker();
}

