/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.ShiftClickAction;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextFormat;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.selector.Selector;

public final class SelectorText
extends Text {
    final Selector selector;

    SelectorText(Selector selector) {
        this.selector = (Selector)Preconditions.checkNotNull((Object)selector, (Object)"selector");
    }

    SelectorText(TextFormat format, ImmutableList<Text> children, @Nullable ClickAction<?> clickAction, @Nullable HoverAction<?> hoverAction, @Nullable ShiftClickAction<?> shiftClickAction, Selector selector) {
        super(format, children, clickAction, hoverAction, shiftClickAction);
        this.selector = (Selector)Preconditions.checkNotNull((Object)selector, (Object)"selector");
    }

    public Selector getSelector() {
        return this.selector;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SelectorText) || !super.equals(o)) {
            return false;
        }
        SelectorText that = (SelectorText)o;
        return this.selector.equals(that.selector);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.selector});
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().addValue((Object)this.selector);
    }

    public static class Builder
    extends Text.Builder {
        private Selector selector;

        Builder(Selector selector) {
            this.selector(selector);
        }

        Builder(Text text, Selector selector) {
            super(text);
            this.selector(selector);
        }

        Builder(SelectorText text) {
            super(text);
            this.selector = text.selector;
        }

        public final Selector getSelector() {
            return this.selector;
        }

        public Builder selector(Selector selector) {
            this.selector = (Selector)Preconditions.checkNotNull((Object)selector, (Object)"selector");
            return this;
        }

        @Override
        public SelectorText build() {
            return new SelectorText(this.format, (ImmutableList<Text>)ImmutableList.copyOf((Collection)this.children), this.clickAction, this.hoverAction, this.shiftClickAction, this.selector);
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Builder) || !super.equals(o)) {
                return false;
            }
            Builder that = (Builder)o;
            return Objects.equal((Object)this.selector, (Object)that.selector);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.selector});
        }

        @Override
        MoreObjects.ToStringHelper toStringHelper() {
            return super.toStringHelper().addValue((Object)this.selector);
        }

        @Override
        public Builder format(TextFormat format) {
            return (Builder)super.format(format);
        }

        @Override
        public Builder color(TextColor color) {
            return (Builder)super.color(color);
        }

        @Override
        public Builder style(TextStyle ... styles) {
            return (Builder)super.style(styles);
        }

        @Override
        public Builder onClick(@Nullable ClickAction<?> clickAction) {
            return (Builder)super.onClick(clickAction);
        }

        @Override
        public Builder onHover(@Nullable HoverAction<?> hoverAction) {
            return (Builder)super.onHover(hoverAction);
        }

        @Override
        public Builder onShiftClick(@Nullable ShiftClickAction<?> shiftClickAction) {
            return (Builder)super.onShiftClick(shiftClickAction);
        }

        @Override
        public Builder append(Text ... children) {
            return (Builder)super.append(children);
        }

        @Override
        public Builder append(Collection<? extends Text> children) {
            return (Builder)super.append(children);
        }

        @Override
        public Builder append(Iterable<? extends Text> children) {
            return (Builder)super.append(children);
        }

        @Override
        public Builder append(Iterator<? extends Text> children) {
            return (Builder)super.append(children);
        }

        @Override
        public Builder insert(int pos, Text ... children) {
            return (Builder)super.insert(pos, children);
        }

        @Override
        public Builder insert(int pos, Collection<? extends Text> children) {
            return (Builder)super.insert(pos, children);
        }

        @Override
        public Builder insert(int pos, Iterable<? extends Text> children) {
            return (Builder)super.insert(pos, children);
        }

        @Override
        public Builder insert(int pos, Iterator<? extends Text> children) {
            return (Builder)super.insert(pos, children);
        }

        @Override
        public Builder remove(Text ... children) {
            return (Builder)super.remove(children);
        }

        @Override
        public Builder remove(Collection<? extends Text> children) {
            return (Builder)super.remove(children);
        }

        @Override
        public Builder remove(Iterable<? extends Text> children) {
            return (Builder)super.remove(children);
        }

        @Override
        public Builder remove(Iterator<? extends Text> children) {
            return (Builder)super.remove(children);
        }

        @Override
        public Builder removeAll() {
            return (Builder)super.removeAll();
        }
    }
}

