/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.ForOverride;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.ChannelLogger;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.HttpConnectProxiedSocketAddress;
import io.grpc.InternalChannelz;
import io.grpc.InternalInstrumented;
import io.grpc.InternalLogId;
import io.grpc.InternalWithLogId;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.CallTracer;
import io.grpc.internal.ChannelLoggerImpl;
import io.grpc.internal.ChannelTracer;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.ForwardingClientStream;
import io.grpc.internal.ForwardingClientStreamListener;
import io.grpc.internal.ForwardingConnectionClientTransport;
import io.grpc.internal.InUseStateAggregator;
import io.grpc.internal.LogExceptionRunnable;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.TimeProvider;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class InternalSubchannel
implements InternalInstrumented<InternalChannelz.ChannelStats> {
    private static final Logger log = Logger.getLogger(InternalSubchannel.class.getName());
    private final InternalLogId logId;
    private final String authority;
    private final String userAgent;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Callback callback;
    private final ClientTransportFactory transportFactory;
    private final ScheduledExecutorService scheduledExecutor;
    private final InternalChannelz channelz;
    private final CallTracer callsTracer;
    private final ChannelTracer channelTracer;
    private final ChannelLoggerImpl channelLogger;
    private final Object lock = new Object();
    private final SynchronizationContext syncContext;
    @GuardedBy(value="lock")
    private Index addressIndex;
    @GuardedBy(value="lock")
    private BackoffPolicy reconnectPolicy;
    @GuardedBy(value="lock")
    private final Stopwatch connectingTimer;
    @Nullable
    @GuardedBy(value="lock")
    private ScheduledFuture<?> reconnectTask;
    @GuardedBy(value="lock")
    private boolean reconnectCanceled;
    @GuardedBy(value="lock")
    private final Collection<ConnectionClientTransport> transports = new ArrayList<ConnectionClientTransport>();
    private final InUseStateAggregator<ConnectionClientTransport> inUseStateAggregator = new InUseStateAggregator<ConnectionClientTransport>(){

        @Override
        protected void handleInUse() {
            InternalSubchannel.this.callback.onInUse(InternalSubchannel.this);
        }

        @Override
        protected void handleNotInUse() {
            InternalSubchannel.this.callback.onNotInUse(InternalSubchannel.this);
        }
    };
    @Nullable
    @GuardedBy(value="lock")
    private ConnectionClientTransport pendingTransport;
    @Nullable
    private volatile ManagedClientTransport activeTransport;
    @GuardedBy(value="lock")
    private ConnectivityStateInfo state = ConnectivityStateInfo.forNonError(ConnectivityState.IDLE);
    @GuardedBy(value="lock")
    private Status shutdownReason;

    InternalSubchannel(List<EquivalentAddressGroup> addressGroups, String authority, String userAgent, BackoffPolicy.Provider backoffPolicyProvider, ClientTransportFactory transportFactory, ScheduledExecutorService scheduledExecutor, Supplier<Stopwatch> stopwatchSupplier, SynchronizationContext syncContext, Callback callback, InternalChannelz channelz, CallTracer callsTracer, ChannelTracer channelTracer, InternalLogId logId, TimeProvider timeProvider) {
        Preconditions.checkNotNull(addressGroups, "addressGroups");
        Preconditions.checkArgument(!addressGroups.isEmpty(), "addressGroups is empty");
        InternalSubchannel.checkListHasNoNulls(addressGroups, "addressGroups contains null entry");
        this.addressIndex = new Index(Collections.unmodifiableList(new ArrayList<EquivalentAddressGroup>(addressGroups)));
        this.authority = authority;
        this.userAgent = userAgent;
        this.backoffPolicyProvider = backoffPolicyProvider;
        this.transportFactory = transportFactory;
        this.scheduledExecutor = scheduledExecutor;
        this.connectingTimer = stopwatchSupplier.get();
        this.syncContext = syncContext;
        this.callback = callback;
        this.channelz = channelz;
        this.callsTracer = callsTracer;
        this.channelTracer = Preconditions.checkNotNull(channelTracer, "channelTracer");
        this.logId = InternalLogId.allocate("Subchannel", authority);
        this.channelLogger = new ChannelLoggerImpl(channelTracer, timeProvider);
    }

    ChannelLogger getChannelLogger() {
        return this.channelLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ClientTransport obtainActiveTransport() {
        ManagedClientTransport savedTransport = this.activeTransport;
        if (savedTransport != null) {
            return savedTransport;
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                block10: {
                    savedTransport = this.activeTransport;
                    if (savedTransport == null) break block10;
                    ManagedClientTransport managedClientTransport = savedTransport;
                    return managedClientTransport;
                }
                if (this.state.getState() == ConnectivityState.IDLE) {
                    this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "CONNECTING as requested");
                    this.gotoNonErrorState(ConnectivityState.CONNECTING);
                    this.startNewTransport();
                }
            }
        }
        finally {
            this.syncContext.drain();
        }
        return null;
    }

    @Nullable
    ClientTransport getTransport() {
        return this.activeTransport;
    }

    String getAuthority() {
        return this.authority;
    }

    @GuardedBy(value="lock")
    private void startNewTransport() {
        Preconditions.checkState(this.reconnectTask == null, "Should have no reconnectTask scheduled");
        if (this.addressIndex.isAtBeginning()) {
            this.connectingTimer.reset().start();
        }
        SocketAddress address = this.addressIndex.getCurrentAddress();
        HttpConnectProxiedSocketAddress proxiedAddr = null;
        if (address instanceof HttpConnectProxiedSocketAddress) {
            proxiedAddr = (HttpConnectProxiedSocketAddress)address;
            address = proxiedAddr.getTargetAddress();
        }
        ClientTransportFactory.ClientTransportOptions options = new ClientTransportFactory.ClientTransportOptions().setAuthority(this.authority).setEagAttributes(this.addressIndex.getCurrentEagAttributes()).setUserAgent(this.userAgent).setHttpConnectProxiedSocketAddress(proxiedAddr);
        TransportLogger transportLogger = new TransportLogger();
        transportLogger.logId = this.getLogId();
        CallTracingTransport transport = new CallTracingTransport(this.transportFactory.newClientTransport(address, options, transportLogger), this.callsTracer);
        transportLogger.logId = transport.getLogId();
        this.channelz.addClientSocket(transport);
        this.pendingTransport = transport;
        this.transports.add(transport);
        Runnable runnable = transport.start(new TransportListener(transport, address));
        if (runnable != null) {
            this.syncContext.executeLater(runnable);
        }
        this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Started transport {0}", transportLogger.logId);
    }

    @GuardedBy(value="lock")
    private void scheduleBackoff(Status status) {
        this.gotoState(ConnectivityStateInfo.forTransientFailure(status));
        if (this.reconnectPolicy == null) {
            this.reconnectPolicy = this.backoffPolicyProvider.get();
        }
        long delayNanos = this.reconnectPolicy.nextBackoffNanos() - this.connectingTimer.elapsed(TimeUnit.NANOSECONDS);
        this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "TRANSIENT_FAILURE ({0}). Will reconnect after {1} ns", this.printShortStatus(status), delayNanos);
        Preconditions.checkState(this.reconnectTask == null, "previous reconnectTask is not done");
        this.reconnectCanceled = false;
        class EndOfCurrentBackoff
        implements Runnable {
            EndOfCurrentBackoff() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = InternalSubchannel.this.lock;
                    synchronized (object) {
                        block10: {
                            InternalSubchannel.this.reconnectTask = null;
                            if (!InternalSubchannel.this.reconnectCanceled) break block10;
                            return;
                        }
                        InternalSubchannel.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "CONNECTING after backoff");
                        InternalSubchannel.this.gotoNonErrorState(ConnectivityState.CONNECTING);
                        InternalSubchannel.this.startNewTransport();
                    }
                }
                catch (Throwable t) {
                    log.log(Level.WARNING, "Exception handling end of backoff", t);
                }
                finally {
                    InternalSubchannel.this.syncContext.drain();
                }
            }
        }
        this.reconnectTask = this.scheduledExecutor.schedule(new LogExceptionRunnable(new EndOfCurrentBackoff()), delayNanos, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetConnectBackoff() {
        try {
            Object object = this.lock;
            synchronized (object) {
                block8: {
                    if (this.state.getState() == ConnectivityState.TRANSIENT_FAILURE) break block8;
                    return;
                }
                this.cancelReconnectTask();
                this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "CONNECTING; backoff interrupted");
                this.gotoNonErrorState(ConnectivityState.CONNECTING);
                this.startNewTransport();
            }
        }
        finally {
            this.syncContext.drain();
        }
    }

    @GuardedBy(value="lock")
    private void gotoNonErrorState(ConnectivityState newState) {
        this.gotoState(ConnectivityStateInfo.forNonError(newState));
    }

    @GuardedBy(value="lock")
    private void gotoState(final ConnectivityStateInfo newState) {
        if (this.state.getState() != newState.getState()) {
            Preconditions.checkState(this.state.getState() != ConnectivityState.SHUTDOWN, "Cannot transition out of SHUTDOWN to " + newState);
            this.state = newState;
            this.syncContext.executeLater(new Runnable(){

                @Override
                public void run() {
                    InternalSubchannel.this.callback.onStateChange(InternalSubchannel.this, newState);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAddresses(List<EquivalentAddressGroup> newAddressGroups) {
        Preconditions.checkNotNull(newAddressGroups, "newAddressGroups");
        InternalSubchannel.checkListHasNoNulls(newAddressGroups, "newAddressGroups contains null entry");
        Preconditions.checkArgument(!newAddressGroups.isEmpty(), "newAddressGroups is empty");
        newAddressGroups = Collections.unmodifiableList(new ArrayList<EquivalentAddressGroup>(newAddressGroups));
        ManagedClientTransport savedTransport = null;
        try {
            Object object = this.lock;
            synchronized (object) {
                SocketAddress previousAddress = this.addressIndex.getCurrentAddress();
                this.addressIndex.updateGroups(newAddressGroups);
                if (!(this.state.getState() != ConnectivityState.READY && this.state.getState() != ConnectivityState.CONNECTING || this.addressIndex.seekTo(previousAddress))) {
                    if (this.state.getState() == ConnectivityState.READY) {
                        savedTransport = this.activeTransport;
                        this.activeTransport = null;
                        this.addressIndex.reset();
                        this.gotoNonErrorState(ConnectivityState.IDLE);
                    } else {
                        savedTransport = this.pendingTransport;
                        this.pendingTransport = null;
                        this.addressIndex.reset();
                        this.startNewTransport();
                    }
                }
            }
        }
        finally {
            this.syncContext.drain();
        }
        if (savedTransport != null) {
            savedTransport.shutdown(Status.UNAVAILABLE.withDescription("InternalSubchannel closed transport due to address change"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(Status reason) {
        ConnectionClientTransport savedPendingTransport;
        ManagedClientTransport savedActiveTransport;
        try {
            Object object = this.lock;
            synchronized (object) {
                block11: {
                    if (this.state.getState() != ConnectivityState.SHUTDOWN) break block11;
                    return;
                }
                this.shutdownReason = reason;
                this.gotoNonErrorState(ConnectivityState.SHUTDOWN);
                savedActiveTransport = this.activeTransport;
                savedPendingTransport = this.pendingTransport;
                this.activeTransport = null;
                this.pendingTransport = null;
                this.addressIndex.reset();
                if (this.transports.isEmpty()) {
                    this.handleTermination();
                }
                this.cancelReconnectTask();
            }
        }
        finally {
            this.syncContext.drain();
        }
        if (savedActiveTransport != null) {
            savedActiveTransport.shutdown(reason);
        }
        if (savedPendingTransport != null) {
            savedPendingTransport.shutdown(reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        List<EquivalentAddressGroup> addressGroupsCopy;
        Object object = this.lock;
        synchronized (object) {
            addressGroupsCopy = this.addressIndex.getGroups();
        }
        return MoreObjects.toStringHelper(this).add("logId", this.logId.getId()).add("addressGroups", addressGroupsCopy).toString();
    }

    @GuardedBy(value="lock")
    private void handleTermination() {
        this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Terminated");
        this.syncContext.executeLater(new Runnable(){

            @Override
            public void run() {
                InternalSubchannel.this.callback.onTerminated(InternalSubchannel.this);
            }
        });
    }

    private void handleTransportInUseState(final ConnectionClientTransport transport, final boolean inUse) {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                InternalSubchannel.this.inUseStateAggregator.updateObjectInUse(transport, inUse);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownNow(Status reason) {
        ArrayList<ConnectionClientTransport> transportsCopy;
        this.shutdown(reason);
        try {
            Iterator iterator = this.lock;
            synchronized (iterator) {
                transportsCopy = new ArrayList<ConnectionClientTransport>(this.transports);
            }
        }
        finally {
            this.syncContext.drain();
        }
        for (ManagedClientTransport managedClientTransport : transportsCopy) {
            managedClientTransport.shutdownNow(reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<EquivalentAddressGroup> getAddressGroups() {
        try {
            Object object = this.lock;
            synchronized (object) {
                List<EquivalentAddressGroup> list = this.addressIndex.getGroups();
                return list;
            }
        }
        finally {
            this.syncContext.drain();
        }
    }

    @GuardedBy(value="lock")
    private void cancelReconnectTask() {
        if (this.reconnectTask != null) {
            this.reconnectTask.cancel(false);
            this.reconnectCanceled = true;
            this.reconnectTask = null;
            this.reconnectPolicy = null;
        }
    }

    @Override
    public InternalLogId getLogId() {
        return this.logId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<InternalChannelz.ChannelStats> getStats() {
        ArrayList<InternalWithLogId> transportsSnapshot;
        List<EquivalentAddressGroup> addressGroupsSnapshot;
        SettableFuture<InternalChannelz.ChannelStats> ret = SettableFuture.create();
        InternalChannelz.ChannelStats.Builder builder = new InternalChannelz.ChannelStats.Builder();
        Object object = this.lock;
        synchronized (object) {
            addressGroupsSnapshot = this.addressIndex.getGroups();
            transportsSnapshot = new ArrayList<InternalWithLogId>(this.transports);
        }
        builder.setTarget(addressGroupsSnapshot.toString()).setState(this.getState());
        builder.setSockets(transportsSnapshot);
        this.callsTracer.updateBuilder(builder);
        this.channelTracer.updateBuilder(builder);
        ret.set(builder.build());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    ConnectivityState getState() {
        try {
            Object object = this.lock;
            synchronized (object) {
                ConnectivityState connectivityState = this.state.getState();
                return connectivityState;
            }
        }
        finally {
            this.syncContext.drain();
        }
    }

    private static void checkListHasNoNulls(List<?> list, String msg) {
        for (Object item : list) {
            Preconditions.checkNotNull(item, msg);
        }
    }

    private String printShortStatus(Status status) {
        StringBuilder buffer = new StringBuilder();
        buffer.append((Object)status.getCode());
        if (status.getDescription() != null) {
            buffer.append("(").append(status.getDescription()).append(")");
        }
        return buffer.toString();
    }

    @VisibleForTesting
    static final class TransportLogger
    extends ChannelLogger {
        InternalLogId logId;

        TransportLogger() {
        }

        @Override
        public void log(ChannelLogger.ChannelLogLevel level, String message) {
            ChannelLoggerImpl.logOnly(this.logId, level, message);
        }

        @Override
        public void log(ChannelLogger.ChannelLogLevel level, String messageFormat, Object ... args) {
            ChannelLoggerImpl.logOnly(this.logId, level, messageFormat, args);
        }
    }

    @VisibleForTesting
    static final class Index {
        private List<EquivalentAddressGroup> addressGroups;
        private int groupIndex;
        private int addressIndex;

        public Index(List<EquivalentAddressGroup> groups) {
            this.addressGroups = groups;
        }

        public boolean isValid() {
            return this.groupIndex < this.addressGroups.size();
        }

        public boolean isAtBeginning() {
            return this.groupIndex == 0 && this.addressIndex == 0;
        }

        public void increment() {
            EquivalentAddressGroup group = this.addressGroups.get(this.groupIndex);
            ++this.addressIndex;
            if (this.addressIndex >= group.getAddresses().size()) {
                ++this.groupIndex;
                this.addressIndex = 0;
            }
        }

        public void reset() {
            this.groupIndex = 0;
            this.addressIndex = 0;
        }

        public SocketAddress getCurrentAddress() {
            return this.addressGroups.get(this.groupIndex).getAddresses().get(this.addressIndex);
        }

        public Attributes getCurrentEagAttributes() {
            return this.addressGroups.get(this.groupIndex).getAttributes();
        }

        public List<EquivalentAddressGroup> getGroups() {
            return this.addressGroups;
        }

        public void updateGroups(List<EquivalentAddressGroup> newGroups) {
            this.addressGroups = newGroups;
            this.reset();
        }

        public boolean seekTo(SocketAddress needle) {
            for (int i = 0; i < this.addressGroups.size(); ++i) {
                EquivalentAddressGroup group = this.addressGroups.get(i);
                int j = group.getAddresses().indexOf(needle);
                if (j == -1) continue;
                this.groupIndex = i;
                this.addressIndex = j;
                return true;
            }
            return false;
        }
    }

    @VisibleForTesting
    static final class CallTracingTransport
    extends ForwardingConnectionClientTransport {
        private final ConnectionClientTransport delegate;
        private final CallTracer callTracer;

        private CallTracingTransport(ConnectionClientTransport delegate, CallTracer callTracer) {
            this.delegate = delegate;
            this.callTracer = callTracer;
        }

        @Override
        protected ConnectionClientTransport delegate() {
            return this.delegate;
        }

        @Override
        public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions) {
            final ClientStream streamDelegate = super.newStream(method, headers, callOptions);
            return new ForwardingClientStream(){

                @Override
                protected ClientStream delegate() {
                    return streamDelegate;
                }

                @Override
                public void start(final ClientStreamListener listener) {
                    CallTracingTransport.this.callTracer.reportCallStarted();
                    super.start(new ForwardingClientStreamListener(){

                        @Override
                        protected ClientStreamListener delegate() {
                            return listener;
                        }

                        @Override
                        public void closed(Status status, Metadata trailers) {
                            CallTracingTransport.this.callTracer.reportCallEnded(status.isOk());
                            super.closed(status, trailers);
                        }

                        @Override
                        public void closed(Status status, ClientStreamListener.RpcProgress rpcProgress, Metadata trailers) {
                            CallTracingTransport.this.callTracer.reportCallEnded(status.isOk());
                            super.closed(status, rpcProgress, trailers);
                        }
                    });
                }
            };
        }
    }

    static abstract class Callback {
        Callback() {
        }

        @ForOverride
        void onTerminated(InternalSubchannel is) {
        }

        @ForOverride
        void onStateChange(InternalSubchannel is, ConnectivityStateInfo newState) {
        }

        @ForOverride
        void onInUse(InternalSubchannel is) {
        }

        @ForOverride
        void onNotInUse(InternalSubchannel is) {
        }
    }

    private class TransportListener
    implements ManagedClientTransport.Listener {
        final ConnectionClientTransport transport;
        final SocketAddress address;

        TransportListener(ConnectionClientTransport transport, SocketAddress address) {
            this.transport = transport;
            this.address = address;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportReady() {
            Status savedShutdownReason;
            InternalSubchannel.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "READY");
            try {
                Object object = InternalSubchannel.this.lock;
                synchronized (object) {
                    savedShutdownReason = InternalSubchannel.this.shutdownReason;
                    InternalSubchannel.this.reconnectPolicy = null;
                    if (savedShutdownReason != null) {
                        Preconditions.checkState(InternalSubchannel.this.activeTransport == null, "Unexpected non-null activeTransport");
                    } else if (InternalSubchannel.this.pendingTransport == this.transport) {
                        InternalSubchannel.this.gotoNonErrorState(ConnectivityState.READY);
                        InternalSubchannel.this.activeTransport = this.transport;
                        InternalSubchannel.this.pendingTransport = null;
                    }
                }
            }
            finally {
                InternalSubchannel.this.syncContext.drain();
            }
            if (savedShutdownReason != null) {
                this.transport.shutdown(savedShutdownReason);
            }
        }

        @Override
        public void transportInUse(boolean inUse) {
            InternalSubchannel.this.handleTransportInUseState(this.transport, inUse);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportShutdown(Status s) {
            InternalSubchannel.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "{0} SHUTDOWN with {1}", this.transport.getLogId(), InternalSubchannel.this.printShortStatus(s));
            try {
                Object object = InternalSubchannel.this.lock;
                synchronized (object) {
                    block13: {
                        if (InternalSubchannel.this.state.getState() != ConnectivityState.SHUTDOWN) break block13;
                        return;
                    }
                    if (InternalSubchannel.this.activeTransport == this.transport) {
                        InternalSubchannel.this.gotoNonErrorState(ConnectivityState.IDLE);
                        InternalSubchannel.this.activeTransport = null;
                        InternalSubchannel.this.addressIndex.reset();
                    } else if (InternalSubchannel.this.pendingTransport == this.transport) {
                        Preconditions.checkState(InternalSubchannel.this.state.getState() == ConnectivityState.CONNECTING, "Expected state is CONNECTING, actual state is %s", (Object)InternalSubchannel.this.state.getState());
                        InternalSubchannel.this.addressIndex.increment();
                        if (!InternalSubchannel.this.addressIndex.isValid()) {
                            InternalSubchannel.this.pendingTransport = null;
                            InternalSubchannel.this.addressIndex.reset();
                            InternalSubchannel.this.scheduleBackoff(s);
                        } else {
                            InternalSubchannel.this.startNewTransport();
                        }
                    }
                }
            }
            finally {
                InternalSubchannel.this.syncContext.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportTerminated() {
            InternalSubchannel.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "{0} Terminated", this.transport.getLogId());
            InternalSubchannel.this.channelz.removeClientSocket(this.transport);
            InternalSubchannel.this.handleTransportInUseState(this.transport, false);
            try {
                Object object = InternalSubchannel.this.lock;
                synchronized (object) {
                    InternalSubchannel.this.transports.remove(this.transport);
                    if (InternalSubchannel.this.state.getState() == ConnectivityState.SHUTDOWN && InternalSubchannel.this.transports.isEmpty()) {
                        InternalSubchannel.this.handleTermination();
                    }
                }
            }
            finally {
                InternalSubchannel.this.syncContext.drain();
            }
            Preconditions.checkState(InternalSubchannel.this.activeTransport != this.transport, "activeTransport still points to this transport. Seems transportShutdown() was not called.");
        }
    }
}

