/*
 * Decompiled with CFR 0.152.
 */
package dk.itu.real.ooe.services;

import com.google.protobuf.Empty;
import dk.itu.real.ooe.Minecraft;
import dk.itu.real.ooe.MinecraftServiceGrpc;
import io.grpc.stub.StreamObserver;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.block.DirectionalData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class MinecraftService
extends MinecraftServiceGrpc.MinecraftServiceImplBase {
    private final PluginContainer plugin;
    private final Map<String, String> blockNamesToBlockTypes = new HashMap<String, String>();

    public MinecraftService(PluginContainer plugin) throws IllegalAccessException {
        this.plugin = plugin;
        for (Field field : BlockTypes.class.getFields()) {
            BlockType blockType = (BlockType)field.get(null);
            String key = blockType.getName();
            String value = field.getName();
            this.blockNamesToBlockTypes.put(key, value);
        }
    }

    @Override
    public void spawnBlocks(Minecraft.Blocks request, StreamObserver<Empty> responseObserver) {
        Task.builder().execute(() -> {
            World world = (World)Sponge.getServer().getWorlds().iterator().next();
            for (Minecraft.Block block : request.getBlocksList()) {
                try {
                    BlockType blockType = (BlockType)BlockTypes.class.getField(block.getType().toString()).get(null);
                    Minecraft.Point pos = block.getPosition();
                    Minecraft.Orientation orientation = block.getOrientation();
                    world.setBlockType(pos.getX(), pos.getY(), pos.getZ(), blockType);
                    if (!blockType.getDefaultState().supports(Keys.DIRECTION)) continue;
                    this.setOrientation((Location<World>)world.getLocation(pos.getX(), pos.getY(), pos.getZ()), orientation, blockType);
                }
                catch (IllegalAccessException | IllegalArgumentException | IllegalStateException | NoSuchFieldException | SecurityException e) {
                    this.plugin.getLogger().info(e.getMessage());
                }
            }
            responseObserver.onNext(Empty.getDefaultInstance());
            responseObserver.onCompleted();
        }).name("spawnBlocks").submit((Object)this.plugin);
    }

    @Override
    public void readCube(Minecraft.Cube cube, StreamObserver<Minecraft.Blocks> responseObserver) {
        Task.builder().execute(() -> {
            Minecraft.Blocks.Builder builder = Minecraft.Blocks.newBuilder();
            World world = (World)Sponge.getServer().getWorlds().iterator().next();
            Minecraft.Point min = cube.getMin();
            Minecraft.Point max = cube.getMax();
            for (int x = min.getX(); x <= max.getX(); ++x) {
                for (int y = min.getY(); y <= max.getY(); ++y) {
                    for (int z = min.getZ(); z <= max.getZ(); ++z) {
                        String name = world.getLocation(x, y, z).getBlock().getType().getName();
                        builder.addBlocks(Minecraft.Block.newBuilder().setPosition(Minecraft.Point.newBuilder().setX(x).setY(y).setZ(z).build()).setType(Minecraft.BlockType.valueOf(this.blockNamesToBlockTypes.get(name))).build());
                    }
                }
            }
            responseObserver.onNext(builder.build());
            responseObserver.onCompleted();
        }).name("readCube").submit((Object)this.plugin);
    }

    @Override
    public void fillCube(Minecraft.FillCubeRequest request, StreamObserver<Empty> responseObserver) {
        Task.builder().execute(() -> {
            BlockType type;
            World world = (World)Sponge.getServer().getWorlds().iterator().next();
            Minecraft.Cube c = request.getCube();
            Minecraft.Point min = c.getMin();
            Minecraft.Point max = c.getMax();
            try {
                Field typeField = BlockTypes.class.getField(request.getType().toString());
                type = (BlockType)typeField.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            for (int x = min.getX(); x <= max.getX(); ++x) {
                for (int y = min.getY(); y <= max.getY(); ++y) {
                    for (int z = min.getZ(); z <= max.getZ(); ++z) {
                        world.setBlockType(x, y, z, type);
                    }
                }
            }
            responseObserver.onNext(Empty.getDefaultInstance());
            responseObserver.onCompleted();
        }).name("fillCube").submit((Object)this.plugin);
    }

    public void setOrientation(Location<World> blockLoc, Minecraft.Orientation orientation, BlockType btype) throws IllegalStateException {
        Optional optionalData = blockLoc.get(DirectionalData.class);
        if (!optionalData.isPresent()) {
            throw new IllegalStateException("Failed to get block location data");
        }
        DirectionalData data = (DirectionalData)optionalData.get();
        data.set(Keys.DIRECTION, (Object)Direction.valueOf((String)orientation.toString()));
        BlockState state = btype.getDefaultState();
        Optional newState = state.with((ValueContainer)data.asImmutable());
        if (!newState.isPresent()) {
            throw new IllegalStateException("block type " + btype.toString() + " failed to set orientation!");
        }
        blockLoc.setBlock((BlockState)newState.get());
    }
}

