"""
Constants

:date: Mar 11, 2021
:author: Aldo Diaz, Marcelo Sureda

Constants file.
"""

from enum import Enum

FRAMEWORK_NAME = 'vcd_extension'
LOG_DIR = './logs'
PYVCLOUD_LOG_FILE = 'pyvcloud.log'
DEFAULT_LOG_LEVEL = 'INFO'
ENV_VAR_CONFIG_FILE = 'VCD_EXTENSIONS_CONFIG_FILE'
DEFAULT_CONFIG_FILE = './extensions_config.yml'
DEFAULT_DB_FILE = './db/vcdextensions.db'


class RightName(Enum):
    CATALOG_PUBLISH = 'Catalog: Publish'
    CATALOG_SHARING = 'Catalog: Sharing'
    CATALOG_CHANGE_OWNER = 'Catalog: Change Owner'
    CATALOG_CLSP_PUBLISH_SUBSCRIBE = 'Catalog: CLSP Publish Subscribe'
    CATALOG_ADD_VAPP = 'Catalog: Add vApp from My Cloud'
    CATALOG_VIEW_PRIVATE_AND_SHARED = 'Catalog: View Private and Shared Catalogs'
    CATALOG_EDIT_PROPERTIES = 'Catalog: Edit Properties'
    CATALOG_VIEW_PUBLISHED_CATALOGS = 'Catalog: View Published Catalogs'
    CATALOG_CREATE_DELETE = 'Catalog: Create / Delete a Catalog'
    VAPP_TEMPLATE_MEDIA_COPY = 'vApp Template / Media: Copy'
    VAPP_TEMPLATE_MEDIA_EDIT = 'vApp Template / Media: Edit'
    VAPP_TEMPLATE_CHECKOUT = 'vApp Template: Checkout'
    VAPP_TEMPLATE_MEDIA_VIEW = 'vApp Template / Media: View'
    VAPP_TEMPLATE_MEDIA_CREATE_UPLOAD = 'vApp Template / Media: Create / Upload'
    VAPP_TEMPLATE_DOWNLOAD = 'vApp Template: Download'
    CUSTOM_ENTITY_VIEW_ALL_CUSTOM_ENTITY_INSTANCES_IN_ORG = 'Custom entity: View all custom entity instances in org'
    CUSTOM_ENTITY_VIEW_CUSTOM_ENTITY_INSTANCE = 'Custom entity: View custom entity instance'
    DISK_VIEW_PROPERTIES = 'Disk: View Properties'
    DISK_CHANGE_OWNER = 'Disk: Change Owner'
    DISK_CREATE = 'Disk: Create'
    DISK_EDIT_PROPERTIES = 'Disk: Edit Properties'
    DISK_DELETE = 'Disk: Delete'
    ORGANIZATION_VDC_DISTRIBUTED_FIREWALL_VIEW_RULES = 'Organization vDC Distributed Firewall: View Rules'
    ORGANIZATION_VDC_DISTRIBUTED_FIREWALL_CONFIGURE_RULES = 'Organization vDC Distributed Firewall: Configure Rules'
    ORGANIZATION_VDC_GATEWAY_CONVERT_ADVANCED_NETWORKING = 'Organization vDC Gateway: Convert to Advanced Networking'
    ORGANIZATION_VDC_GATEWAY_VIEW = 'Organization vDC Gateway: View'
    ORGANIZATION_VDC_GATEWAY_CONFIGURE_SYSLOG = 'Organization vDC Gateway: Configure Syslog'
    ORGANIZATION_VDC_GATEWAY_CONFIGURE_FIREWALL = 'Organization vDC Gateway: Configure Firewall'
    ORGANIZATION_VDC_GATEWAY_CONFIGURE_NAT = 'Organization vDC Gateway: Configure NAT'
    ORGANIZATION_VDC_GATEWAY_CONFIGURE_LOAD_BALANCER = 'Organization vDC Gateway: Configure Load Balancer'
    ORGANIZATION_VDC_GATEWAY_CONFIGURE_IPSEC_VPN = 'Organization vDC Gateway: Configure IPSec VPN'
    ORGANIZATION_VDC_GATEWAY_CONFIGURE_DHCP = 'Organization vDC Gateway: Configure DHCP'
    ORGANIZATION_VDC_GATEWAY_CONFIGURE_STATIC_ROUTING = 'Organization vDC Gateway: Configure Static Routing'
    GENERAL_SEND_NOTIFICATION = 'General: Send Notification'
    GENERAL_ADMINISTRATOR_CONTROL = 'General: Administrator Control'
    GENERAL_ADMINISTRATOR_VIEW = 'General: Administrator View'
    HYBRID_CLOUD_OPERATIONS_VIEW_TO_THE_CLOUD_TUNNEL = 'Hybrid Cloud Operations: View to-the-cloud tunnel'
    HYBRID_CLOUD_OPERATIONS_ACQUIRE_CONTROL_TICKET = 'Hybrid Cloud Operations: Acquire control ticket'
    HYBRID_CLOUD_OPERATIONS_DELETE_FROM_THE_CLOUD_TUNNEL = 'Hybrid Cloud Operations: Delete from-the-cloud tunnel'
    HYBRID_CLOUD_OPERATIONS_ACQUIRE_FROM_THE_CLOUD_TUNNEL_TICKET =\
        'Hybrid Cloud Operations: Acquire from-the-cloud tunnel ticket'
    HYBRID_CLOUD_OPERATIONS_ACQUIRE_TO_THE_CLOUD_TUNNEL_TICKET =\
        'Hybrid Cloud Operations: Acquire to-the-cloud tunnel ticket'
    HYBRID_CLOUD_OPERATIONS_CREATE_TO_THE_CLOUD_TUNNEL =\
        'Hybrid Cloud Operations: Create to-the-cloud tunnel'
    HYBRID_CLOUD_OPERATIONS_CREATE_FROM_THE_CLOUD_TUNNEL =\
        'Hybrid Cloud Operations: Create from-the-cloud tunnel'
    HYBRID_CLOUD_OPERATIONS_DELETE_TO_THE_CLOUD_TUNNEL =\
        'Hybrid Cloud Operations: Delete to-the-cloud tunnel'
    HYBRID_CLOUD_OPERATIONS_VIEW_FROM_THE_CLOUD_TUNNEL =\
        'Hybrid Cloud Operations: View from-the-cloud tunnel'
    HYBRID_CLOUD_OPERATIONS_UPDATE_FROM_THE_CLOUD_TUNNEL_ENDPOINT_TAG =\
        'Hybrid Cloud Operations: Update from-the-cloud tunnel endpoint tag'
    ORGANIZATION_VDC_NETWORK_EDIT_PROPERTIES = 'Organization vDC Network: Edit Properties'
    ORGANIZATION_VDC_NETWORK_VIEW_PROPERTIES = 'Organization vDC Network: View Properties'
    ORGANIZATION_VIEW = 'Organization: View'
    ORGANIZATION_EDIT_QUOTAS_POLICY = 'Organization: Edit Quotas Policy'
    ORGANIZATION_EDIT_LEASES_POLICY = 'Organization: Edit Leases Policy'
    ORGANIZATION_EDIT_PROPERTIES = 'Organization: Edit Properties'
    ACCESS_ALL_ORGANIZATION_VDCS = 'Access All Organization VDCs'
    ORGANIZATION_VDC_VIEW_ACL = 'Organization vDC: View ACL'
    ORGANIZATION_NETWORK_VIEW = 'Organization Network: View'
    ORGANIZATION_NETWORK_EDIT_PROPERTIES = 'Organization Network: Edit Properties'
    ORGANIZATION_EDIT_FEDERATION_SETTINGS = 'Organization: Edit Federation Settings'
    ORGANIZATION_IMPORT_USER_GROUP_FROM_IDP_WHILE_EDITING_VDC_ACL =\
        'Organization: Import User/Group from IdP while Editing VDC ACL'
    ORGANIZATION_EDIT_ASSOCIATION_SETTINGS = 'Organization: Edit Association Settings'
    ORGANIZATION_VDC_EDIT_ACL = 'Organization vDC: Edit ACL'
    CATALOG_VIEW_ACL = 'Catalog: View ACL'
    ORGANIZATION_EDIT_PASSWORD_POLICY = 'Organization: Edit Password Policy'
    VAPP_VIEW_ACL = 'vApp: View ACL'
    ORGANIZATION_EDIT_SMTP_SETTINGS = 'Organization: Edit SMTP Settings'
    ORGANIZATION_VDC_VIEW = 'Organization vDC: View'
    ORGANIZATION_VDC_VM_VM_AFFINITY_EDIT = 'Organization vDC: VM-VM Affinity Edit'
    ORGANIZATION_VDC_STORAGE_PROFILE_SET_DEFAULT = 'Organization vDC Storage Profile: Set Default'
    ORGANIZATION_VDC_EDIT = 'Organization vDC: Edit'
    ORGANIZATION_VDC_MANAGE_FIREWALL = 'Organization vDC: Manage Firewall'
    ORGANIZATION_VDC_COMPUTE_POLICY_VIEW = 'Organization vDC Compute Policy: View'
    ROLE_CREATE_EDIT_DELETE_OR_COPY = 'Role: Create, Edit, Delete, or Copy'
    SERVICE_LIBRARY_VIEW_SERVICE_LIBRARIES = 'Service Library: View service libraries'
    GROUP_USER_VIEW = 'Group / User: View'
    UI_PLUGINS_VIEW = 'UI Plugins: View'
    VDC_TEMPLATE_VIEW = 'VDC Template: View'
    VDC_TEMPLATE_INSTANTIATE = 'VDC Template: Instantiate'
    ORGANIZATION_VIEW_METRICS = 'Organization: view metrics'
    ORGANIZATION_VDC_VIEW_METRICS = 'Organization VDC: view metrics'
    VAPP_UPLOAD = 'vApp: Upload'
    VAPP_EDIT_PROPERTIES = 'vApp: Edit Properties'
    VAPP_MANAGE_VM_PASSWORD_SETTINGS = 'vApp: Manage VM Password Settings'
    VAPP_VM_METADATA_TO_VCENTER = 'VAPP_VM_METADATA_TO_VCENTER'
    VAPP_VM_BOOT_OPTIONS = 'vApp: VM Boot Options'
    VAPP_CREATE_RECONFIGURE = 'vApp: Create / Reconfigure'
    VAPP_EDIT_VM_HARD_DISK = 'vApp: Edit VM Hard Disk'
    VAPP_POWER_OPERATIONS = 'vApp: Power Operations'
    VAPP_TEMPLATE_CHANGE_OWNER = 'vApp Template: Change Owner'
    VAPP_DOWNLOAD = 'vApp: Download'
    VAPP_COPY = 'vApp: Copy'
    VAPP_EDIT_VM_CPU = 'vApp: Edit VM CPU'
    VAPP_CHANGE_OWNER = 'vApp: Change Owner'
    VAPP_EDIT_VM_MEMORY = 'vApp: Edit VM Memory'
    VAPP_EDIT_VM_NETWORK = 'vApp: Edit VM Network'
    VAPP_USE_CONSOLE = 'vApp: Use Console'
    VAPP_DELETE = 'vApp: Delete'
    VAPP_EDIT_VM_PROPERTIES = 'vApp: Edit VM Properties'
    VAPP_SHARING = 'vApp: Sharing'
    VAPP_SNAPSHOT_OPERATIONS = 'vApp: Snapshot Operations'
    VAPP_VIEW_VM_METRICS = 'vApp: View VM metrics'

